/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.FString;
import gnu.kawa.util.SubString;
import gnu.kawa.util.UniformVector;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import gnu.text.Char;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public abstract class AbstractString
extends UniformVector
implements Printable {
    public static final int BEFORE_MARK_KIND = 0;
    public static final int EMACS_MARK_KIND = 1;
    public static final int AFTER_MARK_KIND = 2;

    public abstract char charAt(int var1);

    public FString copy() {
        int n = this.length();
        char[] cArray = new char[n];
        while (--n >= 0) {
            cArray[n] = this.charAt(n);
        }
        return new FString(cArray);
    }

    public int createPosition(int n, int n2) {
        return n;
    }

    public void fill(char c) {
        this.fill(c, 0, this.length());
    }

    public void fill(char c, int n, int n2) {
        while (--n2 >= 0) {
            this.setCharAt(n++, c);
        }
    }

    public final Object get(int n) {
        if (n < 0 || n >= this.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return Char.make(this.charAt(n));
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        int n4 = n;
        while (n4 < n2) {
            cArray[n3++] = this.charAt(n4);
            ++n4;
        }
    }

    public int getEndPosition() {
        return this.createPosition(this.length(), 2);
    }

    public int getPositionKind(int n) {
        return 0;
    }

    public int getPositionOffset(int n) {
        return n;
    }

    public int getStartPosition() {
        return this.createPosition(0, 0);
    }

    public String getTag() {
        return "ch";
    }

    public void insert(int n, char c, int n2, boolean bl) {
        this.insert(n, n2, bl);
        this.fill(c, n, n2);
    }

    protected void insert(int n, int n2, boolean bl) {
        throw new RuntimeException("insert not supported");
    }

    public void insert(int n, AbstractString abstractString, boolean bl) {
        int n2 = abstractString.length();
        this.insert(n, n2, bl);
        this.replace(n, abstractString);
    }

    public void insert(int n, String string, boolean bl) {
        int n2 = string.length();
        this.insert(n, n2, bl);
        this.replace(n, string);
    }

    public void insert(int n, char[] cArray, int n2, int n3, boolean bl) {
        this.insert(n, n3, bl);
        this.replace(n, cArray, n2, n3);
    }

    public void makeCapitalize() {
        char c = ' ';
        int n = this.length();
        int n2 = 0;
        while (n2 < n) {
            char c2 = this.charAt(n2);
            c2 = !Character.isLetterOrDigit(c) ? Character.toTitleCase(c2) : Character.toLowerCase(c2);
            this.setCharAt(n2, c2);
            c = c2;
            ++n2;
        }
    }

    public void makeLowerCase() {
        int n = this.length();
        while (--n >= 0) {
            this.setCharAt(n, Character.toLowerCase(this.charAt(n)));
        }
    }

    public void makeUpperCase() {
        int n = this.length();
        while (--n >= 0) {
            this.setCharAt(n, Character.toUpperCase(this.charAt(n)));
        }
    }

    public void print(PrintWriter printWriter) {
        int n = this.length();
        if (printWriter instanceof OutPort && ((OutPort)printWriter).printReadable) {
            printWriter.print('\"');
            int n2 = 0;
            while (n2 < n) {
                char c = this.charAt(n2);
                if (c == '\\' || c == '\"') {
                    printWriter.print('\\');
                }
                printWriter.print(c);
                ++n2;
            }
            printWriter.print('\"');
        } else {
            int n3 = 0;
            while (n3 < n) {
                printWriter.print(this.charAt(n3));
                ++n3;
            }
        }
    }

    public void releasePosition(int n) {
    }

    public void replace(int n, AbstractString abstractString) {
        int n2 = 0;
        int n3 = abstractString.length();
        while (--n3 >= 0) {
            this.setCharAt(n++, abstractString.charAt(n2++));
        }
    }

    public void replace(int n, String string) {
        int n2 = 0;
        int n3 = string.length();
        while (--n3 >= 0) {
            this.setCharAt(n++, string.charAt(n2++));
        }
    }

    public void replace(int n, char[] cArray, int n2, int n3) {
        while (--n3 >= 0) {
            this.setCharAt(n++, cArray[n2++]);
        }
    }

    public final void setAll(Object object2) {
        this.fill(((Char)object2).charValue());
    }

    public abstract void setCharAt(int var1, char var2);

    public void setElementAt(Object object2, int n) {
        this.setCharAt(n, ((Char)object2).charValue());
    }

    public AbstractString subString(int n, int n2) {
        return new SubString(this, n, n2);
    }

    public String substring(int n, int n2) {
        char[] cArray = new char[n2 - n];
        this.getChars(n, n2, cArray, 0);
        return new String(cArray);
    }

    public String toString() {
        return this.substring(0, this.length());
    }

    public void writeTo(int n, int n2, Writer writer) throws IOException {
        while (n2 == -1 || --n2 >= 0) {
            writer.write(this.charAt(n++));
        }
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(0, -1, writer);
    }
}

