/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.Procedure;
import gnu.mapping.WrongArguments;
import java.io.PrintWriter;
import java.util.Stack;

public class ApplyExp
extends Expression {
    Expression func;
    Expression[] args;
    boolean tailCall;
    LambdaExp context;
    public ApplyExp nextCall;

    public ApplyExp(Expression expression, Expression[] expressionArray) {
        this.func = expression;
        this.args = expressionArray;
    }

    public ApplyExp(Procedure procedure, Expression[] expressionArray) {
        this.func = new QuoteExp(procedure);
        this.args = expressionArray;
    }

    public static void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        boolean bl;
        boolean bl2;
        Method method;
        Type[] typeArray;
        Stack<Field> stack;
        Object object2;
        Expression[] expressionArray;
        Object object3;
        int n = applyExp.args.length;
        CodeAttr codeAttr = compilation.getCode();
        LambdaExp lambdaExp = null;
        String string = null;
        if (applyExp.func instanceof LambdaExp) {
            lambdaExp = (LambdaExp)applyExp.func;
            string = lambdaExp.getName();
            if (string == null) {
                string = "<lambda>";
            }
        } else if (applyExp.func instanceof ReferenceExp) {
            object3 = ((ReferenceExp)applyExp.func).binding;
            if (object3 != null) {
                expressionArray = ((Declaration)object3).getValue();
                string = ((Declaration)object3).getName();
                if (expressionArray != null && expressionArray instanceof LambdaExp) {
                    lambdaExp = (LambdaExp)expressionArray;
                }
                if (expressionArray != null && expressionArray instanceof QuoteExp) {
                    object2 = ((QuoteExp)expressionArray).getValue();
                    stack = null;
                    if (!(object2 instanceof Procedure)) {
                        typeArray = null;
                        stack = "calling " + string + " which is not a procedure";
                    } else {
                        typeArray = (Type[])object2;
                        stack = WrongArguments.checkArgCount((Procedure)typeArray, n);
                    }
                    if (stack != null) {
                        compilation.error('w', (String)((Object)stack));
                    } else {
                        PrimProcedure primProcedure = PrimProcedure.getMethodFor((Procedure)typeArray, (Declaration)object3, applyExp.args, compilation.getInterpreter());
                        if (primProcedure != null) {
                            if (!primProcedure.getStaticFlag()) {
                                ((Declaration)object3).base.load(compilation);
                            }
                            primProcedure.compile(null, applyExp.args, compilation, target);
                            return;
                        }
                    }
                }
            }
        } else if (applyExp.func instanceof QuoteExp && (object3 = ((QuoteExp)applyExp.func).getValue()) instanceof Inlineable && (expressionArray = PrimProcedure.getMethodFor((Procedure)object3, applyExp.args)) != null) {
            applyExp = new ApplyExp((Procedure)expressionArray, applyExp.args);
            expressionArray.compile(applyExp, compilation, target);
            return;
        }
        if (lambdaExp != null) {
            if (n < lambdaExp.min_args) {
                compilation.error('w', "too few args for " + string);
                lambdaExp = null;
            } else if (lambdaExp.max_args >= 0 && n > lambdaExp.max_args) {
                compilation.error('w', "too many args for " + string);
                lambdaExp = null;
            } else if (!lambdaExp.isHandlingTailCalls() && (method = lambdaExp.getMethod(n)) != null) {
                boolean bl3 = method.getStaticFlag();
                expressionArray = applyExp.getArgs();
                int n2 = 0;
                typeArray = method.getParameterTypes();
                stack = lambdaExp.outerLambda();
                if (!bl3 || lambdaExp.declareClosureEnv() != null) {
                    if (bl3) {
                        n2 = 1;
                    }
                    if (compilation.curLambda == lambdaExp) {
                        codeAttr.emitLoad(lambdaExp.closureEnv);
                    } else if (((LambdaExp)((Object)stack)).heapFrame != null || ((LambdaExp)((Object)stack)).closureEnv == null) {
                        ((LambdaExp)((Object)stack)).loadHeapFrame(compilation);
                    } else {
                        codeAttr.emitLoad(((LambdaExp)((Object)stack)).closureEnv);
                    }
                }
                boolean bl4 = lambdaExp.restArgType() != null;
                PrimProcedure.compileArgs(expressionArray, n2 > 0 ? Type.void_type : null, typeArray, bl4, string, lambdaExp, compilation);
                codeAttr.emitInvoke(method);
                target.compileFromStack(compilation, method.getReturnType());
                return;
            }
        }
        if (Compilation.usingCPStyle()) {
            Field field;
            object3 = new Label(codeAttr);
            expressionArray = compilation.fswitch;
            int n3 = expressionArray.getMaxValue() + 1;
            expressionArray.addCase(n3, (Label)object3, codeAttr);
            codeAttr.emitLoad(compilation.callStackContext);
            codeAttr.emitLoad(compilation.callStackContext);
            codeAttr.emitPushInt(n3);
            codeAttr.emitPutField(Compilation.pcCallStackField);
            codeAttr.emitInvokeVirtual(Compilation.applyCpsMethod);
            typeArray = codeAttr.saveStackTypeState(false);
            stack = new Stack<Field>();
            if (typeArray != null) {
                int n4 = typeArray.length;
                while (--n4 >= 0) {
                    field = compilation.allocLocalField(typeArray[n4], null);
                    codeAttr.emitPushThis();
                    codeAttr.emitSwap();
                    codeAttr.emitPutField(field);
                    stack.push(field);
                }
            }
            codeAttr.emitReturn();
            ((Label)object3).define(codeAttr);
            if (typeArray != null) {
                int n5 = typeArray.length;
                while (--n5 >= 0) {
                    field = (Field)stack.pop();
                    codeAttr.emitPushThis();
                    codeAttr.emitGetField(field);
                    compilation.freeLocalField(field);
                }
            }
            codeAttr.emitLoad(compilation.callStackContext);
            codeAttr.emitGetField(Compilation.valueCallStackField);
            target.compileFromStack(compilation, Type.pointer_type);
            return;
        }
        boolean bl5 = bl2 = applyExp.tailCall && lambdaExp != null && lambdaExp == compilation.curLambda;
        if (lambdaExp != null && lambdaExp.getInlineOnly() && !bl2 && lambdaExp.min_args == n) {
            int n6 = 0;
            while (n6 < n) {
                applyExp.args[n6].compile(compilation, Target.pushObject);
                ++n6;
            }
            object2 = compilation.curLambda;
            compilation.curLambda = lambdaExp;
            lambdaExp.allocChildClasses(compilation);
            lambdaExp.allocParameters(compilation);
            ApplyExp.popParams(codeAttr, lambdaExp, false);
            lambdaExp.enterFunction(compilation);
            lambdaExp.body.compileWithPosition(compilation, target);
            codeAttr.popScope();
            lambdaExp.compileChildMethods(compilation);
            compilation.curLambda = object2;
            return;
        }
        if (compilation.curLambda.isHandlingTailCalls() && applyExp.isTailCall() && !compilation.curLambda.getInlineOnly()) {
            codeAttr.emitLoad(compilation.callStackContext);
            codeAttr.emitDup(compilation.callStackContext.getType());
            applyExp.func.compile(compilation, new StackTarget(Compilation.typeProcedure));
            codeAttr.emitPutField(Compilation.procCallStackField);
            codeAttr.emitDup(compilation.callStackContext.getType());
            ApplyExp.compileToArray(applyExp.args, compilation);
            codeAttr.emitPutField(Compilation.argsCallStackField);
            codeAttr.emitReturn();
            return;
        }
        if (!bl2) {
            applyExp.func.compile(compilation, new StackTarget(Compilation.typeProcedure));
        }
        boolean bl6 = bl2 ? lambdaExp.min_args != lambdaExp.max_args : (bl = n > 4);
        if (!bl) {
            int n7 = 0;
            while (n7 < n) {
                applyExp.args[n7].compile(compilation, Target.pushObject);
                ++n7;
            }
            method = bl2 ? null : Compilation.applymethods[n];
        } else {
            ApplyExp.compileToArray(applyExp.args, compilation);
            method = Compilation.applyNmethod;
        }
        if (bl2) {
            ApplyExp.popParams(codeAttr, lambdaExp, bl);
            codeAttr.emitTailCall(false, lambdaExp.scope);
            return;
        }
        codeAttr.emitInvokeVirtual(method);
        target.compileFromStack(compilation, Type.pointer_type);
    }

    public void compile(Compilation compilation, Target target) {
        Object object2;
        if (this.func instanceof QuoteExp && (object2 = ((QuoteExp)this.func).getValue()) instanceof Inlineable) {
            ((Inlineable)object2).compile(this, compilation, target);
            return;
        }
        ApplyExp.compile(this, compilation, target);
    }

    public static void compileToArray(Expression[] expressionArray, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (expressionArray.length == 0) {
            codeAttr.emitGetStatic(Compilation.noArgsField);
            return;
        }
        LambdaExp lambdaExp = compilation.curLambda;
        if (expressionArray.length == lambdaExp.min_args && expressionArray.length == lambdaExp.max_args && lambdaExp.isHandlingTailCalls()) {
            codeAttr.emitLoad(compilation.callStackContext);
            codeAttr.emitGetField(Compilation.argsCallStackField);
        } else {
            codeAttr.emitPushInt(expressionArray.length);
            codeAttr.emitNewArray(Type.pointer_type);
        }
        int n = 0;
        while (n < expressionArray.length) {
            Expression expression = expressionArray[n];
            if (Compilation.usingCPStyle && !(expression instanceof QuoteExp) && !(expression instanceof ReferenceExp)) {
                expression.compile(compilation, Target.pushObject);
                codeAttr.emitSwap();
                codeAttr.emitDup(1, 1);
                codeAttr.emitSwap();
                codeAttr.emitPushInt(n);
                codeAttr.emitSwap();
            } else {
                codeAttr.emitDup(Compilation.objArrayType);
                codeAttr.emitPushInt(n);
                expression.compile(compilation, Target.pushObject);
            }
            codeAttr.emitArrayStore(Type.pointer_type);
            ++n;
        }
    }

    public Object eval(Environment environment) {
        Procedure procedure = (Procedure)this.func.eval(environment);
        int n = this.args.length;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.args[n2].eval(environment);
            ++n2;
        }
        return procedure.applyN(objectArray);
    }

    public final Expression[] getArgs() {
        return this.args;
    }

    public final Expression getFunction() {
        return this.func;
    }

    public final Type getType() {
        Object object2;
        if (this.func instanceof QuoteExp && (object2 = ((QuoteExp)this.func).getValue()) instanceof Inlineable) {
            return ((Inlineable)object2).getReturnType(this.args);
        }
        return super.getType();
    }

    public final boolean isTailCall() {
        return this.tailCall;
    }

    private static void popParams(CodeAttr codeAttr, Variable variable, int n) {
        if (n > 0) {
            ApplyExp.popParams(codeAttr, variable.nextVar(), n - 1);
            codeAttr.emitStore(variable);
        }
    }

    private static void popParams(CodeAttr codeAttr, LambdaExp lambdaExp, boolean bl) {
        Variable variable = lambdaExp.scope.firstVar();
        if (variable != null && variable.getName() == "this") {
            variable = variable.nextVar();
        }
        if (variable != null && variable.getName() == "argsArray") {
            if (bl) {
                ApplyExp.popParams(codeAttr, variable, 1);
                return;
            }
            variable = variable.nextVar();
        }
        ApplyExp.popParams(codeAttr, variable, lambdaExp.min_args);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("(#%apply ");
        if (this.tailCall) {
            printWriter.print("[tailcall] ");
        }
        this.func.print(printWriter);
        int n = 0;
        while (n < this.args.length) {
            printWriter.print(" ");
            this.args[n].print(printWriter);
            ++n;
        }
        printWriter.print(")");
    }

    public final void setTailCall(boolean bl) {
        this.tailCall = bl;
    }

    Object walk(ExpWalker expWalker) {
        return expWalker.walkApplyExp(this);
    }
}

