/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEventMulticaster;
import java.awt.ClassAnalyzer;
import java.awt.ClassProperties;
import java.awt.Container;
import java.awt.Defaults;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public abstract class TextComponent
extends Container
implements ActionListener {
    private static final long serialVersionUID = -2214773872412987419L;
    protected transient TextListener textListener;
    boolean isEditable = true;

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Copy".equals(string)) {
            this.copyToClipboard();
            this.setCaretPosition(this.getCaretPosition());
        } else if ("Paste".equals(string)) {
            this.pasteFromClipboard();
        } else if ("Select All".equals(string)) {
            this.selectAll();
        } else if ("Cut".equals(string)) {
            this.copyToClipboard();
            this.replaceSelectionWith(null);
        }
    }

    public void addTextListener(TextListener textListener) {
        this.eventMask |= 0x400;
    }

    void copyToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String string = this.getSelectedText();
        if (string != null && string.length() > 0) {
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    public abstract int getCaretPosition();

    ClassProperties getClassProperties() {
        return ClassAnalyzer.analyzeAll(this.getClass(), true);
    }

    public abstract String getSelectedText();

    public abstract int getSelectionEnd();

    public abstract int getSelectionStart();

    public abstract String getText();

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean isFocusTraversable() {
        return (this.flags & 0x405) == 1029 && (this.eventMask & Integer.MIN_VALUE) == 0 && this.isEditable;
    }

    boolean isPrintableTyped(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        char c = keyEvent.getKeyChar();
        if (n != 0 && n != 1) {
            return false;
        }
        switch (c) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\u001b': 
            case '\u007f': {
                return false;
            }
        }
        return true;
    }

    protected String paramString() {
        return super.paramString();
    }

    void pasteFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.replaceSelectionWith(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void process(TextEvent textEvent) {
        if (this.textListener != null || (this.eventMask & 0x400) != 0) {
            this.processEvent(textEvent);
        }
    }

    protected void processTextEvent(TextEvent textEvent) {
        if (this.textListener != null) {
            this.textListener.textValueChanged(textEvent);
        }
    }

    public void removeTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    void replaceSelectionWith(String string) {
    }

    public abstract void select(int var1, int var2);

    public abstract void selectAll();

    public abstract void setCaretPosition(int var1);

    public void setEditable(boolean bl) {
        if (this.isEditable != bl) {
            this.isEditable = bl;
            this.setForeground(this.isEditable ? Defaults.TextAreaTxtClr : Defaults.TextAreaRoTxtClr);
            this.setBackground(this.isEditable ? Defaults.TextAreaBgClr : Defaults.TextAreaRoBgClr);
        }
    }

    public abstract void setSelectionEnd(int var1);

    public abstract void setSelectionStart(int var1);

    public abstract void setText(String var1);
}

