/*
 * Decompiled with CFR 0.152.
 */
package kaffe.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.Hashtable;
import kaffe.rmi.server.ProtocolConstants;
import kaffe.rmi.server.RMIObjectInputStream;
import kaffe.rmi.server.TripleKey;
import kaffe.rmi.server.UnicastConnection;

public class UnicastConnectionManager
implements Runnable,
ProtocolConstants {
    private static String localhost;
    private static Hashtable servers;
    private Thread serverThread;
    private ServerSocket ssock;
    String serverName;
    int serverPort;
    private RMIServerSocketFactory serverFactory;
    private RMIClientSocketFactory clientFactory;

    public static synchronized UnicastConnectionManager getInstance(String string, int n, RMIClientSocketFactory rMIClientSocketFactory) {
        TripleKey tripleKey;
        UnicastConnectionManager unicastConnectionManager;
        if (rMIClientSocketFactory == null) {
            rMIClientSocketFactory = RMISocketFactory.getSocketFactory();
        }
        if ((unicastConnectionManager = (UnicastConnectionManager)servers.get(tripleKey = new TripleKey(string, n, rMIClientSocketFactory))) == null) {
            unicastConnectionManager = new UnicastConnectionManager(string, n, rMIClientSocketFactory);
            servers.put(tripleKey, unicastConnectionManager);
        }
        return unicastConnectionManager;
    }

    public static synchronized UnicastConnectionManager getInstance(int n, RMIServerSocketFactory rMIServerSocketFactory) {
        TripleKey tripleKey;
        UnicastConnectionManager unicastConnectionManager;
        if (rMIServerSocketFactory == null) {
            rMIServerSocketFactory = RMISocketFactory.getSocketFactory();
        }
        if ((unicastConnectionManager = (UnicastConnectionManager)servers.get(tripleKey = new TripleKey(localhost, n, rMIServerSocketFactory))) == null) {
            unicastConnectionManager = new UnicastConnectionManager(n, rMIServerSocketFactory);
            tripleKey.port = unicastConnectionManager.serverPort;
            servers.put(tripleKey, unicastConnectionManager);
        }
        return unicastConnectionManager;
    }

    public UnicastConnection getConnection() throws IOException {
        if (this.ssock == null) {
            return this.getClientConnection();
        }
        return this.getServerConnection();
    }

    private UnicastConnection getServerConnection() throws IOException {
        Socket socket = this.ssock.accept();
        UnicastConnection unicastConnection = new UnicastConnection(this, socket);
        unicastConnection.acceptConnection();
        return unicastConnection;
    }

    private UnicastConnection getClientConnection() throws IOException {
        Socket socket = this.clientFactory.createSocket(this.serverName, this.serverPort);
        UnicastConnection unicastConnection = new UnicastConnection(this, socket);
        unicastConnection.makeConnection(75);
        return unicastConnection;
    }

    public void discardConnection(UnicastConnection unicastConnection) {
        unicastConnection.disconnect();
    }

    public void startServer() {
        UnicastConnectionManager unicastConnectionManager = this;
        synchronized (unicastConnectionManager) {
            block6: {
                block5: {
                    if (this.ssock == null) break block5;
                    if (this.serverThread == null) break block6;
                }
                Object var2_2 = null;
                return;
            }
            this.serverThread = new Thread(this);
        }
        this.serverThread.start();
    }

    public void run() {
        while (true) {
            try {
                UnicastConnection unicastConnection = this.getServerConnection();
                new Thread(unicastConnection).start();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    void write(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.serverName);
        objectOutput.writeInt(this.serverPort);
    }

    static UnicastConnectionManager read(ObjectInput objectInput) throws IOException {
        String string = objectInput.readUTF();
        int n = objectInput.readInt();
        RMIClientSocketFactory rMIClientSocketFactory = ((RMIObjectInputStream)objectInput).manager.clientFactory;
        return UnicastConnectionManager.getInstance(string, n, rMIClientSocketFactory);
    }

    private UnicastConnectionManager(String string, int n, RMIClientSocketFactory rMIClientSocketFactory) {
        this.ssock = null;
        this.serverName = string;
        this.serverPort = n;
        this.serverFactory = null;
        this.clientFactory = rMIClientSocketFactory;
    }

    private UnicastConnectionManager(int n, RMIServerSocketFactory rMIServerSocketFactory) {
        try {
            this.ssock = rMIServerSocketFactory.createServerSocket(n);
            this.serverPort = this.ssock.getLocalPort();
        }
        catch (IOException iOException) {
            try {
                this.ssock = rMIServerSocketFactory.createServerSocket(0);
                this.serverPort = this.ssock.getLocalPort();
            }
            catch (IOException iOException2) {
                this.ssock = null;
                this.serverPort = 0;
            }
        }
        this.serverName = localhost;
        this.serverFactory = rMIServerSocketFactory;
        this.clientFactory = null;
    }

    static {
        servers = new Hashtable();
        try {
            localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            localhost = "localhost";
        }
    }
}

