/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Scrollbar;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;

public class TextEdit
extends Frame
implements NoteListener,
WindowListener {
    private final int NOACTION = 0;
    private final int NEWFILE = 1;
    private final int OPENFILE = 2;
    private final int QUITAPP = 3;
    public File file = new File("Untitled");
    private String openPrompt = new String("Open text file");
    private String closePrompt = new String("Save file as");
    private boolean neverNamed = true;
    private boolean menuBusy = false;
    private Scrollbar horiz;
    private Scrollbar vert;
    private TextCanvas textCanvas;
    private TextMenu textMenu;
    private String fontString = new String("Courier");
    private int fontSize = 12;
    private int tabSize = 4;
    private Vector beans;

    public TextEdit() {
        this.setTitle();
        FilterMan filterMan = new FilterMan();
        this.beans = filterMan.loadDir("jars");
        this.vert = new Scrollbar(1);
        this.add("East", this.vert);
        this.horiz = new Scrollbar(0);
        this.add("South", this.horiz);
        this.textCanvas = new TextCanvas(this, this.horiz, this.vert);
        this.add("Center", this.textCanvas);
        this.textCanvas.setFont(this.fontString, this.fontSize);
        this.addKeyListener(this.textCanvas);
        this.textMenu = new TextMenu(this, this.beans);
        this.setMenuBar(this.textMenu);
        this.addWindowListener(this);
    }

    public TextCanvas getCanvas() {
        return this.textCanvas;
    }

    private void setTitle() {
        super.setTitle("TextEdit - " + this.file.getName());
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        block3: {
            block2: {
                if (!this.textCanvas.isDirty()) break block2;
                this.notify("The current file has not been saved. ", 3);
                if (!false) break block3;
            }
            System.exit(0);
        }
    }

    public void setFont(String string) {
        this.fontString = string;
        this.textCanvas.setFont(this.fontString, this.fontSize);
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.textCanvas.setFont(this.fontString, this.fontSize);
    }

    public void setTabSize(int n) {
        this.tabSize = n;
        this.textCanvas.setTab(this.tabSize);
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void cmdFileNew() {
        block3: {
            block2: {
                if (!this.textCanvas.isDirty()) break block2;
                this.notify("The current file has not been saved. ", 1);
                if (!false) break block3;
            }
            this.newFile();
        }
    }

    public void cmdFileOpen() {
        block5: {
            block4: {
                if (!this.textCanvas.isDirty()) break block4;
                this.notify("The current file has not been saved. ", 2);
                if (!false) break block5;
            }
            if (this.getFile(0)) {
                this.openTheFile();
            }
        }
    }

    public void cmdFileSave() {
        this.saveFile(false);
    }

    public void cmdFileSaveAs() {
        this.saveFile(true);
    }

    public void cmdPrint() {
        this.textCanvas.print(this.file.getName());
    }

    public void cmdFileQuit() {
        block3: {
            block2: {
                if (!this.textCanvas.isDirty()) break block2;
                this.notify("The current file has not been saved. ", 3);
                if (!false) break block3;
            }
            System.exit(0);
        }
    }

    private boolean isItSafe(int n) {
        if (this.textCanvas.isDirty()) {
            this.notify("The current file has not been saved. ", n);
            return false;
        }
        return true;
    }

    public void noteListen(int n) {
        switch (n) {
            case 1: {
                this.newFile();
                return;
            }
            case 2: {
                if (!this.getFile(0)) break;
                this.openTheFile();
                return;
            }
            case 3: {
                System.exit(0);
                return;
            }
        }
    }

    private void newFile() {
        this.neverNamed = true;
        this.file = new File("Untitled");
        this.setTitle();
        this.textCanvas.clear();
        this.textCanvas.validate();
    }

    private void openFile() {
        if (this.getFile(0)) {
            this.openTheFile();
        }
    }

    public void openTheFile() {
        this.textCanvas.read(this.file);
        this.textCanvas.validate();
        this.neverNamed = false;
        this.setTitle();
    }

    private void saveFile(boolean bl) {
        boolean bl2;
        if (this.neverNamed || bl) {
            bl2 = this.getFile(1);
            this.neverNamed = false;
        } else {
            bl2 = true;
        }
        if (bl2) {
            this.textCanvas.write(this.file);
            this.neverNamed = false;
            this.setTitle();
        }
    }

    private boolean getFile(int n) {
        String string = n == 0 ? this.openPrompt : this.closePrompt;
        FileDialog fileDialog = new FileDialog((Frame)this, string, n);
        if (n == 0) {
            fileDialog.setFile("*");
        } else {
            fileDialog.setFile(this.file.getName());
        }
        fileDialog.setDirectory(".");
        ((Component)fileDialog).setVisible(true);
        String string2 = fileDialog.getFile();
        String string3 = String.valueOf(fileDialog.getDirectory()) + string2;
        fileDialog.dispose();
        if (string2 != null) {
            this.file = new File(string3);
            return true;
        }
        return false;
    }

    private void notify(String string, int n) {
        Note note = new Note((Frame)this, string, n);
        ((Component)note).setVisible(true);
    }

    public static void main(String[] stringArray) {
        TextEdit textEdit = new TextEdit();
        ((Component)textEdit).setSize(500, 400);
        ((Component)textEdit).setVisible(true);
        if (stringArray.length > 0) {
            textEdit.file = new File(stringArray[0]);
            if (textEdit.file.isFile()) {
                textEdit.openTheFile();
                return;
            }
            textEdit.notify("File not found: " + stringArray[0], 0);
        }
    }
}

