/*
 * @(#)HelpWriter.java	1.8 98/08/18
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

// package com.sun.tools.doclets.standard;

import com.sun.tools.doclets.*;
import java.io.*;
import java.lang.*;
import java.util.*;

/**
 * Generate the Help File for the generated API documentation. The help file
 * contents are helpful for browsing the generated documentation.
 *
 * @author Atul M Dambalkar
 */
public class HelpWriter extends HtmlStandardWriter {

    /**
     * Constructor to construct HelpWriter object. 
     * @param filename File to be generated.
     */
    public HelpWriter(String filename) throws IOException {
        super(filename);
    }

    /**
     * Construct the HelpWriter object and then use it to generate the help 
     * file. The name of the generated file is "help-doc.html". The help file
     * will get generated if and only if "-helpfile" and "-nohelp" is not used
     * on the command line.
     */
    public static void generate() throws DocletAbortException {
        HelpWriter helpgen;
        String filename = "";
        try {
            if (Standard.configuration().helpfile.length() == 0 &&
                                          !Standard.configuration().nohelp) {
                filename = "help-doc.html";
                helpgen = new HelpWriter(filename);
                helpgen.generateHelpFile();
                helpgen.close();
            }
        } catch (IOException exc) {
            Standard.configuration().standardmessage.error(
                "doclet.exception_encountered",
                exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    /**
     * Generate the help file contents.
     */
    protected void generateHelpFile() {
        printHeader(getText("doclet.Window_Help_title",
                            Standard.configuration().windowtitle));
        navLinks(true);  hr();

        printHelpFileContents();

        navLinks(false);
        printBottom();
        printBodyHtmlEnd();
    }

    /**
     * Print the help file contents from the resource file. While
     * generating the help file contents it also keeps track of user
     * options. If "-notree" is used, then the "overview-tree.html"
     * will not get generated and hence help information also will not
     * get generated.  */
    protected void printHelpFileContents() {
        //center(); 
        //h1(); printText("doclet.Help_line_1"); h1End(); 
        //centerEnd();
        center(); 
        h1(); print("How the Swarm API Document is Organized"); h1End(); 
        centerEnd();

        printText("doclet.Help_line_2");
        
        // additional Swarm doclet features
        h3(); print("Additional Swarm Conventions"); h3End();
        blockquote(); p();
        print("This API documentation conforms to the API that would be"
              + " generated by the standard Sun javadoc run"
              + " in most respects, and are detailed in the sections following"
              + " this one.  This section sets out the exceptions.");
        blockquoteEnd();
        blockquote(); p();
        print ("The Swarm class hierarchy (as opposed to the interface hierarchy) is virtually flat.  All instantiatable Swarm objects are subclasses of java.lang.Object.  This means that all methods that a class provides are made available in that class, which can result in some very long lists of methods which generate much redundant documentation.  So in the case of instantiatable Swarm classes, the method detail is forgone, and replaced with links to the method documentation to the interface  which that class implements. For example: ");
        ul(); 
        li(); print ("the swarm.collections.ListImpl class, has a box with the heading <strong>Methods implemented by this class for interface swarm.collections.List</strong>, which contains links to the methods <code>addFirst, addLast, listBegin, removeFirst, removeLast</code> which are <em>implemented</em> in the ListImpl class but <em>documented</em> in the List interface.");
        ulEnd();
        blockquoteEnd(); p();
        blockquote(); p();
        print("All Java classes that are required for the correct operation of Swarm, but have no corresponding user-creatable Objective C classes are suppressed in the API output.  This means that there may be some `Impl' classes that will appear in the swarm.jar file, but not in this document.");
        ulEnd();
        blockquoteEnd();

        if (Standard.configuration().createoverview) {
            h3(); printText("doclet.Overview"); h3End();
            blockquote(); p(); 
            printText("doclet.Help_line_3",
                       getHyperLink("overview-summary.html", 
                                     getText("doclet.Overview"))); 
            blockquoteEnd();
        }
        h3(); printText("doclet.Package"); h3End();
        blockquote(); p(); printText("doclet.Help_line_4"); 
        ul(); 
        li(); printText("doclet.Interfaces_Italic");
        li(); printText("doclet.Classes");
        li(); printText("doclet.Exceptions");
        li(); printText("doclet.Errors");
        ulEnd();
        blockquoteEnd();
        h3(); printText("doclet.Help_line_5"); h3End();
        blockquote(); p(); printText("doclet.Help_line_6");
        ul();
        li(); printText("doclet.Help_line_7");
        li(); printText("doclet.Help_line_8");
        li(); printText("doclet.Help_line_9");
        li(); printText("doclet.Help_line_10");
        li(); printText("doclet.Help_line_11");
        li(); printText("doclet.Help_line_12");
        p();
        li(); printText("doclet.Inner_Class_Summary");
        li(); printText("doclet.Field_Summary");
        li(); printText("doclet.Constructor_Summary");
        li(); printText("doclet.Method_Summary");
        p();
        li(); printText("doclet.Field_Detail");
        li(); printText("doclet.Constructor_Detail");
        li(); printText("doclet.Method_Detail");
        ulEnd(); 
        printText("doclet.Help_line_13");
        blockquoteEnd();
        if (Standard.configuration().classuse) {
            h3(); printText("doclet.Help_line_14"); h3End();
            blockquote(); 
            printText("doclet.Help_line_15");
            blockquoteEnd();
        }
        if (Standard.configuration().createtree) {
            h3(); printText("doclet.Help_line_16"); h3End();
            blockquote(); 
            printText("doclet.Help_line_17_with_tree_link",
                 getHyperLink("overview-tree.html", 
                               getText("doclet.Class_Hierarchy"))); 
            ul(); 
            li(); printText("doclet.Help_line_18");
            li(); printText("doclet.Help_line_19");
            ulEnd(); 
            blockquoteEnd();
        }
        if (!(Standard.configuration().nodeprecatedlist ||
                  Standard.configuration().nodeprecated)) {
            h3(); printText("doclet.Deprecated_API"); h3End();
            blockquote();
            printText("doclet.Help_line_20_with_deprecated_api_link",
                          getHyperLink("deprecated-list.html", 
                                        getText("doclet.Deprecated_API"))); 
            blockquoteEnd();
        }
        if (Standard.configuration().createindex) {
            String indexlink;
            if (Standard.configuration().splitindex) {
                indexlink = getHyperLink("index-files/index-1.html", 
                                          getText("doclet.Index"));
            } else {
                indexlink = getHyperLink("index-all.html", 
                                          getText("doclet.Index"));
            }
            h3(); printText("doclet.Help_line_21"); h3End();
            blockquote();
            printText("doclet.Help_line_22", indexlink);
            blockquoteEnd();
        }
        h3(); printText("doclet.Help_line_23"); h3End(); 
        printText("doclet.Help_line_24");
        h3(); printText("doclet.Help_line_25"); h3End(); 
        printText("doclet.Help_line_26"); p();
        h3(); printText("doclet.Serialized_Form"); h3End();
        printText("doclet.Help_line_27"); p(); 
        font("-1"); em(); 
        print("This help file applies to API documentation generated using "
              + "the Swarm doclet, which is a slightly modified form of the "
              + "standard Sun doclet.");
        //printText("doclet.Help_line_28"); 
        emEnd(); fontEnd(); br();
        hr();
    }

    /**
     * Highlight the word "Help" in the navigation bar as this is the help file.
     */
    protected void navLinkHelp() {
        navCellRevStart();
        fontStyle("NavBarFont1Rev");
        boldText("doclet.Help");
        fontEnd();
        navCellEnd();
    }
}



