/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexBuilder {
    private Map indexmap = new HashMap();
    private boolean noDeprecated;
    private boolean classesOnly;
    protected final Object[] elements;

    public IndexBuilder(RootDoc rootDoc, boolean bl) {
        this(rootDoc, bl, false);
    }

    public IndexBuilder(RootDoc rootDoc, boolean bl, boolean bl2) {
        if (bl2) {
            Configuration.message.notice("doclet.Building_Index_For_All_Classes");
        } else {
            Configuration.message.notice("doclet.Building_Index");
        }
        this.noDeprecated = bl;
        this.classesOnly = bl2;
        this.buildIndexMap(rootDoc);
        Set set = this.indexmap.keySet();
        this.elements = set.toArray();
        Arrays.sort(this.elements);
    }

    protected void adjustIndexMap(Doc[] docArray) {
        int n = 0;
        while (n < docArray.length) {
            if (this.shouldAddToIndexMap(docArray[n])) {
                String string = docArray[n].name();
                char c = string.length() == 0 ? (char)'*' : (char)Character.toUpperCase(string.charAt(0));
                Character c2 = new Character(c);
                ArrayList<Doc> arrayList = (ArrayList<Doc>)this.indexmap.get(c2);
                if (arrayList == null) {
                    arrayList = new ArrayList<Doc>();
                    this.indexmap.put(c2, arrayList);
                }
                arrayList.add(docArray[n]);
            }
            ++n;
        }
    }

    protected void buildIndexMap(RootDoc rootDoc) {
        PackageDoc[] packageDocArray = rootDoc.specifiedPackages();
        ClassDoc[] classDocArray = rootDoc.classes();
        ArrayList arrayList = new ArrayList();
        if (!this.classesOnly) {
            this.adjustIndexMap((Doc[])packageDocArray);
        }
        this.adjustIndexMap((Doc[])classDocArray);
        if (!this.classesOnly) {
            int n = 0;
            while (n < classDocArray.length) {
                if (this.shouldAddToIndexMap((Doc)classDocArray[n])) {
                    this.putMembersInIndexMap(classDocArray[n]);
                }
                ++n;
            }
        }
        this.sortIndexMap();
    }

    public Object[] elements() {
        return this.elements;
    }

    public Map getIndexMap() {
        return this.indexmap;
    }

    public List getMemberList(Character c) {
        return (List)this.indexmap.get(c);
    }

    protected void putMembersInIndexMap(ClassDoc classDoc) {
        this.adjustIndexMap((Doc[])classDoc.fields());
        this.adjustIndexMap((Doc[])classDoc.methods());
        this.adjustIndexMap((Doc[])classDoc.constructors());
    }

    protected boolean shouldAddToIndexMap(Doc doc) {
        boolean bl = !(this.noDeprecated && doc.tags("deprecated").length > 0 || Standard.configuration().hide && doc.tags("hide").length > 0);
        return bl;
    }

    protected void sortIndexMap() {
        Iterator iterator = this.indexmap.values().iterator();
        while (iterator.hasNext()) {
            Collections.sort((List)iterator.next());
        }
    }
}

