/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.DocletAbortException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;

public class ClassUseMapper {
    private final ClassTree classtree;
    public Map classToPackage = new HashMap();
    public Map classToClass = new HashMap();
    public Map classToSubclass = new HashMap();
    public Map classToSubinterface = new HashMap();
    public Map classToImplementingClass = new HashMap();
    public Map classToField = new HashMap();
    public Map classToMethodReturn = new HashMap();
    public Map classToMethodArgs = new HashMap();
    public Map classToMethodThrows = new HashMap();
    public Map classToConstructorArgs = new HashMap();
    public Map classToConstructorThrows = new HashMap();

    private ClassUseMapper(RootDoc rootDoc, ClassTree classTree) {
        this.classtree = classTree;
        Iterator iterator = classTree.baseclasses().iterator();
        while (iterator.hasNext()) {
            this.subclasses((ClassDoc)iterator.next());
        }
        Iterator iterator2 = classTree.baseinterfaces().iterator();
        while (iterator2.hasNext()) {
            this.implementingClasses((ClassDoc)iterator2.next());
        }
        ClassDoc[] classDocArray = rootDoc.classes();
        int n = 0;
        while (n < classDocArray.length) {
            FieldDoc fieldDoc;
            ClassDoc classDoc = classDocArray[n];
            FieldDoc[] fieldDocArray = classDoc.fields();
            int n2 = 0;
            while (n2 < fieldDocArray.length) {
                fieldDoc = fieldDocArray[n2];
                ClassDoc classDoc2 = fieldDoc.type().asClassDoc();
                if (classDoc2 != null) {
                    this.add(this.classToField, classDoc2, (ProgramElementDoc)fieldDoc);
                }
                ++n2;
            }
            fieldDoc = classDoc.constructors();
            int n3 = 0;
            while (n3 < ((FieldDoc)fieldDoc).length) {
                this.mapExecutable((ExecutableMemberDoc)fieldDoc[n3]);
                ++n3;
            }
            MethodDoc[] methodDocArray = classDoc.methods();
            int n4 = 0;
            while (n4 < methodDocArray.length) {
                MethodDoc methodDoc = methodDocArray[n4];
                this.mapExecutable((ExecutableMemberDoc)methodDoc);
                ClassDoc classDoc3 = methodDoc.returnType().asClassDoc();
                if (classDoc3 != null) {
                    this.add(this.classToMethodReturn, classDoc3, (ProgramElementDoc)methodDoc);
                }
                ++n4;
            }
            ++n;
        }
    }

    private void add(Map map, ClassDoc classDoc, ProgramElementDoc programElementDoc) {
        this.refList(map, classDoc).add(programElementDoc);
        this.packageSet(classDoc).add(programElementDoc.containingPackage());
        this.classSet(classDoc).add(programElementDoc instanceof MemberDoc ? ((MemberDoc)programElementDoc).containingClass() : programElementDoc);
    }

    private void addAll(Map map, ClassDoc classDoc, Collection collection) {
        if (collection == null) {
            return;
        }
        this.refList(map, classDoc).addAll(collection);
        Set set = this.packageSet(classDoc);
        Set set2 = this.classSet(classDoc);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ProgramElementDoc programElementDoc = (ProgramElementDoc)iterator.next();
            set.add(programElementDoc.containingPackage());
            set2.add(programElementDoc instanceof MemberDoc ? ((MemberDoc)programElementDoc).containingClass() : programElementDoc);
        }
    }

    private Set classSet(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToClass.get(classDoc);
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.classToClass.put(classDoc, treeSet);
        }
        return treeSet;
    }

    public static void generate(RootDoc rootDoc, ClassTree classTree) throws DocletAbortException {
        ClassUseMapper classUseMapper = new ClassUseMapper(rootDoc, classTree);
        ClassDoc[] classDocArray = rootDoc.classes();
        int n = 0;
        while (n < classDocArray.length) {
            ClassUseWriter.generate(classUseMapper, classDocArray[n]);
            ++n;
        }
        PackageDoc[] packageDocArray = Standard.configuration().packages;
        int n2 = 0;
        while (n2 < packageDocArray.length) {
            PackageUseWriter.generate(classUseMapper, packageDocArray[n2]);
            ++n2;
        }
    }

    private Collection implementingClasses(ClassDoc classDoc) {
        SequencedCollection sequencedCollection = (List)this.classToImplementingClass.get(classDoc);
        if (sequencedCollection == null) {
            Iterator iterator;
            sequencedCollection = new TreeSet();
            List list = this.classtree.implementingclasses(classDoc);
            if (list != null) {
                sequencedCollection.addAll(list);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    sequencedCollection.addAll(this.subclasses((ClassDoc)iterator.next()));
                }
            }
            iterator = this.subinterfaces(classDoc).iterator();
            while (iterator.hasNext()) {
                sequencedCollection.addAll(this.implementingClasses((ClassDoc)iterator.next()));
            }
            this.addAll(this.classToImplementingClass, classDoc, sequencedCollection);
        }
        return sequencedCollection;
    }

    private void mapExecutable(ExecutableMemberDoc executableMemberDoc) {
        ClassDoc classDoc;
        Parameter[] parameterArray = executableMemberDoc.parameters();
        boolean bl = executableMemberDoc.isConstructor();
        ArrayList<ClassDoc> arrayList = new ArrayList<ClassDoc>();
        int n = 0;
        while (n < parameterArray.length) {
            classDoc = parameterArray[n].type().asClassDoc();
            if (classDoc != null && !arrayList.contains(classDoc)) {
                this.add(bl ? this.classToConstructorArgs : this.classToMethodArgs, classDoc, (ProgramElementDoc)executableMemberDoc);
                arrayList.add(classDoc);
            }
            ++n;
        }
        classDoc = executableMemberDoc.thrownExceptions();
        int n2 = 0;
        while (n2 < ((ClassDoc)classDoc).length) {
            this.add(bl ? this.classToConstructorThrows : this.classToMethodThrows, classDoc[n2], (ProgramElementDoc)executableMemberDoc);
            ++n2;
        }
    }

    private Set packageSet(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToPackage.get(classDoc);
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.classToPackage.put(classDoc, treeSet);
        }
        return treeSet;
    }

    private List refList(Map map, ClassDoc classDoc) {
        ArrayList arrayList = (ArrayList)map.get(classDoc);
        if (arrayList == null) {
            arrayList = new ArrayList();
            map.put(classDoc, arrayList);
        }
        return arrayList;
    }

    private Collection subclasses(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToSubclass.get(classDoc);
        if (treeSet == null) {
            treeSet = new TreeSet();
            List list = this.classtree.subclasses(classDoc);
            if (list != null) {
                treeSet.addAll(list);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    treeSet.addAll(this.subclasses((ClassDoc)iterator.next()));
                }
            }
            this.addAll(this.classToSubclass, classDoc, treeSet);
        }
        return treeSet;
    }

    private Collection subinterfaces(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToSubinterface.get(classDoc);
        if (treeSet == null) {
            treeSet = new TreeSet();
            List list = this.classtree.subinterfaces(classDoc);
            if (list != null) {
                treeSet.addAll(list);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    treeSet.addAll(this.subinterfaces((ClassDoc)iterator.next()));
                }
            }
            this.addAll(this.classToSubinterface, classDoc, treeSet);
        }
        return treeSet;
    }
}

