// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.    

//S: ̥ߥ졼ġ롣

//D: ߤˤ鷺ʴϢġΥ쥯󡣥饹ؤϼ¼Ū˥եåȤǤ

#import <objectbase.h>

@protocol UName <SwarmObject>
//S: ˡ̾(㤨"critter1""critter2"ʤ)륯饹

//D: Υ饹ϡߥ졼Υ֥Ȥ˥ˡ̾(agent0, agent1, agent2...)Τ˻Ѥޤ̤(const char *)String饹Υ֥ȤȤ󶡤baseNameǽUNameΥ󥹥󥹤뤳ȤˤʤǤ礦ޤƱbaseNameȤäƥ֥Ȥ̿̾Ƽ¹ԤȤϡ̿̾˻Ѥ륫󥿤ꥻåȤǤޤ

//D: ա(const char *)ˤȡString饹Υ󥹥󥹤ˤΤɤξǤ⡢ŪˤϳǼ줺˥ꥸʥ뤬ԡޤäơꥸʥ(const char *)String󥹥󥹤βϡɬפ˱ƥ桼¦ǹԤɬפޤ

CREATING
//M: create:setBaseNameObject:᥽åɤUName饹Υ󥹥󥹤Ϳ줿const char *١̾˥åȤޤ󥿤ϼưŪ˥ꥻåȤޤ
+ create: aZone setBaseName: (const char *)aString;

//M: create:setBaseNameObject:᥽åɤUName饹Υ󥹥󥹤Ϳ줿String饹Υ֥Ȥ١̾˥åȤޤ󥿤ϼưŪ˥ꥻåȤޤ
+ create: aZone setBaseNameObject: aStringObject;

//M: setBaseName:᥽åɤϡͿ줿const char *١̾˥åȤޤ
- setBaseName: (const char *)aString;

//M: setBaseNameObject:᥽åɤϡͿ줿String饹Υ֥Ȥ١̾˥åȤޤ
- setBaseNameObject: aStringObject;

USING
//M: getNewName᥽åɤϡ̾ʸȤޤ
- (const char *)getNewName;

//M: getNewNameObjectϡ̾String֥ȤȤޤ
- getNewNameObject;

//M: ˡ̾Υեå˻Ѥ륫󥿤ꥻåȤޤ
- resetCounter;
@end

@protocol InFile <SwarmObject>
//S: եϤ¹Ԥ륯饹

//D: SwarmǤϥեI/Oñ㲽륯饹ǤŪˤϺ٤ʥեΥץ/Υ롼CΥեI/OץƤӽФ֤򸺤餷ޤ

CREATING
//M: InFilecreate᥽åɤǤtheNameˤϥץ󤹤ե̾ꤷޤ
+ create: aZone withName: (const char *)theName;

USING
//M: getWord:᥽åɤϡڡ֡ԤΤʤʸ֤ޤ
- (int)getWord: (char *)aWord;

//M: getLine:᥽åɤϡʣʸäʸ򡢲ʸμޤǥɤޤ
- (int)getLine: (char *)aLine;

//M: getInt:᥽åɤϡIntΥݥ󥿤ơƤե뤫餽ηΥ󥹥󥹤ȰˤɤޤԤ0֤ޤ
- (int)getInt: (int *)anInt;

//M: getUnsigned:᥽åɤϡunsignedΥݥ󥿤ơƤե뤫餽ηΥ󥹥󥹤ȰˤɤޤԤ0֤ޤ
- (int)getUnsigned: (unsigned *)anUnsigned;

//M: getLong:᥽åɤϡlongΥݥ󥿤ơƤե뤫餽ηΥ󥹥󥹤ȰˤɤޤԤ0֤ޤ
- (int)getLong: (long *)aLong;

//M: getUnsignedLong:᥽åɤϡunsigned longΥݥ󥿤ơƤե뤫餽ηΥ󥹥󥹤ȰˤɤޤԤ0֤ޤ
- (int)getUnsignedLong: (unsigned long *)anUnsLong;

//M: getDouble:᥽åɤϡdoubleΥݥ󥿤ơƤե뤫餽ηΥ󥹥󥹤ȰˤɤޤԤ0֤ޤ
- (int)getDouble: (double *)aDouble;

//M: getFloat:᥽åɤϡfloatΥݥ󥿤ơƤե뤫餽ηΥ󥹥󥹤ȰˤɤޤԤ0֤ޤ
- (int)getFloat: (float *)aFloat;

//M: getChar:᥽åɤϡcharΥݥ󥿤ơƤե뤫餽ηΥ󥹥󥹤ȰˤɤޤԤ0֤ޤ
- (int)getChar: (char *)aChar;

//M: ɤ߹Ѥ1ʸ֤ޤ
- (int)unGetChar: (char)aChar;

//M: 1ԥåפޤ
- (int)skipLine;

//M: եĤˤdrop᥽åɤƤӽФʤФʤޤInFile֥ȤɥåפǤϡ˥ե뤬ĤȤˤϤʤޤ
- (void)drop;
@end

@protocol OutFile <SwarmObject>
//S: եϤ¹Ԥ륯饹

//D: SwarmǤνϥեI/Oñ㲽륯饹ǤŪˤϺ٤ʥեΥץ/Υ롼CΥեI/OץƤӽФ֤򸺤餷ޤ
 

CREATING
//M: create:withName:᥽åɤtheNameȤե򳫤Outfile֥Ȥޤ
+ create: aZone withName: (const char *)theName;

USING
//M: putString:᥽åɤϡstringΥ󥹥󥹤ơ򳫤Ƥե˽񤭹ߤޤ
- putString: (const char *)aString;

//M: putInt:᥽åɤϡintΥ󥹥󥹤ơ򳫤Ƥե˽񤭹ߤޤ
- putInt: (int) anInt;

//M: putUnsigned:᥽åɤϡunsignedΥ󥹥󥹤ơ򳫤Ƥե˽񤭹ߤޤ
- putUnsigned: (unsigned)anUnsigned;

//M: putLong:᥽åɤϡlongΥ󥹥󥹤ơ򳫤Ƥե˽񤭹ߤޤ
- putLong: (long)aLong;

//M: putUnsignedLong:᥽åɤϡunsigned longΥ󥹥󥹤ơ򳫤Ƥե˽񤭹ߤޤ
- putUnsignedLong: (unsigned long)anUnsLong;

//M: putDouble:᥽åɤϡdoubleΥ󥹥󥹤ơ򳫤Ƥե˽񤭹ߤޤ
- putDouble: (double)aDouble;

//M: putFloat:᥽åɤϡfloatΥ󥹥󥹤ơ򳫤Ƥե˽񤭹ߤޤ
- putFloat: (float)aFloat;

//M: putChar:᥽åɤϡcharΥ󥹥󥹤ơ򳫤Ƥե˽񤭹ߤޤ
- putChar: (char)aChar;

//M: putNewline᥽åɤϳƤե˲Ԥ񤭹ߤޤ
- putNewLine;

//M: putTab᥽åɤϳƤե˥֤񤭹ߤޤ
- putTab;

//M: drop᥽åɤϳƤեĤޤեĤˤϤΥ᥽åɤƤӽФʤФʤޤ
- (void)drop;
@end

@protocol AppendFile <OutFile>
//S: եϤ򥢥ڥɥ⡼ɤǼ¹Ԥ륯饹

//D: OutFile饵֥饹饹ǤǽŪˤϡͿ줿ե񤭥⡼ɤǤʤڥɥ⡼ɤǥץ󤹤Ȥ㤤Ǥ

CREATING
//M: create:withName:᥽åɤϡAppendFilecreate᥽åɤǤtheNameϳե̾Ǥ
+ create: aZone withName: (const char *)theName;
@end

@protocol ObjectLoader <SwarmObject>
//S:  륪֥ȤΥ󥹥ѿե뤫ɤ륯饹

//D: Υ饹ϡǡե뤫饿åȥ֥ȤѿΤ˻Ѥޤǡե϶ˤñʽ񼰤ǤʤФʤޤ

USING
//M: load:from:᥽åɤϡ餫ᳫƤaFileObjectanObjectɤޤObjectLoader饹μºݤΥ󥹥󥹤֤ޤFileObjectϥ᥽åɤƤӽФ줿ⳫޤޤǤ
+ load: anObject from: aFileObject;

//M: load:fromFileNamed:᥽åɤϡaFileNameȤե뤫anObjectɤޤObjectLoader饹ϡaFileNameե򳫤ƤƤ˽äƥ֥ȤեĤޤ
+ load: anObject fromFileNamed: (const char *)aFileName;

//M: load:fromAppConfigFileNamed:᥽åɤϡaFileNameȤץꥱͭΥե졼ե뤫anObjectɤޤObjectLoader饹ϡaFileNameե򳫤ƤƤ˽äƥ֥ȤեĤޤ
+ load: anObject fromAppConfigFileNamed: (const char *)aFileName;

//M: load:fromAppConfigFileNamed:᥽åɤϡaFileNameȤץꥱͭΥǡե뤫anObjectɤޤObjectLoader饹ϡaFileNameե򳫤ƤƤ˽äƥ֥ȤեĤޤ
+ load: anObject fromAppDataFileNamed: (const char *)aFileName;

//M: setFileObject:᥽åɤϡΥå줿ObjectLoader饹Υ󥹥󥹤Ѥ٤ե륪֥Ȥ򥻥åȤޤ
- setFileObject: aFileObject;

//M: ꥯȤ줿ե뤫饿åȥ֥ȤˤϡObjectLoader饹Υ󥹥󥹤ˡloadObject:åʤФʤޤ
- loadObject: anObject;

//M: ObjectLoader󥹥󥹤Ʊ饹¿Υ֥Ȥ褦ȤƤȤϡupdateCache:᥽åɤƤӽФɬפޤ
- updateCache: exampleTarget; 

//M: setTemplateProbeMap:᥽åɤϡΥå줿ObjectLoader󥹥󥹤ɤ٤åȥ֥Ȥѿꤷޤ
- setTemplateProbeMap: probeMap;
@end

@protocol ObjectSaver <SwarmObject>
//S: 륪֥ȤΥ󥹥ѿե¸륯饹

//D: ֥ȤѿΥե˽񤭹ȤΥ饹ѤޤѿΥ֥åȤ񤭽ФϡtemplateProbeMapǤΥåȤꤷޤ(ProbeMap¸٤ѿProbeޤߤޤ)

USING
//M: save:to:᥽åɤϡåȥ֥Τ¸ޤObjectSaverΥ󥹥󥹤֤ޤ
+ save: anObject to: aFileObject;

//M: save:to:withTemplate:᥽åɤϡanObject顢ƥץ졼Ȥ˻ꤵ줿åȥ֥ѿΥ֥åȤ¸ޤObjectSaverΥ󥹥󥹤֤ޤ
+ save: anObject to: aFileObject withTemplate: aProbeMap;

//M: save:toFileNamed:᥽åɤϡåȥ֥ΤaFileNameȤե¸ޤ
+ save: anObject toFileNamed: (const char *)aFileName;

//M: save:toFileNamed:withTemplate:᥽åɤϡåȥ֥Ȥ顢ƥץ졼Ȥ˻ꤵ줿ѿΥ֥åȤaFileNameȤե¸ޤ
+ save: anObject toFileNamed: (const char *)aFileName 
                withTemplate: (ProbeMap *)aProbeMap;

//M: setFileObject:᥽åɤϡObjectSaver饹Υ󥹥󥹤Ѥ٤åfileObject򥻥åȤޤ
- setFileObject: aFileObject;

//M: setTemplateProbeMap:᥽åɤϡΥå줿ObjectSaver󥹥󥹤֥ȤΤɤѿ¸٤ꤷޤ
- setTemplateProbeMap: aProbeMap;

//M: saveObject:åϡ׵ᤵ줿ե˥åȥ֥Ȥξ֤¸褦ObjectSaver饹Υ󥹥󥹤˻ؼޤ
- saveObject: anObject;
@end

@protocol QSort <SwarmObject>
//S: 쥯򥽡Ȥ륯饹

//D: CΥͥƥִؿ"qsort"Swarm쥯ŬѤ뤿Ρñʤqsort"å"ǤǥեȤǤͤϾ˸ޤսˤȤreverseOrderOfƤӽФƤΥ᥽åɤϤɤäȤʤ륳쥯뤿ᡢ٤ƤΥǥåϺƺʤФʤޤ

USING
//M: sortObjectsIn:᥽åɤϡ쥯ˤ륪֥Ȥ򡢤Υ֥Ȥ`compare'ؿȤäƥȤޤΥ֥Ȥcompareؿ󶡤Ƥʤ硢sortObjectsIndefobj饤֥ΥǥեȤѤޤ
+ (void)sortObjectsIn: aCollection;

//M: sortObjectsIn:using:᥽åɤϡ쥯ˤ륪֥Ȥ򡢤Υ֥Ȥ˻ꤵ줿comparisonؿȤäƥȤޤ
+ (void)sortObjectsIn: aCollection using: (SEL) aSelector;

//M: sortNumbersIn:᥽åɤϡǥեȤ"compare"ؿȤ쥯Υ֥ȤФӤ¹ԤޤǥեȤǤϿͤñĴä뤳ȤȤʤޤ
+ (void)sortNumbersIn: aCollection;

//M: sortNumbersIn:using:᥽åɤϡΥ֥Ȥ˻ꤵ줿comparisonؿȤ쥯Υ֥ȤӤ¹Ԥޤ
+ (void)sortNumbersIn: aCollection
                using: (int(*)(const void*,const void*)) comp_fun;

//M: reverseOrderOf:᥽åɤϡ쥯θߤνդˤޤ"ս"ΥȤԤˤϡޤб"sort"᥽åɤ1Ĥ򥳥쥯˸ƤӽФˤΥ쥯ˤδؿƤӽФޤ
+ (void)reverseOrderOf: aCollection;
@end

@protocol NSelect <SwarmObject>
//S: 륳쥯󤫤NȤ򡢸̩򤹤륯饹

//D: NSelectϡͿ줿åȥ쥯󤫤顢ʣʤʣNȤ̩򤷤ޤ

USING
//M: select:from:into:᥽åɤϡ륳쥯󤫤̤Υ쥯ءʣʤNȤ̩򤷤ޤKnuth򥢥르ꥺबѤޤ
+ (void)select: (int)n from: aCollection into: bCollection;
@end



//F: СХݡȥɥ쥹ξ󶡤ʤǡSwarm饤֥ޤ
extern void initSwarm (int argc, const char **argv);

//F: СХݡȥɥ쥹ξ󶡤ʤǡХå⡼ɤSwarm饤֥ޤ
extern void initSwarmBatch (int argc, const char **argv);

//F: ץꥱѤSwarm饤֥ޤ
extern void initSwarmApp (int argc, const char **argv,
                          const char *version, const char *bugAddress);

//F: initSwarmApp˻ƤޤХå⡼ɤǽ¹Ԥޤ
extern void initSwarmAppBatch (int argc, const char **argv,
                          const char *version, const char *bugAddress);

//F: initSwarmApp˻Ƥޤϴؿꤷޤ
extern void initSwarmAppOptions (int argc, const char **argv,
                                 const char *version, const char *bugAddress,
                                 struct argp_option *options,
                                 int (*optionFunc) (int key, const char *arg));

//F: initSwarmAppOptions˻ƤޤХå⡼ɤǽ¹Ԥޤ
extern void initSwarmAppOptionsBatch (int argc, const char **argv,
                                 const char *version, const char *bugAddress,
                                 struct argp_option *options,
                                 int (*optionFunc) (int key, const char *arg));

//F: initSwarm˻ƤޤβϤ˻Ȥ饹ꤷޤ̤ArgumentsΥ֥饹Ȥޤ
extern void initSwarmArguments (int argc, const char **argv,
                                Class argumentsClass);

//F: initSwarmApp˻ƤޤβϤ˻Ȥ饹ꤷޤ̤ArgumentsΥ֥饹Ȥޤ
extern void initSwarmAppArguments (int argc, const char **argv,
                                   const char *version, const char *bugAddress,
                                   Class argumentsClass);

//G: եå⡼ɤˤ뤫Ǥʤ򼨤ե饰ǥեȤ1Ǥ
extern BOOL swarmGUIMode;

@class ControlPanel;
@class UName;
@class InFile;
@class OutFile;
@class AppendFile;
@class ObjectLoader;
@class ObjectSaver;
@class QSort;
@class NSelect;
