// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute. This library is
//   distributed without any warranty; without even the implied warranty
//   of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            random.h
Description:     Protocol header file for random number generation  
Library:         random
Authors:         Nelson Minar, Roger Burkhart, Manor Askenazi
Date:            1996-12-11
Modified:        1997-01-15 (v. 0.6)  by Sven Thommesen
Modified:	 1997-09-01 (v. 0.7)  by Sven Thommesen
Modified:	 1997-12-08 (v. 0.75) by Sven Thommesen
Modified:	 1998-10-08 (v. 0.8)  by Sven Thommesen
*/

//S: ⥸塼

//D: Υ⥸塼ϡߥ졼Ȥ͡ʳΨʬۤѴ뤿ΡϢ饹ʬۥ饹ǹƤޤ

#import <objectbase.h>		// for protocol SwarmObject


@protocol InternalState
//S: ͥ졼ʬ۾֤Υ֥롼

//D: ƤӽФץबƤХåեˡ륪֥(ͥ졼ʬ)֤¸ޤޤХåե̤ơ¸Ƥξ֥ǡ饪֥Ȥξ֤򥻥åȤޤ

//D: աputStateInto/setStateFrom᥽åɤϡƥˤäưۤʤХȽȤädoubleǼ뤿ᡢܿϤޤ󡣼Υ꡼ǤϡܿΤǼ᥽åɤ󶡤뤫⤷ޤ

USING
//M: ɬפʺǾХåեꤷޤ
- (unsigned)getStateSize;		// size of buffer needed
- (void)putStateInto: (void *)buffer;	// save state data for later use
- (void)setStateFrom: (void *)buffer;	// set state from saved data
- (void)describe: outStream;	        // prints ascii data to stream
- (const char *)getName;		// returns name of object
- (unsigned)getMagic;			// object's 'magic number'
@end

#import <random/generators.h>
#import <random/distributions.h>
#import <random/randomvars.h>
#import <random/randomdefs.h>

