//
// <random/generators.h>
//
//     1997-09-01 (v. 0.7)
//     1998-10-08 (v. 0.8)
//

// 
// See the file docs/README.Generators for guide to usage
// 

//
// Every implemented random number generator is --
// 
//   A predefined algorithm for generating non-negative integral
//   values uniformly distributed across an algorithm-specific
//   closed interval [0,unsignedMax], as well as floating point
//   values uniformly distributed over the half-open interval 
//   [0.0,1.0).
//

// 
// ---------------------------------------------------------------------
// Protocol components:
//

@protocol SingleSeed
//S: 
CREATING
+ create: aZone setStateFromSeed: (unsigned)seed;

SETTING
//M: setStateFromSeeds᥽åɤϡ֤Υɰ¸ʬޤ
- setStateFromSeed: (unsigned)seed;

USING
//M: getMaxSeedValue᥽åɤϡͤξ¤֤ޤ
- (unsigned)getMaxSeedValue;	// minvalue is 1

//M: getInitialSeed᥽åɤϡͥ졼ν֤ͤޤ
- (unsigned)getInitialSeed;
@end


@protocol MultiSeed
//S: 
CREATING
+ create: aZone setStateFromSeeds: (unsigned *)seeds;

SETTING
//M: setStateFromSeeds᥽åɤϡ֤Υɰ¸ʬޤ
- setStateFromSeeds: (unsigned *)seeds;

USING
//M: lengthOfSeedVector᥽åɤϡɬפʥɿ(Υ)֤ޤ
- (unsigned)lengthOfSeedVector;

//M: getMaxSeedValue᥽åɤϡ󶡤륷ͤξ¤֤ޤ
- (unsigned *)getMaxSeedValues;		// minvalue is 1

//M: getInitialSeed᥽åɤϡͥ졼ν֤ͤޤ
- (unsigned *)getInitialSeeds;
@end

@protocol Simple
//S: 
CREATING
+ createWithDefaults: aZone;

SETTING
//M: setAntithetic᥽åɤϡоνϤonޤoffڤؤޤ(ǥե=off)оνϤ(unsignedMax - u)ޤ(1.0 - d)Ǥ
- setAntithetic: (BOOL) antiT;

USING
//M: getAntithetic᥽åɤϡߤΥѥ᡼֤ͤޤ
- (BOOL)getAntithetic;

//M: getCurrentCountϡ줿̤ΥȤ֤ޤ
- (unsigned long long int)getCurrentCount;

//M: -reset᥽åɤϡͥ졼򳫻ϻ뤤ϺǸsetStateFromSeedλѻξ֤ᤷޤCurrentCountϥˤʤޤ
- reset;
@end


@protocol SimpleOut
//S: 

USING
//M: getUnsignedMax᥽åɤϡ-getUnsignedSample֤ȤΤǤǹ֤ͤޤ(ͤ0)
- (unsigned)getUnsignedMax;

//M: getUnsignedSample᥽åɤϡ[0,unsignedMax]ϰϤǰʬۤ˽unsigned֤ޤ
- (unsigned)getUnsignedSample;

//M: getFloatSample᥽åɤϡ[0.0, 1.0)ϰϤǰʬۤ˽floatΥư֤ޤΥ᥽åɤϡ-getUnsignedSample1ƤӽФƲޤ
- (float)getFloatSample;

//M: getThinDoubleSample᥽åɤϡ[0.0, 1.0)ϰϤǰʬۤ˽doubleΥư֤ޤΥ᥽åɤϡ-getUnsignedSample1ƤӽФƲޤ
- (double)getThinDoubleSample;

//M: getDoubleSample᥽åɤϡ[0.0, 1.0)ϰϤǰʬۤ˽doubleΥư֤ޤΥ᥽åɤϡ-getUnsignedSample2ƤӽФƲޤ
- (double)getDoubleSample;

//M: getLongDoubleSample᥽åɤϡ[0.0, 1.0)ϰϤǰʬۤ˽long doubleΥư֤ޤΥ᥽åɤϡ-getUnsignedSample2ƤӽФƲޤաΥ᥽åɤϡƥ֤ΰܿޤ
- (long double)getLongDoubleSample;

@end

@protocol SplitSingleSeed
//S: 
CREATING
+ create          : aZone
              setA: (unsigned)A 	// # of virtual generators
              setv: (unsigned)v 	// log2(#segments/generator)
              setw: (unsigned)w		// log2(segment length)
  setStateFromSeed: (unsigned)seed;

SETTING
//M: setStateFromSeed᥽åɤϡͥ졼ñΥͤޤ¿ɬפʤȤϡŪޤ
- setStateFromSeed: (unsigned)seed;

USING
//M: getMaxSeedValue᥽åɤϡǧǹΥ֤ͤޤͤ1Ǥ(0ͭʥͤǤϤޤ)
- (unsigned)getMaxSeedValue;

//M: getInitialSeed᥽åɤϡͥ졼νɤ֤ޤ
- (unsigned)getInitialSeed;
@end

@protocol SplitMultiSeed
//S: 
CREATING
+ create          : aZone
              setA: (unsigned)A         // # of virtual generators
              setv: (unsigned)v         // log2(#segments/generator)
              setw: (unsigned)w	        // log2(segment length)
 setStateFromSeeds: (unsigned *)seeds;

SETTING
//M: setStateFromSeeds᥽åɤϡͥ졼򥷡ͤΥ٥ȥ뤫ޤ
- setStateFromSeeds: (unsigned *)seeds;

USING
//M: lengthOfSeedVector᥽åɤϡɬפʥɤο֤ޤ
- (unsigned)lengthOfSeedVector;

//M: getMaxSeedValue᥽åɤϡǧǹΥͤΥ٥ȥ֤ޤͤϾ1Ǥ(0ͭʥɤǤϤޤ)
- (unsigned *)getMaxSeedValues;		// min is 1

//M: getInitialSeed᥽åɤϡͥ졼νɤ֤ޤ
- (unsigned *)getInitialSeeds;     	// = getInitialSeeds: 0
@end


@protocol Split
//S: 
CREATING
+ createWithDefaults: aZone;

SETTING
//M: setAntithetic᥽åɤϡоνϤonޤoffڤؤޤ(ǥե=off)оνϤ(unsignedMax - u)ޤ(1.0 - d)Ǥ
- setAntithetic: (BOOL)antiT;

//M: initGenerator᥽åɤϡ벾ۥͥ졼򥻥#0γϻξ֤˥ꥻåȤޤ
- initGenerator: (unsigned)vGen;

//M: initAll᥽åɤϡ٤Ƥβۥͥ졼򥻥#0γϻξ֤˥ꥻåȤޤ
- initAll; 

USING
// Note: Valid values for vGen are [0,getNumGenerators-1]

//M: getNumGenerators᥽åɤϡۥͥ졼θߤθĿ(A)֤ޤ
- (unsigned)getNumGenerators;

//M:  getNumSegments᥽åɤϡlog2(ߤΥȿ)=v֤ޤ
- (unsigned)getNumSegments;

//M: getSegmentLength᥽åɤϡlog2(ߤΥĹ)=w֤ޤ
- (unsigned)getSegmentLength;

//M: getAntithetic᥽åɤϡѥ᡼θ֤ͤޤ
- (BOOL)getAntithetic;

//M: restartGenerator᥽åɤϡۥͥ졼򸽺ߤΥȤγϻξ֤˥ꥻåȤޤ
- restartGenerator: (unsigned)vGen;

//M: advanceGenerator᥽åɤϡۥͥ졼򼡤ΥȤγϻξ֤˥ꥻåȤޤ
- advanceGenerator: (unsigned)vGen;

//M: jumpGenerator:toSegment:᥽åɤϡۥͥ졼ꤷȤγϻξ֤˥ꥻåȤޤ
- jumpGenerator: (unsigned)vGen  toSegment: (unsigned long long int)seg;

//M: restartAll᥽åɤϡ٤Ƥβۥͥ졼򡢤줾츽ߤΥȤγϻξ֤˥ꥻåȤޤ
- restartAll;					// start of current segment

//M: advanceAll᥽åɤϡ٤Ƥβۥͥ졼򡢤줾켡ΥȤγϻξ֤˥ꥻåȤޤ
- advanceAll;					// to next segment

//M: jumpAlltoSegment:᥽åɤϡ٤Ƥβۥͥ졼򡢻ꤷȤγϻξ֤˥ꥻåȤޤ
- jumpAllToSegment: (unsigned long long int)seg;

//M: getCurrentCount᥽åɤϡꤷۥͥ졼θߤΥ(̤ο)֤ޤ
- (unsigned long long int)getCurrentCount: (unsigned)vGen;

//M: getCurrentSegment᥽åɤϡꤷۥͥ졼θߤΥȿ֤ޤ
- (unsigned long long int)getCurrentSegment: (unsigned)vGen;

//M: -reset᥽åɤϡͥ졼򳫻ϻ뤤ϺǸ-setStateFromSeedλѻξ֤ᤷޤCurrentCountϥˤʤޤ 
- reset;
@end

@protocol SplitOut
//S: 
USING
// Note: Valid values for vGen are [0,getNumGenerators-1]

//M: getUnsignedMax᥽åɤϡ-getUnsignedSample֤ȤΤǤǹ֤ͤޤ(ͤ0)
- (unsigned)getUnsignedMax;

//M: getUnsignedSample᥽åɤϡۥͥ졼(ǡ)vGen顢[0,unsignedMax]ϰϤǰʬۤ˽unsigned֤ޤ
- (unsigned)getUnsignedSample: (unsigned)vGen;

//M: getFloatSample᥽åɤϡۥͥ졼(ǡ)vGen顢[0.0,1.0)ϰϤǰʬۤ˽floatΥư֤ޤΥ᥽åɤϡ-getUnsignedSample1ƤӽФƲޤ
- (float)getFloatSample: (unsigned)vGen; // using 1 unsigned

//M: getThinDoubleSample᥽åɤϡۥͥ졼(ǡ)vGen顢[0.0,1.0)ϰϤǰʬۤ˽doubleΥư֤ޤΥ᥽åɤϡ-getUnsignedSample1ƤӽФƲޤ
- (double)getThinDoubleSample: (unsigned)vGen;      // using 1 unsigned

//M: getDoubleSample᥽åɤϡۥͥ졼(ǡ)vGen顢[0.0,1.0)ϰϤǰʬۤ˽doubleΥư֤ޤΥ᥽åɤϡ-getUnsignedSample2ƤӽФƲޤ
- (double)getDoubleSample: (unsigned)vGen;          // using 2 unsigneds

//M: getLongDoubleSample᥽åɤϡۥͥ졼(ǡ)vGen顢[0.0,1.0)ϰϤǰʬۤ˽long doubleΥư֤ޤΥ᥽åɤϡ-getUnsignedSample2ƤӽФƲޤٹ𡧤Υ᥽åɤˡƥ֤ΰܿϤޤ
- (long double)getLongDoubleSample: (unsigned)vGen; // using 2 unsigneds

@end


// 
// ------------------------------------------------------------------------
// Implemented generator types:
//

// 
// NOTE: all the split generators implement the same protocols,
//   and likewise for the non-split (simple) generators.
//

@protocol SimpleRandomGenerator <SwarmObject, InternalState, SimpleOut, Simple, SingleSeed, MultiSeed>
//S: ñ(ʬ)ͥ졼

//D: Υץȥϡ줿ʬ䥸ͥ졼򤹤٤ƥСޤ
@end

@protocol SplitRandomGenerator <SwarmObject, InternalState, SplitOut, Split, SplitSingleSeed, SplitMultiSeed>
//S: ʬ䥸ͥ졼.

//D: ΥץȥϡѤߤʬ䥸ͥ졼(C2LCGXC4LCGX)򥫥Сޤ
@end

// 
// -----------------------------------------------------------------
// @protocols for individual generator classes:
//

// NOTE: these protocols are included for backward compatibility only.
// Use protocols <SimpleRandomGenerator> and <SplitRandomGenerators>.

// LCG[1-3] -- single short random number generators, 
@protocol LCGgen <SimpleRandomGenerator>
//S: Ʊͥ졼

//D: 32ӥåȤ椵줿СեŵŪʥͥ졼ǤANSI C§˽32bitͤunsigned׵ᤵޤKnuthϷ2^32ƱͤΰҤäƤʤ¤ꡢûcϤޤˤʤʤȼĥޤ

//D: פʻѤˤϿǤޤ󡣤Υ饹Ūͳ(Υ꡼ȤθߴΤ)ޤޤƤޤ 
@end

@protocol LCG1gen <LCGgen, CREATABLE>
//S: Ʊͥ졼1

//D: a = 1,664,525c = 1,013,904,223Ȥѥ᡼ȤȡΥͥ졼ĹmñΥե륵른ͥ졼ˤʤޤ
@end

@protocol LCG2gen <LCGgen, CREATABLE>
//S: Ʊͥ졼2

//D: a = 69,069c = 1,013,904,223Ȥѥ᡼ȤȡΥͥ졼ĹmñΥե륵른ͥ졼ˤʤޤ
@end

@protocol LCG3gen <LCGgen, CREATABLE>
//S: Ʊͥ졼3

//D: a = 1,664,525c = 152,193,325Ȥѥ᡼ȤȡΥͥ졼ĹmñΥե륵른ͥ졼ˤʤޤ
@end


//
// PMMLCG1, PMMLCG2, PMMLCG3 --
//   single short random number generators recommended for use.
//
// PMMLCG4, PMMLCG5, PMMLCG6, PMMLCG7 --
//   component generators of C4LCGX
//
// PMMLCG8, PMMLCG9 --
//   component generators of C2LCGX

@protocol PMMLCGgen <SimpleRandomGenerator>
//S: ǿƱͥ졼

//D: Υͥ졼ϡĹ(m-1)ñΥե륵른ͥ졼Ǥ
@end

@protocol PMMLCG1gen <PMMLCGgen, CREATABLE>
//S: ǿƱͥ졼1

//D: a = 16,807m = 2,147,483,647ѥ᡼˻ȤȡΥͥ졼Ĺ(m-1)ñΥե륵른ͥ졼ˤʤޤ
@end

@protocol PMMLCG2gen <PMMLCGgen, CREATABLE>
//S: ǿƱͥ졼2

//D: a = 48,271m = 2,147,483,647ѥ᡼˻ȤȡΥͥ졼Ĺ(m-1)ñΥե륵른ͥ졼ˤʤޤ
@end

@protocol PMMLCG3gen <PMMLCGgen, CREATABLE>
//S: ǿƱͥ졼3

//D: a = 69,621m = 2,147,483,647ѥ᡼˻ȤȡΥͥ졼Ĺ(m-1)ñΥե륵른ͥ졼ˤʤޤ
@end

@protocol PMMLCG4gen  <PMMLCGgen, CREATABLE>
//S: ǿƱͥ졼4

//D: a = 45,991m = 2,147,483,647ѥ᡼˻ȤȡΥͥ졼Ĺ(m-1)ñΥե륵른ͥ졼ˤʤޤCLOG4Υݡͥȥͥ졼1ĤǤ
@end

@protocol PMMLCG5gen  <PMMLCGgen, CREATABLE>
//S: ǿƱͥ졼5

//D: a = 207,707m = 2,147,483,543ѥ᡼˻ȤȡΥͥ졼Ĺ(m-1)ñΥե륵른ͥ졼ˤʤޤCLOG4Υݡͥȥͥ졼1ĤǤ
@end

@protocol PMMLCG6gen <PMMLCGgen, CREATABLE>
//S: ǿƱͥ졼6

//D: a = 138,556m = 2,147,483,423ѥ᡼˻ȤȡΥͥ졼Ĺ(m-1)ñΥե륵른ͥ졼ˤʤޤCLOG4Υݡͥȥͥ졼1ĤǤ
@end

@protocol PMMLCG7gen <PMMLCGgen, CREATABLE>
//S: ǿƱͥ졼7

//D: a = 49,689m = 2,147,483,323ѥ᡼˻ȤȡΥͥ졼Ĺ(m-1)ñΥե륵른ͥ졼ˤʤޤCLOG4Υݡͥȥͥ졼1ĤǤ
@end

@protocol PMMLCG8gen <PMMLCGgen, CREATABLE>
//S: ǿƱͥ졼8

//D: a = 40,014m = 2,147,483,563ѥ᡼˻ȤȡΥͥ졼Ĺ(m-1)ñΥե륵른ͥ졼ˤʤޤC2LOGXΥݡͥȥͥ졼1ĤǤ
@end

@protocol PMMLCG9gen <PMMLCGgen, CREATABLE>
//S: ǿƱͥ졼 9

//D: a = 40,692m = 2,147,483,399ѥ᡼˻ȤȡΥͥ졼Ĺ(m-1)ñΥե륵른ͥ졼ˤʤޤC2LOGXΥݡͥȥͥ졼1ĤǤ
@end

// ACG, SCG -- single long random number generators

@protocol ACGgen <SimpleRandomGenerator, CREATABLE>
//S: ˡƱͥ졼

//D: ACGLagged-Fibonacci饹Υͥ졼ǤΥͥ졼ϡX_n = f(X_(n-r),X_(n-s)) mod m(r>s)Ȥδܥ르ꥺѤޤɽŪfؿϡxorû軻ޤϷ夬դθǤŪLCGñʿؤȤޤ礭֤ݤޤ

//D: ʻѤˤϿǤޤ󡣤Υ饹Ūͳ(Υ꡼ȤθߴΤ)ޤޤƤޤ
@end

@protocol SCGgen <SimpleRandomGenerator, CREATABLE>
//S: Ʊͥ졼

//D: SCGϡLagged Fibonacci饹Υͥ졼ǤΥͥ졼ϡX_n = f(X_(n-r),X_(n-s)) mod m(r>s)Ȥδܥ르ꥺѤޤɽŪfؿϡxorû軻ޤϷ夬դθǤŪLCGñʿؤȤޤ礭֤ݤޤ

//D: ʻѤˤϿǤޤ󡣤Υ饹Ūͳ(Υ꡼ȤθߴΤ)ޤޤƤޤ
@end

// SWB1, SWB2, SWB3 -- single long generators recommended for use.

@protocol SWBgen <SimpleRandomGenerator>
//S: ܥդƱͥ졼

//D: Υͥ졼ϡX_n = f(X_(n-r),X_(n-s)) mod m(r>s)Ȥδܥ르ꥺѤޤɽŪfؿϡxorû軻ޤϷ夬դθǤŪLCGñʿؤȤޤ礭֤ݤޤ
@end

@protocol SWB1gen <SWBgen, CREATABLE>
//S: ܥդƱͥ졼1

//D: r = 37s = 24ѥ᡼˻ȤȡΥͥ졼Ĺ10^35464ĤΥޤ
@end

@protocol SWB2gen <SWBgen, CREATABLE>
//S: ܥդƱͥ졼2

//D: r = 24s = 19ѥ᡼˻ȤȡΥͥ졼Ĺ10^2281536ĤΥޤ
@end

@protocol SWB3gen <SWBgen, CREATABLE>
//S: ܥդƱͥ졼3

//D: r = 21s = 6ѥ᡼˻ȤȡΥͥ졼Ĺ10^200192ĤΥޤ
@end

// PSWB -- single long generator recommended for use.
@protocol PSWBgen   <SimpleRandomGenerator, CREATABLE>
//S: ǿȤäܥդƱͥ졼

//D: PSWBSWBɤΤǡǿѤ뤳ȤñΥե륵른ͥ졼ˤʤäƤޤSWB٤ʤޤ
@end

// MWC -- two long generators recommended for use.

@protocol MWCAgen <SimpleRandomGenerator, CREATABLE>
//S: 夬ѥͥ졼

//D: Υͥ졼ϡ̩ˤϼ > 2^59ȿȸƤޤ(餯Τ褦ʥ뤬2Ĥޤ)
@end

@protocol MWCBgen <SimpleRandomGenerator, CREATABLE>
//S: 夬ѥͥ졼

//D: Υͥ졼ϡ(MWCAȤϰۤʤ)2ĤΥݡͥȤ礷ؼˡƤޤΥͥ졼ϡ̩ˤϼ > 2^59ȿȸƤޤ(餯Τ褦ʥ뤬2Ĥޤ)
@end

// RWC2 -- single long generator recommended for use.
@protocol RWC2gen <SimpleRandomGenerator, CREATABLE>
//S: 夬饰2Ƶͥ졼

//D: 64-bitη׻ȤäƼ饰2MWCͥ졼Ǥ
@end

// RWC8 ("Mother") -- single long generator recommended for use.
@protocol RWC8gen <SimpleRandomGenerator, CREATABLE>
//S: 夬ѥͥ졼("٤ƤRNG")

//D: 2Ĥ16-bit饰8夬Ƶͥ졼礷ͥ졼Ǥ
@end

// TT403, TT775, TT800 -- single long generators recommended for use.
@protocol TGFSRgen <SimpleRandomGenerator>
//S: Twisted GFSRͥ졼

//D: Ŭ򤵤줿ѥ᡼ȤȡΥͥ졼Ĺ2^(w*N) -1ñ쥵ޤ
@end

@protocol TT403gen <TGFSRgen, CREATABLE>
//S: ñlongͥ졼侩ǡ

//D: ñlongͥ졼侩ǡ
@end

@protocol TT775gen <TGFSRgen, CREATABLE>
//S: ñlongͥ졼侩ǡ

//D: ñlongͥ졼侩ǡ
@end

@protocol TT800gen <TGFSRgen, CREATABLE>
//S: ñlongͥ졼侩ǡ

//D: ñlongͥ졼侩ǡ
@end

// MT19937 -- single *very* long generator recommended for use.
@protocol MT19937gen <SimpleRandomGenerator, CREATABLE>
//S: 'Mersenne Twister'Twisted GFSRͥ졼

//D: Υͥ졼ϡĹ2^19937-1ñ쥵ޤ
@end

// MRG5, MRG6, MRG7 -- single long generators recommended for use.
@protocol MRGgen <SimpleRandomGenerator>
//S: ¿źƵ[LCG]ͥ졼

//D: Υͥ졼ǤϡkĤξkĤβͤݻʤФʤޤʸˤСԤ17νkMRG򸦵椷ƤꡢѤߤ礭ʿͤ椫ѥ᡼åȤ򤤤Ĥ󶡤Ƥޤ̤ˡk礭ʤ˽äƥͥ졼ʼϹ⤯ʤޤ
@end

@protocol MRG5gen <MRGgen, CREATABLE>
//S: ¿źƵ[LCG]ͥ졼5

//D: Υͥ졼ϡĹ(2^31-1)^5 - 1Ĥޤ2^154 <  < 2^155ñΥե륵른ͥ졼Ǥ
@end

@protocol MRG6gen <MRGgen, CREATABLE>
//S: ¿źƵ[LCG]ͥ졼6

//D: Υͥ졼ϡĹ(2^31-1)^6 - 1Ĥޤ2^185 <  < 2^186ñΥե륵른ͥ졼Ǥ
@end

@protocol MRG7gen <MRGgen, CREATABLE>
//S: ¿źƵ[LCG]ͥ졼7

//D: Υͥ졼ϡĹ(2^31-1)^7 - 1Ĥޤ2^216 <  < 2^217ñΥե륵른ͥ졼Ǥ
@end

// C2TAUS[1-3]: short component based generator recommended for use.
@protocol C2TAUSgen <SimpleRandomGenerator>
//S: 緿Tauswortheͥ졼 

//D: Υͥ졼ϡ2^31-12^29-12ĤΥݡͥȥͥ졼Ȥޤ
@end

@protocol C2TAUS1gen <C2TAUSgen, CREATABLE>
//S: 緿Tauswortheͥ졼1

//D: ݡͥ1Υѥ᡼: P = 31, S = 12, Q = 13ݡͥ2Υѥ᡼: P = 29, S = 17, Q = 2ȤȡΥͥ졼Ĺ~2^60ñΥե륵른ͥ졼ˤʤޤ
@end

@protocol C2TAUS2gen <C2TAUSgen, CREATABLE>
//S: 緿Tauswortheͥ졼2

//D: ݡͥ1Υѥ᡼: P = 31, S = 21, Q = 3ݡͥ2Υѥ᡼: P = 29, S = 17, Q = 2ȤȡΥͥ졼Ĺ~2^60ñΥե륵른ͥ졼ˤʤޤ
@end

@protocol C2TAUS3gen <C2TAUSgen, CREATABLE>
//S: 緿Tauswortheͥ졼3

//D: ݡͥ1Υѥ᡼: P = 31, S = 13, Q = 13ݡͥ2Υѥ᡼: P = 29, S = 20, Q = 2ȤȡΥͥ졼Ĺ~2^60ñΥե륵른ͥ졼ˤʤޤ
@end

// C2MRG3 -- long component based generator recommended for use.
@protocol C2MRG3gen <SimpleRandomGenerator, CREATABLE>
//S:  緿¿źƵͥ졼2Ĥ¿źƵLCGͥ졼η硣

//D: Ʊͥ졼Ȥ߹碌ȡñΥͥ졼Ūͥ줿򼨤ޤΥͥ졼ΥݡͥȤϡ줾2ĤΥǤʤ(ȡǤ)äƤޤϡۤʤ뷸(2^31-1, 2145483479)Ȥޤ
@end

// C3MWC -- long component based generator recommended for use.
@protocol C3MWCgen <SimpleRandomGenerator, CREATABLE>
//S: 緿夬ѥͥ졼

//D: 줾2Ĥ16-bit夬ѥͥ졼礷MWCͥ졼3ķ礷ͥ졼Ǥ
 
@end

// 
// XXX --
//   single short generator with splitting facilities.
//
//   (no generators in this class implemented.)
//
// @protocol XXXgen <SingleShortSplitGenerator, CREATABLE> @end

// 
// YYY --
//   single long generator with splitting facilities.
//
//   (no generators in this class implemented.)
//
// @protocol YYYgen <SingleLongSplitGenerator, CREATABLE> @end

@protocol C2LCGXgen <SplitRandomGenerator, CREATABLE>
//S: ʬեƥȤäͥ졼١ˤʷʥݡͥȡ侩ǡη緿ͥ졼2Ĥ(PMM)LGCͥ졼Ѥޤ

//D: ܿΤ른ͥ졼ǡΥХåܡ󥸥ͥ졼2Ĥ(PMM)LCGͥ졼Ȥ߹碌ΤǤϡۤ2^61(2.3e18)ǤA * V * W <= 2^60¤ȤơХåܡ󥸥ͥ졼μ(A)Ĥ'ۥͥ졼'ʬ䤷줾βۥͥ졼ĹW(V)Ĥ''˥褦˥åȤǤޤ
@end

// C4LCGX -- recommended short component based generator with splitting
@protocol C4LCGXgen  <SplitRandomGenerator, CREATABLE>
//S: 4Ĥ(PMM)LGCͥ졼Ȥä緿ͥ졼 
//D: 4Ĥ(PMM)LCGͥ졼礷Хåܡ󥸥ͥ졼Ȥäͥ졼ǡܿޤϡ(m1-1)(m2-1)(m3-1)(m4-1) / 8Ĥޤۤ2^121 (2.6e36)Ǥ
@end

// 
// ZZZ --
//   long component based generator with splitting facilities.
//
//   (no generators in this class implemented.)
//
// @protocol ZZZgen <CombinedLongSplitGenerator, CREATABLE> @end

// 
// ---------------------------------------------------------------
// @class definitions for implemented generators:
// 

// ----- <SimpleRandomGenerator> -----

// <SingleShortGenerator>

@class LCG1gen;
@class LCG2gen;
@class LCG3gen;
@class PMMLCG1gen;
@class PMMLCG2gen;
@class PMMLCG3gen;
@class PMMLCG4gen;
@class PMMLCG5gen;
@class PMMLCG6gen;
@class PMMLCG7gen;
@class PMMLCG8gen;
@class PMMLCG9gen;

// <SingleLongGenerator>

@class ACGgen;
@class SCGgen;
@class SWB1gen;
@class SWB2gen;
@class SWB3gen;
@class PSWBgen;
@class TT403gen;
@class TT775gen;
@class TT800gen;
@class MT19937gen;
@class MRG5gen;
@class MRG6gen;
@class MRG7gen;
@class MWCAgen;
@class MWCBgen;
@class RWC2gen;
@class RWC8gen;

// <CombinedShortGenerator>

@class C2TAUS1gen;
@class C2TAUS2gen;
@class C2TAUS3gen;

// <CombinedLongGenerator>

@class C2MRG3gen;
@class C3MWCgen;

// ----- <SplitRandomGenerator> -----

// <SingleShortSplitGenerator>

//   (none)

// <SingleLongSplitGenerator>

//   (none)

// <CombinedShortSplitGenerator>

@class C2LCGXgen;
@class C4LCGXgen;

// <CombinedLongSplitGenerator>

//   (none)

