// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

//S: ʬϥġ

//D: ʬϥ˴ϢġΥ饤֥Ǥͤ򥰥ղʬۤñɽġǤʤAverageEntropyΤ褦¬ġ󶡤Ƥޤ

#import <objectbase.h>
#import <simtoolsgui.h> // GUIComposite
#import <gui.h> // GraphElement

@protocol Averager <MessageProbe>
//S: ǡʿѤ׵ḵˤΥǡ󶡤ޤ

//D: Averager֥Ȥϡ֥ȤΥ쥯(̤ϥꥹ)(MessageProbeȤä)ͤɤ߹ߡ̤ޤ

CREATING
//M: probe뤳Ȥˤʤ륪֥ȤΥ쥯򥻥åȤޤ

- setCollection: aCollection;

- createEnd;

USING
//M: update᥽åɤϡ쥯̤Ƴƥ֥Ⱦǥ쥯ƤӽФޤ

- update;

//M: getAverage᥽åɤaveragerͤʿѤޤͤͤθĿϡʿͤ׻륪֥Ȥɤ߽Фޤ
- (double)getAverage;

//M: getTotal᥽åɤaveragerͤפޤͤϤ줬׵ᤵ뤿Ӥ׻ΤǤϤʤ֥Ȥɤ߽Фޤ
- (double)getTotal;

//M: getMin᥽åɤaveragerǾ֤ͤޤͤϤ줬׵ᤵ뤿Ӥ׻ΤǤϤʤ֥Ȥɤ߽Фޤ
- (double)getMin;

//M: getCount᥽åɤaveragerͤθĿ֤ޤ
- (unsigned)getCount;
@end

@protocol Entropy <MessageProbe>
//S: MessageProbeȤäƥȥԡ׻ޤ

//D: Entropy֥Ȥϡ(MessageProbe̤)֥ȤΥ쥯󤫤Ψɤ߹ߡ¸ߤʬۤΥȥԡ׻ޤ

CREATING
//M: setCollection᥽åɤϡprobe륪֥ȤΥ쥯򥻥åȤޤ
- setCollection: aCollection;

- createEnd;

USING
//M: update᥽åɤϡ쥯ɼ׻ƥȥԡ򹹿ޤΥ᥽åɤϡgetEntropyȤäƥǡ˥塼뤷ʤФʤޤ
- update;

//M: getEntropy᥽åɤϷ׻줿Entropy֤ޤȥԡͤϤ줬׵ᤵ뤿Ӥ׻ΤǤϤʤ֥Ȥɤ߽Фޤ
- (double)getEntropy;
@end

@protocol EZBin <GUIComposite>
//S: ڤʥҥȥ।󥿡ե

//D: EZBin饹ˤꡢ桼ϥ֥ȤΥ쥯ǡñ˥ҥȥಽǤޤˡΥ饹ϳǡɸṲ̄⤤Ĥޤ

CREATING
+ createBegin: aZone;

//M: setGraphics᥽åɤɽ֤򥻥åȤޤդ˥եɽɬפʤȤ0֤˥åȤƤǥեȤξ֤1ǡξǡϥɥ˥եåɽޤ
- setGraphics: (BOOL)state;

//M: setCollection᥽åɤϡҥȥΥǡΤɬפʥåȥ֥ȤΥ쥯򥻥åȤޤ
- setCollection: aCollection;

//M: setProbedSelector᥽åɤϡ(MessageProbeѾ줿)ǡ뤿ˡꤷ쥯Υ֥ȤŬѤ륻쥯򥻥åȤޤ
- setProbedSelector: (SEL)aSel;

//M: setFileOutput᥽åɤϥեI/Oξ֤򥻥åȤޤΥ󥹤ΥǡեꤿȤ1򥻥åȤƤǥեȾ֤0ǡξEZBinϥեI/O¹Ԥޤ
- setFileOutput: (BOOL)state;

//M: setTitle᥽åɤϥȥʸѤơEZBinΥեСΥեɥ˥٥Ĥޤꤷ٥ϥեɥκǾ˸ޤΥ᥽åɤطΤϡsetGraphics1˥åȤƤȤǤ
- setTitle: (const char *)title;

//M: setFileName᥽åɤϡǥեؤΥǡϤ˻Ѥե̾򥻥åȤޤåȤʤΥǥեȥե̾ϥեȥǤΥ᥽åɤطΤϡsetFileOutputξ֤1˥åȤƤȤǤ
- setFileName: (const char *)fileName;

//M: setAxisLabels:X:Y᥽åɤϡEZBinΥեСǺҥȥοʿ٥ȿľ٥򥻥åȤޤΥ᥽åɤطΤϡsetGraphicsξ֤1˥åȤƤȤǤ
- setAxisLabelsX: (const char *)xl Y: (const char *)yl;

//M: setMonoColorBars᥽åɤϡ٤Ƥñ쿧()ɽ뤫ꤷޤǥեȤǤ͡˿Ťޤ
- setMonoColorBars: (BOOL)mcb;

//M: setBinNum᥽åɤϡҥȥζֿ򥻥åȤޤ
- setBinNum: (int)theBinNum;

//M: setLowerBound᥽åɤϡҥȥϰϲ(ͤޤ)򥻥åȤޤ
- setLowerBound: (double)theMin;

//M: setUpperBound᥽åɤϡҥȥϰϾ(ͤޤޤʤ)򥻥åȤޤ
- setUpperBound: (double)theMax;

- createEnd;

USING

//M: Ĺߥ٥ɽͭη򥻥åȤޤ
- setPrecision: (unsigned)precision;

//M: ҥȥꥻåȤޤ
- reset;

//M: update᥽åɤϡ֥ȤΥ쥯ɼ׻ǡǽŪʥǡɲäޤƱ֥ȤΥ쥯򷫤֤פ뤳ȤǽǡξϽϤ˺ǽŪʥǡ˴ޤޤǡ̤äޤ
- update;

//M: ouputGraph᥽åɤϡupdateθƤӽФǳȤäƥեɽ򹹿ޤsetGraphics==0ξϲʤޤ
- outputGraph;

//M: outputToFile᥽åɤϡupdateθƤӽФǳǡȤäơҥȥζ֤ȤΥȥϥեޤsetFileOutput==0ξϲʤޤ
- outputToFile;

//M: output:᥽åɤϡ-outputGraph-outputToFileΥ礷ΤǤդιȥեϤμ¹٤ۤʤϤΥ᥽åɤǤʤ-outputGraph-outputToFileθƤӽФ򥹥塼뤷Ƥ
- output;

//M: getDistribution᥽åɤϡҥȥΥȥ֤Ȥ֤ޤ
- (int *)getDistribution;

//M: getCount᥽åɤϡҥȥϰ˴ޤޤ륨ȥޤ
- (unsigned)getCount;

//M: getOutliersϡҥȥϰϳˤ볰ͤθĿޤեɽ줿ҥȥ"o"򲡤ȡͤθĿǤʤҥȥϰ⳰ιץȥФѡȤɽޤ
- (int)getOutliers;

//M: getBinNum᥽åɤϡҥȥζֿޤ
- (int)getBinNum;

//M: getLowerBound᥽åɤϡҥȥϰϲ¤ޤ
- (double)getLowerBound;

//M: getUpperBound᥽åɤϡҥȥϰϾ¤ޤ
- (double)getUpperBound;

//M: getMin᥽åɤϡǡκǾͤޤ
- (double)getMin;

//M: getMax᥽åɤϡǡκͤޤ
- (double)getMax;

//M: getAverage᥽åɤϡǡʿͤޤͤϤ줬׵ᤵ뤿Ӥ׻ΤǤϤʤ֥Ȥɤ߽Фޤ
- (double)getAverage;

//M: getStd᥽åɤϡǡɸкޤͤϤ줬׵ᤵ뤿Ӥ׻ΤǤϤʤ֥Ȥɤ߽Фޤ
- (double)getStd;

//M: ҥȥ०åȤ֤ޤ
- (id <Histogram>)getHistogram;

//M: ȥʸ֤ޤ
- (const char *)getTitle;

//M:  ե̾ʸ֤ޤ
- (const char *)getFileName;
@end

@protocol EZDistribution <EZBin>
//S: ǡʬۤȤưEZBin

//D: ǡɸಽʬۤȤƽޤEZBinΥ֥饹ʤΤǡEZBin׻̤ϼǤޤۤˡʬۤΥȥԡҥȥγƶ֤бΨη׻ǽǤ
CREATING
- createEnd;

USING
//M: update᥽åɤϥҥȥγɼ׻ʬۤΥȥԡġζ֤бΨ򹹿ޤ
- update;

//M: output᥽åɤϡupdateθƤӽФǳȤäƥեɽ򹹿ޤեI/OͭǤ(setFileOutputξ֤1)줾ζ֤бΨϥե졢եɽͭǤ(setGraphicsξ֤1)ҥȥबޤ
- output;

//M: getProbabilities᥽åɤϡʬۤγƶ֤γΨɽdouble֤ޤ
- (double *)getProbabilities;

//M: getEntropy᥽åɤϡupdateθƤӽФǷ׻줿ʬۤΥȥԡ֤ޤ
- (double)getEntropy;
@end

@protocol EZGraph <GUIComposite>
//S: ڤ˥դ륯饹

//D: Υ饹ĴƤǥ̤͡Υդñ˺ޤޤEZGraph""(դ˸뤤Ĥ)Ƥ󥹤ñΥ֥Ȥ󶡤ǡ˴Ť뤤ϥåȥ֥ȤΥ쥯˴Ťꤷ쥯бޤEZGraphħȤƤϡAverager¾β̤Υ饹¿˻ȤȤʤưŪʿ͡סǾ͡͡ȤΥ󥹤Ǥ뤳Ȥ󤲤ޤ

CREATING
//M: setGraphics᥽åɤɽ֤򥻥åȤޤդ˥եɽɬפʤȤ0֤˥åȤƤǥեȤξ֤1ǡξǡϥɥ˥եåɽޤ
- setGraphics: (BOOL)state;

//M: setFileOutput᥽åɤϡեI/Oξ֤򥻥åȤޤΥ󥹤ΥǡեꤿȤ1򥻥åȤƤǥեȾ֤0ǡξEZGraph饹ϥեI/O¹Ԥޤ
- setFileOutput: (BOOL)state;

//M: setFileName᥽åɤϡǥեؤΥǡϤ˻Ѥե̾򥻥åȤޤǥåȤ̾ϡ줾Υǡ̾ƬͿޤΥ᥽åɤǥե̾åȤʤä硢󥹤Υե̾ˤϥ̾ǥեꤵޤΥ᥽åɤطΤϡseFileOutputξ֤1˥åȤƤȤǤ
- setFileName: (const char *)aFileName;

//M: setTitle᥽åɤϡȥʸѤEZGraphΥեСΥեɥ˥٥Ĥޤꤷ٥ϥեɥκǾ˸ޤΥ᥽åɤطΤϡsetGraphicsξ֤1˥åȤƤȤǤ
- setTitle: (const char *)aTitle;

//M: setAxisLabels:X:Y᥽åɤϡEZGraphΥեСǺҥȥοʿ٥ȿľ٥򥻥åȤޤΥ᥽åɤطΤϡsetGraphicsξ֤1˥åȤƤȤǤ
- setAxisLabelsX: (const char *)xl Y:(const char *)yl;

- createEnd;

USING
//M: դXͤϰϤꤷϰϤ˸ꤷޤ
- setRangesXMin: (double)xmin Max: (double)xmax;

//M: դYͤϰϤꤷϰϤ˸ꤷޤ
- setRangesYMin: (double)ymin Max: (double)ymax;

//M: ƥॹƥåפȥ뤵褦˥åȤ뤫뤤ϥץ򥻥åȤޤ
- setScaleModeX: (BOOL)xs Y: (BOOL)ys;

//M: getGraph᥽åɤȤȡ桼EZGraphŪդ˥ǤޤΥ᥽åɤطΤϡsetGraphicsξ֤1˥åȤƤȤǤ
- (id <Graph>)getGraph;

//M: createSequence᥽åɤϡ쥯aSeläȤ˥֥anObj֤ͤȤäEZGraphΥ󥹤ޤեI/OͭʤǡaNameȤե졢ʤaNameEZGraph륰եȤȤƻѤǤΥ᥽åɤͤϡ-dropSequenceǻȤȤˤʤidǤ
- createSequence: (const char *)aName
    withFeedFrom: anObj
     andSelector: (SEL)aSel;

//M: ñΥ֥ȤȤcreateSequenceȤоŪˡcreateAverageSequence᥽åɤϡ֥ȤΥ쥯ơ֥ȽΤȿʿͤ饷󥹤ޤΥ᥽åɤͤϡ-dropSequenceǻȤȤˤʤidǤ
- createAverageSequence: (const char *)aName 
           withFeedFrom: aCollection 
            andSelector: (SEL)aSel;

//M: ñΥ֥ȤȤcreateSequenceȤоŪˡcreateTotalSequence᥽åɤϡ֥ȤΥ쥯ơ֥ȽΤȿιͤ饷󥹤ޤΥ᥽åɤͤϡ-dropSequenceǻȤȤˤʤidǤ
- createTotalSequence: (const char *)aName
         withFeedFrom: aCollection 
          andSelector: (SEL)aSel;

//M: ñΥ֥ȤȤcreateSequenceȤоŪˡcreateMinSequence᥽åɤϡ֥ȤΥ쥯ơ֥ȽΤȿκǾͤ饷󥹤ޤΥ᥽åɤͤϡ-dropSequenceǻȤȤˤʤidǤ
- createMinSequence: (const char *)aName 
       withFeedFrom: aCollection 
        andSelector: (SEL)aSel;

//M: ñΥ֥ȤȤcreateSequenceȤоŪˡcreateMaxSequence᥽åɤϡ֥ȤΥ쥯ơ֥ȽΤȿκͤ饷󥹤ޤΥ᥽åɤͤϡ-dropSequenceǻȤȤˤʤidǤ
- createMaxSequence: (const char *)aName
       withFeedFrom: aCollection 
        andSelector: (SEL)aSel;

//M: ñΥ֥ȤȤcreateSequenceȤоŪˡcreateCountSequence᥽åɤϡ֥ȤΥ쥯ơ֥ȽΤȿΥȤ饷󥹤ޤΥ᥽åɤͤϡ-dropSequenceǻȤȤˤʤidǤ
- createCountSequence: (const char *)aName
         withFeedFrom: aCollection 
          andSelector: (SEL) aSel;

//M: dropSequence᥽åɤϡȤХ֥ȤϤ¸ߤʤȤäͳǡǡ(դ)ɥåפޤaSeqѥ᡼createSequence:᥽åɤΤɤ줫֤idǤʤФʤޤ󡣥ɥåפaSeq֤ꡢʤnil֤ޤ
- dropSequence: aSeq;  

//M: ȥʸ֤ޤ
- (const char *)getTitle;

//M: ե̾Υץեʸ֤ޤ
- (const char *)getFileName;

//M: -update᥽åɤȤȡߤ륷󥹤ϼΥǡͽޤAveragerǤʤñΥ֥Ȥ³Ƥ륷󥹤Ǥϡʤޤ
- update;

//M: outputGraph᥽åɤϡǸ-updateθƤӽФǳǡȤäƥդ򹹿ޤsetGraphics==0ξϡʤޤ
- outputGraph;

//M: outputToFile᥽åɤϡǸ-updateθƤӽФǳǡǥեޤsetFileOutput==0ξϡʤޤ
- outputToFile;

//M: stepϡ-update-outputGraph-outputToFile礷᥽åɤǤդιȥեϤμ¹٤ۤʤϤΥ᥽åɤǤʤ̤Υ᥽åɤ򤽤줾˥塼뤷Ƥ
- step;

@end

@protocol ActiveGraph <MessageProbe>
//S: SwarmGUIδ֤Ϣ³Ū˥ǡ򶡵뤷ޤ

//D: ActiveGraph֥ȤϡMessageProbe(ǡɤ߹)GraphGraphElementδ֤ǥǡζϤ򤷤ޤ줿ActiveGraphϡǡμʹ塢ºݤ˥եåؿ¹Ԥ褦˥塼뤵ޤΥ饹EZGraphѤΤǤEZGraphΤ褦ˤ줾˵ǽʬϥġ뤬ˤĤơɥ桼ľѤ뵡ϸäƤǤ礦
USING
//M: ˻Ѥ륰եȤ򥻥åȤޤ
- setElement: ge;

//M: ǡprobe륪֥Ȥ򥻥åȤޤ
- setDataFeed: d;

//M: probe¹Ԥƥ֥Ȥͤɤ߹ߡ򥰥եȤޤXͤϾ˸ߤΥߥ졼Yɤ߹ͤǤ
- step;
@end

@protocol ActiveOutFile <MessageProbe>
//S: ˥ե륹ȥ꡼򥢥ƥ֤˹륪֥ȡ

//D: ActiveGraphΥեI/OǤActiveOutFileǤΥ֥ȤΤϡOutFile֥ȡåȥ֥(ǡ)쥯Ǥϡ֥ȤǡФƥե뤿˻Ѥޤ
USING
//M: setFileObject:᥽åɤϡǡե륪֥Ȥ򥻥åȤޤ
- setFileObject: aFileObj;

//M: setDataFeed:᥽åɤϡǡprobe뤳Ȥˤʤ륪֥Ȥ򥻥åȤޤ 
- setDataFeed: d;

//M: step᥽åɤϡprobe¹Ԥƥ֥Ȥͤɤ߹ߡͤեޤ
- step;
@end

@protocol FunctionGraph
//S: ѿϰϤФƴؿåȡ
 
//D: FunctionGraph饹ActiveGraph˻ƤޤͤȻδطץåȤˡꤷxϰϤФͤץåȤޤޤƥƥå(ActiveGraphǤϻ)1ĤͤץåȤΤǤʤ`graph'᥽åɤƤӽФ뤿Ӥ˴ʥץ󥰤ԤޤĤޤꡢx = minX + n * stepSizeȤȤ[minX, maxX]Τ٤ƤxˤĤf(x) = y򥰥ղޤ

//D: 桼ꤹ٤ǤˤϡminXmaxXminXmaxX֤Υƥå׿᥽åɥ쥯(ղ뼰Фå)ޤ᥽åɥ쥯ϡ(BOOL) f: (double *) x : (double *) yȤν񼰤ǻꤷʤФʤޤ󡣥᥽åɤFALSE֤ȤϤxͤϥåפ졢ʳξy = f(x)ǤΤȲꤵƥץåȤоݤȤʤޤ

CREATING
+ createBegin: aZone;
- createEnd;

//M: ɬפʥåȤ򤹤٤ƥåȤʴؿǤ
- setElement         : (id <GraphElement>)e
          setDataFeed: f
  setFunctionSelector: (SEL)sel;

//M: ץåȤ˻ȤGraphElement򥻥åȤޤ
- setElement: (id <GraphElement>)graphElement;

//M: ؿ᥽åɤ륿åȤ򥻥åȤޤ
- setDataFeed: feed;

//M: ؿ᥽åɤ򥻥åȤޤ
- setFunctionSelector: (SEL)aSel;

//M: trueˤȡؿ᥽åɤͤη׻˼ԤȤ˷ٹȯޤ
- setArithmeticWarn: (BOOL)state;

//M: ͤ׻XͤϰϤȥƥå׿򥻥åȤޤ
- setXMin: (double)minx Max: (double)maxx Resolution: (int)steps;

//M: ͤ׻XͤϰϤȥƥåץ򥻥åȤޤ
- setXMin: (double)minx Max: (double)maxx StepSize: (double)size;

//M: եȤ򥯥ꥢ٤򥻥åȤޤ
- setResetFrequency: (unsigned)freq;

USING
//M: ߤΥեȤƤ򥰥դޤ
- graph;
@end

@class Averager;
@class Entropy;
@class EZBin;
@class EZDistribution;
@class EZGraph;
@class ActiveGraph;
@class ActiveOutFile;
@class FunctionGraph;
