// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:         defobj.h
Description:  standard objects for GNU Objective C extensions
Library:      defobj
*/

#import <defobj/deftype.h>

//S: GNU Objective Cĥɸ४֥

//D: defobjϡSwarmΤǻѤ륪֥Ȼظץߥ󥰤Υ
//D: 򥵥ݡȤޤdefobjΤϡ֥Ȥκ
//D: 졼γơ顼ǥХåݡȤȤäObjective C
//D: Ѥ뤿ȼΥǤ

@protocol Serialization
//S: ֥ȥꥢ饤ץȥ롣
//D: ֥ȥꥢ饤ץȥ롣

CREATING
//M: ɽΥɥѥ᡼ơΥѥ᡼
//M: ޤ
- lispInCreate: expr;

//M: HDF5֥ȤơΥѥ᡼ꤷޤ
- hdf5InCreate: hdf5Obj;

//F: Load an object from a lisp expression of the form
//F: (make-{class,instance} :arg1 x :arg y). 
extern id lispIn (id aZone, id expr);

//F: Load an object from a HDF5 object.
extern id hdf5In (id aZone, id hdf5Obj);

USING
//M: 󥹥ѿ̾/ͥڥΥꥹȤ顢֥Ȥξ֤Υ
//M: ֤줿Lispɽޤ
- lispIn: expr;

//M: ֥Ȥξ֤Lispɽ򡢥ȥ꡼ؽϤޤ
- lispOutShallow: stream;

//M: ֥Ȥξ֤οLispɽ򡢥ȥ꡼ؽϤޤ
- lispOutDeep: stream;

//M: HDF5֥Ȥ饤󥹥ѿɤޤ
- hdf5In: hdf5Obj;

//M: ֥Ȥξ֤HDF5ɽ򡢥ȥ꡼ؽϤޤ
- hdf5OutShallow: hdf5obj;

//M: ֥Ȥξ֤οHDF5ɽ򡢥ȥ꡼ؽϤޤ
- hdf5OutDeep: hdf5obj;

- updateArchiver;

//F: Expect and convert a boolean from next index item.
extern BOOL lispInBoolean (id index);

//F: Expect and convert an integer from next index item.
extern int lispInInteger (id index);

//F: Expect and convert a string from next index item.
extern const char *lispInString (id index);

//F: Expect and convert a keyword from next index item.
extern id lispInKeyword (id index);

@end

@protocol DefinedObject
//S: ȼĥ֥ȡ

//D: DefinedObjectϡdefobj饤֥Υ֥ȥץߥ󥰵§
//D: äȥåץ٥ΥѡפǤη줿å
//D: ϡε§˽֥ȤǼưŪѲǽȤʤͣΥ
//D: ǤäˡGNU Objective C󥿥Objectѡ饹
//D: åλѤȤƤϤޤ󡣤ʤʤ顢
//D: ֥ȤμΥåؤΥĤȤϸ
//D: ʤǤ

//D: DefinedObjectɬ׺¤ɸåޤŪǤ
//D: դˡǸġΥ֥ȤŬѤ롢뤤ŬѤʤå
//D: ¾ηǹԤޤ
USING
//M: getZoneåϡ֥Ȥ֤ޤ
- getZone;

//M: ֥Ȥselector˻ꤵ줿åƤС
//M: respondsTo:åtrue֤ޤåȤ
//M: Ȥϡå֥Ȥ줿ˡ餫Υ᥽åɤ
//M: ȤȤ˲᤮ޤ(Ǥ⤳Υ᥽åɤϥ顼ȯ
//M: ǽޤ)respondTo:åϥ᥽åɥǥѥåơ
//M: ֥ǤľܥååפˤäƼޤäơ̤Υ
//M: Τ®ϤޤäѤޤ󡣤륪֥Ȥη
//M: ΥåޤǤ뤫᤯ƥȤʤȤʤޤ
- (BOOL)respondsTo: (SEL)aSel;

+ (BOOL)conformsTo: (Protocol *)protocol;

//M: getClassϡ֥Ȥθߤο񤤤Ƥ륯饹֤
//M: 
- getClass;

//M: getTypeNameϡΥ֥ȤθȤʤ뷿֤̾ޤ
- (const char *)getTypeName;

//M: ֥Ȥѹ뤫ƥȤ뤿ӤΤ륪֥
//M: Ȥˡե󥹤ɲäޤ
- (ref_t)addRef: (notify_t)notifyFunction withArgument: (void *)arg;

//M: ֥Ȥؤγե󥹤ޤ
- (void)removeRef: (ref_t)refVal;

//M: Object᥽åɤΥʼ
- (int)compare: anObject;

//M: Object᥽åɤΥʼ
- perform: (SEL)aSel;

//M: Object᥽åɤΥʼ
- perform: (SEL)aSel with: anObject1;

//M: Object᥽åɤΥʼ
- perform: (SEL)aSel with: anObject1 with: anObj2;

//M: 3ĤΥ֥ȰȤäƥ쥯¹Ԥޤ
- perform: (SEL)aSel with: anObject1 with: anObj2 with: anObj3;

//M: ɽѤ⤷ϥǥХåѤΥ֥Ȥ̤̾Ȥơʸ
//M: Ƥޤ
- (void)setDisplayName: (const char *)displayName;

//M: ɽѤΥ֥Ȥ̤ʸ򡢰˳Ƥʸ
//M: ǥեȤμʸΤ줫֤ޤ
- (const char *)getDisplayName;

//M: describe:åϰȤϤ줿֥Ȥˡ֥
//M: ΥǥХåŪȤñץȤޤoutputCharStream
//M: Ϥ줿֥Ȥϡcollections饤֥String
//M: OutputStreamƤ褦ʡcatC:åʤ
//M: Фʤޤ󡣥֥ȷˤäƤϡӥȥ󤵤줿ǥեȤ
//M: ۤɲþޤ֥ȵʸ礬ޤ
//M: ǥեȤǤϡ饹֥̾Ȥɽ̾(⤷)˲äơ
//M: ֥idݥ󥿤16ͤץȤޤ
- (void)describe: outputCharStream;

//M: ӥȥ󤵤줿ǥեȤޤ1ԤʸoutputCharStream
//M: ˥ץȤޤ
- (void)describeID: outputCharStream;

//M: describe:ƱǤϤɸϤˤʤޤ
- (void)xprint;

//M: describeID:ƱǤϤɸϤˤʤޤ
- (void)xprintid;

//M: ǥХåϥȥ꡼ˡ쥯γƥФץȤ
//M: 
- (void)xfprint;

//M: ǥХåϥȥ꡼ˡ쥯γƥФidץȤޤ
- (void)xfprintid;
@end

@protocol Customize
//S: եΥޥ

//D: ˤäƤϡ󥹥󥹤ǤϤʤη
//D: οС򥫥ޥ뤿ˤΥå
//D: Ǥޤޥ뷿륪֥ȤϡΥ
//D: ޥ뷿줿å餫᥻åȤ줿
//D: ץĤȤˤʤޤƱץɬפȤ륪֥
//D: Ȥ¿Ȥϡޥ뷿ΥСäƤ
//D: η餵ʤ륤󥹥󥹤Ȥˡ̾ϴñǤ
//D: ®Ǥ

//D: ֥ȤΥޥǡꥸʥη֥Ȥѹ
//D: 뤳ȤϤޤ󡣤ˡޥǽȤ߹ޤ줿
//D: ֥Ȥޤ֥Ȥcreate:å
//D: ϡcreateBegin:createEndȤäƺƱå
//D: η֥Ȥ줿Τ褦ˡ󥹥󥹤
//D: ޤΥޥϡ󥹥󥹤createBegin:
//D: createEndåȤäƺΥå󥹤򤯤뤳
//D: ȤǤʤΤǤϤޤcreateBegincreateEndå
//D: ޤ

//D: ޥ줿ΥСǤ뤫ϡηȤμ
//D: ˡ˰¸ޤޥбƤʤ硢ηؤ
//D: customizeBegin:åϥ顼ˤʤޤ@protocol
//D: Ϥ٤ơ֥Ȥ뾯ʤȤ1Υ
//D: ޥ򥵥ݡȤΤȹͤ뤳ȤǤޤǤ˥ޥ
//D: 줿(customizeEnd֤)֥ȤʾΥ
//D: ޥ(⤦1ȤcustomizeBegin:/customizeEnd󥹤ˤ)
//D: 򥵥ݡȤ뤫ݤϡǽ˷ѾϤ᤿ꥸʥημˡ
//D: ¸ޤŪ˵ҤƤΤǤʤСʣΥ
//D: ޥ򥵥ݡȤȹͤƤϤޤ

CREATING
//E: newArrayType = [Array customizeBegin: aZone];
//E: [newArrayType setCount: 100];
//E: newArrayType = [newArrayType customizeEnd];
//E: array1 = [newArrayType create: aZone];
//E: array2 = [newArrayType create: aZone];
//E: // [array1 getCount][array2 getCount]ϡȤ100

//M: createBegin:Τ褦ʺΥå뤿ΰ֤ͤ
//M: 

//M: customizeBegin:Ϥ륾ϡǽŪʷ֥ȤΥ
//M: ȥ졼ݤ뤳Ȥˤʤ륾˰פޤΥϤη
//M: ˺륤󥹥󥹤ƱˤɬפϤޤ󡣤η
//M: 뺣createåˤϡ٤ƿϤ뤫
//M: Ǥ
+ customizeBegin: aZone;

//M: ꥸʥηΡޥ줿С֤ޤ
- customizeEnd;

//M: customizeCopy:åϡcustomizeBegin:֤֥
//M: οԡޤΰ֥ȤϤǤ˽Υ
//M: ޥ˱ƶͿʤޤޡ˥ޥԤΤ˻ѤǤ
//M: ĤޤꡢΥåϿʹΥޥʬơ⤦1
//M: κǽŪ˥ޥ줿֥Ȥ뤿˻Ѥޤ

//M: customizeCopy:ϡcustomizeBegin:֤֥Ȥ
//M: customizeEnd:Ǵ뤵ƤʤˤΤ߻ѤǤޤޥ
//M: 줿֥ȤοСϡcustomizeCopy:׵᤹
//M: zoneѤơꥸʥΥСƱ⤷ϰۤʤä
//M: ˳뤳ȤǤޤ

//E: newArrayType1 = [Array customizeBegin: aZone];
//E: [newArrayType1 setCount: 100];
//E: newArrayType2 = [newArrayType2 customizeCopy: aZone];
//E: [newArrayType2 setDefaultMember: UnsetMember];
//E:
//E: newArrayType1 = [newArrayType1 customizeEnd];
//E:  newArrayType2 = [newArrayType2 customizeEnd];
//E: array1 = [newArrayType1 create: aZone];  // DefaultMemberץʤ
//E: array2 = [newArrayType create: aZone];   // DefaultMemberץ󥻥å
- customizeCopy: aZone;
@end


@protocol Create <DefinedObject, Customize>
//S: ޥȤ(ץʥ)Υ󥹥󥹤ޤ

//D: Createѡפϡ֥Ȥ뤿ѥץ
//D: 󶡤ɸåޤΥåϡ1
//D: Υå˿Υ󥹥󥹤Ȥ뤤Ϻ
//D: ֥ȤѤǤ륪ץ򥫥ޥϢΥå
//D: 򤯤Ȥ˻ѤǤޤλͤΥ֥Ȥο
//D: ʬΥ뤳ȤǡŪʷġΥˡŬ뤿ι⤤
//D: ޤޤ

//D: createåϡƤ륯饹򱣤ˤäƼ
//D: ꡢ뤤ϥ֥Ȥ뤿ΰͤʥ󥿥եȤ
//D: ΥåѤƤ륯饹ˤäľŪ˼뤳Ȥ
//D: ǽǤ饹ľܼ硢Υ饹֥ȤϤθ
//D: ³٤ƤΥåҤˤƷ֥ȤȤΩޤ
//D: ʳξ硢֥Ȥ͡ǼǤޤȯ
//D: 줿åȤȤ«ޤ

//D: Createcreateå˲ä֥ȷ¾Ǥդ̾
//D: ƤӽФ§Τå򥵥ݡȤǤޤΥ
//D: ϡ¾ηε§˽äƼͳ˷ѾǤ뿷
//D: ֥Ȥ뤿ɸ᥽åɤޤʤ뵬§
//D: ̤ξǳΩޤɸŪˤĤƷå
//D: ǤĤΥƥåפ礷createå
//D: 礷ޤ

//D: createBegin:ޤcustomizeBegin:Τ줫֤٤Ƥΰ֥
//D: ȤϡgetZoneådropå򥵥ݡȤޤ
//D: Υåϡǽ󥹥󥹤Ǥ⥵ݡȤǤޤĤޤꡢ
//D: ΥåDrop졢̾Ϥ뷿ˤѾФơǽ
//D: 󥹥󥹤Ǥ줬Ǥ褦ˤʤޤηCreateˤϷѾ
//D: ޤ󡣤ʤʤ顢ˤΥåŬѤΤϡ֥
//D: ȤǤʤǽ󥹥󥹤ǤΥåϤȤ
//D: ƤʤƤ⡢֥ȤѤǤޤ֥
//D: Фdropåϡ䥫ޥǤ˳Ϥ줿塢
//D: ϤǽСפȽ˻ȤȤˤʤǤ礦

//D: createBegin:createEndåϡƤ륪֥ȤΥ
//D: ꤹϢΥå򤯤ޤ2ĤΥå
//D: ֤˥åϤळȤǡΥѥ᡼Ȥͤ򥻥åȤ
//D: ꡢѲǽʥåȤä¾ηλͤͿ뤳ȤǤޤ
//D: ġΥ֥ȷϡΰեĤ
//D: Υåޤ

//E: newArray = [Array createBegin: aZone];
//E: [newArray setInitialValue: aList];
//E: [newArray setDefaultMember: UnsetMember];
//E: [newArray setCount: [aList getCount] * 2 );
//E: newArray = [newArray createEnd];   // ! note reassignment of newArray

CREATING
//M: create:åϡǥեȤΥץä󥹥
//M: ޤzoneϿ֥ȤΤΥȥ졼
//M: ꤷޤΥå륪֥ȤϡǤ
//M: Ƥ륪֥ȤǤΥåǤ˺줿ηΥ
//M: 󥹥󥹤ǤϤʤ֥ȤΤΤˤΤ߼褦
//M: å+դΥ饹åȤޤ

//M: create:åϺ줿֥Ȥ֤ޤΥ
//M: Ȥϡη뤿򤵤줿륯饹Υ󥹥
//M: ǤgetClassåȤХ֥Ȥ뤿˷
//M: 饹Ǥޤ¾ˡǸƤӽФΥץफ
//M: Τ뤳ȤϤǤޤ󡣤ΥåȤäƥ֥Ȥ
//M: ƤȤƤӽФϤʤ륯饹̾⻲Ȥޤ󡣸Ƥӽ
//M: ȤΤϷ̾Ǥ̾Ϥɤ@protocolǤ⥰
//M: ХȤƼưŪȯԤޤ
+ create: aZone;

//M: createBegin:ϡΥåŪò֥
//M: Ȥ֤ޤ@protocol줿ΤǤС
//M: ΥåCREATINGޤSETTINGˤΤǤ
//M: ʳξϡιʸޡʤå
//M: Ȥͭʥåޤ
+ createBegin: aZone;

//M: createEnd åϡ줿֥Ȥͭʥץ
//M: ꤹץλޤ̤ˤΥå׵ᤵƤ륪
//M: ץͭǤꡢߤ礬Ƥ뤳Ȥǧ˰ȿ
//M: åХ顼ȯޤɸ२顼
//M: InvalidCombinationȯԤꥯȤȤ߹碌򼨤Ȥ
//M: Ǥޤ뤤¾ΤŪʥ顼ϥɥ󥰤Ѥ뤳Ȥ
//M: Ǥޤ

//M: ǽcreateBegin:ʹߡġΥꥯȤ䤽Ȥ߹碌٤
//M: ͭ˼Ĥ줿硢createEndϼä٤ƤΥꥯ
//M: Ȥ֥ȤκǽŪʷꤷΥ֥Ȥ֤
//M: ǽŪʥ֥Ȥ׵᤹뤢ɲåȥ졼ϡ
//M: createBegin˺ǽϤ줿Ʊ󤫤ޤ
//M: ֥ȤϡġΥꥯȤФ줿ɤμ
//M: ƤϤǤۤʤäꥯȤϡޤäۤʤä
//M: ֤Ǥ礦֤륪֥Ȥϡǽ֥Ȥθ
//M: ѤǤ褦줿å򥵥ݡȤ뤳Ȥݾڤ
//M: 뷿@protocolˤä줿硢Υå
//M: SETTINGޤUSINGΤ줫˸åǤ

//M: createEnd֤ͤƱˡcreateBegin:֤֥
//M: ȤidϤϤ亣ѤͭǤ뤫ݾڤޤ󡣤äơ
//M: Υ֥ȤϻȤʤǤidΤ褦ʥ֥Ȥݻ
//M: ѿˤϡcreateEnd֤idƳƤ뤳ȤǤޤ
//M: ˤꡢΥ֥ȤϢ³СƱѿݤ
//M: ޤ
- createEnd;

@end

@protocol Drop
//S: ˳Ƥ줿֥Ȥޤ

//D: DropѡפdropåޤdropϤΥ֥
//D: ȤϤ¸ߤ٤ȻȤʤȤ򼨤ɸåǤ
//D: drop¹Ԥ줿֥Ȥ򤳤θ˻Ȥ褦ȤСʤ餺
//D: 顼ȯޤΥ顼ͽ¬ǽʱƶĤϡǥХå
//D: å䤽¾ǤΥ٥ˤޤ

//M: dropåľŪʱƶϡΥ֥ȤΥȥ졼
//M: 뤿˻ѤΥ֥פ˰¸ޤ󷿤ˤäƤϡ
//M: dropå֥ȤΥȥ졼¨¤˲¾ŪǤ
//M: Υȥ졼ѤǤ褦ˤʤΤ⤢ޤʹߤλѤǤϡޤ
//M: Ʊ֤˿֥ȤƤΤǡdrop֥
//M: Ȥidȿ֥idƱˤʤޤ

//M: DropϡΥ󥹥󥹤Фdrop򥵥ݡȤ뷿ʤ顢ɤη
//M: ѾƤ⹽ޤdropåϥȥ졼β䥪֥
//M: Ȥ̵˲äΥ֥Ǽ졢뤤ϼƤ줿¾
//M: Υ꥽Ǥޤ줿٤ƤΥ֥Ȥ
//M: åפбƤȤϸ¤ޤ󡣤ޤ֥Ȥˤϡľ
//M: Ǥʤˤؤ餺ɥåפǽʤΤ¸ߤޤ¾Υڥ졼
//M: ѤȤƺ줿֥Ȥˤɥåפǽʤ
//M: Τꡢ¾¾Υ֥ȤȤΥ󥯤ˤäƺƤơñ
//M: ȤǤϥɥåפǤʤΤ¸ߤޤ뷿CreateDropΤ
//M: 줫⤷ξѾɸ।󥿡ե򥵥ݡ
//M: ơ֥ȤΥ饤եνޤ
USING
- (void)drop;
@end


//
// Miscellaneous operations for mixing into other types.
//

@protocol Copy
//S: ֥ȤΰȤ줿٤Ƥξ֤򥳥ԡޤ

//D: ԡ˺ݤơԡΥ֥ȤƤ˲ޤ뤫
//D: 뤿Υ֥ȷǤԡ륪֥Ȥȡԡ
//D: ݤ˻Ȥ륪֥Ȥ""ȤƲθ뤫Ȥǡ
//D: Хʥ롼Ϥޤ󡣤ĤޤꡢĤΥ֥ȥ饤֥
//D: ˸褦ʡԡ(shallow copy)俼ԡ(deep copy)
//D: Ȥ공ǰϤޤ󡣥ԡ塢Υ֥Ȥ黲Ȥ
//D: ¾ΥȤؤΥե󥹤֥Ȥ˻Ĥ⤢
//D: ޤ̤˿֥ȤϡΥ֥Ȥȶͭ
//D: ¸طǤ¤꾯ʤƤޤcopyå󶡤뤹
//D: ٤ƤΥ֥ȷϡԡ륪֥Ȥ˴ؤ롼򵭽
//D: ʤФʤޤ

//M: copyåϡΥ֥ȤƱͤƤ俶񤤤Ŀ
//M: ֥ȤޤΥ֥Ȥˤˤʤ
//M: ѹ⤦˱ƶʤ褦Υ֥ȤƤΩ
//M: ʣȤʤޤzoneˤϡ֥ȤФ륹ȥ졼
//M: ꤷޤcopyåͤϡ줿֥
//M: ȤidǤ
USING
- copy: aZone;
@end

@protocol GetName
//S: ѥƥȤǥ֥Ȥ̤뤿Υ֥̾
//S: ޤ

//D: ѥƥȤǥ֥Ȥ̤뤿Υ֥̾
//D: ޤ

//M: getNameåϡѥƥȤǥ֥Ȥ̤
//M: 뽪üʸ֤ޤꤵ줿ƥȤǥ֥Ȥ
//M: 졢ˡ̾ƤȡʹߤϤΥ֥
//M: ФƤΥåŪ˻ѤޤΤ褦ʥ֥
//M: ˤϡȤХץ饤֥ΰȤ줿֥
//M: Ȥ󤲤ޤΥåϡ֥Ȥ¸³֤̤
//M: Ƥб֤̾ߤƤꡢ䤨Ѳ
//M: ʥǡ֤ȤϤޤ
USING
+ (const char *)getName;
@end

@protocol GetOwner
//S: ֥Ȥ¸ߤ뤿ΰ¸ȤʤäƤ륪֥Ȥ
//S: 

//D: ͭؤϡʬȤ̩ñ롼ȤΥĥ꡼󤷤ޤͭ
//D: ؤΥȥåץ٥ΥΡɤϡ̾綠ΥʡȤnil֤ޤ
//D: ֥ȤñˤΥʡȤƤ̤Υ֥
//D: ΰȤƤߤʤ硢ʡ֥Ȥ򥳥ԡɥ
//D: פꤹȡΥХ֥Ȥ˥ԡޤϥɥåפ
//D: ޤʡȥФδطϡޤƻҴطȸƤФŪط
//D: ФƤǤġΥ֥ȷϡgetOwnerˤäƼ
//D: طΤʤФʤޤ

//M: getOwneråϡ֥ȤΥʡȤߤʤ̤Υ
//M: Ȥ֤ޤʡȤߤʤ뤫ϡ줾Υ֥
//M: ȷ˰¸ޤ륪֥ȤΰʬȤʤä
//M: 륪֥Ȥ䡢륪֥Ȥ¾Ū˥ȥ뤹륪
//M: ֥Ȥϡ구Ϥ礭ʥ֥ȤȤʤǤ礦ͭ¤
//M: ΩǽפʤΤϡ륪֥Ȥ¾ñΥ֥
//M: Ȥ򵿤ʤʡȤƻĤȤǤ
USING
- getOwner;
@end

@protocol SetInitialValue
//S: ¸Υ֥ȤνͤѤcreate

//D: SetInitialValueϡ֥ȤΰȤƳΩƤͤ
//D: ͤ˴ط͡ʥåޤäˤΥåϡ
//D: ͤ򥼥Ωƿ֥ȤΤǤʤ¸
//D: Υ֥Ȥͤ򥳥ԡ뤳ȤǴز뤿󶡤Ƥ
//D: copyåƱͤˡԡ٤Ȥߤʤ¸Υ֥
//D: ȤͤϡΥå󶡤Υ֥ȷˤä
//D: Τޤ

//D: ֥Ȥ˳ΩͤäƤȤϡ夳Υ֥
//D: ȤѤ֡ͤϰڹʤȤƤȤ
//D: ƤǤޤˤäƤʤθΨ¸ޤͤι
//D: ¤뤳Ȥ"꡼ɥ꡼"¤ɽޤηϡǤդ
//D: ͤ˥꡼ɥ꡼å󶡤ޤ֥
//D: ˤϡ֥Ȥ줿Ǥ꡼ɥ꡼°ɲä
//D: ǽʤΤ⤢ޤ

CREATING
//M: setInitialValue:åΰˤϡ륪֥Ȥ
//M: ͤ٤̤Υ֥ȤꤷޤcopyåȤϰ㤤
//M: ͤΥȤƻѤ륪֥Ȥϡ뿷֥
//M: ȤȰۤʤäǤ⹽ޤ󡣸ġΥ֥ȷϡ줬
//M: ĤͤΥ֥Ȥη򡢤Τ褦ͤŬѤ뤢
//M: ѴޤϲˡȤȤޤ
- (void)setInitialValue: initialValue;
@end


@protocol Symbol <Create, GetName, CREATABLE>
//S: ƤʥХidȤ륪֥ȡ

//D: SymbolϡѹǤʤ̾Ȥäƺ줿֥ȤǤΥ
//D: ֥Ȥˤϡꤵ줿̾ʳ˿񤤤Ϥ
//D: ޤ̾SymbolϡХ̾˳Ƥˡid
//D: Τ˻Ѥޤ̾ϡХ륪֥
//D: ο侩§˽äʸɽƤꡢĤΥ饤֥Ǥ
//D: åͤˤͤΥɡ뤤ϥե饰Ȥ
//D: ѤƤޤ

//D: ̾亮ܥϡ줬Ƥ줿Хid˥ޥåʸ
//D: ̾Ȥäƺޤʸ塢ΥХץϡ
//D: 켫ȤκǾ٥εҤ򥪥֥ȤȤ󶡤뤳ȤǤޤ
//D: SymbolΥ֥פ̾դХidδäĥơ
//D: ܺ٤ʥݡͥȤΥХΩ뤳ȤǤޤ

//D: ܥɸCreateåǺǤޤǥեͤϤ
//D: ᡢܥˤϤʤ餺ʸ̾ꤹɬ
//D: פޤSymbolϥܥ֤̾getNameåѾޤ

CREATING
//M: create:setName:ϡƤӽФΤå
//M: Ǥå§˴ؤ륵ޥϡåΥ
//M: 򻲾ȤƤ
+ create: aZone setName: (const char *)name;
@end

@protocol EventType <Symbol>
//S: ץμ¹˸Ф줿򼨤ݡȡ

//D: ץμ¹˸Ф줿򼨤ݡȡ

USING
//M: ͤʤǡ٥ȤΥܥ뷿ȯޤ
- (void)raiseEvent;

//M: եޥåʸȰȤͤʤǡ٥ȤΥܥ뷿
//M: ȯޤ
- (void)raiseEvent: (const void *)eventData, ...;
@end

@protocol Warning <EventType, CREATABLE>
//S: ץ೫ȯԤؿʾ

//D: ץ೫ȯԤؿʾ

USING
//M: ηٹ˥åʸϢդޤ
- (void)setMessageString: (const char *)messageString;

//M: ηٹ˴ϢդƤå֤ޤ
- (const char *)getMessageString;

extern id <Warning>
  WarningMessage,         //G: Υåٹޤ
  ResourceAvailability,   //G: 󥿥ĶΥ꥽̵Ǥ
  LibraryUsage,           //G: 饤֥ꥤ󥿡եλѰȿǤ
  DefaultAssumed,         //G: ǥեȤѤޤ
  ObsoleteFeature,        //G: Ū˺뵡ǽѤޤ
  ObsoleteMessage;        //G: Ū˺åѤޤ

@end

@protocol Error <Warning, CREATABLE>
//S: ʤ¹Ԥ˸֡

//D: ʤ¹Ԥ˸֡

extern id <Error> 
  SourceMessage,        //G: Υå顼ޤ
  NotImplemented,       //G: ׵ᤵ줿񤤤ϡ֥Ȥ˼Ƥޤ
  SubclassMustImplement,//G: ׵ᤵ줿񤤤ϡ֥饹¦Ǽɬפޤ
  InvalidCombination,   //G: ѤsetåȤ߹碌̵Ǥ
  InvalidOperation,     //G: ¦θߤξ֤ڥ졼бƤޤ
  InvalidArgument,      //G: ̵ͤǤ
  CreateSubclassing,    //G: Create֥饹Υե졼ޤ
  CreateUsage,          //G: CreateץȥåΥ󥹤äƤޤ
  OutOfMemory,          //G: Ƥ꤬ޤ
  InvalidAllocSize,     //G: Ƥ꤬ޤ
  InternalError,        //G: ץͽʤ֤ȯޤ
  BlockedObjectAlloc,   //G: ̵ʳƤObjectΥ᥽åɡ
  BlockedObjectUsage,   //G: Objectѡ饹Ѿ줿᥽åɡ
  ProtocolViolation,    //G: ׵ᤵ줿ץȥ˥֥ȤбƤޤ
  LoadError,            //G: ꥽˥Ǥޤ
  SaveError;            //G: ꥽¸Ǥޤ

@end


//#: ΥʸȤäƷٹ䥨顼ȯޥ
#define raiseEvent( eventType, formatString, args... ) \
[eventType raiseEvent: \
"\r" __FUNCTION__, __FILE__, __LINE__, formatString , ## args]

@protocol Zone <Create, Drop, CREATABLE>
//S: ȥ졼ƤΥ⥸塼ñ̡

//D: ϡ֥Ȥ䤽¾˳ƤǡѤΥȥ졼
//D: Ǥ֥ȤȡϤΥ󥹥
//D: ¾ǡˤĤơɤΥȥ졼餽줬뤫ǧ
//D: ɬפޤץȤСʣΥΩơ
//D: 褦¸³֤뤤ϻ褦ʥȥ졼ɬ׾ĥ֥
//D: Ȥְ㤤ʤƱȤ˳Ƥ褦ˤꡢȥ졼
//D: ƤѤŬ뤳ȤǤޤ

//D: ZoneϤޤΥ˳ƤƤ뤹٤ƤΥ֥ȤΥ
//D: 쥯ޤΥ쥯ϥ"콸"ȤƤФ
//D: 뽸ǡǺƤޤɥåפƤʤ֥Ȥ
//D: ٤ƥ쥯˴ޤޤޤ쥯ϥ˼ưŪ˴
//D: 뤿ᡢ֥Ȥ콸ΤΥȥåݻɬפΤ륢
//D: ꥱǤ⡢쥯̤˴ɬפϤޤ󡣳
//D: Ƥ줿֥ȤΥ쥯Ǥϡ֥ȥ꡼
//D: ֥ȥȥ졼ưȥ졼ؤΥݡȤ󶡤ޤ

//D: ϥ֥ȤΥȥ졼ǤʤCmallocؿ󶡤
//D: 褦Υȥ졼֥åǤޤ륾˳Ƥ
//D: ֥Ȥ䥹ȥ졼֥åϡ٤ƤΥФƥ
//D: ʤޤޤǤĤޤꡢ¾Υ˥ȥ졼ƤƤ⡢ġ
//D: Υȥ졼γƸΨ˱ƶϤޤ󡣤ۤȤɤΥ
//D: 󷿤Ǥϡ륾ǤθġγƤϼͳǡιץȥ졼
//D: ̤ɬ׾˱ޤƤϤ줾Ǥ
//D: Τɥåפ뤳ȤǤޤɥåפȡ
//D: 줿٤ƤγƤϼưŪ˲졢ƱˡƤ줿
//D: ֥ȤǥɥåפɬפʤΤˤĤƤǽŪʥɥå׽
//D: ޤΤβϡˤ륪֥Ȥ11Ĳ
//D: Ƥꤺäȹ®Ǥ

//D: Zoneϴ˼줿ǡ֥Ȥ䤽¾γƤ줿
//D: ȥ졼ФơǥեȤΥȥ졼ݡȤ󶡤ޤ
//D: ηϤޤ̤ʾѤ뤿إݥꥷ¾Υ
//D: ΥѡפǤ⤢ޤ

//D: ¾Υ֥ȤƱ͡ɸcreateåѤƺ
//D: 뤳ȤǤޤĤޤꡢzoneϤΥȥ졼븵Ȥʤ¾
//D: ΥꤷʤФʤޤ󡣥ȥ졼ϥڡȸƤФ礭
//D: ñ̤Ǵ¸Υ󤫤졢ŪʳƵǽ򥵥ݡ
//D: 뤿˥륾ˤäƴޤDropgetZoneå
//D: ϡΥ١ڡ󶡤륾֤ޤ

//D: Ͼ˴¸Υǧɬפ뤿ᡢ¸
//D: Ƥʤ¤꿷뤳ȤϤǤޤ󡣤Τ褦ʥ
//D: ΤΤĤdefobj饤֥ΰȤƤ餫
//D: ޤޥˤĤƤϴΥ򻲾ȤƤ

CREATING
//M: PageSizeϡŪʳƤڡΥꤷ
//M: ޤǥեȤǤϡޥΥƥŬڡ
//M: (餯4K)ǤΥǥեȤ򥪡С饤ɤΤϡˤ
//M: üʾǥȥ졼ƤĴʤФʤʤ˸¤٤
//M: Ǥ礦Ǥγƿϥڡ¤ޤ󡣤
//M: ΤϡڡĶꥯȤϡΥ󤬳Ƥ
//M: Ƥ륪ʡΥϤ뤫Ǥ
- (void)setPageSize: (int)pageSize;

USING
- getReclaimPolicy;
- (BOOL)getStackedSubzones;
- (int)getPageSize;

//M: allocIVars:ϡ֥Ȥ˥󥹥ѿ¤Τ
//M: ޤι¤Τκǽ1ñϡȤϤ줿饹id˥å
//M: ޤΥ饹ϤޤƤ빽¤ΤΥꤷޤ
//M: ι¤ΤλĤƤϥХʥ0ͤ˽ޤ
- allocIVars: aClass;

//M: copyIVars:ϡ륾˿Ƥ줿ȥ졼ˡ¸
//M: Υ󥹥ѿ¤ΤΥԡޤ¸Υ󥹥ѿ
//M: ¤ΤϤɤΥˤäƤ⹽ޤ󤬡¤ΤΥ
//M: κǽ1ñΥ饹ݥ󥿤ޤǤʤФʤޤ
- copyIVars: anObject;

//M: freeIVars:ϡ֥ȤΥ󥹥ѿ¤Τ¸뤿˳
//M: Ƥ줿ȥ졼ޤ֥Ȥκǽ1ñϡ
//M: ¤ΤΥҤ饹ݥ󥿤ǤʤФʤޤ
//M: allocIVars:copyIVars:Ƥȥ졼ϡfreeIVars:Ǥʤ
//M: вǤޤ󡣤ޤfreeIVars:ϤΥåΤɤ줫
//M: Ƥȥ졼뤿ˤѤǤޤ
- (void)freeIVars: anObject;

//M: ϳơԡ뤿ΥåǤ

//M: Υåϡ֥ȤΥ󥹥ѿ¸륹ȥ졼
//M: Ƥޤ֥Ȥϥ콸Ĥ˴ޤޤʤ
//M: ݡͥȤȤƳƤޤѤΤϡ¾Υ֥
//M: ȤμΰȤɲå֥ȤƤ륯饹ȡ
//M: ٥륪֥Ȥ餳Υȥ졼Υޥåԥ󥰤̤˥ȥ뤹
//M: 륯饹Ǥ
- allocIVarsComponent: aClass;

//M: allocateIVarsComponentȤۤȤƱǤ֥ȤΥ󥹥
//M: ѿ¸Ƥ륹ȥ졼򥳥ԡޤ
- copyIVarsComponent: anObject;

//M: ֥ȤΥ󥹥ѿȥ졼ޤ
- (void)freeIVarsComponent: anObject;

//M: ̤˸¤Ϳ줿СΥ֤ޤΥϡ
//M: allocIVars:copyIVars:ˤäƳƤ줿Τޤߡݡ
//M: ͥȤθ¤ĤΥ֥Ȥ٤ƤưŪ˳Ƥޤ
//M: ̤ʸ¤ĥcreate:createBegin:å˰Ȥ
//M: Ϥȡݡͥȥ֥ȤȤƿ֥Ȥ
//M: ޤ
- getComponentZone;

//M: alloc:Ͽȥ졼֥åƤåǡC饤֥
//M: mallocؿˤ褯Ƥޤȥ졼ϡΥޥΥ
//M: ƥǤΡ٤ƤΥǡФǤ⸷̩׵˽ä
//M: 󤷤ޤȥ졼Τͤǽ뤳ȤϤޤ
- (void *)alloc: (size_t)size;

//M: free:alloc:ǳƤ줿ȥ졼֥åޤalloc:
//M: ϺǽγƽǤΥ֥åΥ¸뤿ᡢfree:ΰ
//M: ˥֥åϤޤfree:alloc:ǳƤ줿֥
//M: ФƤΤ߻ѤƤ¾alloc:Ƥ֥åϡ
//M: free:ǤΤ߲Ǥޤ
- (void)free: (void *)aBlock;

//M: allocBlock:ϡalloc:˻ȥ졼֥å򿷤˳Ƥޤ
//M: ֥åȤƤ줿֥åΥ
//M: Ϥɬפޤ
- (void *)allocBlock: (size_t)size;

//M: freeBlock:blockSize:ϡallocBlock:Ƥ֥å뤿
//M: ˻ѤǤޤ
- (void)freeBlock: (void *)aBlock blockSize: (size_t)size;

//M: getPopulationϡallocIVars:ޤcopyIVars:ˤäƥ˳
//M: 졢ޤfreeIVars:ǲƤϤʤ٤ƤΥ֥ȤΥ쥯
//M: ֤ޤObjectCollectionץfalseξ硢
//M: getObjectsnil֤ޤ֤륳쥯ϡcollections饤
//M: Ƥ褦OrderedSetޤ(ReadOnlyץ
//M: trueIndexSafetyץSafeAlways)Υ쥯Υ
//M: ϡ֥ȤƤ줿ȤѹƤ⹽ޤ
//M: 󤬡쥯ľɲáƤϤޤ
- getPopulation;

//M: containsAlloc:ϡġγƤ륾䤽Υ󤫤饹
//M: 졼ˤäƤʤ줿ΤȽꤷޤݥ󥿰
//M: ϡäǤդΥ󤬹ԤäƤؤƤʤФʤޤ
//M: 󡣤Υȥ졼륾䤽Υ֥󤫤Ƥ줿
//M: ΤǤСåtrue֤ޤ
- (BOOL)containsAlloc: (void *)alloc;

//M: 콸ĤΤ줾ΥФˡǥХåεҤޤ
- (void)describeForEach: outputCharStream;

//M: 콸ĤΤ줾ΥФˡǥХåidεҤޤ
- (void)describeForEachID: outputCharStream;

//G: ReclaimPolicyץΥܥ
extern id <Symbol>  ReclaimImmediate, ReclaimDeferred,
                    ReclaimFrontierInternal, ReclaimInternal, ReclaimFrontier;

@end

@protocol DefinedClass <DefinedObject, GetName>
//S: Υ󥿡ե륯饹

//D: Υ󥿡ե륯饹
USING
+ getSuperclass;
+ (BOOL)isSubclass: aClass;

+ (void)setTypeImplemented: aType;
+ getTypeImplemented;

+ (IMP)getMethodFor: (SEL)aSel;
@end

@protocol CreatedClass <Create, DefinedClass>
//S: ¹Իѿ᥽åɤĥ饹

//D: ¹Իѿ᥽åɤĥ饹

CREATING
- setName: (const char *)name;
- setClass: aClass;
- setSuperclass: aClass;
- setDefiningClass: aClass;
- at: (SEL)aSel addMethod: (IMP)aMethod;
- lispInCreate: expr;
- hdf5InCreate: hdf5Obj;
- lispOutShallow: stream;
- hdf5OutShallow: hdf5Obj;
- updateArchiver;
extern id createType (id aZone, const char *name);
extern Class copyClass (Class class);
extern void addVariable (Class class, const char *name, const char *type);
USING
- getDefiningClass;
@end

@protocol BehaviorPhase <CreatedClass>
//S: ֥Ȥο񤤤Υե뤿˺륯饹

//D: ֥Ȥο񤤤Υե뤿˺륯饹

CREATING
- (void)setNextPhase: aClass;

USING
- getNextPhase;
@end

@protocol Arguments <Create, Drop, CREATABLE>
//S: ޥǽʥޥɥ饤ΰϥݡȤ󶡤륯饹

//D: ޥǽʥޥɥ饤ΰϥݡȤ󶡤륯饹

//E: ȤС`protocol'ȤɸΥޥɥꥹȤɲä
//E: ޤ礦Ĥޤꡢޥɥ饤--helpϤݤ˰ʲΤ褦ɽ
//E: 褦ˤȤޤ
//E: ------------------------
//E: mgd@wijiji[/opt/src/mgd/src/mySwarmApp] $ ./mySwarmApp --help
//E: Usage: mySwarmApp [OPTION...]
//E: 
//E:   -s, --varyseed             Run with a ramdom seed -ॷɤǼ¹
//E:   -b, --batch                Run in batch mode -Хå⡼ɤǼ¹
//E:   -m, --mode=MODE            Specify mode of use (for archiving) -(֤Ф)Ѥ⡼ɤ
//E:   -p, --protocol=PROTOCOL    Set protocol -ץȥ
//E:   -?, --help                 Give this help list -ΥإץꥹȤ
//E:       --usage                Give a short usage message -ˡʷ˼
//E:   -V, --version              Print program version -ץСץ
//E: 
//E: Mandatory or optional arguments to long options are also mandatory or
//E: optional for any corresponding short options.
//E: -- ĹɽΥץФɬܤ뤤ϥץʥΰϡ
//E:    бûץǤƱͤǤɬפޤ
//E: 
//E: Report bugs to bug-swarm@santafe.edu.
//E: -- ХݡȤbug-swarm@santafe.eduäƤ
//E: -----------------------
//E: 
//E: ˤϡʲΤ褦ˡʤȤΥ֥饹Arguments
//E: ɬפޤ
//E: 
//E: #import <defobj/Arguments.h>
//E: 
//E: @interface MySwarmAppArguments: Arguments_c
//E: {
//E:   const char *protocolArg;
//E: }
//E: - (const char *)getProtocolArg;
//E: @end
//E: 
//E: @implementation MySwarmAppArguments
//E: 
//E: + createBegin: aZone
//E: {
//E:   static struct argp_option options[] = {
//E:     {"protocol", 'p', "PROTOCOL", 0, "Set protocol", 3},
//E:     { 0 }
//E:   };
//E:   
//E:   MySwarmAppArguments *obj = [super createBegin: aZone];
//E: 
//E:   [obj addOptions: options];
//E:   return obj;
//E: }
//E: 
//E: - (int)parseKey: (int)key arg: (const char *)arg
//E: {
//E:   if (key == 'p')
//E:     {
//E:       protocolArg = arg;
//E:       return 0;
//E:     }
//E:   else
//E:     return [super parseKey: key arg: arg];
//E: }
//E: 
//E: - (const char *)getProtocolArg
//E: {
//E:   return protocolArg;
//E: }
//E: 
//E: @end
//E:
//E: ºݤmain.mץफ¹Ԥ뤿ˤϡʲΤ褦ˤޤ
//E:
//E: int 
//E: main (int argc, const char ** argv) 
//E: {
//E:   initSwarmArguments (argc, argv, [MySwarmAppArguments class]);
//E:   
//E:   // Ĥ̤ - buildObjects:, - buildActions:, - activateIn: θƤӽФ
//E:   
//E:   return 0;					  
//E: }

CREATING
+ createBegin: aZone;
- createEnd;

- setArgc: (int)argc Argv: (const char **)argv;
- setAppModeString: (const char *)appModeString;
- setOptionFunc: (int (*) (int, const char *))optionFunc;
- setBugAddress: (const char *)bugAddress;
- setVersion: (const char *)version;
- setInhibitArchiverLoadFlag: (BOOL)inhibitArchiverLoadFlag;
- addOptions: (struct argp_option *)options;

+ createArgc: (int)argc Argv: (const char **)argv version: (const char *)version bugAddress: (const char *)bugAddress options: (struct argp_option *)options optionFunc: (int (*) (int, const char *))optionFunc;

//M: ʲξޤ४ץǤޤ

//M: - ץͤ̾Ρ

//M: - ץΥϰǽǤФΥץαѻ1ʸ
//M: 򼨤ǤȤ`p'`--protocol'ɽۤʤƱ
//M: ץǡԤϳФ䤹ԤǤ

//M: - NULLǤʤСΥץ󤬰(ξϥץȥ̾)ɬ
//M: Ȥ뤳Ȥ򼨤٥롣

//M: - ΥץβϤȲĻѹե饰

//M: - Υץ

//M: - إץ꡼ǤΥץа֡

//M: Υ᥽åɤȯƥץ˸ƤӽФޤ
- (int)parseKey: (int)key arg: (const char *)arg;

SETTING
- setArgc: (int)theArgc Argv: (const char **)theArgv;
- setAppName: (const char *)appName;
- setAppModeString: (const char *)appModeString;
- setBatchModeFlag: (BOOL)batchModeFlag;
- setVarySeedFlag: (BOOL)varySeedFlag;
//M: SwarmΥ󥹥ȡ꤬狼ʤΡե졼
//M: ؤΥǥեȥѥꤷޤǥեȤϥȥǥ쥯
//M: Ǥ
- setDefaultAppConfigPath: (const char *)path;
//M: SwarmΥ󥹥ȡ꤬狼ʤΡǡեؤΥǥե
//M: ȥѥꤷޤǥեȤϥȥǥ쥯ȥǤ
- setDefaultAppDataPath: (const char *)path;

USING
- (BOOL)getBatchModeFlag;
- (BOOL)getVarySeedFlag;
- (const char *)getAppName;
- (const char *)getAppModeString;
- (int)getArgc;
- (const char **)getArgv;
- (const char *)getExecutablePath;
- (const char *)getSwarmHome;
- (const char *)getConfigPath;
- (const char *)getDataPath;
//M: ץꥱͭΥǡե뤬ĤȴԤѥ̾
- (const char *)getAppDataPath;
//M: ץꥱͭΥե졼ե뤬Ĥȴ
//M: ѥ̾
- (const char *)getAppConfigPath;
- (BOOL)getShowCurrentTimeFlag;
- (BOOL)getInhibitArchiverLoadFlag;
@end

@protocol Archiver <Create, Drop, CREATABLE>
//S: ٥롦ꥢ饤󥤥󥿡ե
//D: ٥롦ꥢ饤󥤥󥿡ե
CREATING
+ createBegin: aZone;
- setInhibitLoadFlag: (BOOL)inhibitLoadFlag;
- setHDF5Flag: (BOOL)hdf5Flag;
- setPath: (const char *)path;
- setDefaultLispPath;
- setDefaultHDF5Path;
- createEnd;
USING
- registerClient: client;
- unregisterClient: client;
- putDeep: (const char *)key object: object;
- putShallow: (const char *)key object: object;
- getObject: (const char *)key;
- save;
@end

@protocol HDF5 <Create, Drop, CREATABLE>
//S: HDF5󥿡ե
//D: HDF5󥿡ե
CREATING
+ createBegin: aZone;
- setCreateFlag: (BOOL)createFlag;
- setDatasetFlag: (BOOL)datasetFlag;
- setParent: parent;
- setName: (const char *)name;
- setCompoundType: compoundType;
- setCount: (unsigned)count;
- createEnd;
SETTING
- setBaseTypeObject: baseTypeObject;
USING
- iterate: (int (*) (id hdf5Obj))iterateFunc;
- (BOOL)getDatasetFlag;
- (const char *)getName;
- (unsigned)getCount;
- getCompoundType;
- getClass;

- (BOOL)checkName: (const char *)groupName;
- loadDataset: (void *)ptr;
- storeAsDataset: (const char *)name typeName: (const char *)typeName type: (const char *)type ptr: (void *)ptr;
- storeTypeName: (const char *)typeName;
- storeComponentTypeName: (const char *)typeName;
- shallowLoadObject: obj;
- shallowStoreObject: obj;
- nameRecord: (unsigned)recordNumber name: (const char *)recordName;
- numberRecord: (unsigned)recordNumber;
- selectRecord: (unsigned)recordNumber;

- (const char **)readRowNames;
- writeRowNames;

- storeAttribute: (const char *)attributeName value: (const char *)valueString;
- iterateAttributes: (int (*) (const char *key, const char *value))iterateFunc;
- (const char *)getAttribute: (const char *)attributeName;

- (void)drop;
@end

@protocol HDF5CompoundType <Create, Drop, CREATABLE>
//S: HDF5ʣ祤󥿡ե
//D: HDF5ʣ祤󥿡ե
CREATING
+ createBegin: aZone;
- setClass: class;
- createEnd;
USING
- getClass;
@end

//G: 󥰥ȥArguments֥ȡ
extern id arguments;

//G: 󥰥ȥHDF5 Archiver֥ȡ
extern id hdf5Archiver;

//G: 󥰥ȥLisp Archiver֥ȡ
extern id lispArchiver;

//G: ƥ֥åδηǥץ
extern id <Symbol> t_ByteArray, t_LeafObject, t_PopulationObject;

//#: @selector()ά
#define M(messageName) @selector (messageName)

#ifndef PTRFMT
#if 0
//#: ХȿȤƤΥݥ󥿥
#ifndef PTRSIZE
#define PTRSIZE 4
#endif
#if PTRSIZE == 4
#define PTRFMT "%0#8lx"
#else
#define PTRFMT "%0#16lx"
#endif
#endif
//#: ݥ󥿤ɽ뤿printfΥեޥå
#define PTRFMT "%p"
#endif


//F: ɸեޥåȤǥ֥idʸȯؿ(󶡤Ƥ
//F: Хåեϡǹ78ʸޤǼƲǽǤ)
extern void _obj_formatIDString (char *buffer, id anObject);

//F: ѥ饨顼򵯤ˡåԤ@classѤǤ
//F: 褦ˤ뤿
extern Class objc_get_class (const char *name);  // for class id lookup 

//F: defobjΥ֥Ȥ򥪥֥̾Ǹޤ
extern id defobj_lookup_type (const char *name);

//
// type objects generated for module
//
#import <defobj/types.h>


//F: ץꥱ󡢥Arguments饹ץʥ(ޤ
//F: NULL)ɲåץw/ؿȤädefobjޤ
extern void initDefobj (int argc,
                        const char **argv, 
                        const char *version,
                        const char *bugAddress,
                        Class argumentsClass,
                        struct argp_option *options,
                        int (*optionFunc) (int key, const char *arg));

//F: ⥸塼ؿ
extern void _obj_initModule (void *module);

//#: ⥸塼ޥ
#define initModule(module) _obj_initModule(_##module##_)

//G: globalZoneޥѿ
extern id _obj_globalZone;   

//G: scratchZoneޥѿ
extern id _obj_scratchZone; 

//#: Х륪֥ȤƤ뤿Υ
#define globalZone _obj_globalZone

//#: ֥ȤƤ뤿Υ
#define scratchZone _obj_scratchZone

#ifndef _obj_debug
//G: trueǤФ٤ƤΥǥХå顼åԤޤ
extern BOOL _obj_debug;   
#endif

//G: 顼åѽϥե
extern FILE *_obj_xerror;  
//G: ǥХååѽϥե
extern FILE *_obj_xdebug;  

//F: ǥץ쥤̾򥻥åȤޤ
extern void xsetname (id anObject, const char *name); 

//F: ǥХåϥȥ꡼ˡ֥ȤεҤץȤޤ
extern void xprint (id anObject);                

//F: ǥХåϥȥ꡼ˡ֥ȤidʸץȤޤ
extern void xprintid (id anObject);              

//F: ǥХåϥȥ꡼ˡ쥯γƥФεҤץȤ
//F: 
extern void xfprint (id anObject);

//F: ǥХåϥȥ꡼ˡ쥯γƥФidץȤޤ
extern void xfprintid (id anObject);  

//F: ֥Ȥ˥å¹Ԥ뤿ΥǥХåؿ
extern void xexec (id anObject, const char *name);

//F: 쥯γƥФ˥å¹Ԥ뤿ΥǥХåؿ
extern void xfexec (id anObject, const char *name); 

//F: ƥȤΥݥ󥿵Ҥ饪֥Ȥޤ
extern id nameToObject (const char *name);

//
// macros used to create and initialize warning and error symbols
// (obsolete once module system in use)
//

//#: ܥκȽ˻Ѥޥ
#define defsymbol(name) name = [Symbol create: globalZone setName: #name]

//#: Errorܥ뤿˻Ѥޥ
#define defwarning(name, message) \
  [(name = [Warning create: globalZone setName: #name]) \
    setMessageString: message]

//#: Warningܥ뤿˻Ѥޥ
#define deferror(name, message) \
  [(name = [Error create: globalZone setName: #name]) \
    setMessageString: message]

//#: Lisp֤Υ饹ؿѤ뤿̾
#define MAKE_CLASS_FUNCTION_NAME "make-class"

//#: Lisp֤Υ֥ȺؿѤ뤿̾
#define MAKE_INSTANCE_FUNCTION_NAME "make-instance"

//#: ȤϤ줿Υ֥Ȥˡ10ʷݼŪʳԤ
//#: ߥ͡ϴޤߤޤsignchar + roundup (log (10)/log(2) =
//#:  3.3219)
#define DSIZE(type) (1 + sizeof (type) * 8 / 3 + 1)
