#!/bin/sh
V="4.2.0"
prefix=/usr
infodir=${prefix}/share/info
docdir=${prefix}/share/doc

# Install the .info files
cd ${infodir}
for fn in zsh.info ; do
  install-info --dir-file=./dir --info-file=${fn}
done

# Install default zprofile if needed
if [ ! -f /etc/zprofile ]; then
  echo "Installing default /etc/zprofile"
  install -c -m 755 ${docdir}/zsh-$V/StartupFiles/zprofile /etc/zprofile
else
  echo "Keeping current /etc/zprofile"
fi

exit 0
