.\"

.\" Copyright (c) Mark J. Kilgard, 1998.

.\"

.TH glutKeyboardUpFunc 3GLUT "3.7" "GLUT" "GLUT"

.SH NAME

glutKeyboardUpFunc - sets the keyboard up (key release) callback for the current window. 

.SH SYNTAX

.nf

.LP

void glutKeyboardUpFunc(void (*func)(unsigned char key,

                      int x, int y));

.fi

.SH ARGUMENTS

.IP \fIfunc\fP 1i

The new keyboard up callback function. 

.SH DESCRIPTION

glutKeyboardFunc sets the keyboard up (key release) callback for the current window.

When a user types into the window, each key release matching an ASCII

character will generate a keyboard up callback. The key callback parameter

is the generated ASCII character. The state of modifier keys such as Shift

cannot be determined directly; their only effect will be on the returned

ASCII data. The x and y callback parameters indicate the mouse location

in window relative coordinates when the key was pressed. When a new

window is created, no keyboard callback is initially registered, and ASCII

key strokes in the window are ignored. Passing NULL to

glutKeyboardFunc disables the generation of keyboard callbacks. 



During a keyboard up callback, glutGetModifiers may be called to

determine the state of modifier keys when the keystroke generating the

callback occurred. 



To avoid the reporting of key release/press pairs due to auto

repeat, use glutIgnoreKeyRepeat to ignore auto repeated keystrokes.



There is no guarantee that the keyboard press callback will match

the exact ASCII character as the keyboard up callback.  For example,

the key down may be for a lowercase b, but the key release may

report an uppercase B if the shift state has changed.  The same

applies to symbols and control characters.  The precise behavior

is window system dependent.



Use glutSpecialUpFunc for a means to detect non-ASCII key

releases.

.SH SEE ALSO

glutKeyboardFunc, glutSpecialUpFunc, glutSpecialFunc, glutCreateWindow, glutMouseFunc, glutSpaceballButtonFunc, glutButtonBoxFunc, glutTabletButtonFunc, glutGetModifiers, glutIgnoreKeyRepeat

.SH AUTHOR

Mark J. Kilgard (mjk@nvidia.com)

