
/*---------------------------------------------------------------------------*\

    gluixFileSelect.cpp

    Copyright (c) 2001 Andre Bleau

    Revision:	March 28, 2001

    This program is freely distributable without licensing fees and is
    provided without guarantee or warrantee expressed or implied. This
    program is -not- in the public domain.

\*---------------------------------------------------------------------------*/

#if !defined(_WIN32) || defined(__GNUC__)
#include <sys/types.h>
#endif
#include <GL/glut.h>
#include "glui.h"
#include "gluix.h"
#include "gluixIntern.h"


/*****************************************************************************/

   GLUIX_FileSelectionDialog::GLUIX_FileSelectionDialog(
                     char *Title,
                     void (*NewFileCB)(char *, char *, char *),
							int Flags,
                     int OrgX,
                     int OrgY,
                     int DirState,
                     int ExtState,
                     int NameState,
                     int Type
                     )
   
   {
   
      intern = new GLUIX_FileSelectionDialogIntern(
                           Title, 
                           NewFileCB,
									Flags,
									OrgX,
									OrgY, 
                           DirState, 
                           ExtState, 
                           NameState,
                           Type
                           );
   
   }


/*****************************************************************************/

   GLUIX_FileSelectionDialog::~GLUIX_FileSelectionDialog()
   
   {
   
      delete intern;
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialog::set_default_dir(
                     char	*FileDefaultDir, 
                     int	DefaultValueReset
                     )
   
   {
   
      return(intern->set_default_dir(FileDefaultDir, DefaultValueReset));
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialog::set_default_ext(
                     char	*FileDefaultExt, 
                     int	DefaultValueReset
                     )
   
   {
   
      return(intern->set_default_ext(FileDefaultExt, DefaultValueReset));
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialog::set_default_name(
                     char	*FileDefaultName, 
                     int	DefaultValueReset
                     )
   
   {
   
      return(intern->set_default_name(FileDefaultName, DefaultValueReset));
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialog::set_access(int Access)
   
   {
   
      return(intern->set_access(Access));
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialog::set_bkgd_color(
                     Byte Red, Byte Green, Byte Blue)
   
   {
   
       
      return(intern->set_bkgd_color(Red, Green, Blue));
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialog::set_font(
                     enum GLUIX_FSD_Part part, 
                     void *new_font)
   
   {
   
      return(intern->set_font(part, new_font));
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialog::set_h(
                     enum GLUIX_FSD_Part part, 
                     int new_size)
   
   {
   
      return(intern->set_h(part, new_size));
   
   }


#ifdef DEPRECATED
/*****************************************************************************/

   int GLUIX_FileSelectionDialog::set_interface_text(
                     char *DirPanelText,
                     char *DirBrowseText,
                     char *DirCheckboxText,
                     char *ExtPanelText,
                     char *ExtNumberText,
                     char *ExtCheckboxText,
                     char *NamePanelText,
                     char *NameBrowseText,
                     char *NameCheckboxText,
                     char *OKText,
                     char *CancelText,
                     char *SubMenuText
                     )
   
   {
   
      intern->set_interface_text(
                           DirPanelText,
                           DirBrowseText,
                           DirCheckboxText,
                           ExtPanelText,
                           ExtNumberText,
                           ExtCheckboxText,
                           NamePanelText,
                           NameBrowseText,
                           NameCheckboxText,
                           OKText,
                           CancelText,
                           SubMenuText
                           );
   
   }


#endif
/*****************************************************************************/

   int GLUIX_FileSelectionDialog::set_text(
                     enum GLUIX_FSD_Part part, 
                     char *new_text)
   
   {
   
      return(intern->set_text(part, new_text));
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialog::set_w(
                     enum GLUIX_FSD_Part part, 
                     int new_size)
   
   {
   
      return(intern->set_w(part, new_size));
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialog::set_n_items_max(
                     int new_n_items_max)
   
   {
   
      return(intern->set_n_items_max(new_n_items_max));
   
   }


/*****************************************************************************/

   void GLUIX_FileSelectionDialog::show(GLUI *gluiDisabled)
   
   {
   
      intern->show(gluiDisabled);
   
   }
