#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e 's/^[^\-]*\-//' -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e 's/^[^\-]*\-[^\-]*\-//'`
export FULLPKG=${PKG}-${VER}-${REL}
export src_pkg_url=ftp://ftp.ncftp.com/ncftp/
export src_orig_pkg_name=${PKG}-${VER}-src.tar.bz2
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}
#export objdir=${srcdir}/.build
export objdir=${srcdir}
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc
CFLAGS="-O2"

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  if [ ! -f ${src_orig_pkg} ] ; then
    wget -O ${src_orig_pkg} ${src_pkg_url}/${src_orig_pkg_name}
  fi && \
  tar xvjf ${src_orig_pkg} && \
  cd ${topdir} && \
  patch -p0 < ${src_patch} 
  && mkdirs )
}
mkpatch() {
  (cd ${srcdir} && \
  tar xvjf ${src_orig_pkg} && \
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' -x 'texi2pod.pl' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}
conf() {
  (cd ${objdir} && \
  autoheader --localdir=autoconf && \
  autoconf --localdir=autoconf && \
  ${srcdir}/configure --host=${host} --target=${target} \
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib --includedir=${prefix}/include \
  --enable-readline )
}
build() {
  (cd ${objdir} && \
  make CFLAGS=${CFLAGS} DESTDIR=${instdir} )
}
check() {
  (cd ${objdir} && \
  make check | tee ${checkfile} 2>&1 )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  make install INSTALL=install \
    prefix=${instdir}${prefix} \
    exec_prefix=${instdir}${prefix} \
    bindir=${instdir}${prefix}/bin \
    libdir=${instdir}${prefix}/lib \
    SYSCONFDIR=${instdir}${sysconfdir} \
    includedir=${instdir}${prefix}/include && \
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/doc/Cygwin ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/doc/CHANGELOG.txt ${srcdir}/doc/FIREWALLS_AND_PROXIES.txt \
           ${srcdir}/doc/LICENSE.txt ${srcdir}/doc/READLINE.txt \
           ${srcdir}/doc/html/* ${srcdir}/doc/what_changed_between_v2_v3.txt \
	   ${srcdir}/README.txt ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    if [ ! -d ${instdir}${prefix}/doc/${PKG}-${VER} ]; then \
      mkdir -p ${instdir}${prefix}/doc/${PKG}-${VER} ; \
    fi && \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/doc/${PKG}-${VER} ; \
  fi && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README ]; then \
    /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
      ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
  else \
    if [ -f ${srcdir}/CYGWIN-PATCHES/README ]; then \
      /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/README \
        ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
    fi ;\
  fi && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/postinstall.sh ]; then \
    if [ ! -d ${instdir}${sysconfdir}/postinstall ]; then \
      mkdir -p ${instdir}${sysconfdir}/postinstall ; \
    fi && \
    /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/postinstall.sh \
      ${instdir}${sysconfdir}/postinstall/${PKG}.sh ; \
  fi ; )
}
strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} * )
}
spkg() {
  (echo "WARNING: patch is NOT updated to reflect any changes" && \
  echo  "         you may have made..." && \
  if [ ! -f ${srcinstdir}/${src_patch_name} ]; then \
    cp ${src_patch} ${srcinstdir}/${src_patch_name} ; \
  fi && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  rm -rf ${srcdir} 
}
case $1 in
  prep)		prep ;    STATUS=$? ;;
  conf)		conf ;    STATUS=$? ;;
  build)	build ;   STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  check)	check ;   STATUS=$? ;;
  clean)	clean ;   STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ;   STATUS=$? ;;
  package)	pkg ;     STATUS=$? ;;
  pkg)		pkg ;     STATUS=$? ;;
  src-package)	spkg ;    STATUS=$? ;;
  spkg)		spkg ;    STATUS=$? ;;
  finish)	finish ;  STATUS=$? ;;
  all)		prep && conf && build && install && \
     		strip && pkg && spkg && finish ; \
	  		  STATUS=$? ;;
  *) echo -e "Error: bad arguments\nvalid arguments are:" prep, mkpatch, \
     conf, build, check, clean, install, strip, package, pkg, src-package, \
     spkg, finish, all ; exit 1 ;;
esac
exit ${STATUS}
