module gcc.threadsem;
private import gcc.config;

version (GNU_Semaphore_POSIX)
{
    private import std.c.unix;
    version(linux) {
       private import std.thread; // ugly, needs to be fixed
    }
    struct Semaphore {
	sem_t sem;
	bool create() {  return sem_init(& sem, 0, 0) == 0; }
	void wait() { sem_wait(& sem); }
	void signal() { sem_post(& sem); }
	
    }
}
else version (GNU_Semaphore_Mach)
{
    private import std.c.mach.mach;
    struct Semaphore {
	semaphore_t sem;
	bool create() {
	    return semaphore_create(current_task(), & sem,
		SYNC_POLICY_FIFO, 0) == KERN_SUCCESS; }
	void wait() { semaphore_wait(sem); }
	void signal() { semaphore_signal(sem); }
    }
}
else version (GNU_Semaphore_SysV)
{
    // TODO
}
else version (GNU_Sempahore_Pthreads)
{
    // TODO
}
