/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

public final class CharBufferImpl
extends CharBuffer {
    private boolean readOnly;

    public CharBufferImpl(int cap, int off, int lim) {
        super(cap, lim, off, 0);
        this.backing_buffer = new char[cap];
        this.readOnly = false;
    }

    public CharBufferImpl(char[] array, int offset, int length) {
        super(array.length, length, offset, 0);
        this.backing_buffer = array;
        this.readOnly = false;
    }

    public CharBufferImpl(CharBufferImpl copy) {
        super(copy.capacity(), copy.limit(), copy.position(), 0);
        this.backing_buffer = copy.backing_buffer;
        this.readOnly = copy.isReadOnly();
    }

    private static native char[] nio_cast(byte[] var0);

    CharBufferImpl(byte[] copy) {
        super(copy.length / 2, copy.length / 2, 0, 0);
        this.backing_buffer = copy != null ? CharBufferImpl.nio_cast(copy) : null;
        this.readOnly = false;
    }

    private static native byte nio_get_Byte(CharBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(CharBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl res = new ByteBufferImpl(this.backing_buffer);
        res.limit(this.limit() * 1 / 2);
        return res;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public CharBuffer slice() {
        return new CharBufferImpl(this);
    }

    public CharBuffer duplicate() {
        return new CharBufferImpl(this);
    }

    public CharBuffer asReadOnlyBuffer() {
        CharBufferImpl result = new CharBufferImpl(this);
        result.readOnly = true;
        return result;
    }

    public CharBuffer compact() {
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final CharSequence subSequence(int start, int end) {
        if (start < 0 || end > this.length() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        return new CharBufferImpl(this.array(), this.position() + start, this.position() + end);
    }

    public final char get() {
        char e = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return e;
    }

    public final CharBuffer put(char b) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = b;
        this.position(this.position() + 1);
        return this;
    }

    public final char get(int index) {
        if (index < 0 || index >= this.limit()) {
            throw new IndexOutOfBoundsException();
        }
        return this.backing_buffer[index];
    }

    public final CharBuffer put(int index, char b) {
        if (index < 0 || index >= this.limit()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = b;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }
}

