#! /bin/sh
set -e

nt=$(uname -s | sed -ne 's/CYGWIN_NT-\(.*\)/\1/p')

if [ -n "$nt" ]
then
  export CYGWIN=ntsec
  SYSTEMUID=$(sed -ne '/^[^:]*:[^:]*:[0-9]*:[0-9]*:[^:]*,S-1-5-18:.*:/{s/[^:]*:[^:]*:\([0-9]*\):.*$/\1/p;q}' /etc/passwd)
  ADMINSGID=$(sed -ne '/^[^:]*:S-1-5-32-544:.*:/{s/[^:]*:[^:]*:\([0-9]*\):.*$/\1/p;q}' /etc/group)
  setfacl -m u::rw-,g::rw-,o:r-- /etc/defaults/etc/exim.conf
  if [ -n "${SYSTEMUID}" -a -n "${ADMINSGID}" ]
  then
    chown "${SYSTEMUID}:${ADMINSGID}" /etc/defaults/etc/exim.conf
  else
    echo "ERROR: Cannot find SYSTEM and/or ADMINS SIDS"  
  fi
fi

# If /etc/exim.conf does not exit, initialize

if [ ! -e /etc/exim.conf ]
then
  if [ ! -e /usr/bin/exim-config ]
  then
    echo "ERROR: /usr/bin/exim-config does not exist."
  else
    ln -sf /usr/bin/exim-config /usr/bin/exim
  fi

  if [ -n "$nt" ]
  then
    chmod 777 /var/spool/exim /var/log/exim
    if [ -n "${SYSTEMUID}" -a -n "${ADMINSGID}" ]
      then
      chown "${SYSTEMUID}:${ADMINSGID}" /var/spool/exim /var/log/exim
    fi
  fi
fi
