<TeXmacs|1.0.3.11>

<style|tmdoc>

<\body>
  <tmdoc-title|Page layout>

  In this section, we describe how <TeXmacs> fills pages with typesetted
  content. Besides specifying the settings on how to print a document, the
  user may also determine the way pages should be rendered on screen. It
  should be noticed that the number of environment variables is redundant in
  the sense that some variables are computed as a function of other ones. For
  instance, by default, the paragraph width is computed as a function of the
  page size and the left and right margins.

  <paragraph|Paper specific variables>

  <\explain>
    <var-val|page-type|a4><explain-synopsis|the size of pages>
  <|explain>
    Specify the size of a page when printing out. Most standard formats are
    available in <menu|Document|Page|Size>. By default, the paper size is the
    one of your printer (the default printer settings may be changed in
    <menu|Edit|Preferences|Printer>). When the <src-var|page-type> is set to
    <verbatim|user>, then the page size is given by <src-var|page-width> and
    <src-var|page-height>.
  </explain>

  <\explain>
    <var-val|page-orientation|portrait><explain-synopsis|page orientation>
  <|explain>
    The orientation of pages can be either <verbatim|portrait> or
    <verbatim|landscape>.
  </explain>

  <\explain>
    <var-val|page-nr|0><explain-synopsis|current page number>
  <|explain>
    The current page number. This environment variable should be manipulated
    with care, since it is not yet available at typesetting time. For a
    reliable determination of page numbers, one may combine the
    <markup|label> and <markup|page-ref> primitives. Nevertheless, the
    <src-var|page-nr> variable can be used in the macros which render page
    headers and footers.
  </explain>

  <\explain>
    <src-var|page-the-page><explain-synopsis|display the page number>
  <|explain>
    This environment variable really contains the macro which is used for
    rendering the page-number. By default, it renders <src-var|page-nr>. The
    macro takes no arguments. In order to simulate a document whose first
    page number os <with|mode|math|123>, one may redefine

    <\tm-fragment>
      <inactive*|<assign|page-the-page|<macro|<plus|<value|page-nr>|122>>>>
    </tm-fragment>
  </explain>

  <\explain>
    <var-val|page-breaking|optimal><explain-synopsis|page breaking algorithm>
  <|explain>
    This parameter specifies the page breaking algorithm. The default
    <verbatim|optimal> algorithm takes into account the global document and
    tries hard to avoid bad page breaks. The alternative <verbatim|sloppy>
    algorithm uses a fast first-fit algorithm, but produces bad page break
    with a higher probability. The <verbatim|medium> quality algorithm is the
    same as the <verbatim|optimal> algorithm, except for two column content.
  </explain>

  <\explain>
    <var-val|page-flexibility|1.0><explain-synopsis|flexibility for
    stretching>
  <|explain>
    This parameter specifies how much stretchable spaces may be extended or
    reduced in order to fill pages which are too short or too long. A page
    flexibility of <with|mode|math|1> allows spaces to be stretched to their
    minimal and maximal values. A page flexibility of <with|mode|math|0>
    prevents spaces to be stretched. For other values of
    <src-var|page-flexibility> the behaviour is linear.
  </explain>

  <\explain>
    <var-val|page-shrink|1fn><explain-synopsis|allowed amount of page
    shrinking>
  <|explain>
    In the case when it is very hard to find good page breaks, this parameter
    specifies an additional amount of space by which a page is allowed to be
    reduced.
  </explain>

  <\explain>
    <var-val|page-extend|0fn><explain-synopsis|allowed amount of page
    extensions>
  <|explain>
    In the case when it is very hard to find good page breaks, this parameter
    specifies an additional amount of space by which a page is allowed to be
    extended.
  </explain>

  <paragraph|Screen specific variables>

  <\explain>
    <var-val|page-medium|papyrus><explain-synopsis|the page medium>
  <|explain>
    This environment variable, which is initialized using
    <menu|Document|Page|Type>, specifies how pages are rendered on the
    screen. The following values are available:

    <\description>
      <item*|<verbatim|paper>>Page breaks are visually indicated on the
      screen. This mode is useful for ajusting the final version of a
      document before printing or sending it to a publisher. However, the use
      of this mode slows down the editor since every modification in the
      document triggers the page-breaking algorithm.

      Notice also that the mere selection of this mode does not imply the
      screen margins and page decorations to be as on paper. In order to
      previsualize a document in a fully realistic way, you should also set
      <menu|Document|View|Page layout|Show header and footer> and
      <menu|Document|View|Page layout|Margins as on paper>.

      <item*|<verbatim|papyrus>>The paragraph width is the same as on paper,
      but page breaking is disabled. This mode is most useful during the
      editing phase of a document which will ultimately be printed out. It
      combines a reasonable editing speed with realistic line breaks.

      <item*|<verbatim|automatic>>The paragraph width is as large as possible
      so as to fit into the current window and page breaking is disabled.
      This setting, which makes optimal use of the available space on your
      screen, is useful for documents which are not intended to be printed
      out. It may for instance be selected when using <TeXmacs> as a browser
      or as an interface to computer algebra systems.
    </description>
  </explain>

  <\explain>
    <var-val|page-screen-width|10cm><explain-synopsis|width of the rendering
    window>
  <|explain>
    In <verbatim|automatic> mode, this environement variable contains the
    width of the screen.
  </explain>

  <\explain>
    <var-val|page-screen-height|10cm><explain-synopsis|height of the
    rendering window>
  <|explain>
    In <verbatim|automatic> mode, this environement variable contains the
    height of the screen.
  </explain>

  <\explain>
    <var-val|page-screen-margin|true><explain-synopsis|special margins for
    screen editing?>
  <|explain>
    This flag specifies whether the screen margins are manually specified by
    the user, or whether they are the same as on paper.
  </explain>

  <\explain>
    <var-val|page-screen-left|5mm>

    <var-val|page-screen-right|5mm>

    <var-val|page-screen-top|15mm>

    <var-val|page-screen-bot|15mm><explain-synopsis|left margin on screen>
  <|explain>
    When <src-var|page-screen-margin> is <verbatim|true>, then these
    environment variables determine the margins which are to be used for
    rendering on the screen.
  </explain>

  <\explain>
    <var-val|page-show-hf|false><explain-synopsis|show headers and footers on
    screen?>
  <|explain>
    This flag determines whether the page headers and footers should be
    visible on the screen. When set to <verbatim|true>, it should be noticed
    that the headers and footers are not always correctly updated when
    editing. In the case when you suspect them to be wrong, refreshing the
    display by scrolling down and up should display the correct values.
  </explain>

  <paragraph|Specifying the margins>

  The parameters for page margins are represented schematically at the left
  hand side in figure <no-break><reference|tm-page-fig>. One may either
  specify the paragraph width as a function of the left and right margins, or
  <em|vice versa>. The left and right margins may depend on whether the page
  number is odd or even.

  <\explain>
    <var-val|page-width-margin|false><explain-synopsis|compute margins from
    paragraph width?>
  <|explain>
    When set to <verbatim|false>, the paragraph width <src-var|par-width> is
    determined automatically from the page size and the left and right
    margins. When set to <verbatim|true>, the left and right margins are
    determined as a function of the page size, the paragraph width,
    <src-var|page-odd-shift> and <src-var|page-even-shift>.
  </explain>

  <\explain>
    <var-val|page-width|auto>

    <var-val|page-height|auto><explain-synopsis|page width>
  <|explain>
    By default, the width and height of a page are automatically determined
    from the page type. When <src-var|page-type> is set to <verbatim|user>,
    then the user may manually specify the page size using
    <src-var|page-width> and <src-var|page-height>.
  </explain>

  <\explain>
    <var-val|page-odd|auto>

    <var-val|page-even|auto><explain-synopsis|left margin>
  <|explain>
    If <src-var|page-width-margin> is set to <verbatim|false>, then
    <src-var|page-odd> and <src-var|page-even> specify the left margins for
    odd and even pages. If <src-var|page-width-margin> is <verbatim|true>,
    then these values are computed as a function of the page size, the
    paragraph width, <src-var|page-odd-shift> and <src-var|page-even-shift>.
    When <src-var|page-odd> and <src-var|page-even> are set to
    <verbatim|auto>, then a nice default left margin is determined as a
    function of the specified page type.
  </explain>

  <\explain>
    <var-val|page-right|auto><explain-synopsis|right margin>
  <|explain>
    If <src-var|page-width-margin> is set to <verbatim|false>, then
    <src-var|page-right> specifies the right margin for odd pages. The right
    margin for even pages is given by the formula

    <\equation*>
      <with|mode|text|<src-var|page-right>>+<with|mode|text|<src-var|page-even>>-<with|mode|text|<with|mode|text|<src-var|page-odd>>>
    </equation*>

    If <src-var|page-width-margin> is <verbatim|true> or when
    <src-var|page-right> is set to <verbatim|auto>, then the right margin is
    determined in a similar way as the left margin.
  </explain>

  <\explain>
    <var-val|page-odd-shift|0mm>

    <var-val|page-even-shift|0mm><explain-synopsis|margin shifts>
  <|explain>
    If <src-var|page-width-margin> is set to <verbatim|true>, then the left
    margins for odd and even pages are determined from the page size,
    paragraph width and the margin shifts using the formulas

    <\eqnarray*>
      <tformat|<table|<row|<cell|<with|mode|text|<src-var|page-even>>>|<cell|=>|<cell|<frac|<with|mode|text|<src-var|page-width>>-<with|mode|text|<src-var|par-width>>|2>+<with|mode|text|<with|mode|text|<with|mode|text|<src-var|page-odd-shift>>>>>>|<row|<cell|<with|mode|text|<with|mode|text|<src-var|page-odd>>>>|<cell|=>|<cell|<frac|<with|mode|text|<src-var|page-width>>-<with|mode|text|<src-var|par-width>>|2>+<with|mode|text|<with|mode|text|<with|mode|text|<src-var|page-even-shift>>>>>>>>
    </eqnarray*>

    The right margin is always taken to be such that the paragraph width and
    the left and right margins sum up to the page width.
  </explain>

  <\quote-env>
    <\big-figure|<postscript|<tuple|<#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>|ps>|/2|/2||||>>
      <label|tm-page-fig>Schematic representation of the layout of pages. On
      the left hand side, the parameters <with|mode|math|l>,
      <with|mode|math|r>, <with|mode|math|t> and <with|mode|math|b>
      respectively correspond to the left, right, top and bottom margins, and
      <with|mode|math|w> corresponds to the paragraph width. On the right
      hand side, <with|mode|math|h>, <with|mode|math|f>, <with|mode|math|d>
      and <with|mode|math|m> correspond to the header, footer, footnote and
      marginal note separations, <with|mode|math|w> to the width of marginal
      notes, and <with|mode|math|l> to the length of the footnote bar.
    </big-figure>
  </quote-env>

  <paragraph|Page decorations>

  <\explain>
    <var-val|page-odd-header|>

    <var-val|page-odd-footer|>

    <var-val|page-even-header|>

    <var-val|page-even-footer|><explain-synopsis|header for odd pages>
  <|explain>
    These environment variables contain the header and footer texts for odd
    and even pages.
  </explain>

  <\explain>
    <var-val|page-head-sep|8mm>

    <var-val|page-foot-set|8mm><explain-synopsis|separation between
    headers/fotters and text>
  <|explain>
    These parameters determine the space between the main text and page
    headers and footers. They correspond to the <with|mode|math|h> and
    <with|mode|math|f> distances at the right hand side of figure
    <reference|tm-page-fig>.
  </explain>

  <\explain>
    <var-val|page-fnote-sep|1.0fn><explain-synopsis|space between footnotes
    and text>
  <|explain>
    The separation between the main text and footnotes, <abbr|i.e.> the
    distance <with|mode|math|d> in figure <reference|tm-page-fig>.
  </explain>

  <\explain>
    <var-val|page-fnote-barlen|7.5fn><explain-synopsis|length of footnote
    bars>
  <|explain>
    The length of the foornote bar.
  </explain>

  <\explain>
    <var-val|page-float-sep|1.5fn><explain-synopsis|separation between floats
    and text>
  <|explain>
    The separation between the main text and floating objects.
  </explain>

  <\explain>
    <var-val|page-mnote-sep|5mm><explain-synopsis|separation between marginal
    notes and text>
  <|explain>
    The separation between marginal notes and the main text (not implemented
    yet).
  </explain>

  <\explain>
    <var-val|page-mnote-width|15mm><explain-synopsis|width of marginal notes>
  <|explain>
    The width of marginal notes (not implemented yet).
  </explain>

  <tmdoc-copyright|2004|Joris van der Hoeven>

  <tmdoc-license|Permission is granted to copy, distribute and/or modify this
  document under the terms of the GNU Free Documentation License, Version 1.1
  or any later version published by the Free Software Foundation; with no
  Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
  Texts. A copy of the license is included in the section entitled "GNU Free
  Documentation License".>
</body>