#!../src/bltwish

package require BLT
source scripts/demo.tcl

set saved [pwd]

#blt::bltdebug 100

image create photo bgTexture -file ./images/rain.gif

set imageList {}
foreach f [glob ./images/mini-*.gif] {
    lappend imageList [image create photo -file $f]
}

#option add *TreeView.Tile	bgTexture
option add *TreeView.ScrollTile  yes

option add *xTreeview.openCommand	{
    set path /home/gah/src/blt/%P
    if { [file isdirectory $path] } {
	cd $path
	set files [glob -nocomplain * */. ]
	if { $files != "" } {
	    eval %W insert -at %n end $files
	}
    }
}

option add *xTreeView.closeCommand {
    eval %W delete %n 0 end
}

image create photo openFolder -file images/open.gif
image create photo closeFolder -file images/close.gif

option add *TreeView.icons "closeFolder openFolder"

image create photo openFolder2 -file images/open2.gif
image create photo closeFolder2 -file images/close2.gif

option add *TreeView.activeIcons "closeFolder2 openFolder2"

#    -activebackground blue \

blt::treeview .h  \
    -yscrollcommand { .vs set } \
    -xscrollcommand { .hs set } 

scrollbar .vs -orient vertical -command { .h yview }
scrollbar .hs -orient horizontal -command { .h xview }
blt::table . \
    0,0 .h  -fill both \
    0,1 .vs -fill y \
    1,0 .hs -fill x

blt::table configure . c1 r1 -resize none

proc DoFind { entry } {
    global fileList
    lappend fileList $entry
    if { [file isdirectory $entry] } {
	foreach f [lsort [glob -nocomplain $entry/*]] {
	    DoFind $f
	} 
    }
}

proc Find { dir } {
    global fileList
    set fileList {}
    DoFind $dir 
    return $fileList
}
proc GetAbsolutePath { dir } {
    set saved [pwd]
    cd $dir
    set path [pwd] 
    cd $saved
    return $path
}

set top [GetAbsolutePath ..]
set trim "$top"

.h configure -separator "/" -autocreate yes  -trim $trim

.h entry configure root -label "$top"
.h configure -bg grey90
update

set fileList [Find $top]
eval .h insert end $fileList
.h configure -bg white

# %n => %#
# no -activebackground
# no -image 

focus .h

# -labelcolor == -foreground
set nodes [.h find -glob -name *.c]
eval .h entry configure $nodes -foreground red 

cd $saved

