#!/bin/sh

export work_dir=`pwd`

# make src tar
tar -cvjf uw-imap-2002e-3-src.tar.bz2 uw-imap-2002e-3.sh uw-imap-2002e-3 &&
cd uw-imap-2002e-3 &&
#clean up any previous stuff
/bin/rm -f /usr/bin/mlock.exe /usr/bin/dmail.exe /usr/bin/mailutil.exe \
	/usr/bin/tmail.exe /usr/sbin/uw-imapd.exe /usr/sbin/uw-ipop2d.exe \
	/usr/sbin/uw-ipop3d.exe &&
/bin/rm -rf /usr/share/doc/uw-imap-2002e \
	/usr/share/doc/Cygwin/uw-imap-2002e.README &&
/bin/rm -rf /etc/preremove/uw-imap-imapd.sh &&
/bin/rm -rf /etc/postinstall/uw-imap-imapd.sh &&
/bin/rm -rf /usr/include/c-client /usr/lib/libc-client.a &&
# patch anything
patch -p0 < CYGWIN-PATCHES/uw-imap-2002e.patch &&
# build everything with plaintext passwords allowed and with ssl support
make cyg SSLTYPE=unix &&
# install everything
# executables
cp mlock/mlock.exe dmail/dmail.exe mailutil/mailutil.exe tmail/tmail.exe \
	/usr/bin/ &&
mkdir -p /usr/sbin/ &&
cp imapd/imapd.exe /usr/sbin/uw-imapd.exe &&
cp ipopd/ipop2d.exe /usr/sbin/uw-ipop2d.exe &&
cp ipopd/ipop3d.exe /usr/sbin/uw-ipop3d.exe &&
# man pages
mkdir -p /usr/share/man/man1/ &&
cp src/dmail/dmail.1 src/mailutil/mailutil.1 src/tmail/tmail.1 \
	/usr/share/man/man1/ &&
mkdir -p /usr/share/man/man8c/ &&
cp src/imapd/imapd.8c /usr/share/man/man8c/uw-imapd.8c &&
cp src/ipopd/ipopd.8c /usr/share/man/man8c/uw-ipopd.8c &&
# devel
mkdir -p /usr/include/c-client/ &&
cd c-client &&
cp c-client.h osdep.h mail.h misc.h rfc822.h nntp.h smtp.h linkage.h \
	env_unix.h fs.h ftl.h nl.h tcp.h flockcyg.h env.h netmsg.h news.h \
	newsrc.h phile.h utf8.h imap4r1.h pop3.h mbox.h mbx.h mh.h mmdf.h mtx.h \
	mx.h tenex.h unix.h linkage.c /usr/include/c-client/ &&
cd .. &&
cp c-client/c-client.a /usr/lib/libc-client.a &&
# strip binaries
strip /usr/bin/mlock.exe &&
strip /usr/bin/dmail.exe &&
strip /usr/bin/mailutil.exe &&
strip /usr/bin/tmail.exe &&
strip /usr/sbin/uw-imapd.exe &&
strip /usr/sbin/uw-ipop2d.exe &&
strip /usr/sbin/uw-ipop3d.exe &&
# put cygwin-specific files in place
cp CYGWIN-PATCHES/uw-imap.README /usr/share/doc/Cygwin/uw-imap-2002e.README &&
mkdir -p /usr/share/doc/uw-imap-2002e &&
cp CPYRIGHT README SUPPORT WARNING CYGWIN-PATCHES/README.cygwin.txt \
	docs/RELNOTES docs/Y2K docs/SSLBUILD docs/internal.txt \
	/usr/share/doc/uw-imap-2002e/ &&
cp CYGWIN-PATCHES/uw-imap-imapd-preremove.sh \
	/etc/preremove/uw-imap-imapd.sh &&
cp CYGWIN-PATCHES/uw-imap-imapd-postinstall.sh \
	/etc/postinstall/uw-imap-imapd.sh &&
cd / &&
# make tar files
tar -cvhj --file=${work_dir}/uw-imap-2002e-3.tar.bz2 \
	--files-from=${work_dir}/CYGWIN-PATCHES/uw-imap.tar.incl &&
tar -cvhj --file=${work_dir}/uw-imap-util-2002e-3.tar.bz2 \
	--files-from=${work_dir}/CYGWIN-PATCHES/uw-imap-util.tar.incl &&
tar -cvhj --file=${work_dir}/uw-imap-imapd-2002e-3.tar.bz2 \
	--files-from=${work_dir}/CYGWIN-PATCHES/uw-imap-imapd.tar.incl &&
tar -cvhj --file=${work_dir}/c-client-2002e-3.tar.bz2 \
	--files-from=${work_dir}/CYGWIN-PATCHES/c-client.tar.incl &&
cd ${work_dir}
