#!/bin/sh

echo .
autoconf2.13 -m texk/etc/autoconf
sed -e 's@--enable-multiplatform.*put executables in bin/PLATFORM@--disable-multiplatform     put executables in bin instead of bin/PLATFORM@' \
    -e 's@window-capable METAFONT is mfw@window-capable METAFONT is mfw (default)@' \
    -e 's@--with-cxx-runtime-hack.*runtime statically@--without-cxx-runtime-hack do not link C++ runtime statically@' \
  < configure > configure_tmp$$
cat configure_tmp$$ > configure; rm configure_tmp$$

dir=libs
  (test -d $dir || exit; cd $dir; echo $dir; autoconf2.13 -m ../texk/etc/autoconf)

# Don't pass --cache-file argument to avoid running different autoconf2.13
# versions with a common cache.
for f in configure libs/configure; do
  sed 's@ac_sub_configure_args --cache-file=.ac_sub_cache_file@ac_sub_configure_args@' < $f > configure_tmp$$
  cat configure_tmp$$ > $f
  rm -f configure_tmp$$
done

#ed libs/ncurses/configure >/dev/null <<'eof'
#1a
#
## added by Thomas Esser for teTeX to work around a bug in MacOS X (darwin):
#test "x$NCURSES_CPP_FIX" = xtrue \
#  && { CPPFLAGS="-no-cpp-precomp $CPPFLAGS"; export CPPFLAGS; }
#
#.
#w
#q
#eof

dir=texk
  (test -d $dir || exit; cd $dir; echo $dir; autoconf2.13 -m etc/autoconf)

dir=t1utils
  (test -d $dir || exit; cd $dir; echo $dir; autoconf2.13)

dir=utils/dialog
  (test -d $dir || exit; cd $dir; echo $dir; autoconf2.13)

for i in texk/*/configure.in; do
  (echo `dirname $i`; cd `dirname $i`; autoconf2.13 -m ../etc/autoconf)
done

#for i in texk/*/*/configure.in; do
#  (echo `dirname $i`; cd `dirname $i`; autoconf2.13 -m ../../etc/autoconf)
#done

#dir=utils/texinfo
#  (test -d $dir || exit; cd $dir; echo $dir; automake -i Makefile doc/Makefile lib/Makefile makeinfo/Makefile util/Makefile; autoconf2.13; touch aclocal.m4 ; touch Makefile.in;
# touch stamp-h.in; touch configure)

# dir=libs/ncurses
#  (test -d $dir || exit; cd $dir; echo $dir; autoconf2.13 -m ../ncurses-ac)

dir=libs/libwww
  (test -d $dir || exit; cd $dir; echo $dir; autoconf2.13 -m ../../texk/etc/autoconf)

#dir=libs/xpdf
#  (test -d $dir || exit; cd $dir; echo $dir; autoconf2.13 -m ../../texk/etc/autoconf)

dir=libs/t1lib
  (test -d $dir || exit; cd $dir; echo $dir; autoconf2.13 -m ../../texk/etc/autoconf)

dir=libs/type1
  (test -d $dir || exit; cd $dir; echo $dir; autoconf2.13 -m ../../texk/etc/autoconf)
