'\" t
.TH X3270IF 1 "07 February 2003"
.SH "NAME"
x3270if \- command interface to x3270, c3270 and s3270
.SH "SYNOPSIS"
\fBx3270if\fP [ \fB\-v\fP ] \fIaction\fP [ ( \fIparam\fP [ ,... ] )
]
.br
\fBx3270if\fP [ \fB\-v\fP ] \fB\-s\fP \fIfield\fP
.br
\fBx3270if \-i\fP
.SH "DESCRIPTION"
\fBx3270if\fP provides an interface between scripts and
the 3270 emulators \fIx3270\fP, \fIc3270\fP, and \fIs3270\fP.
.LP
\fBx3270if\fP performs one of three functions.
In \fBaction mode\fP (the default), it passes a single action and optional
parameters to the emulator for execution;
the result of the command is written to standard output.
In \fBstatus mode\fP, it reports to standard output the value of one of
the emulator's status fields.
In \fBiterative mode\fP, it forms a continuous conduit between a script and
the emulator.
.SH "OPTIONS"
.TP
\fB\-v\fP
Turns on verbose debug messages, showing the literal data that is passed
between the emulator and \fBx3270if\fP.
.TP
\fB\-s\fP \fIfield\fP
Puts \fBx3270if\fP in status mode: it outputs the value of an emulator
status field.
\fIField\fP is an integer in the range 0 through 11.
The value 0 is a no-op and is used only to return exit status indicating the
state of the emulator.
The indices 1-11 and meanings of each field are documented on the
\fIx3270-script\fP(1) manual page.
.TP
\fB\-i\fP
Puts \fBx3270if\fP in iterative mode.
Data from \fBx3270if\fP's standard input is copied to the
emulator's script input; data from the
emulator's script output is copied to
\fBx3270if\fP's standard output.
\fBx3270if\fP
runs until it detects end-of-file on its standard input or on the
output from the emulator.
(This mode exists primarily to give \fIexpect\fP(1)
a process to run, on systems which do not support bidirectional pipes.)
.SH "EXIT STATUS"
In action mode, if the requested \fIaction\fP succeeds,
\fBx3270if\fP exits with status 0.
If the action fails, \fBx3270if\fP exits with status 1.
In iterative mode, \fBx3270if\fP
exits with status 0 when it encounters end-of-file.
If there is an operational error within \fBx3270if\fP
itself, such as a command-line syntax error, missing environment
variable, or an unexpectedly closed pipe,
\fBx3270if\fP exits with status 2.
.SH "ENVIRONMENT"
\fIx3270\fP, \fIc3270\fP, and \fIs3270\fP
use a pair of pipes for communication with each child process.
The values of the file descriptors for these pipes are encoded as text
in two environment variables, which are required by
\fBx3270if\fP:
.TP
\fBX3270OUTPUT\fP
Output from the emulator, input to the child process.
.TP
\fBX3270INPUT\fP
Input to the emulator, output from the child process.
.SH "SEE ALSO"
x3270(1),
c3270(1),
s3270(1),
x3270-script(1)
.SH "COPYRIGHT"
Copyright 1999, 2000 by Paul Mattes.
.RS
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.
.RE
