/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class blobtest {
    Connection db;
    Statement s;
    LargeObjectManager lobj;

    public blobtest(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        String url = args[0];
        String usr = args[1];
        String pwd = args[2];
        Class.forName("org.postgresql.Driver");
        System.out.println("Connecting to Database URL = " + url);
        this.db = DriverManager.getConnection(url, usr, pwd);
        System.out.println("Connected... First turn off autoCommit()");
        this.db.setAutoCommit(false);
        System.out.println("Now creating a statement");
        this.s = this.db.createStatement();
        this.ownapi();
        System.out.println("Now closing the connection");
        this.s.close();
        this.db.close();
    }

    public void ownapi() throws FileNotFoundException, IOException, SQLException {
        System.out.println("\n----------------------------------------------------------------------\nTesting postgresql large object api\n----------------------------------------------------------------------\n");
        System.out.println("Gaining access to large object api");
        this.lobj = ((PGConnection)this.db).getLargeObjectAPI();
        int oid = this.ownapi_test1();
        this.ownapi_test2(oid);
        this.jdbc2api(oid);
        this.ownapi_test3(oid);
        System.out.println("\n\nOID=" + oid);
    }

    private int ownapi_test1() throws FileNotFoundException, IOException, SQLException {
        int s;
        System.out.println("Test 1 Creating a large object\n");
        System.out.println("Creating a large object");
        int oid = this.lobj.create(393216);
        DriverManager.println("got large object oid=" + oid);
        LargeObject obj = this.lobj.open(oid, 131072);
        DriverManager.println("got large object obj=" + obj);
        System.out.println("Opening test source object");
        FileInputStream fis = new FileInputStream("example/blobtest.java");
        System.out.println("Copying file to large object");
        byte[] buf = new byte[2048];
        int tl = 0;
        while ((s = fis.read(buf, 0, 2048)) > 0) {
            System.out.println("Block size=" + s + " offset=" + tl);
            obj.write(buf, 0, s);
            tl += s;
        }
        DriverManager.println("Copied " + tl + " bytes");
        System.out.println("Closing object");
        obj.close();
        return oid;
    }

    private void ownapi_test2(int oid) throws FileNotFoundException, IOException, SQLException {
        int rs;
        System.out.println("Test 2 Reading a large object and save as a file\n");
        System.out.println("Opening large object " + oid);
        LargeObject obj = this.lobj.open(oid, 262144);
        DriverManager.println("got obj=" + obj);
        System.out.println("Opening test destination object");
        FileOutputStream fos = new FileOutputStream("blob_testoutput");
        System.out.println("Copying large object to file");
        byte[] buf = new byte[512];
        int tl = 0;
        for (int s = obj.size(); s > 0; s -= rs) {
            rs = buf.length;
            if (s < rs) {
                rs = s;
            }
            obj.read(buf, 0, rs);
            fos.write(buf, 0, rs);
            tl += rs;
        }
        DriverManager.println("Copied " + tl + "/" + obj.size() + " bytes");
        System.out.println("Closing object");
        obj.close();
    }

    private void ownapi_test3(int oid) throws SQLException {
        System.out.println("Test 3 Deleting a large object\n");
        System.out.println("Deleting large object " + oid);
        this.lobj.unlink(oid);
    }

    public void jdbc2api(int oid) throws SQLException, IOException {
        System.out.println("Testing JDBC2 Blob interface:");
        this.jdbc2api_cleanup();
        System.out.println("Creating Blob on large object " + oid);
        this.s.executeUpdate("create table basic (a oid)");
        System.out.println("Inserting row");
        this.s.executeUpdate("insert into basic values (" + oid + ")");
        System.out.println("Selecting row");
        ResultSet rs = this.s.executeQuery("select a from basic");
        if (rs != null) {
            while (rs.next()) {
                System.out.println("Fetching Blob");
                Blob b = rs.getBlob("a");
                System.out.println("Blob.length() = " + b.length());
                System.out.println("Characters 400-500:");
                System.out.write(b.getBytes(400L, 100));
                System.out.println();
            }
            rs.close();
        }
        System.out.println("Cleaning up");
        this.jdbc2api_cleanup();
    }

    private void jdbc2api_cleanup() throws SQLException {
        this.db.setAutoCommit(true);
        try {
            this.s.executeUpdate("drop table basic");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.db.setAutoCommit(false);
    }

    public static void instructions() {
        System.err.println("java example.blobtest jdbc-url user password [debug]");
        System.err.println("\nExamples:\n");
        System.err.println("java -Djdbc.driver=org.postgresql.Driver example.blobtest jdbc:postgresql:test postgres password\nThis will run the tests on the database test on the local host.\n");
        System.err.println("java -Djdbc.driver=org.postgresql.Driver example.blobtest jdbc:postgresql:test postgres password debug\nThis is the same as above, but will output debug information.\n");
        System.err.println("This example tests the binary large object api of the driver.\nThis allows images or java objects to be stored in the database, and retrieved\nusing both postgresql's own api, and the standard JDBC api.");
    }

    public static void main(String[] args) {
        System.out.println("PostgreSQL blobtest v7.0 rev 1\n");
        if (args.length < 3) {
            blobtest.instructions();
            System.exit(1);
        }
        if (args.length > 3) {
            DriverManager.setLogStream(System.err);
        }
        try {
            blobtest test = new blobtest(args);
        }
        catch (Exception ex) {
            System.err.println("Exception caught.\n" + ex);
            ex.printStackTrace();
        }
    }
}

