#!/bin/sh

# run the build with ntsec on if possible...
pkg=perl
ver=5.8.5
release=-3
dir=`pwd`
shortver=`echo ${ver}${release} | sed 's/-.*//'`
timestamp=${dir}/pkg.timestamp
files=${dir}/pkg.files

# cleanup
mkdir -p old/
mv -f ${timestamp} ${files} ${files}.manpages ${files}.perl ${pkg}-${ver}${release}-src.tar.bz2 ${pkg}-${ver}${release}.tar.bz2 ${pkg}_manpages-${ver}${release}.tar.bz2 ${pkg}-${ver}${release}/ old/
mv -f /usr/share/doc/Cygwin/${pkg}-${shortver}.README old
# cleanup modules
for i in \
         Compress-Zlib-1.33	\
         IO-Zlib-1.01	\
         Archive-Tar-1.10	\
         MD5-2.03	\
         Term-ReadLine-Perl-1.0203 \
         Net-Telnet-3.03	\
         TermReadKey-2.21	\
         XML-Parser-2.34;	\
do rm -rf ${i};	\
done


# start
set -e
touch ${timestamp}
touch README

## install READMEs
/bin/install -m 644 README /usr/share/doc/Cygwin/${pkg}-${shortver}.README 
mkdir -p /usr/share/doc/${pkg}-${ver}${release}
rm -rf /usr/share/doc/${pkg}-${ver}${release}/Artistic /usr/share/doc/${pkg}-${ver}${release}/Copying /usr/share/doc/${pkg}-${ver}${release}/README

# build perl now
sh -x ${dir}/build.sh

# source package
rm -rf ${pkg}-${ver}${release}
mkdir ${pkg}-${ver}${release}
cp -p ANNOUNCEMENTS README *.patch *.pl *.sh *.tar.gz *.tar.bz2 ${pkg}-${ver}${release}
for i in `ls log.*`; do cp ${i} ${pkg}-${ver}${release}/${i}.rel; done
tar cjf ${pkg}-${ver}${release}-src.tar.bz2 ${pkg}-${ver}${release}

# binary package
# first the files
(cd / ; find usr/share/man -path usr/lib/perl5 -prune -o -type f -newer ${timestamp} -print) >${files}
(cd / ; find usr/bin -path usr/lib/perl5 -prune -o -type f -newer ${timestamp} -print) >>${files}
echo usr/lib/perl5/${shortver} >>${files}
echo usr/lib/perl5/site_perl/${shortver} >>${files}
echo usr/lib/perl5/vendor_perl/${shortver} >>${files}
echo usr/share/doc/${pkg}-${ver}${release} >>${files}
echo usr/share/doc/Cygwin/${pkg}-${ver}.README >>${files}
# separate manpages and remove builddirs from list
${dir}/separate.pl
# then pack it up
(cd /;tar -c -T ${files}.manpages) | bzip2 -9 >${pkg}_manpages-${ver}${release}.tar.bz2
(cd /;tar -c -T ${files}.perl) | bzip2 -9 >${pkg}-${ver}${release}.tar.bz2
