#!/bin/sh
#
# Postinstall script for pdksh.

ver=5.2.14
data=/usr/share
sysconf=/etc
kshrc=ksh.kshrc
profile=profile.ksh

add_shell ()
{
  if [ -f /etc/shells ]; then
    cat /etc/shells |grep $1 >/dev/null 2>&1
    if [ "$?" -eq "0" ]; then
      echo "$1 already in /etc/shells"
    else
      echo "Adding $1 to /etc/shells"
      echo "$1" >> /etc/shells
    fi
  fi
}

# Check if we already have /etc/ksh.kshrc and /etc/profile.ksh
if [ ! -f "/etc/$kshrc" ]; then
  echo "Installing default /etc/$kshrc"
  install -c -m 755 /usr/share/pdksh-$ver/$kshrc /etc/$kshrc
else
  echo "Keeping current /etc/$kshrc"
fi
if [ ! -f "/etc/$profile" ]; then
  echo "Installing default /etc/$profile"
  install -c -m 755 /usr/share/pdksh-$ver/$profile /etc/$profile
else
  echo "Keeping current /etc/$profile"
fi

# Check if ksh.exe is already installed in /bin
if [ ! -e /bin/ksh.exe ]; then
  cd /bin
  ln -s pdksh.exe ksh.exe
fi

# Check if ksh.1 is already installed in /usr/man/man1
if [ ! -e /usr/man/man1/ksh.1 ]; then
  cd /usr/man/man1
  ln -s pdksh.1 ksh.1
fi

# Check if /etc/shells contains [/usr]/bin/{pd,}ksh
add_shell /bin/pdksh
add_shell /bin/ksh
add_shell /usr/bin/pdksh
add_shell /usr/bin/ksh

exit 0
