
/*---------------------------------------------------------------------------*\

    gluixFileSelectIntern.cpp

    Copyright (c) 2001 Andre Bleau

    Revision:	March 28, 2001

    This program is freely distributable without licensing fees and is
    provided without guarantee or warrantee expressed or implied. This
    program is -not- in the public domain.

\*---------------------------------------------------------------------------*/

#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#if defined(_WIN32) && !defined(__GNUC__)
#include <io.h>
#include <direct.h>
#include <windows.h>
#define R_OK 4
#define W_OK 2
#define X_OK 1
#define S_ISDIR(m) (((m)&0170000) == 0040000)
#define S_ISREG(m) (((m)&0170000) == 0100000)
#else
#include <dirent.h>
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <GL/glut.h>
#include "glui.h"
#include "gluix.h"
#include "gluixIntern.h"


/*****************************************************************************/

   int
   GLUIX_FileSelectionDialogIntern::n_used = 0;
   int
   GLUIX_FileSelectionDialogIntern::n_alloc = 0;
   GLUIX_FileSelectionDialogIntern
   **GLUIX_FileSelectionDialogIntern::used = NULL;


/*****************************************************************************/

   GLUIX_FileSelectionDialogIntern::GLUIX_FileSelectionDialogIntern(
                     char *Title,
                     void (*NewFileCB)(char *, char *, char *),
                     int Flags,
                     int OrgX,
                     int OrgY,
                     int DirState,
                     int ExtState,
                     int NameState,
                     int Type
                     )
   
   {
   
      int
         i;
   
      Menu_dirs  = NULL;
      Menu_names = NULL;
      access_name = -1;
      bkgd_blue  = 200;
      bkgd_green = 208;
      bkgd_red   = 212;
      default_dir  = 1;
      default_ext  = 1;
      default_name = 1;
      dir_mtime = 0;
      dirs  = NULL;
      file_default_dir  = strdup(".");
      file_default_ext  = strdup("");
      file_default_name = strdup("");
      file_dir  = NULL;
      file_ext  = NULL;
      file_name = NULL;
      flags = Flags;
      glui = NULL;
      glui_checkbox_dir  = NULL;
      glui_checkbox_ext  = NULL;
      glui_checkbox_name = NULL;
      menu_dir_list = 0;
      menu_name_list = 0;
      n_dirs = 0;
      n_dirs_alloc = 0;
		n_items_max = N_ITEMS_MAX;
      n_names = 0;
      n_names_alloc = 0;
      n_menus_dirs = 0;
      n_menus_dirs_alloc = 0;
      n_menus_names = 0;
      n_menus_names_alloc = 0;
      names = NULL;
      new_file_CB = NewFileCB;
      new_interface = false;
      new_bkgd_color = false;
      org_x = OrgX;
      org_y = OrgY;
      shown = 0;
      text[GLUIX_FSD_DIR_PANEL]     = strdup("Directory");
      text[GLUIX_FSD_DIR_EDITTEXT]  = NULL;
      text[GLUIX_FSD_DIR_BROWSE]    = strdup("Browse");
      text[GLUIX_FSD_EXT_PANEL]     = strdup("Extension");
      text[GLUIX_FSD_EXT_EDITTEXT]  = NULL;
      text[GLUIX_FSD_EXT_NUMBER]    = strdup("Number");
      text[GLUIX_FSD_NAME_EDITTEXT] = NULL;
      text[GLUIX_FSD_NAME_BROWSE]   = strdup("Browse");
      text[GLUIX_FSD_OK]            = strdup("OK");
      text[GLUIX_FSD_CANCEL]        = strdup("Cancel");
      text[GLUIX_FSD_SUBMENU]       = strdup("MORE...");
      if (Title)
         title = strdup(Title);
      else 
         title = strdup("");
      switch (Type) {
         case GLUIX_DIR:
            type = GLUIX_DIR;
            text[GLUIX_FSD_NAME_PANEL] = strdup("Subdirectory");
            break;
         default:
            type = GLUIX_REG;
            text[GLUIX_FSD_NAME_PANEL] = strdup("Name");
      }
      for (i=0; i<=GLUIX_FSD_CANCEL; i++) {
         h[i] = w[i] = 0;
         font[i] = NULL;
      }
      w[GLUIX_FSD_DIR_EDITTEXT]  = GLUIX_FSD_DIR_EDITTEXT_W;
      w[GLUIX_FSD_EXT_EDITTEXT]  = GLUIX_FSD_EXT_EDITTEXT_W;
      w[GLUIX_FSD_NAME_EDITTEXT] = GLUIX_FSD_NAME_EDITTEXT_W;
   
      locked_dir  = DirState&GLUIX_LOCKED;
      locked_ext  = ExtState&GLUIX_LOCKED;
      locked_name = NameState&GLUIX_LOCKED;
      has_dir_panel  = DirState!=GLUIX_NONE;
      has_name_panel = NameState!=GLUIX_NONE;
      has_dir_def_cb  = (DirState&GLUIX_NODEFCHECKBOX)==0;
      has_ext_def_cb  = (ExtState&GLUIX_NODEFCHECKBOX)==0;
      has_name_def_cb = (NameState&GLUIX_NODEFCHECKBOX)==0;
      if (locked_dir)
         text[GLUIX_FSD_DIR_CHECKBOX]  = strdup("Mandatory directory");
      else
         text[GLUIX_FSD_DIR_CHECKBOX]  = strdup("Set as default");
      if (locked_ext)
         text[GLUIX_FSD_EXT_CHECKBOX]  = strdup("Mandatory extension");
      else
         text[GLUIX_FSD_EXT_CHECKBOX]  = strdup("Set as default");
      if (locked_name) {
         text[GLUIX_FSD_NAME_CHECKBOX] = strdup("Mandatory name");
         has_ext_panel  = false;
      }
      else {
         text[GLUIX_FSD_NAME_CHECKBOX] = strdup("Set as default");
         has_ext_panel  = ExtState!=GLUIX_NONE;
      }
   
      if (n_alloc==0) {
         n_alloc += N_MENUS_ALLOC;
         used = (GLUIX_FileSelectionDialogIntern **)calloc(
                              n_alloc, 
                              sizeof(GLUIX_FileSelectionDialogIntern *));
         my_id = n_used;
         used[n_used++] = this;
      }
      else if (n_alloc==n_used) {
         n_alloc += N_MENUS_ALLOC;
         used = (GLUIX_FileSelectionDialogIntern **)realloc(
                              used, 
                              n_alloc*sizeof(GLUIX_FileSelectionDialogIntern *));
         my_id = n_used;
         used[n_used++] = this;
         for (i=n_used; i<n_alloc; i++) {
            used[i] = NULL;
         }
      }
      else {
         for (i=0; used[i]!=NULL; i++) 
            ;
         my_id = i;
         n_used++;
         used[i] = this;
      }
   
   }


/*****************************************************************************/

   GLUIX_FileSelectionDialogIntern::~GLUIX_FileSelectionDialogIntern()
   
   {
   
      int
         i;
   
      for (i=0; i<n_menus_dirs; i++)
         glutDestroyMenu(Menu_dirs[i]);
      if (Menu_dirs)
         free(Menu_dirs);	
      for (i=0; i<n_menus_names; i++)
         glutDestroyMenu(Menu_names[i]);
      if (Menu_names)
         free(Menu_names);
      free(text[GLUIX_FSD_DIR_PANEL]);
      free(text[GLUIX_FSD_DIR_BROWSE]);
      free(text[GLUIX_FSD_DIR_CHECKBOX]);
      free(text[GLUIX_FSD_OK]);
      free(text[GLUIX_FSD_CANCEL]);
      for (i=0; i<n_dirs; i++)
         free(dirs[i]);
      if (dirs)
         free(dirs);
      free(text[GLUIX_FSD_EXT_CHECKBOX]);
      free(text[GLUIX_FSD_EXT_NUMBER]);
      free(text[GLUIX_FSD_EXT_PANEL]);
      free(file_default_dir);
      free(file_default_ext);
      free(file_default_name);
      if (file_dir)
         free(file_dir);
      if (file_ext)
         free(file_ext);
      if (file_name)
         free(file_name);
      if (glui)
         glui->close();
      free(text[GLUIX_FSD_NAME_BROWSE]);
      free(text[GLUIX_FSD_NAME_CHECKBOX]);
      free(text[GLUIX_FSD_NAME_PANEL]);
      for (i=0; i<n_names; i++)
         free(names[i]);
      if (names)
         free(names);
      free(text[GLUIX_FSD_SUBMENU]);
      free(title);
   
      used[my_id] = NULL;
      n_used--;
   
   }


/*****************************************************************************/

   void GLUIX_FileSelectionDialogIntern::show(GLUI *gluiDisabled)
   
   {
   
      GLUI_Panel
         *glui_panel_but,
         *glui_panel_dir2,
         *glui_panel_ext2,
         *glui_panel_name2;
      struct stat
         stat_buf;
   
      glui_disabled = gluiDisabled;
      if (glui_disabled)
         glui_disabled->disable();
   
      if (file_dir==NULL)
         file_dir = strdup(file_default_dir);
      else if (strcmp(file_dir, file_default_dir)) {
         free(file_dir);
         file_dir = strdup(file_default_dir);
         menu_name_list = menu_dir_list = 0;
      }

      stat(file_dir, &stat_buf);
		if (stat_buf.st_mtime>dir_mtime) {
			dir_mtime = stat_buf.st_mtime;
         menu_name_list = menu_dir_list = 0;
		}
   
      if (file_ext==NULL)
         file_ext = strdup(file_default_ext);
      else if (strcmp(file_ext, file_default_ext)) {
         free(file_ext);
         file_ext = strdup(file_default_ext);
         menu_name_list = 0;
      }
   
      if (file_name==NULL)
         file_name = strdup(file_default_name);
      else if (strcmp(file_name, file_default_name)) {
         free(file_name);
         file_name = strdup(file_default_name);
      }
   
      if ((menu_dir_list==0||new_interface) && !locked_dir)
         menu_dir_list = create_dir_menu();
      if ((menu_name_list==0||new_interface) && !locked_name)
         menu_name_list = create_name_menu();
      if (glui==NULL) {
         glui = GLUI_Master.create_glui(title, flags, org_x, org_y);
         glui->bkgd_color.set(bkgd_red, bkgd_green, bkgd_blue);
         glui->bkgd_color_f[0] = (float)bkgd_red;
         glui->bkgd_color_f[1] = (float)bkgd_green;
         glui->bkgd_color_f[2] = (float)bkgd_blue;
      
         if (has_dir_panel) {
            glui_panel_dir1 = glui->add_panel(text[GLUIX_FSD_DIR_PANEL]);
            glui_panel_dir2 = glui->add_panel_to_panel(glui_panel_dir1, 
                                 "", GLUI_PANEL_NONE);
            glui_edittext_dir = glui->add_edittext_to_panel(glui_panel_dir2, 
                                 "", GLUI_EDITTEXT_TEXT, NULL, my_id, 
                                 edittext_dir_CB);
            glui_edittext_dir->set_text(file_dir);
            glui_edittext_dir->text_x_offset = 2;
            if (h[GLUIX_FSD_DIR_EDITTEXT]>0)
               glui_edittext_dir->set_h(h[GLUIX_FSD_DIR_EDITTEXT]);
            if (w[GLUIX_FSD_DIR_EDITTEXT]>0)
               glui_edittext_dir->set_w(w[GLUIX_FSD_DIR_EDITTEXT]);
            if (font[GLUIX_FSD_DIR_EDITTEXT])
               glui_edittext_dir->set_font(font[GLUIX_FSD_DIR_EDITTEXT]);
            if (!locked_dir) {
               glui->add_column_to_panel(glui_panel_dir2, false);
               glui_button_dir = glui->add_menubutton_to_panel(
                                    glui_panel_dir2, 
                                    text[GLUIX_FSD_DIR_BROWSE], GLUI_MENUBUTTON_PLAIN, 
                                    menu_dir_list, GLUT_LEFT_BUTTON);
               if (h[GLUIX_FSD_DIR_BROWSE]>0)
                  glui_button_dir->set_h(h[GLUIX_FSD_DIR_BROWSE]);
               if (w[GLUIX_FSD_DIR_BROWSE]>0)
                  glui_button_dir->set_w(w[GLUIX_FSD_DIR_BROWSE]);
               if (font[GLUIX_FSD_DIR_BROWSE])
                  glui_button_dir->set_font(font[GLUIX_FSD_DIR_BROWSE]);
            }
            if (has_dir_def_cb) {
               glui_checkbox_dir = glui->add_checkbox_to_panel(
                                    glui_panel_dir1,
                                    text[GLUIX_FSD_DIR_CHECKBOX], NULL, my_id, 
                                    checkbox_dir_CB);
               glui_checkbox_dir->set_int_val(default_dir);
               if (h[GLUIX_FSD_DIR_CHECKBOX]>0)
                  glui_checkbox_dir->set_h(h[GLUIX_FSD_DIR_CHECKBOX]);
               if (w[GLUIX_FSD_DIR_CHECKBOX]>0)
                  glui_checkbox_dir->set_w(w[GLUIX_FSD_DIR_CHECKBOX]);
               if (font[GLUIX_FSD_DIR_CHECKBOX])
                  glui_checkbox_dir->set_font(font[GLUIX_FSD_DIR_CHECKBOX]);
            }
            if (locked_dir)
               glui_panel_dir1->disable();
            if (h[GLUIX_FSD_DIR_PANEL]>0)
               glui_panel_dir1->set_h(h[GLUIX_FSD_DIR_PANEL]);
            if (w[GLUIX_FSD_DIR_PANEL]>0)
               glui_panel_dir1->set_w(w[GLUIX_FSD_DIR_PANEL]);
            if (font[GLUIX_FSD_DIR_PANEL])
               glui_panel_dir1->set_font(font[GLUIX_FSD_DIR_PANEL]);
         }
      
      
         if (has_ext_panel) {
            glui_panel_ext1 = glui->add_panel(text[GLUIX_FSD_EXT_PANEL]);
            glui_panel_ext2 = glui->add_panel_to_panel(glui_panel_ext1, 
                                 "", GLUI_PANEL_NONE);
            glui_edittext_ext = glui->add_edittext_to_panel(glui_panel_ext2, 
                                 "", GLUI_EDITTEXT_TEXT, NULL, my_id, 
                                 edittext_ext_CB);
            glui_edittext_ext->set_text(file_ext);
            glui_edittext_ext->text_x_offset = 2;
            if (h[GLUIX_FSD_EXT_EDITTEXT]>0)
               glui_edittext_ext->set_h(h[GLUIX_FSD_EXT_EDITTEXT]);
            if (w[GLUIX_FSD_EXT_EDITTEXT]>0)
               glui_edittext_ext->set_w(w[GLUIX_FSD_EXT_EDITTEXT]);
            if (font[GLUIX_FSD_EXT_EDITTEXT])
               glui_edittext_ext->set_font(font[GLUIX_FSD_EXT_EDITTEXT]);
            glui->add_column_to_panel(glui_panel_ext2, false);
            glui_edittext_num  = glui->add_edittext_to_panel(glui_panel_ext2, 
                                 text[GLUIX_FSD_EXT_NUMBER], GLUI_EDITTEXT_INT);
            glui_edittext_num->set_int_val(n_names);
            glui_edittext_num->disable();
            if (h[GLUIX_FSD_EXT_NUMBER]>0)
               glui_edittext_num->set_h(h[GLUIX_FSD_EXT_NUMBER]);
            if (w[GLUIX_FSD_EXT_NUMBER]>0)
               glui_edittext_num->set_w(w[GLUIX_FSD_EXT_NUMBER]);
            if (font[GLUIX_FSD_EXT_NUMBER])
               glui_edittext_num->set_font(font[GLUIX_FSD_EXT_NUMBER]);
            if (has_ext_def_cb) {
               glui_checkbox_ext = glui->add_checkbox_to_panel(
                                    glui_panel_ext1,
                                    text[GLUIX_FSD_EXT_CHECKBOX], NULL, my_id, 
                                    checkbox_ext_CB);
               glui_checkbox_ext->set_int_val(default_ext);
               if (h[GLUIX_FSD_EXT_CHECKBOX]>0)
                  glui_checkbox_ext->set_h(h[GLUIX_FSD_EXT_CHECKBOX]);
               if (w[GLUIX_FSD_EXT_CHECKBOX]>0)
                  glui_checkbox_ext->set_w(w[GLUIX_FSD_EXT_CHECKBOX]);
               if (font[GLUIX_FSD_EXT_CHECKBOX])
                  glui_checkbox_ext->set_font(font[GLUIX_FSD_EXT_CHECKBOX]);
            }
            if (locked_ext)
               glui_panel_ext1->disable();
            if (h[GLUIX_FSD_EXT_PANEL]>0)
               glui_panel_ext1->set_h(h[GLUIX_FSD_EXT_PANEL]);
            if (w[GLUIX_FSD_EXT_PANEL]>0)
               glui_panel_ext1->set_w(w[GLUIX_FSD_EXT_PANEL]);
            if (font[GLUIX_FSD_EXT_PANEL])
               glui_panel_ext1->set_font(font[GLUIX_FSD_EXT_PANEL]);
         }
      
         if (has_name_panel) {
            glui_panel_name1 = glui->add_panel(text[GLUIX_FSD_NAME_PANEL]);
            glui_panel_name2 = glui->add_panel_to_panel(glui_panel_name1, 
                                 "", GLUI_PANEL_NONE);
            glui_edittext_name = glui->add_edittext_to_panel(glui_panel_name2, 
                                 "", GLUI_EDITTEXT_TEXT, NULL, my_id, 
                                 edittext_name_CB);
            glui_edittext_name->set_text(file_name);
            glui_edittext_name->text_x_offset = 2;
            if (h[GLUIX_FSD_NAME_EDITTEXT]>0)
               glui_edittext_name->set_h(h[GLUIX_FSD_NAME_EDITTEXT]);
            if (w[GLUIX_FSD_NAME_EDITTEXT]>0)
               glui_edittext_name->set_w(w[GLUIX_FSD_NAME_EDITTEXT]);
            if (font[GLUIX_FSD_NAME_EDITTEXT])
               glui_edittext_name->set_font(font[GLUIX_FSD_NAME_EDITTEXT]);
            if (!locked_name) {
               glui->add_column_to_panel(glui_panel_name2, false);
               glui_button_name = glui->add_menubutton_to_panel(
                                    glui_panel_name2, 
                                    text[GLUIX_FSD_NAME_BROWSE], GLUI_MENUBUTTON_PLAIN, 
                                    menu_name_list, GLUT_LEFT_BUTTON);
               if (h[GLUIX_FSD_NAME_BROWSE]>0)
                  glui_button_name->set_h(h[GLUIX_FSD_NAME_BROWSE]);
               if (w[GLUIX_FSD_NAME_BROWSE]>0)
                  glui_button_name->set_w(w[GLUIX_FSD_NAME_BROWSE]);
               if (font[GLUIX_FSD_NAME_BROWSE])
                  glui_button_name->set_font(font[GLUIX_FSD_NAME_BROWSE]);
            }
            if (has_name_def_cb) {
               glui_checkbox_name = glui->add_checkbox_to_panel(
                                    glui_panel_name1,
                                    text[GLUIX_FSD_NAME_CHECKBOX], NULL, my_id, 
                                    checkbox_name_CB);
               glui_checkbox_name->set_int_val(default_name);
               if (h[GLUIX_FSD_NAME_CHECKBOX]>0)
                  glui_checkbox_name->set_h(h[GLUIX_FSD_NAME_CHECKBOX]);
               if (w[GLUIX_FSD_NAME_CHECKBOX]>0)
                  glui_checkbox_name->set_w(w[GLUIX_FSD_NAME_CHECKBOX]);
               if (font[GLUIX_FSD_NAME_CHECKBOX])
                  glui_checkbox_name->set_font(font[GLUIX_FSD_NAME_CHECKBOX]);
            }
            if (locked_name)
               glui_panel_name1->disable();
            if (h[GLUIX_FSD_NAME_PANEL]>0)
               glui_panel_name1->set_h(h[GLUIX_FSD_NAME_PANEL]);
            if (w[GLUIX_FSD_NAME_PANEL]>0)
               glui_panel_name1->set_w(w[GLUIX_FSD_NAME_PANEL]);
            if (font[GLUIX_FSD_NAME_PANEL])
               glui_panel_name1->set_font(font[GLUIX_FSD_NAME_PANEL]);
         }
      
         glui_panel_but = glui->add_panel("", GLUI_PANEL_NONE);
         glui_button_OK = glui->add_button_to_panel(
                              glui_panel_but, text[GLUIX_FSD_OK], my_id, OK_CB);
         glui->add_column_to_panel(glui_panel_but, false);
         glui_button_cancel = glui->add_button_to_panel(
                              glui_panel_but, text[GLUIX_FSD_CANCEL], my_id, cancel_CB);
      }
      else {
         if (has_dir_panel) {
            glui_edittext_dir->set_text(file_dir);
            if (!locked_dir)
               glui_button_dir->set_menu(menu_dir_list);
         }
         if (has_ext_panel) {
            glui_edittext_ext->set_text(file_ext);
            glui_edittext_num->set_int_val(n_names);
         }
         if (has_name_panel) {
            glui_edittext_name->set_text(file_name);
            if (!locked_name)
               glui_button_name->set_menu(menu_name_list);
         }
         if (new_bkgd_color) {
            glui->bkgd_color.set(bkgd_red, bkgd_green, bkgd_blue);
            glui->bkgd_color_f[0] = (float)bkgd_red;
            glui->bkgd_color_f[1] = (float)bkgd_green;
            glui->bkgd_color_f[2] = (float)bkgd_blue;
         }
         if (new_interface) {
            if (has_dir_panel) {
               glui_panel_dir1->set_name(text[GLUIX_FSD_DIR_PANEL]);
               if (!locked_dir) {
                  glui_button_dir->set_name(text[GLUIX_FSD_DIR_BROWSE]);
                  if (h[GLUIX_FSD_DIR_BROWSE]>0)
                     glui_button_dir->set_h(h[GLUIX_FSD_DIR_BROWSE]);
                  if (w[GLUIX_FSD_DIR_BROWSE]>0)
                     glui_button_dir->set_w(w[GLUIX_FSD_DIR_BROWSE]);
                  if (font[GLUIX_FSD_DIR_BROWSE])
                     glui_button_dir->set_font(font[GLUIX_FSD_DIR_BROWSE]);
               }
               if (has_dir_def_cb) {
                  glui_checkbox_dir->set_name(text[GLUIX_FSD_DIR_CHECKBOX]);
                  if (h[GLUIX_FSD_DIR_CHECKBOX]>0)
                     glui_checkbox_dir->set_h(h[GLUIX_FSD_DIR_CHECKBOX]);
                  if (w[GLUIX_FSD_DIR_CHECKBOX]>0)
                     glui_checkbox_dir->set_w(w[GLUIX_FSD_DIR_CHECKBOX]);
                  if (font[GLUIX_FSD_DIR_CHECKBOX])
                     glui_checkbox_dir->set_font(font[GLUIX_FSD_DIR_CHECKBOX]);
               }
               if (h[GLUIX_FSD_DIR_EDITTEXT]>0)
                  glui_edittext_dir->set_h(h[GLUIX_FSD_DIR_EDITTEXT]);
               if (w[GLUIX_FSD_DIR_EDITTEXT]>0)
                  glui_edittext_dir->set_w(w[GLUIX_FSD_DIR_EDITTEXT]);
               if (font[GLUIX_FSD_DIR_EDITTEXT])
                  glui_edittext_dir->set_font(font[GLUIX_FSD_DIR_EDITTEXT]);
               if (h[GLUIX_FSD_DIR_PANEL]>0)
                  glui_panel_dir1->set_h(h[GLUIX_FSD_DIR_PANEL]);
               if (w[GLUIX_FSD_DIR_PANEL]>0)
                  glui_panel_dir1->set_w(w[GLUIX_FSD_DIR_PANEL]);
               if (font[GLUIX_FSD_DIR_PANEL])
                  glui_panel_dir1->set_font(font[GLUIX_FSD_DIR_PANEL]);
            }
            if (has_ext_panel) {
               glui_panel_ext1->set_name(text[GLUIX_FSD_EXT_PANEL]);
               glui_edittext_ext->set_name(text[GLUIX_FSD_EXT_NUMBER]);
               if (has_ext_def_cb) {
                  glui_checkbox_ext->set_name(text[GLUIX_FSD_EXT_CHECKBOX]);
                  if (h[GLUIX_FSD_EXT_CHECKBOX]>0)
                     glui_checkbox_ext->set_h(h[GLUIX_FSD_EXT_CHECKBOX]);
                  if (w[GLUIX_FSD_EXT_CHECKBOX]>0)
                     glui_checkbox_ext->set_w(w[GLUIX_FSD_EXT_CHECKBOX]);
                  if (font[GLUIX_FSD_EXT_CHECKBOX])
                     glui_checkbox_ext->set_font(font[GLUIX_FSD_EXT_CHECKBOX]);
               }
               if (h[GLUIX_FSD_EXT_EDITTEXT]>0)
                  glui_edittext_ext->set_h(h[GLUIX_FSD_EXT_EDITTEXT]);
               if (w[GLUIX_FSD_EXT_EDITTEXT]>0)
                  glui_edittext_ext->set_w(w[GLUIX_FSD_EXT_EDITTEXT]);
               if (font[GLUIX_FSD_EXT_EDITTEXT])
                  glui_edittext_ext->set_font(font[GLUIX_FSD_EXT_EDITTEXT]);
               if (h[GLUIX_FSD_EXT_NUMBER]>0)
                  glui_edittext_num->set_h(h[GLUIX_FSD_EXT_NUMBER]);
               if (w[GLUIX_FSD_EXT_NUMBER]>0)
                  glui_edittext_num->set_w(w[GLUIX_FSD_EXT_NUMBER]);
               if (font[GLUIX_FSD_EXT_NUMBER])
                  glui_edittext_num->set_font(font[GLUIX_FSD_EXT_NUMBER]);
               if (h[GLUIX_FSD_EXT_PANEL]>0)
                  glui_panel_ext1->set_h(h[GLUIX_FSD_EXT_PANEL]);
               if (w[GLUIX_FSD_EXT_PANEL]>0)
                  glui_panel_ext1->set_w(w[GLUIX_FSD_EXT_PANEL]);
               if (font[GLUIX_FSD_EXT_PANEL])
                  glui_panel_ext1->set_font(font[GLUIX_FSD_EXT_PANEL]);
            }
            if (has_name_panel) {
               glui_panel_name1->set_name(text[GLUIX_FSD_NAME_PANEL]);
               if (!locked_name) {
                  glui_button_name->set_name(text[GLUIX_FSD_NAME_BROWSE]);
                  if (h[GLUIX_FSD_NAME_BROWSE]>0)
                     glui_button_name->set_h(h[GLUIX_FSD_NAME_BROWSE]);
                  if (w[GLUIX_FSD_NAME_BROWSE]>0)
                     glui_button_name->set_w(w[GLUIX_FSD_NAME_BROWSE]);
                  if (font[GLUIX_FSD_NAME_BROWSE])
                     glui_button_name->set_font(font[GLUIX_FSD_NAME_BROWSE]);
               }
               if (has_dir_def_cb) {
                  glui_checkbox_name->set_name(text[GLUIX_FSD_NAME_CHECKBOX]);
                  if (h[GLUIX_FSD_NAME_CHECKBOX]>0)
                     glui_checkbox_name->set_h(h[GLUIX_FSD_NAME_CHECKBOX]);
                  if (w[GLUIX_FSD_NAME_CHECKBOX]>0)
                     glui_checkbox_name->set_w(w[GLUIX_FSD_NAME_CHECKBOX]);
                  if (font[GLUIX_FSD_NAME_CHECKBOX])
                     glui_checkbox_name->set_font(font[GLUIX_FSD_NAME_CHECKBOX]);
               }
               if (h[GLUIX_FSD_NAME_EDITTEXT]>0)
                  glui_edittext_name->set_h(h[GLUIX_FSD_NAME_EDITTEXT]);
               if (w[GLUIX_FSD_NAME_EDITTEXT]>0)
                  glui_edittext_name->set_w(w[GLUIX_FSD_NAME_EDITTEXT]);
               if (font[GLUIX_FSD_NAME_EDITTEXT])
                  glui_edittext_name->set_font(font[GLUIX_FSD_NAME_EDITTEXT]);
               if (h[GLUIX_FSD_NAME_PANEL]>0)
                  glui_panel_name1->set_h(h[GLUIX_FSD_NAME_PANEL]);
               if (w[GLUIX_FSD_NAME_PANEL]>0)
                  glui_panel_name1->set_w(w[GLUIX_FSD_NAME_PANEL]);
               if (font[GLUIX_FSD_NAME_PANEL])
                  glui_panel_name1->set_font(font[GLUIX_FSD_NAME_PANEL]);
            }
            glui_button_OK->set_name(text[GLUIX_FSD_OK]);
            glui_button_cancel->set_name(text[GLUIX_FSD_CANCEL]);
         }
         glui->show();
      }
      shown = 1;
      new_bkgd_color = false;
      new_interface = false;
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::create_name_menu(void)
   
   {
   
   #if defined(_WIN32) && !defined(__GNUC__)
     HANDLE h;
      WIN32_FIND_DATA find_data;
     char *pattern;
   #else
      DIR
         *dir;
      struct dirent
         *dp;
   #endif
      struct stat
         stat_buf;
      int
         access_OK,
         i,
         j,
         len_ext,
         len_name,
         type_OK;
      char
         *directory = file_dir,
         *extension = file_ext,
         *ending,
         *pwd;
   
      if (n_names_alloc==0) {
         n_names_alloc = N_FILES_ALLOC;
         names = (char **)calloc(n_names_alloc, sizeof(char *));
      }
      if (n_menus_names_alloc==0) {
         n_menus_names_alloc = N_MENUS_ALLOC;
         Menu_names = (int *)calloc(n_menus_names_alloc, sizeof(int));
      }
   
      for (j=0; j<n_names; j++) {
         free(names[j]);
      }
   
   #if defined(_WIN32) && !defined(__GNUC__)
     pattern = (char *)malloc(strlen(directory)+3);
     strcpy(pattern, directory);
     strcat(pattern, "\\*");
      h = FindFirstFile(pattern, &find_data);
     free(pattern);
      if (h==INVALID_HANDLE_VALUE) {
   	 LPVOID lpMsgBuf;
   	 FormatMessage( 
   		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
   		FORMAT_MESSAGE_FROM_SYSTEM | 
   		FORMAT_MESSAGE_IGNORE_INSERTS,
   		NULL,
   		GetLastError(),
   		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
   		(LPTSTR) &lpMsgBuf,
   		0,
   		NULL 
   	 );
   	 cerr << (LPTSTR)lpMsgBuf << endl;
   	 return 0;
     }
      pwd = getcwd(NULL, 0);
      chdir(directory);
      len_ext = strlen(extension);
      n_names = 0;
      do {
         if (0==strcmp(find_data.cFileName, ".")
   			|| 0==strcmp(find_data.cFileName, ".."))
            continue;
         len_name = strlen(find_data.cFileName);
         if (len_name>=len_ext) {
            ending = &find_data.cFileName[len_name - len_ext];
            stat(find_data.cFileName, &stat_buf);
            if (type==GLUIX_REG)
               type_OK = S_ISREG(stat_buf.st_mode);
            else if (type==GLUIX_DIR)
               type_OK = S_ISDIR(stat_buf.st_mode);
            else
               type_OK = false;
            if (access_name==-1)
               access_OK = true;
            else if (access(find_data.cFileName, access_name)==0)
               access_OK = true;
            else
               access_OK = false;
            if (!strcmp(ending, extension) && type_OK && access_OK) {
               if (n_names==n_names_alloc) {
                  n_names_alloc += N_FILES_ALLOC;
                  names = (char **)realloc(
                                       names, n_names_alloc*sizeof(char *));
               }
               names[n_names++] = strdup(find_data.cFileName);
            }
         }
      } while (FindNextFile(h, &find_data));
      FindClose(h);
   #else
      dir = opendir(directory);
      if (dir==NULL) {
         cerr << endl << "Error opening directory " 
            << directory << endl;
         return 0;
      }
      pwd = getcwd(NULL, 0);
      chdir(directory);
      len_ext = strlen(extension);
      n_names = 0;
      for (dp=readdir(dir); dp!=NULL; dp=readdir(dir)) {
         if (0==strcmp(dp->d_name, ".") || 0==strcmp(dp->d_name, ".."))
            continue;
         len_name = strlen(dp->d_name);
         if (len_name>=len_ext) {
            ending = &dp->d_name[len_name - len_ext];
            stat(dp->d_name, &stat_buf);
            if (type==GLUIX_REG)
               type_OK = S_ISREG(stat_buf.st_mode);
            else if (type==GLUIX_DIR)
               type_OK = S_ISDIR(stat_buf.st_mode);
            else
               type_OK = false;
            if (access_name==-1)
               access_OK = true;
            else if (access(dp->d_name, access_name)==0)
               access_OK = true;
            else
               access_OK = false;
            if (!strcmp(ending, extension) && type_OK && access_OK) {
               if (n_names==n_names_alloc) {
                  n_names_alloc += N_FILES_ALLOC;
                  names = (char **)realloc(
                                       names, n_names_alloc*sizeof(char *));
               }
               names[n_names++] = strdup(dp->d_name);
            }
         }
      }
      closedir(dir);
   #endif
      chdir(pwd);
      free(pwd);
   
      if (n_names==0)
         return 0;
   
      qsort(names, n_names, sizeof(char *), compare);
   
      for (j=0; j<n_menus_names; j++) {
         glutDestroyMenu(Menu_names[j]);
      }
   
      j = 0;
      Menu_names[j] = glutCreateMenu(menu_name_select_CB);
      for (i=0; i<n_names; i++) {
         if (i>0 && i%n_items_max==0) {
            if (j==n_menus_names_alloc) {
               n_menus_names_alloc += N_MENUS_ALLOC;
               Menu_names = (int *)realloc(
                                    Menu_names, 
                                    n_menus_names_alloc*sizeof(int));
            }
            Menu_names[++j] = glutCreateMenu(menu_name_select_CB);
            glutSetMenu(Menu_names[j-1]);
            glutAddSubMenu(text[GLUIX_FSD_SUBMENU], Menu_names[j]);
            glutSetMenu(Menu_names[j]);
         }
         glutAddMenuEntry(names[i], (my_id<<24)+i);
      }
      n_menus_names = j + 1;
   
      return Menu_names[0];
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::create_dir_menu(void)
   
   {
   
   #if defined(_WIN32) && !defined(__GNUC__)
     HANDLE h;
      WIN32_FIND_DATA find_data;
     char *pattern;
   #else  
      DIR
         *dir;
      struct dirent
         *dp;
   #endif
      struct stat
         stat_buf;
      int
         i,
         j;
      char
         *directory = file_dir,
         *pwd;
   
      if (n_dirs_alloc==0) {
         n_dirs_alloc = N_FILES_ALLOC;
         dirs = (char **)malloc(n_dirs_alloc*sizeof(char *));
      }
      if (n_menus_dirs_alloc==0) {
         n_menus_dirs_alloc = N_MENUS_ALLOC;
         Menu_dirs = (int *)calloc(n_menus_dirs_alloc, sizeof(int));
      }
   
      for (j=0; j<n_dirs; j++) {
         free(dirs[j]);
      }
   
   #if defined(_WIN32) && !defined(__GNUC__)
     pattern = (char *)malloc(strlen(directory)+3);
     strcpy(pattern, directory);
     strcat(pattern, "\\*");
      h = FindFirstFile(pattern, &find_data);
     free(pattern);
      if (h==INVALID_HANDLE_VALUE) {
   	 LPVOID lpMsgBuf;
   	 FormatMessage( 
   		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
   		FORMAT_MESSAGE_FROM_SYSTEM | 
   		FORMAT_MESSAGE_IGNORE_INSERTS,
   		NULL,
   		GetLastError(),
   		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
   		(LPTSTR) &lpMsgBuf,
   		0,
   		NULL 
   	 );
   	 cerr << (LPTSTR)lpMsgBuf << endl;
   	 return 0;
     }
      pwd = getcwd(NULL, 0);
      chdir(directory);
      n_dirs = 0;
      if (strcmp(directory, "/")) 
         dirs[n_dirs++] = strdup("..");
      do {
         if (0==strcmp(find_data.cFileName, ".") || 0==strcmp(find_data.cFileName, ".."))
            continue;
         stat(find_data.cFileName, &stat_buf);
         if (S_ISDIR(stat_buf.st_mode) && access(find_data.cFileName, R_OK|X_OK)==0) {
            if (n_dirs==n_dirs_alloc) {
               n_dirs_alloc += N_FILES_ALLOC;
               dirs = (char **)realloc(dirs, n_dirs_alloc*sizeof(char *));
            }
            dirs[n_dirs++] = strdup(find_data.cFileName);
   	 }
      } while (FindNextFile(h, &find_data));
      FindClose(h);
   #else
      dir = opendir(directory);
      if (dir==NULL) {
         cerr << endl << "Error opening directory " 
            << directory << endl;
         return 0;
      }
      pwd = getcwd(NULL, 0);
      chdir(directory);
      n_dirs = 0;
      if (strcmp(directory, "/")) 
         dirs[n_dirs++] = strdup("..");
      for (dp=readdir(dir); dp!=NULL; dp=readdir(dir)) {
         if (0==strcmp(dp->d_name, ".") || 0==strcmp(dp->d_name, ".."))
            continue;
         stat(dp->d_name, &stat_buf);
         if (S_ISDIR(stat_buf.st_mode) && access(dp->d_name, R_OK|X_OK)==0) {
            if (n_dirs==n_dirs_alloc) {
               n_dirs_alloc += N_FILES_ALLOC;
               dirs = (char **)realloc(dirs, n_dirs_alloc*sizeof(char *));
            }
            dirs[n_dirs++] = strdup(dp->d_name);
         }
      }
      closedir(dir);
   #endif
      chdir(pwd);
      free(pwd);
   
      if (n_dirs==0)
         return 0;
   
      qsort(dirs, n_dirs, sizeof(char *), compare);
   
      for (j=0; j<n_menus_dirs; j++) {
         glutDestroyMenu(Menu_dirs[j]);
      }
   
      j = 0;
      Menu_dirs[j] = glutCreateMenu(menu_dir_select_CB);
      for (i=0; i<n_dirs; i++) {
         if (i>0 && i%n_items_max==0) {
            if (j==n_menus_dirs_alloc) {
               n_menus_dirs_alloc += N_MENUS_ALLOC;
               Menu_dirs = (int *)realloc(
                                    Menu_dirs, n_menus_dirs_alloc*sizeof(int));
            }
            Menu_dirs[++j] = glutCreateMenu(menu_dir_select_CB);
            glutSetMenu(Menu_dirs[j-1]);
            glutAddSubMenu(text[GLUIX_FSD_SUBMENU], Menu_dirs[j]);
            glutSetMenu(Menu_dirs[j]);
         }
         glutAddMenuEntry(dirs[i], (my_id<<24)+i);
      }
      n_menus_dirs = j + 1;
   
      return Menu_dirs[0];
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::compare(
                     const void *a,
                     const void *b
                     )
   
   {
   
      char
         **ca,
         **cb;
   
      ca = (char **)a;
      cb = (char **)b;
   
      return(strcmp(*ca, *cb));
   
   }


/*****************************************************************************/

   void	GLUIX_FileSelectionDialogIntern::checkbox_dir_CB(int id)
   
   {
   
      GLUIX_FileSelectionDialogIntern
         *me;
   
      if (id>=0 && id<n_alloc) {
         me = used[id];
         if (me) {
            me->default_dir = !me->default_dir;
         }
      }
   
   }


/*****************************************************************************/

   void	GLUIX_FileSelectionDialogIntern::checkbox_ext_CB(int id)
   
   {
   
      GLUIX_FileSelectionDialogIntern
         *me;
   
      if (id>=0 && id<n_alloc) {
         me = used[id];
         if (me) {
            me->default_ext = !me->default_ext;
         }
      }
   
   }


/*****************************************************************************/

   void	GLUIX_FileSelectionDialogIntern::checkbox_name_CB(int id)
   
   {
   
      GLUIX_FileSelectionDialogIntern
         *me;
   
      if (id>=0 && id<n_alloc) {
         me = used[id];
         if (me) {
            me->default_name = !me->default_name;
         }
      }
   
   }


/*****************************************************************************/

   void	GLUIX_FileSelectionDialogIntern::edittext_ext_CB(int id)
   
   {
   
      char
         *new_file_ext;
      GLUIX_FileSelectionDialogIntern
         *me;
   
      if (id>=0 && id<n_alloc) {
         me = used[id];
         if (me) {
            new_file_ext = me->glui_edittext_ext->get_text();
            if (strcmp(me->file_ext, new_file_ext)) {
               free(me->file_ext);
               me->file_ext = strdup(new_file_ext);
               free(me->file_name);
               me->file_name = strdup(me->file_default_name);
               if (me->has_name_panel)
                  me->glui_edittext_name->set_text(me->file_name);
               if (me->has_name_panel && !me->locked_name) {
                  me->menu_name_list = me->create_name_menu();
                  me->glui_button_name->set_menu(me->menu_name_list);
               }
               me->glui_edittext_num->set_int_val(me->n_names);
            }
         }
      }
   
   }


/*****************************************************************************/

   void	GLUIX_FileSelectionDialogIntern::edittext_dir_CB(int id)
   
   {
   
      char
         *new_file_dir;
      struct stat
         stat_buf;
      GLUIX_FileSelectionDialogIntern
         *me;
   
      if (id>=0 && id<n_alloc) {
         me = used[id];
         if (me) {   
            new_file_dir = me->glui_edittext_dir->get_text();
         
            if (access(new_file_dir, R_OK|X_OK)) {
               me->glui_edittext_dir->set_text(me->file_dir);
               return;
            }
            stat(new_file_dir, &stat_buf);
            if (!S_ISDIR(stat_buf.st_mode)) {
               me->glui_edittext_dir->set_text(me->file_dir);
               return;
            }
         
            free(me->file_dir);
            me->file_dir = strdup(new_file_dir);
            me->menu_dir_list = me->create_dir_menu();
            me->glui_button_dir->set_menu(me->menu_dir_list);
            free(me->file_name);
            me->file_name = strdup(me->file_default_name);
            if (me->has_name_panel) {
               me->glui_edittext_name->set_text(me->file_name);
               if (!me->locked_name) {
                  me->menu_name_list = me->create_name_menu();
                  me->glui_button_name->set_menu(me->menu_name_list);
               }
            }
            if (me->has_ext_panel)
               me->glui_edittext_num->set_int_val(me->n_names);
         }
      }
   
   }


/*****************************************************************************/

   void	GLUIX_FileSelectionDialogIntern::edittext_name_CB(int id)
   
   {
   
      char
         *new_file_name,
         *pwd;
      int
         badtype,
         noaccess = false;
      struct stat
         stat_buf;
      GLUIX_FileSelectionDialogIntern
         *me;
   
      if (id>=0 && id<n_alloc) {
         me = used[id];
         if (me) {
            new_file_name = me->glui_edittext_name->get_text();
         
            pwd = getcwd(NULL, 0);
            chdir(me->file_dir);
            if (me->access_name>-1) {
               noaccess = access(new_file_name, me->access_name);
            }
            stat(new_file_name, &stat_buf);
            if (me->type==GLUIX_REG)
               badtype = !S_ISREG(stat_buf.st_mode);
            else if (me->type==GLUIX_DIR)
               badtype = !S_ISDIR(stat_buf.st_mode);
            else
               badtype = false;
            chdir(pwd);
            free(pwd);
         
            if (noaccess || badtype) {
               me->glui_edittext_name->set_text(me->file_name);
               return;
            }
         
            free(me->file_name);
            me->file_name = strdup(new_file_name);
         }
      }
   
   }


/*****************************************************************************/

   void	GLUIX_FileSelectionDialogIntern::menu_name_select_CB(int code)
   
   {
   
      int
         id,
         item;
      GLUIX_FileSelectionDialogIntern
         *me;
   
      id = code>>24;
      item = code - (id<<24);
   
      if (id>=0 && id<n_alloc) {
         me = used[id];
         if (me) {
            if (item>=0 && item<me->n_names) {
               free(me->file_name);
               me->file_name = strdup(me->names[item]);
               me->glui_edittext_name->set_text(me->file_name);
            }
         }
      }
   
   }


/*****************************************************************************/

   void	GLUIX_FileSelectionDialogIntern::menu_dir_select_CB(int code)
   
   {
   
      int
         id,
         item;
      GLUIX_FileSelectionDialogIntern
         *me;
      static char
         abs_path[FILENAME_MAX+1],
         rel_path[2*FILENAME_MAX+2];
   
      id = code>>24;
      item = code - (id<<24);
   
      if (id>=0 && id<n_alloc) {
         me = used[id];
         if (me) {
            if (item>=0 && item<me->n_dirs) {
               strncpy(rel_path, me->file_dir, FILENAME_MAX);
               if (strcmp(me->file_dir, "/")) 
                  strcat(rel_path, "/");
               strncat(rel_path, me->dirs[item], FILENAME_MAX);
            #if defined(__MINGW32__) || defined(_WIN32) && !defined(__CYGWIN__)
               _fullpath(abs_path, rel_path, FILENAME_MAX);
            #else
               realpath(rel_path, abs_path);
            #endif
               free(me->file_dir);
               me->file_dir = strdup(abs_path);
               me->glui_edittext_dir->set_text(me->file_dir);
               me->menu_dir_list = me->create_dir_menu();
               me->glui_button_dir->set_menu(me->menu_dir_list);
               free(me->file_name);
               me->file_name = strdup(me->file_default_name);
               if (me->has_name_panel) {
                  me->glui_edittext_name->set_text(me->file_name);
                  if (!me->locked_name) {
                     me->menu_name_list = me->create_name_menu();
                     me->glui_button_name->set_menu(me->menu_name_list);
                  }
               }
               if (me->has_ext_panel)
                  me->glui_edittext_num->set_int_val(me->n_names);
            }
         }
      }
   
   }


/*****************************************************************************/

   void GLUIX_FileSelectionDialogIntern::OK_CB(int id)
   
   {
   
      GLUIX_FileSelectionDialogIntern
         *me;
   
      if (id>=0 && id<n_alloc) {
         me = used[id];
         if (me) {  
            if (me->default_dir) {
               if (me->file_default_dir) 
                  free(me->file_default_dir);
               me->file_default_dir = strdup(me->file_dir);
            }
            if (me->default_ext) {
               if (me->file_default_ext) 
                  free(me->file_default_ext);
               me->file_default_ext = strdup(me->file_ext);
            }
            if (me->default_name) {
               if (me->file_default_name) 
                  free(me->file_default_name);
               me->file_default_name = strdup(me->file_name);
            }
         
            if (me->glui)
               me->glui->hide();
         
            if (me->glui_disabled)
               me->glui_disabled->enable();
         
            if (me->new_file_CB)
               (me->new_file_CB)(me->file_dir, me->file_name, me->file_ext);
         
            me->shown = 0;
         }
      }
   }


/*****************************************************************************/

   void GLUIX_FileSelectionDialogIntern::cancel_CB(int id)
   
   {
   
      GLUIX_FileSelectionDialogIntern
         *me;
   
      if (id>=0 && id<n_alloc) {
         me = used[id];
         if (me) {
            if (me->glui)
               me->glui->hide();
            if (me->glui_disabled)
               me->glui_disabled->enable();
            me->shown = 0;
         }
      }
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::set_default_dir(
                     char	*FileDefaultDir, 
                     int	DefaultValueReset
                     )
   
   {
   
      if (shown)
         return -1;
      free(file_default_dir);
      if (FileDefaultDir==NULL)
         file_default_dir = strdup(".");
      else
         file_default_dir = strdup(FileDefaultDir);
      if (default_dir!=DefaultValueReset) {
         default_dir = DefaultValueReset;
         if (glui_checkbox_dir)
            glui_checkbox_dir->set_int_val(default_dir);
      }
      return 0;
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::set_default_ext(
                     char	*FileDefaultExt, 
                     int	DefaultValueReset
                     )
   
   {
   
      if (shown)
         return -1;
      free(file_default_ext);
      if (FileDefaultExt==NULL)
         file_default_ext = strdup("");
      else
         file_default_ext = strdup(FileDefaultExt);
      if (default_ext!=DefaultValueReset) {
         default_ext = DefaultValueReset;
         if (glui_checkbox_ext)
            glui_checkbox_ext->set_int_val(default_ext);
      }
      return 0;
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::set_default_name(
                     char	*FileDefaultName, 
                     int	DefaultValueReset
                     )
   
   {
   
      if (shown)
         return -1;
      free(file_default_name);
      if (FileDefaultName==NULL)
         file_default_name = strdup("");
      else
         file_default_name = strdup(FileDefaultName);
      if (default_name!=DefaultValueReset) {
         default_name = DefaultValueReset;
         if (glui_checkbox_name)
            glui_checkbox_name->set_int_val(default_name);
      }
      return 0;
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::set_access(int Access)
   
   {
   
      if (shown)
         return -1;
      if (Access>0)
         access_name = 0;
      else
         access_name = -1;
      if (Access&GLUIX_READABLE)
         access_name |= R_OK;
      if (Access&GLUIX_WRITABLE)
         access_name |= W_OK;
      if (Access&GLUIX_EXECUTABLE)
         access_name |= X_OK;
      return 0;
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::set_bkgd_color(
                     Byte Red, Byte Green, Byte Blue)
   
   {
   
      if (shown)
         return -1;
   
      bkgd_red   = Red;
      bkgd_green = Green;
      bkgd_blue  = Blue;
   
      new_bkgd_color = true;
   
      return 0;
   
   }


#ifdef DEPRECATED
/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::set_interface_text(
                     char *DirPanelText,
                     char *DirBrowseText,
                     char *DirCheckboxText,
                     char *ExtPanelText,
                     char *ExtNumberText,
                     char *ExtCheckboxText,
                     char *NamePanelText,
                     char *NameBrowseText,
                     char *NameCheckboxText,
                     char *OKText,
                     char *CancelText,
                     char *SubMenuText
                     )
   
   {
   
      if (shown)
         return -1;
   
      if (DirPanelText!=NULL) {
         free(text[GLUIX_FSD_DIR_PANEL]);
         text[GLUIX_FSD_DIR_PANEL] = strdup(DirPanelText);
      }
      if (DirBrowseText!=NULL) {
         free(text[GLUIX_FSD_DIR_BROWSE]);
         text[GLUIX_FSD_DIR_BROWSE] = strdup(DirBrowseText);
      }
      if (DirCheckboxText!=NULL) {
         free(text[GLUIX_FSD_DIR_CHECKBOX]);
         text[GLUIX_FSD_DIR_CHECKBOX] = strdup(DirCheckboxText);
      }
   
      if (ExtPanelText!=NULL) {
         free(text[GLUIX_FSD_EXT_PANEL]);
         text[GLUIX_FSD_EXT_PANEL] = strdup(ExtPanelText);
      }
      if (ExtNumberText!=NULL) {
         free(text[GLUIX_FSD_EXT_NUMBER]);
         text[GLUIX_FSD_EXT_NUMBER] = strdup(ExtNumberText);
      }
      if (ExtCheckboxText!=NULL) {
         free(text[GLUIX_FSD_EXT_CHECKBOX]);
         text[GLUIX_FSD_EXT_CHECKBOX] = strdup(ExtCheckboxText);
      }
   
      if (NamePanelText!=NULL) {
         free(text[GLUIX_FSD_NAME_PANEL]);
         text[GLUIX_FSD_NAME_PANEL] = strdup(NamePanelText);
      }
      if (NameBrowseText!=NULL) {
         free(text[GLUIX_FSD_NAME_BROWSE]);
         text[GLUIX_FSD_NAME_BROWSE] = strdup(NameBrowseText);
      }
      if (NameCheckboxText!=NULL) {
         free(text[GLUIX_FSD_NAME_CHECKBOX]);
         text[GLUIX_FSD_NAME_CHECKBOX] = strdup(NameCheckboxText);
      }
   
      if (OKText!=NULL) {
         free(text[GLUIX_FSD_OK]);
         text[GLUIX_FSD_OK] = strdup(OKText);
      }
      if (CancelText!=NULL) {
         free(text[GLUIX_FSD_CANCEL]);
         text[GLUIX_FSD_CANCEL] = strdup(CancelText);
      }
      if (SubMenuText!=NULL) {
         free(text[GLUIX_FSD_SUBMENU]);
         text[GLUIX_FSD_SUBMENU] = strdup(SubMenuText);
      }
   
      new_interface = true;
   
      return 0;
   
   }


#endif
/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::set_text(
                     enum GLUIX_FSD_Part part, 
                     char *new_text)
   
   {
   
      if (shown)
         return -1;
      if (new_text==NULL)
         return -2;
   
      switch (part) {
         case GLUIX_FSD_DIR_PANEL:
         case GLUIX_FSD_DIR_BROWSE:
         case GLUIX_FSD_DIR_CHECKBOX:
         case GLUIX_FSD_EXT_PANEL:
         case GLUIX_FSD_EXT_NUMBER:
         case GLUIX_FSD_EXT_CHECKBOX:
         case GLUIX_FSD_NAME_PANEL:
         case GLUIX_FSD_NAME_BROWSE:
         case GLUIX_FSD_NAME_CHECKBOX:
         case GLUIX_FSD_OK:
         case GLUIX_FSD_CANCEL:
         case GLUIX_FSD_SUBMENU:
            free(text[part]);
            text[part] = strdup(new_text);
            break;
         default:
            return 1;
      }
   
      new_interface = true;
   
      return 0;
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::set_h(
                     enum GLUIX_FSD_Part part, 
                     int new_size)
   
   {
   
      if (shown)
         return -1;
   
      if (part==GLUIX_FSD_SUBMENU)
         return 1;
   
      h[part] = new_size;
   
      new_interface = true;
   
      return 0;
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::set_w(
                     enum GLUIX_FSD_Part part, 
                     int new_size)
   
   {
   
      if (shown)
         return -1;
   
      if (part==GLUIX_FSD_SUBMENU)
         return 1;
   
      w[part] = new_size;
   
      new_interface = true;
   
      return 0;
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::set_font(
                     enum GLUIX_FSD_Part part, 
                     void *new_font)
   
   {
   
      if (shown)
         return -1;
      if (new_font==NULL)
         return -2;
   
      if (part==GLUIX_FSD_SUBMENU)
         return 1;
   
      font[part] = new_font;
      new_interface = true;
   
      return 0;
   
   }


/*****************************************************************************/

   int GLUIX_FileSelectionDialogIntern::set_n_items_max(
                     int new_n_items_max)
   
   {
   
      if (shown)
         return -1;
      if (new_n_items_max<1)
         return -2;
   
      n_items_max = new_n_items_max;
   
      return 0;
   
   }
