#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
# Note that bzip2 generates TWO different binary packages:
# 1) bzip2    -- includes static libs, import libs, executables,
#                header files, documentation
# 2) libbz2_1 -- includes only the DLLs
export FULLPKG=${PKG}-${VER}-${REL}
export FULLPKG2=mingw-libbz2_1-${VER}-${REL}
export BASEPKG=`echo $PKG | sed -e 's/mingw-//'`

# determine correct decompression option and tarball filename
if [ -e ${BASEPKG}-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${BASEPKG}-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=${BASEPKG}-${VER}.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_pkg_name2=${FULLPKG2}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${FULLPKG2}.tar.bz2
export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_pkg2=${topdir}/${src_pkg_name2}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg_name2}
export srcdir=${topdir}/${BASEPKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on 
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-mingw32
prefix=/usr
pnoslash=`echo $prefix | sed -e 's#^/##'`
sysconfdir=/etc
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
MY_CC=${objdir}/mgcc
MY_CFLAGS="-O2"
MY_LDFLAGS="-L/usr/lib/mingw"

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir}
)}

mktools() {
  cat >${objdir}/mgcc <<EOF
#!/bin/sh
gcc -mno-cygwin \$*
EOF
  chmod +x ${objdir}/mgcc
}

prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} && \
  cd ${srcdir} && \
  patch -p1 < ${src_patch} 
  chmod +x ${srcdir}/CYGWIN-PATCHES/shtool && \
  mkdirs && \
  CYGWIN-PATCHES/shtool mkshadow -v . .build
  mktools
)}

conf() {
	echo Configuration complete.
}

build() {
  (cd ${objdir} && \
  make CC="${MY_CC}" CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  DESTDIR=${instdir}
)}

check() {
  (cd ${objdir} && \
  make test | tee ${checkfile} 2>&1
)}

clean() {
  (cd ${objdir} && \
  make clean
)}
install-mingw-cleanup() {
  (cd ${objdir}
  delfiles="${prefix}/share/man/man1/bzcmp.1 \
            ${prefix}/share/man/man1/bzdiff.1 \
            ${prefix}/share/man/man1/bzegrep.1 \
            ${prefix}/share/man/man1/bzfgrep.1 \
            ${prefix}/share/man/man1/bzgrep.1 \
            ${prefix}/share/man/man1/bzip2.1 \
            ${prefix}/share/man/man1/bzless.1 \
            ${prefix}/share/man/man1/bzmore.1 \
            ${prefix}/share/info/bzip2.info \
            ${prefix}/share/info/bzip2.info-1 \
            ${prefix}/share/info/bzip2.info-2"
  deldirs="${prefix}/share/man/man1 ${prefix}/share/man ${prefix}/share/info"
  binmove="bunzip2.exe bzcat.exe bzcmp bzdiff bzegrep bzfgrep bzgrep \
           bzip2.exe bzip2recover.exe bzless bzmore"
  for f in $delfiles ; do \
    if [ -f ${instdir}/$f ] ; then \
      rm -f ${instdir}/$f ;\
    fi ;\
  done &&\
  for d in $deldirs; do \
    if [ -d ${instdir}/$d ] ; then \
      rmdir ${instdir}/$d ;\
    fi ;\
  done &&\
  mkdir ${instdir}/${prefix}/bin/mingw &&\
  for f in $binmove; do \
    if [ -f ${instdir}/${prefix}/bin/$f -o -L ${instdir}/${prefix}/bin/$f ] ; then \
      mv ${instdir}/${prefix}/bin/$f ${instdir}/${prefix}/bin/mingw/$f 
    fi ;\
  done
)}

install() {
  (cd ${objdir} && \
  make install INSTALL=install DESTDIR=${instdir} PREFIX=${instdir}${prefix} \
       libdir='$(prefix)/lib/mingw' incdir='$(prefix)/include/mingw' &&
  if [ -f ${instdir}${prefix}/share/info/dir ] ; then \
    rm ${instdir}${prefix}/share/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/share/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/share/doc/${PKG}-${VER} ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/share/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/share/doc/Cygwin ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/README ${srcdir}/LICENSE ${srcdir}/CHANGES \
  ${srcdir}/manual_1.html ${srcdir}/manual_2.html ${srcdir}/manual_3.html \
  ${srcdir}/manual_4.html ${srcdir}/manual_toc.html ${srcdir}/manual.ps \
  ${srcdir}/manual.texi ${srcdir}/Y2K_INFO; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
	 ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
  fi && \
  /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README ; \
  install-mingw-cleanup
)}

mkpatch() {
  (cd ${srcdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} && \
  mv ${BASEPKG}-${VER} ../${BASEPKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${BASEPKG}-${VER}-orig ${BASEPKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${BASEPKG}-${VER}-orig
)}

strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip > /dev/null 2>&1 
  find . -name "*.dll" | xargs strip > /dev/null 2>&1
)}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} * --exclude="${pnoslash}/bin/*.dll" --exclude="${pnoslash}/bin" && \
  tar cvjf ${bin_pkg2} ${pnoslash}/bin/*.dll
)}

spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} *
)}

finish() {
  rm -rf ${srcdir}
}

case $1 in
  prep)		prep ; STATUS=$? ;;
  mkdirs)	mkdirs ; STATUS=$? ;;
  mktools)	mktools ; STATUS=$? ;;
  conf)		conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkdirs ; mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish && STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
