/*
 * $Id: ioperm.c,v 1.3 2003/01/22 11:31:40 telka Exp $
 *
 * ioperm() implementation
 * Copyright (C) 2002 ETC s.r.o.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Written by Marcel Telka <marcel@telka.sk>, 2002.
 *
 */

#include <windows.h>
#include <winioctl.h>

#include <errno.h>

#define	IOCTL_IOPERM	CTL_CODE( FILE_DEVICE_UNKNOWN, 0xA00, METHOD_BUFFERED, FILE_ANY_ACCESS )

struct ioperm_data {
	unsigned long from;
	unsigned long num;
	int turn_on;
};

int __declspec(dllexport)
ioperm( unsigned long from, unsigned long num, int turn_on )
{
	HANDLE h;
	struct ioperm_data iop_data;
	DWORD BytesReturned;
	BOOL r;
	OSVERSIONINFO version;

	version.dwOSVersionInfoSize = sizeof version;
	if (!GetVersionEx( &version )) {
		errno = EINVAL;
		return -1;
	}
	if (version.dwPlatformId != VER_PLATFORM_WIN32_NT)
		return 0;

	h = CreateFile( "\\\\.\\ioperm", GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
	if (h == INVALID_HANDLE_VALUE) {
		errno = ENODEV;
		return -1;
	}

	iop_data.from = from;
	iop_data.num = num;
	iop_data.turn_on = turn_on;

	r = DeviceIoControl( h, IOCTL_IOPERM, &iop_data, sizeof iop_data, NULL, 0, &BytesReturned, NULL );
	if (!r)
		errno = EIO;

	CloseHandle( h );

	return r ? 0 : -1;
}

int __declspec(dllexport)
iopl( int value )
{
	if (value == 0)
		return 0;

	errno = EINVAL;
	return -1;
}
