/*
 * This file ./obj/ht_ccsto.c was generated from ./lib/ht_ccsto.ps by genht.
 * Do not edit this file.
 *
 *  This file is a reformatting of data placed in the public domain by its
 *  author, CalComp Technology, Inc.  The original file bore this comment:
 * 
 * 	convert 167.pat 167a360h.dat 167a360h.lin
 * 
 *  Aladdin Enterprises, Menlo Park, CA reformatted the original data as
 *  PostScript halftone dictionaries, and hereby places this file in the
 *  public domain as well.
 *  $Id: ht_ccsto.ps,v 1.1 2000/03/09 08:40:40 lpd Exp $
 *  This file defines a /StochasticDefault Type 5 Halftone.
 *  Note that the Black array is used for Default, Black, and Gray
 *  (not too surprisingly), as well as for Red, Green, and Blue.
 *  The reason for using the single Black array for the
 *  RGB additive primaries is to make stochastic dither to displays
 *  look better since there is no misalignment between primaries to
 *  a screen (as there often is printing to paper).
 *  The CMY components are decorrelated (90 degree rotations of the
 *  Black data) so that misalignment doesn't cause color shifts. This
 *  is the same reason that conventional ordered screening uses
 *  varying angles for C, M, Y, and K inks.
 */
#include "gxdhtres.h"

/* StochasticDefault.Black */
static const unsigned int levels_0[] = {
    0,   59,  117,  171,  227,  288,  348,  407,  466,  526,
  584,  641,  698,  755,  818,  881,  934,  988, 1043, 1099,
 1152, 1205, 1260, 1314, 1366, 1417, 1469, 1520, 1579, 1641,
 1704, 1764, 1817, 1869, 1918, 1968, 2026, 2086, 2151, 2215,
 2277, 2331, 2380, 2430, 2480, 2532, 2594, 2654, 2712, 2770,
 2830, 2882, 2932, 2983, 3034, 3094, 3164, 3230, 3298, 3376,
 3431, 3480, 3532, 3586, 3638, 3689, 3752, 3832, 3887, 3944,
 4006, 4064, 4111, 4158, 4245, 4330, 4414, 4491, 4545, 4599,
 4671, 4789, 4900, 4955, 4997, 5039, 5081, 5123, 5171, 5225,
 5364, 5454, 5517, 5575, 5633, 5692, 5788, 5940, 6034, 6083,
 6132, 6184, 6236, 6296, 6358, 6426, 6510, 6594, 6663, 6780,
 6821, 6861, 6899, 6931, 6964, 6996, 7028, 7061, 7093, 7144,
 7216, 7515, 7687, 7806, 7881, 7955, 8016, 8066, 8157, 8239,
 8292, 8360, 8440, 8524, 8886, 9045, 9207, 9263, 9308, 9338,
 9367, 9396, 9428, 9461, 9494, 9537, 9599,10003,10129,10247,
10352,10431,10497,10574,10649,10723,10803,10884,11016,11231,
11300,11356,11409,11460,11543,11933,11988,12043,12099,12155,
12211,12276,12359,12442,12525,13024,13104,13162,13211,13264,
13320,13418,13650,13769,13889,13986,14047,14103,14159,14214,
14382,14647,14822,15022,15162,15268,15375,15485,15612,15750,
15836,15940,16051,16290,16421,16533,16657,16794,17063,17146,
17232,17303,17353,17410,17484,17558,18253,18697,18798,18894,
19014,19326,19441,19559,20083,20163,20241,20304,20462,20814,
20915,20979,21046,21117,21214,21316,21452,22095,22230,22332,
22432,22625,23011,23235,23384,23540,23707,23949,24107,24306,
24670,25326,25442,25557,26440,27889,
0};
static const unsigned short bit_data_0[] = {
    3,  129,  284, 1021, 1422, 2604, 2645, 2720, 3237, 3281,
 4492, 4657, 5871, 5891, 6485, 6953, 7395, 7503, 7743, 9158,
 9718,10909,11380,11410,11523,11934,12967,13369,14267,14926,
15069,15239,16320,17010,17105,18116,18912,19037,19834,20689,
20866,21015,21550,22054,22676,23166,24295,25113,25182,25627,
26350,26821,27139,27928,28800,29869,29978,30864,31153,   12,
  916, 1461, 1771, 2247, 3961, 4127, 4863, 5960, 5976, 6304,
 6796, 7993, 8069, 8977, 9317, 9450,10052,11726,11784,12809,
13523,13655,13859,14127,14368,15480,15595,16421,17172,17327,
17625,17797,18241,19979,20040,20578,20655,22810,22912,22956,
23117,23855,24134,24453,25922,26131,26231,27177,28278,28818,
29061,29113,29126,29528,30242,30415,31717,  486,  543,  993,
 1364, 1926, 2564, 3157, 4037, 4364, 4375, 7244, 7920, 8525,
 8673, 9240, 9571, 9850,10267,10884,11159,12574,12631,13831,
13870,14144,15389,16272,16957,17507,18730,18958,19325,19667,
19820,21085,21602,22284,22497,23427,23568,23900,25357,25401,
26260,27237,27303,27864,27952,28130,28304,29607,30783,31765,
31985,   55, 1440, 2430, 3702, 4067, 4650, 4905, 5007, 5470,
 5689, 6213, 6834, 7192, 7811, 9842,10002,10316,11055,11257,
11750,12642,12926,14937,15172,15828,15987,16139,16971,18056,
18357,18835,19159,20131,21175,21187,21242,21391,21834,22554,
23735,24494,24848,25386,25470,26955,27082,28173,29619,29966,
30038,30144,30470,30494,30984,31516,31992,  262,  621, 1590,
 2007, 3379, 3867, 4737, 5462, 5709, 5988, 6439, 6779, 7128,
 7642, 8038, 8135, 8926, 9298, 9369,10016,10379,11286,11388,
12182,12589,12608,12917,13317,13454,14801,15663,15682,15806,
15973,16480,16636,16730,17372,18489,18713,19699,20738,21334,
22331,24030,24207,24613,24717,24983,25503,25796,26210,26583,
27391,27486,27710,28766,29138,30647,31831,32012, 1261, 1696,
 2318, 2832, 3366, 3395, 3422, 3498, 3525, 4965, 5061, 5339,
 6310, 7788, 8295, 8657, 8693, 9535, 9712,10562,10826,11427,
11468,11757,12486,13961,14304,14475,15460,16266,17192,17321,
17428,17823,18755,19276,20252,22189,22517,22695,22753,22803,
23395,24250,25266,26029,26338,27035,27217,27696,27798,28621,
28929,29630,29659,29984,30571,30931,31109,31211,  410,  701,
 1287, 1609, 2136, 2341, 2558, 4043, 4247, 4311, 4855, 5106,
 5982, 6385, 6609, 7038, 8213, 8605, 8729, 9228,10089,12893,
13204,13978,14056,14105,14565,15032,15575,16085,16580,17979,
18124,18667,18851,19458,19605,20020,20293,20754,21079,21129,
21351,21957,22006,22470,23449,23895,24152,24777,25284,26444,
26938,28232,28342,28837,29480,29887,31565,  257,  908, 1126,
 1357, 1883, 2360, 2766, 2787, 3400, 4144, 5521, 5667, 5704,
 6539, 6916, 7543, 7760, 8372, 9280,10134,10799,11240,11263,
11422,11971,12254,12750,12910,13749,14868,15110,16604,17286,
17495,17524,17774,18150,18190,18867,19166,19499,19723,20837,
22160,22596,23142,24053,24509,24639,24768,25447,26191,26463,
28257,29075,29433,30092,30848,31395,  213,  423, 1235, 1446,
 2616, 2887, 3355, 3729, 3902, 5022, 5587, 6208, 7138, 7388,
 7893, 8555, 8778, 9029, 9676,10260,10598,11299,12218,12433,
12711,12885,13924,14430,14450,14849,15371,17884,18830,19396,
19898,20604,21533,22049,22297,22701,23178,23891,24546,25780,
26712,27164,27268,27344,27384,27472,28004,28167,28299,28330,
28892,29038,29577,30641,30881,31004,  134,  242, 1487, 2733,
 3601, 4381, 4541, 5191, 5415, 5649, 5805, 6352, 6647, 7047,
 7071, 7364, 7708, 8189, 8546,11846,12018,12345,13198,13635,
14672,14714,14894,15521,15849,16091,16400,16839,17216,17728,
19364,19682,19815,20379,20590,21234,21594,21841,22921,23438,
24007,24404,24842,24867,25428,25489,25672,26367,26739,28829,
29107,30024,30872,30971,  108,  269,  400, 1049, 1159, 1179,
 1601, 1666, 2031, 2689, 2953, 5626, 6236, 8208, 8802, 9095,
 9338,10119,10621,11088,11143,11165,11732,13066,13129,13144,
13571,14505,14547,16051,16349,16759,17100,17228,17938,18020,
18696,20122,20683,21632,22184,22580,23198,23681,23844,24308,
24620,26235,26537,26993,27615,28266,29284,30730,31159,31654,
31825, 1657, 2012, 2466, 2710, 3122, 3371, 4753, 5153, 5502,
 5675, 7150, 8477, 8890, 9602, 9950,10204,10463,10640,11059,
11226,12006,13211,13688,13889,14228,16133,16146,16631,18279,
18707,19144,20166,20626,20649,20899,21002,21133,22550,23745,
24156,24817,25562,25631,26375,28160,28378,29187,29259,29345,
29396,29881,30293,30595,31036,31452,31520,31529,  355,  692,
 1190, 1586, 1687, 2142, 2841, 3302, 3940, 4533, 4879, 4934,
 5258, 5570, 6391, 6866, 7019, 7883, 8149, 9072, 9443, 9746,
10276,10493,10961,13171,13411,13534,14792,15206,15217,16201,
16554,17377,18146,18647,18926,18963,19453,20096,20309,20609,
22129,23727,25156,25301,26120,26318,26526,26624,26788,28480,
29133,30823,31049,31185,31775,  391,  923, 1030, 2407, 3085,
 3130, 3650, 5013, 5083, 5719, 7075, 8166, 8512, 8945, 9608,
10007,10340,10625,10796,11878,11984,12899,13663,15010,15092,
15498,15840,15992,16025,16063,17473,18672,19208,19320,19610,
19616,20046,21374,21714,21790,21853,21892,22222,23068,23097,
24076,24097,24336,24665,25273,25508,25599,25765,25803,26963,
27400,27859,27912,28282,30193,30373,30936,31310,  442,  466,
 2000, 2636, 3582, 3801, 4079, 4290, 5027, 5429, 6026, 6433,
 6460, 6556, 6683, 6931, 7525, 7563, 7602, 8385, 8685, 9496,
10229,10979,11913,12339,12504,12770,13182,13518,13737,13966,
14412,15526,16662,16739,17005,17351,17943,18065,18686,19600,
20447,21446,21732,22038,22155,22400,22778,22849,23272,26225,
26265,26408,28178,28347,28466,28525,29080,30165,31555,31577,
31804,  480, 1662, 1731, 2399, 2907, 3680, 3860, 4123, 6658,
 7547, 7816, 7840, 9517,10115,10522,11192,11819,11864,12495,
12597,13030,14088,14829,15001,15244,15812,17055,17397,17983,
18186,18197,19303,19671,20777,21047,21229,23281,23382,23494,
24329,25362,26497,27319,27490,27556,27691,28226,28823,28896,
29409,29724,29875,30197,  687, 1875, 1938, 2353, 2419, 3725,
 4001, 4281, 4361, 4516, 4717, 5580, 5876, 6184, 6422, 8156,
 8601, 8641, 8662, 9546,11014,12041,12160,12187,14341,14872,
15103,15123,15983,16725,17720,17869,18080,18395,18525,18931,
19777,20111,20979,21780,22143,22857,23443,23739,24218,24514,
24875,25868,26170,27933,29649,30149,30557,30807,  222,  681,
 1788, 2654, 2818, 4104, 4610, 6479, 6792, 6975, 7494, 7531,
 9505, 9616,10025,10248,10484,11754,11842,12130,12363,13266,
13298,13599,14942,16427,16599,17233,18884,19447,20319,20958,
22961,23313,23456,23519,23968,24002,25205,26051,26275,27030,
27572,28292,29001,29827,29896,29996,30097,30307,31235,31410,
31738,31917,32028,  527,  650,  706, 1013, 2187, 2581, 2729,
 3136, 3195, 4443, 5142, 5424, 5441, 5479, 7379, 7418, 7635,
 9872,10296,11678,11858,13289,13551,14166,14262,14518,14595,
14692,15631,16577,16609,16676,16835,16927,17360,18095,19048,
19329,20468,20566,21738,22671,23365,23483,23849,24994,25030,
26399,26899,27403,27732,27852,28059,28758,29034,30913,  963,
 1674, 1930, 1953, 3404, 3464, 4047, 4356, 4498, 4922, 5401,
 6962, 7519, 8013, 8116, 8722, 8841, 9052, 9063, 9092, 9320,
10374,10707,11222,12675,12997,13756,14041,15229,15376,18594,
19087,19293,20071,20422,21608,22010,22108,22724,23722,25240,
25653,25776,27004,28385,30009,30219,30443,30623,30948,31251,
31690,31782,  279,  505, 1175, 1194, 1827, 2278, 3361, 3948,
 4197, 4263, 4810, 6280, 6338, 7008, 7592, 8761, 9837,10476,
11147,11596,11637,11738,12562,12738,16711,16751,17401,17915,
18630,19163,19823,20079,21054,21453,21478,21896,22627,22991,
23285,24147,24863,25544,26137,26197,26924,26943,27374,27532,
28554,29057,29854,30736,31509,  340, 1026, 2778, 2992, 3414,
 5731, 5849, 6108, 6831, 7296, 7308, 7414, 8131, 8367, 8981,
 9154, 9463,11569,11837,12621,13501,14469,14633,15273,15484,
15504,15585,15705,16335,17052,18557,19526,19731,20004,20366,
21021,21466,21751,22002,22408,22557,23127,24011,25230,26725,
27395,27611,27655,28326,29100,29391,29698,31244,31559,31742,
  779, 1123, 1582, 2182, 3575, 3699, 4942, 5051, 6357, 6369,
 6872, 8461, 9183, 9469,10127,10455,10887,12001,12550,12971,
13778,14097,14492,14730,14997,15686,16380,17778,17876,18293,
18458,19654,20600,22373,24468,24506,25097,25212,25452,25690,
25759,26255,26951,27507,28668,29071,29308,29402,29733,30054,
31149,31414,31456,31540,  227, 1245, 1265, 2026, 2741, 3734,
 4180, 4447, 4846, 4898, 5838, 7969, 8312, 8390, 8714, 9236,
 9439,10337,10777,11361,11964,12442,13274,13834,15413,15644,
16899,16934,17578,17928,19019,20440,20815,21317,21529,23277,
23540,23717,23830,23881,24166,24734,24783,25026,26501,26894,
27160,27877,30298,30419,30460,31430,  537, 2243, 2961, 3234,
 3479, 4136, 4680, 6079, 6573, 7769, 8097, 9694,10580,11392,
11823,12307,12524,12921,13347,13440,13910,14722,15140,16151,
17347,17368,18320,18375,18552,18982,19933,20472,20488,21190,
21266,21579,21711,22233,22500,23948,24424,25829,26440,26613,
27168,27289,28355,28500,29238,31760,31897,  166,  712,  816,
  867,  978, 1046, 1210, 2061, 2705, 4626, 4958, 5110, 6204,
 6251, 6283, 6727, 7705, 8917, 9142, 9165,10382,10617,10852,
10985,11302,14031,14629,14897,15560,16654,17380,17442,17609,
17899,17951,18193,18351,18725,20031,21555,22547,22623,25390,
25558,26203,29104,29382,29519,30205,30753,30988,31697, 1947,
 1960, 2235, 3107, 3707, 3969, 4885, 6196, 6757, 7234, 7247,
 8107, 8957, 9190,10304,10445,12300,12604,13023,13147,15709,
16056,16239,16589,16756,17306,19997,20179,20476,20773,21563,
21920,22871,24062,24080,24497,24581,24632,24726,24886,25281,
25809,26167,26797,27041,27715,27772,29147,30184,30427,30830,
 1080, 1604, 2263, 2500, 3501, 3522, 4702, 4805, 5130, 5295,
 6035, 6820, 7367, 8035, 8081, 9102, 9267,10048,10212,10289,
10890,11097,11854,12592,12949,13579,14364,15073,15617,15771,
15784,16261,18052,18656,18902,19441,20075,20833,21281,22021,
22315,23323,23385,24416,25190,25931,27285,27599,27649,28462,
28681,28964,29615,29970,30070,30344,31423,31598,31878,  426,
  848,  990, 1120, 1449, 2004, 2369, 2822, 3567, 4469, 4762,
 5408, 5637, 5907, 5966, 7183, 7447, 8072, 9947,10418,10591,
10875,11052,11718,13062,13286,13400,13874,13900,13944,14124,
14462,15446,16403,17146,17213,18178,18275,19053,19735,20235,
20554,20697,21012,22102,22397,22967,23170,24241,25885,25894,
26178,27119,27944,28240,28315,28531,28560,29405,29893,30628,
31651,  254, 1088, 1105, 2699, 2805, 3293, 3358, 3528, 3983,
 5418, 6617, 6965, 6978, 7615, 8029, 8474, 8701, 8744, 9499,
11395,11767,11800,12065,12336,12419,13088,15554,15693,15815,
16099,17049,17482,17548,18399,18497,19866,20260,20593,20710,
21154,21762,21807,22343,22909,23045,23145,23433,24668,24872,
25486,25607,25960,26642,26767,27707,28421,28833,29321,29448,
29524,29665,31945,31970,  116, 1111, 1764, 1892, 3782, 4232,
 4578, 5313, 5630, 5956, 6071, 7131, 7407, 8292, 9481, 9988,
10664,11041,11104,11214,12315,12394,13575,13852,13892,14059,
14179,14323,14990,15509,15611,16162,18138,18200,18955,19258,
19343,19504,19992,20870,21605,22735,22796,22806,23267,24914,
24987,26238,26809,26907,28455,28903,29838,29920,29963,30772,
30996,31254,31625,31920, 1227, 1743, 2133, 3027, 4076, 4824,
 6244, 6258, 6307, 7506, 8123, 8589, 9557, 9803, 9818, 9916,
 9984,11729,11832,12245,12388,14333,14433,15250,15406,16424,
16659,17703,18251,19010,19272,19552,19597,20245,22178,22704,
23398,23876,24018,24902,25442,25648,25743,25834,26743,27960,
28189,28634,28856,30274,30360,30669,30981, 1626, 1843, 2985,
 3127, 3148, 3228, 3957, 4621, 4645, 6469, 6813, 7874, 8497,
 9523, 9638, 9685,12454,12792,14406,15468,15764,15820,17503,
18348,19224,19427,19894,19907,20035,20395,20742,21976,22274,
22290,23934,25816,26379,26887,26912,27022,27744,28245,29042,
29680,29762,30575,30836,30953,31077,31134,31772,31785,  599,
 1669, 1972, 2158, 2256, 3006, 3460, 4477, 4485, 5404, 5509,
 5856, 6296, 6553, 6927, 7015, 7990, 8139, 8351,10805,10835,
10845,10893,11675,13292,13313,13842,13916,14016,14119,14352,
14664,16222,16775,17975,18700,20877,21163,21652,23852,24628,
25122,25878,27526,27756,28504,28926,29461,31811,  385, 1309,
 1567, 3160, 4111, 5542, 6414, 8941,10881,10958,12329,13137,
14812,14836,16035,16059,16748,17411,17445,18098,18110,19870,
20761,21419,21429,21629,21707,22328,22494,22860,23139,23316,
23560,23864,24292,24588,25084,25116,25964,26661,27781,27918,
28183,29302,29987,30584,30875,31304,31359,31418,  330,  438,
  975, 1276, 2039, 2363, 2402, 4756, 4889, 5535, 5584, 5640,
 6858, 6997, 7113, 7453, 7528, 7540, 8202, 8875, 9039, 9180,
 9540,10045,10223,12099,12994,13201,13685,13729,14423,14934,
15236,16436,16521,16842,17820,18071,18752,19664,19784,21576,
22575,23379,23580,23644,24107,24456,24653,25762,25925,26134,
26162,27412,29591,29824,30733,32032,   67,  684,  803,  901,
 1354, 2460, 3092, 3661, 3964, 4530, 4537, 5093, 5261, 5810,
 5815, 5884, 6187, 6842, 8146, 8517, 9551, 9891,10437,10710,
10870,11460,11735,12325,12540,12568,12877,15474,15967,16258,
16911,16986,17152,17613,18153,18871,18939,19108,20214,21443,
21667,22119,22338,23499,25980,26460,27174,28062,28707,29196,
29244,29866,30041,30406,31199,31439,   32,  474, 1345, 1837,
 1983, 2386, 2826, 3504, 5043, 8403, 8549, 8613, 9621,10094,
10569,10726,11465,11997,12342,12511,12939,13548,13746,14286,
14727,14843,15270,15323,15758,16474,16754,16816,16991,18133,
19072,19410,19625,19901,19912,20884,20944,20987,21168,21258,
21394,21506,22428,23486,24257,24286,24311,24980,25070,25659,
25862,25948,26507,26779,26825,27520,27810,28083,29419,30474,
31955,  317, 2079, 2312, 2377, 2975, 3142, 3804, 3880, 3978,
 4116, 5100, 6163, 6595, 6721, 6752, 7429, 7766, 8169, 8178,
 8416, 8647, 8767, 9060,11173,11402,11441,12422,14446,15095,
15449,16130,16975,17301,17517,18461,18546,18777,19749,20162,
20191,20826,22707,22890,22983,23392,23729,24407,24605,25043,
25856,26513,26998,27073,27157,27300,27844,27885,27978,28678,
28932,29910,31320,31449,31887,  832,  862, 1593, 2724, 3097,
 3622, 4225, 4330, 4450, 4866, 5459, 6097, 6254, 7726, 8280,
 8344, 9475,10322,10841,11140,11375,11590,11816,11988,13498,
13567,13596,14293,14540,14754,14784,15980,16551,18641,19099,
19685,20704,20992,22349,22392,22609,22942,23248,23972,24089,
24538,24578,25245,25394,26372,26578,26748,26794,27038,27416,
29981,30255,30530,31399,31491,31828,31914,   19,  337,  497,
 1425, 2213, 2240, 3133, 3858, 4129, 5385, 7161, 7318, 7391,
 7553, 8025, 8772, 9760, 9895,10039,10583,11282,11452,12681,
12689,13350,13590,15299,16640,17533,18579,18949,19125,20273,
20391,20460,20812,22378,23354,23654,23940,24809,25418,25889,
26036,27704,28235,28318,28390,28686,28727,28952,29278,30649,
31143,  774,  819,  845, 1484, 2201, 2346, 2990, 3407, 5228,
 7028, 7612, 7950, 9262,10251,10780,11156,12173,12427,12637,
12721,13080,14602,14862,14909,15007,16374,17018,17117,17668,
17680,18310,18977,19090,19917,21407,23858,24854,25163,25292,
25874,28260,28336,28350,29412,29885,30676,31001,31523,31562,
  202,  292, 1492, 1560, 2736, 3192, 5398, 5602, 5722, 5864,
 6590, 7460, 8468, 9543,10073,11007,11875,13168,13703,14053,
15891,16383,16477,16996,17062,17392,17810,18722,18854,19444,
20671,20948,21940,23071,23622,24226,24636,24703,25346,27010,
27470,27546,28906,29534,29637,29707,30440,30852,30939,30978,
 1306, 2416, 2717, 2853, 4062, 4274, 4927, 5573, 5660, 6216,
 6494, 7824, 8078, 8566, 8731, 8888, 9323, 9629, 9740,10411,
12214,12360,13152,14360,14457,14466,14699,15209,15434,15750,
15880,16214,17002,17335,18405,19658,20306,21979,23151,23373,
23695,23958,26544,27378,27529,27880,28755,30800,31010,31070,
   59,  502,  604,  661, 1197, 2189, 3274, 3561, 3684, 3796,
 5088, 5324, 6171, 6464, 7061, 7522, 7780, 9671, 9766,10402,
10525,12031,13058,13886,14417,14687,15862,16269,16524,16531,
17415,17743,18875,19546,20507,21224,21471,21933,22682,22822,
23299,24883,25601,26415,26785,27483,27730,28743,29376,29393,
29814,30549,  153,  824, 1032, 1822, 2250, 3040, 3343, 3914,
 3929, 3954, 4186, 5139, 5307, 5491, 6154, 7345, 7491, 7627,
 8126, 8644, 9121, 9721, 9944,10080,10994,11337,11429,11577,
13366,13475,13529,14147,15846,15903,17238,17353,17949,18477,
18634,19501,20597,20955,21590,21624,21656,22018,22220,22281,
22785,23522,24911,24932,25061,26405,26648,27114,28806,28862,
30095,30587,30602,31535,  105,  596,  808, 1061, 1379, 2451,
 3076, 3705, 4551, 5010, 5799, 5826, 7982, 8719, 8863, 9413,
10313,10384,10819,11555,11669,12819,13192,13295,13515,14020,
15379,15588,16570,16728,16786,17522,17701,17767,18768,19013,
19231,19285,20017,20029,20242,21040,21537,23254,24814,24977,
25783,26342,26709,27658,28557,28652,28821,30034,30692,31115,
31215,31382,31924,31999,  324,  644, 2114, 2588, 2790, 2946,
 3393, 4096, 4436, 4575, 4882, 5032, 5185, 5241, 5847, 6634,
 6693, 7945, 8379, 8489, 8599,10258,11371,12118,13179,13452,
13794,14138,14682,14928,15607,15793,16045,16154,16866,17598,
19030,20368,20450,20612,20616,21071,21908,22175,22538,22918,
23157,23628,24708,24967,25613,25848,27777,28660,28960,29643,
29656,29668, 1361, 1406, 1622, 1932, 2515, 2919, 3347, 3865,
 4159, 4177, 4710, 4932, 6191, 6201, 7134, 8897, 9099, 9466,
 9921,10101,11437,11550,11723,12384,12583,13652,15678,16194,
17013,17097,17557,18281,18774,19113,20356,20852,21831,22095,
22141,22420,22902,23720,24142,26013,26437,26753,27578,28118,
28675,29223,29312,30190,30259,30353,30400,30726,31797,32015,
   38,  271,  349,  388, 1283, 2166, 2331, 2619, 3031, 4827,
 4875, 6342, 6452, 6541, 6742, 6862, 6955, 7002, 7373, 8459,
 8968, 9992,10672,10915,11368,12548,13111,14307,14427,15825,
16198,17039,17121,17541,18017,18254,18761,19035,19296,19429,
20325,20748,20858,22930,22937,23009,24201,24465,25220,25380,
26003,27235,27324,27562,27701,27794,28147,28689,30109,30463,
  397,  741,  890, 1392, 1507, 1798, 3116, 3364, 3811, 4527,
 5495, 6094, 6759, 6994, 7749, 9111, 9233, 9363,10811,11408,
11610,12044,12350,12402,12714,12764,13277,15263,15910,16088,
18362,18506,19331,19514,19729,20217,21775,22115,22758,22972,
24544,25937,26332,26914,28094,28440,28639,28730,29731,30578,
31314,32008,   28,  534, 1455, 3908, 5144, 6266, 6431, 6790,
 7066, 7165, 7265, 7402, 7926, 8005, 8094, 8948, 9648,10501,
10681,11955,12836,13016,13195,14640,14695,15039,15116,15136,
15175,16219,17881,18453,18627,19243,19481,22659,22714,22885,
23341,24532,24793,25017,26185,26645,26828,27149,27750,30239,
31354,31961,  264,  906, 1057, 3021, 3206, 3741, 4087, 4747,
 5195, 5246, 5920, 7774, 8795, 9653, 9806, 9870, 9900,10662,
10757,11344,11488,13448,13712,13765,13982,14511,16205,17029,
18103,19120,19594,20001,20483,20606,21219,21753,22239,22866,
23929,24071,24238,24714,26658,27089,27994,28046,28886,29007,
29483,29687,30099,  110,  239, 1259, 1349, 1576, 1851, 3296,
 3847, 4699, 5221, 6032, 6563, 8001, 8677, 8783, 9242,10512,
10878,11616,12564,13972,15290,16369,16516,17437,17755,17922,
17956,18372,19541,19746,20973,21349,21744,23754,23962,24004,
25022,25051,25449,25688,26434,26539,26610,26782,26933,28579,
28803,29820,30563,31017,   94,  123, 1075, 1565, 1681, 2266,
 2702, 4432, 4461, 5894, 7178, 7241, 7689, 8303, 8932, 8996,
 9341,10023,11016,11137,11292,11354,11412,12142,12239,13583,
13671,14049,14482,14827,16545,17671,18161,18572,18702,19247,
19268,20106,20182,20503,21319,21531,21803,21812,22165,23670,
24480,25376,26057,26393,26412,26621,26691,28272,28875,28939,
29766,29801,30104,31735,   23,  636, 1750, 1804, 2338, 2602,
 2747, 3189, 3999, 4475, 6483, 7021, 7031, 9026, 9116, 9135,
 9682,10197,11457,11905,12205,13072,13127,13165,13797,14487,
14606,14646,14858,15385,15945,16442,16807,17490,17781,17807,
17815,18519,18781,19215,19689,20064,20768,21121,21961,23510,
23824,23833,24114,24320,24490,25003,25152,25271,25424,26697,
27206,27550,27669,27680,27905,28513,30348,30367,30423,30664,
31032,31182,31646,31681,  417, 1544, 1864, 1986, 2024, 2547,
 2628, 2763, 3972, 4151, 4582, 4887, 5644, 5681, 5782, 6054,
 6776, 7044, 7398, 7829, 7911, 8883, 9565,10077,10466,10976,
11271,11774,12059,12414,12514,12698,13115,14344,14527,15320,
16241,16365,17389,17601,18492,19711,19781,20201,20431,21329,
21759,22013,22052,22225,22386,22808,23513,23840,24230,25622,
27122,28141,28180,28763,29294,29441,30363,31147,31745,31749,
  911, 1051, 1728, 2584, 3225, 3942, 4366, 4422, 4832, 5524,
 5706, 5984, 7316, 7763, 9086, 9175, 9225, 9826,10234,11050,
12368,13269,13353,13526,14612,14823,14852,15280,15888,15994,
16777,16937,16983,17294,18727,19392,19648,20455,20630,21197,
21647,21912,22319,22793,23004,23304,23360,23466,24060,25072,
25576,25826,26357,26573,26757,27789,28191,28296,28435,29208,
29215,29232,29281,29316,29521,30075,30305,31948,  353,  793,
 2017, 2422, 2521, 3316, 3519, 3664, 4074, 4495, 5155, 5290,
 5697, 5725, 6220, 6419, 6580, 6689, 6737, 7036, 7796, 7929,
 8711, 9858, 9955,10201,11447,11471,12103,12113,12736,13217,
13445,13675,14110,14748,14978,15477,15761,16455,16611,17830,
17886,18336,18482,18935,20278,20360,20843,21064,21083,21210,
21248,21572,23047,23617,23953,24278,24438,24594,24643,25119,
25556,26023,26336,26640,27309,27574,27622,28357,29274,29454,
29492,30567,31013,31596,31617,31880,  703,  777, 1693, 1968,
 2384, 2759, 3265, 3578, 4513, 5064, 5251, 6768, 8856,10299,
10520,10600,10829,10838,12964,12982,13300,14155,15247,15259,
15304,15523,16168,16657,16830,16963,17323,18277,19470,19612,
21173,21970,22528,22882,23087,23966,24109,25541,27007,27084,
27101,27362,27542,28472,28617,30413,31026,31156,31165,31389,
31629,  276,  805, 1443, 1856, 2464, 2802, 3373, 3990, 4853,
 5465, 5786, 5953, 6102, 7111, 8091, 8799, 9249, 9452,10527,
10764,10807,12165,12243,13184,13872,13883,14520,14988,15075,
16705,16989,17555,17595,17803,21093,21462,21851,21989,22121,
23907,25087,25111,25786,27909,28649,28709,29141,29780,30915,
  333,  871, 1078, 2128, 2697, 3402, 3477, 4426, 5040, 5117,
 6046, 7251, 7771, 7792, 8336, 8376, 9701, 9907,10070,11092,
12481,13123,14028,14272,15297,17963,18499,18869,19082,19135,
19339,19549,19676,20494,20951,21517,21617,22760,23325,23346,
24266,25200,25224,25668,26112,27033,28643,29050,31046,31137,
31267,31379,  811, 1810, 2343, 2446, 4916, 5136, 5188, 5677,
 7891, 8163, 8256, 8584, 8707, 9152,10431,11635,11812,11936,
12036,14549,14617,15083,15583,16621,16732,17139,17165,19983,
20205,21177,21918,23012,23475,24270,24356,25057,25372,25560,
25684,25741,26365,26920,27568,27915,28114,28721,29498,29579,
29809,30021,30276,30866,31038,31500, 1689, 1977, 2348, 2816,
 3732, 4317, 5264, 6558, 6668, 7141, 7232, 7908,10132,10178,
10413,11979,12121,12570,12640,12816,12826,13135,14435,15411,
16149,16356,16664,17930,18788,19509,20282,20388,20573,20637,
22406,23185,24205,24234,24800,24889,25871,26425,26791,27270,
27613,28698,28943,29651,30621,30959,31126,32036,  402,  926,
 1432, 2033, 3119, 3530, 3677, 5282, 5628, 6877, 6923, 7630,
 7937, 8114, 8533, 8845, 8851, 8938, 9865, 9929,10578,11944,
12794,14068,14090,14707,14724,15062,15226,17440,17530,17697,
17712,18367,18824,19078,19153,19831,20509,21889,22923,23243,
23297,25287,27287,27774,27784,30056,30582,31585,31710,  722,
 1207, 1220, 2082, 3544, 3746, 3878, 4142, 4630, 4764, 5197,
 5319, 5422, 5969, 6211, 6602, 7010, 7608, 8027, 9296, 9918,
11039,11382,12683,12901,13150,13658,13734,13761,14210,15756,
15831,15883,17375,17991,19041,19116,19795,20225,21060,21244,
22086,22573,23066,23136,23764,23925,24678,25500,25651,25983,
26581,26761,27180,28444,29349,29511,29722,30147,30210,30678,
31608,31834,   81,  102, 1203, 2069, 2502, 2632, 2744, 3616,
 4035, 4084, 4108, 4347, 4480, 5802, 5925, 6233, 6532, 6570,
 6663, 7217, 7382, 7650, 8191, 8301, 8561, 9065, 9078, 9925,
10206,10474,11181,11341,11834,12501,14129,14789,15233,15650,
15851,15989,16000,16224,16293,16395,16789,17015,17111,18010,
18246,18259,18910,19861,20321,20658,20932,21377,21404,21735,
21773,22486,22563,22582,23481,23944,25011,25506,25546,25580,
25646,26148,26553,27027,28520,28545,29236,30044,30351,30828,
31178,31912,  607,  664,  981, 1289, 2173, 3279, 3411, 3788,
 4354, 5813, 6275, 6448, 7693, 7895, 8172, 8507, 8736, 9163,
 9336,10843,11777,11790,12248,12424,12786,13648,13908,14216,
15212,15326,15876,16253,17043,17124,17283,18323,20037,20119,
21009,22218,22395,23501,23549,24220,24611,25482,25853,26079,
28624,29063,29990,30479,30859,31514,31730,  482,  738,  769,
 1415, 1766, 1845, 2468, 2771, 2972, 3482, 3682, 4727, 4759,
 4912, 5598, 6298, 7078, 7549, 9186, 9663, 9669,11480,11606,
11940,11962,12260,12777,13503,13784,15012,17867,17909,19607,
19910,20077,21192,21353,22360,22980,23828,24283,24384,25207,
25228,25990,27857,27875,27984,28038,28284,28702,28725,30052,
30065,30613,30920,31795,  150,  436,  647,  973, 1562, 2221,
 2752, 2785, 2843, 3659, 4102, 4648, 5669, 6014, 6654, 8259,
 8387, 8593, 9624, 9706,10498,10670,11952,12745,14038,14046,
14122,14134,14542,15506,16915,17225,17382,17395,17812,18205,
18523,19070,19096,19852,20286,20403,21222,21524,22134,22423,
23778,24124,24519,24583,26016,26075,26522,26961,28132,28345,
29019,29149,29421,29502,29975,31813,  850, 1569, 2245, 3377,
 4500, 4808, 4857, 6037, 6182, 8023, 8329, 8541, 9990,10510,
11986,12139,12225,12509,12821,13213,13473,13532,14072,14854,
15195,15748,15817,15905,16652,17761,17901,18126,18664,20219,
21513,22438,22606,22933,23054,23454,24540,24898,25360,26154,
27188,27425,27497,28302,29251,29572,30203,30309,30492,30600,
30658,31333,31493,31740,  518, 1086, 2233, 3862, 4092, 4637,
 5964, 6593, 6798, 8419, 8955, 9422, 9640,10632,10721,11434,
12723,13139,13950,14999,15646,16601,16767,18841,19025,19314,
19437,20250,20300,21343,22340,22492,23269,24259,24332,25216,
25299,25444,27194,27321,27971,29265,29709,29776,30264,31120,
31532,  236,  638,  668, 1829, 3270, 3304, 3976, 4715, 5085,
 5711, 6050, 6359, 7441, 8479, 8787, 9301,10255,10674,11612,
11740,12101,12111,14366,16170,16327,16351,17785,18625,19994,
20083,21613,21792,22016,22035,23352,23471,23555,23724,24536,
25426,25997,26991,27931,28656,29286,31249,31361,  266,  347,
  881, 1643, 1748, 1871, 1993, 2045, 2316, 2336, 3140, 3889,
 4195, 4237, 4490, 4800, 5315, 5808, 6619, 6636, 7159, 7585,
 7913, 9223, 9310, 9329, 9618,10596,10907,11009,11025,11253,
11957,12207,12727,13413,13513,14162,14309,14443,15023,15444,
15674,15703,15996,16015,16246,16965,17500,17858,18112,18163,
18704,19057,19298,19529,20160,20364,20967,20989,21665,22323,
22505,22545,23099,23697,24243,24807,25892,26263,26503,26734,
27141,27272,27283,27405,28732,28962,29961,30253,30417,30453,
30573,31420,31767,31780,31907,  921, 1404, 1509, 1628, 1806,
 2116, 4113, 4313, 4326, 4441, 5305, 5604, 6537, 7121, 7455,
 7561, 7730, 8463, 8675, 8934, 9361, 9538, 9563, 9883,10759,
11194,11346,12200,12297,12408,13381,13507,13581,13754,14554,
14995,15857,16275,16482,16529,17141,17795,17897,18636,18783,
18873,19157,19398,19704,19935,20265,20481,20618,21023,21400,
21836,21901,22192,22526,22782,23060,23758,23903,24973,25268,
25597,25966,26199,26218,26307,26823,27137,27162,27728,28568,
28811,28854,28910,29027,29247,29599,30199,30625,31600,31699,
  440,  491, 1285, 2180, 2850, 3095, 3114, 3197, 3573, 3744,
 3946, 4844, 4936, 5341, 5427, 5537, 6938, 6980, 7106, 7377,
 7623, 8154, 9113, 9238,10036,11046,11274,11647,12386,12566,
12811,13060,14086,14509,14834,14845,14866,14986,15114,15655,
15769,16376,17133,17423,17435,17753,17926,17981,18340,18759,
18882,19161,19431,19533,19614,20055,20066,21268,21548,21627,
22173,22625,22939,23650,24105,24111,24130,24530,25238,26324,
26442,27145,27296,28006,28839,30003,30090,30186,30425,31220,
31297,31387,31445,31627, 1216, 1274, 1970, 3217, 3840, 4064,
 5431, 5446, 5493, 6249, 6864, 7136, 7786, 7995, 8985, 9084,
 9486, 9559, 9828,10027,10278,10435,10486,10609,11212,11521,
11856,12212,12691,12908,13984,14400,14690,15030,15590,15680,
16093,16141,16626,17060,17170,18105,18736,18937,19713,20207,
20429,20564,21131,21145,21469,21959,22914,22963,23043,23576,
23782,23817,24790,24840,25666,26240,26258,27326,27560,27957,
28268,28417,28502,29206,30528,30547,30589,30751,31054,31365,
31703,  118, 1065, 1620, 2988, 3012, 3029, 3517, 4242, 4543,
 5575, 6807, 7341, 7782, 8018, 8200, 8265, 8310, 8687,10587,
12185,12798,13133,13673,13959,14439,14860,15310,16645,16901,
16994,17318,18574,19362,20806,21448,21947,22762,23119,23893,
24482,24634,25629,26142,26193,26397,27800,28088,28128,28290,
28937,29834,30488,31233,31950,   14,   96,  319,  421,  642,
 1006, 1109, 1649, 1928, 2967, 3610, 3906, 4261, 4371, 5393,
 5788, 6456, 7405, 7685, 9097, 9315, 9408,10696,10917,11224,
11390,11400,11542,12807,13450,15278,15374,15965,18463,18941,
19220,20744,21087,21362,22474,23872,24603,25778,26615,26650,
26701,27046,27317,28055,29069,29276,29314,29490,30369, 1102,
 1463, 1472, 2077, 2647, 2722, 2882, 2899, 3103, 4463, 4520,
 5326, 5642, 6547, 6679, 6691, 7359, 8278, 8411, 8770, 9934,
 9997,10423,10983,12063,12327,12768,13902,14256,14889,15423,
16371,16606,16907,17148,17776,18517,19212,19687,19857,20376,
20500,20662,20835,20845,21396,21423,21702,21914,22481,23091,
23287,23582,24236,24693,24962,25066,25161,25378,25801,26273,
26638,27172,27347,27388,27676,29526,30438,30688,30798,30969,
32030,    1, 1039, 1192, 1347, 1359, 2590, 3038, 3175, 3320,
 3580, 3727, 3739, 4166, 4580, 4861, 4877, 5095, 5268, 5472,
 5824, 5986, 6081, 6090, 6189, 6394, 6630, 6925, 7143, 7163,
 7386, 7747, 7903, 8223, 8395, 8751, 8858,10461,10953,10966,
11267,11294,11439,11684,11999,12354,12897,13362,13588,13669,
13741,13920,13968,14298,14523,14752,14816,15168,15381,15621,
16018,16231,16670,17025,17137,17431,17484,17827,17878,17891,
18188,18267,18732,18741,19449,19634,19656,19779,20515,20779,
21081,21557,22008,22117,22402,22559,22687,22712,23526,23750,
23866,24342,24663,25177,25850,25943,26031,27166,27229,27393,
27458,27468,27505,27796,27946,28071,28478,29065,29191,29323,
29581,29760,30036,30482,30745,30843,31258,31401,32034,   17,
   64,  197,  625,  988, 1071, 1177, 1588, 1964, 2059, 2198,
 2606, 2641, 2810, 3475, 3849, 3886, 4147, 4420, 4471, 4569,
 4675, 5210, 6069, 6110, 7257, 7412, 7515, 7680, 7751, 8491,
 8573, 8915, 9333, 9436, 9458, 9914,10000,10331,10372,10457,
11069,11086,11185,11204,11848,12220,12526,12731,12752,12975,
13594,14181,14529,15707,16618,17089,17535,18195,18312,18344,
18391,18440,18447,19618,19644,19925,20628,20839,20860,20963,
21067,21264,21327,21636,22276,22621,22733,23083,23109,23189,
23339,24162,24197,24214,24228,24401,24641,24822,24891,25104,
25192,25434,25603,26723,27534,27544,27758,28361,29036,29347,
29596,29624,29856,30032,30080,30280,30532,31527,31943,32018,
   57,  328,  507, 2327, 2573, 3345, 3584, 5528, 5582, 5958,
 6612, 6848, 7155, 7948, 8557, 8679, 8843, 9569,10054,10236,
11167,11475,12933,14218,14738,14902,15778,15790,15835,16196,
17370,17591,18283,19652,19680,19985,20602,21283,22196,22317,
24492,24659,25735,26128,26420,26755,27110,27210,27962,28294,
28572,29097,29203,29603,30346,  112,  478, 2304, 2596, 4560,
 5025, 6023, 6077, 7006, 7017, 7445, 7617, 8499, 8727,10657,
12803,12871,13271,13488,13720,14275,15609,16457,17387,17413,
18487,21993,23371,23447,24350,24623,26403,26519,26546,27762,
28001,28041,28564,29270,30569,30802,31350, 1034, 1505, 1547,
 1824, 2932, 5204, 7545, 8322, 8360, 9156,10032,10507,10644,
10903,11005,12773,13070,13083,13494,13577,15138,15301,16535,
18561,19281,19727,19818,19889,19931,19981,20802,21217,21718,
23687,23706,23822,25537,26061,27502,28255,29670,30404,   90,
  217,  393,  523, 1184, 2333, 3017, 4384, 5770, 6416, 8262,
 9167,10096,10149,10593,11064,11821,11917,13096,13940,14226,
14269,14876,15100,15629,16278,16367,17546,18466,18779,19333,
20975,24313,24460,24916,25247,25807,26277,26653,26885,31030,
31802,  826, 1298, 2203, 2566, 2731, 4332, 4659, 5034, 6481,
 6665, 7225, 7696, 8908, 9219, 9656,11525,12169,13206,13633,
15937,16633,16953,18670,18694,19394,21757,22477,24324,24688,
24908,24996,26619,26704,26777,26819,27746,28367,29417,31192,
31213,31240,31397,  852,  899, 1831, 2433, 3598, 3779, 5272,
 5780, 7724, 7844, 7967, 8703, 9822, 9867,10186,10302,11057,
11851,12954,13373,13661,14484,16391,16717,17007,17497,18214,
18334,19254,19708,20295,20385,21240,23102,23387,23656,24101,
24248,25306,26160,27620,28079,28543,29091,29639,29700,30877,
30933,  296,  591, 2072, 2726, 2942, 3083, 3171, 3427, 3532,
 4678, 5717, 6043, 6060, 6645, 7260, 7511, 7959, 8952, 9696,
 9879,10004,11163,11781,12444,13345,14061,14743,15049,16256,
16859,17358,17492,17571,19110,20006,20496,20790,21585,21855,
22304,22602,22663,23233,23441,24586,26122,26910,28581,29111,
30059,30926,31346,31376,31713,  233,  322,  460,  579,  695,
 1247, 1387, 1459, 1859, 1955, 1975, 2066, 2131, 2543, 2999,
 3300, 3607, 3691, 3719, 3760, 4188, 4253, 4731, 4930, 4994,
 5102, 5455, 5540, 6372, 6582, 6627, 6766, 6853, 6941, 7109,
 7498, 7566, 7906, 8133, 8274, 8398, 8597, 8755, 8774, 9054,
 9253, 9286, 9660, 9875, 9937,10794,10946,10996,11228,11618,
11623,11746,12054,12151,12814,13027,13119,13559,13838,13906,
13980,14452,14513,15077,15125,15365,15400,15668,15952,16078,
16358,16405,17480,17538,17936,18108,18158,18328,18364,18401,
18652,19044,19347,20681,20750,21034,21123,21149,21236,21386,
21574,21795,22292,22426,22727,22948,22969,23835,24082,24446,
25125,25413,25565,25655,25770,25832,25841,25973,26246,26941,
27414,27686,27866,28242,28523,28666,28691,29185,29337,29435,
29678,29691,29715,29785,29806,29918,30015,30785,31008,31132,
31265,31495,31614,31893,  550,  727,  732, 1410, 1671, 1790,
 2228, 2314, 2896, 3323, 4131, 4502, 4749, 4816, 5015, 5030,
 5056, 5828, 5882, 6011, 6065, 6085, 7205, 7421, 7818, 8505,
 9418, 9511, 9646,10103,10143,10516,11462,12125,12258,12557,
12695,12980,13333,14614,14648,14992,15457,15562,15716,16071,
16573,16784,17020,17037,17907,18384,19455,19695,20088,20545,
20635,20677,21139,21669,21849,22363,22989,23073,23570,23661,
23683,24318,24655,24772,24798,25063,25173,25197,25595,27397,
27548,27787,28116,28157,28228,28237,28276,28492,29729,30639,
30769,30810,31368,31979,   85,  499, 1229, 1677, 2409, 3072,
 4511, 5673, 6194, 6406, 7338, 9282, 9353, 9532, 9931,10688,
10768,10831,10897,11366,11450,12203,12865,13485,13540,13829,
14236,15200,15427,15844,16345,16734,16853,17366,17576,18181,
18908,19085,19092,19492,19829,20169,20240,20415,21953,22351,
22488,22513,23350,23429,23551,23709,24712,24929,25812,26535,
26903,27410,27524,27898,27996,30285,31899,  260, 1542, 2550,
 2768, 4643, 4960, 5311, 5900, 5913, 6114, 6336, 6933, 8912,
 9380,10091,10635,11482,11490,12116,13105,13378,13964,14494,
14905,14912,15408,16820,18377,18456,19050,19226,19366,21250,
21539,21974,22242,22790,22888,22958,23306,24861,25953,26020,
26125,26608,28121,28615,28741,28945,29471,29797,30029,30270,
30342,30758,31447,31693,32010,   61,  677, 1201, 1494, 1503,
 1554, 2813, 2830, 3350, 3653, 5284, 5467, 6350, 6947, 7176,
 7932, 8339, 9519,10082,10214,11528,12107,12347,13075,13305,
13394,13739,14473,14477,14563,15132,15256,16451,17057,17566,
17617,18063,18436,20694,21799,24527,24646,24877,25468,25472,
25495,25866,26576,26851,26936,28576,28673,28719,28825,29426,
30634,31270,31544,  877, 1237, 1381, 1817, 2562, 2995, 3146,
 3291, 3506, 3752, 3986, 4245, 4565, 4812, 7536, 8033, 8989,
 9068, 9753,10368,11043,11352,11571,11759,12320,12381,12484,
14655,14920,15441,16234,18288,18359,18688,19544,19716,19989,
20042,20069,21650,21898,22137,22744,23507,23677,23923,24590,
24626,25747,26010,26363,26369,26847,26966,27873,29005,29621,
31635,31762,   46,  822, 1611, 1660, 1934, 1945, 1979, 2712,
 3806, 3966, 4090, 4745, 4920, 5146, 5297, 5652, 5760, 6231,
 6367, 6568, 6588, 6638, 6868, 7169, 7180, 7806, 8076, 8176,
 8806, 9273, 9606, 9748,10821,11830,12516,12613,13601,13744,
14404,14814,15121,15786,15868,15943,16011,16029,16226,16514,
17296,17526,17772,18661,20575,20702,21206,21438,21931,22031,
22212,22465,22877,23007,23336,23713,24280,24409,24695,25019,
25041,25478,25731,25836,25946,26929,27000,27024,27339,27418,
27474,27653,27882,27894,28363,28438,28508,29654,29877,30107,
30217,30266,30790,30883,31306,31356,31372,31428,   53,  312,
  464,  736,  785,  864, 1161, 1255, 1291, 1499, 1616, 1949,
 2211, 2388, 2885, 3080, 3162, 3318, 3589, 3757, 3927, 4265,
 4286, 4549, 5244, 5612, 6100, 6169, 6285, 6429, 6687, 6992,
 7349, 7427, 7644, 7687, 8089, 8290, 8334, 8353, 8668, 8853,
 8881, 8930, 9632, 9689,10241,10310,10531,10612,10868,10963,
11028,11084,11579,11825,11860,11869,11975,12390,12493,12587,
12828,12951,13176,13284,13701,13722,13922,14222,14249,14346,
15090,15395,15432,15466,15613,15766,16216,16287,16741,16939,
16961,16998,17115,17419,17741,17862,17985,18581,18837,18846,
18946,18979,19068,19168,19210,19251,19287,19323,19486,19842,
20051,20254,20462,20786,20824,20882,20996,21372,21622,21938,
22024,22097,22187,22345,22369,22502,22577,22976,23064,23192,
23367,23375,23588,23665,23885,24549,24923,25158,25396,25574,
26803,26978,27890,28374,28997,29115,29221,29343,29586,29705,
29793,29803,29858,30237,30388,30393,30551,31060,31139,31815,
  494, 1366, 1962, 2205, 2219, 2321, 2367, 2457, 3105, 3150,
 3712, 3981, 4340, 4688, 5213, 5321, 5695, 6198, 7517, 7576,
 7799, 7976, 8901, 9058, 9483,10137,10392,10782,11564,11793,
12237,12533,12743,12988,13064,13098,13117,13279,13521,13845,
13878,14288,14678,14949,15500,15604,15854,16446,16623,16968,
17312,17874,17940,18346,19310,19942,20370,20584,20864,20897,
21451,21508,22163,22375,22436,22716,22864,23240,23860,24039,
24499,24676,25049,25102,25167,26038,26568,26601,27075,27087,
27151,27307,27335,27941,28096,28249,29009,29109,30654,30682,
30998,31024,31171,31504,  142,  903,  965, 1702, 2356, 2792,
 3854, 5592, 6344, 6411, 6744, 7310, 7437, 8317, 9549, 9612,
10280,10291,10409,11077,15079,15177,17047,17095,17732,17865,
18014,19929,20098,20113,21152,22613,23344,23356,24069,24138,
24223,24844,26269,26716,28453,28739,29143,29194,29959,30643,
31006,31723,31876,  610,  623,  892, 2184, 3019, 3199, 3551,
 3763, 3813, 4184, 4292, 4900, 5500, 5817, 7640, 7987, 8780,
 9129, 9269, 9567,12003,12096,14140,15294,15700,18169,18484,
18529,18598,19483,20856,21788,21922,23445,24387,24488,24893,
25985,26069,26348,26401,27371,29444,29465,29712,30086,30163,
30172,31649,  395,  413,  448, 2441, 2517, 3310, 4508, 4998,
 5234, 5266, 6399, 6492, 7004, 8450, 9728,10011,10376,11797,
11967,12626,13544,13683,13956,14103,15018,15570,16281,16347,
16678,16763,17512,18211,18393,18889,19149,19630,20419,20549,
20570,21006,21935,24618,25590,26118,26387,27198,27855,28151,
28195,30604,31034,31997,   99, 1242, 1848, 1951, 2498, 3144,
 4250, 4873, 5609, 5904, 6173, 6624, 7024, 8128, 8570, 9501,
10573,10859,13324,13848,14240,14244,14534,16720,16942,18140,
18315,20453,20984,22237,22897,23451,23883,24024,25312,25958,
27522,27591,27900,28106,28847,29053,29297,29661,30116,30764,
30966,31130,31242,31316,31327,31965,  790,  932, 1304, 1400,
 1775, 2609, 3385, 3419, 3893, 5330, 6147, 6632, 6649, 7152,
 7174, 7188, 7269, 7432, 8101, 8229, 8695, 8848, 9139, 9665,
 9734, 9795,10141,10990,11170,11473,13355,13556,13975,14599,
15056,15580,15810,16780,16795,17208,17553,17765,17972,19406,
19591,19937,20928,21845,21955,22207,22699,22800,23332,25510,
26836,27098,27671,29024,29818,32024,  531,  654,  837, 2738,
 2981, 3331, 3495, 4257, 6029, 6578, 8196, 8408, 8538, 9427,
10061,10449,10490,11539,11840,11994,13406,13457,13696,14312,
14650,15066,15519,15865,16190,16463,16930,17032,17246,17407,
17800,18086,18542,19882,20092,20188,20400,20849,22661,23767,
25091,25263,25680,26181,26188,26244,26515,27842,28145,28562,
28880,29119,29456,29673,30661,30819,31342,31632,  114,  717,
  855, 1250, 2554, 3672, 3785, 3923, 4344, 4459, 4721, 4820,
 5486, 6087, 6681, 7838, 8356, 8523, 8838, 9132, 9256,10691,
10911,11493,11535,11561,11586,11786,11928,12146,12371,12645,
13068,14471,14516,14915,16340,16950,17678,17724,18450,18513,
18565,19318,19661,20195,20313,21183,21619,21964,21998,22585,
23320,23936,24093,24836,25694,26550,26588,26839,27367,27465,
28516,29326,29696,30303,31643,31845,   36,   49,  875, 1795,
 2047, 2150, 2260, 2270, 2774, 3044, 3165, 3468, 3749, 4297,
 4301, 4430, 5046, 5158, 5379, 5411, 7051, 7321, 7332, 7581,
 7953, 8110, 8576, 8992, 9643,10439,11232,11552,12057,12229,
12782,13392,13692,14497,14892,15130,15361,15416,15689,16330,
16800,17150,17621,18074,18915,19306,19335,19356,19864,20024,
20425,21336,21504,21785,22740,23050,23460,23585,23659,24118,
24787,24920,25977,26603,26688,26817,27019,27107,27231,28253,
28610,28851,28868,28889,29240,29496,30157,30974,31940,32002,
    7,   88,  617, 1164, 1181, 1281, 1862, 2834, 3178, 3425,
 4154, 5001, 5288, 5665, 5973, 6226, 6651, 6851, 7063, 7489,
 8084, 8181, 9172, 9492, 9714, 9953,10232,10238,10752,11599,
11625,12700,12719,12801,12957,13005,13727,13826,15027,16021,
16053,16067,16081,16209,16744,16812,16918,17280,17735,18077,
18303,18860,19238,19414,19892,20011,20115,21357,21412,21724,
22533,23245,23911,24033,24832,25045,25440,25583,25941,26065,
26214,26891,27967,28109,28334,28450,28511,29340,29782,30000,
30178,31392,31572,31594,   75, 1019, 1188, 1646, 1889, 2085,
 2191, 2570, 3486, 4666, 4949, 4962, 5635, 5686, 6262, 6354,
 6764, 7219, 7304, 8362, 8520, 9527,10085,10390,11001,11259,
11530,12447,12543,12599,13251,13706,14169,14234,14329,14349,
15042,16160,16565,17242,17710,18770,19015,20640,20938,21262,
21560,21634,22691,22928,23771,24395,24432,24474,25992,26044,
26529,26764,27131,27184,28135,28552,29212,29452,30215,30924,
31263,31791,32021,  408,  885, 1023, 1733, 2438, 2511, 2910,
 3202, 3605, 4272, 4352, 4504, 4895, 5125, 5255, 5606, 5700,
 5853, 5860, 5993, 7057, 7201, 7598, 7713, 7733, 8015, 8342,
 9119, 9306,10225,10479,10606,10703,10713,10970,11074,11716,
11960,11991,12134,12438,12595,12895,12946,13190,13934,14177,
14545,14608,14718,14819,15286,15597,16037,16289,16518,16586,
17201,17218,18509,18534,18750,19064,19265,19421,19476,19518,
20490,20892,21141,21156,21195,21272,21610,22286,22519,22588,
22773,22787,22894,22946,22996,23205,23679,23951,24055,24193,
24211,24705,24829,25077,25099,25251,25259,25548,25625,26072,
27124,27408,27806,27935,27974,28052,28185,28340,28536,28750,
29032,29077,29158,29485,29634,29913,30083,30476,30886,31799,
  720, 1171, 2536, 3168, 4615, 5148, 5200, 6409, 7814, 8020,
 8284, 8456, 8609, 9217,10789,11661,11806,12366,14074,14082,
14502,15642,17477,17750,18273,18548,18832,20231,20935,22299,
24149,24925,24989,26049,26313,26558,28430,29908,30398,31903,
31975, 1397, 1800, 2428, 3183, 4171, 5078, 6348, 6784, 7778,
 9731,10453,11948,13209,13954,14810,14982,15492,15798,16848,
17158,17251,17404,17706,19146,19425,19884,20669,20708,23534,
23624,23634,24315,26227,29087,30229,30249,30435,30748,31042,
31063,  159,  512, 1152, 2394, 2714, 2845, 2949, 3896, 5215,
 5439, 6116, 7802, 8272,10857,11019,15939,16459,16944,17113,
17997,18820,19827,19838,20582,20588,21200,24673,25955,26251,
27719,28426,29850,29956,30160,31111,31338,31567,31883, 2208,
 3792, 5874, 5915, 6723, 7208, 7573, 7718, 9150, 9651,10387,
10901,11931,12554,14246,14880,16614,18501,18906,21253,22180,
22748,22900,23545,23564,24275,26730,26772,27493,27767,30929,
31935, 1004, 2940, 2964, 4049, 6270, 7700, 7722, 9814,10209,
11151,12234,12488,12536,12879,13160,13563,14356,15975,16398,
17630,18299,21019,23811,24517,24739,25035,25367,25466,26355,
28032,28628,30962,31604, 1438, 1580, 3015, 5017, 5515, 7965,
 8757, 9704, 9744, 9801,10650,11651,11828,12411,13464,14252,
16468,17108,18445,19467,19975,20624,22416,23874,25185,28716,
28864,28914,29093,29641,30554,30637, 2662, 3109, 4379, 7876,
 8551, 9265, 9627, 9736, 9854,10684,11397,13056,15960,15971,
18929,20458,20764,21359,22091,22158,23261,24881,25007,25406,
25410,25677,26006,27869,28459,28761,29331,31733,  470, 1413,
 1833, 2926, 3329, 5231, 7820, 8414,11106,13107,15635,16249,
17856,18555,19813,20124,20788,21568,21727,22235,22571,23078,
23123,23176,26598,27312,27735,27982,28162,28498,30180,31582,
31822,  548,  708, 1878, 2252, 3546, 3755, 3768, 4751, 4803,
 6543, 6597, 6781, 8878, 9710,10065,10327,10659,10998,14659,
16410,16809,21520,22040,23292,24721,26082,26814,27016,28382,
29702,31168,31175,  344,  843, 1252, 1792, 2901, 3689, 3934,
 4060, 4295, 4337, 4868, 6643, 6747, 6754, 6803, 6882, 8529,
 9178, 9275, 9698,11080,11334,11671,12157,12311,13641,14284,
15127,15181,15453,15602,16236,16526,18006,18286,18527,18863,
19241,21077,21641,23497,24609,24670,25039,25351,25553,26606,
29128,30174,31770,31808,  207, 1041, 1116, 1186, 1921, 2612,
 2937, 3090, 3267, 3695, 4547, 4946, 5151, 5300, 5484, 6058,
 7238, 7312,10397,10441,10762,10861,11454,11557,11872,12049,
12209,12929,13090,13157,14022,14099,14315,14593,15087,15186,
15430,15873,16363,16629,16714,17426,18570,18920,19008,19875,
19940,19972,20100,20464,20559,20687,21045,21817,21985,22279,
22540,22721,22869,25638,26116,26532,26656,27264,28490,28713,
29575,29871,30114,30380,30465,31206,   34,   43,  121,  219,
  252,  298,  581,  787,  795,  800,  858, 1107, 1225, 1296,
 1469, 1595, 1634, 1654, 1741, 1943, 2050, 2057, 2119, 2148,
 2193, 2226, 2391, 2527, 2623, 2657, 2892, 3001, 3154, 3214,
 3416, 3555, 3559, 3591, 3844, 4056, 4190, 4428, 4454, 4506,
 4641, 4673, 4691, 4924, 4940, 5070, 5333, 5451, 5620, 5763,
 5778, 5791, 5842, 5880, 5998, 6240, 6437, 6474, 6566, 6575,
 6585, 6641, 6987, 7148, 7212, 7227, 7300, 7362, 7736, 7887,
 7901, 7956, 8074, 8183, 8204, 8665, 8682, 8835, 9042, 9056,
 9293, 9489, 9494, 9573, 9750, 9846, 9912,10030,10125,10188,
10270,10285,10308,10427,10679,10755,10786,11178,11202,11349,
11417,11573,11603,11922,12009,12025,12039,12069,12290,12520,
12623,12628,12633,12833,13002,13154,13320,13338,13358,13459,
13467,13604,13856,14033,14065,14079,14107,14150,14338,14460,
14489,14557,14795,14932,15005,15016,15190,15333,15464,15495,
15627,15640,15661,15671,15695,15894,15955,16076,16176,16582,
16642,16668,16770,16979,17127,17177,17187,17222,17310,17314,
17337,17355,17583,17633,17905,17960,17993,18243,18249,18262,
18306,18531,18590,18897,18968,19021,19316,19451,19463,19522,
19536,19742,19788,19801,19807,19855,20059,20210,20373,20407,
20413,20819,20999,21038,21160,21214,21370,21553,21770,21822,
21838,21928,22083,22169,22229,22591,22667,22994,23111,23194,
23202,23329,23492,23626,23704,23837,24048,24159,24304,24345,
24392,24443,24523,24592,24597,24649,25093,25309,25457,25592,
25696,25822,26041,26055,26316,26328,26344,26360,26382,26454,
26470,26511,26566,26570,26719,26844,26975,26984,27094,27191,
27204,27514,27565,27722,27848,27921,28081,28099,28264,28541,
28663,28849,28898,29022,29117,29136,29218,29254,29290,29378,
29437,29836,29902,30017,30169,30232,30295,30384,30432,30450,
30542,30673,30778,30788,30855,31068,31194,31225,31300,31460,
31537,31755,31789,31938,32004,    9,   51,  144,  289,  406,
  576,  614,  629,  897, 1199, 1239, 1293, 1314, 1452, 1745,
 2042, 2153, 2592, 3298, 3313, 3470, 3723, 4157, 4278, 4322,
 4342, 4723, 4771, 4839, 4850, 5020, 5037, 5506, 5714, 5775,
 5830, 6424, 6725, 7053, 7653, 7754, 7808, 7923, 8065, 8218,
 8288, 8326, 8453, 8790, 8870, 8961, 8974, 9127, 9288, 9716,
 9793,10019,10700,10814,10968,10992,11031,11250,11356,11405,
11532,11628,11658,12197,12748,12830,12869,12889,12977,13187,
13335,13510,13645,13698,13866,13928,14232,14259,14327,14878,
14907,14923,15036,15060,15363,15438,16040,16048,16187,16736,
16864,17023,17035,17182,17588,17636,17691,17726,18000,18474,
18891,19474,19632,20008,20547,20644,20666,20679,20784,20799,
21324,21415,21660,22199,22215,22295,22306,22382,22432,22770,
22951,22987,23250,23295,23310,23573,23808,23813,24037,24255,
24429,24661,25261,25663,25737,25755,25773,25987,26174,26451,
27154,27553,27594,27673,27808,27871,27892,28139,28311,28487,
28612,28748,28774,28948,29012,29083,29458,29475,29787,29953,
30537,30690,30760,30795,31189,31336,31901,  147,  648,  690,
  776,  782, 1756, 1813, 1840, 2371, 2454, 2795, 2934, 2957,
 3034, 3220, 3231, 3841, 4118, 4670, 4707, 4713, 4814, 5279,
 5656, 5821, 6008, 6402, 6607, 6880, 7221, 7638, 7979, 8143,
 8319, 8393, 8471, 8650, 8759, 8764, 9374, 9725, 9834,10227,
10503,10642,10655,10716,11209,12375,12497,12912,12959,12991,
13480,13770,14561,14636,14704,14735,15051,15397,15402,15514,
15565,16031,16782,17092,17291,17685,17788,18100,18166,18326,
18923,19105,19140,19350,19417,19555,20561,21338,21381,21542,
21858,22099,22356,22411,22510,22521,22629,23130,23463,23504,
23556,23918,24262,24414,24779,25462,26027,26586,26973,27223,
27381,27517,27581,27661,28124,28814,28843,29790,29812,30288,
30454,30845,30944,31208,31837,31872,  139,  725, 1010, 1096,
 1268, 1383, 1784, 2309, 2380, 2556, 3288, 5120, 5349, 6003,
 6179, 6288, 6730, 6935, 6970, 7041, 7589, 8119, 8739, 9349,
 9431, 9604,10193,10394,11236,11485,11583,12333,12733,13709,
13781,13789,14409,14419,15223,15266,15578,15714,16005,16824,
17792,18588,18765,18877,19060,19075,19130,19538,19719,19811,
20633,21582,21783,23163,23516,24120,25254,25315,25431,25585,
26987,27292,27584,27989,28495,28769,28859,29863,30742,30991,
31106,  835, 2022, 2163, 2568, 2639, 3307, 3570, 3620, 3715,
 4562, 5276, 5337, 5382, 5833, 6445, 6500, 6845, 6943, 8298,
 8347, 8581, 8654, 8748, 9170, 9887,10058,10495,10533,11836,
12323,12985,13010,13666,13881,13990,14917,15283,16183,16596,
16792,17568,17965,18468,19401,19601,20085,21366,21457,22080,
22880,23529,23631,23769,24043,24485,24896,25171,25571,25619,
25675,26428,26562,26882,27092,27351,27500,29045,29123,29772,
30068,31065,31237,31726,31928,  929, 1737, 3586, 3873, 5048,
 6166, 6377, 7262, 7985, 8898, 9756,10264,10855,12398,14159,
14479,15774,16073,16136,16471,16722,17345,18129,18678,19496,
19627,19886,20228,20257,20890,20970,21203,21433,21597,22150,
22418,22875,23389,24681,25080,25210,25298,25881,26206,26541,
26833,26905,27903,27939,28164,28808,28920,29414,29727,30245,
30775,30869,31217,31223,31752,31973, 2275, 3595, 3918, 4304,
 5577, 6838, 7000, 7197, 7509, 8104, 8314, 9076, 9859,10773,
11072,11330,11762,12545,12579,13078,13725,15487,16178,16558,
16827,17385,18121,18644,19203,19290,19915,21476,22011,22111,
23479,24021,24347,24806,25994,26422,26431,27126,28066,29612,
29847,30738,30879,31330,31512,31958,  301,  430, 1435, 1476,
 1538, 1762, 2028, 2064, 2138, 2781, 2890, 3100, 3766, 3951,
 4554, 4617, 5218, 5595, 6295, 6660, 7434, 7451, 7757, 8922,
 9245,10021,10146,10325,11246,12023,12127,12175,12190,12302,
12530,12761,13173,13388,13638,13897,13951,14063,15045,15420,
15898,16008,16101,17144,17818,17988,18137,18270,18592,18887,
19511,19640,21036,21425,21527,21699,21904,22133,22182,22389,
22531,23040,23081,23174,23640,24353,24774,24821,24850,25033,
25195,25436,26630,26706,27105,27365,27725,28369,28872,28884,
29516,29531,29830,30793,31053,31442,31549,  730, 1001, 1467,
 1613, 1777, 1989, 2075, 3326, 3335, 3509, 3514, 3655, 3771,
 3775, 4051, 4270, 5068, 5346, 5488, 5897, 6017, 6075, 6223,
 6362, 6817, 7633, 7917, 8194, 8324, 8724, 9032, 9356, 9447,
 9455, 9508, 9679,10041,10575,10630,10638,12451,13328,13408,
13731,14318,14623,16323,16850,17196,17230,17688,18060,18088,
18174,19234,20061,20095,20382,20691,20793,20821,21322,22719,
22999,23539,23700,25567,25635,26958,27044,27651,27769,28338,
28736,29589,29719,30222,30337,30448,30535,31204,31569,  588,
 1232, 1374, 1886, 2423, 2531, 2799, 3538, 3995, 5225, 5286,
 5617, 6149, 7898, 8382, 8832, 9087, 9145, 9939,10122,10816,
11566,11673,11803,12164,12490,12905,13162,13308,13553,13862,
14455,16415,16432,18682,18772,19173,20620,21260,21827,21996,
22536,24146,24600,25475,25934,26139,26635,27275,27420,28187,
30766,31325,  194,  453,  521,  659,  984, 1168, 2969, 2978,
 3009, 3932, 4417, 4734, 5073, 5435, 5532, 6290, 6426, 6740,
 7558, 7570, 8158, 9811,10098,10220,10652,10950,12418,13101,
14171,14301,14537,14626,14808,14831,14947,16156,16284,16342,
16648,16904,18092,19103,19478,19798,20706,20961,21126,21255,
22312,22814,23135,24742,24858,25277,25971,26222,26594,27215,
27925,28075,28433,28448,28469,28916,29198,29889,30616,31229,
  309,  673, 1017, 1578, 2170, 2836, 3852, 4194, 4525, 5793,
 6380, 6720, 6771, 6856, 6870, 7329, 7620, 7738, 8226, 8401,
 8406, 9230, 9326, 9433,10407,11425,11444,11681,11925,13303,
13643,14325,15599,15653,16387,16593,17206,17544,17559,18256,
18353,18386,18537,18584,19359,19520,19790,20014,21043,22333,
22617,22768,22892,23238,23362,23647,23933,24079,24245,24904,
25383,25493,25606,25728,26000,26034,26694,27609,28262,28866,
28954,29085,29431,29800,30118,30611,30666,31113,31201,31718,
  281, 1640, 1868, 3004, 3286, 3493, 4133, 4163, 4299, 4452,
 4634, 4953, 5658, 5693, 5918, 6599, 6920, 7334, 7343, 7973,
 8332, 8486, 9692, 9723,10111,10803,10898,11207,11545,11653,
12222,12932,13263,13717,13988,14797,14886,14939,15053,15119,
15697,15808,16361,16805,17179,17220,18082,19465,19803,19880,
20301,20757,20809,20830,21028,21587,22354,22366,22413,22472,
23308,23468,23867,24098,24135,24477,24504,25790,26948,27304,
27476,27980,28197,28695,28845,29384,29538,29647,29676,29692,
30049,31117,31426,31552,   79,  155,  212,  303,  357,  432,
  445,  510,  612,  680,  697,  861,  970, 1154, 1279, 1316,
 1480, 1557, 1599, 1685, 1781, 1802, 2010, 2015, 2052, 2176,
 2195, 2324, 2349, 2443, 2509, 2524, 2575, 2650, 2691, 2847,
 2929, 3046, 3186, 3368, 3382, 3474, 3541, 3613, 3721, 3884,
 3900, 4041, 4167, 4182, 4307, 4390, 4467, 4668, 4704, 4871,
 4918, 5099, 5208, 5249, 5327, 5387, 5498, 5511, 5526, 5589,
 5624, 5663, 5797, 5921, 6055, 6063, 6067, 6159, 6228, 6273,
 6278, 6397, 6622, 6884, 6966, 6985, 6989, 7013, 7214, 7324,
 7458, 7499, 7595, 7605, 7742, 7776, 8186, 8220, 8305, 8500,
 8562, 8659, 8670, 8700, 8733, 8792, 8904, 8969, 9034, 9047,
 9105, 9259, 9312, 9345, 9366, 9513, 9764, 9863,10043,10183,
10273,10400,10469,10614,10987,11066,11219,11243,11277,11328,
11364,11415,11477,11559,11576,11581,11714,11912,11920,12060,
12138,12148,12373,12538,12601,12618,12672,12704,12755,12780,
12882,12902,13015,13220,13255,13341,13568,13585,13679,13752,
14043,14085,14095,14113,14415,14421,14552,14559,14675,14711,
14841,15085,15106,15220,15289,15316,15552,15559,15567,15637,
15776,15822,15859,16033,16061,16143,16180,16185,16413,16547,
16861,16869,17130,17156,17198,17240,17299,17339,17474,17487,
17509,17520,17585,17606,17693,17739,17911,17953,18208,18265,
18301,18370,18511,18550,18568,18674,18708,18746,18857,18960,
18972,19219,19228,19301,19461,19506,19638,20027,20033,20126,
20170,20185,20247,20297,20435,20467,20480,20551,20867,20874,
20888,20943,21276,21340,21364,21378,21388,21409,21417,21431,
21523,21544,21847,21944,21950,22124,22301,22483,22569,22599,
22776,22818,22852,22873,23076,23096,23126,23147,23369,23476,
23542,23775,23878,23920,23938,24012,24035,24073,24253,24333,
24450,24700,24729,24824,24991,25010,25037,25178,25256,25295,
25304,25348,25550,25614,25633,25699,25753,25951,26025,26322,
26446,26458,26468,26548,26560,26628,26775,26916,26927,26981,
26995,27003,27212,27221,27277,27328,27359,27510,27537,27586,
27601,27618,27684,27737,27763,27862,27886,28103,28137,28143,
28155,28323,28428,28485,28550,28635,28877,28958,28994,29400,
29424,29487,29509,29906,30007,30013,30072,30234,30358,30401,
30459,30467,30539,30620,30756,30762,30780,30826,31055,31344,
31611,31623,31638,31839,31890,31963,   69,  224,  232,  457,
  541,  676, 1118, 1273, 1372, 1619, 1636, 1773, 2123, 2273,
 2627, 2755, 3152, 3216, 3484, 3564, 3871, 3877, 3909, 4367,
 4439, 4664, 4711, 4766, 4892, 5075, 5202, 5236, 5391, 5449,
 5568, 5996, 6151, 6477, 6875, 6998, 7123, 7224, 7356, 7878,
 8007, 8152, 8173, 8553, 8612, 8920, 9080, 9476,10105,10191,
10243,10321,10694,10956,11003,11098,11108,11216,11230,11255,
11621,11788,12166,12430,12506,12585,12936,13193,13397,13470,
13925,14335,14464,14621,14788,14822,15192,15307,15517,15754,
16069,16212,16228,16435,16466,16483,17162,17211,17564,17769,
18084,18434,18712,19017,19279,20044,20197,20352,20646,20977,
21051,21057,21073,21090,21158,21662,21704,21808,22167,22209,
22288,22756,23132,23182,23716,24016,24232,24390,24856,24879,
24917,25193,25289,25416,25643,25884,26151,26201,26306,26747,
27355,28091,28111,28230,28446,28711,29130,29440,29450,29463,
29775,29874,30292,30374,30387,30630,30917,30941,30994,31261,
31353,31587,31694,31794,31968,   82,  633, 1068, 1683, 1881,
 2037, 2222, 2426, 2598, 2696, 2895, 2921, 3205, 3511, 3534,
 3618, 3795, 4082, 4230, 4638, 4719, 4769, 4836, 5444, 5615,
 5647, 5654, 5888, 6435, 6734, 7145, 7171, 7231, 7376, 7439,
 7600, 7698, 7715, 9108, 9159, 9290, 9376, 9424, 9444, 9633,
 9708,10013,10181,10416,10648,10677,10698,10718,11588,11641,
11743,12016,12177,12449,12577,13007,13109,13322,13442,13462,
13768,13868,13938,13947,14025,14076,14296,14716,14733,14758,
14855,15021,15198,15318,15712,16385,16430,16440,16560,16910,
16977,17044,17184,17708,18069,18203,18296,18379,18596,18847,
18879,19032,19136,19142,19403,19740,19847,19920,20057,20128,
20281,20557,20586,20759,21017,21926,21969,22145,22619,22861,
23458,23763,23773,24045,24057,24085,24096,24122,24127,24300,
24502,24651,24736,24796,24970,25657,25820,26047,26053,26067,
26157,26449,26592,27080,27182,27200,27295,27588,28671,29030,
29210,29268,29287,29493,29540,29770,30212,30283,30502,30838,
30946,31436,31497,31510,31592,31640,31874,  314,  435,  451,
  515, 1156, 1550, 1623, 1760, 2351, 3548, 3992, 5835, 6073,
 6498, 7539, 7648, 8399, 9148,10068,11378,11655,11969,12012,
12572,13482,16449,16982,17332,17763,18470,19585,19721,19926,
20404,20841,21829,22027,22204,22516,23057,23108,23290,23424,
23898,24464,24812,25611,26390,26518,26919,27850,27977,29380,
29610,30077,31074,  126,  797,  999, 3465, 4227, 5081, 6001,
 6301, 7195, 8872, 9470, 9903,11239,11287,13681,13787,14531,
14610,15394,15456,15472,16174,17204,17696,17967,18058,18176,
18539,20222,20622,21383,22245,22752,23472,24690,24723,26353,
27144,27987,28506,29200,29845,30430,31040,31575, 1264, 1698,
 2659, 4139, 4841, 5773, 7997, 8494, 8652,10008,10109,12293,
12416,13142,16568,16584,16665,17619,18115,20579,20946,21459,
22926,23156,27348,28388,28475,28882,30356,30560,   26,  620,
 1094, 2449, 2806, 3903, 5303, 5670, 6389, 7105, 8513, 8735,
 8963,10334,12034,13259,14213,14242,14709,14833,15253,16923,
19604,19878,20994,25792,27664,30062,31364,  287, 4099, 5133,
 5912, 6826, 7254, 8909, 9358,10114,10628,11248,12518,12635,
17816,18522,19119,19216,19873,25054,25153,25569,27117,27753,
27813,28631,30279,30300,31141,31547,  137,  200,  918, 1597,
 2529, 2577, 3457, 4686, 5869, 6605, 7115, 7203, 7940, 8690,
 8944,10342,13536,13565,14035,15977,16128,18850,19132,21355,
22743,23642,23947,25082,26805,28270,28956,29505, 1036, 1652,
 2254, 2373, 2838, 4120, 4240, 4627, 6675, 6950, 8867,10216,
12318,12523,12806,14320,14873,16444,17189,17721,17861,18843,
19248,22193,24976,25029,25927,26272,28073,29600,30226,31371,
31842,  526,  657, 1631, 1957, 4320, 4741, 4847, 6365, 7702,
 8211, 8987, 8995,12943,13312,13971,15424,19534,19899,20163,
21166,21825,22106,22152,22973,23236,23913,24163,25587,27377,
27480,28705,29334,31157,  631, 2020, 2307, 4350, 5091, 6375,
10282,11664,12051,12405,12686,14372,14500,14698,15659,16003,
16096,17614,17747,18503,18631,20685,21180,21278,21750,22046,
22113,23690,24422,25701,25769,26946,28279,28923,29422,29514,
30396,30597,30632,30670,31021,31313,31926, 1083, 1351, 2708,
 2749, 2797, 3209, 3339, 3353, 3773, 4619, 6404, 6614, 6840,
 7352, 7710, 9460, 9799,10252,10848,10974,11154,11297,11419,
11593,11770,13330,14358,15188,16145,16165,16264,16766,17304,
17784,17919,17934,19283,19434,19622,20082,20486,20663,20828,
21026,21313,22126,22201,23488,24323,24435,24803,25365,25683,
25844,26506,27422,27607,28035,28250,28287,28307,29861,    5,
  205,  210,  250,  325,  352,  475,  529,  639,  671,  841,
  870,  880,  986, 1090, 1099, 1113, 1219, 1256, 1271, 1368,
 1500, 1552, 1607, 1680, 1769, 1779, 1786, 1819, 2121, 2155,
 2237, 2359, 2600, 2629, 2652, 2924, 2945, 3078, 3125, 3212,
 3374, 3491, 3553, 3674, 3920, 4004, 4053, 4072, 4173, 4267,
 4289, 4309, 4329, 4538, 4566, 4623, 4662, 4955, 4996, 5107,
 5113, 5128, 5293, 5316, 5344, 5437, 5453, 5622, 5783, 5961,
 5980, 6040, 6051, 6092, 6145, 6276, 6293, 6441, 6463, 6545,
 6561, 6671, 6918, 6959, 6972, 6983, 7069, 7250, 7385, 7401,
 7410, 7501, 7552, 7611, 7682, 7727, 7783, 7833, 7962, 8009,
 8136, 8160, 8277, 8481, 8510, 8558, 8587, 8741, 8786, 8798,
 8859, 8886, 9220, 9303, 9330, 9419, 9503, 9657, 9674, 9809,
 9839, 9856, 9910, 9941,10074,10138,10218,10312,10471,10564,
10618,10724,10828,10865,10895,10982,11144,11149,11189,11261,
11547,11630,11866,11910,11916,11939,12027,12143,12170,12193,
12240,12500,12593,12694,12726,12774,12797,12914,13021,13086,
13114,13249,13316,13402,13477,13546,13572,13750,13773,14071,
14093,14175,14221,14280,14440,14643,14685,14839,14865,14943,
14977,14984,15038,15111,15183,15262,15485,15593,15625,15665,
15683,15886,15900,15941,15948,15957,15969,15997,16026,16042,
16204,16537,16542,16591,16673,16709,16802,16836,16845,17154,
17254,17289,17316,17330,17418,17628,17683,17826,17925,17947,
18049,18143,18149,18184,18291,18381,18388,18479,18577,18716,
18739,18744,18756,18970,19170,19201,19205,19308,19489,19646,
19651,19705,19737,19786,19849,19860,19922,19986,20133,20192,
20262,20270,20291,20312,20397,20410,20433,20555,20613,20901,
20954,21345,21399,21422,21439,21474,21756,21764,21798,21820,
21893,21900,21911,21983,22003,22029,22042,22172,22227,22309,
22322,22371,22380,22523,22542,22656,22678,22731,22816,23090,
23149,23167,23172,23314,23377,23436,23537,23637,23710,23749,
24010,24102,24116,24144,24349,24398,24411,24441,24448,24718,
24771,24852,24866,25068,25164,25187,25217,25399,25499,25617,
25746,25788,25815,25839,25858,25864,25949,26062,26166,26212,
26525,26633,26769,26801,26810,26842,26849,27129,27134,27146,
27171,27281,27314,27461,27579,27596,27603,27688,27741,27908,
28085,28149,28175,28332,28353,28548,28565,28701,28771,28836,
28874,28900,28912,28918,29003,29015,29101,29235,29305,29472,
29536,29569,29626,29645,29717,29768,29779,29852,29997,30183,
30410,30446,30457,30489,30496,30581,30608,30675,30723,30740,
30805,31196,31219,31296,31302,31323,31340,31404,31432,31757,
31894,31911,31990,   71,  131,  151,  163,  295, 1044, 1420,
 1540, 1663, 1998, 2140, 2375, 2519, 2587, 2917, 3023, 3173,
 3489, 3665, 4360, 4834, 5482, 5611, 6489, 7512, 7567, 7880,
 8099, 8422, 8466, 9285, 9347, 9368, 9429, 9762, 9894, 9905,
 9994,10063,10128,10432,10646,11161,11234,11275,11649,11945,
12231,12355,12379,12559,12822,13257,13310,13854,14402,14468,
14871,14888,15268,15314,15632,15802,16407,16563,17293,17324,
17602,17978,18514,18692,18735,18827,19246,19340,19445,19677,
20862,21238,21463,22506,22594,22878,22903,23180,23333,23431,
23490,23578,23702,23738,24051,24165,24269,24328,24343,24427,
24965,24984,25459,25477,25579,25969,26232,26309,26796,26921,
26968,27234,27333,27341,27897,28239,28376,28646,29049,29310,
29319,29507,29602,29631,29976,30976,31227,31716,31820,  307,
  415,  772,  829, 1204, 2322, 3188, 3333, 3410, 3808, 3891,
 3943, 3953, 3997, 4149, 4283, 4545, 4774, 5059, 5206, 5274,
 5335, 5377, 5504, 6033, 6157, 6382, 6945, 7199, 7529, 7618,
 7827, 8141, 8268, 8371, 8708, 8718, 8891, 8965, 9049, 9143,
 9823,10369,10405,10872,12256,12304,12707,12717,12790,12961,
13383,13932,14101,14447,14945,15003,15048,15675,15781,15896,
16454,16616,16817,16822,16898,17551,17717,18317,18724,18834,
18903,19156,19620,20267,20322,20438,20740,21326,21639,21746,
21776,23264,23692,24298,24647,24869,25118,25213,25497,25921,
26017,26145,26183,26194,26696,26896,27207,27489,27759,27937,
28050,28309,28575,28658,28828,30191,30544,30851,30989,31127,
31256,31311,31347,31385,31458,31777,31978,  275,  586,  593,
 1458, 1482, 2125, 2625, 3086, 3588, 3693, 4444, 4682, 5137,
 5474, 5795, 6015, 6447, 6551, 6801, 7156, 7625, 8031, 8309,
 8535, 8959, 9071, 9125, 9162,10497,10528,10771,10823,11096,
11198,11766,11814,12021,12122,12180,12396,12678,13178,13351,
13410,13657,13840,13876,14354,14745,14848,15013,15908,16084,
16389,16447,16556,17342,17944,17970,18680,18839,18855,18945,
19423,19895,20285,20315,20693,20766,20847,20880,20895,20990,
21403,21717,22615,22670,23159,23278,23465,23531,23685,23779,
24209,24471,24846,24894,25750,26078,26554,26626,27695,27923,
28364,28419,29226,29329,29879,30002,30019,30202,30250,30857,
31558,31919,  996, 1223, 1311, 1450, 2197, 2545, 2824, 3112,
 3387, 3462, 3709, 3798, 3925, 4176, 5035, 5727, 5765, 5902,
 6472, 6732, 7267, 7575, 7746, 7971, 8568, 8939, 9797,10451,
10797,10977,11036,11091,11100,12247,12359,13723,14131,14343,
14668,15108,15691,16523,17248,17308,17364,17574,18437,18698,
18881,18952,20981,21511,21577,22089,22553,22854,23620,23862,
24028,24710,25438,25739,25794,26714,26831,27558,27576,27713,
28424,28538,28819,29840,29916,30340,30626,30656,31248,31408,
32026,  934, 1244, 1300, 2055, 2174, 2232, 2415, 2783, 3430,
 4315, 5242, 5684, 5845, 6387, 6657, 8022, 8861, 9371, 9382,
10667,11022,11907,12729,12804,12891,13519,14017,14118,15096,
15214,15369,15418,15837,16247,16797,16913,17612,18119,18403,
18894,19494,19717,20175,20568,20965,21031,21648,21862,21917,
22737,23113,24419,24884,27357,27369,27485,27965,28192,28684,
29059,29898,30176,31177,31187,31606,31995,  427,  980, 1941,
 2456, 2594, 3284, 4334, 4487, 5406, 5971, 6836, 6940, 7822,
 7942, 8340, 8492, 9738, 9880, 9889,10421,10948,11081,11183,
11981,12184,12924,13185,13591,14720,15275,15788,15962,16533,
16858,17003,17041,17214,17667,18079,18090,18638,19123,19260,
19673,19732,20016,20110,20427,20796,21600,21612,22005,22138,
22953,23011,23059,24287,24512,24906,25201,25423,25539,25767,
26216,26456,27266,27353,28105,28359,29156,29446,29777,30187,
30247,30951,31905,31933,   24,  327,  462,  715,  874, 1857,
 2463, 2776, 2955, 3223, 4234, 4612, 5192, 5691, 5991, 6047,
 6392, 6694, 6928, 7371, 7740, 8192, 8260, 9044, 9360, 9820,
 9861,10571,11808,12106,12620,13024,13314,13775,13895,14411,
14442,14883,14900,16549,17622,17872,17894,18624,18748,18974,
19589,19888,20048,20213,20416,21330,21589,21730,22597,22607,
22915,23001,23256,23753,23869,24091,24216,25012,25293,25429,
25464,26700,27803,28834,28907,28941,29582,30102,31160,  665,
  887, 1008, 1376, 1408, 1735, 1753, 1809, 3098, 3321, 3911,
 4068, 4324, 4568, 4656, 4694, 5131, 5923, 6822, 7166, 7229,
 7449, 7983, 8924, 9473, 9613, 9831, 9924,10293,10585,11061,
11712,12155,12392,13092,13332,13360,13496,15201,15557,15796,
16158,16393,16764,16946,17729,18155,18586,18719,20202,21049,
22750,23653,23757,24533,24577,25027,26229,26736,26759,27478,
28043,28371,28518,29189,29406,29477,29681,29923,30047,30152,
30591,30618,31424,  192,  229, 1059, 1166, 1496, 1573, 2357,
 2382, 2469, 2694, 2751, 3970, 4385, 6019, 6810, 6860, 6957,
 7327, 7415, 7654, 7921, 8993, 9462, 9530, 9898,10076,10818,
10879,11221,11279,11487,11632,11745,11923,12435,12938,13076,
13294,13561,14303,14370,14539,14701,14805,15634,16973,17128,
17604,17758,17782,18106,18865,19419,19679,20038,20745,22430,
22467,22907,23827,24008,24239,24495,25313,25371,26155,26237,
26341,26417,27197,27698,28064,28320,28841,29468,30558,30685,
30833,31362,31499,  894,  913, 1478, 1700, 2217, 2539, 2808,
 2912, 3391, 4629, 5004, 5054, 5523, 5866, 6176, 6496, 6787,
 6829, 7885, 8282, 8358, 8484, 9442, 9491,11176,11643,12145,
12616,13261,13386,13860,13912,14237,15133,15426,15447,15871,
16650,16814,17674,17829,18260,19905,20469,20700,20736,21065,
21441,21644,21741,22508,22566,23093,23154,23520,23553,23889,
24607,25160,25640,25686,25998,26204,26248,26325,26751,26884,
27429,28313,29047,29145,29843,29882,29904,30452,30956,31438,
31490,31580,31922,31983,  341,  546,  583, 1206, 1212, 1678,
 1816, 2145, 2178, 2258, 2421, 2553, 3074, 3536, 3697, 3736,
 3790, 3863, 3936, 4287, 4448, 4725, 5122, 5413, 5457, 6106,
 6218, 6260, 6461, 6534, 6762, 6815, 6854, 7514, 7889, 7992,
 8198, 8602, 8697, 8713, 9037, 9074, 9261, 9295, 9314,10140,
10514,10760,11269,11386,11393,11549,11601,12674,13203,13444,
13538,14145,14173,14230,14290,14740,14863,15113,15142,15502,
15576,15814,15878,16419,17349,17698,17737,18247,18733,19040,
19352,19642,19692,19969,19998,20103,20444,21856,22147,22154,
22217,22398,22693,23380,23725,23740,23821,24066,24291,24720,
25005,25015,25047,25089,25126,25189,25744,26084,26164,26196,
26267,26596,27226,27528,27948,28069,28477,28482,28528,28745,
29152,29262,29594,29694,29765,29796,30277,30408,30499,30815,
30960,31072,31123,31620,31706,31946,   16,  285,  293,  734,
  833,  878, 1385, 1418, 1426, 1842, 1923, 2160, 2268, 2405,
 2579, 2951, 3041, 3229, 3562, 3593, 3658, 3663, 3869, 4280,
 4348, 4456, 4573, 4653, 4755, 4909, 5062, 5086, 5269, 5395,
 5702, 5771, 5851, 5978, 6010, 6356, 6530, 6968, 7173, 7186,
 7252, 7496, 7572, 7772, 7915, 8011, 8102, 8228, 8784, 8788,
 9222, 9449, 9525, 9817, 9852,10034,10056,10195,10318,10481,
10518,10530,10616,10850,10853,10944,11241,11764,11838,11943,
12046,12352,12702,12759,12934,13018,13095,13148,13164,13281,
13364,13491,13694,14091,14121,14331,14652,14799,14837,14875,
15377,15511,15745,16023,16192,16242,16286,16325,16333,16353,
16461,16761,17119,17135,17244,17302,17402,17561,17616,17903,
17917,18012,18131,18151,18182,18338,18559,18575,18649,18901,
19127,19244,19263,19274,19472,19744,19991,20165,20199,20238,
20475,20563,20615,20642,20652,20781,20791,21010,21075,21232,
21342,21546,21566,21658,21722,21796,21815,21890,21902,21978,
22336,22549,22665,22765,23234,23259,23317,23391,23927,24616,
24685,24732,24781,25023,25242,25275,25454,25480,25609,25797,
25976,26172,26220,26320,26654,26721,26732,26829,27012,27096,
27463,27498,27535,27605,27703,27791,27969,28247,28533,28654,
28734,28950,29089,29205,29246,29299,29387,30005,30155,30371,
30422,30679,31019,31518,31590,31686,31721,31806,31818,31930,
31952, 1390, 1555, 1758, 1821, 2412, 2534, 3123, 4497, 4556,
 4709, 5097, 5104, 5156, 5211, 5309, 5632, 5909, 7836, 8003,
 8138, 8263, 8896, 8936, 9410, 9534,10300,10589,10833,11339,
11667,12875,13029,14215,14374,15242,15399,15489,15657,15842,
16082,17824,18003,19077,19221,20676,21004,21245,22243,22293,
22703,22779,24041,24458,24827,24978,25056,25110,26807,26853,
27765,28870,29079,29617,30026,30461,30840,30912,31058,31700,
  245,  459, 1092, 1658, 2621, 2828, 2904, 3337, 3376, 3959,
 3973, 4125, 5416, 5639, 7587, 7789, 8946, 9877,11265,11373,
11537,11818,11874,12383,14306,14437,15218,15985,16207,16251,
16704,16855,17168,18072,18443,19292,20172,20264,21170,21843,
21994,22689,22985,23293,23523,23760,23969,24679,26256,26377,
27279,28573,30281,31259,31358,31956,  602,  883, 1633, 2506,
 2512, 4006, 4632, 4852, 6053, 6458, 6756, 7055, 7314, 7542,
 8737, 9555, 9637, 9927,10429,12211,12250,13291,13949,14157,
15329,15572,16932,17000,17394,18676,18956,19337,20299,21924,
22579,22673,23662,23842,24195,25374,26384,26590,27109,27590,
27667,28738,29096,29542,30051,30391,31444,31801,31916,  258,
 3348, 3687, 4743, 6118, 7264, 9515, 9958,10442,10595,10775,
11034,11591,11613,11844,12532,13073,13468,13792,14706,14979,
15451,16833,17580,19557,19649,20002,21315,21966,22490,22611,
23196,23302,23474,24133,24466,25661,26059,26330,27169,27330,
28060,28108,28274,28416,28752,29628,30060,30111,30377,31374,
  508,  728,  961, 1638, 1739, 2186, 2959, 3011, 3120, 3557,
 3651, 3713, 4817, 5066, 5233, 5409, 5520, 6346, 6443, 6685,
 6769, 6937, 7026, 7236, 7560, 8087, 8121, 8380, 8775, 9308,
 9807,10603,10766,12195,12561,12591,12795,13785,13891,14224,
14340,14425,14677,15043,15414,16520,16539,17416,17489,17790,
18785,18918,18966,19045,19256,19701,19862,19902,20310,20512,
21143,21368,23527,23672,23694,23960,25105,25234,25542,26234,
26741,27209,27232,27379,27846,28317,28623,29073,30594,30771,
30922,31129,31191,   30,  128,  157,  305,  311,  332,  419,
  483,  539,  597,  626,  646,  810,  967,  991, 1048, 1055,
 1163, 1262, 1394, 1402, 1423, 1429, 1490, 1591, 1835, 1853,
 1866, 1959, 1991, 2080, 2200, 2305, 2329, 2397, 2526, 2634,
 2643, 2840, 2971, 2983, 2993, 3043, 3276, 3324, 3341, 3487,
 3669, 3764, 3898, 3938, 4039, 4058, 4106, 4276, 4302, 4388,
 4483, 4523, 4535, 4571, 4697, 4801, 4831, 4859, 5089, 5198,
 5239, 5342, 5421, 5490, 5513, 5517, 5530, 5886, 5890, 5968,
 6006, 6049, 6181, 6186, 6264, 6450, 6620, 6677, 6750, 6794,
 6824, 7034, 7049, 7107, 7118, 7125, 7168, 7182, 7346, 7354,
 7527, 7533, 7583, 7785, 7794, 7904, 8017, 8216, 8270, 8286,
 8316, 8349, 8374, 8488, 8579, 8604, 8902, 8918, 8942, 8954,
 8972, 8997, 9247, 9416, 9649, 9677, 9690, 9742, 9754, 9758,
 9892, 9943,10179,10245,10287,10447,10488,10577,10801,10846,
10863,11012,11102,11187,11191,11332,11359,11403,11464,11527,
11608,11639,11755,11779,11795,11862,11941,12014,12153,12253,
12295,12316,12321,12420,12528,12739,12788,12817,12873,12941,
12963,13145,13273,13343,13390,13404,13606,13650,13690,13715,
13735,13766,13864,13936,13969,14027,14136,14153,14261,14445,
14525,14555,14666,14756,14817,15034,15117,15179,15211,15251,
15291,15321,15387,15391,15422,15462,15470,15647,15800,15950,
16010,16019,16220,16230,16469,16485,16746,16768,16773,16819,
16829,16838,16867,16920,16948,17160,17237,17378,17514,17676,
17714,17745,17995,18113,18172,18268,18332,18355,18390,18476,
18495,18657,18684,18758,18818,19097,19250,19299,19313,19345,
19516,19547,19599,19624,19821,20063,20180,20244,20418,20498,
20775,20941,20997,21024,21062,21069,21128,21221,21226,21274,
21285,21347,21401,21427,21435,21515,21713,21754,21766,21972,
22032,22044,22191,22211,22231,22320,22326,22368,22534,22583,
22604,22978,23079,23104,23161,23247,23275,23383,23733,23743,
23781,23831,24087,24113,24264,24439,24452,24543,24667,24697,
24776,24794,24816,24900,24922,25065,25074,25166,25223,25403,
25420,25445,25764,25818,25929,25940,26153,26159,26176,26242,
26335,26410,26466,26564,26708,26799,26970,27026,27032,27078,
27202,27482,27491,27508,27541,27648,27748,27884,27901,27910,
27930,27992,28153,28194,28328,28457,28473,28619,28693,28723,
28831,28934,28999,29017,29040,29202,29257,29429,29474,29533,
29895,29973,30146,30207,30224,30257,30272,30286,30290,30354,
30606,30821,30927,31051,31076,31145,31163,31174,31221,31461,
31747,31981,32006,  905, 1370, 1474, 1690, 1936, 1966, 2915,
 3135, 3180, 3351, 3882, 3968, 4045, 5767, 6421, 7842, 9091,
10792,11772,12306,13175,14239,14491,14930,16098,17175,17399,
17690,17932,18168,18294,18472,18633,19080,19608,20259,20591,
20986,21193,21748,22277,22684,22729,23326,23751,27761,27985,
28259,28305,28570,29228,29816,29900,31015,31406,   77,  248,
  255,  338,  578, 4951, 5115, 5679, 6021, 6673, 8145, 8560,
 8865, 9277, 9352, 9378, 9510, 9836,12364,13026,13375,13904,
14019,14265,14273,14825,15670,16172,16338,17433,18349,19023,
19134,20442,20517,21205,21461,22122,23618,23915,24006,24339,
25095,25174,25589,25860,26015,27148,27193,27998,29121,29686,
30728,30813,31454,  237, 2018, 2706, 2757, 4066, 4424, 4701,
 4739, 4884, 6192, 6395, 7302, 7331, 7424, 7556, 8067, 8688,
 8983, 9844,10207,10675,10913,11676,12216,12607,12948,12969,
13677,15436,16065,16378,16402,16925,18191,19151,19587,19858,
19977,20279,20770,21185,22746,23062,25279,25846,26311,26339,
26931,26960,27406,28801,30365,30791,31542,31976,31988,  472,
 1571, 2172, 2688, 2743, 3194, 3597, 3922, 4179, 4327, 5476,
 5733, 5878, 7804, 8503, 9243, 9292, 9620,10262,10459,10566,
10972,11094,11196,11568,11734,11810,11996,12313,13004,13918,
14449,14619,15902,16417,16902,18397,19836,20233,20673,21280,
21823,23088,23688,23847,23964,24026,25354,25813,25944,27178,
29416,29891,30220,31394,31684,  513,  635,  814, 1038, 1302,
 2434, 3418, 3758, 5469, 6281, 7399, 8531, 9066, 9254, 9479,
10505,11068,11470,12067,12907,13188,13832,14278,15281,15366,
16244,16475,17362,17638,19321,19724,19876,20022,20317,21860,
22949,23014,23052,23115,23184,25002,25317,25450,25876,26392,
26509,26556,26726,28168,29250,29272,29925,30485,31332,31688,
31768, 1464, 3081, 3117, 3389, 3398, 3930, 4684, 5271, 5442,
 5785, 5840, 6340, 6847, 7191, 7646, 7935, 8448, 9328,10275,
10825,10980,11342,11634,13541,13587,14508,14803,15312,15331,
16452,17017,17373,17528,17731,18289,18563,19062,20930,21987,
22022,22680,22812,23121,23707,24064,25052,25732,25887,27779,
28048,28348,29292,29763,29832,29993,30043,30263,30444,30553,
31239,31416,31708,31714,31826,31885,  468,  489,  710,  739,
 1173, 1502, 1876, 1985, 2215, 2761, 3362, 4077, 4192, 6206,
 6303, 6610, 6626, 7256, 7306, 7609, 8345, 8527, 8656, 9848,
10144,10199,10329,10473,10509,10692,11430,11850,12109,12288,
12766,13986,14165,15882,16425,16724,17103,17164,18067,18135,
18147,18160,18654,18789,19088,20304,20380,20465,22394,22706,
23730,24221,24358,24403,24521,24683,24727,25392,25484,25650,
26019,26572,26745,27103,27519,27593,27659,28033,28894,29132,
29154,29522,29605,29828,30420,30693,31151,31378,31434,   41,
  335,  784,  820, 1028, 1214, 1891, 1996, 2224, 2503, 2631,
 2974, 3088, 3700, 3718, 4034, 4169, 4528, 5140, 5572, 6360,
 6467, 6773, 8206, 8275, 8364, 8607, 9343,10107,11686,11977,
12309,12824,13112,13131,13555,14039,14693,15093,15204,15619,
15792,15852,16671,17098,17479,17700,18646,18822,18921,18934,
19524,19553,20177,20595,21137,21147,21199,21952,21981,22544,
22850,23358,23511,23674,23956,24999,25226,26407,26689,26812,
26837,26989,27512,27539,28626,28729,29068,30491,31231,31507,
31561,31833,   92,  215, 1085, 1433, 3025, 3305, 3945, 4433,
 4465, 4558, 4729, 5194, 5597, 5730, 5837, 6095, 6248, 6454,
 6952, 8162, 8950, 9920,10050,10185,10623,11026,12199,12413,
12867,13704,14051,14597,14793,14913,15685,16079,16087,16321,
16344,16794,16841,17232,17409,18009,19066,19101,19117,19805,
19825,19844,19851,20116,20358,20631,20648,20886,21536,21801,
22140,22792,23669,23825,24321,24462,24931,26074,26923,27142,
27495,27751,28126,28289,28567,28637,29103,29398,29663,29721,
30349,30382,30562,31044,31787,  161,  198,  273,  398,  403,
  492,  606,  615,  655,  699,  866, 1015, 1074, 1103, 1125,
 1217, 1445, 1536, 1548, 1559, 1563, 1584, 1796, 1838, 1860,
 1873, 1884, 2002, 2035, 2134, 2168, 2248, 2262, 2339, 2354,
 2401, 2445, 2542, 2585, 2611, 2617, 2770, 2909, 2980, 2986,
 3036, 3138, 3200, 3481, 3500, 3524, 3550, 3615, 3667, 3769,
 3793, 3888, 3916, 4070, 4093, 4141, 4255, 4318, 4358, 4373,
 4377, 4473, 4672, 4736, 4822, 4829, 4938, 4957, 5011, 5109,
 5118, 5184, 5189, 5220, 5223, 5253, 5318, 5480, 5496, 5600,
 5800, 5811, 5819, 5899, 6038, 6042, 6099, 6155, 6161, 6238,
 6256, 6299, 6370, 6408, 6413, 6549, 6571, 6592, 6667, 6738,
 6805, 7023, 7067, 7073, 7210, 7270, 7393, 7430, 7436, 7520,
 7564, 7578, 7636, 7831, 7896, 7955, 7999, 8108, 8112, 8167,
 8266, 8307, 8377, 8391, 8404, 8475, 8515, 8564, 8610, 8643,
 8646, 8663, 8716, 8766, 8893, 8913, 9082, 9123, 9181, 9234,
 9271, 9322, 9332, 9339, 9547, 9553, 9610, 9687, 9874, 9885,
 9901, 9986,10018,10087,10100,10117,10189,10230,10323,10434,
10464,10682,10686,10753,10784,10812,10837,10891,11078,11146,
11157,11180,11245,11284,11291,11423,11598,11721,11776,11798,
11950,12162,12261,12377,12425,12521,12552,12581,12610,12684,
12709,12735,12757,12887,12916,12973,13000,13013,13103,13215,
13253,13326,13372,13472,13647,13653,13687,13719,13763,13850,
13885,13914,14055,14115,14125,14294,14322,14362,14481,14544,
14628,14657,14661,14713,14750,14936,15024,15071,15082,15296,
15372,15383,15404,15459,15507,15623,15667,15672,15717,15752,
15804,15830,16013,16058,16238,16336,16359,16598,16612,16707,
16737,16749,16753,16758,16955,16993,17027,17173,17194,17235,
17326,17334,17383,17391,17439,17542,17597,17665,17694,17779,
17802,17962,18062,18127,18179,18210,18240,18308,18324,18449,
18505,18659,18763,18775,18899,19138,19154,19165,19223,19230,
19236,19277,19399,19480,19497,19602,19636,19697,19809,19833,
19840,19868,19928,20073,20204,20220,20289,20375,20393,20478,
20506,20665,20752,20803,20817,20851,20854,20872,20933,20959,
20972,21212,21332,21449,21455,21571,21697,21733,21737,21743,
21768,21778,21805,21810,21895,21906,21991,22104,22131,22347,
22358,22434,22479,22562,22697,22709,22784,22798,22856,22905,
22941,22966,22981,22997,23074,23106,23152,23187,23200,23252,
23434,23562,23566,23646,23676,23698,23736,23747,24014,24032,
24049,24084,24104,24154,24284,24302,24309,24317,24388,24445,
24707,24789,24819,24834,24927,24993,25060,25107,25155,25180,
25208,25249,25270,25369,25388,25408,25645,25665,25679,25697,
25799,25804,25810,25879,25932,26086,26127,26224,26253,26371,
26395,26439,26500,26543,26616,26773,26787,26815,26889,26901,
26944,27037,27090,27100,27190,27219,27323,27678,27723,27755,
27811,27888,27906,27950,28057,28171,28325,28366,28380,28437,
28464,28488,28493,28514,28578,28641,28661,28699,28816,28947,
28965,28996,29055,29125,29242,29338,29389,29482,29501,29512,
29518,29652,29657,29672,29684,29689,29980,29983,30011,30167,
30533,30565,30585,30650,30672,30817,30860,30986,31003,31210,
31308,31334,31533,31583,31601,31613,31731,31737,31829,31936,
31942,31971,32013,32037,  652,  693,  802, 2117, 2537, 2965,
 3800, 4339, 4944, 5072, 5399, 5954, 6309, 6555, 7797, 7933,
 8542, 8906, 9040,10047,10222,10705,11300,11737,12236,12343,
12440,13499,13930,14282,14604,14670,14726,15260,15516,15581,
15833,16016,16163,16182,16382,16438,16464,16988,17106,17443,
17704,18553,18721,18858,19213,19939,20354,20639,20772,21055,
21581,22475,22820,22955,23850,24267,24331,24394,25236,25758,
25854,26413,26826,27555,27739,28159,28422,29822,30064,30385,
30663,30721,30874,31136,   11, 1121, 2127, 2431, 2560, 2764,
 2884, 3191, 3412, 3703, 4369, 4902, 5389, 6775, 7369, 7422,
 7694, 8746, 9438, 9659,10477,10581,11363,11456,12549,12688,
12784,13084,13836,13963,15496,16138,17723,18544,18690,18861,
19913,22495,22718,24289,24337,25169,25232,25979,26008,26453,
26574,26983,27014,27311,27375,27427,27853,28879,29193,30645,
31573,31728,  278,  860, 1101, 1196, 2086, 4614, 4914, 5433,
 6268, 6486, 7248, 7684, 9173,10254,10714,10960,11801,12158,
12644,12763,13505,13943,16587,17123,17284,18535,19270,20408,
21252,21720,22499,22932,23138,24306,24406,24547,26551,27582,
27954,28461,29217,29403,30113,30747,30979,30992,31061,31644,
31810,   73,  496, 1115, 1353, 2206, 2938, 4032, 4651, 6061,
 6305, 6729, 7717, 7872, 7900, 7925, 7958, 9251, 9956,10395,
11446,11752,12242,12291,13550,14142,15555,15762,15999,16959,
18651,19354,19782,20876,21406,21626,21654,22135,22767,23085,
23321,25681,25774,26523,26771,27927,28343,28860,28902,29233,
30268,30973,31696,31824,  124,  791, 1807, 2038, 2459, 2715,
 3979, 4677, 4906, 5807, 5892, 7396, 7507, 8105, 8129, 8518,
 8577, 8648, 8782, 8877, 9115,10419,11200,11432,11870,11919,
13489,13795,14654,14881,16428,17864,19028,19327,19502,19854,
20276,20378,20811,21228,21467,22422,23143,23396,23651,24281,
24699,24805,25412,25501,28039,28181,29220,30105,30159,30214,
  412,  724,  780,  998, 1416, 2700, 2739, 2902, 3271, 3428,
 3472, 3803, 4705, 5724, 5858, 6024, 6789, 7042, 7147, 7651,
 7951, 8928, 9542, 9623, 9720, 9932,10882,11540,11660,12032,
12132,12178,12638,13318,13493,13857,14168,14254,14504,14680,
14807,14895,14910,15238,15249,15783,15959,16267,16579,16743,
17421,17687,17749,17821,17889,18005,18892,18932,19172,19266,
19596,19669,20101,20108,20401,21092,21592,22093,22273,22311,
23547,23667,24068,24273,24417,24622,24716,25673,25830,26305,
26611,26651,26784,27072,27085,27551,27919,28053,28165,28484,
28648,28718,29807,30040,30436,30808,30831,31125,  195,  240,
  346,  839,  854,  889,  896, 1042, 1064, 1158, 1170, 1249,
 1269, 1575, 1648, 1675, 1879, 1974, 1981, 2044, 2062, 2143,
 2436, 2582, 2977, 3356, 3777, 3783, 3846, 3875, 3963, 4243,
 4646, 4732, 4768, 4772, 4826, 4890, 5057, 5237, 5256, 5651,
 5872, 5896, 5911, 6209, 6246, 6616, 6778, 6782, 6799, 7030,
 7059, 7127, 7298, 7325, 7390, 7404, 7603, 7691, 7813, 8221,
 8225, 8369, 8547, 8585, 8672, 8869, 8884, 9025, 9035, 9046,
 9089, 9107, 9672, 9680, 9730,10005,10524,10607,10840,11141,
11251,11281,11289,11370,11435,11932,11983,12119,12149,12227,
12410,12437,12541,12705,12778,13170,13200,13447,13479,13569,
13598,13708,13888,14036,14058,14066,14728,14742,14786,14993,
15098,15196,15225,15246,15257,15327,15701,15847,15855,15869,
15964,15979,16090,16132,16199,16292,16409,16607,16634,16831,
16847,16909,17760,17798,17958,18051,18093,18122,18490,18710,
19240,19295,19439,19530,19542,19550,19792,20324,20461,20576,
20800,20939,20952,21161,21360,21411,21509,21621,21833,21915,
22034,22149,22376,22384,22675,22920,23005,23262,23311,23766,
23819,23909,24001,24199,24326,24334,24425,24671,24887,25264,
25282,25363,25593,25760,25824,26130,26187,26346,26435,26521,
26728,26762,26780,27127,27158,27186,27274,27345,27616,27682,
27693,27717,28467,28522,28633,28747,28812,29082,29150,29303,
29332,29503,29584,29825,29986,30031,30150,30200,30241,30732,
30743,30835,30849,30964,31107,31648,31680,31704,31909,31966,
  350,  927, 1602, 1939, 2727, 2811, 2996, 3503, 3648, 3810,
 3989, 4086, 4114, 4293, 5419, 5454, 5585, 5905, 6175, 6470,
 6844, 6873, 6878, 6914, 7408, 7505, 7537, 7720, 7761, 7927,
 7960, 8170, 8661, 8979, 9305, 9471, 9521, 9833,10079,10315,
10425,10708,11048,11206,11351,11448,11645,12140,12202,12679,
12945,14108,14133,15272,15615,15779,16787,16970,17054,17344,
17505,17549,17910,18001,18141,18165,18207,18213,18943,20019,
20389,20696,20813,21393,21637,21771,22240,22530,22556,22589,
22801,22924,23169,23338,23394,23535,23558,24251,24396,24433,
24437,24469,24741,24785,24838,25432,25670,25851,25957,25981,
26643,26659,26793,27801,27958,27963,28089,28696,29135,29230,
29253,29267,29307,29799,30170,30652,31011,31198,31589,  148,
  231,  455, 1378, 1437, 1644, 1673, 1729, 2365, 2411, 2461,
 2656, 2815, 3210, 3369, 3520, 3676, 3761, 3856, 4161, 4236,
 4248, 4259, 4695, 5041, 5053, 6028, 6242, 6565, 7011, 7246,
 8330, 9325, 9423, 9561, 9601, 9635, 9645,10130,10256,10306,
11018,11139,11575,11748,11782,12004,12400,13158,13399,13460,
13632,13945,14270,14351,14791,15409,15760,15981,16134,16373,
16625,16922,17034,17319,17340,17593,18252,18329,19094,19112,
19218,19584,19683,19897,19995,20361,20449,20510,20878,21041,
21172,21208,21375,21518,22424,22935,22964,23440,23649,23712,
23931,25115,25203,26270,26373,26622,26738,27133,27213,27298,
27372,27460,28650,29105,29256,29592,29911,29965,30633,30686,
30803,30853,30942,30954,30968,31411,31622,31743,31758,   98,
  225,  246,  641,  679, 1209, 2006, 2073, 2404, 2452, 2800,
 2913, 3269, 3600, 3913, 4153, 4904, 4999, 6044, 6384, 6536,
 6995, 7834, 8396, 8837, 9117, 9996,10660,10712,11000,11215,
11458,11491,11909,12555,12697,13700,13713,13758,14149,14624,
14638,14645,14732,15015,15170,15194,15476,16001,16660,17109,
17563,17582,17715,18054,18368,18493,18566,19012,19528,20229,
20249,20272,20603,20950,21465,21726,21793,22524,22601,23003,
23258,23270,23762,23815,23854,24020,24160,24486,24657,25344,
26208,26433,26717,27530,28037,28093,28234,28927,28992,29622,
29865,30046,30261,30847,30918,30957,  535, 1470, 2660, 3128,
 3539, 3748, 4689, 5402, 6478, 6828, 6977, 7239, 7322, 7930,
 8873, 9188, 9456,10297,10601,11229,11605,12136,12299,12624,
13283,14688,16472,16713,17058,17132,17203,17572,17883,18007,
18718,18976,19034,19262,19628,21032,22036,22198,22404,23286,
24638,26135,26315,27387,27663,27804,27867,27878,28936,29213,
29264,30082,31441,31816,31843,31882,31932,   21, 1414, 2041,
 2532, 5038, 5347, 5576, 6961, 7336, 7944, 8080, 8540, 8571,
 8742,10060,10284,10403,12038,12406,12776,12989,13020,13222,
13264,15227,15494,17998,19468,19508,19691,20091,20808,21645,
21705,21909,21936,22353,22944,23049,24420,24510,24692,24826,
25198,25291,25890,26647,27783,27956,28101,28753,28810,29469,
30195,31579,31763,  107, 2152, 2948, 3222, 3315, 3396, 4418,
 4910, 5259, 5867, 5975, 6004, 6603, 7077, 9626,10246,10339,
11855,11953,12019,12930,13531,13828,15221,15885,16541,16967,
17167,17223,18272,18828,19726,20173,20446,21120,21615,21664,
21740,23887,24675,25300,25460,25551,25577,25782,26115,26790,
26926,28452,28665,29335,29587,29667,30302,31180,31712,  718,
  925, 1510, 2053, 2571, 2735, 2922, 3294, 3359, 3994, 4457,
 4488, 5024, 5112, 5507, 5662, 6274, 6832, 7140, 7242, 7632,
 9896,11937,12904,13156,13336,14458,15063,15293,16148,16619,
16952,17125,17329,18365,19348,19714,19796,20893,20956,22014,
22170,22917,23902,24399,26064,26250,26388,26426,27666,27776,
28704,30153,30497,31502,   87,  477,  519,  600,  914, 1003,
 1066, 1254, 1395, 1695, 2049, 2418, 2448, 2963, 3232, 3380,
 3384, 3850, 4097, 4362, 4382, 4514, 5187, 5247, 5396, 5863,
 5995, 6013, 6031, 6427, 6559, 6629, 7117, 7350, 7358, 7381,
 7881, 8037, 8258, 8366, 8383, 8388, 8402, 8473, 8483, 8544,
 8846, 8911, 9168, 9536, 9667, 9699, 9949,10202,10294,10636,
10778,11109,11533,11619,11666,12029,12097,12692,12919,12992,
13166,13782,14292,14408,14506,15276,15287,15429,15573,15698,
15755,15795,15936,16411,16553,16727,16985,17090,17253,17600,
17626,17913,18145,18263,18508,18639,18737,18953,19055,19106,
19592,19674,19817,19968,20194,20237,20492,20598,20651,20822,
21188,21270,21373,21414,21559,22157,22223,22302,22335,22387,
22565,22739,22883,23055,23776,23871,23945,24599,24737,24769,
24874,25183,25296,25381,25564,25636,25883,26703,26957,26996,
27009,27227,27305,27332,27516,27990,28077,28134,28530,28613,
28688,28822,28852,28924,29443,29488,29805,29842,29867,29915,
30093,30161,30181,30411,30428,30468,30576,30592,31450,31531,
31554,31609,  119,  133,  145,  443,  584,  609,  714,  770,
  817,  830,  977, 1183, 1430, 1486, 1655, 1924, 1995, 2046,
 2084, 2157, 2165, 2326, 2505, 2522, 2793, 2821, 2881, 3110,
 3181, 3207, 3277, 3405, 3420, 3516, 3670, 3737, 4109, 4146,
 4229, 4239, 4251, 4660, 4837, 4929, 5003, 5050, 5127, 5463,
 5518, 5618, 5683, 5687, 5716, 5721, 5728, 5917, 6214, 6225,
 6364, 6529, 6736, 7001, 7033, 7534, 7555, 7634, 7755, 7810,
 7988, 8095, 8165, 8496, 8502, 8726, 8794, 8850, 8990, 9031,
 9185, 9545, 9655, 9830,10067,10071,10266,10386,10398,10482,
10567,10610,10720,11011,11063,11076,11153,11175,11237,11295,
11358,11376,11595,11657,11769,11876,11965,11972,12052,12188,
12251,12335,12575,12646,12676,13120,13197,13368,13384,13484,
13524,13659,13743,13791,13952,14029,14045,14111,14116,14152,
14163,14209,14276,14631,14857,14941,15040,15173,15309,15392,
15490,15524,15649,15818,15838,15861,16254,16260,16423,16719,
16844,16928,17008,17046,17051,17485,17540,17681,17771,17986,
18096,18304,18322,18451,18533,18663,18767,18786,18845,18885,
19058,19115,19128,19253,19665,19709,20167,20224,20307,20484,
20513,20968,21053,21059,21135,21569,21787,22464,22468,22795,
22859,22970,23100,23274,23348,23452,23638,23664,23880,23896,
23906,23916,23949,24129,24412,24541,24972,25014,25086,25215,
25222,25243,25353,25421,25734,25963,25988,26032,26039,26070,
26169,26189,26333,26530,26637,26662,26750,27121,27156,27656,
27742,27792,27913,28087,28120,28243,28443,28546,28683,28767,
28904,29466,29571,29711,29734,29789,30079,30089,30378,30403,
30481,30500,30609,30614,30862,30870,30949,31022,31122,31162,
31321,31329,31349,31403,31615,31683,31987,  164,  234,  268,
  500,  504,  589,  685, 1054, 1389, 1497, 1546, 1605, 1752,
 1811, 2129, 2361, 2396, 2897, 3032, 3543, 4089, 4246, 4460,
 4479, 4522, 4564, 4693, 4760, 5281, 5291, 5322, 5477, 5990,
 6164, 6199, 6272, 6488, 7206, 7493, 7579, 7613, 7791, 7938,
 8086, 8215, 8684, 8894, 8971, 9141, 9318, 9478, 9935,10136,
10177,10249,10378,10491,10604,10620,10654,10889,11054,11615,
11730,11989,12043,12104,12615,12922,13296,13511,13557,13776,
13899,14069,14616,14634,14884,14899,15058,15203,15305,15512,
15710,15974,15991,16055,16273,16396,16543,16562,16772,17191,
17288,17515,17590,17752,17757,17895,18171,18202,18485,18715,
18817,18895,19232,19311,19738,20026,20437,20451,20661,20755,
21088,21164,21179,21216,21320,21390,21540,21643,21781,22051,
22485,22504,22593,22710,22764,23190,23495,23589,23742,23846,
24151,24455,24472,25101,25286,25302,25455,25641,25749,25967,
26011,26385,26710,26952,26971,27040,27291,27360,27385,27457,
27699,28112,28170,28669,28759,29225,29248,29280,29300,29428,
29479,29922,30023,30339,30681,30735,30841,31172,31183,31384,
31783,32001,   65,  100,  209,  221,  244,  930, 1642, 1667,
 1987, 2067, 2146, 2413, 2614, 2637, 2693, 2719, 2789, 3093,
 3496, 3526, 3603, 4081, 4122, 4174, 4284, 4387, 4446, 4493,
 4517, 4532, 4608, 4925, 5009, 5614, 5633, 5761, 5789, 5844,
 6153, 6476, 6484, 6746, 6964, 7045, 7185, 7258, 7340, 7365,
 7606, 7649, 7732, 8188, 8293, 8338, 8698, 8834, 9110, 9176,
 9364, 9415, 9421, 9425, 9529, 9733, 9825,10037,10113,10666,
10702,10877,10955,10964,11033,11217,11478,11741,12007,12172,
12331,12361,12507,12835,12952,12979,13012,13517,13574,13593,
13668,13772,13843,14264,14428,14702,14737,14746,14869,15020,
15241,15368,15440,16043,16050,16262,16332,16571,16637,16803,
16980,17093,17494,17501,17607,18117,18442,18629,18947,18965,
19043,19051,19342,19459,19748,19890,19904,20189,20303,20424,
20667,20782,21124,21729,21941,22176,22185,22282,22330,22551,
22911,23165,23342,23509,23543,23718,24078,24297,24340,24596,
24610,24686,24811,24864,25000,25120,25176,25219,25404,25616,
25730,26418,26465,26632,26698,26934,27028,27116,27176,27302,
27712,27916,27972,27999,28321,28534,28679,28772,28909,28930,
29318,29386,29408,29725,29810,29972,30027,30066,30101,30394,
30556,30599,30824,30867,31029,31048,31167,31631,31652,31720,
31953,32022,  390,  663,  667,  868,  920,  982,  995, 1098,
 1428, 1489, 2161, 2507, 2540, 2548, 2753, 3131, 3158, 3458,
 3743, 3750, 4165, 4335, 5135, 5263, 6177, 6252, 6601, 6761,
 6786, 6922, 7629, 7707, 7963, 8327, 8457, 8706, 8768, 8803,
 9372, 9661, 9684, 9841, 9909, 9951,10029,10120,11168,11544,
11679,11914,11958,12055,12192,12498,12772,12831,12983,13082,
13093,13302,14311,14413,14522,14662,15651,15907,16153,16354,
16576,16798,16896,17249,17519,17670,17762,17804,17871,17969,
18156,18318,18481,18917,18961,19361,19456,19702,20000,20049,
20104,20215,20268,20571,21008,21231,21436,21525,21708,22000,
22213,22308,22685,22804,23284,23288,23514,23629,23732,24074,
24157,24386,24585,24602,24631,26021,26146,26584,26897,27077,
27225,27487,27598,27734,27860,28559,28922,29051,29261,29325,
29411,29573,29884,30231,30390,30472,30916,31245,31318,31564,
31792,31835,  433,  813,  828, 1076, 1160, 1453, 1754, 2112,
 2905, 3467, 3686, 3786, 4482, 4654, 5005, 5080, 5123, 5302,
 5534, 5578, 6811, 6930, 7425, 7524, 8082, 8536, 8591, 9411,
 9440, 9998,10371,10791,10809,10866,11792,12348,12404,13370,
14047,14211,14336,14533,14551,14850,14921,15088,15215,15481,
15746,15874,16028,16856,17786,17893,17942,18951,19047,19083,
19778,19845,20054,20256,20363,20398,20699,20797,21030,21561,
22658,22755,22886,23301,23363,23755,23839,24023,24131,24508,
24870,24974,25075,25124,25349,25843,26447,27005,27342,27689,
27705,28044,28068,28122,28527,29713,29994,30208,30635,30755,
30797,30811,31155,31380,31778,31841,31892,31994,  204,  524,
 1221, 1312, 1665, 3176, 3218, 3283, 3512, 3609, 3678, 3710,
 3956, 4552, 5708, 5823, 6057, 6682, 6912, 7744, 7765, 7919,
 8071, 8093, 8753,10268,10388,10499,10668,10722,10873,11021,
11385,11467,11554,11719,11728,12223,12232,12337,12502,12741,
13486,13747,13846,14348,15264,15605,16189,16202,16270,16329,
17143,17499,17946,18706,18728,18743,19122,19206,19408,19412,
19443,20130,20482,20654,20982,21599,21967,22088,22567,23636,
24423,24645,24731,25020,25058,25490,25581,25838,25870,26504,
26528,26600,26940,26950,27042,27383,28352,28470,28757,28765,
29066,29099,29282,30084,30227,30376,30456,30545,30667,30782,
30938,31351,31556,31619,31773,   62,  283,  517,  545,  594,
  616,  682, 1231, 1639, 1825, 2009, 2310, 2580, 2893, 2952,
 2998, 3390, 3848, 4636, 4716, 4758, 4893, 5461, 6105, 6112,
 6222, 6455, 6749, 6835, 7119, 7394, 7419, 8409, 8465, 8745,
 8800, 9051, 9100, 9272, 9726, 9752,10319,10380,11853,12070,
12999,13356,13711,13894,14499,14684,14804,14904,16211,16233,
16478,16567,16716,17624,17719,17887,18258,18665,18826,19067,
19663,19693,19707,20226,20274,20502,20869,21094,21715,22202,
22324,22342,22512,22975,23128,23265,23340,23426,24100,24242,
24525,25025,25310,25355,25398,25692,25751,26649,26690,27315,
28176,28224,28297,28463,28539,28677,28826,29401,29683,30189,
30486,30684,31413,31692,32019,  135,  688,  704, 1399, 1405,
 1411, 1466, 1574, 2014, 2230, 2255, 3035, 3163, 3235, 4156,
 4581, 5238, 5414, 5447, 5870, 6083, 6267, 6341, 6587, 6861,
 7374, 7392, 7593, 7645, 7692, 8674, 8721, 8796, 8967, 9028,
 9137, 9258, 9334, 9467,10084,10832,10886,11030,11071,11199,
11347,11442,12011,12100,12167,12512,12753,12955,13639,13985,
14161,14642,15185,15231,15328,15638,15687,15972,16825,17026,
17510,17537,17554,17673,17809,17931,18018,18196,18245,18331,
18396,18660,18754,19799,20287,20390,20656,21169,21385,21584,
21620,21913,22019,22026,22047,22668,22674,22681,22922,24054,
24476,24890,25032,25235,25671,26046,26080,26144,26150,26184,
27135,27205,27337,27363,27757,28003,28640,28887,29010,29153,
29231,29289,30073,30244,30729,30773,31057,31169,31421,31506,
31517,31687,   45,   72,  348,  411,  960, 1241, 1493, 1583,
 1614, 1747, 2216, 2271, 2633, 2758, 3106, 3312, 3342, 3566,
 3883, 3937, 4085, 4425, 4572, 4681, 4823, 5217, 5226, 5252,
 5306, 5732, 5777, 6020, 6259, 6501, 6655, 6969, 7320, 7443,
 7601, 8125, 8375, 8595, 8680, 9094, 9147, 9263, 9487, 9498,
 9506, 9765, 9899,10006,10240,10517,10781,10905,11992,12409,
12715,12725,12812,12874,12942,12996,13017,13125,13218,13307,
13455,13543,13865,13913,14651,14669,14933,15271,15437,15592,
15759,15768,16277,16628,16974,17185,17341,17406,18284,18648,
19257,19271,19353,19488,19924,20326,20372,20443,21013,21151,
21256,21631,21696,21840,21929,21954,22390,22895,22992,23134,
23201,23961,23971,24065,24271,24711,25433,25474,25938,26005,
26358,26783,26798,27401,27430,27570,28056,28379,28465,28998,
29328,29627,29773,30640,30816,30885,31369,31453,31488,31525,
  228,  439,  851, 1457, 2265, 2620, 3991, 4306, 4740, 5105,
 5713, 5855, 6825, 7074, 7621, 7681, 8151, 8586, 8855, 9077,
 9133,10288,10770,10788,10800,11044,11205,11227,11484,11563,
12353,12445,14050,14123,14373,15102,15582,16006,16047,16290,
16294,16916,16941,17161,17234,17631,17989,18021,18342,18459,
18762,20552,20805,21132,21227,21700,22433,23084,23255,23505,
23761,23921,23942,24059,24203,24213,24430,24725,25079,25610,
25660,25893,26352,26411,27102,27161,27278,27943,28431,28497,
29029,29968,30033,31203,31819,31982,  387,  846,  971, 1012,
 1277, 2144, 2319, 2379, 2943, 2976, 3185, 3203, 3754, 3809,
 4100, 4345, 4435, 4611, 4947, 5593, 6423, 6471, 6576, 6674,
 6934, 6982, 7303, 7370, 7597, 7800, 8269, 8354, 9868,10014,
10024,10272,10436,10918,10952,11389,11845,12898,13151,13248,
13267,13395,13682,14081,14514,14598,14674,15258,15313,15801,
15897,16064,16074,16416,16791,17227,18298,18356,18361,18541,
19288,19485,19743,19837,20068,20174,20200,20209,20497,20769,
21473,21767,21949,22427,22555,22789,23144,23875,24528,24662,
24963,24992,26461,26614,27112,27538,28286,28358,28510,28609,
29304,29460,29530,29703,29962,30166,30177,31150,31707,31729,
  316, 1056, 1286, 1377, 1893, 2210, 2344, 2576, 2583, 3289,
 3309, 3915, 4455, 4510, 4555, 4576, 4860, 4880, 5766, 6202,
 6237, 6374, 6378, 6876, 7712, 7739, 7977, 8299, 8421, 8578,
 9061, 9741,11252,11436,11805,12110,12179,12344,12431,13141,
13361,13570,13597,13917,14024,14077,14438,15178,15382,15826,
15866,15986,16528,16540,16811,17030,17331,17859,17920,18313,
18465,18583,18691,18981,19148,19595,20087,20234,21213,21937,
22162,22348,22414,23105,23153,23160,23241,23502,23657,24000,
24244,24491,25008,25572,25928,26124,26140,26179,26516,26589,
26618,26980,27020,27273,27583,27799,28291,28329,28425,28824,
28890,28938,29035,29636,29732,29817,30235,30252,30483,30822,
31750,   78,   95,  104,  320,  450,  723,  798,  886, 1226,
 1358, 1362, 1369, 1692, 1783, 1869, 2246, 2261, 2497, 2607,
 2716, 2827, 2849, 2935, 3008, 3196, 3273, 3508, 3621, 3720,
 3731, 4057, 4124, 4135, 4150, 4178, 4466, 4624, 5028, 5149,
 5260, 5283, 5378, 5407, 5590, 5703, 5885, 5999, 6025, 6089,
 6158, 6168, 6197, 6418, 6591, 6640, 6818, 6850, 6948, 7029,
 7568, 7972, 8120, 8205, 8222, 8321, 8389, 8498, 8521, 8762,
 9024, 9227, 9237, 9283, 9435, 9554, 9705, 9843, 9886,10147,
10211,10261,10332,10373,10633,10776,10959,11089,11188,11374,
11602,12015,12120,12194,12215,12357,12436,12441,12609,12680,
12712,12880,12986,13132,13465,13537,13636,13664,13732,13976,
14251,14257,14281,14332,14367,14426,14607,14948,15009,15028,
15105,15235,15405,15469,15702,16024,16038,16095,16548,16594,
16667,16774,16832,16936,17118,17199,17298,17429,17573,17587,
17744,17819,17880,18382,18520,18528,18558,18862,19063,19225,
19357,19588,19659,19690,19909,20013,20120,20377,20456,20601,
20607,20739,20966,21267,21426,21604,21638,21818,21982,22109,
22206,22314,22480,22574,22610,22688,22742,22898,22986,23013,
23193,23331,23430,23583,23633,23673,23678,23963,24027,24140,
24276,24400,24479,24501,24968,25088,25227,25258,25290,25779,
25791,25827,25861,25935,26261,26575,26770,26834,26917,27128,
27286,27310,27423,27523,27841,28152,28252,28337,28384,28830,
29120,29139,29798,29821,29833,29954,30081,30171,30240,30343,
30923,30943,31073,31144,31407,31429,31637,31739,31896,31960,
   84,  249,  306,  485, 1114, 1215, 1348, 1442, 1572, 1585,
 1617, 1770, 2183, 2225, 2239, 2514, 2746, 2779, 3139, 3170,
 3423, 3577, 3843, 4046, 4806, 5432, 5458, 5672, 5910, 6843,
 7154, 7189, 7326, 7435, 7461, 7703, 7914, 8363, 8565, 9106,
 9124, 9350, 9472, 9609,10314,10410,10487,10971,11210,11585,
11761,11841,12128,12393,12927,13008,13522,13962,14132,14495,
14696,14918,15503,15757,15763,15803,16206,16656,17193,17209,
17356,17444,17734,17902,17908,18061,18302,18432,19026,19491,
19621,19804,19867,20753,21048,21086,21363,21397,21454,21607,
21923,21962,22053,22085,22723,23461,23744,24224,24516,24919,
25265,25437,25555,25621,26310,26362,26571,26992,27203,27563,
27674,27786,27879,27932,27964,28308,28372,28857,29013,29094,
29192,29342,29455,29899,30004,30983,30999,31118,31269,31607,
31689,  405, 1104, 1403, 1757, 1849, 1888, 1929, 2218, 2642,
 2930, 3108, 3592, 3872, 3949, 4119, 4546, 4870, 5019, 5278,
 5426, 5804, 5820, 5877, 6287, 6339, 6924, 7835, 7910, 7947,
 7966, 8982, 9537,10286,10430,10467,10519,11329,11642,11682,
11813,12064,12124,12378,12913,13287,13374,13451,13603,13880,
13957,14486,14925,15207,15324,15753,15772,16175,16386,16513,
17012,17181,17791,18374,18398,18675,19523,19919,20052,20887,
21328,21547,21573,21814,22041,22188,22487,22772,22906,23517,
23574,24047,24696,24847,24859,25385,25505,25594,25639,26060,
26429,26510,26852,27610,27778,28049,28301,28645,28724,29043,
29184,29447,29662,29872,30297,30552,30642,30763,30932,31164,
31197,31298,31433,  141,  358,  806, 1007, 1082, 1292, 1625,
 1629, 1844, 3221, 3599, 3881, 4052, 4474, 4515, 4864, 4963,
 5103, 5145, 5503, 6265, 6535, 6631, 6973, 6991, 7064, 7211,
 7240, 7384, 7998, 8209, 8417, 8469, 8508, 8862, 9069, 9130,
 9304, 9792, 9812,10055,10689,11171,11272,11336,11369,11414,
11597,11665,11826,12340,12492,12888,13278,13340,13527,13824,
13841,14454,14806,14859,14891,15330,15556,16443,16647,16863,
16921,16949,17038,17581,17705,18454,19069,19073,19273,19305,
19405,19435,19513,19539,20316,20445,20594,20871,21001,21247,
21595,21945,21986,23041,23069,23120,24229,24261,24301,24522,
24548,24986,26076,26182,26327,26582,26733,27189,27557,27602,
27697,27708,28065,28127,28556,29525,29791,29826,29849,29860,
30057,30078,30112,30478,31455,31641,31722,   31,  300,  343,
  601, 1016, 1070, 1091, 1317, 1793, 2214, 2711, 2954, 3075,
 3328, 3344, 4351, 4427, 4557, 4640, 4726, 5229, 5332, 5657,
 5734, 5963, 5987, 6027, 6162, 6234, 6436, 6596, 6765, 7124,
 7158, 7590, 7752, 7875, 8079, 8179, 8973, 9379, 9484,10009,
10106,10233,10335,10420,11101,11233,11626,11733,12174,12482,
12605,12708,12746,13100,13403,13695,13780,13937,14299,14526,
15046,15269,15285,15443,15454,15664,16360,16392,16418,16534,
16555,16906,17176,17281,17531,17748,17974,18185,18595,18909,
18940,19011,19543,19987,20239,20383,20473,20511,20937,20993,
21072,21202,21337,21534,21934,22100,22118,22409,22780,23141,
23469,23567,24125,24307,24580,24831,24913,24981,25656,25806,
25975,26113,26217,26629,26754,26977,27159,27462,27854,28074,
28377,28733,28804,28935,29074,29623,30659,30767,31035,31522,
31584,31754,31877,31888,   47,  261,  272,  618,  674,  853,
 1087, 1303, 1801, 1839, 1922, 1933, 1997, 2242, 2533, 2648,
 2852, 2888, 2923, 2987, 3002, 3101, 3549, 3571, 3675, 3694,
 3747, 3781, 3895, 3905, 4191, 4378, 4683, 4696, 5044, 5076,
 5205, 5308, 5531, 5538, 5608, 5676, 5698, 5979, 6098, 6210,
 6229, 6560, 6583, 6814, 7022, 7039, 7305, 7446, 7456, 7729,
 7817, 8098, 8144, 8185, 8449, 8667, 8696, 8704, 8709, 8750,
 8844, 8880, 8935, 9155, 9311, 9446, 9642, 9719, 9749, 9798,
 9873, 9906,10118,10414,10626,10647,10663,10765,10783,11056,
11083,11093,11399,11724,11771,11861,11867,11949,12159,12397,
12452,12573,12612,12758,12966,12981,13254,13684,13774,13927,
14083,14172,14229,14291,14317,14431,14519,14562,14802,14820,
14846,14931,14989,15055,15129,15254,15334,15586,15600,15620,
15658,15677,15692,15890,16283,16339,16352,16377,16429,16460,
16643,16675,16708,16806,16852,17021,17136,17151,17567,17675,
17742,17923,18076,18194,18345,18448,18738,18778,18914,19036,
19363,19426,19475,19643,19785,19826,19914,20010,20056,20212,
20294,20387,20421,20659,20737,20842,21218,21444,21514,21846,
21852,22195,22361,22491,22560,22662,22717,22726,22797,22815,
22862,22868,23124,23175,23280,23435,23498,23812,23914,23926,
23957,24090,24235,24352,24457,24483,24633,24804,24901,25253,
25359,25391,25487,25496,25605,25756,25845,25859,25961,26002,
26009,26043,26083,26368,26534,26816,26838,26932,27017,27097,
27228,27267,27467,27567,27727,27895,28131,28387,28436,28672,
28715,28895,29006,29026,29037,29144,29295,29394,29499,29508,
29644,29783,29808,29988,30206,30405,30541,30607,30662,30722,
30776,30919,31031,31067,31230,31252,31400,31539,31550,31570,
31578,31989,32009,  447,  628,  773, 1978, 2132, 2139, 2372,
 2393, 2595, 3155, 3264, 3403, 3980, 4138, 4742, 4842, 4896,
 4992, 5299, 5388, 6358, 6453, 6604, 7823, 8148, 8692, 8715,
 8730, 8976, 9860, 9881,10110,10192,10774,11262,11383,11906,
12115,12429,14219,14530,14980,15031,16603,16779,17245,17610,
17794,18502,18905,18925,19278,19558,19871,20176,20183,21018,
21162,21318,21346,21421,21564,21760,21772,22082,22775,22954,
24217,25233,26597,27130,27152,27428,27720,27770,27976,29438,
29494,29609,29957,30310,30617,30687,   39,  649, 1180, 1356,
 1672, 1967, 2703, 2927, 3612, 3919, 4540, 5831, 6306, 7146,
 7361, 7832, 8175, 8454, 8574, 8583, 9370, 9568, 9630,10450,
10561,10988,11038,11062,11075,11558,12677,12701,12827,12883,
13122,13128,13167,13380,13497,14287,15068,16433,17104,18104,
18439,18516,18848,18975,19432,19879,19971,20284,20765,21091,
21450,21710,22498,22509,22734,23257,24086,24094,24210,24511,
24934,25181,25307,26249,26321,26693,26986,27023,27356,27473,
27997,28097,28899,29060,29106,29155,30439,30601,30804,31519,
31597,31602,  788, 1052, 1299, 1308, 1814, 2334, 2425, 2551,
 2819, 3174, 3899, 4294, 4848, 5058, 5381, 5701, 6672, 6917,
 7132, 7416, 7735, 8472, 9702,10444,10704,11195,12346,12369,
12641,13354,13387,13670,13755,14830,15624,16245,16372,17424,
18083,18199,18668,18829,19507,20412,20645,21747,22979,23186,
23388,24247,24397,24876,25269,25536,25821,25835,25873,26186,
26737,26908,27001,27413,27870,28942,29846,30579,30786,30950,
31588,32016,32031,  394,  506, 1506, 1768, 2803, 2831, 4633,
 4819, 5329, 5861, 6257, 6491, 6635, 7137, 7196, 7235, 8267,
 8296, 8548, 9235, 9276, 9300,10124,12962,13207,14279,14592,
15300,18016,18142,18369,18771,19415,19848,20505,23484,23714,
24121,24444,24652,24813,26892,28158,28423,28505,29388,30087,
30622,31243,31545, 1025, 1062, 1234, 1927, 2557, 3340, 3988,
 4451, 4519, 4856, 4959, 7839, 7845, 9289, 9804,11829,11843,
11976,12048,14248,14536,14813,14882,15823,16142,16574,17169,
17476,17684,19334,19344,19639,19839,20428,20434,20489,20832,
21975,22586,22809,22959,23645,24535,24905,25685,25738,26557,
26612,26846,27106,27329,28855,29597,29677,30935,31020,31234,
  162,  226,  707, 1193, 1780, 2328, 2574, 3016, 3111, 3568,
 3668, 3716, 4003, 5257, 5275, 5774, 6661, 6885, 7151, 7758,
 7968, 8132, 9355, 9516, 9946,11685,11809,12326,12603,12718,
13136,13276,13474,13871,14601,15958,16155,16280,16408,16738,
16954,17155,17955,18159,18864,18938,20080,20587,20883,20942,
21314,22337,22372,22520,22738,23586,23810,24040,24136,24294,
24391,24625,24689,25439,26163,27924,28054,28333,28519,28754,
29613,29720,30987,31766,  670,  909, 1073, 1270, 2065, 3683,
 4117, 4231, 4269, 4728, 4937, 6432, 6804, 7550, 7892, 7980,
 8412, 8655, 9266, 9711,10044,10406,10806,11672,11930,13069,
13514,14271,14350,15435,15483,15594,15666,15848,16519,17768,
17976,18280,18507,19016,20074,20949,21225,21432,21551,21806,
22017,22421,22889,23372,23823,24449,24606,25276,25570,25623,
25924,26538,26954,27389,27617,27849,27981,28084,28460,28878,
29020,29467,29907,30434,30993,31255,31702,31725,    8,   27,
   50,   97,  193,  302,  323,  329,  345,  399,  429,  469,
  487,  528,  533,  608,  653,  702,  731,  740,  783,  836,
  857,  888,  904,  969,  985, 1031, 1189, 1228, 1258, 1346,
 1448, 1543, 1558, 1670, 1744, 1759, 1772, 1789, 1791, 1828,
 1847, 1855, 1882, 1956, 2011, 2029, 2043, 2071, 2185, 2192,
 2194, 2249, 2251, 2274, 2276, 2317, 2352, 2368, 2389, 2499,
 2516, 2538, 2591, 2791, 2814, 2837, 2846, 2854, 2933, 2941,
 2960, 3013, 3161, 3166, 3226, 3280, 3287, 3336, 3488, 3574,
 3585, 3606, 3656, 3662, 3698, 3733, 3770, 3774, 3971, 3975,
 3984, 4061, 4071, 4083, 4094, 4132, 4224, 4228, 4266, 4271,
 4298, 4303, 4437, 4470, 4507, 4529, 4622, 4676, 4735, 4752,
 4809, 4878, 4907, 5021, 5031, 5094, 5132, 5147, 5199, 5289,
 5334, 5384, 5394, 5436, 5487, 5512, 5603, 5621, 5636, 5645,
 5648, 5659, 5666, 5690, 5816, 5887, 5955, 6039, 6093, 6103,
 6144, 6174, 6302, 6371, 6376, 6381, 6386, 6400, 6407, 6446,
 6540, 6542, 6608, 6653, 6666, 6688, 6808, 6869, 6951, 6984,
 6988, 7012, 7025, 7130, 7194, 7222, 7228, 7261, 7348, 7353,
 7355, 7504, 7508, 7714, 7750, 7762, 7819, 7826, 7882, 7961,
 7975, 8004, 8021, 8064, 8090, 8117, 8193, 8201, 8302, 8333,
 8348, 8452, 8478, 8528, 8598, 8805, 8840, 8852, 8868, 8947,
 9057, 9103, 9120, 9144, 9149, 9153, 9161, 9241, 9381, 9448,
 9453, 9461, 9465, 9500, 9566, 9615, 9622, 9686, 9715, 9724,
 9796, 9810, 9857, 9866, 9923, 9938,10133,10145,10184,10224,
10231,10279,10283,10341,10396,10401,10494,10631,10651,10676,
10693,10715,10756,10815,10849,10899,10986,11027,11051,11085,
11105,11186,11258,11340,11343,11350,11355,11407,11416,11420,
11461,11476,11524,11587,11604,11624,11631,11763,11802,11946,
11970,12026,12062,12126,12294,12322,12374,12389,12426,12494,
12542,12547,12558,12563,12578,12594,12630,12728,12779,12799,
12810,12818,12838,12915,13180,13214,13250,13270,13290,13299,
13309,13348,13377,13391,13449,13453,13508,13535,13549,13738,
13869,13909,13921,13942,13974,13989,14040,14067,14075,14146,
14214,14225,14285,14297,14361,14434,14512,14517,14548,14556,
14594,14694,14811,14908,14927,14944,15017,15026,15065,15081,
15115,15193,15228,15282,15302,15317,15375,15415,15425,15563,
15589,15643,15679,15713,15718,15864,15892,15953,15968,15978,
16002,16032,16036,16072,16131,16135,16213,16448,16538,16559,
16592,16597,16651,16658,16742,16823,16903,16938,16947,17101,
17116,17157,17188,17197,17241,17305,17313,17333,17363,17393,
17400,17412,17562,17596,17634,17664,17713,17725,17736,17806,
17813,17877,17992,18055,18144,18242,18282,18354,18380,18462,
18512,18643,18679,18683,18687,18780,18853,18888,18893,18922,
18927,18933,19089,19214,19286,19291,19302,19324,19420,19519,
19531,19609,19615,19631,19794,19853,19921,19932,19973,20005,
20078,20089,20099,20118,20127,20353,20405,20471,20550,20585,
20610,20623,20632,20670,20674,20686,20707,20747,20762,20794,
20829,20875,21042,21050,21082,21176,21182,21191,21196,21237,
21249,21335,21379,21464,21470,21521,21532,21543,21651,21668,
21779,21809,21832,21943,21992,22028,22096,22112,22148,22164,
22285,22334,22365,22407,22429,22514,22537,22570,22595,22628,
22807,22817,22884,23044,23046,23058,23131,23253,23263,23282,
23294,23319,23328,23347,23355,23489,23491,23500,23528,23536,
23572,23577,23641,23671,23699,23737,23746,23851,23857,23884,
23888,23904,23919,23973,24009,24034,24143,24354,24451,24537,
24629,24706,24792,24801,24851,24857,24910,24930,24961,24966,
24998,25046,25064,25108,25172,25196,25209,25260,25274,25288,
25395,25441,25471,25507,25549,25561,25575,25598,25608,25649,
25676,25771,25777,25793,25945,26048,26133,26205,26245,26259,
26264,26340,26349,26394,26402,26414,26424,26499,26552,26567,
26579,26756,26765,26880,26994,27079,27088,27181,27195,27284,
27349,27399,27415,27492,27499,27509,27545,27573,27589,27670,
27745,27922,27945,27986,28005,28080,28227,28254,28263,28281,
28283,28310,28429,28441,28515,28553,28625,28674,28692,28700,
28728,28740,28848,28873,28955,29031,29151,29186,29207,29239,
29392,29462,29504,29506,29513,29515,29632,29675,29688,29728,
29767,29794,29857,29862,30006,30030,30045,30069,30096,30156,
30204,30254,30301,30355,30362,30462,30498,30559,30564,30665,
30779,30820,30961,31027,31075,31104,31247,31301,31305,31367,
31391,31419,31503,31513,31634,31759,31786,31925,31927,31939,
31998,32029,32038,    4,   60,  113,  214,  267,  290,  422,
  634,  656,  735,  742,  796,  902,  964, 1009, 1110, 1282,
 1295, 1360, 1439, 1444, 1612, 1627, 1651, 1682, 1761, 1785,
 1931, 1958, 1971, 1990, 2269, 2432, 2439, 2563, 2721, 2773,
 2807, 2958, 2989, 3082, 3091, 3099, 3215, 3306, 3338, 3360,
 3461, 3513, 3563, 3738, 3794, 3960, 3998, 4005, 4055, 4185,
 4319, 4499, 4526, 4642, 4669, 4854, 4891, 4899, 4915, 5074,
 5111, 5119, 5152, 5157, 5209, 5232, 5336, 5440, 5641, 5768,
 5779, 5792, 5801, 5873, 5919, 6072, 6086, 6205, 6292, 6442,
 6465, 6548, 6581, 6670, 6690, 6745, 6816, 6855, 6919, 6946,
 7207, 7215, 7249, 7268, 7299, 7530, 7767, 7803, 7815, 7879,
 8109, 8115, 8127, 8177, 8224, 8227, 8289, 8315, 8352, 8552,
 8592, 8712, 8725, 8760, 8773, 8793, 8887, 8900, 8925, 9231,
 9279, 9327, 9357, 9490, 9558, 9670, 9829, 9919, 9930,10012,
10028,10046,10081,10383,10391,10456,10639,10671,10683,10761,
10804,10810,10856,10910,10916,10978,11010,11138,11142,11280,
11428,11453,11481,11551,11594,11656,11662,11775,11831,11926,
11942,11998,12013,12257,12330,12421,12489,12569,12744,12781,
12791,12925,13087,13110,13337,13463,13576,13586,13600,13605,
13634,13662,13705,13759,13907,13979,14042,14054,14096,14126,
14137,14223,14305,14313,14371,14538,14653,14658,14719,14840,
14916,15059,15134,15174,15187,15197,15279,15478,15614,15708,
15770,15797,15821,15946,15982,16004,16034,16060,16068,16166,
16188,16218,16481,16590,16677,16808,16813,16962,17019,17033,
17183,17205,17386,17486,17516,17545,17558,17699,17756,17811,
17873,17914,17982,18073,18101,18125,18278,18404,18478,18498,
18518,18532,18578,18650,18868,18944,18957,18969,19009,19029,
19091,19102,19141,19209,19217,19460,19619,19655,19686,19733,
19832,19874,19938,19976,20015,20034,20084,20094,20186,20454,
20558,20580,20627,20709,20834,20976,21016,21265,21348,21468,
21611,21633,21784,21857,22012,22098,22103,22127,22181,22200,
22224,22316,22352,22412,22425,22471,22592,22666,22769,22870,
22945,23094,23112,23204,23271,23370,23459,23525,23532,23559,
23581,23616,23705,23879,23954,24061,24222,24314,24617,24680,
24687,24701,24786,24839,24907,24921,24926,25038,25053,25352,
25361,25476,25568,25602,25695,25785,25880,25996,26215,26228,
26278,26314,26400,26432,26536,26604,26636,26641,26655,26720,
26841,26904,27120,27165,27199,27216,27293,27366,27503,27518,
27527,27533,27561,27672,27788,27843,28102,28144,28148,28163,
28258,28298,28316,28346,28370,28375,28629,28647,28773,28809,
28861,28917,29092,29124,29273,29306,29451,29588,29611,29786,
29829,29914,29952,29991,29999,30037,30194,30221,30267,30350,
30418,30441,30464,30475,30561,30572,30646,30671,30725,30749,
30789,30846,30930,31025,31064,31069,31190,31209,31309,31345,
31373,31528,31553,31639,31809,31962,31993,   18,  318,  501,
 1014, 1288, 1315, 1365, 1386, 2400, 3492, 3751, 3857, 3952,
 4613, 5317, 5596, 5707, 6544, 7142, 7172, 7411, 7582, 7807,
 8182, 8871, 9053, 9995,10269,10292,10695,10836,11572,11973,
12208,12305,12324,12529,12947,12960,13367,14474,14635,14991,
15169,15641,15853,15966,17570,17629,17966,18128,18250,18311,
18551,18569,18591,19038,19111,19245,19319,20109,20934,21140,
21165,21269,21365,21828,22153,22272,22751,22925,23357,23437,
23541,24005,24481,24843,24849,25414,26175,26356,26707,26820,
26922,26965,27681,27768,28762,29216,29427,29457,29539,29576,
29710,30568,31205,31324,31788,31812,31821,31908,  351,  452,
  672,  842, 1267, 1890, 2362, 2569, 2651, 2728, 3233, 3523,
 3726, 4044, 4754, 4941, 5664, 5809, 5843, 6107, 6986, 7897,
 8346, 8683, 8849, 9151, 9221, 9319, 9474, 9743, 9761, 9816,
10093,10208,10822,10981,12534,13061,13161,14174,14420,14448,
14632,14796,14879,15322,15410,15690,15887,16052,16285,16470,
16561,16613,16723,17217,17918,18564,19355,19503,19637,20062,
20814,20846,21376,22090,22107,22694,22791,23859,24249,24780,
25491,25849,25999,26028,26143,26915,27421,27907,27940,28140,
28193,28389,28544,29058,29084,29415,30336,30357,30437,30538,
30588,31002,31050,31339,  282,  490,  974, 1431, 1468, 1564,
 1877, 1925, 2154, 2313, 2420, 2601, 2968, 3020, 3026, 3317,
 4065, 4312, 4355, 5989, 6115, 6393, 6579, 6724, 6841, 7135,
 7167, 7450, 7502, 7779, 8219, 8723, 8777, 8882, 8978, 9331,
 9348, 9697,10042,10062,10661,10991,11459,11494,11722,11799,
12056,12434,12503,12525,13265,13578,13691,14295,14359,14856,
14946,15684,16221,16585,16638,16837,17061,17110,17239,17290,
17311,18290,18538,18773,19430,19527,19670,19980,20221,20232,
20374,20692,20787,20896,21339,21477,21598,21609,21755,21816,
21894,22891,22938,23006,23374,23442,23623,23748,24158,24268,
24274,24503,24531,24614,24797,25021,25443,25509,25626,25865,
26033,26496,27513,27604,28076,28082,28494,28885,29008,29243,
29701,30258,30402,30487,   25,  235,  274,  331,  392,  434,
  700,  872,  994, 1020, 1263, 1417, 1589, 1668, 1688, 1694,
 1812, 1834, 1867, 1944, 2175, 2332, 2589, 2801, 2925, 3201,
 3238, 3325, 3334, 3363, 3537, 3608, 3673, 3772, 3845, 4103,
 4140, 4453, 4730, 4763, 4770, 4950, 4995, 5036, 5079, 5219,
 5292, 5434, 5489, 5505, 5519, 5643, 5661, 5772, 5781, 5825,
 5883, 5997, 6052, 6150, 6282, 6361, 6621, 6871, 6879, 7052,
 7122, 7149, 7187, 7253, 7368, 7488, 7510, 7725, 7787, 7877,
 8100, 8323, 8405, 8476, 8556, 8572, 8651, 8857, 8921, 8931,
 9081, 9098, 9184, 9409, 9564, 9840,10104,10176,10182,10213,
10496,10508,10653,10813,10902,11023,11208,11353,11440,11489,
11553,11636,11727,11758,11961,11980,12040,12221,12391,12443,
12510,12556,12802,12866,12978,13006,13025,13077,13102,13149,
13205,13674,13697,13833,13837,13901,13948,14052,14070,14117,
14128,14151,14493,14815,14818,14864,14901,14929,14950,15044,
15191,15267,15319,15417,15569,15654,15749,15829,16017,16248,
16364,16390,16456,16818,16956,16987,17122,17159,17243,17287,
17336,17359,17422,17780,17796,17898,17961,18134,18187,18201,
18276,18446,18488,18556,18576,18628,18978,19076,19104,19211,
19393,19442,19452,19521,19816,19930,19999,20298,20369,20810,
20827,20836,20962,21011,21046,21052,21254,21261,21350,21387,
21424,21728,21927,22039,22045,22166,22190,22226,22518,22522,
22532,22759,23067,23361,23428,23477,23493,23912,24036,24063,
24092,24237,24305,24346,24473,24582,24627,24784,24835,25071,
25092,25175,25186,25225,25347,25397,25498,25664,25775,25811,
26126,26138,26198,26364,26404,26459,26467,26631,26644,26778,
26945,27091,27140,27147,27211,27361,27394,27469,27845,27868,
27993,28095,28458,28558,28611,28642,28690,28722,28853,28905,
28919,29004,29062,29131,29142,29148,29279,29309,29476,29570,
29870,29917,30098,30216,30308,30603,30638,30774,31009,31045,
31071,31138,31224,31303,31319,31534,31568,31605,31873,31886,
31902,31929,31941,31947,31974,32025,  143,  831, 1000, 1280,
 1375, 2212, 2427, 2737, 3104, 3230, 3278, 3887, 3933, 3967,
 3977, 4321, 4472, 4620, 4876, 5583, 5814, 6227, 6247, 6839,
 7307, 7709, 7821, 8511, 8717, 9033, 9441, 9502, 9673, 9845,
 9904, 9928,10026,10135,10194,10257,10281,11067,11238,12224,
12878,12923,13065,13221,13955,14044,14212,14644,14681,14906,
15052,15210,16274,16431,16450,16515,16799,16943,17320,17857,
17939,18078,18261,19071,19300,19360,19505,19537,19941,20050,
20216,20548,20672,21066,21601,21932,22350,22437,22590,22720,
22811,22879,23232,23482,23701,24704,25272,25825,25926,25956,
26381,26609,26890,27494,27547,27760,27814,28439,28517,28551,
28768,28863,29381,29425,29489,30173,30844,30850,31188,31459,
31541,  962,  983, 1388, 1541, 1679, 1742, 1808, 1823, 1988,
 2223, 2646, 2886, 4193, 4241, 4368, 4374, 4501, 4531, 4840,
 5023, 5301, 5438, 5478, 6041, 6269, 6971, 7372, 7580, 7619,
 8113, 8276, 8294, 8588, 9700, 9722,10309,10320,10526,10615,
10763,11053,11357,11365,11713,12008,12639,12699,12710,12783,
12998,13346,13525,14424,14560,14794,14893,14898,15598,16062,
16097,16186,16343,16384,16462,16721,17539,17777,17828,17957,
18526,18554,19042,19145,19797,19850,20060,20203,20688,21080,
21178,21189,21516,21628,21719,21797,22171,22385,22805,22990,
23056,23122,23353,24013,24518,24550,25048,25833,26620,26746,
26902,27218,27893,27926,28381,28427,28542,29214,29449,29909,
29971,29995,30071,30233,30590,30928,31937,31964,31996,   10,
  263,  280,  339,  356,  389,  431,  444,  495,  503,  630,
  658,  691,  729,  733,  804,  876, 1040, 1047, 1060, 1108,
 1243, 1272, 1284, 1290, 1344, 1401, 1545, 1749, 1787, 1830,
 1841, 1969, 2156, 2199, 2244, 2311, 2342, 2370, 2381, 2429,
 2470, 2549, 2567, 2605, 2638, 2658, 2701, 2723, 2956, 2973,
 2991, 3190, 3224, 3285, 3314, 3349, 3365, 3409, 3459, 3494,
 3499, 3587, 3711, 3724, 3897, 3921, 3982, 3996, 4042, 4059,
 4063, 4343, 4357, 4468, 4521, 4674, 4821, 4858, 4872, 5042,
 5121, 5193, 5207, 5280, 5501, 5536, 5571, 5605, 5655, 5674,
 5715, 5829, 5903, 6070, 6117, 6160, 6289, 6363, 6434, 6493,
 6538, 6589, 6594, 6642, 6659, 6722, 6743, 6763, 6767, 6806,
 6867, 6993, 7050, 7120, 7209, 7263, 7301, 7330, 7423, 7526,
 7571, 7637, 7731, 7737, 7748, 7777, 7798, 7843, 7890, 7949,
 8134, 8187, 8199, 8313, 8331, 8341, 8350, 8550, 8563, 8606,
 8640, 8686, 8771, 8892, 8940, 8943, 8949, 8984, 9067, 9302,
 9321, 9359, 9437, 9459, 9678, 9763, 9794, 9800, 9827, 9884,
10108,10242,10250,10330,10389,10393,10408,10412,10428,10452,
10465,10576,10678,10697,10754,10802,11020,11032,11087,11099,
11190,11338,11345,11418,11424,11455,11526,11560,11589,11629,
11773,11835,11978,11985,12042,12050,12117,12147,12210,12226,
12259,12576,12596,12632,12737,12775,12793,12906,12953,13089,
13130,13194,13202,13285,13297,13311,13365,13401,13516,13660,
13686,13693,13740,13753,13830,13839,13893,13911,13919,13987,
14158,14164,14253,14418,14456,14480,14521,14532,14660,14676,
14832,14842,14914,14940,15176,15189,15205,15295,15315,15373,
15553,15584,15612,15648,15688,15706,15711,15751,15799,15819,
15976,16049,16140,16177,16235,16388,16517,16630,16669,16801,
16857,16865,16981,17126,17190,17338,17403,17427,17488,17518,
17547,17560,17608,17689,17875,17980,18013,18081,18114,18192,
18300,18480,18530,18543,18549,18585,18593,18632,18666,18831,
18886,18890,18907,18942,18967,19014,19031,19065,19139,19174,
19307,19317,19322,19395,19473,19629,19650,19672,19703,19725,
19791,20003,20070,20076,20097,20223,20308,20381,20487,20583,
20592,20625,20668,20760,20807,20844,21084,21138,21198,21220,
21312,21402,21475,21545,21649,21698,21749,21850,21951,21968,
21995,22004,22023,22030,22114,22151,22208,22370,22431,22478,
22539,22548,22584,22660,22708,22872,22893,22940,22957,23051,
23107,23158,23173,23191,23273,23335,23496,23579,23625,23639,
23643,23648,23655,23708,23741,23826,23853,23917,24119,24128,
24139,24263,24296,24341,24385,24447,24542,24619,24654,24669,
24691,24719,24778,24833,25001,25013,25059,25188,25255,25350,
25393,25422,25559,25566,25596,25644,25654,25674,25745,25781,
25823,25875,25882,25965,26030,26152,26161,26230,26243,26312,
26370,26569,26634,26639,26657,26718,26776,26786,26818,26883,
26906,26959,26982,26999,27031,27045,27155,27318,27376,27501,
27600,27668,27743,27876,27899,27917,27973,27988,28040,28146,
28256,28306,28676,28717,28807,28846,28850,28897,29018,29033,
29067,29122,29137,29157,29204,29241,29245,29271,29293,29390,
29413,29523,29537,29568,29578,29646,29851,29883,29897,30055,
30085,30094,30168,30201,30299,30338,30421,30566,30574,30577,
30605,30636,30741,30868,30985,31023,31047,31173,31307,31393,
31425,31437,31457,31508,31543,31548,31581,31784,31814,31906,
31915,31991,32023,   86,  595, 1310, 2578, 3515, 3671, 3735,
 3765, 3935, 4069, 4574, 4746, 5688, 5790, 5818, 5875, 6221,
 6253, 7198, 7912, 8207, 8217, 9055, 9182, 9229, 9239, 9544,
10226,10277,10290,10820,11677,11959,12181,12395,13533,14208,
14436,14656,15078,15240,16733,17215,17446,17900,18180,18703,
18959,19617,20271,20323,20983,21150,21358,21512,21712,22037,
22904,23882,23924,24405,24915,25090,25237,26702,27104,27525,
27807,27995,28047,28129,28161,28471,29442,29478,30175,30720,
30784,30937,31698,  425,  514,  587,  844,  987, 1202, 1218,
 1260, 2267, 2709, 2979, 3137, 3401, 3660, 4609, 4761, 5994,
 6487, 6528, 7790, 7809, 8611, 9096, 9717, 9847,10131,10723,
10758,11073,11736,11938,12935,13067,13329,13382,13389,14507,
14546,14903,15261,15308,15332,16066,16086,16401,16566,16715,
17300,17343,17623,18330,19911,19993,20125,20362,20420,20439,
21395,22608,23777,24132,24782,25055,25314,25954,26247,26257,
26520,26843,28078,28142,28362,29831,29876,30431,31443,31836,
31972,  992, 1799, 2395, 2817, 3378, 3560, 4349, 4478, 4687,
 4933, 6048, 6152, 6271, 6564, 7366, 7535, 8077, 8092, 9948,
11220,11640,12328,12380,14596,14809,15596,16572,16588,16793,
16815,17207,17475,17579,17695,17984,18444,19061,19284,20065,
20218,20457,20964,22139,22303,24123,25018,25179,25502,25740,
25991,26705,26742,26974,27015,27531,27543,27766,27773,28760,
28770,30466,31207,31526,  106,  265,  520,  577,  632,  719,
 1084, 1122, 1236, 1363, 1653, 1946, 2147, 2306, 2315, 2355,
 2450, 2555, 2655, 2898, 3193, 3490, 3614, 3619, 4098, 4353,
 4464, 4720, 4815, 4903, 5273, 5350, 5423, 5514, 5527, 5784,
 6598, 6751, 6821, 6921, 6967, 7417, 7431, 7964, 8019, 8929,
 8956, 9059, 9365, 9605, 9808,10072,10973,10989,11008,11158,
11288,11760,12196,12298,12480,12505,12531,12560,12820,13113,
13186,13212,13315,13542,13651,13939,14429,14896,14935,15199,
15448,15467,15652,15816,15956,15998,16355,16605,16854,17036,
17059,17221,17322,17866,17906,17927,18389,18626,18645,18685,
19121,19155,19358,19411,19440,19469,20277,20778,21058,21207,
21434,21554,21763,22291,22396,22503,22572,22626,22736,23103,
23177,23279,23309,23530,23877,23908,23952,24303,24393,24410,
24660,24885,25411,25469,25557,25678,26542,26695,27288,27368,
27426,27690,28638,28667,28680,28720,29532,29590,29695,29841,
30151,30389,30842,30873,31135,31146,31193,31492,31560,31626,
31653,31984,   52,  132,  206,  216,  414,  449,  479,  775,
  812,  838, 1018, 1391, 1441, 1498, 1600, 1730, 1832, 1852,
 1863, 1937, 2196, 2231, 2444, 2541, 2603, 2692, 2713, 2718,
 2823, 2842, 2936, 3028, 3141, 3213, 3292, 3388, 3547, 3565,
 3649, 3701, 3859, 4105, 4143, 4314, 4325, 4389, 4563, 4616,
 4635, 4652, 4750, 4883, 4894, 4923, 5092, 5212, 5254, 5294,
 5417, 5428, 5443, 5794, 5889, 5916, 6084, 6156, 6195, 6224,
 6410, 6546, 6567, 6618, 6650, 6664, 6692, 6797, 6963, 7020,
 7056, 7104, 7170, 7220, 7383, 7448, 7452, 7513, 7688, 7716,
 7741, 7781, 7986, 8203, 8261, 8279, 8335, 8361, 8464, 8480,
 8490, 8501, 8923, 9088, 9255, 9297, 9337, 9539, 9647, 9662,
 9745, 9819, 9824, 9876,10053,10381,10458,10669,10685,10785,
10793,10892,10912,11042,11049,11060,11110,11270,11283,11387,
11394,11592,11674,11715,11756,11839,12037,12045,12191,12303,
12407,12539,12567,12690,13059,13063,13081,13134,13183,13288,
13409,13530,13552,13564,13777,13788,13835,13847,13867,13896,
13905,13929,14048,14064,14154,14268,14422,14476,14498,14524,
14558,14731,15265,15439,15577,15587,15603,15636,15696,15809,
16070,16075,16102,16157,16232,16420,16441,16512,16557,16718,
16810,16919,16978,17040,17508,17525,17632,17669,17759,18123,
18130,18164,18343,18347,18406,18460,18500,18560,18567,18833,
18904,18916,19046,19242,19351,19454,19482,19590,19613,19710,
19828,19846,19936,20114,20236,20355,20504,20577,20589,20657,
20684,20749,20756,20798,20831,20840,20898,21044,21316,21530,
21635,21663,21789,21899,22130,22280,22410,22489,22568,22745,
22771,22848,22908,22919,22947,23048,23075,23092,23359,23378,
23439,23467,23768,23774,23890,24029,24056,24137,24196,24279,
24402,24484,24624,24841,25069,25112,25345,25407,25618,25628,
25766,26022,26035,26141,26168,26192,26236,26262,26271,26276,
26398,26559,26724,26758,27115,27123,27179,27265,27380,27392,
27464,27595,27665,27711,27729,27851,28072,28138,28174,28225,
28314,28344,28434,28468,28491,28503,28549,28644,28756,29237,
29301,29320,29420,29459,29481,29595,29664,29708,29890,29967,
30016,30103,30179,30211,30256,30347,30644,30668,30689,30777,
30865,30947,31005,31018,31184,31312,31536,31551,31574,31603,
31612,31840,31949,32020,  420,  484,  716, 1485, 1645, 1803,
 2406, 2891, 3311, 3688, 4300, 4363, 4440, 5190, 5201, 5262,
 7009, 7040, 7266, 7723, 7745, 9027, 9417, 9560, 9619, 9709,
 9897,10307,10637,10969,11155,11377,11791,11873,11935,11995,
12292,12432,12720,13028,14470,14501,14683,14828,15037,15292,
15836,15938,16092,16179,16769,17163,17224,17307,17870,18457,
18486,18573,18973,19678,19881,20936,21263,21575,21630,21925,
22050,22405,23125,23680,24164,24215,24418,24682,24924,25085,
25802,26132,26200,26252,26547,26607,27132,27679,27942,28182,
28295,28622,28925,28995,29277,29410,29819,29919,29924,30416,
30546,30727,31131,31900,32000,  666,  726,  976, 2167, 2272,
 3397, 5138, 5154, 5460, 6383, 7409, 7438, 7711, 8137, 8728,
 8980, 9284, 9533, 9574, 9658,10847,11065,11466,12246,12706,
12894,14605,14734,16144,16215,16760,17202,17575,18658,18689,
19418,19715,19891,20441,20701,20980,20995,21774,21984,22275,
22511,22683,23518,23538,24635,24903,25006,25103,25267,25356,
26233,26347,27039,29835,30039,30050,30379,31417,31451,  737,
 1664, 2207, 2227, 2337, 2559, 3005, 3153, 3955, 4835, 5055,
 5822, 6045, 6200, 6741, 6823, 7888, 8066, 8195, 9101, 9179,
 9316, 9644,10706,10824,11058,11731,11811,13730,14260,14274,
14757,15061,15112,15298,17247,17371,19147,19466,19556,19593,
20007,20436,20664,20873,21333,22136,22581,22802,23114,23199,
23444,23756,23845,25729,25986,26050,27214,27975,28058,28303,
28341,29072,30265,30963,31954,31967,   20,  115,  972, 1191,
 2063, 3159, 3236, 3473, 3885, 4137, 4226, 4935, 5569, 6091,
 6420, 6644, 7351, 8559, 8769,10377,10534,10597,11911,12010,
12061,12423,13163,13319,13667,13977,14073,14515,14528,15591,
16100,16740,16995,17292,17727,17775,17808,18094,18167,18900,
19641,19694,20560,21078,21230,21916,21977,22971,23861,24698,
24799,24928,25494,25754,26792,27417,27812,28229,28285,28651,
29336,29811,30148,30291,30429,31170,31823,   48,   63,  313,
  709, 1106, 1230, 1396, 1701, 1885, 2141, 2513, 3177, 3272,
 3604, 3714, 3745, 3787, 4445, 5240, 5533, 5922, 5974, 6212,
 6255, 6748, 6976, 7037, 7309, 7841, 7957, 8304, 8649, 8758,
 9264, 9695,11193,11218,11725,11739,12020,12334,12931,13589,
13767,13915,14609,14790,15029,15288,15465,15622,16282,16362,
16635,16776,17174,17410,17896,18209,18504,18866,19490,19927,
20283,20544,20868,21392,22094,22507,23330,23397,23503,23561,
24208,24233,24338,24823,24964,25930,26173,26195,26918,27138,
27153,27747,27929,28288,28521,28921,29771,30251,30615,30952,
31161,31236,31405,31682,  689, 1373, 1774, 1826, 2190, 2565,
 2939, 3802, 4155, 4305, 4476, 4811, 4917, 5420, 5668, 5957,
 6562, 7144, 7153, 7237, 7837, 8164, 8407, 8678, 8702, 8710,
 8734, 8994, 9157, 9882,10126,10399,11391,11404,11492,11556,
11670,12219,12428,12551,12693,12958,12976,13487,13751,13983,
14410,15579,16137,16223,16735,16945,16976,17042,17091,17627,
17686,17996,18183,19668,19789,20181,20302,20423,20452,21148,
21153,21430,21562,21758,21888,22043,22101,22183,22558,23322,
23364,24067,24475,25036,25387,25647,25863,25891,26018,27086,
27220,27373,27459,27587,28349,28901,29327,29682,29778,30213,
30278,30925,31062,31232,31331,31910,    6,  259,  294,  598,
 1033, 1124, 1157, 1603, 1763, 1942, 2640, 2725, 2777, 2804,
 2809, 3073, 3583, 3910, 4238, 4386, 4524, 4838, 4874, 4897,
 5325, 5529, 5841, 6059, 6088, 7403, 7490, 7577, 7801, 7931,
 8467, 8590, 8653, 9362, 9625, 9713,10102,10112,10180,10247,
10311,10608,10624,10641,10844,10904,10957,11622,11765,12156,
12262,12565,12580,12829,13352,13649,13953,14821,14938,15054,
15277,15311,16203,16276,16341,16649,17589,17945,18075,18148,
18170,18244,18257,18662,18681,18705,18731,18950,19326,19776,
20399,20608,20690,20698,21056,21130,21603,21782,21930,22535,
22672,22881,22977,22988,23195,23289,23627,24272,24299,24539,
24604,24837,24865,24979,25658,26077,26165,26430,27143,27313,
27484,27549,28051,28368,28383,28512,28608,28636,28928,29076,
29383,29423,29625,29792,30284,30683,30691,31166,31186,31563,
31624,31904,   58,  117,  130,  154,  208,  247,  270,  416,
  446,  580,  603,  662,  669,  686,  721,  815,  818,  834,
  891,  898,  924,  979, 1002, 1058, 1112, 1246, 1367, 1424,
 1465, 1504, 1577, 1598, 1606, 1647, 1740, 1815, 1865, 1920,
 1973, 2013, 2027, 2048, 2068, 2126, 2171, 2308, 2330, 2417,
 2435, 2455, 2593, 2644, 2754, 2765, 2788, 2844, 2903, 2931,
 3018, 3102, 3113, 3179, 3319, 3327, 3375, 3399, 3466, 3545,
 3617, 3654, 3679, 3722, 3767, 4075, 4080, 4115, 4130, 4145,
 4181, 4264, 4279, 4288, 4341, 4359, 4376, 4380, 4449, 4486,
 4503, 4509, 4625, 4658, 4773, 4825, 4926, 4931, 4948, 4993,
 5012, 5052, 5060, 5077, 5096, 5277, 5348, 5390, 5497, 5508,
 5594, 5601, 5678, 5685, 5812, 5839, 5967, 5992, 6056, 6074,
 6101, 6146, 6172, 6193, 6203, 6207, 6232, 6297, 6379, 6430,
 6468, 6482, 6495, 6600, 6637, 6726, 6777, 6788, 6812, 6874,
 6926, 7054, 7126, 7204, 7323, 7357, 7375, 7406, 7433, 7591,
 7604, 7753, 7805, 7830, 7884, 7894, 7954, 8006, 8016, 8096,
 8161, 8174, 8180, 8264, 8311, 8343, 8514, 8530, 8569, 8575,
 8603, 8608, 8642, 8854, 8860, 8933, 8998, 9030, 9075, 9083,
 9090, 9128, 9160, 9260, 9270, 9313, 9335, 9426, 9445, 9482,
 9495, 9611, 9739, 9759, 9832, 9957,10064,10083,10271,10324,
10426,10454,10529,10613,10634,10665,10673,10680,10701,10717,
10769,10772,10779,10842,10854,10883,10984,11107,11145,11169,
11197,11331,11372,11426,11445,11451,11469,11614,11627,11654,
11753,11824,11921,11987,12024,12058,12108,12161,12183,12255,
12296,12317,12351,12362,12399,12537,12622,12643,12796,12800,
12808,12823,12864,12909,12940,13079,13091,13143,13262,13301,
13331,13363,13461,13466,13471,13637,13672,13699,13733,13742,
13764,13873,13887,13898,13903,14018,14109,14135,14139,14156,
14160,14250,14334,14342,14369,14432,14472,14510,14550,14679,
14877,14887,15041,15171,15180,15202,15216,15243,15284,15306,
15401,15419,15508,15571,15574,15618,15633,15681,15704,15715,
15791,15834,15863,15867,15970,16077,16080,16181,16184,16200,
16237,16334,16357,16422,16434,16453,16479,16564,16595,16641,
16729,16771,16846,16897,16905,16914,16940,16958,17053,17094,
17153,17195,17212,17303,17357,17376,17420,17502,17543,17672,
17718,17868,17904,17916,17929,17959,18008,18015,18085,18132,
18157,18248,18292,18366,18464,18510,18524,18562,18571,18720,
18740,18790,18859,18936,18971,18980,19018,19033,19074,19137,
19255,19309,19341,19349,19413,19422,19428,19462,19471,19495,
19525,19548,19554,19684,19706,19819,19830,19893,19978,20036,
20047,20058,20105,20193,20211,20314,20359,20371,20426,20448,
20459,20485,20599,20758,20767,20838,20953,20974,20988,21014,
21020,21089,21122,21134,21159,21215,21259,21367,21416,21510,
21549,21552,21618,21640,21646,21653,21765,21769,21848,21997,
22105,22132,22146,22156,22186,22197,22210,22278,22283,22355,
22359,22419,22493,22501,22576,22677,22722,22757,22813,22887,
22896,22974,23010,23042,23053,23150,23188,23315,23376,23453,
23457,23544,23663,23666,23703,23814,23868,23886,23910,23922,
23950,23959,24025,24126,24194,24265,24277,24288,24310,24322,
24428,24520,24545,24637,24715,24775,24791,24871,24933,25009,
25040,25050,25073,25162,25168,25184,25285,25297,25382,25409,
25485,25591,25612,25624,25637,25642,25736,25808,25855,25978,
25989,26012,26063,26081,26129,26266,26308,26406,26508,26524,
26577,26602,26722,26735,26744,26808,26811,26845,26972,26979,
26997,27013,27043,27083,27093,27113,27167,27269,27290,27299,
27343,27386,27471,27511,27515,27540,27597,27606,27714,27754,
27764,27775,27805,27809,27874,27891,27914,28045,28125,28172,
28261,28293,28547,28653,28764,28820,28832,28888,28893,28940,
29002,29028,29056,29064,29070,29140,29146,29209,29291,29298,
29317,29445,29486,29497,29535,29541,29655,29666,29693,29784,
29815,29844,30182,30192,30218,30260,30269,30282,30345,30395,
30480,30495,30543,30550,30555,30619,30627,30648,30787,30914,
30921,30945,30990,31007,31037,31124,31133,31148,31152,31158,
31195,31257,31402,31409,31440,31557,31576,31586,31691,31764,
31838,31913,31944,32011,32035,  109,  146,  160,  297,  713,
 1077, 1162, 1380, 1427, 1661, 1686, 2060, 2350, 2769, 2851,
 3087, 3143, 3535, 3814, 3876, 3901, 3941, 4054, 4698, 4943,
 5150, 5214, 5579, 5827, 5972, 6606, 6646, 6881, 6949, 7043,
 7339, 7734, 7756, 8297, 8594, 8864, 9166, 9294, 9324, 9729,
 9855,10035,10203,10328,10888,11381,11396,11859,12356,12685,
12713,12762,13153,13177,13412,13580,13592,13689,14098,14407,
15033,15518,15662,15839,15860,15940,16152,16399,16745,17014,
17236,17315,17552,17924,18327,18352,18387,19407,19633,19730,
19841,20028,20320,20479,20816,20978,21194,21835,22015,22244,
22305,22525,22664,23324,23726,24019,24155,24240,24612,24855,
24918,25081,25384,25923,26136,26419,26455,26565,26942,26967,
27006,27592,27887,27911,27961,28233,28524,28993,29418,29583,
29864,29905,30014,30598,30694,31028,31398,31494,31705,31923,
    2,  396, 1029, 1050, 1178, 1419, 2323, 2424, 2504, 2630,
 3164, 3381, 3483, 3505, 3789, 4158, 4807, 4913, 5033, 5039,
 5265, 6475, 6802, 6944, 6999, 7062, 7495, 7584, 7652, 7918,
 7978, 8506, 8916, 9307, 9570, 9735, 9747, 9755, 9999,10031,
10051,10086,10210,10301,10563,11247,11296,12035,12314,12367,
13676,14227,14363,14689,14890,14976,16020,16159,16484,17529,
17577,17594,17605,17948,18019,18496,19204,19484,19802,19970,
20660,20776,21661,21716,22179,22777,23116,23146,23291,23366,
23587,23682,24206,24895,25316,25582,25757,26832,26956,27018,
27183,27840,28086,29129,29718,29788,29839,29853,30381,30469,
31355,31807,  334,  467,  869, 1398, 1553, 1699, 1861, 2408,
 4110, 5101, 5320, 5522, 5692, 5806, 5834, 5846, 5926, 6245,
 7538, 7939, 8281, 8291, 8958, 8970, 9041, 9287,10040,10095,
10196,10253,10605,10629,12000,12789,12928,12968,13003,13074,
13407,14321,14564,14637,14647,15004,15057,15237,16473,17200,
17379,17491,17801,18204,18653,18919,18962,19259,19433,19696,
20246,20848,21184,21535,21586,21842,22216,23065,23239,23384,
23715,24031,24231,24478,24868,25405,25461,25761,25800,25867,
26323,26389,26436,26469,27354,28324,28432,28456,28501,28726,
28751,29041,29697,29764,29992,30053,30061,30997,31179,31446,
31918,32007,   93,  156,  218,  230,  481,  547, 1072, 1093,
 1213, 1488, 1539, 1778, 1818, 1850, 2149, 2177, 2335, 2378,
 2649, 3007, 3024, 3039, 3268, 3308, 3855, 3947, 4040, 4282,
 4291, 4370, 4708, 4804, 4921, 4956, 5222, 5623, 5710, 6022,
 6068, 6180, 6366, 6633, 6656, 6739, 6915, 7007, 7058, 7068,
 7226, 7521, 7695, 7991, 8318, 8359, 8747, 8791, 8879, 9118,
 9146, 9257, 9603, 9681, 9821,10099,10375,10658,10709,10880,
10967,11166,11242,11409,11472,11611,11783,11951,12068,12098,
12133,12150,12308,12765,12805,12825,12944,13304,13393,13443,
13566,13665,13849,14026,14310,14451,14736,15109,15184,15255,
15367,15807,16041,16265,16366,16445,16781,16929,17250,17295,
17369,17408,17521,17933,18048,18264,18836,19056,19084,19233,
19315,19900,19916,19974,20365,20514,20572,20611,20621,21074,
21241,21442,21596,21606,21670,21731,22001,22009,22289,22313,
22603,22630,22927,22962,23110,23268,23865,23897,23943,23955,
24459,24526,24770,25016,25221,25244,25257,25305,25427,25453,
25473,25504,25742,25959,26068,26207,26354,26561,26888,27173,
27687,27863,27883,28063,28113,28184,28386,28474,28614,28813,
28911,29090,29260,29604,29620,29878,30018,30115,30392,30610,
30724,30825,30861,31142,31803,   13,   80,  211,  315,  342,
  384,  428,  454,  458,  511,  585,  592,  611,  821, 1100,
 1119, 1182, 1198, 1238, 1257, 1471, 1491, 1637, 1736, 1976,
 2001, 2036, 2078, 2181, 2209, 2345, 2442, 2518, 2552, 2775,
 2928, 2994, 3084, 3282, 3322, 3330, 3367, 3415, 3540, 3579,
 3681, 3740, 3778, 3807, 4033, 4346, 4458, 4462, 4489, 4512,
 4553, 4631, 4639, 4661, 4671, 4685, 4813, 4939, 4952, 5026,
 5312, 5397, 5466, 5525, 5574, 5671, 5962, 6109, 6170, 6219,
 6235, 6241, 6349, 6449, 6499, 6569, 6652, 6770, 6783, 6857,
 6936, 6958, 7181, 7363, 7378, 7426, 7492, 7631, 7647, 7690,
 7699, 7899, 7952, 7984, 8010, 8190, 8300, 8420, 8519, 8539,
 8582, 8645, 8676, 8694, 8738, 8797, 9038, 9138, 9430, 9497,
 9607, 9668, 9703, 9732, 9751,10057,10069,10142,10215,10298,
10506,10532,10574,10643,10808,11136,11174,11184,11223,11256,
11293,11529,11541,11659,11717,11742,11789,11963,11993,12047,
12053,12198,12213,12332,12415,12496,12588,12892,12896,13094,
13106,13258,13321,13562,13595,13721,13736,13745,13769,13798,
13941,13970,14062,14102,14114,14247,14277,14283,14339,14414,
14459,14671,14729,14744,14826,14996,15000,15076,15104,15137,
15230,15370,15412,15452,15463,15473,15482,15501,15626,15787,
15901,16147,16322,16331,16439,16600,16617,16762,16924,16969,
16997,17028,17134,17142,17365,17374,17432,17511,17618,17692,
17773,17783,17921,17937,18053,18064,18162,18295,18309,18394,
18467,18669,18782,18856,19098,19131,19207,19264,19336,19464,
19487,19535,19545,19712,19793,19814,19859,19934,20112,20258,
20263,20491,20581,20746,20820,20825,20885,20902,20945,20971,
20985,21063,21235,21275,21420,21437,21528,21570,21580,21593,
21666,21891,22125,22174,22238,22321,22327,22561,22616,22761,
22867,22936,22965,23487,23548,23619,23660,23829,23843,23892,
23965,24161,24202,24290,24344,24389,24436,24493,24498,24507,
24601,24640,24658,24722,24808,24995,25100,25308,25370,25586,
25733,25748,25814,25852,25982,26040,26190,26219,26319,26416,
26445,26527,26540,26587,26881,26953,26988,27029,27201,27233,
27282,27316,27419,27466,27488,27575,27580,27654,27709,27793,
28119,28300,28327,28335,28339,28360,28373,28442,28670,28731,
28867,28933,29046,29095,29188,29201,29211,29346,29407,29436,
29517,29658,29769,29781,29892,30106,30162,30228,30368,30414,
30433,30484,30655,30680,30761,30781,30958,31222,31226,31238,
31250,31262,31266,31375,31427,31435,31462,31599,31715,31741,
31895,   29,   89,  694,  825,  849, 1067, 1307, 1483, 1755,
 1858, 1963, 2202, 2414, 2661, 2690, 2750, 2812, 3022, 3147,
 3169, 3301, 3480, 3569, 3690, 3868, 3894, 3928, 3944, 4164,
 4365, 4542, 4577, 4690, 4718, 5298, 5425, 5448, 5473, 5627,
 5705, 5798, 5914, 5985, 6390, 6648, 7018, 7133, 7175, 7218,
 7387, 7546, 7551, 7588, 7719, 8026, 8230, 8462, 8524, 8596,
 8919, 9050, 9250, 9278, 9524, 9531, 9650, 9707, 9993,10129,
10237,10594,10602,10860,11150,11213,11231,11273,11290,11379,
11646,11650,12485,12491,12627,12771,13019,13116,13181,13327,
13339,13509,13793,13844,14235,14243,14403,14463,14710,14874,
15124,15213,15252,15390,15398,15566,15794,15832,15872,15904,
16014,16195,16227,16326,16337,16467,16627,17099,17226,17348,
17472,17789,18070,18091,18337,18383,18536,18697,18757,19020,
19095,19200,19252,19498,19822,19996,20241,20253,20280,20290,
20357,20414,20466,20596,20879,20894,20998,21027,21522,21706,
21734,22110,22203,22541,22598,22614,22741,22799,22853,22899,
22910,22916,23448,23464,23552,23584,23691,23711,23721,23974,
24260,24312,24415,24463,24595,24899,24960,25096,25165,25204,
25248,25402,25842,25886,26024,26054,26158,26326,26378,26937,
27021,27118,27301,27327,27559,27936,28246,28273,28555,28687,
28959,29078,29108,29118,29224,29640,29855,29926,30341,30447,
30458,30731,30739,30744,30770,30792,30809,31012,31328,31496,
31736,31746,31776,31827,31986,  792,  917, 1024, 1153, 1165,
 1266, 1393, 1568, 1767, 1994, 2074, 2081, 2760, 2782, 2889,
 2914, 3010, 3383, 3611, 3950, 4036, 4050, 4867, 5047, 5345,
 5400, 5452, 5586, 5803, 5893, 6078, 6096, 6613, 6780, 6819,
 7076, 7114, 7223, 7313, 7628, 8306, 8325, 8720, 8874, 9136,
 9177, 9344, 9548, 9805, 9851,10200,10523,10869,10949,11017,
11162,11584,11633,11680,12233,12515,12600,12724,12756,12832,
12911,12974,12995,13502,14316,14357,14483,15101,15525,15608,
15877,15895,16250,16348,16381,16608,16622,16655,16726,16796,
17050,17478,17523,17890,17990,18107,18198,18521,18878,18928,
19280,19606,20039,20134,20861,21035,21398,21558,21623,22221,
22241,22307,22344,22466,22618,22669,22713,22984,23070,23630,
24325,24988,25044,25083,25604,25687,26147,26211,26450,26625,
26715,26727,26740,27569,27621,27726,27970,28034,28186,28481,
28664,28891,28946,29014,29439,29614,29921,30028,30631,30834,
30856,31299,31337,31505,  111,  138,  463,  933, 1095, 1350,
 1436, 1462, 1982, 2025, 2510, 2732, 2740, 2772, 2900, 2906,
 3030, 3529, 3556, 3784, 3890, 3904, 3985, 4249, 5002, 5084,
 5483, 6018, 6343, 6502, 6678, 6793, 6830, 7444, 7574, 7924,
 7994, 8000, 8030, 8157, 8285, 8660, 8781, 9216, 9636, 9675,
 9954,10038,10433,10500,10876,10896,11413,11431,11536,11768,
11822,12135,12312,12358,12382,13099,13199,13492,13640,13726,
13981,14032,14622,14641,14749,15047,15364,15777,15845,15856,
16169,16581,16672,16840,16933,17149,17615,18177,18441,18709,
18723,18747,18870,19126,19169,19227,19645,19681,19808,19885,
20102,20117,20208,20396,21125,21273,21445,21565,21903,22161,
22364,22401,22698,23343,23478,23565,23765,24042,24070,24442,
24487,24815,24880,25239,25366,25417,25920,25962,25984,26121,
26441,26692,26802,27224,27479,27554,27716,27733,27949,28179,
28451,28489,28582,28655,29529,29580,29704,30058,30196,30273,
30366,30455,30863,30876,31322,31366,31732,31771,31781,31832,
  165,  201,  241,  251,  277,  538,  807,  895, 1063, 1224,
 1940, 2005, 2019, 2056, 2122, 2257, 2383, 2653, 2756, 2918,
 3799, 3926, 4196, 4235, 4260, 4536, 4628, 4714, 5245, 5516,
 5680, 5764, 5852, 6113, 6353, 6572, 6662, 6800, 7317, 7523,
 7624, 7641, 7784, 8153, 8458, 8754, 8905, 8964, 9375, 9693,
 9835, 9890, 9911, 9985,10066,10570,10590,11285,11785,11954,
12028,12129,12584,12734,12749,12785,12870,13001,13057,13334,
13398,13853,13861,14180,14615,14703,14715,14723,14844,15072,
15091,15386,15497,15505,15515,15813,15995,16368,16406,16712,
17004,17022,17498,17635,17954,18087,18333,18435,18640,18671,
18734,19160,19269,19660,19722,19863,20184,20409,20855,21005,
21155,21325,21354,21410,21472,22228,22294,22379,22529,22702,
23137,23197,23249,23312,23334,23816,23834,23930,23937,24246,
24254,24587,24740,25078,25229,25446,25554,25667,25682,25819,
26073,26421,26555,26593,26962,27338,27614,27738,27782,27790,
28061,28090,28150,28156,28236,28703,28714,29266,29714,29804,
29977,30370,30829,30884,30977,31317,31800,   44,   68,   76,
  326,  542,  801, 1081, 1172, 1240, 1421, 1551, 1594, 1632,
 1950, 2118, 2135, 2238, 2364, 2613, 2794, 2798, 2880, 2982,
 3126, 3204, 3533, 3706, 3717, 3730, 3742, 4189, 4254, 4421,
 4544, 4665, 4724, 4843, 4886, 5008, 5071, 5116, 5235, 5285,
 5338, 5541, 5638, 5859, 5879, 5908, 5983, 6034, 6082, 6552,
 6669, 6684, 6731, 6809, 7157, 7230, 7337, 7344, 7936, 7943,
 8034, 8068, 8142, 8355, 8365, 8386, 8392, 8487, 8567, 8664,
 8889, 9073, 9169, 9174, 9187, 9226, 9246, 9299, 9813,10001,
10090,10123,10265,10480,10582,10611,10790,10851,11004,11013,
11179,11268,11520,11747,11817,11927,12252,12370,12450,12625,
12740,13174,13349,13547,13644,13716,13760,13825,13879,13890,
13965,14094,14302,14328,14800,14824,14851,14985,15084,15139,
15222,15491,15630,15744,15767,15780,15841,15944,16663,16755,
16788,16826,16870,16999,17131,17350,17396,17504,18004,18154,
18253,18316,18360,18378,18402,18655,18838,18874,18898,19152,
19237,19436,19512,19877,19982,20123,20196,20516,20636,20653,
20680,20859,21341,21361,21384,21460,21703,21802,21973,21999,
22142,22341,22391,22783,22788,22819,22876,23089,23305,23351,
23425,23899,24050,24108,24112,24330,24591,24642,24733,25159,
25194,25379,25630,25700,25972,26221,26239,26391,26464,26766,
26898,26911,26947,27238,27308,27409,27858,28115,28351,28420,
28616,28632,28659,28838,28842,28876,28951,29011,29315,29341,
29432,29633,29669,29679,29690,29903,30022,30110,30145,30158,
30426,30796,30880,30967,31041,31114,31202,31593,31630,   33,
   40,   54,  125,  299,  530,  637,  865,  910, 1570, 1581,
 1836, 2070, 2234, 2467, 2544, 2970, 3079, 3134, 3219, 3295,
 3426, 3469, 3478, 3596, 4518, 4757, 5065, 5124, 5250, 5403,
 6000, 6066, 6396, 7070, 7179, 7297, 7518, 7704, 7812, 8212,
 8543, 9464, 9509, 9518, 9664, 9869,10305,10336,10415,10462,
10711,11548,11638,11865,11966,12230,12385,12535,12553,12884,
13071,13481,13573,13884,14490,14535,14625,14665,14739,15949,
16044,16083,16255,16268,16412,16544,16860,16912,17166,17584,
17603,17666,17709,17822,17941,18099,18111,18473,18823,18911,
19402,19745,19908,20023,20032,20043,20178,20384,20695,20929,
21144,21284,21452,21946,21990,22730,22749,23063,23179,23242,
23298,23318,24077,24117,24513,24529,24534,24598,24648,24666,
24818,25375,25456,25481,25634,26502,26533,26617,26652,26711,
26893,27187,27208,27322,27334,27506,28190,28507,28708,28744,
28869,28913,28963,29025,29112,29618,30296,30399,30473,30757,
31216,31343,31381,31390,31695,31761,31879,  103,  473,  498,
  622,  627,  781,  968, 1089, 1176, 1412, 1495, 1650, 1870,
 1992, 2387, 2626, 2825, 3372, 3421, 3502, 3776, 3879, 3974,
 4275, 4308, 4316, 4338, 4559, 4767, 5186, 5412, 5464, 5694,
 6007, 6030, 6165, 6250, 6401, 6480, 6531, 6623, 6735, 6755,
 7112, 7162, 7243, 7380, 7389, 7596, 7825, 8124, 8257, 8273,
 8495, 8763, 8899, 8937, 9104, 9434, 9862, 9915,10015,10020,
10472,10483,10511,10560,10830,10839,11264,11278,11335,11384,
11609,11780,11794,11918,11947,12114,12204,12289,12403,12519,
12619,12629,13275,13344,13707,13875,14021,14314,14324,14541,
14618,14751,14785,15126,15232,15378,15479,15990,16009,16210,
16259,16346,16437,16550,16575,16900,17180,17430,17738,17805,
17912,18066,18582,18695,18751,18842,18924,18954,19109,19477,
19517,19540,19700,19780,20018,20266,20392,20743,20801,21022,
21723,21811,21821,21839,21965,22020,22236,22692,22766,22995,
23095,23162,23237,23276,23485,23770,23905,24046,24083,24192,
24225,24830,25067,25121,25278,25538,25615,25784,25872,25947,
25968,26345,26376,26580,26985,27352,27396,27564,27660,27675,
27702,27904,28196,28267,28561,28737,29021,29088,29199,29377,
29574,29606,29848,29886,30012,30225,30409,30451,30980,31121,
31422,31645,31709,31753,31798,31846,  140,  291,  407,  476,
  536,  605,  643,  651,  696,  771, 1043, 1069, 1195, 1208,
 1251, 1313, 1382, 1477, 1481, 1501, 1615, 1794, 1820, 1874,
 1894, 2032, 2040, 2115, 2164, 2320, 2392, 2523, 2530, 2597,
 2920, 3033, 3151, 3167, 3386, 3408, 3429, 3704, 3851, 3912,
 3958, 4170, 4183, 4258, 4323, 4434, 4496, 4550, 4647, 4655,
 4679, 4966, 5016, 5087, 5216, 5304, 5328, 5383, 5481, 5492,
 5581, 5631, 5653, 5726, 6104, 6183, 6190, 6215, 6279, 6345,
 6459, 6772, 6833, 6849, 7016, 7255, 7420, 7532, 7557, 7586,
 7775, 7846, 7909, 7928, 7946, 7989, 8012, 8085, 8368, 8415,
 8455, 8532, 8671, 8691, 8962, 8988, 9036, 9043, 9085, 9342,
 9414, 9454, 9493, 9550, 9639, 9652, 9926, 9942, 9989,10443,
10489,10502,10515,10586,10619,10862,10962,10997,11037,11103,
11182,11201,11260,11360,11463,11531,11620,11683,11751,11857,
11982,12123,12338,12417,12602,12634,12703,12730,12760,12872,
12970,13126,13138,13219,13458,13476,13504,13539,13554,13582,
13656,13678,13935,13973,14087,14104,14141,14170,14603,14611,
14630,14639,14691,14835,14861,14870,14981,15011,15070,15118,
15131,15442,15486,15656,15773,15879,15906,16030,16173,16193,
16240,16532,16778,16834,16849,16951,16984,17016,17129,17252,
17390,17436,17483,17496,17532,17536,17766,17935,17952,18173,
18269,18287,18371,18547,18589,18701,18766,18787,19024,19039,
19202,19267,19330,19448,19688,19736,19865,20081,20093,20470,
20495,20499,20556,20567,20614,20619,20641,20703,20763,20783,
20795,20865,20947,21039,21201,21223,21588,21642,21657,21736,
21824,21921,21939,21958,22092,22177,22246,22296,22362,22417,
22482,22578,22715,22929,22950,23000,23008,23072,23080,23206,
23251,23327,23345,23569,23686,23820,23836,23935,23941,24017,
24088,24200,24293,24355,24421,24489,24730,24862,25004,25028,
25109,25294,25368,25465,25545,25552,25691,25772,25787,25847,
25933,25950,25995,26180,26202,26304,26359,26443,26789,26822,
26840,26850,26976,27192,27196,27477,27496,27536,27652,27683,
27694,27724,27749,27785,27797,27847,27934,27953,28100,28356,
28447,28571,28883,29052,29081,29116,29134,29195,29229,29255,
29288,29322,29333,29399,29484,29648,29685,29795,30100,30185,
30198,30238,30246,30359,30383,30660,30734,30750,30806,30970,
31105,31110,31212,31253,31386,31538,31650,31701,31744,32003,
   35,  120,  256,  288,  321,  354,  441,  456,  488,  544,
  582,  786,  809,  884,  893,  900,  907,  915,  989,  997,
 1037, 1053, 1205, 1305, 1318, 1407, 1447, 1454, 1561, 1596,
 1608, 1618, 1624, 1659, 1734, 1738, 1746, 1846, 1952, 2021,
 2151, 2159, 2220, 2264, 2277, 2358, 2376, 2398, 2437, 2508,
 2572, 2624, 2704, 2745, 2786, 2829, 2835, 2848, 2911, 2947,
 3000, 3014, 3077, 3096, 3115, 3132, 3156, 3182, 3187, 3266,
 3299, 3352, 3476, 3507, 3554, 3581, 3791, 3842, 3866, 3987,
 4000, 4078, 4101, 4107, 4112, 4128, 4162, 4285, 4328, 4333,
 4423, 4431, 4505, 4534, 4570, 4579, 4738, 4828, 4865, 5045,
 5067, 5090, 5129, 5141, 5203, 5230, 5340, 5386, 5405, 5456,
 5485, 5510, 5610, 5625, 5696, 5776, 5850, 5854, 5906, 5924,
 5952, 5977, 6002, 6062, 6230, 6263, 6284, 6368, 6405, 6417,
 6438, 6462, 6490, 6584, 6628, 6676, 6760, 6837, 6863, 6886,
 6939, 6956, 6979, 7003, 7046, 7110, 7116, 7164, 7177, 7315,
 7333, 7442, 7457, 7544, 7607, 7616, 7643, 7706, 7728, 7759,
 7770, 7793, 7886, 7905, 8024, 8070, 8075, 8106, 8147, 8150,
 8171, 8197, 8320, 8357, 8381, 8400, 8482, 8600, 8743, 8756,
 8779, 8801, 8876, 8885, 8907, 9062, 9093, 9114, 9189, 9218,
 9232, 9351, 9373, 9432, 9468, 9485, 9504, 9514, 9520, 9528,
 9556, 9628, 9634, 9878,10049,10075,10121,10139,10148,10187,
10219,10317,10385,10422,10438,10468,10475,10485,10622,10645,
10687,10787,10834,10906,10914,10947,10954,10993,11045,11082,
11160,11177,11211,11348,11443,11474,11479,11580,11778,11804,
11833,11852,11990,12002,12017,12102,12105,12171,12228,12448,
12453,12483,12522,12527,12546,12571,12590,12606,12696,12769,
12813,12876,12918,12965,13009,13022,13191,13208,13252,13282,
13306,13325,13357,13371,13379,13396,13490,13520,13558,13646,
13855,13960,14057,14078,14100,14112,14178,14217,14231,14266,
14337,14353,14444,14453,14465,14503,14566,14673,14911,14919,
14922,15008,15080,15089,15097,15182,15224,15362,15403,15407,
15428,15433,15458,15520,15628,15639,15660,15669,15699,15765,
15805,15884,15942,15961,16057,16089,16129,16167,16217,16229,
16476,16525,16546,16569,16610,16646,16661,16674,16752,16783,
16843,16926,16966,17001,17011,17096,17107,17114,17138,17147,
17186,17231,17346,17361,17417,17441,17599,17679,17707,17751,
17754,17817,17888,17892,17950,17964,17973,17977,18022,18057,
18118,18266,18307,18321,18341,18385,18433,18452,18469,18483,
18491,18637,18745,18760,18776,18821,18930,18964,19054,19081,
19100,19114,19133,19167,19239,19249,19282,19297,19365,19416,
19532,19647,19718,19741,19783,19787,19810,19835,19856,19896,
19988,20009,20012,20132,20161,20190,20227,20251,20255,20288,
20311,20430,20474,20629,20751,20789,20891,20931,21029,21033,
21061,21068,21157,21181,21211,21233,21323,21344,21369,21380,
21408,21458,21507,21519,21526,21556,21583,21614,21625,21739,
21813,21830,21859,21907,21963,22084,22128,22144,22232,22300,
22310,22325,22473,22543,22552,22564,22587,22600,22622,22763,
22851,22863,23129,23164,23171,23183,23349,23381,23455,23473,
23506,23652,23668,23689,23719,23723,23731,23752,23780,23848,
23873,24022,24058,24141,24148,24285,24316,24351,24426,24440,
24461,24470,24500,24579,24608,24674,24702,24788,24795,24820,
24878,24971,25034,25094,25098,25106,25157,25199,25214,25252,
25311,25415,25425,25448,25573,25620,25652,25669,25702,25817,
25857,25877,26117,26213,26223,26254,26329,26337,26386,26409,
26452,26512,26545,26623,26627,26660,26731,26749,26781,26806,
26913,26928,26935,26969,26990,27025,27036,27076,27081,27136,
27294,27404,27721,27771,27802,27856,27865,27896,27968,28002,
28070,28092,28136,28244,28271,28277,28312,28322,28365,28496,
28532,28537,28566,28620,28802,28817,28835,28865,28908,28961,
29000,29048,29283,29313,29339,29350,29453,29470,29598,29635,
29642,29653,29873,29894,29960,29964,29969,29979,30001,30008,
30042,30074,30091,30108,30164,30209,30243,30287,30306,30375,
30442,30531,30653,30677,30746,30754,30801,30814,30832,30839,
30878,30955,30965,30975,31014,31052,31128,31176,31241,31335,
31412,31498,31546,31566,31621,31642,31711,31724,31779,31830,
31875,31884,31889,31957,31980,32017,  136,  660,  789, 1167,
 2076, 2253, 2347, 2546, 3145, 3227, 3392, 3657, 3708, 3753,
 3762, 4244, 4869, 4945, 5029, 5049, 5114, 5729, 6148, 6412,
 6550, 6942, 6996, 7216, 7400, 8666, 8836, 8951, 9122, 9480,
 9922,10033,10627,11040,11152,11244,11565,11600,11648,11868,
12154,12517,12787,12937,13085,13414,13654,13790,13931,14106,
14330,15128,15601,15858,15870,15951,16208,17088,17317,17354,
17414,17556,18400,18494,18711,18948,19027,19598,19728,20021,
20041,20269,20969,21246,21279,22332,22605,23086,23133,23244,
23300,23386,24888,24975,25206,25373,26056,26177,26380,26427,
26517,26699,27099,27411,27424,27552,27571,27731,27947,28265,
28486,29127,29234,29395,29495,30188,30501,30536,30674,31616,
31748,31769,  386,  683,  912, 1185, 1473, 1805, 2137, 2561,
 2610, 3346, 3471, 3497, 3870, 3962, 4277, 4802, 5082, 5098,
 5267, 5720, 6012, 6960, 7065, 7202, 7360, 8509, 8526, 8614,
 8749, 9354, 9552, 9562, 9917,10198,10370,10448,10864,10951,
11035,11362,11398,11815,11956,12319,12881,12956,13121,13376,
14167,14308,14600,14667,14753,14998,15014,15493,15645,15947,
15993,16197,16271,16620,16639,16990,17620,17711,17860,18314,
19118,19162,19229,19235,20261,20292,21000,21655,21761,21786,
21971,22087,22383,22496,22786,22901,23140,23446,23809,23939,
24081,24256,24335,24882,24897,24997,25211,25632,25888,26343,
26949,27650,27740,28251,28712,29330,29601,29629,30271,30471,
30818,31066,31377,31524,31898,31921,31934,   37,   42,   83,
  149,  199,  203,  223,  286,  308,  401,  409,  437,  509,
  516,  540,  549,  619,  624,  645,  678,  840,  847,  856,
  879,  919,  931, 1022, 1027, 1097, 1117, 1155, 1200, 1211,
 1248, 1253, 1275, 1294, 1301, 1352, 1371, 1460, 1549, 1556,
 1579, 1621, 1641, 1697, 1765, 1776, 1782, 1797, 1854, 1948,
 2008, 2016, 2051, 2058, 2113, 2169, 2188, 2229, 2259, 2325,
 2340, 2366, 2385, 2410, 2440, 2447, 2462, 2465, 2501, 2535,
 2608, 2618, 2622, 2698, 2707, 2780, 2839, 2908, 2950, 2984,
 3045, 3118, 3124, 3149, 3211, 3303, 3357, 3394, 3424, 3510,
 3521, 3542, 3558, 3572, 3590, 3594, 3666, 3696, 3756, 3797,
 3812, 3853, 3861, 3874, 3907, 3917, 3931, 3993, 4038, 4088,
 4152, 4187, 4262, 4268, 4310, 4416, 4442, 4481, 4491, 4561,
 4618, 4667, 4703, 4722, 4733, 4744, 4748, 4765, 4833, 4849,
 4862, 4901, 4908, 4961, 5006, 5014, 5069, 5108, 5143, 5224,
 5270, 5296, 5310, 5314, 5380, 5591, 5613, 5619, 5634, 5796,
 5832, 5836, 5857, 5862, 5865, 5881, 5898, 5901, 5959, 5970,
 5981, 6005, 6016, 6036, 6064, 6277, 6294, 6300, 6337, 6347,
 6351, 6373, 6425, 6428, 6444, 6451, 6466, 6497, 6554, 6574,
 6625, 6753, 6774, 6795, 6859, 6932, 6974, 6981, 7035, 7048,
 7072, 7108, 7184, 7190, 7213, 7311, 7319, 7335, 7397, 7413,
 7428, 7440, 7459, 7462, 7497, 7541, 7559, 7565, 7610, 7614,
 7683, 7773, 7828, 7902, 7916, 7922, 8008, 8028, 8083, 8088,
 8103, 8118, 8130, 8168, 8328, 8370, 8378, 8384, 8397, 8410,
 8418, 8460, 8493, 8522, 8537, 8545, 8669, 8699, 8705, 8732,
 8776, 8785, 8789, 8833, 8847, 8866, 8960, 9045, 9064, 9079,
 9109, 9134, 9140, 9224, 9309, 9340, 9377, 9457, 9488, 9512,
 9541, 9614, 9631, 9641, 9666, 9688, 9849, 9853, 9893, 9902,
 9908, 9952, 9991,10003,10010,10022,10078,10150,10221,10274,
10326,10333,10417,10440,10446,10492,10513,10572,10588,10592,
10599,10649,10699,10817,10871,10885,10900,10908,10965,10999,
11029,11047,11249,11266,11276,11301,11333,11367,11401,11449,
11486,11522,11534,11546,11570,11582,11796,11807,11820,11847,
11863,11877,11924,11933,12022,12030,12131,12144,12152,12163,
12168,12186,12238,12244,12301,12349,12365,12412,12439,12499,
12582,12586,12611,12617,12636,12673,12716,12754,12834,12886,
12890,12903,12984,13011,13104,13118,13124,13140,13169,13256,
13260,13323,13342,13385,13446,13478,13483,13495,13528,13545,
13602,13702,13748,13757,13786,13851,13923,13967,14030,14034,
14092,14120,14148,14182,14241,14245,14255,14263,14289,14300,
14319,14347,14355,14405,14467,14485,14496,14620,14708,14712,
14747,14847,14853,14987,14994,15019,15035,15064,15067,15086,
15099,15107,15120,15141,15219,15245,15325,15384,15388,15461,
15499,15558,15616,15775,15782,15827,15850,15875,15881,15893,
15899,15909,15988,16007,16027,16054,16161,16171,16225,16252,
16288,16324,16328,16379,16394,16397,16404,16465,16486,16530,
16536,16552,16615,16624,16750,16757,16908,16960,17006,17045,
17048,17056,17102,17120,17171,17178,17210,17219,17229,17285,
17381,17398,17438,17493,17513,17550,17569,17586,17682,17716,
17722,17733,17770,17787,17879,17885,17987,17994,17999,18011,
18059,18089,18102,18139,18274,18325,18339,18350,18376,18475,
18597,18717,18729,18742,18749,18769,18819,18825,18840,18849,
18872,18876,18880,18883,19049,19059,19079,19086,19093,19107,
19164,19275,19289,19328,19338,19404,19409,19510,19515,19586,
19623,19662,19698,19747,19806,19824,19843,19869,19883,19923,
19984,19990,20025,20072,20107,20121,20168,20187,20198,20243,
20248,20296,20318,20463,20493,20546,20553,20565,20605,20643,
20675,20705,20771,20780,20785,20792,20818,20823,20853,20857,
20863,20881,20900,20957,21003,21127,21171,21186,21271,21331,
21382,21389,21405,21418,21428,21447,21456,21505,21541,21591,
21659,21721,21725,21742,21752,21791,21826,21854,21988,22033,
22123,22205,22219,22287,22329,22339,22346,22357,22377,22388,
22393,22435,22476,22612,22620,22657,22679,22696,22700,22705,
22732,22774,22821,22855,22874,22913,22931,22943,22952,23077,
23168,23303,23368,23393,23450,23480,23512,23533,23557,23563,
23575,23621,23632,23675,23693,23772,23841,23870,23901,23928,
23932,23967,24038,24044,24052,24099,24106,24110,24145,24153,
24198,24204,24219,24357,24408,24431,24454,24584,24593,24615,
24650,24656,24709,24713,24825,24853,24860,24892,24909,25062,
25076,25117,25123,25154,25218,25231,25241,25303,25358,25364,
25377,25419,25451,25543,25578,25584,25588,25600,25662,25689,
25752,25763,25840,25869,25939,25974,26004,26014,26026,26037,
26042,26052,26066,26123,26171,26268,26274,26334,26351,26374,
26383,26457,26498,26505,26585,26591,26595,26646,26752,26760,
26795,26800,26824,26830,26964,27008,27095,27108,27111,27125,
27150,27175,27230,27236,27271,27280,27306,27320,27325,27350,
27364,27390,27402,27456,27475,27521,27577,27608,27662,27718,
27780,27872,27889,27951,27959,28042,28067,28110,28133,28169,
28177,28188,28231,28418,28479,28483,28499,28509,28526,28540,
28574,28580,28630,28657,28662,28682,28694,28735,28742,28815,
28827,28840,28844,28858,28915,28944,28949,28953,29190,29249,
29263,29275,29285,29296,29324,29404,29430,29473,29500,29608,
29638,29674,29699,29726,29730,29761,29774,29901,29912,29955,
29974,29985,29998,30035,30067,30223,30230,30236,30248,30262,
30364,30372,30407,30412,30445,30493,30540,30580,30586,30596,
30624,30657,30737,30768,30871,30934,30972,30995,31000,31033,
31043,31059,31108,31181,31246,31268,31326,31341,31348,31360,
31431,31489,31501,31591,31595,31610,31633,31647,31734,31751,
31756,31774,31790,31793,31805,31891,31931,31959,32014,32027,
    0,   15,   22,   56,   66,   70,   74,   91,  101,  122,
  127,  152,  158,  196,  220,  238,  243,  253,  304,  310,
  336,  404,  418,  424,  461,  465,  471,  493,  522,  525,
  532,  590,  613,  640,  675,  698,  705,  711,  768,  778,
  794,  799,  823,  827,  859,  863,  873,  882,  922,  928,
  966, 1005, 1011, 1035, 1045, 1079, 1169, 1174, 1187, 1222,
 1233, 1278, 1297, 1355, 1384, 1409, 1434, 1451, 1456, 1475,
 1479, 1508, 1537, 1566, 1587, 1592, 1610, 1630, 1635, 1656,
 1676, 1684, 1691, 1732, 1751, 1872, 1880, 1887, 1935, 1954,
 1961, 1965, 1980, 1984, 1999, 2003, 2023, 2030, 2034, 2054,
 2083, 2120, 2124, 2130, 2162, 2179, 2204, 2236, 2241, 2374,
 2390, 2403, 2453, 2458, 2496, 2520, 2525, 2528, 2586, 2599,
 2615, 2635, 2695, 2730, 2734, 2742, 2748, 2762, 2767, 2784,
 2796, 2820, 2833, 2883, 2894, 2916, 2944, 2962, 2966, 2997,
 3003, 3037, 3042, 3089, 3094, 3121, 3129, 3172, 3184, 3198,
 3208, 3275, 3290, 3297, 3332, 3354, 3370, 3406, 3413, 3417,
 3456, 3463, 3485, 3518, 3527, 3531, 3552, 3576, 3602, 3652,
 3685, 3692, 3728, 3759, 3780, 3805, 3864, 3892, 3924, 3939,
 3965, 4002, 4048, 4073, 4091, 4095, 4121, 4126, 4134, 4148,
 4160, 4168, 4172, 4175, 4198, 4233, 4252, 4256, 4273, 4296,
 4331, 4336, 4372, 4383, 4419, 4429, 4438, 4484, 4494, 4539,
 4548, 4567, 4644, 4649, 4663, 4692, 4700, 4706, 4712, 4818,
 4830, 4845, 4851, 4881, 4888, 4911, 4919, 4928, 4954, 4964,
 4997, 5000, 5018, 5063, 5126, 5134, 5196, 5227, 5243, 5248,
 5287, 5323, 5331, 5343, 5376, 5392, 5410, 5430, 5445, 5450,
 5468, 5471, 5475, 5494, 5499, 5539, 5588, 5599, 5607, 5616,
 5629, 5646, 5650, 5682, 5699, 5712, 5718, 5723, 5762, 5769,
 5787, 5848, 5868, 5895, 5965, 6009, 6076, 6080, 6111, 6167,
 6178, 6185, 6188, 6217, 6239, 6243, 6261, 6286, 6291, 6308,
 6355, 6388, 6398, 6403, 6415, 6440, 6457, 6473, 6533, 6557,
 6577, 6586, 6611, 6615, 6639, 6680, 6686, 6728, 6733, 6758,
 6785, 6791, 6827, 6846, 6852, 6865, 6883, 6913, 6929, 6954,
 6990, 7005, 7014, 7027, 7032, 7060, 7129, 7139, 7160, 7193,
 7200, 7233, 7245, 7259, 7328, 7342, 7347, 7454, 7500, 7516,
 7548, 7554, 7562, 7569, 7594, 7599, 7622, 7626, 7639, 7686,
 7697, 7701, 7721, 7764, 7768, 7795, 7873, 7907, 7934, 7941,
 7970, 7974, 7981, 7996, 8002, 8014, 8032, 8036, 8073, 8111,
 8122, 8140, 8155, 8159, 8184, 8210, 8214, 8271, 8283, 8287,
 8308, 8337, 8373, 8394, 8413, 8451, 8470, 8485, 8504, 8516,
 8534, 8554, 8580, 8658, 8681, 8689, 8740, 8752, 8765, 8804,
 8839, 8842, 8895, 8903, 8910, 8914, 8927, 8953, 8966, 8975,
 8986, 8991, 9048, 9070, 9112, 9126, 9131, 9164, 9171, 9244,
 9248, 9252, 9268, 9274, 9281, 9291, 9346, 9367, 9412, 9420,
 9428, 9451, 9477, 9507, 9522, 9526, 9572, 9600, 9617, 9654,
 9683, 9691, 9727, 9737, 9757, 9802, 9815, 9838, 9864, 9871,
 9888, 9913, 9933, 9936, 9940, 9945, 9987,10017,10059,10088,
10092,10097,10116,10190,10205,10217,10228,10235,10239,10244,
10259,10263,10295,10303,10338,10404,10424,10460,10470,10478,
10504,10521,10565,10568,10579,10584,10656,10690,10719,10725,
10767,10795,10798,10827,10858,10867,10874,10894,10945,10975,
10995,11002,11006,11015,11024,11070,11079,11090,11095,11148,
11164,11172,11203,11225,11235,11254,11298,11406,11411,11421,
11433,11438,11483,11538,11543,11562,11567,11574,11578,11607,
11617,11644,11652,11663,11668,11720,11744,11749,11787,11827,
11849,11871,11904,11908,11915,11929,11968,11974,12005,12033,
12066,12112,12137,12141,12176,12189,12201,12206,12217,12235,
12241,12249,12310,12341,12372,12376,12387,12401,12446,12487,
12508,12513,12544,12598,12614,12682,12687,12722,12732,12742,
12747,12751,12767,12815,12837,12868,12900,12920,12950,12972,
12987,12990,12993,13014,13097,13108,13146,13155,13159,13172,
13189,13196,13210,13216,13268,13272,13280,13293,13359,13405,
13441,13456,13469,13500,13506,13512,13560,13584,13642,13680,
13710,13714,13718,13724,13728,13762,13771,13779,13783,13796,
13827,13858,13863,13877,13882,13926,13933,13946,13958,14023,
14037,14060,14080,14084,14089,14130,14143,14176,14220,14233,
14238,14258,14326,14345,14365,14401,14416,14441,14461,14478,
14488,14543,14553,14613,14627,14649,14663,14686,14697,14700,
14705,14717,14721,14725,14741,14755,14787,14798,14838,14867,
14885,14924,14983,15002,15006,15022,15025,15050,15074,15094,
15122,15135,15208,15234,15248,15274,15303,15360,15380,15393,
15396,15421,15431,15445,15450,15455,15471,15475,15488,15510,
15513,15522,15561,15564,15568,15606,15610,15673,15676,15694,
15747,15785,15789,15811,15824,15843,15889,15954,15963,15984,
16012,16022,16039,16046,16094,16150,16164,16191,16243,16257,
16263,16279,16291,16350,16370,16375,16414,16426,16458,16522,
16527,16578,16583,16602,16632,16644,16653,16666,16706,16710,
16731,16747,16765,16785,16790,16804,16821,16828,16851,16862,
16868,16917,16931,16935,16964,16972,16992,17009,17024,17031,
17112,17140,17145,17282,17297,17309,17325,17328,17352,17367,
17384,17388,17405,17425,17434,17481,17506,17527,17534,17565,
17592,17611,17637,17677,17702,17730,17740,17746,17764,17793,
17799,17814,17825,17863,17882,17968,17971,18002,18050,18068,
18097,18109,18120,18136,18152,18175,18189,18206,18212,18255,
18271,18285,18297,18305,18319,18335,18358,18363,18373,18392,
18438,18455,18471,18515,18540,18545,18580,18587,18635,18642,
18673,18677,18693,18699,18714,18726,18753,18764,18784,18816,
18844,18852,18896,18913,19022,19052,19124,19129,19143,19150,
19158,19171,19222,19261,19294,19304,19312,19332,19346,19397,
19400,19424,19438,19446,19450,19457,19479,19493,19500,19551,
19603,19611,19626,19635,19653,19657,19666,19675,19720,19734,
19739,19750,19800,19812,19872,19887,19903,19906,19918,20030,
20045,20053,20067,20086,20090,20129,20164,20171,20206,20230,
20275,20305,20367,20386,20394,20402,20406,20411,20417,20432,
20477,20501,20508,20518,20562,20569,20574,20617,20634,20638,
20647,20650,20678,20682,20741,20774,20804,20850,20889,20940,
20960,20991,21007,21025,21037,21070,21076,21136,21142,21146,
21167,21174,21204,21209,21239,21243,21251,21257,21277,21282,
21286,21321,21352,21356,21371,21413,21440,21538,21567,21578,
21616,21701,21709,21745,21777,21794,21800,21804,21819,21837,
21844,21861,21897,21905,21910,21919,21942,21948,21956,21960,
21980,22007,22025,22048,22081,22116,22120,22159,22168,22194,
22214,22230,22234,22298,22318,22367,22374,22381,22399,22403,
22415,22469,22484,22515,22527,22546,22624,22686,22690,22711,
22725,22728,22747,22754,22781,22794,22858,22865,22934,22960,
22968,22982,22993,22998,23002,23061,23082,23098,23101,23118,
23148,23155,23181,23203,23235,23246,23260,23266,23283,23296,
23307,23337,23390,23432,23462,23470,23508,23515,23521,23524,
23546,23550,23554,23571,23590,23635,23658,23684,23696,23728,
23734,23759,23818,23832,23838,23856,23863,23894,23946,23970,
24003,24015,24072,24075,24095,24103,24115,24150,24212,24227,
24252,24258,24282,24319,24327,24348,24413,24434,24467,24496,
24505,24515,24524,24576,24589,24621,24630,24644,24664,24672,
24677,24684,24694,24724,24728,24735,24738,24773,24802,24810,
24828,24845,24873,24912,24969,24982,24985,24990,25024,25031,
25042,25114,25170,25191,25202,25246,25250,25262,25280,25283,
25318,25389,25400,25430,25435,25458,25463,25467,25479,25483,
25488,25492,25540,25547,25563,25693,25698,25768,25789,25795,
25798,25805,25828,25831,25837,25936,25942,25952,25970,25993,
26001,26007,26045,26058,26071,26085,26114,26119,26149,26156,
26209,26226,26241,26317,26331,26361,26366,26396,26423,26438,
26448,26462,26514,26531,26549,26563,26599,26605,26713,26729,
26763,26768,26774,26804,26813,26827,26835,26848,26854,26886,
26895,26900,26909,26925,26930,26939,27002,27011,27034,27074,
27163,27170,27185,27222,27276,27297,27331,27336,27340,27346,
27358,27370,27382,27398,27407,27481,27504,27566,27585,27612,
27619,27657,27677,27685,27692,27700,27706,27736,27752,27795,
27861,27881,27902,27920,27938,27955,27966,27979,27983,27991,
28000,28036,28098,28104,28107,28117,28123,28154,28166,28198,
28238,28241,28248,28269,28275,28280,28319,28331,28354,28445,
28449,28454,28476,28529,28535,28563,28569,28577,28618,28627,
28685,28697,28706,28710,28746,28749,28805,28871,28881,28931,
28957,28966,29016,29023,29039,29044,29054,29086,29098,29102,
29110,29114,29197,29219,29222,29227,29252,29258,29269,29311,
29344,29348,29379,29385,29397,29434,29464,29491,29510,29520,
29527,29585,29593,29616,29650,29660,29671,29706,29716,29723,
29802,29813,29823,29837,29859,29868,29880,29888,29958,29982,
29989,30010,30020,30025,30048,30063,30076,30088,30117,30154,
30275,30289,30294,30304,30352,30361,30386,30397,30424,30449,
30477,30490,30529,30534,30548,30570,30583,30593,30612,30629,
30651,30752,30759,30765,30794,30799,30812,30827,30837,30854,
30858,30882,30940,30982,31016,31039,31056,31078,31112,31116,
31119,31140,31154,31200,31214,31218,31228,31260,31264,31315,
31352,31357,31363,31370,31383,31388,31396,31415,31448,31511,
31515,31521,31530,31571,31618,31628,31636,31685,31719,31727,
31796,31817,31844,31881,31951,31969,31977,32005,32033,
0};
static const gx_device_halftone_resource_t res_0 = {
    "Black", 3, 167, 167, 256, levels_0, bit_data_0, 2
};

/* StochasticDefault.Cyan */
static const unsigned int levels_1[] = {
    0,   59,  117,  171,  227,  288,  348,  407,  466,  526,
  584,  641,  698,  755,  818,  881,  934,  988, 1043, 1099,
 1152, 1205, 1260, 1314, 1366, 1417, 1469, 1520, 1579, 1641,
 1704, 1764, 1817, 1869, 1918, 1968, 2026, 2086, 2151, 2215,
 2277, 2331, 2380, 2430, 2480, 2532, 2594, 2654, 2712, 2770,
 2830, 2882, 2932, 2983, 3034, 3094, 3164, 3230, 3298, 3376,
 3431, 3480, 3532, 3586, 3638, 3689, 3752, 3832, 3887, 3944,
 4006, 4064, 4111, 4158, 4245, 4330, 4414, 4491, 4545, 4599,
 4671, 4789, 4900, 4955, 4997, 5039, 5081, 5123, 5171, 5225,
 5364, 5454, 5517, 5575, 5633, 5692, 5788, 5940, 6034, 6083,
 6132, 6184, 6236, 6296, 6358, 6426, 6510, 6594, 6663, 6780,
 6821, 6861, 6899, 6931, 6964, 6996, 7028, 7061, 7093, 7144,
 7216, 7515, 7687, 7806, 7881, 7955, 8016, 8066, 8157, 8239,
 8292, 8360, 8440, 8524, 8886, 9045, 9207, 9263, 9308, 9338,
 9367, 9396, 9428, 9461, 9494, 9537, 9599,10003,10129,10247,
10352,10431,10497,10574,10649,10723,10803,10884,11016,11231,
11300,11356,11409,11460,11543,11933,11988,12043,12099,12155,
12211,12276,12359,12442,12525,13024,13104,13162,13211,13264,
13320,13418,13650,13769,13889,13986,14047,14103,14159,14214,
14382,14647,14822,15022,15162,15268,15375,15485,15612,15750,
15836,15940,16051,16290,16421,16533,16657,16794,17063,17146,
17232,17303,17353,17410,17484,17558,18253,18697,18798,18894,
19014,19326,19441,19559,20083,20163,20241,20304,20462,20814,
20915,20979,21046,21117,21214,21316,21452,22095,22230,22332,
22432,22625,23011,23235,23384,23540,23707,23949,24107,24306,
24670,25326,25442,25557,26440,27889,
0};
static const unsigned short bit_data_1[] = {
   16,   81,  682,  742, 3007, 3341, 3413, 3888, 5002, 5635,
 5795, 5864, 6296, 8002, 8861, 8886, 9412, 9550,10091,11199,
11420,11873,12222,12889,13128,13719,14735,15135,15851,16761,
16917,17505,17829,17944,18500,19136,19816,19875,20889,20939,
21448,21966,22772,23329,24238,24934,25018,25288,25563,25847,
27353,27654,27899,28741,28761,29412,30254,31830,31924,  263,
  415, 1084, 1671, 2174, 2470, 2793, 3472, 3678, 4511, 4743,
 6587, 6814, 7105, 8181, 8341, 8413, 9066, 9100,10387,12237,
12335,13170,13263,13287,13886,13929,14723,14830,15176,16032,
16205,18385,18825,19473,19510,20185,20783,21371,21405,22623,
22878,23126,23247,23357,23378,25610,25743,25769,26075,26404,
27960,28578,29197,29451,29616,30812,30854,  620, 1105, 1308,
 1438, 2354, 2530, 3999, 4524, 4629, 4726, 5654, 6385, 6457,
 6497, 6795, 7500, 7512, 8511, 8926, 9341,10978,11251,11790,
12102,13209,14906,15379,16000,16321,16470,17585,17706,18149,
18836,18870,19748,20421,21525,21696,24066,24669,25454,27009,
27024,27332,27692,27730,28446,29093,29136,30201,30692,31413,
31705,    9,  855, 1608, 1945, 2194, 2698, 3020, 3570, 3716,
 5378, 6865, 7401, 8098, 8206, 9715, 9804, 9875,10515,10616,
10726,12003,12920,13382,13829,14426,14478,15223,15397,16212,
16522,17025,17329,18186,18591,20301,21159,21421,22019,22535,
22891,23040,23340,23369,23480,24226,24346,25278,25736,26549,
26993,27092,29059,29465,30344,31205,31358,  442, 2224, 2784,
 2920, 3353, 4279, 4452, 4737, 5071, 5330, 5783, 5801, 6258,
 7047, 7142, 7187, 8803,10275,10526,11014,11378,11459,11627,
11926,11988,13088,13345,13605,13756,15862,16615,16650,16732,
16860,17157,17740,18168,18846,19909,21029,21397,22144,22229,
22855,23888,24408,24677,24910,25045,26880,27110,27209,28047,
28908,28993,29494,29695,30353,30562,30801,31997,  495,  964,
 1253, 2513, 2842, 3385, 3653, 6154, 6557, 7536, 7611, 7948,
 8212, 8263, 8745, 9238,10225,10297,11176,11916,13388,13396,
14318,14491,14658,17484,17725,18524,18672,19115,19286,19733,
20045,20548,20862,20959,20979,21088,21620,21923,24501,24784,
25221,25301,26398,26578,26987,27800,27865,28272,28492,28822,
29786,29899,30485,30602,30878,31341,31821,32006, 1201, 1555,
 1765, 1784, 2257, 2422, 3514, 4096, 4501, 4560, 4763, 4844,
 5156, 5667, 5895, 6788, 7120, 7258, 7543, 7773, 8325, 9541,
10046,10701,10840,11162,12057,12737,13136,13300,14174,14664,
14786,15684,16746,16848,17181,17209,19981,20274,22028,22675,
22708,23689,24163,24322,24395,25379,25597,26080,26909,28514,
28691,28732,29049,29225,29662,30266,31771,   37,  898, 1228,
 2244, 2655, 4491, 6355, 8931, 9134, 9860,10059,10217,10687,
10906,10957,12134,12406,12645,12968,15076,15128,15198,15411,
15486,15951,16217,17744,18155,19011,19145,19160,19450,19630,
19656,19810,20076,20609,21194,21649,22395,22559,24039,24492,
24582,25393,25816,26249,26261,26752,26890,27042,27336,27978,
28914,29917,30403,30439,30557,32033,  792,  833, 1079, 1495,
 1740, 2198, 2756, 3095, 3785, 4131, 4157, 4197, 4635, 4850,
 5449, 5622, 5851, 5900, 6657, 7407, 7588, 7652, 8688, 8847,
 9691,10016,11579,12050,12422,12569,14419,14708,15384,15699,
15978,16096,16241,17621,17669,17680,17689,17792,19294,19743,
20371,20666,21703,23064,23193,23487,23527,25940,26542,26617,
27942,30918,30964,31143,31404,31509,  671, 1385, 1483, 2732,
 3205, 3879, 5244, 5502, 5584, 7551, 7626, 8776, 8792, 8891,
 9765, 9819,11046,11333,12125,12362,13184,13834,14063,14245,
15441,15450,15689,16162,17334,18880,18938,19045,20244,21209,
21944,21992,22095,22980,23514,24124,24143,24653,25833,25894,
25999,26050,26145,27362,27615,27874,27893,27988,29190,29843,
30288,30658,30998,31554,  344, 1452, 1504, 1926, 2018, 2381,
 3236, 3945, 5344, 5649, 5676, 6954, 7900, 8083, 8486,10564,
10639,11273,11823,12523,12638,13751,13893,14114,14167,14949,
15817,16994,17249,17798,19214,20019,20251,20902,21468,21722,
22163,22312,22321,23542,23646,24630,25118,25248,26034,26747,
26957,27757,27772,27841,28315,29630,30382,30551,31225,31561,
31874,  500,  590, 1042, 1213, 2552, 3538, 3853, 3932, 4376,
 5025, 5489, 5690, 6146, 7559, 7874, 8961, 9445, 9750,10847,
11256,12574,12871,13661,14265,14414,15471,15803,16005,16561,
17388,17820,18273,18352,19688,20219,20681,20693,22189,22928,
23243,23390,23813,24330,24596,24811,26179,27982,28617,29587,
29858,29955,29993,30451,30926,31052,31258,31354,  521,  803,
 1566, 1625, 2237, 2717, 3373, 4485, 5788, 5915, 6837, 7383,
 7445, 7456, 8144, 9335, 9459, 9495, 9758,10693,11777,12306,
12539,14098,14347,15309,15556,16444,18144,18241,18700,18888,
19227,19313,19346,19782,20674,21188,21355,22178,22435,22607,
24112,24604,24638,25869,26309,27087,28148,28163,28292,28643,
28669,29150,29528,31393,31461,  267,  531,  820, 1508, 1602,
 1652, 2646, 2691, 3509, 3669, 4172, 4530, 4613, 5056, 5422,
 6047, 6208, 6616, 6819, 7112, 7136, 8558, 9285, 9417,10835,
10990,11155,11286,11959,12129,12410,12591,13601,13845,14432,
14633,15038,15464,15962,17126,17171,17612,18101,18516,18665,
19708,19930,21816,22360,23106,23267,24467,26136,26582,27315,
27688,29129,29922,30197,31426,31522,31601,31977,  239, 1832,
 2395, 3136, 3336, 3778, 4041, 4709, 5508, 6799, 6829, 6860,
 6965, 7231, 7725, 8761, 9169, 9618, 9894,10289,10314,11300,
11973,12816,12866,13708,14343,14451,14527,15072,15516,15908,
16777,16911,17013,17090,18300,18757,18916,19997,20255,20946,
21006,21726,22015,23472,23635,23809,23941,24290,24340,24626,
24891,25783,27033,27358,28052,28852,28880,29406,29523,29892,
31958,  220,  403,  733, 2981, 3490, 3986, 4432, 4888, 5335,
 6291, 6349, 6551, 7930, 8278, 8729, 9453,10185,10584,10860,
11455,13140,13484,13917,14679,16768,17617,18394,18448,18596,
19223,19842,20649,20984,21045,22091,22540,22565,22905,24350,
24457,25092,25266,26238,26344,26568,28680,28845,29289,29680,
29964,30606,30846,31971,  255,  313,  969, 1775, 2441, 2569,
 3612, 3692, 4111, 4345, 5032, 5575, 6216, 7814, 9107, 9562,
 9849,10826,11088,11166,12147,12391,13549,14931,15564,16181,
16645,16710,16985,17575,17788,17877,17926,19343,20581,21070,
21475,22148,22234,22408,23659,24472,24999,25628,26408,26448,
26613,26912,27518,28312,28381,29498,29831,31058,  425,  526,
 1279, 1743, 3188, 3553, 5817, 5925, 6188, 6631, 7986, 8169,
 8383, 8458, 8640, 9697,10211,10625,11137,11677,12226,12875,
13075,13124,13937,13955,13969,14502,15597,16784,18284,18741,
20323,20625,21743,21891,22295,22384,25065,25112,25156,25183,
26123,27589,27850,27917,28826,29952,30425,30489,30589,30624,
30762,31305,31326,  197,  666, 2325, 2928, 3674, 4283, 5204,
 5327, 6030, 6564, 7747, 7914, 7969, 8024, 8079, 8117, 9096,
 9354,10337,10460,11372,12438,12560,12618,13476,14371,14555,
15253,15436,15475,16064,16150,16473,18269,18704,19290,19914,
21408,22332,22747,23153,23552,23766,24834,25123,25231,25581,
26712,27620,28137,28351,28817,28893,28940,30442,31568,  676,
  737, 1264, 1684, 1848, 1921, 2076, 3025, 3158, 4893, 4938,
 5427, 5495, 6079, 6492, 6917, 7607, 9248, 9730,10108,10954,
11799,13104,13175,13500,14409,15235,15865,15887,16620,16931,
17922,18247,19585,19838,20022,20086,20395,20552,22497,23476,
23565,23834,23903,25488,25635,26654,27029,27197,28228,28335,
30931,31174,  517, 1221, 1423, 1569, 1588, 2061, 2220, 3078,
 4034, 4576, 4830, 5097, 7632, 8224, 8474, 8755, 9087, 9103,
10221,11401,12122,12495,12772,14615,14698,15845,16350,16869,
18059,18277,18562,18773,19165,20095,20848,20882,21144,21374,
22570,23308,23353,23396,24249,26246,26514,27127,27503,28265,
29827,31345,31825,31927,32027,  128, 1366, 2153, 2432, 2748,
 2893, 2961, 6421, 6974, 7131, 7962, 9514,10613,10677,11808,
11905,12833,12988,13339,13634,15011,16750,17224,17432,17905,
17913,19603,20247,20751,21435,21443,21655,21940,22784,23894,
24070,24105,24972,25079,25176,25793,26162,26884,27173,27734,
28288,28581,28728,28949,29461,29623,29783,30030,30087,31433,
 2274, 2618, 3913, 4120, 4165, 5005, 5062, 5984, 6469, 8644,
 8990, 9815, 9939, 9986,10247,10811,11468,11537,11555,11601,
11829,13504,13541,13595,13658,15183,15645,16167,16816,17755,
18728,19442,19594,20643,20770,21962,22659,22996,23463,23822,
25813,26030,26340,26586,27405,27486,27570,28127,29315,29601,
30647,30723,31457,31692,  654,  988, 1015, 2014, 2179, 2714,
 2917, 3958, 4266, 4854, 4910, 5089, 6069, 6095, 6443, 6885,
 7125, 7374, 8685, 8973,10262,10328,10875,11624,12708,13897,
14058,14329,15112,15226,15944,16659,16921,16956,17749,18016,
18749,18957,19435,20427,20508,21856,22316,23816,25731,25851,
28561,29577,29670,30374,31025,31913,   96, 2933, 3750, 3951,
 4498, 4564, 4800, 4824, 6460, 6961, 7719, 8549, 8772,10382,
11043,12395,12940,13496,13966,14454,15361,15431,15703,16146,
16606,16972,17214,18164,18457,19105,19424,20113,21417,22492,
23100,23110,24519,25050,25171,25307,25991,26141,26172,26922,
28088,29427,29540,30207,31254,31576,31940, 1165, 1475, 1621,
 2800, 2973, 3265, 3416, 3598, 3617, 4257, 4926, 6342, 7194,
 7981, 8329, 8866, 9378, 9846,11055,11296,11654,11721,12158,
14597,15985,16440,16673,17502,18313,19170,19276,19310,19461,
20678,21383,21519,21785,22775,22796,26275,26379,26822,27191,
27228,27344,27469,27912,30477,30577,31180,31980,32038,  998,
 2406, 3709, 4463, 5068, 5340, 5630, 6196, 6870, 7162, 7235,
 7689, 7836, 8380,10063,10118,10590,10790,11382,11475,11945,
12886,14864,14896,15401,15584,16461,17480,17570,20955,21126,
21394,21735,22693,23123,23771,23830,23868,23909,24120,24689,
24803,24914,25089,27585,28838,29775,30229,30627,30938,31991,
  214,  840,  921, 1101, 1152, 1544, 2143, 3388, 3466, 4056,
 5268, 6183, 6213, 7025, 7331, 7764, 8306, 8788, 8850, 9036,
 9473, 9910,12402,12565,12820,13214,13760,14033,15095,16071,
16419,16580,17517,18190,18682,18712,19331,20606,21122,21451,
21605,21809,22666,23201,24387,25588,25618,26606,26636,26784,
27369,27479,29147,29421,29485,30044,30968,31421,31504, 1250,
 1257, 1660, 1979, 2823, 3091, 4275, 5581, 5921, 6063, 6282,
 6791, 7393, 8228, 8707, 9049, 9448, 9694, 9712,10319,11213,
11995,12634,12702,13385,14461,14686,15297,15522,16017,16185,
16284,16598,17491,19207,19989,20319,20829,20845,21460,22098,
22895,23134,23726,24050,24077,25006,25032,25547,25880,27666,
28360,29056,29120,29281,29435,29710,29875,30176,30881,31298,
31904,  469,  978, 1006, 1772, 1995, 2264, 5114, 5717, 6242,
 6352, 6584, 7711, 8202, 9318, 9467,10306,10665,11350,11759,
11833,12069,12550,12725,12802,12971,13665,13682,13716,13837,
13972,14016,14667,15195,17001,17220,17343,17589,17702,18197,
18636,18816,19261,20005,20089,20206,21365,22616,24511,24737,
25254,26318,27157,27298,27602,28001,28060,28429,29454,30269,
30599,31016,31379,31931,  882,  903, 1680, 2122, 2776, 4670,
 5210, 5220, 5286, 5313, 5470, 6610, 6765, 7035, 7069, 7506,
 8349, 9216, 9990,11202,11413,12041,13150,14133,14987,15084,
15216,16133,17352,18733,19446,19792,20079,20454,21440,21569,
22172,22438,22983,23259,24222,24907,25786,25875,26016,26306,
26756,26928,27522,28069,28694,28804,28848,29153,29256,30731,
30829,31247,31389,31645,  114,  451, 2183, 2227, 2560, 2912,
 3037, 3369, 3497, 3583, 4187, 4616, 4749, 5009, 5107, 6427,
 7562, 8593, 8918, 9264,10587,10768,11452,13098,13253,13890,
14560,15831,16381,18850,18867,19302,19334,20049,20384,21537,
22022,23061,23145,23923,24092,24969,25765,27079,27194,28304,
28375,28711,28725,30164,30785,31430,31917,  395,  434,  509,
 1210, 1243, 1370, 2638, 3506, 3924, 4051, 4674, 5764, 6027,
 6170, 6785, 7246, 7412, 7877, 8316, 9031, 9530, 9615,10710,
12926,14429,14676,14742,16436,16928,16948,17438,17665,17987,
18454,20161,20311,20807,20822,21516,22197,22237,22278,22610,
22719,23140,24234,25215,25669,27290,30102,31685,31974,   93,
  916, 3010, 3550, 4579, 4932, 5514, 8312, 8490, 8545, 8987,
10022,10140,10286,11855,12577,13391,13463,13711,13914,14524,
14661,16046,16333,16914,17758,17966,18130,18363,18568,19869,
19906,20758,22781,22921,24208,24343,25153,25674,25694,27130,
27182,27740,27803,28470,28832,29318,29866,31140,  356, 1539,
 2165, 2342, 2351, 2797, 4858, 5465, 5809, 6110, 6730, 7974,
 8479, 8527, 9672,10073,10759,10794,10802,11976,12099,14997,
15109,15313,15650,16173,17046,18111,19054,19091,19240,20599,
21048,22519,22670,23427,23699,23844,24054,24878,25228,25558,
26156,29012,29766,29988,30304,31708,31756,32010,  679,  991,
 1599, 1808, 1857, 2502, 2999, 3041, 3209, 4254, 4428, 4488,
 4507, 5419, 6560, 7807, 8376, 9137, 9630,10111,10271,10532,
11482,11826,12299,13143,13863,13878,13961,14822,15424,16450,
17229,18719,18970,20585,21361,22353,23004,23968,24645,25059,
25461,26575,26620,26627,26661,27938,28269,28440,28558,28889,
29996,30026,30071,30272,30666,30720, 2079, 2318, 2595, 2643,
 2958, 3990, 4521, 5780, 6035, 6882, 7206, 7539, 8390, 9736,
10429,10628,10696,11534,11551,11621,12365,12722,13030,13360,
13370,13448,14444,14923,15868,16997,17098,17358,18244,19025,
19123,19267,19532,19609,20232,20363,20899,21974,22031,22766,
23375,23555,23684,23944,23954,25042,25207,25451,25698,27147,
27459,27573,28911,29981,30106,31350,  351,  438, 1839, 2140,
 2772, 3129, 3521, 3876, 4148, 5407, 6053, 6310, 7936, 8269,
 9272, 9364, 9679, 9812, 9932,10470,11385,11417,11948,12252,
12311,12355,12520,14499,15068,15799,15898,15936,16392,17444,
17499,17960,18088,18318,19514,19671,20832,21085,21156,21234,
21583,21983,22888,23649,24063,25760,26010,26175,26331,26411,
26504,26552,26648,28347,28474,29649,29847,30002,31126,31802,
31983,  217,  323,  445,  466,  789, 1465, 1690, 2880, 3292,
 3782, 4108, 4455, 4611, 5606, 5638, 6013, 6275, 6936, 7031,
 7212, 7826, 8111, 8661, 8715, 8923, 9840,12996,13457,13590,
14170,14315,15246,15972,16273,16345,16638,17174,17338,18391,
20284,20876,21739,21803,21958,22012,22682,22936,24165,24505,
24608,25360,25664,25830,25967,26517,26642,28811,29379,29445,
30099,30684,30765,30843,31744,   89,  336,  391,  422,  578,
  876, 3117, 3333, 4731, 4950, 5578, 6671, 7064, 7568, 8064,
 8531, 8958, 9131, 9634,11102,11232,11547,12345,12450,12813,
12981,13085,13546,14834,15772,16074,16232,16412,17019,17129,
17198,17539,17891,18095,18210,19456,19779,20073,20379,20496,
21254,21321,23090,24480,26971,27889,27975,28145,28417,29208,
29607,30048,30362,30779,31194,31530,32020, 1828, 1866, 2131,
 3364, 3602, 3814, 4352, 4527, 7339, 7492, 7548, 7909,10674,
10774,11073,11787,11862,12607,14242,14650,14993,15711,18062,
18067,18368,18769,19547,19681,19891,20402,20796,21757,21860,
22303,22531,22865,23239,23469,23915,24656,24731,25239,25386,
25465,25604,28005,28140,28294,28896,29200,29501,30836,30944,
31891,  842, 1314, 2010, 2147, 3146, 3948, 4706, 5486, 5645,
 6040, 6722, 6925, 6931, 8218, 8587, 8950, 9508, 9642, 9954,
10449,13511,14210,14513,14887,14946,15065,15101,15811,16549,
17093,17243,18295,21271,21523,22402,23502,23935,24011,24089,
24211,26790,26915,27039,27135,27605,28064,28423,30245,30980,
  418, 1195, 2085, 2711, 3897, 3962, 4362, 4766, 5189, 5998,
 6568, 6665, 7197, 7364, 9368,10036,10049,11558,12036,12177,
12205,12677,13260,13727,17202,17303,18885,19278,19365,19976,
20104,20368,21580,21602,23190,24422,24443,24986,25350,26037,
26700,28106,28308,28575,29705,30225,30349,31401,31616,31950,
 1097, 1236, 2812, 5684, 5720, 5905, 7701, 7959, 8368, 9244,
 9744,10636,10872,11035,12763,13926,13958,14039,14272,14294,
15211,15366,16594,17524,17593,17801,18530,18821,20430,20634,
20662,21358,21658,21912,22759,22778,24525,26196,26996,27117,
27774,28093,28241,28842,29276,29728,30341,30469,31751,31832,
   13,  482, 2069, 2384, 3277, 3355, 3728, 4039, 5040, 5207,
 5318, 5539, 6640, 6655, 7059, 8692, 8800,10379,11396,11494,
11998,12513,12909,13748,14939,15242,15766,16483,18330,18572,
18651,19326,20024,20308,21341,22117,22740,22820,24488,24709,
25937,25996,27019,27154,28563,28738,29633,29820,30256,30583,
31920,31988,  703,  889, 1168, 1778, 1835, 1989, 2054, 5241,
 6816, 8089, 8710, 9026, 9536, 9709,10235,10914,11050,11335,
11920,12028,13985,14092,14215,14354,15317,16566,17184,17234,
17929,18205,18546,18743,18860,19421,19428,19499,19668,20993,
22034,22218,22753,23094,23348,23755,24816,25012,25245,26651,
26815,26931,27466,27493,28364,28877,29212,29238,29299,29542,
29713,30612,30871,31525,  861,  918, 1027, 1077, 1942, 2116,
 3184, 3300, 3596, 3734, 4003, 4048, 4059, 4269, 4687, 6018,
 6072, 6390, 6826, 6879, 6997, 7178, 7325, 7624, 7842, 8465,
 8869, 9121, 9470, 9675, 9984,10592,11091,11216,11774,12808,
12974,14496,15289,15754,15805,15823,16386,16515,19553,19850,
20326,21245,21316,21561,24384,26063,26210,26417,27090,27717,
28324,28378,28714,31495,  331,  539, 1380, 2347, 2400, 3132,
 3892, 3983, 4291, 4327, 5074, 7820, 7994, 8363, 9492,10001,
10645,11083,12433,12823,13115,13219,13487,13883,14141,14257,
14412,14817,15857,15885,16840,16908,17370,17817,18291,18876,
19212,19736,20484,21011,22510,23072,23517,23714,23739,24267,
24790,24917,25382,25509,27513,27737,29114,30671,30736,31183,
31199,31812,  828, 1158, 1805, 2217, 2460, 2931, 3272, 3423,
 3801, 3935, 4946, 5866, 5889, 7502, 7639, 7943, 8841, 9158,
10415,11078,11253,11763,12063,12296,12507,12600,12754,12881,
14519,16085,16395,16532,16670,17887,18534,19726,19877,20011,
20227,21035,22089,22330,22465,22542,22578,23447,24277,24529,
24590,24883,25485,25565,25973,27305,27456,27985,28466,28869,
  932, 1285, 1650, 1768, 2234, 2362, 2628, 2759, 4355, 5251,
 5275, 5325, 5338, 6413, 6946, 7169, 7462, 7787, 8386,10198,
10523,10658,11544,13091,13157,13323,13522,14541,14912,15333,
15569,15591,15636,15791,15967,17135,17410,18498,19100,20375,
21615,22100,22405,23482,23769,24392,25312,26232,26373,27395,
27534,28054,29143,30154,30309,30959,30985,31321,31406,31741,
 2660, 3295, 3382, 3459, 4626, 5405, 5665, 5969, 6554, 6771,
 7619, 8164, 8598, 9375, 9607,11005,11438,11924,12006,13374,
13597,14278,15221,15467,15874,16823,17386,17764,18327,19349,
19632,21455,21990,22986,23441,23489,23495,23586,23855,25218,
26112,26984,27399,27904,28342,29267,30759,31308,31443,31455,
31843,31956,  624,  645, 1431, 4102, 4837, 4873, 5542, 5884,
 7151, 8322, 9306, 9332, 9896,10493,10980,11139,11184,11841,
12184,13202,13571,14046,14809,17088,17153,17554,18249,18373,
19606,19866,20480,20973,21471,22392,23343,23558,25648,25661,
26786,26907,26968,28455,28636,28964,29283,29324,29698,30808,
31041,31588, 1070, 1632, 1984, 2251, 2708, 2803, 2895, 3179,
 3289, 3503, 6398, 8872,10292,10632,10705,10997,11963,12043,
13673,13989,14866,15091,15455,16528,18003,18174,18785,19064,
19695,20557,20851,21403,21571,22860,23274,25212,25614,25631,
25878,26534,26658,26830,27223,28234,29589,29881,30430,30579,
30827,30856,31132,  592,  809,  848, 1119, 1490, 5110, 6293,
 6727, 6852, 7159, 7225, 7243, 7838, 8284, 8697, 9189, 9269,
 9489,10202,11531,11940,12745,15495,16229,17508,17546,17614,
18075,18538,19273,20165,20194,20704,21286,21916,23511,23773,
24302,24893,24989,25415,26539,27577,27760,28510,28673,29217,
29610,30220,31168,31314,  300,  603, 1163, 1399, 1418, 1854,
 2840, 3215, 4285, 5099, 5238, 5726, 6178, 6416, 6429, 7583,
 7602, 7883, 8345, 8783, 8935, 9090, 9147, 9235,10411,10561,
13122,13933,14337,14416,15045,15835,16235,16371,17117,18214,
18471,19320,20597,20765,21768,22241,22325,23782,24028,24118,
25864,26335,26433,26558,26704,26950,27552,27559,27998,29052,
29194,29723,30060,31608,   35,  193,  248,  296,  503, 1755,
 1811, 2312, 2778, 2946, 3114, 3170, 3531, 4054, 4145, 4381,
 4582, 4842, 4886, 5960, 6166, 6202, 6682, 8292,10458,11471,
11480,11683,12501,13730,14068,14297,14749,14980,15394,15860,
16556,16712,16774,16795,17783,18071,18494,18642,19855,20224,
20391,20505,21026,21031,21058,21431,21929,22538,22614,22883,
22978,23045,23505,24616,24875,25753,26119,27530,28357,29066,
30213,30338,30674,31775, 1023, 1694, 3319, 4360, 5092, 5192,
 6186, 6253, 6500, 6629, 7336, 7613, 7933, 8260, 8721, 9625,
 9912, 9945,10883,11426,11590,12009,12149,12481,12493,12828,
13249,14552,14729,15228,16545,16845,17132,17970,18928,19712,
19719,20124,20948,21004,21134,21778,21833,21938,22993,24052,
24294,24448,24475,24843,25474,25490,25497,26028,26204,26269,
27891,28436,28734,29232,29271,29777,29864,30261,31540,32015,
   65,  157, 1295, 1846, 2764, 3666, 3930, 3968, 4129, 4622,
 4660, 5966, 6279, 6285, 6643, 7577, 7713, 7950, 8108, 9074,
 9230,10205,11219,11249,11561,12023,12352,13145,13275,13843,
13869,14095,14592,14812,14840,15462,16062,16571,16608,16782,
17049,17633,18638,18848,19730,19836,19845,20257,20461,21540,
21591,23626,24621,25358,26352,26633,27094,27408,27510,27618,
27732,27853,28554,29111,29526,29999,30548,30921,  235,  472,
 1056, 1390, 1447, 1536, 1596, 3219, 3348, 3367, 3395, 3494,
 3873, 4913, 4953, 4962, 5833, 6173, 7495, 8209, 8351, 8664,
 9670,10116,10133,10407,11069,12244,12388,12787,12902,13110,
13753,14726,14989,15311,16069,16552,17294,17336,18141,18503,
18780,19088,19397,19807,20491,20602,20738,22285,22398,22550,
22679,22717,22810,22916,22955,23938,24632,24770,24905,25555,
26001,26169,27563,27676,27882,29817,30042,30281,30564,31010,
31044,31077,31411,31436,31895,31946,  341,  993, 1745, 1890,
 2329, 4728, 5440, 5593, 6575, 7175, 7762, 7791, 8332, 9070,
 9347, 9372, 9988,10081,10232,10770,11716,12337,12942,13003,
13784,13964,14792,14894,15041,15255,15514,15796,16535,16622,
17559,17859,18767,18840,19299,20969,21893,22755,23572,23729,
24271,24410,24547,26199,26781,27074,27920,29296,30302,30378,
31382,  271,  327,  581, 1473, 2392, 2414, 3851, 5128, 5308,
 6454, 7266, 7889, 7923, 8565, 9310,10317,10670,11168,11422,
13269,13351,16011,16293,17226,17934,19050,19096,19167,19409,
19444,21077,22040,23131,23691,24420,24674,24733,26762,28327,
28623,28855,28935,28946,29028,29813,30640,30649,30874,31737,
   30,  293, 1880, 2063, 2397, 2550, 3227, 4180, 4473, 6340,
 6737, 9251, 9356,10244,11151,12380,12934,12962,13859,14248,
14275,15483,15939,16626,17598,17728,17901,18183,19508,19938,
20016,20617,21630,21750,21933,22195,22817,23163,24140,24451,
24855,25377,25733,26645,26754,27237,27324,28353,28525,29402,
30209,31300,  123,  907, 2124, 2306, 2528, 2942, 3773, 4641,
 4890, 5410, 5455, 5812, 6037, 6248, 7642, 7706, 8418, 8701,
 9419, 9836, 9869,11000,11741,12208,12985,13258,14421,14861,
15016,15764,15901,18660,19132,19305,20632,21008,21065,21527,
21713,22186,22413,23437,24197,24695,25353,25448,26234,27418,
27788,28038,28449,28699,31528,31535,  497, 1176, 2536, 4114,
 4228, 4903, 5627, 5892, 6181, 6811, 6972, 6993, 7037, 7233,
 8104, 8602, 8752, 9029, 9878,11100,14281,14504,15266,15499,
15948,16275,17297,17381,17863,17915,18000,19803,22529,23261,
23269,23485,24705,24728,25778,27012,27472,27488,27748,27886,
28530,29264,29534,29668,30167,30821,31488,31557,  244, 1604,
 2157, 2242, 2616, 3567, 3620, 3768, 4440, 5715, 5761, 6410,
 7784, 9174, 9290, 9724,10077,10375,10623,11211,11223,11657,
12525,12605,13507,14131,14301,14356,14447,16442,16600,17055,
18626,18955,19978,20472,21852,22170,23524,24214,24455,25434,
25955,26134,26419,27391,27907,30204,30275,30498,30796,  476,
  585, 1203, 2212, 2388, 2635, 3399, 3711, 4366, 5038, 5087,
 5394, 6403, 7203, 7442, 8970,10475,10720,12127,12541,12681,
12998,13216,14043,14340,15478,16348,16788,17044,18146,18316,
18349,18478,18946,18963,19622,19679,20761,20803,20977,21265,
22113,22506,23042,23167,23864,24307,24863,25401,25933,25993,
26059,26772,28195,28459,28807,29569,29580,29885,29986,30094,
31260,31694,  721,  825,  900, 1049, 1223, 1305, 1953, 2603,
 2888, 3719, 4133, 4273, 4493, 5873, 6942, 7541, 7680, 7991,
 8196, 8200, 8481, 8748, 8763, 9828, 9952, 9998,10129,10259,
10487,10904,10972,10988,12371,12431,12535,12567,14212,14481,
14737,14837,15718,16383,16399,16640,17222,17674,17719,18116,
18514,18901,19057,19750,19986,20464,20628,20742,21153,21789,
21818,21825,21947,22705,22926,23529,23760,24508,24786,25651,
26052,26154,26265,28250,28764,29641,30868,30973,31138,31231,
31762,31816,  652, 1628, 2622, 3029, 3089, 3167, 4193, 4541,
 4994, 5416, 6115, 6758, 6989, 7306, 8535, 9601,10312,11450,
11867,12585,13310,13647,14828,15081,15609,16007,16222,17059,
17582,18553,20860,21637,21988,23158,23666,24032,24044,24082,
25104,25286,25428,26214,26464,26530,26547,26694,26807,27027,
27464,28302,28373,29054,29287,30423,30559,   39,  354, 1172,
 1541, 2185, 3285, 3882, 4480, 5140, 5897, 6675, 6741, 7000,
 7016, 7453, 7927,10249,10595,11240,11539,11839,12192,12212,
13364,13471,13791,13880,14627,16088,16327,16618,16946,17512,
17815,18065,18980,19210,20260,20990,21645,21706,22081,22481,
22621,22990,25391,25791,27669,29134,29279,29291,29702,31223,
31267,31591,31642,32002,  699, 1382, 2259, 2657, 3726, 3894,
 4317, 4426, 4724, 5020, 5150, 5199, 5853, 7822, 8653, 9320,
 9852,10148,10419,11971,12039,12440,13585,13795,14116,14655,
15578,16963,17542,18463,18776,19220,19529,19640,19660,20445,
20468,21083,21231,22156,22749,23251,23849,24205,24253,24324,
25072,25275,25537,25959,26381,27355,27962,28118,28490,28966,
29042,29791,29912,30159,30216,31147,  780,  852,  962, 1266,
 1677, 1782, 2734, 3106, 5271, 5669, 5804, 6432, 6494, 7107,
 7430, 7749, 7895, 8094, 8359, 8713,10845,11085,11337,11389,
11521,12878,13529,13831,14100,14139,14995,15048,15848,15906,
16271,16367,16455,17760,17978,18698,21845,22297,24871,24967,
24997,25691,26960,27313,27376,28708,29117,29960,29991,30242,
30936,30996,31689,31922, 2439, 2805, 3076, 3083, 3331, 4370,
 4504, 4868, 5425, 5710, 6007, 7149, 7796, 8450, 8705, 9892,
10968,11665,12175,12323,12612,12904,13106,13935,15107,15566,
16034,17168,17341,18133,19234,20459,21954,23049,23387,23449,
23736,24286,24353,25173,25892,26920,26941,27084,28259,31023,
31419,  261, 1063, 1301, 1425, 2983, 4549, 5054, 5481, 6033,
 6074, 7829, 8146, 8613, 9068, 9233,12067,12483,14815,15281,
15778,16438,17493,17770,17827,17996,18485,18951,19549,19598,
20686,20779,20982,21338,21999,22142,23085,23306,24628,25196,
26258,27593,27844,27968,28276,28345,29223,30428,   61,  141,
  457, 1372, 1462, 1560, 1738, 2364, 2458, 2640, 3572, 3672,
 3997, 5451, 6298, 6720, 7023, 7525, 7545, 7921, 7997, 8347,
 8647, 8859, 9112, 9352, 9475, 9554, 9832, 9842,10280,10660,
10689,11374,11603,11769,12360,12589,13206,13273,13326,14112,
14172,14351,14373,15251,15429,15560,15595,15601,15661,16214,
16705,17604,18166,18751,18882,19201,19484,20702,20868,20937,
21415,21814,21858,22152,22472,22572,22738,23509,23811,23825,
24156,25291,26369,27096,27613,28125,29022,29077,29870,29925,
30966,31120,31441,31520,31777,  605,  923, 1217, 1454, 1830,
 1860, 2128, 2373, 2532, 2548, 3002, 3344, 3393, 3563, 3649,
 3736, 3886, 4943, 5964, 6735, 6841, 7049, 7945, 8863, 9726,
10253,10384,10569,11012,11244,11679,11745,11953,12110,12505,
12960,14143,14267,15133,15382,15697,16734,16951,17232,17305,
17587,17822,18282,18297,18631,19704,19728,20071,20221,20382,
21136,21506,21555,21780,22307,23104,23142,23371,23519,24240,
24828,25077,25226,25633,25947,26933,27168,27307,27958,28306,
28675,29202,29538,29659,29877,30591,30597,30656,31185,31839,
  195,  513,  866, 2008, 3869, 4342, 4566, 4884, 5122, 5824,
 6168, 6571, 7504, 7553, 8073, 8214, 8502, 8589, 8717, 9689,
 9802, 9930,10098,10833,10916,11801,12740,13186,13211,13513,
13533,14041,15680,15833,16547,16613,16766,17096,17162,17207,
17404,17475,17519,17907,18579,18878,18918,19271,19693,19861,
20201,20498,20708,21019,21353,22276,22612,23670,24073,24150,
24490,25001,25696,25989,26047,26253,26506,26525,26584,26604,
26690,26788,27137,27532,28071,28472,28611,29443,29836,30283,
30961,31050,31256,31893,    7,   91,  146,  210,  298,  622,
 1770, 2168, 2578, 3655, 3748, 3899, 4238, 4261, 4417, 4856,
 5958, 6273, 6289, 7027, 7381, 8370, 8467, 8547, 9085, 9519,
 9756,10456,10698,11016,11639,11719,11928,12448,12719,12976,
13251,13578,13684,13861,14700,14844,15093,15821,16530,18906,
19697,19991,20294,20478,21573,21968,22127,22375,22485,22602,
22768,23300,23584,23741,24606,24661,24832,24993,27269,27753,
27779,27990,28062,29109,29228,29496,30199,30227,30814,31566,
31915, 1038, 1481, 1851, 3600, 5295, 5790, 7372, 7579, 7967,
 8768, 9145,10491,10772,11174,11380,11860,12691,13498,14219,
14681,14882,14976,15214,15582,16286,16362,16835,17191,17885,
17889,18452,18855,18894,19710,20321,20400,20887,22822,24292,
24527,24772,25495,25616,26014,26167,26236,26320,27334,27351,
28157,28759,29192,29206,31170,  117, 1086, 1594, 1692, 1969,
 2016, 2523, 2774, 2854, 3402, 3906, 4330, 4436, 5222, 5512,
 5651, 6022, 6344, 7248, 7268, 8993, 9632, 9655,10200,12011,
12330,12818,12835,13931,14135,14799,16855,17004,17678,18598,
19126,21056,21207,21854,21901,22876,23173,24068,24549,24974,
26020,26223,28368,28769,29596,29716,30585,31790,31898,  420,
  535, 1205, 1763, 2190, 2370, 2610, 3313, 3780, 3799, 4347,
 4668, 5044, 5398, 6102, 6562, 6680, 7590, 7597, 8488, 9167,
 9308, 9838, 9873,10605,10672,10949,11597,12182,12224,14048,
14345,14982,15070,15615,15960,16183,16390,18128,18532,19066,
19225,19592,19840,20111,20249,20388,20986,21367,21578,22502,
22715,23007,23832,24735,25081,27292,27379,27403,27425,28476,
28813,29124,29145,29883,30300,30336,30380,30632,30727,30942,
31428,   11,   87,  358,  407,  639,  735, 1358, 1837, 2327,
 2379, 2508, 2626, 3039, 4118, 4297, 4333, 4447, 4806, 4835,
 5112, 5255, 6000, 6077, 6233, 6435, 6663, 6793, 7155, 7199,
 7508, 7617, 7840, 8314, 8774, 9431, 9485, 9664,10230,10800,
10901,11009,11178,11269,11457,11853,11922,12424,12774,12990,
13333,13888,14031,14925,15315,15329,15827,16138,16267,16742,
17372,17408,17619,17968,18073,18201,18289,18344,18526,18570,
19628,19716,19858,19916,19926,20163,20373,20805,21023,21343,
21419,21433,21985,22533,23092,23456,23622,23707,23956,24792,
24846,24903,25010,25260,25771,25873,26631,26702,26811,26952,
27742,28040,28438,28512,28840,29068,29433,29572,30169,30416,
30444,30487,30652,30810,31104,31356,31370,31594,31631,  126,
  269,  775,  818,  880,  911, 1000, 1125, 1606, 1874, 2935,
 2950, 3186, 3303, 3430, 3796, 4264, 4960, 5131, 5311, 5388,
 5493, 5537, 6592, 6747, 6777, 6952, 7490, 7715, 8302, 8378,
 8463, 8604, 8933, 8978, 9516, 9571, 9717,10142,10405,10703,
10764,11428,11584,12171,12454,12518,12897,13006,13164,13294,
13632,13758,13895,14832,14999,15370,15460,16056,16187,16667,
16919,17200,17314,18443,19834,20039,20432,20589,21142,21273,
21411,21473,22225,22400,22582,22599,23539,23576,23653,23866,
23911,24109,24122,24586,24859,25398,26121,26217,26323,26745,
26844,27373,27684,27704,27993,28032,28296,28654,28671,29063,
29505,29519,29664,29845,29873,30193,30471,31145,31310,31773,
 1287, 1376, 1928, 2012, 2232, 2825, 3102, 3326, 3662, 4570,
 6060, 6612, 6732, 7321, 7609, 8327, 8690, 8916, 9921,11110,
11195,11633,12891,13120,13138,13347,13459,13554,14717,14937,
15701,15974,16260,17356,17556,18496,20175,20775,21050,22301,
22323,22745,22923,23445,23780,24707,24724,26277,26521,28122,
28331,29322,29970,31029,31352,  154, 1443, 1748, 4444, 4460,
 4513, 6476, 7879, 9062, 9312, 9628, 9914,10371,10630,11029,
12956,13767,15750,16526,16825,16991,18178,18212,18735,19037,
19353,20212,20290,20620,21670,21910,24135,24895,25252,25612,
26385,26733,27791,28434,28736,30376,30933,  225, 2270, 2558,
 2730, 2786, 3979, 4277, 4496, 5282, 5971, 8127, 8855, 9330,
10135,10464,11071,11821,12730,12795,13064,13675,14369,15618,
16239,17323,18589,18680,19492,19596,20091,21759,24838,25463,
25623,26400,26800,27103,27520,29102,29823,31071,31192,  986,
 1275, 1892, 2056, 2600, 3548, 4965, 5722, 6304, 6447, 6598,
 7778, 9081, 9105,11804,14283,14631,14869,15200,15493,17446,
17753,18275,21033,21618,22366,22661,23149,23272,23425,23896,
25602,26455,26852,27575,28453,28882,29829,30172,30864,31710,
31794,  275,  287,  449,  694, 1066, 2545, 3099, 3198, 6948,
 7885, 8204, 8408, 8901, 9934,10868,11022,11298,11765,13509,
13593,14119,14712,16900,17115,17627,18838,19395,20880,20932,
21542,23312,23361,23644,25179,25384,26116,26436,26917,27475,
27973,28192,28898, 2033, 2575, 3976, 4037, 4875, 5663, 5875,
 6396, 7723, 8574, 9044, 9246,10434,10792,11950,12217,13644,
13713,14515,16219,16290,17035,17379,18119,18365,19023,19433,
19933,21390,21805,23096,23872,24097,24305,24402,24922,25299,
25314,25356,25981,26793,27412,29603,29805,30150,31511,31614,
31944,  237, 1392, 1950, 1958, 2262, 2693, 3043, 3308, 3915,
 3954, 4543, 5292, 5786, 6194, 6337, 7358, 7448, 8733, 9603,
10426,12055,13353,13582,14104,14740,15052,15363,15606,16819,
16829,17607,18548,18721,19083,19158,19651,20133,20554,20871,
22596,22863,23160,24658,26545,27708,28745,29082,29340,29839,
30054,30081,30581,31445,31698,  206,  493,  524,  632,  739,
 1046, 1089, 1346, 1611, 2047, 2746, 2782, 3155, 3475, 3579,
 3803, 3890, 4032, 4811, 5013, 5226, 5380, 5445, 5601, 5624,
 5698, 5712, 5879, 6633, 6653, 6876, 6979, 7045, 7061, 7222,
 7318, 7377, 7766, 8037, 8096, 8174, 8403, 8415, 8843, 8963,
 9177,10075,10093,10207,10500,10663,10716,11153,11341,11592,
11636,11738,11943,12106,12194,12486,12747,13282,13372,13494,
13558,13680,13779,14263,14756,15103,15306,15433,15785,15838,
15953,16051,16401,16967,17772,18400,18437,18922,19061,19140,
19247,19480,19882,20000,20409,20562,21132,21192,21260,21651,
21728,21787,22201,22239,22328,22357,22881,22944,22999,23011,
23279,23628,23758,23879,24194,25101,25125,25309,25667,25758,
25849,26363,27347,27364,27387,27955,28188,28236,28290,28696,
28730,28824,28904,29140,29390,29618,30046,30097,30347,30916,
30983,31395,31626,31716,  251,  787,  805, 2005, 2037, 2074,
 2515, 3160, 3213, 3223, 3704, 4067, 4314, 4516, 4556, 5671,
 5797, 6382, 7436, 8675, 8683, 8948, 9414, 9865,10003,10842,
11066,11361,11463,11477,11792,12061,12161,12428,12831,12907,
13192,13827,14610,14885,15206,15439,16148,16417,16655,17286,
17522,17531,17687,18710,19153,19521,19812,19893,20544,21319,
21376,21831,22371,22427,22962,23102,23560,23886,24020,24128,
24232,25560,25595,25671,25835,26003,26078,26622,26710,27119,
27150,27214,27719,28076,28528,29155,29429,30115,30642,30924,
31207,31573,31734,32036,  150,  291, 1004, 1054, 1789, 3182,
 4442, 4657, 4881, 5184, 5468, 5839, 6231, 7403, 7516, 8192,
 8736, 9457, 9734,10239,11157,12156,12532,12790,12950,13079,
13573,14851,14944,15218,15278,15421,16160,16195,16486,16588,
17732,17899,18383,19265,19284,19296,20043,20297,20314,20647,
22244,22701,23531,23925,24428,24687,25608,26150,26422,26803,
27081,27230,27950,28056,28687,29973,30949,  133, 1160, 1310,
 1361, 2497, 2526, 3943, 4162, 4678, 5058, 6367, 6774, 6862,
 7115, 7302, 7727, 8131, 9302, 9506,10521,13221,14253,14511,
14794,15480,15512,16564,17108,17893,18139,18253,19231,20658,
21167,21532,22351,23321,24201,24523,24665,25016,25057,25553,
25776,26375,26496,26974,27016,27856,28995,29512,29675,30861,
31155,31211,31239,31606,31938,  838, 1107, 1642, 2215, 2821,
 2952, 3614, 3746, 4816, 6850, 7409, 9568, 9613,10754,10778,
11041,11430,11645,11878,12497,13478,13953,14107,14875,15388,
16059,16661,16983,17610,18123,18930,19339,19555,19829,20359,
20639,20965,21329,21429,23842,24152,24610,25233,26528,27416,
27495,27915,28129,28859,28959,29026,30040,30687,30738,30990,
31323,31387,31876,  112,  869, 1972, 2445, 2511, 2726, 3680,
 4094, 4176, 4715, 5333, 6246, 6357, 7263, 8567, 9129, 9287,
 9343, 9638, 9748, 9898,10188,10995,11357,11755,12186,12357,
12509,12825,14270,14358,15638,15745,15980,16480,16538,16944,
17245,17311,17958,19117,19454,20115,20434,21090,22122,22231,
22919,25408,26201,28086,28178,28226,28751,29249,29492,30264,
30555,31037,  136,  241,  464,  608,  859,  982, 1268, 1427,
 1923, 2428, 2844, 3148, 3479, 4242, 4760, 4839, 4956, 5023,
 5615, 5849, 6011, 6085, 7013, 7173, 7812, 8085, 8148, 8308,
 8998, 9434,10389,10443,10530,11062,11281,11364,11484,11523,
11652,12609,13358,13446,14025,14424,14483,14558,14595,14721,
15588,16265,16524,16568,16838,16936,17682,17939,18667,18898,
20013,20768,20810,21252,21599,21628,21835,22475,22761,22886,
23066,23181,23433,23892,23966,24247,24318,24338,25347,25395,
25637,25762,26446,26707,27508,27674,27928,28532,28547,29592,
29708,29770,30395,30483,30575,31008,31302,31993,  975, 1111,
 1187, 1225, 1470, 1686, 1888, 1986, 2597, 2780, 3315, 3426,
 3468, 3757, 4100, 4152, 4308, 4423, 4654, 4924, 4934, 5261,
 5497, 5724, 5828, 6260, 6347, 6651, 6724, 6806, 7009, 7118,
 7183, 7329, 7345, 7964, 8016, 8267, 8334, 8585, 9451, 9528,
 9621, 9652, 9658, 9858, 9992,10018,10095,10304,10342,10517,
10952,11434,11575,11587,11659,11797,12048,12558,12593,12735,
13113,13343,13736,13910,14066,14826,14858,15099,15490,15518,
15524,15998,16237,16282,16770,16803,16850,16954,16978,17204,
17375,17430,17865,17989,18109,18113,18594,18674,18747,18827,
18842,18910,18936,19163,19662,19686,19936,20438,20595,20645,
21075,21180,21745,21801,21976,22107,22382,22710,23138,23205,
23631,23682,24623,24841,25028,25280,25679,25684,25841,25921,
25965,26164,26316,26588,26764,26848,26989,27206,27501,28090,
28421,28521,28551,28678,28819,29230,29797,29919,30052,30079,
30249,30542,30610,30660,30787,30883,31364,31408,31532,31719,
  601,  822, 1581, 1634, 2905, 2915, 3074, 3119, 3279, 3418,
 3516, 3529, 4126, 4383, 4720, 4819, 5695, 5707, 5870, 6049,
 6220, 6486, 6647, 7529, 7739, 8162, 8220, 8280, 8554,10026,
10069,10277,10462,10502,11568,11810,12250,12308,12435,12868,
13368,13656,13732,13852,13902,14517,15126,15193,15452,15502,
15648,15657,15987,16201,16517,16602,17023,17124,18011,19238,
19413,19826,20093,20188,20423,20699,21186,21204,21284,21392,
21509,22119,22416,22479,22687,22974,23907,24199,24273,24521,
24634,26443,26743,26966,27175,27218,27300,29490,29530,29575,
30970,31538,31769,31935,  768, 1121, 1354, 1421, 1669, 1801,
 1815, 1934, 2420, 2816, 2834, 4739, 4745, 5403, 5992, 6200,
 7122, 7984, 8257,10138,11835,13130,13289,14533,14629,18053,
19864,20081,20120,21549,22087,22193,23853,25022,25169,25645,
26082,26537,27189,27200,27430,27902,28657,29007,29070,29439,
30174,30409,32030,  103,  615, 3657, 4076, 5385, 6580, 6691,
 8477, 9187,10054,10294,11080,12511,13069,13200,13979,17101,
17537,17717,18388,18653,18694,19112,19341,20007,20279,20568,
22205,22227,23098,23304,23901,23946,23970,24037,24279,24534,
25738,26839,27001,27660,28501,28639,29311,29329,30645,30914,
31827,31942,  506, 1019, 1182, 1292, 1648, 2276, 2901, 3541,
 4185, 5051, 5265, 5298, 5732, 7755, 8102, 8152, 8896, 8981,
 9076, 9739, 9887,10401,11407,12200,12229,12452,12924,14084,
14599,15033,15883,15965,16425,16797,17794,17807,20064,22868,
23429,24000,24217,24692,25438,26458,27139,28133,29447,29458,
30085,31316,31368,31952,  537, 2607, 3151, 3843, 4649, 4702,
 4996, 5136, 5228, 5702, 5955, 6108, 6236, 7004, 7327, 8009,
 8454, 8910, 9040, 9455,10373,10809,11541,11727,12412,12695,
13974,14157,14228,14442,14471,14689,17440,17736,17856,17868,
17973,18564,19174,19452,20654,21634,21710,23197,23546,25819,
25943,26500,27784,30195,30755,31498,   57,  691,  710, 1408,
 1434, 2753, 3192, 4386, 4438, 5017, 5461, 6159, 6636, 7228,
 8304, 8941, 9181, 9345,10322,10681,10911,11147,12596,12756,
12916,13569,14671,15448,15627,16257,17551,19245,19466,20100,
20641,21849,22199,22345,22368,23117,23364,23381,24435,25844,
26240,27696,27947,28171,28443,28661,29086,29184,29344,29909,
30258,30975,31650,31804,31809,31906,  405, 1008, 3360, 3676,
 3754, 3765, 5437, 6480, 6606, 7368, 7636, 8835, 9276, 9732,
 9752,11226,11986,12383,13013,13278,13410,14622,14898,14919,
15139,15373,15376,15664,17368,17384,17402,19014,19543,20060,
20172,20415,21190,21347,21716,21754,23316,23536,23870,24399,
24460,24681,25188,25374,25468,25543,26186,26190,27537,27650,
27681,28050,28388,29035,29307,30413,30433,30614, 1272, 1751,
 2402, 2762, 2986, 3526, 3921, 3981, 4712, 4755, 6781, 7798,
 7978, 8399, 9703,10396,10446,11289,11594,12152,12778,13093,
13723,14313,14522,14644,14848,15622,16038,16082,16866,16941,
17692,17897,18976,19218,19323,19800,20855,21172,21258,21838,
22054,22134,22363,22722,23184,23281,24588,24618,25241,25263,
25606,26055,26451,27235,27278,29019,29437,29508,29762,30369,
30462,30537,30638,31681,31781,31787,   27,   54,  278,  401,
  714, 1966, 2001, 2452, 2505, 2831, 3685, 4663, 4928, 5064,
 5587, 6250, 6745, 6858, 6956, 7040, 7078, 7451, 8299, 8372,
 8956, 9574, 9808,10508,10766,10814,10838,10975,11615,11909,
11981,13021,13056,13072,13744,14076,14160,14928,15677,16176,
16664,16959,17104,17141,17983,18006,18511,18540,18715,19076,
19539,20418,20572,20706,20825,21220,22697,23053,24540,24698,
24795,24960,25639,25986,26389,26714,26818,27745,28571,28683,
29221,29480,29656,30018,30491,30553,30840,30956,31639,32012,
   76,  110,  319,  478, 1510, 1868, 2138, 2464, 2541, 3964,
 4063, 4167, 4235, 4289, 4302, 5429, 5476, 5640, 5728, 6377,
 6537, 6546, 7362, 7759, 8035, 8318, 8516, 8695, 9057, 9124,
 9226, 9880,10865,12017,12167,12325,13297,13706,14804,15274,
15634,15878,16130,16245,16356,16403,17062,17955,18258,18335,
18435,18466,18761,19255,19614,19818,20107,20266,20354,20502,
20815,21139,22004,22335,22547,22588,23569,23748,24405,24868,
24928,25235,25283,25885,27171,27871,27923,28184,28286,28535,
29122,29966,31027,31061,  673, 1411, 1664, 1977, 2026, 2151,
 2309, 3589, 4336, 5084, 5390, 5908, 6226, 6364, 6768, 7072,
 8579, 8906, 9255,10256,10806,11053,11278,11353,11489,12197,
12760,13001,13641,13855,13946,14303,14361,14566,14605,14619,
15323,15407,17319,18491,19506,19796,20475,21278,21313,21529,
22209,22790,22793,22949,22965,23324,23724,23839,25014,26130,
27164,27320,28101,28608,28749,29469,29645,29803,30532,30630,
31069,31245,31836,  232,  873, 1117, 1232, 2337, 2738, 3033,
 3162, 3688, 3860, 4088, 4772, 5101, 5633, 5911, 6051, 6462,
 6809, 6968, 7399, 7433, 7695, 8007, 8725, 8879, 8943, 9360,
 9521,10009,10302,10601,10609,10819,10856,11749,12139,12257,
12546,12684,13771,14288,14456,14854,15843,16193,16335,16635,
16808,17039,17121,17398,17992,18261,18359,18381,18753,18863,
19043,19336,19475,19654,20406,20579,20941,21214,21247,21424,
21773,22181,22291,22500,22512,22626,22743,22849,23058,23857,
24257,24261,24282,24720,24806,25037,25069,25110,25162,25200,
25481,25676,25749,25826,25882,26556,26724,26888,27281,27498,
27567,27581,27672,27931,27970,28463,28756,28902,29215,29240,
29387,29396,29487,30010,30358,30994,31005,31726,31878,31887,
  310, 1035, 1401, 1486, 1658, 1757, 2706, 3140, 3211, 3808,
 5234, 5499, 5604, 5952, 6407, 7214, 7833,11229,11912,11932,
12765,13693,14149,15078,16586,17365,18153,18582,19675,19776,
22342,24799,25854,27178,27811,28427,28541,28649,30092,30181,
31034, 1240, 1579, 2437, 3499, 5081, 5382, 6401, 8138, 8552,
10335,10452,12419,13517,13981,16329,16432,16652,18255,18942,
19016,20169,20799,21164,21462,22110,23656,23884,23962,24059,
24965,25054,25268,25430,26563,26833,27727,28997,29474,31373,
31547,  160,  659,  778,  836, 1348, 1938, 2112, 3081, 3195,
 4877, 5144, 6091, 6751, 7355, 8067, 8507, 9294, 9855,10898,
11967,12234,13399,13654,14509,15170,15416,17291,17434,18662,
20270,23550,24740,26718,26769,27145,30296,30694,31623,  707,
 3269, 3760, 5288, 7127, 7388, 7422, 8091, 9908,10031,12096,
13318,14309,15976,16155,16447,17348,17712,18521,18587,19251,
19664,20097,22024,22870,23276,24311,25592,26924,27795,28718,
29896,   20,  618, 1637, 2979, 2988, 3409, 3857, 3966, 4339,
 4450, 6449, 7571, 8190, 8609, 9605, 9821,10853,11399,11671,
14436,15057,16279,17529,20066,22274,23458,23712,24326,25575,
26599,28508,30411,31334, 1406, 1843, 2566, 3917, 4704, 4940,
 4999, 6371, 8540, 8606,12304,12714,14028,14465,15419,17391,
17981,18207,19407,20084,20753,20935,21904,22377,22585,23718,
25258,26071,26826,27698,27764,28497,   98,  893, 2163, 4691,
 5300, 5434, 5589, 5613, 6803, 7254, 8274, 9060, 9079, 9526,
10177,11938,12019,12706,13355,15027,16543,19898,20412,21733,
21764,23919,26228,27105,28238,29393,29904,32025,   73, 6005,
 6921, 7167, 7342, 8983, 9163, 9240, 9890,10042,12342,12629,
13407,15762,15982,16021,16676,16726,18050,19612,20317,20593,
23314,23686,24980,26158,27006,27265,27285,29811,30014,30459,
31213,  717, 3012, 3126, 8952,10477,11565,11843,12292,12954,
13380,13636,15666,17361,17428,19119,20239,20691,21236,23187,
24219,25507,25740,26138,27035,27598,27878,28957,29105,29236,
30355,31135,31652, 1259, 1378, 1823, 2583, 2768, 3297, 4183,
 4518, 5315, 5521, 5769, 6374, 6659, 7938, 8019, 8903, 9092,
 9685,11446,11815,12445,13197,13776,14060,14562,14684,15204,
15674,16067,17281,17942,18086,18194,18310,18932,19360,20818,
21148,21840,22212,24577,26127,26221,26358,28665,28873,29080,
29098,29349,29687,31235,   24,   67,  282,  348,  725,  798,
  830, 1245, 1356, 1394, 1999, 2030, 2939, 3045, 3200, 3543,
 3606, 4079, 5680, 6626, 6688, 6940, 7210, 8337, 8456, 9171,
11095,12528,12579,13526,14128,14226,14641,15713,16029,18676,
19071,19490,19588,19617,20036,20177,20487,20636,20874,21038,
21323,21400,21564,21799,22411,22425,22521,22544,23285,24299,
24776,24852,25295,25406,25857,26566,27515,27944,28108,28173,
30113,30668,30748,30825,31114,31551,  397,  486,  627,  647,
  686,  696,  712,  771,  896,  914, 1123, 1499, 1557, 1575,
 1799, 1963, 2044, 2160, 2201, 2333, 2367, 2417, 2447, 2455,
 2563, 2653, 2695, 2908, 3005, 3110, 3357, 3560, 3575, 3592,
 3731, 3744, 3810, 4070, 4092, 4139, 4249, 4295, 4311, 4572,
 4637, 4753, 4809, 4863, 4921, 5280, 5346, 5349, 5610, 5656,
 5693, 5775, 5836, 5979, 6015, 6088, 6105, 6238, 6263, 6306,
 6478, 6542, 6604, 6638, 6694, 7067, 7428, 7439, 7565, 7699,
 7709, 7732, 7736, 7768, 7781, 8172, 8185, 8422, 8577, 8946,
 8967, 9156, 9224, 9257, 9298, 9410, 9424, 9428, 9462, 9481,
 9501, 9661,10121,10282,10483,10577,10620,10781,10785,10878,
11020,11076,11142,11159,11191,11367,11393,11440,11486,11611,
11685,11725,11772,12189,12490,12622,12672,12743,12751,12780,
12800,12884,13062,13100,13454,13468,13520,13678,13689,13697,
13921,14054,14176,14230,14236,14261,14401,14476,14485,14530,
14538,14603,14902,15005,15116,15231,15573,15620,15669,15707,
15880,15894,15994,16014,16042,16078,16253,16629,16858,16905,
16939,16981,17139,17165,17179,17195,17284,17377,17423,17442,
17534,17565,18080,18104,18161,18266,18440,18566,18669,18832,
18914,18974,19078,19085,19156,19525,19924,19994,20041,20054,
20264,20366,20517,20865,20929,20951,21013,21041,21177,21217,
21387,21544,21730,21828,21896,22043,22338,22814,22873,22933,
22959,22972,23155,23176,23236,23263,23336,23383,23398,23745,
23949,24015,24018,24159,24245,24433,24537,25025,25040,25052,
25116,25344,25369,25457,25572,25805,25821,25926,25951,26006,
26024,26068,26377,26460,26595,26629,26727,26963,27004,27021,
27186,27275,27317,27414,27541,27557,27663,27713,27808,27847,
28079,28385,28505,28517,28659,28747,28829,28884,28916,29001,
29252,29333,29416,29477,29614,29957,29979,30032,30179,30235,
30400,30406,30481,30569,30753,30987,31012,31065,31150,31491,
31584,31767,31784,31797,31901,   42,  163,  202,  307,  316,
  635,  662,  785, 1002, 1059, 1082, 1091, 1735, 1760, 1894,
 2359, 2410, 2591, 2836, 3016, 3421, 3501, 3855, 4388, 4466,
 4700, 4717, 4822, 4899, 5195, 5216, 5258, 5483, 5516, 5568,
 5973, 6223, 6267, 6578, 6677, 6834, 7145, 7416, 7459, 7629,
 7683, 7686, 7742, 8027, 8134, 8158, 8672, 8679, 8780, 9184,
 9274, 9280, 9325, 9557, 9741, 9884, 9917, 9958,10005,10339,
10512,11410,11608,11934,11978,12014,12136,12141,12154,12767,
12895,13536,13563,13576,13650,13942,14334,14406,14468,14547,
14692,14891,15021,15062,15757,15769,15809,16216,16324,16358,
16723,16801,16813,16864,17029,17487,18125,18137,18585,18647,
18789,18960,19021,19259,19495,19823,19831,19895,20051,20062,
20564,20842,20895,20963,21170,21587,21795,21936,21996,22222,
22347,22388,22800,22899,22940,23483,23580,23705,24145,24417,
24462,24702,24888,24930,25098,25250,25971,25979,26519,26602,
26735,26766,26777,26897,26991,27202,27232,27384,27721,27814,
28169,28253,28432,28652,28921,29692,30006,30436,30742,30770,
30799,31111,31264,31438,31563,31807,31889,    0,  338,  845,
 1698, 2041, 2149, 2188, 2518, 2581, 2704, 2829, 2850, 3323,
 3365, 3699, 4106, 4538, 4865, 5047, 5533, 5771, 5799, 6149,
 7190, 7350, 7532, 7776, 8150, 8179, 8272, 8538, 8881, 9315,
 9905, 9995,10056,10519,10887,10993,11735,11848,12046,12219,
12805,13018,13303,13480,13987,14124,14488,14935,15055,15292,
15300,15404,15855,16178,16477,16583,16657,16806,17033,17308,
17326,17684,17882,18323,18339,18351,18379,18691,19150,19972,
20302,20575,20612,20669,20696,21162,21594,21661,22051,22488,
22593,22664,22690,22728,22969,23882,23929,24006,24023,24116,
24483,25388,25411,26032,26427,26591,26738,27546,27657,28390,
28566,28866,28927,28954,29017,29654,29719,30063,30145,30454,
30678,30851,31003,31157,31361,31729,  388,  884, 1114, 1819,
 2051, 3377, 3739, 4230, 4533, 4546, 4757, 5077, 5104, 5400,
 6783, 6854, 7647, 8742, 9441, 9761, 9927,10051,10647,10684,
10909,11266,11344,11673,11780,11812,12202,12931,13331,14746,
14879,15030,15173,15186,16738,16757,17147,17708,18903,19129,
19308,19519,19619,19787,20570,22432,23081,23119,23491,23662,
24599,24650,24716,24898,25654,25984,26273,26854,27141,27782,
28097,28629,28703,28771,30022,30239,30251,30929,31189,31331,
31819,   51,  410, 1290, 1793, 2315, 2809, 2923, 3328, 3683,
 3865, 6082, 6191, 6623, 6753, 6822, 6982, 8187, 8297, 8405,
 8471, 8833, 9947,10191,10423,10642,10752,11038,12700,13011,
13026,13977,14152,14322,15969,16208,16728,16975,17595,17803,
18355,18507,19431,19740,20204,20857,21001,21061,22036,22167,
22282,22526,23331,23837,23913,24131,24496,24613,25167,25540,
25625,25658,26721,27609,27895,28131,28151,28175,29381,29419,
29515,31621,31636,31792,31966, 1552, 1618, 1885, 3535, 4358,
 4826, 5231, 5844, 6482, 7309, 8005, 8121, 8320, 8668,10437,
10566,10892,11171,12117,12556,12792,13117,13491,13825,15259,
15624,15992,17009,17910,18078,18685,19029,19392,19401,19886,
20033,20198,21183,21222,21700,21821,22852,23056,23076,23287,
25108,25364,26387,27549,27867,28067,28082,28614,29073,29408,
29626,30068,30189,30465,30540,31074,  491,  642, 1865, 3462,
 3909, 4073, 4142, 4159, 4322, 4610, 6003, 6531, 6548, 7333,
 7804, 8460, 8912, 9682, 9705,10103,10393,10604,11259,12581,
12979,14088,14239,15122,15504,16512,16715,17026,17346,17951,
17985,19109,20236,22685,22787,23668,23695,24413,24470,24685,
26751,26836,29800,30534,31451,31543,   46,  542,  629, 1189,
 1247, 1870, 2071, 2790, 3124, 3483, 4470, 4651, 5147, 5321,
 5526, 5686, 5831, 6055, 6361, 6667, 6685, 7218, 7918, 8291,
 8996, 9117, 9701,10213,10227,10816,10829,11606,11714,12913,
13336,13451,13700,13840,13907,14022,14052,14110,14806,14910,
15271,15781,16144,17160,17188,17400,17631,17698,18008,18151,
19416,19635,20793,20892,21093,21228,21458,21751,22514,22562,
22803,22913,22952,24478,25417,25476,25503,25756,25774,26624,
26639,26893,26977,27077,27804,27859,28035,28721,29126,29642,
29652,29773,29888,30790,30952,31218,31763,  200,  598,  657,
 1351, 1491, 1655, 1975, 2376, 2991, 3793, 4044, 4682, 5125,
 5820, 5985, 6042, 6594, 7605, 7752, 8033, 8765, 8976, 9141,
 9565,10324,11002,11058,11284,12053,12144,12615,13179,13404,
13551,13781,14732,14942,14985,15002,15087,15284,15302,15457,
15554,16171,16249,16378,17918,18755,19041,19103,19204,19317,
20813,21212,21512,21642,21907,22124,23254,23751,23763,23775,
24264,24446,24531,24593,25084,26440,26998,27341,27967,28111,
28283,29004,29039,29731,29916,30817,31243,31398,31514,  120,
 1094, 2021, 2136, 2467, 2719, 4646, 5117, 5214, 5571, 5919,
 6873, 7390, 7971, 8011, 8838, 8938, 9545,10651,11205,11617,
12215,12398,13159,13873,14651,15520,15892,17577,18321,19723,
20450,20788,21464,21585,21792,23002,23351,24315,25186,25205,
26610,26716,26936,28073,28339,28485,29482,29780,29906,29976,
30493,31747,  335,  549, 1208, 1261, 1614, 2702, 3232, 3282,
 3763, 3971, 4287, 4305, 4697, 4769, 5458, 6162, 6393, 6618,
 7730, 8276, 8520, 8561, 8738, 9113, 9823,10194,11466,13412,
13567,15692,15871,16099,16341,16577,16903,17239,17317,17413,
17775,17810,17948,18172,18286,18307,18844,18967,21150,22002,
22288,24004,24035,24334,24779,24919,25062,25976,26192,26395,
26468,27481,28166,29853,30034,30090,30384,31163,31385,31910,
   32,  131, 1179, 1197, 1732, 2207, 2450, 2751, 2806, 3143,
 4136, 4917, 5995, 6464, 6472, 7297, 7315, 7522, 7600, 7691,
 8222, 8495, 8581, 8894, 9109, 9923,10216,10573,10657,11105,
11262,11291,11762,12688,12945,13473,13899,15209,15391,15632,
15943,16779,17871,18628,18731,18787,19477,20230,21071,21238,
21552,21767,21919,22137,22379,22556,22629,22733,24042,24641,
25005,25471,26149,26243,26503,27963,28103,28568,28642,28923,
28931,29254,29399,29425,29584,30594,31018,31228,31249,31882,
 1549, 1585, 1666, 2500, 2585, 2977, 3863, 4090, 4373, 4906,
 5134, 5247, 6600, 7055, 7252, 7418, 7424, 7704, 7953, 8492,
 8656, 9152, 9902,11370,11936,12290,12372,13082,13155,13740,
13764,14074,14081,14544,14637,14715,14872,15180,15794,15990,
16415,16721,17253,17417,17549,17780,17895,18098,18106,18634,
18857,19257,19471,19517,19537,19673,20031,20126,20748,23079,
23732,23820,23959,24137,24295,24498,24963,25297,25421,25642,
25961,26901,27037,27122,27133,27544,27925,28142,29517,29849,
30472,31117,31582,31700,   85,  100,  107,  399,  459,  489,
  544,  728,  802,  815, 1403, 1429, 1441, 1457, 1640, 1873,
 1981, 2039, 2081, 2119, 2239, 2250, 2322, 2345, 2520, 2649,
 2721, 2937, 2955, 2962, 2965, 2971, 3014, 3176, 3456, 3485,
 3555, 3604, 3697, 3702, 3714, 3724, 3769, 3994, 4005, 4123,
 4169, 4190, 4232, 4245, 4535, 4621, 4747, 4832, 4847, 4861,
 4871, 5027, 5201, 5277, 5431, 5442, 5504, 5529, 5618, 5642,
 5881, 5983, 5988, 6228, 6244, 6256, 6761, 6800, 6918, 6934,
 6938, 6958, 7019, 7075, 7179, 7240, 7395, 7594, 7734, 7940,
 8070, 8141, 8167, 8365, 8374, 8499, 8594, 8794, 8853, 9050,
 9119, 9219, 9229, 9291, 9380, 9531, 9559, 9636, 9669, 9935,
10012,10028,10039,10066,10071,10087,10106,10333,10391,10432,
10479,10498,10570,10633,10789,10798,10804,10858,10889,11026,
11033,11237,11390,11404,11442,11526,11641,11662,11666,11722,
11752,11783,11818,11845,11876,11956,12030,12254,12312,12316,
12443,12488,12542,12619,12711,12727,13133,13266,13313,13341,
13482,13652,13747,13773,13944,14057,14146,14163,14365,14474,
14647,14800,14820,14914,15009,15060,15238,15261,15321,15334,
15575,15671,15996,16026,16036,16044,16080,16091,16197,16262,
16405,16422,16468,16558,16731,16765,16811,17110,17289,17436,
17472,17671,17937,17953,17977,18018,18180,18264,18377,18396,
18550,18558,18574,18657,18679,18697,18707,18717,18737,19027,
19418,19458,19504,19522,19911,20003,20117,20131,20180,20191,
20209,20215,20277,20358,20590,20652,20671,20684,20836,21016,
21197,21249,21325,21332,21447,21477,21546,21771,21953,22010,
22038,22102,22106,22140,22164,22215,22591,22700,22726,22797,
22805,22903,22938,23050,23088,23135,23319,23333,23395,23493,
23533,23548,23562,23618,23624,23636,23642,23846,24083,24356,
24544,24636,24672,24886,24902,24983,25002,25031,25048,25160,
25210,25372,25500,25549,25746,25803,25862,25922,25969,26058,
26065,26182,26271,26349,26365,26424,26554,26597,26842,26905,
27112,27180,27293,27461,27491,27595,27716,27863,27936,28043,
28503,28633,28715,28766,28802,28918,28938,28945,29045,29091,
29219,29242,29261,29275,29305,29414,29597,29721,29926,30008,
30020,30056,30076,30223,30292,30352,30398,30529,30571,30619,
30680,30792,31048,31127,31152,31232,31329,31517,31586,31604,
31619,31648,31759,31845,32016,32023,   60,  137,  413,  454,
  857,  965, 1171, 1191, 1277, 1478, 1589, 1795, 2004, 2267,
 2413, 2689, 2891, 2993, 3018, 3113, 3122, 3595, 3777, 4559,
 4695, 5093, 5524, 5535, 5573, 5658, 5778, 5856, 6098, 6309,
 6984, 7165, 7250, 7304, 7352, 7385, 7518, 7720, 7845, 7907,
 8583, 8797, 9465, 9800,10123,10871,10894,10947,11348,11355,
11437,11648,12301,12379,12977,13016,13173,13394,13414,13543,
13858,13923,14154,14180,14221,14285,14654,14697,15188,15234,
15468,15510,15749,16076,16094,16210,16642,16717,16755,16933,
16965,17016,17020,17118,17496,17710,17739,17805,18156,18432,
19010,19243,19248,19282,19358,19363,19486,19498,19591,19643,
19793,19918,20234,20261,20282,20577,20884,21052,21349,21557,
21889,21899,22161,22956,23169,23346,23392,23673,23693,24476,
24819,24825,25305,25619,25839,26045,26339,26402,26511,26775,
27205,27310,27366,27600,27798,27897,27953,28113,28425,28645,
28705,29677,29891,29984,30148,30230,30308,30390,30478,30497,
31067,31161,31377,31597,31610,  384,  480, 1073, 1296, 1561,
 1688, 1730, 1821, 1931, 1956, 2177, 2543, 2555, 2766, 2819,
 3031, 3189, 3582, 4104, 4226, 4320, 4474, 4675, 5006, 5413,
 5682, 5847, 5902, 5976, 6020, 6057, 6452, 6533, 6572, 6846,
 7029, 7053, 7311, 7348, 8001, 8023, 8123, 8522, 8542, 8670,
 8681, 8728, 9161, 9296, 9328, 9745,10274,10708,10823,10985,
11107,11613,12113,12164,12531,12561,12993,13065,13162,13194,
13695,13721,14305,14326,14438,15124,15305,15488,15604,15630,
15655,15910,16142,16247,16361,16649,16988,17007,17145,17150,
17696,18460,18473,18509,18725,19141,19737,19790,19970,20776,
20852,20897,21145,21201,21275,21454,21608,21631,21982,22477,
22575,22620,22662,22695,23121,23265,23293,23338,23465,23578,
23710,23898,24415,24425,24513,24601,24643,24712,25367,25567,
25686,25795,26039,26207,26607,26697,26759,26883,27162,27555,
27584,27711,27869,28255,28267,28371,28382,28494,28887,29186,
29533,29809,29832,30016,30187,30447,30758,30782,30805,30838,
31014,31054,31252,31501,31558,31880,31962,   44,  256,  781,
  928, 1941, 2846, 3310, 4252, 6301, 7366, 7514, 8076, 8160,
 8485, 9178, 9707, 9919, 9956,10033,10044,10060,11181,12584,
13028,13102,14433,14536,15399,16242,16541,16590,16862,17322,
17765,17812,19082,20218,20840,23367,23589,23859,23927,24010,
24849,25316,25589,26026,26325,26368,26740,27579,28863,29330,
30847,31109,31237,  720, 1876, 1992, 3086, 3546, 5730, 6218,
 6614, 7649, 7800, 8914, 9260, 9437, 9503, 9543,11965,12021,
13687,13849,15035,16331,16706,17228,17298,17601,18056,18480,
18518,19884,20614,21385,21427,21590,21926,22349,24358,24581,
24648,25243,28245,28262,29100,29855,30278,31731, 1062, 2425,
 2632, 3513, 3848, 4722, 6151, 6779, 8013, 8954,10832,11346,
12936,13904,15023,15760,16152,16610,20689,21664,22318,24114,
24125,24678,28279,28299,29456,31262,31449,31507,  321, 1052,
 2209, 3094, 3904, 5158, 5262, 6620, 8611, 9497,10309,12242,
12320,12602,12729,13059,16407,18361,19647,19721,21130,22554,
22808,22987,25064,25272,25889,27994,30449,  227, 3138, 4433,
 6369, 7108, 7397, 8665,11330,13009,13167,14904,17350,18084,
18405,18687,20182,20483,21379,21612,25074,25929,27212,27382,
28929,29258,29320,29861,29961,31702,   82,  340, 1701, 2241,
 3741, 5035, 6489, 6596, 7955, 8311, 8851, 9721,11870,13181,
14916,15118,15705,16752,18528,19137,21064,21624,22491,23460,
23875,24096,24781,26470,26730,28962,29968,31985, 1033, 1375,
 3108, 3216, 3790, 5252, 5862, 6156, 6840, 7426, 7793, 7892,
 8357, 9282,11018,13284,13402,14403,14753,15753,17041,17177,
19469,21596,21747,22430,23889,25828,27419,28356,28952,30750,
31105,  637,  813, 4350, 4631, 5043, 5701, 7260, 8888, 9165,
 9825,10180,12374,12385,13875,15267,15715,18398,18576,18641,
20202,21720,23679,24047,24821,25678,27329,27428,28318,28348,
28814,29880,31337,31416,  730, 1413, 2788, 3267, 6387, 7335,
 7621, 7904, 8845,10368,10421,10579,10723,11528,11576,12698,
12947,13255,13702,14251,16010,19148,19291,19356,19975,20442,
20465,20629,20933,22566,23632,24336,26509,27131,27271,27339,
27754,28328,30388,30392,30803,31580,31713,  247,  596, 1459,
 1503, 1948, 2254, 3346, 3564, 3927, 3992, 4066, 4684, 5011,
 5869, 5886, 6757, 7186, 7360, 8129, 8883, 9831,10101,10880,
11241,11864,11983,12115,12169,12332,13189,14122,14549,14705,
15049,15841,15955,16002,16644,17237,17579,17722,18542,18873,
19403,21080,21950,22304,22907,23114,23171,23283,23777,24147,
25192,25788,26194,26454,28257,28892,29015,30360,31020,    3,
   48,  204,  258,  264,  280,  289,  326,  510,  582,  613,
  879,  886,  908,  983, 1012, 1026, 1039, 1043, 1126, 1155,
 1256, 1282, 1302, 1547, 1624, 1644, 1804, 1863, 1883, 1961,
 1983, 2127, 2171, 2229, 2339, 2348, 2356, 2387, 2408, 2588,
 2604, 2623, 2661, 2727, 2967, 3022, 3230, 3288, 3379, 3396,
 3488, 3518, 3621, 3659, 3722, 3846, 3941, 4075, 4115, 4155,
 4177, 4224, 4272, 4324, 4431, 4468, 4552, 4767, 4880, 5049,
 5139, 5153, 5187, 5223, 5290, 5304, 5511, 5596, 5599, 5840,
 5858, 6205, 6391, 6419, 6458, 6468, 6755, 6824, 6868, 6928,
 6988, 7154, 7200, 7405, 7488, 7497, 7702, 7771, 7825, 7957,
 8029, 8177, 8400, 8411, 8451, 8599, 8650, 8700, 9094, 9127,
 9139, 9150, 9154, 9624, 9646, 9650, 9676, 9699, 9806, 9863,
 9882, 9949,10183,10196,10284,10326,10398,10468,10488,10505,
10510,10594,10649,10653,10714,10969,10983,11060,11148,11196,
11234,11247,11293,11301,11377,11552,11573,11650,11795,11850,
11929,11968,11992,12026,12259,12327,12403,12415,12515,12624,
12631,12749,12928,13024,13077,13109,13153,13307,13321,13762,
13790,13916,13948,14079,14101,14178,14216,14224,14233,14311,
14324,14448,14674,14702,14785,14796,14877,14922,15025,15248,
15367,15506,15579,15585,15612,15641,15789,16165,16191,16326,
16464,16736,16759,16822,17031,17216,17363,17394,17405,17545,
17629,17636,17668,17675,17715,17733,17873,17878,17946,18091,
18135,18292,18312,18357,18403,18445,18556,18689,18727,18772,
18853,18895,19033,19058,19143,19216,19230,19464,19513,19625,
19637,19645,19684,19746,19888,19902,20121,20128,20288,20293,
20304,20435,20448,20739,20755,20772,20786,20802,20943,20974,
21067,21128,21175,21181,21226,21242,21269,21344,21520,21666,
21723,21740,21781,21797,21806,22006,22016,22084,22132,22149,
22220,22313,22484,22656,22672,22751,22771,23008,23109,23240,
23246,23296,23372,23451,23567,23639,23720,23743,23861,24086,
24100,24108,24155,24430,24439,24517,24787,24992,25121,25213,
25237,25362,25390,25413,25423,25440,25478,25483,25579,25689,
25701,26008,26115,26144,26184,26225,26252,26332,26429,26572,
26810,26849,26903,27015,27030,27124,27143,27151,27167,27217,
27295,27302,27348,27476,27566,27588,27689,27751,27806,27885,
27910,28004,28095,28153,28161,28231,28247,28275,28487,28620,
28626,28723,28742,28943,29245,29384,29440,29502,29537,29595,
29620,29636,29665,29673,29682,29794,29901,30027,30036,30105,
30111,30184,30243,30274,30457,30617,30621,30728,30733,30768,
30859,30885,30939,30992,31159,31171,31178,31313,31599,31634,
31738,31742,31949,  475,  926,  989,  996, 1388, 1661, 1825,
 2034, 2180, 2572, 2899, 3411, 3578, 4149, 4569, 4618, 4644,
 4735, 4908, 5531, 5807, 5854, 6484, 6540, 6669, 6844, 6913,
 7255, 7313, 7898, 7976, 8113, 8289, 8295, 8393, 8524, 8898,
 9439, 9833, 9872,10241,10607,10959,10965,11220,12001,12108,
12293,12400,12716,12966,13125,13147,13272,13366,13786,13798,
14751,14808,14824,15132,15269,15282,15295,15445,15814,16289,
16555,16623,16785,16793,16922,17574,17625,17920,18924,19287,
19437,19542,19699,19941,20057,20490,20763,21381,21811,22114,
22712,23070,23467,23497,23620,24206,24250,24542,24874,25009,
25035,25165,25270,25318,25570,25934,26023,26152,26256,26796,
26881,26926,26946,27607,27762,28119,28900,29032,29047,29158,
29203,29302,29509,29612,31129,31220,31462,31721,31995,  223,
  304,  330,  462,  826,  930, 1563, 2427, 2630, 2743, 2883,
 3079, 3098, 3174, 3476, 3524, 3610, 4363, 4420, 4919, 5272,
 5392, 6067, 6116, 6189, 6359, 6366, 6466, 6820, 6976, 7188,
 7216, 7999, 8740, 8965, 9033, 9115, 9617, 9653, 9795, 9938,
10144,10250,11448,11472,11747,11874,13004,13177,13397,13662,
13670,13912,14635,14789,14855,14908,15097,15243,15413,15687,
15774,16339,16413,16572,16772,17091,17419,18369,18625,18645,
18655,18723,19269,19429,19922,20048,20352,20392,20605,20830,
21334,21775,21842,22203,22245,22422,22609,22735,22756,22967,
23150,23701,24714,24911,25087,25158,25656,25809,25945,25974,
26017,28181,28350,28483,29131,29188,29268,29410,30290,30372,
30546,30823,30867,31001,31107,31165,32014,  594, 1252, 2083,
 2651, 2736, 2838, 3166, 3304, 3427, 3758, 4085, 4256, 4484,
 4548, 4895, 5095, 5519, 5818, 6017, 6856, 7192, 7556, 7916,
 8078, 8528, 8787, 8877, 9024, 9046, 9143, 9610,10078,10113,
10299,10473,10821,11145,11164,11961,11980,12012,12231,12377,
12874,13291,13329,13442,13742,14350,15013,15683,15957,16101,
16231,16743,16826,16969,17527,18954,19511,19689,19873,20361,
20588,20838,21370,21445,21961,22047,22568,22859,22894,22911,
23522,24061,24229,24465,24504,24836,24880,24921,24988,25492,
26310,26431,26615,26655,26899,27706,27854,27980,28124,28499,
28667,29041,29293,29466,29821,30367,30586,30653,30832,31201,
31339,31572,  776,  811, 1030, 1075, 1096, 1199, 1300, 1398,
 1554, 1779, 2144, 2192, 2435, 3664, 5019, 5417, 5452, 6445,
 7073, 7830, 8396, 8750, 9561,10233,10410,11859,12502,12548,
12704,12798,13734,13792,14070,14277,14682,15371,16048,16204,
16466,16475,16831,17137,17567,17773,18082,18823,19133,19607,
19659,20511,20664,21507,22173,23063,23162,23442,23765,24583,
25432,25766,26012,26180,26245,26264,26773,27400,27483,27652,
27793,28333,28947,29095,29568,29963,30061,30665,30688,30797,
31425,  285,  680, 1814, 2941, 3342, 4667, 5283, 5591, 5620,
 5688, 6153, 6759, 7161, 8919, 9925,11044,11222,11275,12059,
12879,13704,14020,14062,14609,15044,15085,15264,15600,15940,
16456,17616,17824,17880,17935,17940,18392,19649,19677,19833,
20184,20655,21466,22309,22409,22658,22930,23128,23195,23616,
24021,24900,25444,25600,26076,26507,26955,27702,28576,28925,
29878,30740,31367,31925,31990,32021,32034,  408,  609,  650,
  877, 2757, 3275, 3694, 3783, 3989, 4001, 4112, 4188, 5075,
 5506, 5898, 6024, 6336, 7493, 7520, 8136, 8265, 8420, 8532,
 8570, 9132, 9278, 9443,10288,11187,11578,11586,11619,11712,
13453,13565,13775,14036,14460,14888,15202,16251,16999,17011,
17112,17152,18280,18486,18739,18969,19785,19998,20207,20622,
20631,20790,21264,22147,22403,22516,24269,24615,24666,24866,
25939,26413,26533,26612,27326,27390,27918,28480,29088,29213,
29338,29647,31343,31503,   69,  891,  910, 1024, 1675, 2023,
 2064, 2203, 2223, 2331, 2700, 3145, 3202, 3511, 3959, 4648,
 4653, 4774, 5491, 6544, 6581, 7184, 7369, 7623, 8155,10020,
10237,10756,10885,11646,11754,12348,12769,12911,13363,13726,
14528,14551,15140,15422,16354,16374,17048,17513,18375,18537,
19097,20514,20560,21567,22361,23074,23753,23877,24700,24925,
25585,26085,26347,26851,26981,27088,27107,27505,27551,27766,
28810,28875,29142,29423,29782,30404,30682,30819,32004,  105,
  230,  974, 1045, 1501, 1545, 2132, 2612, 4247, 4911, 4957,
 5142, 5773, 5842, 6303, 6423, 7010, 7057, 7147, 7603, 8125,
 9243, 9358, 9377, 9678,10068,10848,11093,11431,11599,12033,
12103,12447,12554,12597,12900,13659,13778,14097,15709,16225,
16654,17251,17287,17784,18096,18250,18309,19344,19405,19602,
19715,20070,20616,21437,21601,21708,22494,22573,22577,23010,
23289,24129,24579,25459,26828,27115,28243,28647,29327,29504,
29638,31307,31432,  165,  625, 1304, 1577, 1786, 2114, 2848,
 3690, 3752, 3938, 4121, 5218, 5249, 5767, 6080, 6164, 6441,
 7133, 7262, 7269, 7757, 7888, 8286, 8770, 8929, 9064, 9476,
 9533, 9622,10330,10485,11208,11375,12248,12675,12782,12999,
13502,14307,14862,15130,15829,16428,17411,17677,17778,18122,
18304,18332,18451,19169,20467,21018,21351,21610,21702,21725,
22730,22976,23328,23541,24025,24030,24494,25106,25419,26779,
27011,27564,28326,29343,30151,30386,30635,30947,31032,31056,
31196,31834,31999,   58,  386,  794, 1571, 1994, 2444, 2593,
 2621, 3911, 4061, 4174, 5115, 5660, 5990, 6278, 6295, 6645,
 7006, 7034, 7788, 8409, 8453, 8497, 8693, 9511, 9600,10222,
10575,12044,12123,12758,12995,15007,15594,15947,16053,16790,
16990,17107,17666,17694,18476,19633,19707,20001,20315,20488,
21059,21199,21312,21934,22280,22524,23192,23435,23722,24354,
24468,24533,24812,24823,24831,25887,26142,26213,26361,26576,
26593,26934,27267,27659,28002,28362,28833,29391,30011,30232,
30853,31646,31704,31754,  254,  484,  534,  864,  971, 1284,
 1415, 1507, 1646, 2538, 2615, 3104, 3389, 3652, 4316, 4562,
 4693, 4993, 5004, 5119, 5674, 5822, 6211, 6287, 6491, 6602,
 6923, 7124, 7139, 7152, 7242, 8195, 8676, 8758, 9221, 9555,
 9719,10014,10528,10596,11065,11097,11200,11243,11680,11730,
12240,12587,12690,12713,12827,12915,13324,13524,13832,13847,
14090,14137,14208,14259,14342,14990,15257,15286,15508,15658,
15690,15836,16158,16740,17043,17053,17724,18246,18371,18578,
18912,18934,19048,19089,19228,20757,20800,20971,20997,21522,
22406,22606,22618,23165,23851,24133,24204,24242,24804,24861,
25100,25346,25545,25644,25812,25852,25859,25982,26321,26355,
26392,27350,27411,27422,27686,28144,28187,28322,28461,28506,
28773,29250,29593,29690,29703,29790,30066,30237,30725,30735,
30773,31268,31304,31519,31908,31960,  109,  276,  429,  436,
  516,  732, 1021, 1041, 1153, 1270, 1367, 1663, 1776, 2067,
 2121, 2125, 2248, 2533, 2577, 2740, 2969, 3027, 3101, 3238,
 3350, 3707, 3761, 3786, 3973, 4046, 4300, 4435, 4478, 4633,
 4869, 4915, 5045, 5127, 5229, 5714, 5762, 5815, 5860, 6029,
 6363, 6417, 6433, 6728, 7420, 7549, 7586, 7592, 7718, 7823,
 7873, 7989, 8031, 8087, 8118, 8381, 8475, 8514, 8698, 8782,
 8849, 9097, 9101, 9371, 9714, 9888,10089,10186,10265,10582,
10618,10783,10863,10882,10896,11023,11136,11271,11550,11610,
11635,11785,11918,11958,11999,12132,12162,12338,12370,12390,
12642,13280,13377,13539,13580,13691,13783,13938,14049,14274,
14367,14493,15037,15191,15360,15425,15801,15873,15903,16008,
16089,16255,16365,16369,16388,16459,16520,16787,16804,17163,
17315,17332,17561,17608,17762,17790,18021,18188,18639,18875,
18887,18926,19253,19502,19546,19557,19586,19848,20253,20268,
20500,20549,20766,20795,20834,20966,20976,21069,21154,21282,
21560,21808,21970,22045,22094,22369,22482,22581,22890,22901,
22915,23500,23651,23676,23708,23952,24193,24209,24297,24454,
24789,25370,25800,25865,26146,26452,26497,26813,27099,27153,
27368,27377,27478,27526,27723,27769,28281,28366,28537,28545,
28631,28816,28912,28999,29078,29622,29667,29990,30025,30029,
30107,30287,30294,30364,30418,30499,30573,30784,31063,31216,
31612,    5,  501, 1436, 1467, 2211, 2219, 3492, 3806, 3841,
 4082, 4098, 5323, 5679, 5917, 7449, 7574, 7913, 8991, 9072,
 9420, 9942,11365,12408,12425,13315,13456,14218,14247,14295,
14332,14649,15662,15695,16719,18013,18468,18900,19534,20088,
20245,20300,20890,21644,22486,22875,23046,23664,23921,24008,
24056,24139,24309,24854,25277,25403,27023,28037,28115,28297,
28330,28744,28836,30078,30794,31347,31628,31707,31779,31964,
   79, 2182, 2365, 2904, 3370, 4680, 4759, 6384, 7195, 7818,
 8747, 9491, 9656, 9687,10341,11757,11907,13769,14045,14165,
14564,15250,15437,16128,16435,17730,18001,18342,18908,19052,
19135,19814,20029,20404,20457,21054,21653,22008,22994,23582,
23698,24153,24876,25505,25682,26313,26351,27032,27678,27691,
28277,29071,29764,30162,30954,31209,  616, 2073, 3225, 3312,
 3584, 3670, 3925, 4750, 5155, 5794, 6570, 6964, 6990, 7043,
 7129, 7220, 8353, 8448, 8875,10053,10125,10495,10568,11824,
15389,18076,18745,18782,19018,19527,19983,20046,21964,22129,
22183,22242,23233,23557,24094,24977,25751,26035,26370,26749,
26948,27165,27586,28341,28419,29671,30999,31885,32018,   18,
  631,  664, 3362, 4526, 5021, 5041, 5396, 5472, 6590, 6831,
 7635, 7880, 9619, 9644,10085,11532,12544,12696,12837,13485,
13738,14320,14612,14979,15028,15783,16277,17389,17558,17962,
18649,20661,20746,20811,21978,24033,24847,25449,25577,26062,
26719,27665,28273,29998,30538,30815,30849,31745,31987,32007,
  353,  723, 1173, 1185, 1616, 1925, 2053, 2269, 2798, 2897,
 2995, 3164, 3339, 3405, 4472, 4540, 4804, 4891, 4930, 5264,
 6474, 7171, 8367, 9366, 9539, 9547, 9798,10203,10454,10795,
10807,10818,11068,12627,12679,12952,12958,13951,14348,14363,
15019,15319,15567,15653,15779,16410,16575,16708,17782,17875,
19111,19540,19652,19742,19820,20677,21413,22018,22104,22528,
23454,23716,23931,23972,24255,24266,25303,25436,25473,26041,
26188,26329,27786,27876,28861,28868,29226,29347,29471,30276,
30745,30780,30981,   22,  333,  346,  393,  452,  689,  705,
  875, 1177, 1359, 1446, 1450, 1489, 1505, 1573, 1592, 1653,
 1759, 1827, 2129, 2166, 2199, 2205, 2272, 2378, 2453, 2553,
 2723, 2771, 2811, 2817, 2827, 2885, 2925, 2944, 3207, 3317,
 3375, 3464, 3470, 3551, 3867, 3871, 3901, 4042, 4161, 4179,
 4195, 4458, 4686, 4815, 4897, 4954, 5015, 5029, 5137, 5270,
 5447, 5478, 5883, 5891, 5913, 5926, 5968, 5981, 6038, 6059,
 6070, 6093, 6100, 6113, 6269, 6405, 6425, 6438, 6743, 6775,
 6884, 6944, 7208, 7238, 7534, 7546, 7615, 7644, 7744, 7774,
 7802, 7876, 7890, 7902, 8139, 8143, 8198, 8226, 8301, 8343,
 8361, 8469, 8518, 8703, 8731, 8767, 8778, 9054, 9231, 9253,
 9266, 9317, 9518, 9524, 9666, 9674, 9728, 9759, 9763, 9900,
10007,10062,10128,10189,10268,10418,10503,10599,10668,10699,
10718,10836,10962,11047,11189,11224,11231,11264,11282,11295,
11332,11362,11469,11589,11643,11669,11733,11990,12105,12166,
12318,12334,12367,12417,12552,12732,12865,12964,12969,13007,
13084,13095,13165,13305,13327,13361,13444,13461,13489,13493,
13560,13603,13667,13788,13864,13901,14030,14291,14298,14339,
14353,14507,14626,14883,14900,14933,14983,15105,15120,15280,
15327,15369,15626,16019,16023,16031,16041,16180,16189,16337,
16343,16479,16632,16745,17002,17051,17057,17143,17155,17186,
17230,17301,17306,17312,17396,17510,17623,17735,17746,17796,
17979,18010,18158,18302,18325,18337,18367,18401,18482,18489,
18759,18764,18829,18892,18962,19074,19107,19172,19222,19315,
19398,19426,19448,19666,19670,19871,19927,19987,20099,20196,
20286,20381,20408,20687,20701,20928,21206,21224,21240,21280,
21339,21363,21422,21425,21598,21705,21737,21762,21847,21861,
21924,22014,22021,22026,22097,22135,22151,22159,22372,22419,
22468,22507,22779,22897,22954,22991,23013,23133,23152,23174,
23252,23270,23278,23544,23554,23671,23703,23873,23880,24079,
24091,24157,24328,24427,24585,24742,24985,24990,25007,25096,
25203,25274,25381,25446,25728,25744,25785,25797,25807,25823,
25931,26219,26397,26434,26442,26649,26653,26693,26761,26929,
27000,27045,27129,27160,27210,27273,27361,27380,27700,27906,
27934,27940,27965,28041,28058,28092,28191,28377,28685,28689,
28740,28871,28905,29037,29043,29107,29205,29210,29308,29336,
29463,29605,29624,29684,29706,29825,29851,29903,29924,30004,
30049,30074,30157,30247,30310,30445,30452,30475,30567,30876,
31124,31133,31375,31447,31493,31578,31632,31683,31723,31736,
31761,31800,31968, 1010, 1480, 1797, 2641, 3228, 3558, 4672,
 5066, 5151, 5424, 6044, 6739, 6871, 7750, 7790, 8210, 8462,
 8988, 9083,10037,10439,10763,11193,11625,12246,12983,13891,
14064,14072,14665,15571,16453,16781,16853,17563,18093,19069,
19781,20886,21123,21718,22924,22946,23112,24722,25119,25963,
26466,26891,27861,28121,29586,29726,31187,31230,  427,  547,
  669, 1193, 1542, 2947, 3537, 4259, 6456, 7961, 8115, 8530,
 8563,10209,10917,11036,11830,12261,12572,13383,14617,14694,
14950,15454,15676,16376,17340,17862,18271,19701,20586,20999,
21449,21626,22668,22741,23257,23756,24259,24481,24783,25376,
25956,26230,27972,28197,28264,28663,29133,29452,30339,30357,
31203,31222,31740,  208,  640,  700, 1280, 1373, 1679, 1790,
 3608, 4270, 5576, 5646, 6065, 6586, 6673, 6749, 6848, 8735,
 8805, 9337, 9350, 9818,10099,10370,11217,11461,12536,13183,
13400,13638,14678,15386,15807,15825,16227,16269,17328,17998,
18972,19968,20259,22191,22272,22688,22909,23143,24419,24485,
24704,24851,25294,27288,27523,27528,29112,30058,31022,  152,
  769, 1230, 1263, 1954, 3956, 4329, 4639, 4902, 5033, 5274,
 5302, 5485, 6878, 7530, 7693, 9262, 9322, 9499,10682,10712,
11583,11628,11675,13867,14077,14601,14710,15890,16352,16625,
17060,17584,17768,18142,18705,18819,18921,19338,19920,20377,
22792,23574,23934,24437,24827,25163,26979,27220,28369,28909,
29994,30215,30420,30776,31817, 1238, 1537, 1630, 2350, 2524,
 6915, 7323, 7414, 8100, 8183, 8355, 8994,10430,11491,11548,
12686,13532,13749,14446,15137,15820,16058,16897,16910,16925,
17994,19263,19439,19904,20386,21267,21783,22354,23298,23917,
24932,25114,25442,26132,26416,26438,26944,27371,27694,28448,
28616,28960,29717,29841,30205,31400,31541,31691,31715,31919,
31947,  122,  441,  587,  800,  901, 1878, 2496, 2795, 3092,
 3737, 4656, 4807, 4936, 5377, 6529, 7021, 7882, 8790, 9479,
10435,10827,12221,12329,12810,12938,13835,14126,14734,15496,
15598,16833,16843,17426,17482,17515,17700,17932,19060,19121,
19488,20744,20750,20827,21622,21994,22857,23043,23199,23310,
23827,24149,24515,25174,25222,25425,25780,25877,25924,27735,
28033,28320,30000,30463,30560,31383,  102,  212, 2048, 2134,
 2599, 2957, 3193, 3687, 3720, 3919, 4192, 4529, 5436, 5608,
 5829, 5977, 7116, 8785, 9028, 9250, 9648,10867,10971,12038,
12119,12636,13067,14168,14620,14669,15290,15427,15747,15876,
16136,16292,16776,17211,18064,18148,18948,18965,19039,19080,
19691,19931,20241,20272,20324,20582,21576,21756,21921,21931,
23359,23474,25455,25891,26327,26343,26499,26580,26601,26895,
26914,27184,27709,28045,28573,28701,29030,29313,29489,30495,
30662,30834,30865,31119,31198,31459,31687,31749,31912,  219,
  431,  529,  905, 1220, 1419, 1497, 1997, 3222, 3234, 3320,
 3325, 3473, 3650, 3771, 4134, 4293, 4509, 4741, 5240, 6986,
 6999, 7524, 8038, 9300, 9851,10131,10146,10307,10775,10850,
11179,12064,12340,12949,13217,13587,14018,14120,14243,14498,
14607,14748,15224,15409,15959,16748,17908,18199,19482,19805,
20228,20820,20859,20954,21647,21659,22176,22552,22724,23249,
23730,23835,24237,24388,24502,25285,25409,26073,26449,27388,
27621,28458,28556,28635,29284,29377,29768,30608,30650,30977,
31453,31978,  273,  675, 1050, 1212, 1817, 1841, 2059, 2504,
 3306, 3407, 4237, 4581, 4689, 5585, 5631, 5705, 6198, 6535,
 6813, 7511, 7810, 8021, 8282, 8840, 9471, 9551,10219,11203,
11571,12207,12499,12786,13119,13465,13919,14463,14920,15015,
15853,16763,17247,17359,17830,17923,18068,18252,18940,19798,
19879,20027,20102,20213,20306,20545,20995,21327,22776,22789,
23374,24102,24161,24691,24808,24844,24857,25349,25621,26160,
26383,27407,27539,27591,27725,27991,28478,28858,29010,29075,
29388,29449,29599,31241,31333,   71,  139,  158,  245,  266,
  302,  498,  611,  655,  697,  783,  796,  807,  967, 1017,
 1057, 1099, 1273, 1317, 1396, 1409, 1583, 1620, 1754, 1833,
 1964, 2028, 2036, 2043, 2246, 2307, 2335, 2390, 2404, 2462,
 2509, 2609, 2729, 2760, 2852, 2910, 2929, 2975, 3088, 3130,
 3153, 3334, 3398, 3481, 3508, 3520, 3574, 3587, 3788, 3795,
 3812, 3885, 3895, 4050, 4058, 4069, 4127, 4140, 4164, 4365,
 4379, 4425, 4476, 4482, 4502, 4515, 4537, 4574, 4659, 4733,
 4820, 4834, 4948, 5086, 5306, 5342, 5386, 5401, 5411, 5709,
 5719, 5782, 5803, 5826, 5834, 5923, 5962, 6009, 6096, 6185,
 6240, 6254, 6271, 6281, 6353, 6372, 6399, 6415, 6574, 6642,
 6661, 6789, 6874, 6978, 7002, 7051, 7111, 7157, 7204, 7299,
 7441, 7569, 7581, 7627, 7651, 7816, 7920, 7925, 7932, 7973,
 8388, 8482, 8505, 8509, 8534, 8556, 8572, 8596, 8642, 8719,
 8908, 8936, 8985, 9052, 9077, 9122, 9234, 9237, 9304, 9340,
 9362, 9374, 9449, 9487, 9754, 9793, 9829, 9843, 9915, 9928,
10048,10083,10193,10224,10444,10447,10481,10655,10678,10721,
10787,10907,10945,10951,10991,11007,11087,11150,11255,11338,
11352,11406,11464,11563,11581,11604,11630,11751,11806,11832,
11857,12111,12196,12288,12314,12322,12351,12393,12420,12430,
12570,12640,12693,12709,12718,12775,12784,12822,12893,12918,
12922,12986,13127,13204,13213,13338,13387,13440,13515,13664,
13717,13842,13877,13925,13957,14086,14213,14422,14450,14624,
14713,14719,14738,14802,14850,14867,14917,15073,15082,15240,
15331,15610,15643,15672,15717,15776,15787,15797,15859,15896,
15900,16004,16061,16140,16169,16199,16347,16397,16420,16430,
16451,16562,16592,16596,16604,16617,16647,16799,16820,16961,
17100,17190,17241,17374,17407,17415,17477,17489,17501,17704,
17720,17727,17903,17971,18182,18192,18196,18242,18328,18347,
18544,18630,18659,18702,18752,18778,18834,18865,18978,19008,
19035,19094,19101,19127,19236,19280,19351,19411,19493,19551,
19828,19852,19890,19900,19980,20009,20106,20222,20225,20356,
20365,20425,20429,20440,20470,20481,20503,20566,20900,20961,
20981,21021,21027,21036,21043,21073,21141,21160,21202,21277,
21388,21442,21534,21550,21638,21698,21760,21941,21980,22049,
22138,22154,22165,22233,22236,22284,22386,22390,22394,22504,
22604,22681,22691,22703,22714,23068,23083,23125,23178,23244,
23291,23322,23355,23379,23385,23431,23507,23535,23734,23779,
23905,24002,24013,24040,24075,24252,24303,24313,24332,24411,
24509,24624,24663,24718,24726,24801,24829,25027,25061,25190,
25195,25224,25230,25247,25501,25551,25583,25650,25837,25856,
25867,25872,25949,26043,26125,26170,26211,26267,26359,26406,
26540,26570,26637,26708,26757,26798,26805,26820,26824,26886,
27008,27072,27102,27226,27277,27283,27308,27312,27489,27511,
27617,27655,27739,27957,27987,27997,28099,28240,28249,28260,
28270,28301,28310,28337,28359,28524,28539,28543,28609,28655,
28707,28752,28955,29024,29061,29118,29247,29273,29520,29582,
29609,29628,29660,29868,29890,29894,29971,30103,30109,30170,
30211,30263,30285,30426,30565,30604,30626,30676,30766,30945,
31042,31078,31122,31154,31176,31226,31318,31680,31696,31765,
31783,31841,31903,32001,  198,  444,  519, 1115, 1170, 1959,
 2161, 2394, 2562, 3191, 3533, 4554, 4905, 5316, 5653, 5792,
 6148, 6690, 6802, 6970, 7754, 8025, 8106, 8132, 8945, 9416,
10450,10662,11424,11837,11915,11985,12210,14300,14328,14440,
14755,14838,15066,15443,15500,16163,16471,17172,17494,17742,
17751,18170,18299,18693,19031,20446,20591,20957,21514,22224,
22590,22627,22737,23302,24224,24404,24441,25818,25927,26523,
26728,26983,27729,27789,27951,29286,29331,29574,30038,31359,
31372,31536,31596,31814,  919, 1742, 2002, 2278, 2398, 2517,
 2634, 2814, 3035, 3172, 3299, 4143, 5474, 5877, 6001, 6827,
 8708, 9048, 9217,10691,10707,11359,11402,11444,11952,12441,
12741,13349,14144,14744,15004,15184,15395,16322,16927,18664,
19725,19802,20473,21040,21336,21574,21604,22471,22998,24320,
24538,24683,25754,26198,26367,26782,27880,27984,28565,28637,
31073,31320,  844,  894, 1294, 3181, 4263, 4661, 5190, 5197,
 6350, 6769, 6797, 8608, 8658,10588,10812,11082,12007,12576,
12869,13506,14480,15089,15365,16175,16677,17193,17572,17826,
18862,19846,21909,21928,22029,22942,23942,24215,24961,25400,
27233,27777,28613,28727,28933,29679,29954,30922,31335,31589,
32028,  125,  145,  661,  678, 1215, 1859, 1887, 3073, 3540,
 5212, 5253, 5296, 5501, 6838, 7230, 7785, 8398, 8686, 8864,
 9422,10301,10611,11287,11536,11717,12174,12179,14182,15963,
16637,16725,17133,18103,18203,19600,21063,21216,21360,21668,
22763,22867,23478,23817,24285,26938,27649,27873,28135,28854,
29634,29921,31046,31603, 1364, 1609, 1657, 2889, 2984, 3775,
 3907, 4578, 5052, 5336, 6763, 6926, 7141, 7996, 8760, 9160,
 9504, 9904,11994,12396,12604,13090,13390,13449,13562,14458,
15039,15325,17128,17591,18713,19328,19822,20075,20493,20792,
20817,21185,22333,22812,23654,23974,24450,24890,25480,26834,
27385,28628,28850,29386,29815,29914,30178,30441,31391,31533,
   25,  221,  242, 1493, 2368, 2456, 2466, 2521, 2547, 3220,
 3946, 4036, 4052, 4375, 4490, 4499, 4505, 4532, 5540, 6375,
 6409, 6430, 7015, 7457, 7538, 7567, 7572, 7697, 8385, 8870,
 8924, 9035, 9468, 9835, 9944,10272,12738,12944,13074,13097,
13379,13527,13537,13959,13983,14660,15189,15293,15592,15639,
15847,16384,16394,16902,16906,16950,16986,18263,18459,18552,
18766,18952,19208,19616,20059,21137,21318,21401,22108,22340,
23156,23660,24281,24680,25070,25090,25556,25598,25845,26337,
26770,26918,26942,26986,26995,27148,28579,28681,29277,29788,
29907,30089,30218,30437,31423,31545,31555,31637,    1,  233,
  311,  473,  512,  580,  648,  741,  850, 1014, 1068, 1161,
 1298, 1312, 1384, 1440, 1944, 2154, 2169, 2231, 2238, 2310,
 2320, 2574, 3084, 3135, 3352, 3486, 3616, 3682, 3696, 3792,
 3933, 4146, 4343, 4422, 4519, 4545, 4609, 4665, 4817, 4828,
 5133, 5236, 5459, 5463, 5480, 5696, 5805, 6107, 6176, 6203,
 6265, 6436, 6538, 6550, 6866, 7104, 7224, 7438, 7584, 7646,
 7707, 7746, 7911, 7928, 8093, 8157, 8171, 8339, 8662, 8712,
 9089, 9135, 9271, 9381, 9693, 9810, 9989,10104,10279,10315,
10524,10585,10761,10977,11031,11206,11267,11813,11868,12035,
12346,12382,12491,12599,12614,12620,13270,13299,13714,13794,
13871,13940,13963,14235,14280,14430,14687,15063,15178,15213,
15272,15299,15476,15576,15905,16055,16073,16537,16581,16665,
16674,17006,17028,17169,17175,17295,17421,17691,17813,18048,
18176,18278,18306,18320,18464,18506,18633,18775,18784,19063,
19130,19434,19657,19718,19860,20018,20129,20370,20452,20651,
20864,20988,21396,21539,21554,21640,21662,21819,21913,21986,
22086,22188,22207,22518,22624,22786,22862,22885,23394,23504,
23512,23526,23762,23950,23964,24084,24397,24463,24738,24774,
24864,24915,24995,25076,25181,25255,25498,25662,25768,25802,
26067,26202,26248,26357,26426,26561,26705,26846,27304,27420,
27535,27746,27948,28084,28354,28430,28693,28710,28843,28865,
28890,29128,29149,29484,29651,29733,30064,30191,30268,30351,
30401,30432,30615,30722,30743,30862,31036,31549,31570,31630,
  147,  514, 1444, 2343, 3301, 3391, 3401, 3804, 4153, 4523,
 5001, 6086, 6411, 6804, 7135, 7164, 7499, 7640, 7806, 7987,
 8394, 8551, 8846, 9172, 9447, 9535, 9854,10215,10441,10513,
10685,10964,11056,11368,11743,12181,12213,12364,12721,12830,
13262,13392,13477,13548,14286,14453,14639,14842,14859,15114,
15607,15651,15678,15889,15950,16015,16359,16913,16930,17021,
17206,17713,17757,17928,18052,18354,19013,19394,20055,20077,
20187,20397,20455,20476,21356,21632,21813,22423,22536,22557,
22677,23147,23630,23637,23648,23768,23815,23939,24049,24106,
24452,24814,25590,25761,25772,25861,26801,27471,27888,27913,
27976,28252,28344,28527,28754,29243,29398,29507,30414,30467,
30501,30600,30690,30771,31149,31251,31324,31718,31752,   64,
   95,  308,  349,  684,  791, 1234, 1433, 1788, 2375, 2448,
 2506, 2742, 2997, 3116, 3156, 3218, 3522, 3936, 4620, 4752,
 5070, 5246, 5523, 5765, 6379, 6552, 6687, 6836, 6864, 7017,
 7236, 7564, 7653, 8069, 8081, 8723, 8756, 9494, 9548, 9627,
 9827,10040,10257,10666,10757,11596,11737,11852,11866,11996,
12097,12151,12436,13277,13545,13796,13838,14317,14331,14727,
14977,15473,15942,16579,16751,16846,16952,17159,18015,18475,
18684,18950,19072,19138,19304,19682,20035,20167,20309,20698,
20760,20894,21046,21606,21711,21753,21776,21843,22083,22319,
23295,23307,23326,23658,24220,24536,24913,25073,25542,25730,
26462,26574,26646,27097,27322,27393,27548,28146,28582,29003,
29089,29234,29493,29796,30298,30343,30366,30396,30873,   15,
   34,  471,  835,  980, 1064, 1080, 1109, 1157, 1224, 1386,
 1484, 1668, 1939, 2418, 3881, 4109, 4281, 4900, 5037, 5079,
 5595, 5813, 6234, 6487, 6501, 7341, 7576, 8645, 8874, 8922,
 9349, 9866,10266,10380,10533,10861,11104,11387,11569,11732,
11782,12563,12643,13151,13309,14162,14231,14501,15276,15590,
15647,16066,16668,17149,17547,17799,17975,18058,18462,18677,
18982,19311,19354,19623,19939,20109,20171,21195,21565,21656,
22358,22473,23377,24287,24390,24400,24647,24797,25067,25629,
25798,26177,26353,26970,27003,27796,28075,28496,28570,29295,
29431,29532,29694,29807,30761,31403, 1807, 1920, 2141, 2214,
 2902, 4446, 5059, 5120, 5130, 5205, 5257, 5582, 6817, 7317,
 7783, 7983, 7992, 8512, 8525, 9333,10413,10902,11261,11520,
11942,11970,12610,15374,15694,16084,16426,17964,18117,18522,
19275,19347,20025,20867,22157,22707,23345,23640,24351,24970,
25394,26049,26113,26128,27397,27749,27843,28468,29065,29156,
29265,29974,30788,31182,31297,31607,31641, 1673, 1774, 1781,
 1936, 3169, 3196, 4084, 4198, 6832, 6951, 7065, 7808, 8867,
 8972, 9268, 9538, 9801,11173,11415,13268,13599,13882,13949,
14657,14706,15602,15937,17474,17786,17869,18479,19705,20068,
20608,20849,22293,22310,22337,22758,23388,23678,23738,24099,
24231,25814,25832,25942,26723,27126,27337,27857,29020,30051,
31136,31435,31970,   56,  527,  606,  862, 2372, 2557, 2913,
 3660, 4551, 5108, 5648, 6145, 6215, 6930, 7835, 7905, 8501,
 8858, 9512, 9941,10119,10263,10400,10961,12771,13207,13553,
13710,14532,14539,14596,15210,15245,17568,18108,19020,19046,
19611,20680,20710,21261,21366,22184,22306,25493,25997,27156,
27328,27561,28451,28950,29006,30345,30774,31409,31810, 1737,
 2690, 2919, 3478, 3903, 3922, 5433, 5909, 6284, 6440, 7041,
 7181, 7779, 8015, 8215, 9176, 9484,10830,11227,13295,13967,
14553,16157,16792,16993,17331,18090,18185,18389,18449,19298,
20083,20624,21635,23180,23453,24071,24087,24244,24598,25024,
25094,25290,25692,26526,26625,27427,27679,27775,28482,29714,
30202,30306,30920,32031,   62,   83,  229,  295,  461,  507,
  715,  977, 1600, 1627, 1853, 2066, 2196, 2602, 2625, 2808,
 2907, 2926, 2949, 3273, 3940, 3978, 4117, 4240, 4454, 4487,
 4495, 4771, 4922, 5102, 5105, 5409, 5810, 5987, 6084, 6589,
 6767, 6842, 7113, 7138, 7896, 7935, 7952, 8258, 8391, 8417,
 8651, 8660, 9091, 9223, 9876, 9951,10000,10427,10496,10614,
10659,11017,11543,11767,11847,12032,12138,12146,12235,12295,
12625,12674,12877,12980,13080,13112,13334,14408,14662,14703,
14810,14835,14845,15288,15303,15377,15755,15984,16087,16220,
16448,16570,16870,17166,17344,17553,17605,17672,18020,18554,
18696,18883,18959,19114,19124,19233,19441,19524,19604,19639,
19744,19912,20389,20443,20513,20555,20603,20823,21218,21243,
21517,21765,21906,22042,22130,22298,22421,22769,22935,23189,
23234,23824,24104,24507,24651,24675,24693,24794,24924,25352,
25467,26084,26346,26372,26640,26940,27082,27507,27683,27767,
27802,28117,28138,28155,28194,28821,28856,28895,29571,29643,
29771,29785,29792,30259,30480,30686,30763,30870,30950,31757,
31789,31805,   49,  284,  324,  343,  546,  577,  588,  817,
  868,  924, 1047, 1104, 1184, 1405, 1455, 1463, 1558, 1699,
 1762, 1881, 2159, 2252, 2340, 2571, 2589, 2645, 2936, 2959,
 3024, 3203, 3338, 3372, 3425, 3460, 3568, 3576, 3667, 3718,
 4267, 4371, 4378, 4803, 5145, 5202, 5279, 5328, 5415, 5420,
 5509, 5579, 5597, 5636, 5661, 5867, 5872, 6076, 6112, 6222,
 6230, 6339, 6499, 6556, 7109, 7245, 7411, 7446, 7557, 7578,
 7596, 7737, 8072, 8109, 8287, 8544, 8795, 8959, 9126, 9259,
 9288, 9323, 9338, 9433, 9570, 9667, 9711, 9737,10126,10179,
10242,10331,10404,10490,10580,10676,10974,11049,11140,11276,
11492,11566,11668,11816,11931,12066,12131,12349,12359,12376,
12386,12534,12872,12973,12991,13087,13131,13148,13160,13316,
13475,13574,13866,14037,14105,14292,14417,14506,14526,14556,
14814,14818,14929,15559,15616,15686,15815,16050,16153,16224,
16519,16633,16671,16818,16842,16916,16938,17218,17235,17293,
17393,17507,17525,17767,18070,18132,18333,18341,18709,18858,
19293,19462,19500,19516,19857,19984,20312,20547,20611,20618,
20778,21078,21125,21407,21535,21582,22000,22033,22080,22217,
22317,22397,22548,22879,22957,22985,23006,23014,23107,23137,
23362,23471,24057,24064,24228,24274,24348,24386,24394,24670,
24809,24909,24978,25033,25046,25086,25209,25404,25426,25453,
25688,25702,26060,26070,26205,26209,26314,26410,26421,26659,
26736,26959,27100,27114,27159,27170,27221,27270,27402,27423,
27468,27525,27670,27848,28006,28159,28285,28317,28520,28553,
28806,28831,28878,29513,29689,29838,29863,30101,30183,30233,
30280,30456,30545,30623,30636,30831,30857,30972,31031,31173,
31496,31574,31593,31644,31884,31900,31973,  215,  260,  305,
  584, 1087, 1591, 1612, 1639, 2032, 2078, 2659, 2886, 3415,
 3419, 3561, 3706, 3974, 4064, 4081, 4251, 4348, 4368, 4698,
 4765, 5208, 6032, 6210, 6807, 6966, 7338, 7379, 7431, 7561,
 7729, 7886, 8154, 8229, 8331, 8504, 8559, 8569, 8591, 8799,
 9055, 9313, 9680, 9814, 9997,10246,10269,10416,10643,10694,
11089,11098,11198,11235,11384,11631,11729,12024,12239,12302,
12797,13060,13135,13406,13557,13642,13671,13676,13728,13850,
14129,14494,14673,14757,15031,15172,15236,15380,15581,15832,
16093,16373,16380,16424,16462,16852,16899,16935,16970,17498,
17503,17541,17599,17818,17930,18159,18209,18346,18446,18456,
18488,18763,19068,19289,19530,19702,19713,19777,19789,19853,
20193,20495,20683,20784,21091,21229,21346,21378,21438,22169,
22286,22436,22523,22560,22583,22731,22931,23204,23238,23256,
23688,23728,24127,24235,24710,24768,24817,25763,26021,26391,
26414,26516,26635,26742,26792,26808,27108,27571,27743,27922,
28559,28835,28846,29009,29033,29116,29270,29298,29317,29326,
29335,29383,29535,29632,29640,30421,30746,30777,31115,31348,
31654,31724,  142,  328,  416,  504,  824, 1029, 1037, 1112,
 1461, 1622, 1862, 1933, 1947, 1970, 1990, 2221, 2385, 2613,
 3381, 3404, 3429, 3742, 3850, 3878, 3949, 4182, 4299, 4643,
 5123, 5285, 5383, 5467, 5629, 5643, 5673, 5704, 5733, 5903,
 6104, 6157, 6389, 6451, 6566, 6683, 6787, 7007, 7227, 7320,
 7681, 7716, 7828, 8293, 8323, 8358, 8473, 8536, 8576, 8890,
 8969, 9553, 9611,10110,10114,10149,10228,10290,10394,10844,
11144,11186,11257,11408,11554,11664,12100,12143,12310,12617,
12646,12899,12929,13020,13320,13376,13588,13639,13649,13884,
14103,14118,14410,14613,14695,14880,14927,15017,15393,15446,
15552,15660,15681,15867,16206,16264,16364,16409,16631,16753,
16995,17197,17425,18469,18483,18643,19087,19366,19535,19544,
19627,19880,19974,19993,20200,20211,20463,20510,20627,20944,
21082,21158,21165,21210,21898,21917,21951,21971,22179,22415,
22469,22674,22783,22809,22892,23349,23675,23932,24046,24080,
24110,24141,24639,24882,24976,25220,25310,25365,25652,25666,
25742,25810,25824,25995,26117,26140,26975,27013,27225,27330,
27375,27409,27458,27517,27930,28230,28372,28380,28442,28456,
28515,28534,28549,28618,28676,28800,28907,29303,29472,29658,
29697,30156,30549,30756,30941,31039,31266,31396,31440,31490,
31505,31552,   78,  423,  532,  773,  972,  985, 1226, 1316,
 1766, 1850, 2024, 2050, 2265, 2357, 2539, 2587, 2953, 3290,
 3557, 3861, 4086, 4227, 4385, 4714, 4882, 5030, 5090, 5243,
 5310, 5616, 5975, 6206, 6252, 6470, 6558, 6609, 6733, 6881,
 6962, 7202, 8003, 8601, 8754, 9099, 9478, 9523, 9563,10029,
10137,10376,10465,10472,10598,10621,10797,11343,11478,11828,
12353,12368,12632,12793,12803,13530,13755,14148,14249,14594,
14798,15047,15307,15417,15614,16244,16287,16534,16662,16713,
16867,16924,17324,17597,17635,18127,18387,18535,18890,19093,
19300,19362,19423,19460,19731,19868,20797,20808,20870,21368,
21456,21505,21556,21769,22315,22579,22720,22947,23440,23515,
23819,23863,24697,25587,25681,26120,26174,26226,26657,26954,
27076,27086,27199,27287,27474,27596,27908,27999,28464,29096,
29346,29401,29761,30070,30185,30628,30634,30643,30978,30989,
31380,31417,  155,  432,  447,  468,  668,  688,  693,  994,
 1696, 2057, 2172, 2260, 2324, 2636, 2724, 2802, 3580, 3586,
 3840, 4457, 4951, 5149, 5994, 6045, 6261, 6726, 6932, 7039,
 7177, 7343, 7443, 7555, 7598, 7894, 8074, 8802, 8892, 8974,
 9111, 9572, 9796,10966,10998,11054,11622,11682,11770,12297,
12761,12815,13293,13311,14467,14790,15000,15465,16131,16574,
16585,17018,17036,17300,17478,17603,17747,18493,18817,19056,
19621,19641,20551,21087,21330,21592,21998,22112,22116,22374,
22433,22795,23318,23424,23498,23521,23847,24026,24668,24896,
25044,25193,25197,25292,25627,25988,26393,26643,26731,27485,
27578,27852,29083,29263,29819,30474,30913,31524,  130, 1218,
 1449, 1468, 1564, 1587, 1809, 2469, 3137, 3177, 3271, 3797,
 3883, 3905, 3952, 4318, 4325, 4997, 5259, 5692, 5907, 6172,
 6634, 7527, 7688, 8673, 8928, 9149, 9510, 9857,10261,10386,
10425,10563,10637,10900,11051,11546,11556,11794,11910,12051,
12232,12414,13058,13286,13348,13408,13466,14223,14290,14893,
15220,15813,15945,16446,17353,17777,17857,18294,18519,18830,
18852,19825,19996,20037,20118,20295,20559,20847,21152,21179,
21817,21955,22175,22418,22872,22917,23048,23342,24487,24595,
24926,25020,25154,25264,25354,26215,26255,26695,26795,26972,
27017,27044,27296,27346,28066,28182,28625,29524,29700,29798,
30161,30880,31130,31166,31215,   19,  411,  428, 1306, 1682,
 1988, 2146, 2305, 2383, 2416, 2647, 3009, 3386, 3527, 3619,
 3701, 3929, 4448, 4813, 5008, 5303, 5518, 5699, 6025, 6381,
 7843, 7941, 8649, 9042, 9265, 9640, 9816,10034,10402,10634,
10640,10870,11395,12070,12516,12733,13265,13490,13534,13975,
14035,14711,15110,15232,15263,15328,16018,16281,16458,16942,
17244,17637,17754,17997,18781,18944,19099,19241,19934,20242,
20281,20515,20781,20833,20878,20992,21949,22092,22211,22467,
22807,22981,23129,23475,23634,23680,23744,24308,24341,24431,
25594,25700,26019,27111,27177,27569,27668,28224,28808,28860,
28942,29259,29300,29404,29499,29511,29959,29985,30371,30417,
30841,30855,31076,31929,31976,  871,  887, 1031, 1093, 1345,
 1439, 1734, 1802, 2352, 2430, 3351, 3458, 3471, 3504, 3755,
 4479, 4848, 4852, 5570, 6161, 6174, 6245, 6649, 6981, 6995,
 7326, 7356, 7371, 7434, 7454, 8182, 9038, 9464, 9690,10182,
10409,10507,10719,11445,11460,11871,12121,12183,12204,12484,
12555,13023,13735,13770,13854,13860,14040,14071,14255,14473,
15104,15414,15470,15652,15673,15819,15971,16597,16621,16720,
17543,17571,17622,17703,18204,18560,19032,19209,19314,20174,
20287,20648,20950,21256,21563,21667,21815,21995,22326,22774,
22811,23242,23311,23461,23583,23750,23953,24003,24223,24445,
24493,24739,25029,25038,25204,25287,25561,25838,25953,26005,
26040,26086,26548,27203,27611,27845,27914,27933,28488,29911,
30023,30073,30271,30580,30751,30807,30927,31006,31177,31317,
31446,31823,    2,   53,  161, 1167, 1871, 2019, 2507, 2964,
 2976, 3400, 3487, 3805, 3900, 4338, 4557, 4628, 4677, 4692,
 4736, 5348, 5678, 6008, 6475, 6678, 7106, 7765, 7801, 7924,
 7966, 8203, 8356, 8402, 8519, 8806, 9071, 9142, 9182, 9365,
 9426,10276,10321,10397,11010,11074,11340,11418,11425,11788,
11836,12401,12521,12724,13191,13195,13346,13559,13592,13698,
13990,14019,14158,14870,14874,15054,15075,15125,15134,15208,
15285,16351,16377,17000,17122,17182,17248,17397,17532,18094,
18267,18438,18497,18701,18770,18933,19863,19872,20123,20659,
21147,21268,21511,21823,21911,22214,22352,22706,22971,23334,
23563,23735,24268,24438,24516,24994,25443,25958,26168,26328,
26457,26980,27662,27695,27701,28346,28352,28479,28690,28697,
28720,28767,29418,29442,29475,29486,29779,30095,30117,30147,
30683,30958,31202,31338,31625,31686,31796,31813,31896,31933,
  318,  821, 1595, 2152, 2360, 2712, 2898, 3082, 3566, 3918,
 4072, 4461, 4536, 5254, 5785, 5845, 6621, 7022, 7077, 7119,
 8362, 8494, 8718, 8871, 9245, 9326,10295,10724,11369,12582,
13306,13356,13523,14093,14241,15562,15570,15596,15888,16098,
16828,17113,17580,18376,19012,19309,19655,19797,20291,20573,
20600,20637,21047,21120,21395,21617,21738,21836,21855,22884,
23841,23961,24280,25486,25609,25663,25770,26565,26618,26689,
27883,27977,28109,28646,29138,29531,30059,30246,30603,30962,
31186,31234,31712,31753,31772,31954,   97,  209,  612,  718,
  740, 1242, 1472, 1645, 1930, 2273, 2619, 2749, 3034, 3745,
 3791, 4233, 4354, 4937, 5185, 5874, 6180, 6299, 6345, 6394,
 6627, 7705, 7741, 7794, 8836, 9348, 9409, 9469, 9695,10145,
11028,11207,11764,11775,11819,11923,12247,12573,12906,13168,
13201,13570,13685,14336,14554,14707,15138,15767,15834,16141,
16550,16783,16837,16962,17367,17521,17921,18066,18338,18513,
18545,18583,18939,19262,20014,20499,20998,21055,21846,21979,
22343,22684,23054,23166,23303,23376,24160,24659,25302,25584,
25641,25747,25932,26053,26579,26765,27687,27900,27927,28164,
28321,28365,29460,29581,29810,30173,30592,30967,31059,31982,
   41,  649, 1288, 1567, 1629, 1746, 1752, 1773, 2007, 2176,
 2334, 2791, 3152, 3868, 4310, 4624, 4949, 5406, 5456, 6270,
 6406, 6495, 6945, 7223, 7387, 7429, 7631, 7834, 7915, 8197,
 8271, 8379, 8789, 9252, 9460, 9683, 9868,10024,10854,10955,
11270,11454,11661,11805,12361,12526,12883,12894,12933,13068,
13441,14087,14269,14546,14642,15020,15501,15513,15795,15828,
16039,16418,16857,17296,17481,17884,17912,17950,17961,17990,
18191,18593,18971,19226,19590,20179,20285,20583,20623,20745,
20843,21742,21793,22380,22910,23086,23452,23508,23973,24407,
25056,25082,25806,25888,26512,26831,26906,26947,27188,27314,
27558,28232,29014,29062,30083,30240,30863,31500,31748,31803,
31837,  119,  213,  345,  394,  522,  634,  832,  863, 1072,
 1196, 1352, 1572, 1636, 1877, 2117, 2230, 2822, 2847, 2911,
 2970, 2989, 3111, 3121, 3171, 3214, 3307, 3532, 3615, 4150,
 4248, 4361, 4608, 4681, 4711, 4718, 4742, 4860, 4866, 4896,
 4945, 4959, 5083, 5193, 5225, 5301, 5395, 5528, 5619, 5776,
 5837, 5922, 5957, 6090, 6192, 6239, 6424, 6833, 6992, 7042,
 7052, 7130, 7307, 7353, 7684, 7758, 7780, 8114, 8348, 8702,
 8726, 8856, 8900, 8939, 9159, 9500, 9647, 9722, 9743, 9824,
 9907,10072,10092,10132,10310,10627,10711,10717,10777,10876,
10987,11003,11329,11723,11947,12128,12155,12228,12603,12836,
12887,12951,12982,13350,13519,13971,14027,14108,14127,14138,
14151,14368,14435,14464,14690,14731,15142,15196,15434,15487,
15771,15824,15850,15877,16083,16168,16433,16560,16896,16966,
16979,17809,18100,18163,18279,18406,18441,18502,18720,18919,
18947,19040,19053,19147,19254,19295,19325,19467,19667,19921,
20028,20134,20276,20387,20416,21014,21169,21315,21389,21416,
21465,21636,21715,21943,22155,22503,22594,22801,22818,22951,
23060,23477,23523,23545,23900,23958,24136,24243,24262,24591,
24612,24655,24727,24741,24778,24856,24869,25091,25539,25568,
25599,25659,25782,25883,26057,26439,26531,26543,26840,26921,
27196,27229,27335,27949,28059,28081,28149,28177,28239,28280,
28387,28518,28610,28638,28684,28763,28885,29246,29278,29422,
29478,29802,29834,29840,30065,30110,30210,30284,30460,30552,
30572,30611,30620,30739,30917,31064,31410,31577,31727,31828,
   70,  722,  927, 1011, 1181, 1293, 1550, 1729, 1844, 2568,
 2580, 2692, 2833, 3322, 3523, 3609, 3681, 3732, 4047, 4542,
 5014, 5293, 5439, 5888, 6184, 6247, 6772, 7070, 7148, 7168,
 7509, 8176, 8189, 8221, 8905, 9513, 9566, 9729, 9847, 9994,
10057,10890,10960,11109,11165,11288,11412,11975,12195,12256,
12405,12586,12912,13014,13514,13637,13787,14260,14316,14428,
14668,15058,15181,15710,15840,15863,15882,16147,16294,16353,
16375,16449,16709,17535,17624,17685,17890,18331,18966,18975,
19073,19319,19556,19599,19830,20058,20105,20237,20262,20567,
20667,21530,21731,21851,22053,22365,22586,22850,22960,23097,
23309,23380,23747,23829,24539,24619,24873,25177,25383,25817,
25846,26518,26590,26609,26699,26816,27319,27542,27728,27747,
28435,28936,29029,29729,30350,30393,30677,31564,31684,31732,
31808,   14,  272,  299,  387,  709, 1812, 1884, 2208, 2434,
 2716, 3127, 3284, 3845, 4196, 4465, 4615, 5324, 5460, 5479,
 5725, 6290, 7062, 7121, 7421, 7575, 7585, 7906, 8262, 8310,
 8584, 9065, 9106, 9507, 9738, 9751, 9807, 9861,10846,11169,
11183,11487,11524,11656,12016,12753,13302,13581,13645,14525,
14803,15205,16190,16603,16849,17382,17509,17860,17900,17933,
18060,18173,18187,19120,19497,19809,20507,20787,21074,21233,
21515,21895,22289,22320,22350,22600,22709,23078,23389,23530,
24029,24289,24458,24885,24982,25103,25217,25630,25799,26260,
26307,26911,27161,27519,27590,27809,28185,28844,28920,29050,
29104,29385,29428,29591,29886,30039,30407,30824,30877,30946,
31210,31392,31515,   94,  115,  238,  853, 1476, 1643, 2405,
 2561, 3358, 3955, 3985, 4154, 4294, 4313, 4445, 4707, 4878,
 5028, 5614, 5857, 5880, 5963, 6356, 6828, 7144, 7458, 7946,
 7979, 8018, 8065, 8321, 8667, 8759, 9185, 9430, 9659,10086,
10254,10459,10996,11279,11542,11642,11779,11842,12429,12547,
12683,13288,13470,13746,14073,14082,14489,14890,15298,15406,
16540,16619,16800,17014,17024,17099,17246,17526,17761,17916,
18014,18260,18868,19151,19211,19415,19908,20170,20226,20471,
20633,20673,20968,21003,21452,21993,22429,22489,23297,23366,
23585,23697,24202,24317,24440,24522,24879,25978,26000,26220,
26241,26535,26898,27040,27238,27272,27342,27604,27946,27964,
28055,28289,28621,28758,29314,29378,29516,29983,30013,30531,
30607,30730,31035,31191,31437,31527,32037,  222,  268,  485,
  643,  701,  726,  784,  806,  960, 1175, 1785, 1998, 2247,
 2255, 2709, 3004, 3072, 3590, 3710, 3891, 3969, 4068, 4137,
 4304, 4568, 4855, 4914, 4963, 5814, 6012, 6118, 6286, 6530,
 6855, 7012, 7347, 7761, 8084, 8336, 8546, 8684, 8771, 8779,
 8884, 9030,10096,10497,10572,10591,10913,11057,11403,12133,
12191,12437,12537,12637,12699,13188,13528,13905,13950,14209,
14308,14359,14535,14709,15008,15079,15229,15509,15759,15800,
16022,16202,16729,16973,17225,17414,17564,17924,18134,18434,
18650,18732,18897,19333,19438,19479,19711,19739,20190,20458,
20901,21281,21589,21790,22120,22204,22551,22729,22798,23073,
23292,23538,23621,23856,23876,24017,24041,24101,24283,24528,
25159,25313,25564,25936,26354,26376,27192,27215,27500,27705,
27877,28511,28555,29057,29157,29395,29857,30253,30588,30641,
31366,31414,31840,32009,  250,  314,  390,  540,  600,  810,
  847, 1200, 1249, 1267, 1349, 1687, 1791, 1856, 1974, 2135,
 2156, 2186, 2409, 2424, 2503, 2584, 2606, 2652, 2703, 2735,
 2914, 3142, 3469, 3545, 3729, 3858, 3887, 4124, 4171, 4427,
 4825, 5233, 5305, 5319, 5331, 5408, 5443, 5448, 5718, 6043,
 6062, 6225, 6276, 6543, 6593, 6613, 6652, 6780, 6922, 6949,
 7001, 7257, 7324, 7413, 7817, 7903, 8126, 8180, 8227, 8296,
 8407, 8655, 8744, 8944, 8979, 9058, 9190, 9227, 9261, 9293,
 9301, 9336, 9534, 9663, 9794,10010,10045,10079,10124,10581,
10692,10706,10758,10873,10982,11025,11392,11433,11760,11906,
11913,11993,12173,12199,12305,12317,12409,12626,12783,12806,
12937,12957,13141,13256,13281,13308,13369,13413,13488,13739,
14055,14173,14252,14542,14604,14940,15050,15175,15190,15256,
15484,15525,15667,15746,15775,16001,16028,16174,16268,16454,
16482,16599,16612,16815,16958,17038,17119,17138,17282,17321,
17957,18004,18179,18256,18315,18358,18481,18872,18884,18979,
19028,19047,19155,19427,19663,19683,19870,19887,19896,19971,
20231,20394,20410,20437,20561,20695,20873,21009,21020,21030,
21241,21250,21326,21335,21469,21613,21957,22003,22131,22139,
22228,22464,22496,22563,22698,22853,22939,22964,23356,23575,
23629,23647,23947,24078,24085,24196,24514,24545,24603,25097,
25115,25184,25232,25271,25357,25399,25445,25573,25683,25735,
25789,25842,25966,26304,26330,26430,26559,26797,26961,26965,
27120,27359,27490,28104,28116,28167,28313,28420,28495,28650,
28713,28717,28724,28827,28853,28928,29152,29199,29218,29337,
29464,29637,29712,29765,29842,29865,29898,29977,30005,30045,
30576,30673,30760,30848,31195,31242,31315,31327,31362,31376,
31590,31640,31959,  140,  149,  435,  488,  856,  970, 1122,
 1207, 2204, 2442, 3133, 3185, 3751, 3995, 4334, 4357, 4477,
 4840, 5339, 6583, 7884, 8120, 8205,10105,10147,10648,10667,
11161,11292,11574,11917,12260,12341,13171,13210,13510,13846,
14479,14521,14645,14724,15042,15385,15587,16086,16252,17095,
17156,17203,17242,17337,17401,17552,18303,18573,19161,19420,
20399,20497,20983,20996,22219,22597,22669,22896,23446,24300,
24306,25034,25051,25870,26133,26571,26837,27026,27174,27582,
27768,30221,30535,31512,31881,31937,  303,  638,  987, 1060,
 1274, 1414, 2463, 2741, 3032, 3149, 3287, 3293, 3496, 3747,
 4845, 5536, 5603, 5626, 5668, 5876, 5954, 6212, 6577, 7402,
 7654, 7745, 8193, 8557, 8689, 9175, 9180,10824,11040,12500,
12608,12770,13071,13768,13922,14023,14179,15024,15260,15314,
15856,16134,16198,16553,17688,17752,18089,18157,19024,19784,
19839,20378,20930,21410,21436,21777,21890,21903,22765,23869,
23951,24314,24423,25261,25441,26042,26270,26334,26551,27482,
29310,29686,29795,29860,30100,30165,30596,30837,31238,31311,
31353,31909,   33, 1090, 1098, 2535, 2564, 4002, 4730, 5402,
 5505, 5781, 5914, 6792, 7301, 7391, 8517, 8921, 9357, 9435,
 9799, 9845,10065,10600,10686,10713,11238,11436,11474,11580,
12678,12812,13584,13909,14238,14704,15654,16523,16669,17825,
17888,19202,19451,19700,19734,20449,20576,20773,22145,22499,
22546,23168,23258,23386,23711,25199,25304,25673,26785,27280,
27648,27724,27759,27780,27872,28078,28384,28632,29064,29997,
30112,30528,31013,   90, 1362, 2084, 2235, 2317, 2330, 3766,
 3789, 4481, 4942, 6465, 7803, 7837, 8677,10946,11559,11564,
11638,13724,13887,14630,16246,17106,17793,18055,18120,18859,
18915,19322,19528,20676,21830,22232,23273,23588,24212,24839,
25281,25431,25930,26692,26994,27608,27979,28293,29090,29436,
29893,30793,31263,  843, 1500, 1952, 2419, 2770, 3914, 4421,
 5580, 5611, 5657, 6553, 6863, 7772,10576,10624,10893,11740,
11865,11984,12159,12504,12641,13928,14134,14652,14741,15252,
15629,15804,15904,16756,18490,18905,19745,19919,20741,20940,
21359,22300,22569,23473,24964,25257,25794,26203,26341,26364,
27714,27752,28562,28641,29031,29424,30363,30654,30669,31806,
  426,  439, 1383, 1818, 2745, 2824, 3987, 4244, 4307, 4762,
 5266, 5473, 6607, 6624, 6693, 7398, 7638, 7721, 8032, 8315,
 8652, 8932, 9118, 9153, 9284, 9446, 9822,10141,10801,11214,
12530,12941,13180,13203,14155,14405,15102,15129,15458,15792,
16149,16513,16977,17611,18274,18557,18729,19081,19250,19624,
19794,20853,20947,21384,21566,21652,21734,23492,23717,25315,
25668,26153,26263,26806,28049,28282,29196,29266,29683,31148,
31270,31442,31786,31811,  799, 1424, 1488, 1603, 1749, 2594,
 2922, 3001, 3965, 4089, 4225, 5096, 5391, 5798, 6561, 6867,
 7408, 7751, 7919, 8092, 8149, 8466, 8641, 8784, 9078, 9718,
10004,10478,11634,12031,12188,12519,14234,14304,14470,14486,
14992,15557,16259,16465,16737,17485,18211,18565,18824,20042,
20052,20216,20414,20861,21173,21428,21857,21973,22816,23095,
23113,23182,23702,23843,24024,24820,26445,26925,27093,27234,
27356,27996,28235,28658,28996,29290,30075,30935,    4,   26,
   74,  124,  134,  144,  228,  252,  357,  398,  455,  474,
  481,  543,  595,  604,  658,  711,  729,  814,  874,  878,
  883,  890,  912,  963, 1022, 1188, 1198, 1211, 1244, 1254,
 1355, 1369, 1416, 1422, 1426, 1502, 1649, 1656, 1674, 1683,
 1702, 1731, 1769, 1824, 1869, 1889, 2045, 2170, 2197, 2313,
 2411, 2436, 2514, 2529, 2546, 2573, 2592, 2650, 2754, 2789,
 2820, 2830, 2835, 2882, 2966, 2987, 2996, 3019, 3042, 3044,
 3085, 3097, 3123, 3199, 3221, 3229, 3281, 3318, 3347, 3356,
 3502, 3519, 3571, 3594, 3656, 3717, 3864, 3875, 3960, 3967,
 3993, 4062, 4077, 4105, 4175, 4246, 4321, 4331, 4340, 4382,
 4430, 4471, 4565, 4645, 4701, 4802, 4818, 4831, 4833, 4843,
 4864, 4876, 4887, 4918, 4961, 5000, 5050, 5072, 5116, 5121,
 5273, 5291, 5350, 5430, 5441, 5453, 5488, 5708, 5713, 5779,
 5830, 5863, 5882, 5894, 5959, 5997, 6016, 6109, 6195, 6227,
 6292, 6307, 6373, 6412, 6448, 6455, 6539, 6569, 6619, 6630,
 6654, 6853, 6857, 6919, 6935, 6941, 6959, 7032, 7068, 7166,
 7172, 7189, 7264, 7332, 7375, 7503, 7507, 7521, 7542, 7618,
 7628, 7633, 7797, 7813, 7931, 7960, 8135, 8142, 8147, 8161,
 8168, 8173, 8208, 8217, 8279, 8288, 8298, 8483, 8605, 8669,
 8734, 8757, 8773, 8804, 8955, 9088, 9104, 9168, 9232, 9236,
 9329, 9370, 9413, 9440, 9450, 9482, 9645, 9649, 9688, 9708,
 9733, 9747, 9766, 9826, 9870, 9885, 9889, 9891, 9897, 9937,
10112,10176,10199,10214,10236,10252,10293,10300,10313,10327,
10378,10511,10560,10574,10603,10612,10629,10646,10673,10780,
10808,10852,10888,10963,10979,11061,11072,11194,11334,11347,
11397,11421,11456,11529,11607,11658,11786,11809,11863,11869,
11937,11949,11954,11960,12005,12049,12165,12206,12253,12300,
12421,12442,12512,12524,12566,12595,12689,12731,12755,12776,
12864,12903,12908,12919,12965,12970,13083,13107,13152,13193,
13198,13218,13325,13566,13635,13660,13688,13743,13765,13793,
13857,13892,13898,13954,13973,14032,14065,14171,14323,14352,
14634,14636,14648,14722,14752,14811,14847,14852,14876,14907,
14921,14947,14986,15077,15117,15169,15227,15275,15287,15312,
15402,15430,15440,15482,15492,15497,15511,15515,15619,15765,
15870,15899,15964,15973,15979,15989,16012,16037,16045,16145,
16179,16234,16344,16400,16402,16414,16467,16474,16484,16525,
16531,16548,16578,16614,16628,16749,16839,16955,17003,17027,
17111,17125,17176,17180,17213,17238,17250,17309,17355,17385,
17409,17518,17538,17557,17583,17609,17615,17628,17681,17771,
17781,17787,17866,17886,17906,17914,18198,18243,18336,18393,
18474,18477,18504,18515,18551,18635,18646,18658,18718,18734,
18790,18845,18917,18953,19026,19206,19277,19283,19297,19330,
19345,19357,19494,19595,19650,19674,19724,19889,19901,19928,
19940,20004,20012,20020,20074,20127,20181,20248,20299,20353,
20401,20420,20447,20512,20556,20644,20653,20657,20685,20771,
20953,21005,21024,21084,21129,21149,21182,21253,21285,21354,
21380,21418,21450,21548,21595,21729,21749,21772,21826,21839,
21914,21945,21959,21975,21989,22085,22125,22196,22200,22383,
22474,22487,22520,22532,22555,22750,22785,22804,22908,22927,
23005,23052,23057,23069,23116,23124,23159,23202,23275,23294,
23459,23481,23528,23532,23561,23571,23619,23641,23661,23772,
23874,23883,23897,23906,23924,23937,24119,24132,24192,24200,
24251,24304,24339,24344,24355,24418,24449,24469,24484,24520,
24526,24541,24589,24607,24657,24824,24865,24887,24892,24916,
24973,24998,25003,25019,25053,25201,25214,25267,25298,25317,
25361,25420,25469,25559,25566,25643,25647,25687,25815,25886,
25944,25970,26066,26147,26165,26185,26195,26250,26274,26311,
26317,26322,26423,26428,26459,26469,26596,26598,26628,26701,
26746,26753,26768,26776,26814,26843,26913,26932,26951,27020,
27181,27207,27301,27323,27338,27460,27497,27545,27553,27658,
27790,27794,27812,27903,28034,28053,28112,28132,28147,28158,
28254,28278,28334,28452,28460,28500,28507,28523,28682,28695,
28722,28733,28739,28760,28772,28862,28894,28901,28922,28939,
28948,29016,29040,29127,29148,29214,29239,29415,29420,29453,
29468,29541,29625,29718,29725,29776,29871,29900,29923,30015,
30021,30043,30144,30153,30194,30273,30391,30434,30440,30453,
30470,30488,30543,30590,30732,30809,30852,30960,30997,31021,
31026,31112,31141,31144,31179,31259,31301,31330,31355,31537,
31542,31643,31651,31701,31722,31774,31793,31798,31801,31872,
31957,31972,32024,   10,   43,  259,  479,  492,  597,  704,
  929,  934,  966, 1108, 1239, 1260, 1393, 1469, 1474, 1570,
 1598, 1672, 1744, 1794, 1829, 1838, 1949, 1968, 2003, 2070,
 2268, 2499, 2696, 2747, 2763, 2972, 2992, 2998, 3231, 3298,
 3330, 3337, 3461, 3493, 3507, 3735, 3784, 3798, 3852, 3972,
 4049, 4099, 4271, 4328, 4389, 4467, 4512, 4528, 4561, 4630,
 4634, 4872, 4931, 4939, 5003, 5053, 5061, 5076, 5085, 5334,
 5490, 5538, 5574, 5592, 5655, 5800, 5855, 6050, 6058, 6171,
 6177, 6280, 6343, 6459, 6488, 6493, 6547, 6637, 6658, 6670,
 6764, 6784, 6794, 6967, 6971, 7219, 7367, 7378, 7389, 7400,
 7452, 7460, 7498, 7505, 7533, 7682, 7708, 7910, 8008, 8166,
 8191, 8213, 8268, 8455, 8498, 8523, 8562, 8764, 8902, 8915,
 9034, 9047, 9075, 9086, 9241, 9273, 9355, 9411, 9569, 9609,
 9916, 9948,10052,10094,10248,10260,10308,10414,10466,10509,
10680,10815,10841,10976,11092,11101,11209,11246,11299,11451,
11602,11686,11728,11753,11802,11811,11846,11854,11927,11989,
12018,12201,12214,12220,12426,12482,12705,12734,12742,12750,
12762,12781,13017,13121,13139,13176,13254,13259,13460,13556,
13596,13655,13669,13674,13696,13870,13924,13945,14091,14111,
14153,14227,14314,14357,14413,14565,14623,14750,14787,14793,
14807,14856,14868,15012,15056,15127,15279,15410,15453,15523,
15752,15861,15884,15995,16003,16024,16030,16079,16330,16441,
16472,16516,16582,16587,16830,16949,16953,17008,17102,17131,
17185,17189,17280,17362,17427,17613,17630,17683,17738,17881,
17892,17976,18115,18152,18317,18384,18399,18461,18555,18563,
18581,18671,18716,18738,18874,18879,18899,18981,19149,19215,
19270,19307,19359,19436,19443,19608,19644,19648,19806,19905,
20006,20047,20078,20090,20164,20168,20183,20252,20428,20485,
20598,20692,20764,20780,21007,21028,21032,21079,21213,21263,
21350,21399,21423,21430,21441,21524,21701,21744,21820,21832,
21862,22221,22238,22292,22302,22334,22480,22541,22663,22742,
22948,22953,22988,23000,23091,23161,23175,23186,23232,23325,
23438,23443,23464,23625,23694,23727,23742,23860,23891,24038,
24107,24198,24254,24265,24409,24474,24479,24499,24524,24584,
24605,24625,24644,24730,24769,24822,24901,25120,25172,25359,
25378,25427,25433,25603,25638,25657,25863,25890,25964,26046,
26051,26074,26208,26218,26382,26541,26587,26611,26696,26725,
26902,26908,26930,27140,27190,27370,27396,27463,27606,27616,
27673,27699,27756,27770,27868,27896,27969,28051,28074,28102,
28128,28179,28190,28298,28550,28672,28917,28961,28994,29011,
29189,29216,29323,29403,29413,29426,29444,29483,29497,29521,
29579,29854,30007,30037,30149,30188,30299,30373,30424,30446,
30482,30556,30561,30664,30691,30816,30844,30860,30965,30993,
31015,31167,31236,31388,31420,31534,31559,31598,31617,31697,
31739,31760,31776,31820,31826,31902,32035,   50,  279, 1001,
 1102, 1209, 1548, 1991, 2226, 2540, 2968, 3204, 3366, 3410,
 3622, 3675, 3896, 4191, 5379, 5513, 5687, 5827, 5843, 6158,
 6358, 6912, 7014, 7060, 7425, 7608, 7687, 8090, 8223, 8346,
 8696, 8706, 9509, 9805,10013,10090,10231,10529,12126,13185,
13352,13474,13703,14067,14299,14437,14831,15432,15565,15589,
16035,16238,16346,17173,17969,18175,18288,18531,18586,18663,
18891,19396,19843,19923,20737,21012,21193,21607,21650,22208,
22385,22508,22628,22780,22914,22918,22945,23062,24045,24357,
24510,25345,25371,25397,25675,26031,26272,26374,26825,27073,
27134,27276,28664,29585,30219,30598,31309,31456,    8, 1058,
 1078, 1927, 1971, 2341, 2393, 2449, 3384, 3727, 3931, 4040,
 4723, 4925, 5235, 5982, 6257, 6746, 7213, 7344, 7501, 7770,
 7832, 8259, 8377, 9307, 9488, 9544, 9686, 9834,10240,10469,
10984,11290,11527,11977,12343,12687,12789,12885,13012,13220,
13550,14169,14338,14370,15034,15123,15199,16072,17285,17403,
17679,18110,18329,18569,18595,19221,19400,19472,19894,20258,
20756,20767,21042,21178,21377,22240,22355,23264,24503,24594,
24845,25414,25968,26501,26581,27213,27540,27572,28174,28258,
28881,29655,29826,29895,29913,30168,30226,30429,30693,30932,
31028,31062,31261,31699,   28,  899, 1116, 1204, 1387, 1882,
 1996, 2025, 2366, 2815, 2849, 3087, 3361, 3500, 4284, 4301,
 4517, 5239, 5534, 5605, 6028, 6081, 6481, 7239, 7334, 7361,
 8219, 8303, 8468, 8741, 9133, 9620, 9671, 9720, 9850, 9924,
10325,10967,11077,11250,11342,11381,11423,11748,11773,12225,
12680,13885,13913,14096,14632,14994,15090,15784,16057,16336,
16576,16796,16809,16863,17040,17047,17313,17327,17445,17938,
18102,18740,19042,19134,19503,20214,20313,20422,20516,21727,
21897,22198,22426,22887,23093,23363,23967,24272,25259,25296,
25387,25429,25462,25548,25615,25985,26336,26425,26592,27031,
27309,28134,28152,28183,28263,28439,28475,28677,28765,29000,
29069,29084,29288,29696,29884,30377,30383,30778,31193,31431,
31714,31735,31758,31979,  113,  127,  192,  257,  309,  396,
  483,  593,  610,  716,  812,  837,  981, 1044, 1085, 1106,
 1190, 1265, 1286, 1347, 1420, 1700, 1822, 2178, 2233, 2319,
 2440, 2519, 2590, 2688, 2718, 2758, 2985, 3109, 3324, 3349,
 3585, 3673, 4130, 4168, 4351, 4419, 4451, 4503, 4764, 4907,
 4920, 4933, 4947, 4966, 5022, 5230, 5397, 5498, 5530, 5760,
 5861, 6014, 6041, 6197, 6442, 6532, 6545, 6563, 6585, 6605,
 6617, 6689, 6859, 6953, 6983, 7005, 7036, 7217, 7247, 7351,
 7540, 7743, 8082, 8137, 8159, 8421, 8529, 8588, 8680, 8766,
 8769, 8775, 8791, 8834, 8930, 8937, 9056, 9331, 9665, 9764,
 9830,10192,10210,10220,10334,10374,10417,10461,10822,10828,
10944,11030,11048,11063,11185,11274,11549,11585,11598,11681,
11822,11861,12116,12137,12251,12506,12575,12616,12901,12987,
13081,13105,13123,13144,13248,13292,13455,13521,13589,13709,
13777,13833,13932,13952,14051,14175,14266,14327,14400,14407,
14425,14455,14537,14693,14696,14878,15244,15277,15362,15449,
15635,15700,15761,15909,15968,15993,16065,16285,16404,16542,
16563,16584,16844,17127,17208,17307,17530,17550,17705,17947,
17954,17967,17988,17993,18009,18254,18499,18629,18648,19095,
19128,19157,19213,19229,19258,19335,19485,19584,19669,19824,
19878,20010,20130,20176,20233,20509,20670,20858,20875,20881,
21127,21131,21171,21348,21472,21559,21597,21611,21736,21834,
21848,21905,21967,21987,22346,22378,22466,22553,22713,22864,
23044,23122,23154,23566,23752,23865,23878,23902,23930,23955,
23971,24014,24103,24609,24688,24813,24833,24906,24918,24984,
25060,25380,25418,25502,25541,25784,25948,26013,26193,26216,
26557,26630,26703,26713,26760,26845,26853,26992,27010,27128,
27282,27340,27363,27594,27718,27929,28042,28083,28444,28706,
28731,28737,28815,28910,28941,29044,29079,29123,29332,29342,
29376,29397,29448,29602,29608,29631,29789,29837,29862,29902,
29967,30069,30155,30196,30494,30533,30659,30839,31011,31019,
31172,31246,31325,31497,31961,32022,   45,  265,  656,  827,
  860,  973, 1183, 1826, 1847, 1946, 2240, 2446, 2787, 2837,
 3017, 3569, 4103, 4434, 5469, 5577, 5694, 5832, 5999, 6111,
 6294, 6453, 6943, 7319, 7756, 7841, 8151, 8178, 8500, 9102,
 9170, 9421, 9560,10074,10178,10291,10504,10813,10895,11180,
11427,12112,12163,12218,12258,12336,14132,14680,14733,14813,
14905,15026,15665,15806,16009,16070,16132,16363,17178,17495,
18002,18165,18319,18656,18678,18768,19266,19355,19410,19692,
19910,20273,21393,21526,21619,21709,21724,21761,22979,23075,
23513,23725,23770,23814,24241,24530,24614,24635,24679,24736,
24966,25041,25246,25938,26227,26450,26553,27198,27622,27905,
28114,29106,29808,30486,30737,30786,31299,31730,31743,31778,
31894,  297,  545, 1118, 1303, 2009, 2130, 2222, 2358, 2537,
 2845, 3077, 3118, 3343, 3408, 3658, 3963, 4095, 4250, 4469,
 4497, 4577, 4699, 5284, 5675, 5774, 6092, 6595, 7211, 7396,
 7419, 7821, 8266, 8317, 8607, 8917, 9532,10197,10671,11163,
11192,11218,11458,11911,12042,12369,12480,12939,13212,13304,
14029,14271,14720,15517,15790,16416,16463,16533,16932,17097,
17223,17523,17664,17726,17791,18118,18397,18913,19316,19445,
19465,19722,20072,20192,21017,21037,21412,21467,21746,21770,
21977,22223,22603,22858,23277,23494,23540,23808,23836,23862,
24134,24210,24275,25279,25649,25767,25827,26371,27002,27311,
27345,27614,27707,27761,27792,28057,28619,28656,28944,28953,
29241,30163,30448,30629,30811,30995,31057,31562,31911,   12,
   55,  121,  159,  231,  277,  392,  437,  494,  499,  515,
  602,  641,  713,  724,  816, 1040, 1088, 1124, 1186, 1219,
 1246, 1258, 1360, 1428, 1498, 1556, 1565, 1605, 1623, 1651,
 1771, 1867, 1886, 1932, 1957, 2027, 2052, 2065, 2086, 2115,
 2158, 2386, 2582, 2648, 2701, 2737, 2943, 2948, 2974, 3147,
 3183, 3201, 3206, 3296, 3371, 3498, 3512, 3547, 3581, 3721,
 3842, 3854, 3862, 4038, 4119, 4135, 4144, 4173, 4181, 4189,
 4449, 4459, 4483, 4547, 4555, 4617, 4655, 4666, 4874, 4912,
 5007, 5018, 5227, 5317, 5329, 5471, 5628, 5685, 5787, 5793,
 6097, 6163, 6187, 6229, 6408, 6434, 6528, 6579, 6656, 6782,
 6835, 6872, 6933, 6947, 7074, 7117, 7191, 7201, 7241, 7303,
 7373, 7423, 7444, 7450, 7531, 7547, 7710, 7763, 7786, 7792,
 7887, 7908, 7917, 7926, 8133, 8163, 8256, 8294, 8375, 8387,
 8404, 8560, 8603, 8663, 8671, 8682, 8687, 8704, 8732, 8839,
 8848, 8907, 8953, 9155, 9188, 9275, 9286, 9305, 9415, 9438,
 9442, 9490, 9505, 9564, 9616, 9710, 9740, 9749, 9895, 9909,
 9918,10032,10127,10208,10212,10229,10329,10392,10463,10476,
10531,10562,10644,10843,10953,10958,11011,11067,11070,11090,
11103,11212,11225,11277,11349,11485,11522,11553,11591,11605,
11632,11640,11684,11726,11807,11817,11844,12135,12148,12157,
12193,12243,12517,12580,12701,12736,12744,12785,12804,12814,
12826,12910,13073,13137,13146,13182,13252,13342,13354,13384,
13508,13564,13672,13683,13690,13785,13797,13868,13965,14021,
14044,14276,14306,14312,14321,14415,14449,14475,14484,14523,
14688,14701,14739,14743,14791,14805,14909,14938,14988,15010,
15014,15032,15092,15194,15412,15451,15521,15611,15617,15656,
15682,15698,15763,15907,15961,16063,16177,16218,16240,16328,
16398,16443,16469,16630,16643,16718,16798,16841,16859,16865,
16923,16960,16971,17005,17061,17187,17335,17387,17483,17540,
17632,17707,17711,17779,17858,17894,18007,18171,18262,18272,
18334,18517,18533,18539,18571,18627,18640,18703,18736,18750,
18843,18866,18886,18949,19044,19256,19361,19541,19610,19646,
19661,19706,19741,19786,19811,19821,19876,19969,20008,20278,
20289,20303,20489,20596,20610,20626,20743,20769,20794,20798,
20831,20856,20898,20942,20945,20970,20975,21034,21081,21151,
21317,21382,21432,21463,21476,21528,21779,21853,21908,21991,
22020,22118,22202,22243,22324,22373,22530,22534,22561,22584,
22686,22689,22702,22736,22767,22782,22791,22806,22848,22874,
22889,22912,22992,23012,23089,23200,23323,23327,23332,23490,
23627,23692,23721,23740,23867,23881,23922,24043,24138,24154,
24260,24471,24491,24512,24617,24627,24771,24830,24908,24975,
24987,25049,25063,25182,25219,25273,25284,25300,25435,25499,
25504,25546,25557,25582,25680,25729,25925,25972,25980,26044,
26187,26197,26315,26415,26524,26529,26594,26600,26626,26656,
26729,27075,27136,27274,27316,27357,27410,27417,27484,27494,
27565,27574,27592,27671,27720,27855,27894,27974,27989,28130,
28136,28237,28256,28300,28311,28355,28361,28389,28422,28437,
28477,28509,28577,28648,28735,28992,29018,29038,29060,29285,
29304,29334,29446,29455,29473,29539,29600,29621,29653,29681,
29769,29804,29869,30009,30041,30098,30217,30224,30277,30307,
30375,30458,30578,30613,30657,30858,30915,30925,30940,30982,
30991,31257,31351,31390,31399,31412,31422,31653,31695,31706,
31815,31939,32026,    6,   92, 1590, 2614, 2715, 2900, 3125,
 3457, 3811, 4071, 4534, 4563, 4805, 5647, 5816, 5896, 5961,
 6071, 6169, 6400, 7003, 7249, 7805, 8521, 8887, 9713,10578,
10617,10664,10799,11272,11476,12294,12378,12685,13166,13271,
13911,14250,14918,15237,15897,16355,16423,16678,16851,17952,
18177,18386,18644,19505,19597,19672,20646,21062,21373,22001,
22216,22314,22611,23177,24461,24788,24996,25416,26229,26638,
27524,27580,28261,28660,29500,29781,30250,30455,30479,30496,
30550,31357,31948,  132,  334, 1262, 1980, 2191, 2210, 2275,
 2451, 2725, 3916, 4184, 4636, 4713, 4862, 5345, 6559, 6632,
 8036, 8199, 8852, 9760,10448,10675,12172,12630,12832,13116,
13643,13731,13943,14754,15633,15649,15991,16764,17351,17943,
18248,18276,19159,19200,20635,20896,21140,21246,22283,22580,
22937,24877,24894,25043,25124,25385,25825,25950,25983,26453,
26515,26967,27169,27697,27870,28123,28227,28338,28883,29067,
29125,29518,29787,29915,29953,30206,30955,31139,31407,31418,
31575,  651,  858, 1670, 2336, 2374, 2620, 3291, 4889, 5219,
 5500, 6002, 6026, 6305, 6969, 7044, 7298, 7782, 8533, 9151,
10243,10395,11172,11197,11379,11600,12047,13568,13663,13789,
14423,14672,15310,16194,16236,16727,17167,17626,17766,18074,
18567,18686,19780,20116,20220,20619,21391,22037,22678,22925,
23146,23657,24022,24144,24518,24649,24920,24968,25677,25946,
29201,30067,30370,31121,  101,  355,  453,  538,  770, 1076,
 1353, 1371, 1767, 1858, 1993, 2022, 2266, 3021, 3187, 3607,
 3698, 3713, 3743, 3807, 3923, 4065, 4101, 4236, 4332, 4632,
 4744, 4901, 5031, 5148, 5659, 5677, 5777, 5956, 6039, 6083,
 6676, 6801, 6839, 6875, 7537, 8068, 8086, 8122, 8140, 8749,
 8860, 9069, 9162, 9281, 9321, 9359, 9654, 9673, 9893, 9946,
10184,10690,10915,11042,11345,11481,11781,11987,12142,12397,
12817,12898,12917,12961,13290,13572,13705,13826,13841,13908,
14181,14829,14849,15408,15461,15563,16166,16288,16760,16982,
17010,17092,17227,17789,17936,18744,19242,19285,19303,19523,
19680,19917,19992,20396,20518,20630,20785,21352,21504,21521,
21593,21646,21763,22174,22501,22525,22622,23360,23382,23430,
23479,23858,23928,23969,24034,24396,24912,25017,25058,25613,
26048,26276,26350,26498,26634,26958,27297,27619,27690,28186,
28291,28349,28516,28679,28726,28879,29081,29130,29292,29382,
29965,30050,30402,30484,30681,31128,31153,31265,31374,31444,
31682,32011,   47,   80,  129,  211,  216,  226,  339,  541,
  636,  674,  681,  808,  823,  920, 1034, 1083, 1216, 1442,
 1506, 1559, 1582, 1586, 1662, 1678, 2120, 2133, 2164, 2206,
 2438, 2554, 2608, 2767, 2853, 2890, 2924, 2982, 3075, 3194,
 3286, 3332, 3420, 3474, 3495, 3556, 3588, 3794, 3898, 4315,
 4494, 4510, 4539, 4773, 4849, 4885, 4898, 4927, 4952, 5046,
 5196, 5299, 5326, 5446, 5515, 5525, 5598, 5609, 5632, 5650,
 5912, 5924, 6237, 6259, 6266, 6395, 6446, 6664, 6725, 6729,
 6766, 6805, 6929, 6939, 6987, 7038, 7328, 7363, 7606, 7620,
 7700, 7777, 7982, 8010, 8130, 8186, 8281, 8300, 8350, 8461,
 8553, 8590, 8610, 8699, 8720, 8793, 9140, 9183, 9218, 9254,
 9309, 9651, 9817, 9877, 9922, 9926,10002,10030,10047,10122,
10150,10190,10251,10298,10323,10782,10793,10903,10950,11297,
11429,11435,11567,11612,11838,11962,11969,12020,12098,12118,
12124,12130,12298,12407,12446,12564,12644,12779,12801,12873,
13002,13126,13362,13398,13467,13503,13579,13602,13679,13918,
13930,14053,14161,14341,14418,14472,14653,14683,14784,14915,
15074,15254,15291,15364,15390,15494,15574,15646,15670,15777,
15786,15816,15822,15949,16077,16213,16243,16283,16514,16722,
16744,16805,16832,16964,17136,17299,17345,17376,17392,17412,
17424,17592,17620,17697,17861,17909,18077,18189,18298,18314,
18343,18404,18444,18711,18783,18907,18925,19055,19239,19268,
19281,19340,19518,19536,19615,19847,20017,20026,20050,20125,
20173,20254,20269,20283,20357,20372,20431,20569,20615,20697,
20866,20964,21039,21076,21259,21457,21513,21600,21755,22013,
22082,22111,22128,22279,22296,22329,22344,22381,22401,22478,
22950,23003,23059,23313,23350,23556,23757,23810,23838,23899,
23904,23957,23965,24111,24256,24429,24482,24489,24600,24646,
24904,24971,25206,25269,25479,25510,25554,25640,25811,25836,
25990,26072,26077,26126,26244,26345,26546,26589,26711,26771,
26778,26812,26887,26892,26939,26990,27034,27176,27222,27284,
27406,27726,27733,27778,27846,27935,27956,28077,28094,28332,
28367,28416,28433,28567,28830,29002,29058,29220,29227,29244,
29312,29674,29720,29727,30047,30080,30088,30379,30427,30558,
30582,30721,30783,30795,30830,30919,31009,31162,31518,31620,
31824,31943,31955,31981,  467,  591,  695,  870, 1291, 1350,
 1593, 1845, 2263, 2705, 2761, 3403, 3463, 3756, 3764, 3870,
 4456, 4751, 4870, 4909, 5188, 5260, 5376, 5974, 6056, 6541,
 6567, 7076, 7156, 7827, 8382, 8537, 9173, 9316, 9515, 9820,
 9874,10438,11339,11545,11800,12331,12559,12606,13531,13651,
13686,14240,14477,14557,14736,14895,15115,15273,15368,16366,
16926,17562,17576,17748,17870,18112,18754,19364,19483,19605,
19738,20223,20275,20390,21044,21086,21340,23895,24016,24036,
24246,24576,24706,25265,25586,26189,26832,26910,27043,27142,
27231,27512,27750,28820,29301,29989,30035,30212,30539,31017,
31156,31233,31499,31529,31587,  626, 2338, 2586, 3154, 3233,
 5057, 5232, 5859, 6078, 6597, 6628, 8264, 8285, 8868, 9073,
 9157,10041,10715,10831,11252,11366,12549,12921,13174,14140,
14411,15029,16266,16714,16786,17017,17148,17443,18092,18350,
18484,18826,19851,21824,21932,21965,22115,22143,23235,23262,
23341,24117,25216,25685,25957,26603,27354,27392,27492,28172,
28536,28903,28963,29763,30203,30554,30875,31244,31989,  224,
  508, 1792, 3197, 3753, 3884, 4087, 4163, 5012, 6490, 6861,
 7146, 7550, 8564, 9797,10076,10803,10886,12040,12236,12249,
12703,12764,13934,14254,14273,14903,15187,15375,15702,15744,
16188,16408,17548,17991,18240,18395,18911,19113,19318,19907,
21997,22226,22235,22483,22513,23099,23241,24151,24734,24991,
25047,25276,25941,26200,26362,26755,26923,27289,28080,28143,
29879,30574,30605,31075,31553,31770,  329,  528,  777,  979,
 1448, 1840, 2380, 2465, 3131, 3412, 4006, 5024, 5428, 5989,
 6815, 6991, 7215, 7573, 7648, 8273, 8786, 8904, 9803,10218,
10688,11008,11037,11731,12170,12676,13729,16196,16261,16854,
17140,17864,19086,19995,20305,20456,20642,21176,21184,21386,
21434,22171,22246,22404,22920,23462,23663,24667,24889,26022,
26061,26823,27457,27612,27722,28233,28834,28857,29198,29400,
29470,30248,30757,31510,31571,31638,31984,   59,  385,  804,
 1241, 1685, 1849, 1951, 2123, 2601, 2624, 2739, 3112, 3354,
 3417, 4359, 5289, 5507, 5711, 5723, 7322, 7685, 7753, 7912,
 8145, 8305, 8934, 9334, 9339, 9382, 9668,10143,10264,10597,
10891,10948,11052,11742,12262,12307,12418,12697,12819,12963,
13190,13525,13894,13903,15136,15212,15415,15577,15852,15966,
16445,16589,16711,17109,17566,18356,18771,18861,18881,19030,
20178,20246,20310,20553,20931,21446,22376,22777,23127,23248,
23397,23677,23696,24130,25036,25348,25402,25699,26015,26348,
26835,28072,28193,28564,28704,29055,29650,30282,30301,30984,
31038,31240,31725,31838,   52,  599,  653, 1095, 1810, 2011,
 2253, 2501, 2559, 2713, 3467, 4083, 4093, 4132, 4298, 5269,
 5432, 5727, 6031, 6064, 6392, 6660, 6723, 7018, 7296, 7417,
 7809, 8290, 8586, 8989, 9120, 9486, 9537,11190,11479,11663,
11957,12025,12203,12905,13257,13401,13561,13692,13733,14628,
14699,15131,15438,15696,16192,17325,17395,17511,18097,18147,
18169,18322,18847,18973,19260,19324,19337,19408,19827,20952,
21345,21603,21859,21900,22605,22711,22943,23719,23761,24019,
24580,25175,25389,25655,25665,25737,25952,25992,26953,26982,
27325,27378,27470,28110,28441,28805,28906,29115,29715,29812,
29835,30270,30622,31224,31328,31595,   17,   63,  342,  511,
  839,  881, 1120, 1318, 1357, 1976, 2155, 2605, 2617, 2832,
 3120, 3335, 3359, 3668, 3684, 3770, 4113, 4380, 4387, 4916,
 5256, 5393, 5399, 5414, 6144, 6155, 6383, 6877, 7193, 7256,
 7365, 7437, 8116, 9037, 9084, 9327, 9432,10206,10281,10956,
10989,11013,11453,11623,11908,12347,12399,13022,13029,13285,
13586,13657,13681,13745,14177,14349,14402,14482,15064,15400,
15621,15663,15688,15748,16143,16421,16565,17161,17215,17240,
17774,17879,18450,18661,18765,19062,19272,19301,19690,19749,
20065,20584,20613,20672,20679,20879,21015,21812,22424,22539,
22770,23358,23384,23457,23496,24221,24258,24532,24592,24633,
24690,24815,24862,25796,26033,26114,26247,26384,26889,26927,
27211,27386,27543,27667,27801,28091,28150,28498,29294,29514,
29627,29657,29767,29799,29806,30175,30244,30547,31248,31303,
31649,31975,   99,  156,  270,  332,  389,  424,  430,  440,
  477,  505,  518,  663,  683,  797,  922,  931,  984, 1055,
 1194, 1202, 1206, 1229, 1271, 1283, 1299, 1381, 1404, 1568,
 1607, 1610, 1638, 1659, 1733, 1736, 1806, 1836, 1935, 1955,
 1982, 1987, 2068, 2113, 2137, 2162, 2228, 2332, 2377, 2391,
 2407, 2429, 2461, 2516, 2542, 2744, 2769, 2785, 2818, 2826,
 2843, 2887, 2903, 3015, 3107, 3237, 3294, 3368, 3374, 3406,
 3534, 3573, 3708, 3733, 3809, 3844, 3856, 3950, 3980, 4057,
 4080, 4097, 4128, 4231, 4282, 4309, 4344, 4349, 4353, 4453,
 4492, 4514, 4567, 4575, 4619, 4814, 4841, 4851, 4857, 4867,
 4879, 4941, 5016, 5088, 5129, 5146, 5191, 5294, 5312, 5347,
 5404, 5496, 5510, 5572, 5612, 5617, 5670, 5825, 5835, 5910,
 6010, 6048, 6099, 6160, 6179, 6214, 6235, 6268, 6308, 6341,
 6380, 6397, 6444, 6473, 6479, 6549, 6555, 6611, 6615, 6744,
 6818, 6927, 6977, 7123, 7153, 7176, 7185, 7221, 7305, 7330,
 7535, 7544, 7775, 7789, 7795, 7815, 7824, 7872, 7897, 7958,
 7977, 8022, 8030, 8156, 8225, 8319, 8324, 8389, 8401, 8452,
 8487, 8526, 8555, 8566, 8657, 8694, 8739, 8889, 9051, 9067,
 9108, 9186, 9220, 9225, 9263, 9270, 9289, 9303, 9361, 9444,
 9502, 9542, 9643, 9742, 9762, 9813, 9853, 9911, 9943,10035,
10055,10064,10120,10258,10273,10287,10332,10372,10431,10442,
10486,10571,10583,10593,10615,10619,10626,10683,10704,10709,
10725,10779,10834,11045,11075,11167,11248,11302,11336,11351,
11414,11447,11462,11483,11562,11577,11593,11660,11750,11820,
11840,11982,12062,12068,12190,12198,12230,12245,12303,12432,
12514,12557,12568,12583,12694,12720,12723,12739,12757,12791,
12794,12824,12834,12870,12943,12959,13118,13187,13196,13250,
13261,13267,13279,13301,13505,13583,13598,13707,13824,13839,
13906,13915,13956,14056,14069,14089,14142,14217,14229,14268,
14302,14310,14319,14325,14355,14487,14625,14643,14691,14860,
14936,14981,14991,15018,15046,15141,15192,15230,15233,15262,
15296,15304,15392,15396,15474,15519,15580,15637,15866,15869,
15981,15986,16016,16033,16040,16081,16129,16139,16151,16200,
16360,16460,16569,16624,16675,16716,16747,16754,16794,16802,
16807,16821,16827,16847,16861,16898,16912,16929,17030,17236,
17316,17342,17364,17390,17476,17479,17690,17695,17721,17734,
17795,17872,17876,17945,17949,17995,17999,18012,18019,18154,
18181,18208,18245,18265,18296,18353,18472,18492,18501,18508,
18742,18748,18777,18818,18828,18923,18961,18977,19015,19034,
19122,19264,19329,19352,19425,19440,19487,19512,19613,19626,
19642,19665,19694,19813,19841,19849,19865,19903,20023,20087,
20103,20108,20271,20355,20374,20380,20385,20403,20558,20604,
20621,20650,20694,20700,20980,20994,21000,21010,21060,21133,
21166,21211,21215,21244,21248,21257,21283,21414,21461,21470,
21553,21609,21699,21732,21807,21841,21850,21902,21930,21942,
21969,22177,22281,22294,22341,22359,22396,22399,22490,22515,
22527,22571,22601,22608,22630,22696,22932,22941,22966,22995,
23047,23067,23084,23108,23144,23151,23245,23354,23370,23391,
23448,23488,23559,23643,23700,23709,23723,23778,23885,23908,
24005,24009,24012,24126,24233,24239,24263,24284,24333,24406,
24416,24506,24676,24732,24835,24848,24853,25000,25011,25030,
25122,25126,25170,25262,25293,25306,25439,25477,25482,25550,
25562,25571,25596,25601,25617,25820,25834,25853,26064,26069,
26151,26166,26212,26231,26366,26432,26461,26505,26583,26647,
26688,26726,26744,26758,26804,26896,26900,26956,26973,27095,
27106,27138,27155,27179,27183,27306,27318,27343,27365,27394,
27487,27651,27656,27693,27731,27741,27773,27875,28003,28165,
28274,28431,28462,28502,28529,28557,28569,28572,28662,28674,
28743,28753,28823,28891,28926,29034,29092,29146,29237,29257,
29269,29328,29345,29380,29510,29583,29598,29629,29672,29699,
29734,29828,29882,29969,30017,30096,30104,30114,30166,30171,
30192,30222,30255,30337,30536,30541,30601,30609,30631,30644,
30661,30842,30879,30934,30943,30951,30969,31004,31024,31060,
31151,31169,31296,31322,31381,31397,31405,31556,31627,31693,
31717,31795,31822,31941,31992,  207,  607,  851, 1154, 1435,
 1584, 1747, 2080, 2249, 2596, 2892, 2945, 3030, 3689, 3975,
 4369, 4638, 4690, 4801, 5297, 5899, 6264, 6386, 6796, 6950,
 7058, 7071, 7234, 7714, 7951, 7972, 7995, 8077, 8384, 8986,
 9045, 9256, 9472, 9657, 9792, 9906,10283,10494,11032,11039,
11582,11761,11858,11914,11930,12211,12543,13000,13129,13158,
13163,13276,13447,13653,13782,14264,14718,15094,15108,15249,
15316,15418,15435,15704,15837,16095,16730,16741,16775,17380,
17422,17709,18324,18722,19538,19587,19979,20325,20754,20854,
21094,21163,21205,21575,22109,22277,22356,22625,22734,22788,
23253,23268,23330,24158,24218,24436,24444,24884,25282,26135,
26222,26467,26741,26976,27036,27383,27597,27851,28096,28154,
28198,28295,28329,28493,28837,28958,29021,29280,29297,29801,
30422,30476,30781,30886,31043,31448,31539,31585,31879,32019,
   21,   88,  446,  550,  687,  834, 1471, 1485, 1689, 2468,
 2728, 2994, 3740, 3802, 3893, 5055, 5094, 5152, 5332, 5387,
 5600, 6034, 6274, 6641, 7738, 8012, 8543, 8648, 8865, 8957,
 9138, 9164, 9556,10388,11019,11258,11331,11373,12358,12715,
12978,13409,14559,14618,14638,15179,15270,15691,15875,16211,
16248,16834,17441,17590,17729,17737,17814,17867,18559,18714,
19059,19698,20235,20398,20441,20477,21337,21420,21837,22331,
22613,23194,23280,23499,24113,24337,24385,24421,25256,25544,
25611,25773,25881,26036,26319,26522,26821,27219,27675,28340,
28812,28930,29852,29876,30198,30828,31221,31340,31369,31523,
31569,31615,  779, 1389, 3090, 3383, 3422, 3554, 3677, 3723,
 3953, 4846, 4923, 5464, 5637, 5993, 6006, 6368, 6843, 7528,
 7690, 7698, 7937, 8730, 8751, 8832, 8968, 9423, 9727,10527,
10650,10866,11394,11746,12344,12387,12989,13335,13359,13750,
13856,14344,14404,14897,15121,15640,15798,16100,16325,16338,
16349,16573,16648,17304,18087,18536,19051,19084,19219,19237,
19402,19526,19554,19844,20067,20122,20938,21068,21426,21562,
21568,21581,21788,22498,22564,22673,23945,24312,24780,25373,
25693,25920,26163,26251,26378,26616,26720,26787,27429,27473,
28085,28100,28170,28803,29229,29457,30024,30625,31454,31579,
31709,32008,   72,  421,  487,  672,  692,  706,  734,  774,
  909,  917, 1169, 1214, 1430, 1456, 1562, 1681, 2013, 2512,
 2556, 2720, 2956, 3006, 3026, 3159, 3314, 3779, 3908, 3942,
 4437, 4525, 4679, 4894, 5157, 5435, 5683, 5868, 5893, 5972,
 6106, 6402, 6414, 6431, 6463, 6773, 6924, 6957, 7046, 7207,
 7259, 7300, 7435, 7461, 7510, 7519, 7922, 7990, 8277, 8597,
 8913, 9128, 9144, 9283, 9483, 9629, 9757, 9883, 9996,10471,
10697,10760,10788,10849,10986,11154,11280,11872,12027,12180,
12508,12635,12682,12923,13008,13283,13486,13575,13737,14362,
14439,14606,14659,14843,14857,14863,15215,15459,15572,15659,
15668,15751,15970,16791,17130,17164,17437,17578,17699,17718,
17956,18022,18167,18270,18370,18788,18831,18927,19342,19417,
19638,19676,19899,20166,20195,20243,20292,20460,20665,20690,
20962,21328,21665,21748,21935,22146,22194,22407,22667,22973,
23284,23288,23373,23543,23553,23581,23617,23871,24081,24288,
24535,24652,24686,24708,24802,25015,25624,25636,25697,25962,
26386,26737,26943,27078,27303,27401,27738,27755,27799,27807,
27937,28089,28162,28176,28266,28447,28719,29113,29204,29411,
29476,29529,30082,30093,30118,30679,30754,31123,31164,31181,
31306,31460,31592,31921,31926,  108,  164,  218,  337,  465,
  619,  628,  782,  895,  992,  999, 1032, 1065, 1081, 1174,
 1289, 1410, 1460, 1693, 1739, 1834, 1891, 1943, 1960, 1978,
 2006, 2017, 2046, 2055, 2193, 2454, 2629, 2637, 2662, 2779,
 2799, 2807, 2909, 3144, 3173, 3235, 3278, 3321, 3327, 3465,
 3480, 3605, 3695, 3730, 3774, 3813, 3872, 3928, 4043, 4074,
 4138, 4170, 4341, 4377, 4416, 4558, 4662, 4696, 4738, 4838,
 5010, 5026, 5126, 5198, 5309, 5450, 5454, 5475, 5865, 5920,
 5965, 5980, 6094, 6152, 6167, 6243, 6483, 6668, 6721, 6756,
 6762, 6790, 6883, 7033, 7163, 7359, 7394, 7404, 7563, 7580,
 7601, 7717, 7748, 7878, 8004, 8026, 8153, 8207, 8313, 8340,
 8476, 8491, 8550, 8571, 8612, 8691, 8709, 8837, 8909, 8925,
 8962, 8975, 8992, 9324, 9367, 9458, 9633, 9698, 9731,10008,
10023,10070,10318,10338,10383,10445,10489,10610,10631,10862,
10905,10908,11001,11215,11285,11419,11432,11533,11713,11718,
11734,11921,11935,11991,12140,12227,12238,12326,12354,12553,
12726,12821,12880,12992,13172,13319,13340,13403,13604,13754,
13889,14042,14094,14113,14130,14159,14293,14372,14492,14534,
14611,14646,14889,14913,14926,14984,15006,15171,15258,15485,
15526,15625,15708,15782,15872,15999,16047,16137,16170,16186,
16276,16396,16434,16544,16605,16672,16724,16812,16856,16943,
16976,17142,17146,17183,17192,17205,17292,17347,17418,17500,
17594,17606,17750,17811,18099,18124,18305,18575,18632,18673,
18758,18779,18856,18877,18909,18937,19288,19470,19550,19687,
19791,19795,19837,19862,19892,19913,19925,20063,20208,20240,
20320,20574,20762,20791,20837,20967,21002,21314,21331,21533,
21629,21782,21791,21829,21927,21960,22007,22039,22099,22136,
22428,22511,22558,22567,22660,22871,22922,22929,23071,23148,
23428,23510,23520,23537,23568,23633,23655,23683,23764,23781,
23831,23840,23852,23940,24055,24316,24391,24486,24543,24548,
24640,24664,24715,24793,25088,25107,25155,25244,25355,25422,
25460,25552,25732,25850,25977,26131,26178,26394,26399,26435,
26447,26608,26621,26650,26691,26748,26794,26829,26916,27041,
27085,27101,27158,27521,27560,27583,27710,27862,28036,28070,
28107,28126,28383,28424,28627,28634,28666,28712,28746,28965,
29108,29141,29191,29224,29233,29260,29274,29325,29441,29578,
29639,29784,29816,29856,29987,30186,30228,30252,30265,30279,
30340,30387,30399,30405,30450,30492,30655,30675,30689,30937,
30953,31000,31108,31118,31158,31429,31600,31611,31875,31930,
31967,   36,   66,   75,  536,  667,  968, 1007, 1020, 1061,
 1233, 1538, 1842, 1973, 2118, 2189, 2213, 2371, 2531, 2773,
 2796, 2810, 3345, 3510, 3654, 3686, 3934, 4243, 4253, 4296,
 4614, 4652, 4756, 5111, 5276, 5341, 5438, 5522, 5697, 5734,
 5811, 5846, 5991, 6147, 6471, 6639, 6646, 6812, 7128, 7253,
 7349, 7382, 7432, 7614, 7694, 7724, 8175, 8211, 8328, 8412,
 8727, 8857, 8862, 8895, 9427, 9546, 9606, 9684, 9716, 9839,
 9899,10019,10043,10050,10501,10514,10753,10970,11106,11170,
11263,11465,11618,11825,11951,11964,12022,12056,12120,12187,
12223,12673,12946,13096,13103,13132,13344,13497,13761,13830,
13836,13962,14085,14237,14443,14550,14714,14833,14892,15059,
15185,15207,15265,15613,15714,15886,16215,16368,16527,16771,
16824,16980,17042,17094,17254,17369,17435,17569,17600,17917,
18251,18283,18348,18433,18453,18467,18695,18762,18774,19065,
19090,19108,19205,19327,19799,19999,20038,20114,20203,20417,
20482,20660,20705,20846,21262,21274,21320,21844,21888,21920,
21948,22017,22027,22160,22287,22389,22746,22819,23080,23101,
23172,23432,23667,23733,23960,24074,24098,24207,24298,24335,
24620,24660,25021,25066,25117,25189,25489,25605,25759,25777,
26148,26412,26441,26573,26706,26847,27098,27216,27415,27504,
27514,27527,27954,28225,28305,28325,28504,28538,28849,29676,
29693,29704,29859,29920,30368,30394,30544,30764,30804,31007,
31055,31833,31883,31914,31996,  352,  404,  433,  579,  913,
 1069, 1227, 1879, 2049, 2544, 2611, 2656, 2731, 3266, 3392,
 3593, 3601, 4239, 4288, 4303, 4721, 4746, 4770, 5100, 5211,
 5412, 5457, 5806, 6302, 6601, 6679, 6750, 6770, 6821, 7515,
 7645, 7875, 8184, 8392, 8844, 9123, 9567, 9723, 9867,10011,
10084,10422,10700,10769,10837,10992,11400,11443,11651,11793,
11972,12000,12109,12394,12449,12498,13005,13089,13371,13694,
13874,13976,14125,14364,14602,14730,14998,15426,15481,16027,
16164,16228,16452,16567,17158,17488,17743,18200,18512,19038,
19139,19783,20601,20828,21200,21219,21266,21572,21623,21719,
21802,21894,22048,22574,22902,22977,22997,23141,23506,23652,
24058,24088,24327,24694,24796,24981,25111,25251,25576,25620,
25672,25801,26118,26159,26407,26997,27007,27123,27536,27783,
28048,28061,28700,28770,28872,29025,29076,29495,29588,29617,
29646,29724,29872,29908,30820,30826,30923,30963,31051,31068,
31618,31703,31766,31934,   31,  118,  795,  854, 1016, 1311,
 1477, 1631, 1758, 1798, 2060, 2316, 2841, 2932, 3165, 3178,
 3961, 3991, 4258, 4439, 4710, 4944, 4995, 5143, 5250, 5691,
 5768, 5850, 6207, 6420, 6738, 7028, 7182, 7591, 7954, 8095,
 8105, 8112, 8354, 8508, 8600, 9041, 9061, 9277, 9498, 9746,
 9985, 9993,10080,10109,10136,10412,10436,10482,10857,11175,
11766,11776,11789,12060,12319,12434,12592,12807,13078,13328,
13443,13481,13542,13720,14034,14050,14147,14164,14516,15332,
15603,16280,16342,16389,16427,16639,16739,17473,17714,17804,
17823,17980,18143,18150,18688,18839,19077,19348,19393,19476,
19815,19883,20316,20362,20682,20949,20991,21225,21251,21357,
21478,21541,21588,21915,22723,22815,22856,23549,23685,23918,
24701,24777,24818,24840,25456,25591,25790,26081,26124,26191,
26259,26333,26662,27116,27193,27462,27531,27554,27758,27986,
28244,28544,28651,28670,28932,28951,29185,29209,29389,29432,
29958,30234,30238,30461,30800,30979,31219,31842,31890,32005,
  290,  306,  646,  904, 1251, 1578, 1615, 1893, 2031, 2042,
 2075, 2150, 2256, 2323, 2551, 3141, 3309, 3397, 3489, 3982,
 3996, 4035, 4160, 4274, 4506, 4669, 4810, 5034, 5067, 5078,
 5588, 5662, 5871, 6439, 6536, 6776, 6847, 7056, 7198, 7447,
 7560, 7650, 8119, 8371, 8459, 8580, 8880, 9093, 9297, 9573,
 9704,10408,11004,11156,11356,11411,11493,11609,11851,11944,
12004,12485,12529,13208,13314,13332,13984,14121,14136,14232,
14656,14819,14841,14884,15322,15405,15491,15758,15770,15858,
16476,16485,16593,16609,16658,16767,17212,17302,17504,17800,
17927,17972,18257,18520,18652,18670,18871,18889,18931,19164,
19618,19629,19937,20069,20094,20369,20494,20594,20814,20934,
21189,21402,21641,21796,22009,22168,22493,22676,22692,22906,
22963,23041,23183,23466,23706,23828,23912,24270,24546,24810,
25185,25242,25464,25750,25860,26239,26268,26390,26403,26560,
27018,27286,27926,27995,28044,28065,28467,28716,28897,29139,
29251,29407,29503,29732,29846,30190,30297,30359,30646,30775,
31047,31371,31494,31526,31581,31633,31846,   84,  106,  151,
  201,  236,  286,  786,  892, 1103, 1307, 1379, 1397, 1553,
 1619, 1816, 1924, 2038, 2243, 2399, 2567, 2697, 2750, 2918,
 3038, 3161, 3212, 3378, 3477, 3482, 3663, 4000, 4147, 4292,
 4335, 4500, 4520, 4571, 4625, 4729, 4740, 5423, 5623, 5878,
 5904, 5916, 5978, 6021, 6087, 6219, 6498, 6754, 6825, 6973,
 6996, 7170, 7312, 7406, 7610, 7769, 8000, 8080, 8099, 8333,
 8364, 8397, 8472, 8513, 8614, 9344, 9454, 9463, 9527, 9641,
 9809, 9871, 9903, 9931,10015,10305,10455,10518,10565,10654,
10765,11064,11086,11204,11283,11294,11629,11674,11955,12413,
12492,12710,12766,12890,12953,13156,13222,13298,13357,13395,
13450,13516,13577,13757,13879,14061,14598,14608,14663,14758,
14932,14943,15003,15061,15069,15100,15308,15812,15846,15879,
15891,15956,16054,16207,16223,16372,16653,16733,17056,17201,
17219,17288,17514,17723,18081,18140,18195,18590,18708,18820,
19118,19131,19144,19404,19455,19489,19531,19735,19854,20162,
20265,20405,20424,20466,20504,20640,20777,20824,20958,20987,
21051,21272,21324,21364,21545,21616,22348,22414,22617,22754,
22893,22898,22970,22984,23105,23111,23132,23393,23436,23503,
23674,23948,24321,24347,24403,24414,24432,24671,24719,24773,
25083,25095,25166,25238,25392,25452,25494,25893,26171,26235,
26536,26567,26802,27166,27204,27266,27467,27715,27864,27941,
27959,28471,28489,28552,28919,29008,29072,29707,29822,30055,
30084,30158,30182,30289,30346,30500,30726,30749,31175,31206,
31229,31344,31384,31415,31521,31548,31818,31897,31951,  249,
  320,  458, 1180, 1344, 1412, 1494, 1965, 1985, 2522, 2579,
 2644, 2881, 2978, 3150, 3517, 3939, 4262, 4372, 4443, 4462,
 4664, 4734, 5322, 5482, 5887, 5986, 6101, 6204, 6224, 6351,
 6426, 6502, 6686, 7110, 7132, 7846, 7942, 7968, 8714, 8798,
 9027, 9136, 9351, 9369, 9612, 9623, 9637, 9864,10534,10622,
10661,10869,11160,11188,11614,11653,11875,12008,12054,12104,
12168,12350,12404,12717,12811,13264,13464,13862,14106,14117,
14156,14256,14462,14529,14825,14899,15053,15553,16323,16393,
16557,17318,17371,17431,17490,17745,17904,18051,18160,18308,
18362,18726,18786,18849,19217,19509,19636,19727,20709,20819,
20893,21237,21508,21538,21579,21712,22023,22105,22505,22762,
23055,23260,23579,24166,24466,24807,24881,25227,25407,25470,
25484,25632,25831,26011,26129,26137,26312,26338,26734,26935,
26962,27028,27426,27879,28196,28307,28314,28374,28540,28750,
28839,28956,29051,29103,29193,29481,29980,30031,30356,30410,
30466,30833,30976,31253,31312,31450,31544,   40,  111,  205,
  281,  294,  315,  417,  523,  708,  831,  846, 1005, 1053,
 1164, 1402, 1451, 1665, 1697, 2326, 2658, 2792, 2894, 3011,
 3268, 3387, 3528, 3542, 3559, 4166, 4768, 5060, 5073, 5082,
 5109, 5206, 5215, 5237, 5281, 5569, 5583, 6066, 6376, 6851,
 6960, 7026, 7050, 7308, 7376, 7589, 7634, 7740, 7901, 8275,
 8360, 8493, 8873, 8980, 8995, 9146, 9247, 9662, 9886, 9936,
 9955,10390,10451,10606,10695,10784,10825,10859,11265,11530,
11644,11756,11941,12176,12309,12375,12538,12613,12984,13061,
13161,13215,13555,13701,13853,13980,14017,14024,14099,14282,
14495,14836,15086,15111,15201,15479,15561,15826,15849,15977,
16090,16156,16256,16272,16385,16814,16907,16920,17034,17194,
17252,17741,17808,17984,18105,18372,18447,18529,18666,19459,
19942,20080,20186,20280,20413,20444,20486,20580,20759,20804,
20839,20863,20885,21168,22032,22046,22052,22088,22133,22182,
22192,22336,22364,22545,22657,22934,23470,23731,23737,24053,
24065,24195,24203,24227,24329,24453,24684,24723,24785,24929,
25113,25234,25368,25396,25874,26456,26564,26789,26817,27146,
27163,27372,27421,27509,27568,27599,27680,27781,27858,27966,
28271,28481,28709,28870,28876,28888,29151,29611,30003,30146,
30293,30618,30670,30948,31508,31873,   29,  196,  450,  731,
  738,  790, 1048, 1074, 1156, 1269, 1365, 1466, 1482, 1576,
 1635, 1761, 1861, 2126, 2187, 2202, 2218, 2258, 2346, 2355,
 2363, 2423, 2527, 2633, 2694, 3105, 3139, 3226, 3305, 3505,
 3552, 3565, 3599, 3693, 3705, 3738, 3767, 3920, 4033, 4055,
 4156, 4424, 4429, 4475, 4580, 4642, 4658, 4683, 4703, 4748,
 5103, 5242, 5287, 5337, 5418, 5639, 5652, 5731, 5766, 5791,
 5970, 6019, 6052, 6073, 6190, 6251, 6283, 6388, 6672, 6681,
 6731, 6742, 6808, 7008, 7143, 7229, 7386, 7455, 7593, 7604,
 7622, 7630, 7703, 7726, 7733, 7831, 7881, 7949, 8416, 8480,
 8484, 8575, 8654, 8722, 8854, 8927, 8940, 8949, 8966, 9032,
 9082, 9095, 9114, 9166, 9602, 9702, 9844, 9881, 9913,10100,
10115,10139,10285,10377,10589,10638,10817,10877,10899,10912,
11141,11236,11360,11376,11386,11439,11535,11595,11831,12233,
12289,12363,12384,12562,12588,12829,12930,13027,13076,13086,
13092,13375,13483,13492,13499,13538,13646,13725,13766,13774,
13970,14287,14333,14431,14459,14512,14563,14614,14853,14873,
15080,15241,15318,15326,15372,15383,15503,15599,15608,15830,
15842,15952,16097,16182,16250,16437,16457,16518,16601,16937,
16974,16989,16996,17050,17103,17151,17283,17310,17330,17821,
17828,17965,18057,18069,18085,18131,18136,18285,18366,18380,
18390,18458,18505,18675,18683,18943,19098,19104,19152,19168,
19173,19306,19414,19419,19432,19545,19593,19631,19658,19832,
19982,20032,20053,20098,20199,20298,20451,20740,20749,21089,
21196,21230,21369,21406,21586,21627,21660,21717,21741,21758,
21827,21937,21984,22150,22410,22476,22589,22716,22802,22880,
23065,23118,23179,23196,23203,23266,23344,23525,23573,23749,
23823,23833,23916,23936,24062,24072,24093,24278,24310,24426,
24629,24826,24870,24899,25026,25039,25080,25152,25223,25351,
25363,25578,25695,25755,25840,25843,25871,26004,26027,26054,
26326,26463,26510,26550,26641,26717,27005,27046,27279,27299,
27333,27352,27360,27381,27516,27787,27797,27884,27890,27919,
27945,28189,28284,28336,28426,28612,28622,28630,28644,28702,
28915,29121,29137,29211,29231,29248,29319,29348,29430,29527,
29606,29661,29669,29778,29793,29848,30028,30072,30214,30303,
30473,30587,30637,30651,30767,31072,31106,31131,31188,31336,
31365,31394,31402,31565,31829,31918,31923,31998,32013,32029,
  135,  253,  262,  274,  400,  470,  502,  530,  533,  576,
  583,  614,  623,  630,  633,  677,  685,  793,  819,  865,
  990,  995, 1028, 1110, 1235, 1255, 1276, 1281, 1309, 1315,
 1407, 1487, 1546, 1551, 1613, 1753, 1777, 1800, 1820, 1831,
 1922, 2029, 2058, 2077, 2148, 2167, 2175, 2225, 2236, 2304,
 2314, 2321, 2403, 2433, 2457, 2565, 2576, 2775, 2783, 2813,
 2927, 2934, 2938, 2954, 3023, 3093, 3100, 3190, 3208, 3224,
 3264, 3274, 3280, 3376, 3613, 3618, 3700, 3725, 3776, 3787,
 3849, 3859, 3877, 3902, 3910, 3947, 3988, 4116, 4265, 4278,
 4508, 4612, 4673, 4708, 4716, 4725, 4758, 4821, 4829, 4883,
 4935, 4958, 4998, 5063, 5069, 5118, 5138, 5194, 5221, 5314,
 5426, 5492, 5517, 5706, 5729, 5772, 5784, 5821, 5838, 5953,
 5996, 6046, 6103, 6182, 6199, 6217, 6232, 6277, 6300, 6362,
 6365, 6461, 6534, 6591, 6608, 6625, 6644, 6650, 6736, 6830,
 6869, 6886, 6955, 6985, 7137, 7160, 7174, 7232, 7265, 7316,
 7346, 7415, 7491, 7496, 7554, 7570, 7643, 7722, 7811, 7934,
 7965, 7980, 8034, 8103, 8165, 8188, 8201, 8261, 8283, 8309,
 8330, 8342, 8369, 8406, 8449, 8510, 8539, 8568, 8578, 8899,
 8971, 8977, 9043, 9059, 9110, 9125, 9179, 9242, 9267, 9295,
 9342, 9418, 9436, 9452, 9474, 9517, 9677, 9696, 9735, 9862,
 9940,10021,10027,10038,10181,10195,10226,10234,10267,10296,
10316,10336,10467,10480,10522,10586,10762,10767,10773,10791,
10839,10879,10884,10999,11024,11081,11096,11108,11138,11177,
11228,11233,11391,11398,11405,11540,11626,11637,11649,11670,
11678,11739,11768,11796,11856,11939,11997,12015,12101,12160,
12255,12313,12339,12411,12453,12489,12496,12522,12571,12594,
12621,12748,12773,12777,12876,12925,12935,12994,13015,13111,
13142,13367,13381,13393,13512,13518,13552,13666,13828,13978,
13982,13988,14038,14059,14083,14102,14145,14220,14244,14452,
14503,14508,14520,14540,14545,14677,14745,14797,14823,14881,
14901,14945,14978,15036,15217,15222,15247,15294,15378,15423,
15456,15498,15505,15558,15586,15623,15628,15642,15685,15773,
15788,15810,15854,15902,16060,16161,16221,16278,16320,16332,
16379,16431,16551,16616,16627,16636,16646,16778,16789,16915,
16945,17045,17054,17114,17120,17134,17170,17231,17290,17354,
17399,17406,17416,17528,17533,17573,17586,17602,17731,17769,
17883,17896,18017,18054,18061,18121,18184,18202,18301,18487,
18525,18549,18577,18597,18690,18724,18835,18854,18893,18896,
18902,18920,18956,18964,18968,19009,19017,19022,19235,19249,
19312,19332,19422,19449,19463,19474,19491,19501,19515,19548,
19589,19717,19819,19867,19897,19935,19988,20002,20056,20112,
20132,20189,20217,20238,20360,20419,20469,20587,20592,20656,
20668,20736,20752,20809,20821,20891,21025,21066,21072,21146,
21157,21174,21221,21255,21270,21279,21342,21510,21621,21707,
21752,21784,21800,21822,21956,22123,22158,22187,22230,22275,
22290,22305,22311,22393,22434,22509,22517,22537,22549,22576,
22595,22683,22752,22799,22813,22854,22975,22982,23103,23157,
23191,23206,23250,23286,23301,23305,23315,23320,23337,23434,
23484,23638,23665,23713,23774,23848,23854,24007,24067,24123,
24148,24162,24230,24293,24325,24412,24459,24473,24495,24597,
24637,24703,24713,24729,24782,24800,24860,24933,25102,25105,
25180,25198,25249,25447,25506,25538,25569,25593,25660,25690,
25739,25764,25781,25792,25808,25858,25866,25879,26009,26018,
26038,26155,26161,26181,26206,26308,26380,26418,26444,26532,
26585,26605,26698,26767,26809,26850,26885,26904,26937,26945,
26964,26985,27014,27091,27113,27172,27185,27224,27294,27465,
27502,27533,27587,27603,27771,27840,27866,27911,27932,27939,
28068,28087,28139,28160,28168,28309,28370,28376,28386,28445,
28457,28484,28513,28533,28548,28615,28640,28653,28688,28748,
28801,28818,29053,29099,29235,29253,29282,29306,29309,29339,
29450,29459,29536,29570,29590,29678,29701,29711,29774,29818,
29874,29887,29962,29978,30033,30091,30208,30262,30342,30385,
30435,30563,30568,30595,30806,30822,30866,30872,30884,30928,
30988,31033,31040,31113,31125,31184,31197,31214,31269,31349,
31439,31516,31531,31550,31602,31624,31746,31782,31799,31835,
31886,31905,31945,31963,32003,32032,   77,  888,  902, 1543,
 1875, 2139, 2349, 2752, 2916, 2963, 3040, 3180, 3661, 3715,
 3984, 4060, 4194, 4319, 4356, 5113, 5209, 5602, 5666, 5890,
 7180, 7205, 7244, 7891, 7929, 8410, 8457, 8746, 8878, 9493,
 9522, 9614, 9753,10238,10403,11084,11239,11570,11667,11974,
12510,12975,13057,13101,13389,13458,13941,14078,14115,14166,
14284,14621,14725,15442,15466,15958,16203,16258,16291,16773,
17089,17373,17902,18455,18541,18935,20096,20307,20565,20638,
20844,20989,21633,21972,22035,22103,22180,22861,22968,23077,
23516,23564,23645,24248,24276,24578,24682,24725,25075,25412,
25804,25935,26143,26278,27121,27227,27712,27981,28039,28248,
29272,29613,29910,30057,30108,30431,30584,30744,30791,31049,
31688,31969,  234,  406,  496,  525,  548,  841, 1395, 1453,
 1626, 2195, 3028, 3363, 4268, 4312, 4337, 4955, 4992, 5203,
 5634, 5906, 6054, 6193, 6348, 6496, 6635, 6786, 6914, 7140,
 7384, 7517, 8020, 9098, 9346, 9408,10088,10223,10320,11027,
11363,11655,11724,11834,11904,12328,12416,12533,12578,12633,
13274,13330,13547,13881,14279,14490,14941,15098,15472,15555,
15593,15893,15988,16075,17333,17420,17581,17686,17763,17941,
18126,18465,18822,18945,19246,19292,19453,19881,19985,20492,
20707,20816,21049,21187,21362,21614,21925,22041,23570,24115,
24393,24464,24673,24805,24927,25008,25194,25405,25622,25928,
26614,27496,27538,27765,27810,28046,28491,29046,29085,29321,
29506,29573,29635,29685,30752,31002,31994,   23,  143,  194,
  203,  240,  246,  292,  312,  325,  347,  402,  412,  419,
  443,  448,  490,  586,  644,  702,  736,  772,  849,  897,
  906, 1003, 1036, 1051, 1067, 1113, 1166, 1192, 1237, 1248,
 1297, 1363, 1368, 1377, 1391, 1400, 1458, 1479, 1509, 1574,
 1597, 1617, 1633, 1654, 1695, 1756, 1787, 1796, 1855, 1940,
 2062, 2072, 2142, 2184, 2200, 2245, 2277, 2311, 2344, 2353,
 2369, 2382, 2401, 2415, 2426, 2498, 2598, 2642, 2654, 2699,
 2710, 2722, 2765, 2781, 2794, 2804, 2828, 2896, 2930, 3000,
 3008, 3013, 3096, 3115, 3134, 3270, 3302, 3329, 3428, 3530,
 3536, 3544, 3549, 3591, 3603, 3648, 3671, 3679, 3703, 3749,
 3762, 3772, 3800, 3874, 3944, 3970, 3998, 4091, 4107, 4141,
 4151, 4178, 4186, 4229, 4234, 4241, 4286, 4323, 4364, 4441,
 4464, 4489, 4544, 4553, 4640, 4647, 4676, 4688, 4694, 4732,
 4853, 4964, 5036, 5039, 5091, 5098, 5106, 5124, 5135, 5200,
 5224, 5245, 5278, 5343, 5384, 5389, 5462, 5466, 5487, 5527,
 5532, 5621, 5625, 5641, 5672, 5689, 5703, 5763, 5789, 5823,
 5885, 6036, 6068, 6117, 6165, 6221, 6255, 6346, 6370, 6378,
 6404, 6418, 6428, 6467, 6477, 6599, 6648, 6674, 6740, 6752,
 6778, 6823, 6920, 6937, 7048, 7066, 7150, 7158, 7196, 7237,
 7261, 7270, 7337, 7357, 7380, 7392, 7410, 7440, 7513, 7526,
 7552, 7587, 7595, 7599, 7612, 7616, 7637, 7641, 7692, 7696,
 7728, 7760, 7799, 7819, 7939, 7944, 7947, 7988, 8088, 8097,
 8230, 8307, 8326, 8338, 8344, 8352, 8414, 8419, 8464, 8489,
 8496, 8506, 8548, 8573, 8592, 8643, 8753, 8762, 8777, 8842,
 8885, 8911, 8964, 8982, 9053, 9063, 9116, 9222, 9249, 9279,
 9314, 9319, 9363, 9373, 9376, 9379, 9425, 9429, 9456, 9466,
 9520, 9525, 9549, 9706, 9725, 9848, 9859, 9879, 9929, 9987,
 9991,10017,10025,10058,10067,10134,10201,10255,10303,10311,
10340,10369,10381,10385,10399,10440,10492,10499,10516,10525,
10652,10656,10669,10679,10776,10796,10805,10810,10820,10855,
10897,10981,10994,11006,11059,11099,11143,11152,11210,11328,
11358,11371,11409,11416,11449,11470,11488,11525,11588,11736,
11771,11814,11827,11946,12002,12010,12034,12045,12058,12065,
12114,12185,12291,12315,12321,12356,12366,12373,12423,12494,
12503,12527,12590,12601,12623,12628,12707,12728,12788,12796,
12809,12882,12914,12927,12932,12955,12967,13010,13025,13063,
13154,13322,13337,13378,13405,13411,13452,13462,13469,13479,
13495,13535,13591,13633,13640,13677,13699,13715,13759,13851,
13927,13936,13947,13960,13986,14123,14225,14246,14258,14289,
14330,14434,14457,14466,14497,14531,14543,14593,14600,14640,
14685,14728,14747,14788,14827,14839,14865,14871,14886,14911,
14924,14930,14934,14996,15001,15040,15043,15051,15088,15177,
15182,15197,15203,15330,15398,15477,15489,15644,15706,15802,
15844,15941,15946,15954,15983,15997,16013,16020,16102,16154,
16159,16209,16226,16233,16263,16357,16370,16387,16391,16411,
16429,16439,16478,16521,16529,16536,16641,16651,16656,16660,
16704,16758,16762,16901,16940,16957,16984,16992,17012,17052,
17058,17116,17123,17154,17199,17210,17221,17357,17383,17486,
17544,17555,17560,17618,17673,17701,17756,17785,17797,17816,
17874,17898,17911,17919,17925,17974,17982,18005,18049,18079,
18145,18162,18213,18268,18287,18293,18345,18382,18439,18523,
18588,18592,18637,18699,18706,18746,18756,18760,18929,19036,
19049,19067,19075,19079,19102,19224,19252,19406,19412,19468,
19478,19507,19520,19533,19552,19620,19685,19720,19732,19747,
19778,19801,19856,19885,19977,20015,20030,20061,20085,20092,
20119,20210,20229,20256,20296,20318,20364,20383,20393,20407,
20426,20436,20453,20506,20546,20571,20578,20607,20841,20869,
20877,20883,20936,20972,21057,21121,21138,21161,21191,21198,
21208,21235,21239,21333,21372,21404,21474,21518,21531,21536,
21584,21639,21643,21657,21697,21794,21804,21952,21963,22011,
22030,22090,22096,22213,22308,22322,22327,22362,22367,22387,
22391,22412,22420,22431,22437,22495,22522,22592,22619,22665,
22704,22721,22725,22732,22739,22760,22869,22958,23082,23130,
23139,23185,23237,23255,23282,23290,23339,23368,23426,23455,
23501,23547,23551,23577,23681,23690,23704,23746,23776,23821,
23826,23845,23850,23890,23910,23920,23926,24001,24051,24069,
24095,24142,24164,24216,24225,24296,24319,24331,24345,24349,
24401,24442,24602,24622,24642,24696,24699,24775,25013,25068,
25093,25099,25109,25157,25164,25211,25225,25229,25236,25240,
25253,25308,25366,25375,25437,25472,25508,25574,25580,25646,
25653,25670,25745,25876,25923,25975,26025,26139,26157,26173,
26183,26233,26237,26242,26254,26266,26324,26342,26388,26401,
26405,26465,26520,26562,26569,26632,26644,26652,26732,26739,
26750,26774,26780,26799,26819,26838,26894,26988,27022,27083,
27104,27109,27132,27149,27195,27208,27264,27268,27291,27367,
27424,27529,27550,27610,27664,27703,27736,27776,27842,27860,
27881,27892,27898,27909,27921,27952,27961,27983,28063,28229,
28287,28316,28323,28379,28465,28519,28526,28542,28624,28686,
28692,28729,28755,28768,28774,28828,28913,28934,28998,29027,
29036,29048,29094,29097,29132,29144,29154,29195,29207,29262,
29392,29405,29409,29417,29438,29522,29663,29691,29760,29814,
29833,29844,29850,29905,29972,29982,29995,30001,30019,30053,
30062,30077,30086,30116,30152,30180,30231,30257,30286,30305,
30348,30354,30361,30389,30397,30412,30443,30490,30530,30570,
30798,30802,30835,30850,30869,30957,30971,31030,31045,31053,
31066,31070,31116,31134,31200,31204,31227,31332,31346,31360,
31424,31458,31492,31506,31513,31546,31635,31720,31728,31750,
31764,31768,31785,31788,31831,31844,31953,31965,31986,32000,
   38,   68,   86,  104,  116,  138,  148,  153,  162,  166,
  199,  243,  283,  288,  301,  317,  322,  350,  409,  414,
  456,  460,  463,  520,  589,  617,  621,  660,  665,  670,
  690,  698,  719,  727,  788,  801,  829,  867,  872,  885,
  915,  925,  933,  961,  976,  997, 1009, 1013, 1018, 1025,
 1071, 1092, 1100, 1159, 1162, 1178, 1222, 1231, 1278, 1313,
 1374, 1417, 1432, 1437, 1445, 1464, 1492, 1496, 1540, 1580,
 1601, 1641, 1647, 1667, 1676, 1691, 1728, 1741, 1750, 1764,
 1780, 1783, 1803, 1813, 1852, 1864, 1872, 1929, 1937, 1962,
 1967, 2000, 2015, 2020, 2035, 2040, 2082, 2145, 2173, 2181,
 2216, 2261, 2271, 2308, 2328, 2361, 2389, 2396, 2412, 2421,
 2431, 2443, 2459, 2510, 2525, 2534, 2549, 2570, 2627, 2631,
 2639, 2707, 2733, 2755, 2777, 2801, 2839, 2851, 2884, 2906,
 2921, 2940, 2951, 2960, 2980, 2990, 3003, 3036, 3046, 3080,
 3103, 3128, 3157, 3163, 3168, 3175, 3210, 3217, 3276, 3283,
 3311, 3316, 3340, 3380, 3390, 3394, 3414, 3424, 3484, 3491,
 3515, 3525, 3539, 3562, 3577, 3597, 3611, 3651, 3665, 3691,
 3712, 3759, 3781, 3847, 3866, 3880, 3889, 3912, 3926, 3937,
 3957, 3977, 4004, 4045, 4053, 4078, 4110, 4122, 4125, 4158,
 4255, 4260, 4276, 4280, 4290, 4306, 4326, 4346, 4367, 4374,
 4384, 4390, 4418, 4486, 4522, 4531, 4550, 4573, 4623, 4627,
 4650, 4671, 4685, 4705, 4719, 4727, 4754, 4761, 4808, 4812,
 4823, 4827, 4836, 4859, 4892, 4904, 4929, 5042, 5048, 5065,
 5080, 5132, 5141, 5154, 5186, 5213, 5217, 5248, 5263, 5267,
 5307, 5320, 5381, 5421, 5444, 5477, 5484, 5494, 5503, 5520,
 5541, 5586, 5590, 5594, 5607, 5644, 5664, 5681, 5700, 5716,
 5721, 5770, 5796, 5802, 5808, 5819, 5841, 5848, 5852, 5901,
 5918, 5967, 6004, 6023, 6061, 6075, 6089, 6114, 6150, 6175,
 6201, 6209, 6241, 6249, 6262, 6272, 6288, 6297, 6338, 6354,
 6360, 6422, 6437, 6450, 6485, 6565, 6573, 6576, 6582, 6588,
 6603, 6622, 6662, 6666, 6684, 6692, 6734, 6748, 6760, 6798,
 6810, 6845, 6849, 6880, 6916, 6963, 6975, 6980, 6994, 6998,
 7011, 7020, 7024, 7030, 7054, 7063, 7114, 7126, 7134, 7209,
 7226, 7251, 7267, 7310, 7314, 7340, 7354, 7370, 7427, 7489,
 7494, 7523, 7558, 7566, 7582, 7625, 7712, 7731, 7735, 7767,
 7839, 7844, 7893, 7899, 7956, 7963, 7970, 7975, 7985, 7993,
 7998, 8006, 8014, 8017, 8028, 8066, 8071, 8075, 8101, 8107,
 8110, 8124, 8128, 8170, 8194, 8216, 8270, 8335, 8366, 8373,
 8395, 8470, 8478, 8503, 8515, 8541, 8582, 8595, 8646, 8659,
 8666, 8674, 8678, 8711, 8716, 8724, 8737, 8743, 8781, 8796,
 8801, 8876, 8882, 8893, 8897, 8920, 8942, 8947, 8951, 8960,
 8984, 8997, 9025, 9039, 9080, 9130, 9148, 9228, 9239, 9258,
 9292, 9299, 9311, 9353, 9461, 9477, 9480, 9496, 9529, 9540,
 9552, 9558, 9604, 9608, 9626, 9631, 9635, 9639, 9660, 9681,
 9692, 9700, 9755, 9811, 9837, 9841, 9856, 9901, 9920, 9933,
 9950, 9953, 9957, 9999,10006,10061,10082,10097,10102,10107,
10117,10130,10187,10204,10245,10270,10278,10406,10420,10424,
10428,10433,10453,10457,10474,10484,10506,10520,10567,10602,
10608,10635,10641,10702,10722,10755,10771,10786,10851,10864,
10874,10881,10910,10918,10973,11015,11021,11034,11079,11094,
11146,11149,11158,11182,11201,11221,11230,11242,11245,11254,
11260,11268,11354,11383,11388,11441,11467,11473,11490,11538,
11557,11560,11572,11616,11620,11647,11672,11676,11715,11720,
11744,11758,11778,11784,11791,11798,11803,11849,11877,11919,
11925,11933,11966,11979,12013,12029,12037,12052,12107,12145,
12150,12153,12178,12209,12216,12241,12324,12333,12381,12389,
12392,12427,12439,12444,12451,12487,12540,12545,12551,12598,
12611,12639,12692,12712,12746,12752,12759,12768,12799,12838,
12867,12888,12892,12896,12948,12972,12997,13019,13066,13070,
13094,13099,13108,13114,13134,13149,13169,13178,13199,13205,
13296,13312,13317,13365,13373,13386,13445,13472,13501,13540,
13544,13594,13600,13606,13648,13668,13712,13718,13722,13741,
13752,13763,13772,13780,13844,13848,13865,13872,13876,13896,
13900,13920,13939,13968,14026,14047,14075,14080,14109,14150,
14211,14214,14222,14262,14296,14335,14346,14360,14366,14374,
14420,14427,14441,14445,14469,14500,14505,14510,14514,14518,
14548,14561,14616,14666,14670,14675,14716,14795,14801,14816,
14821,14846,14948,15022,15067,15071,15083,15096,15106,15113,
15119,15168,15174,15219,15225,15239,15268,15283,15301,15320,
15324,15381,15387,15403,15420,15428,15444,15447,15463,15469,
15507,15568,15583,15605,15631,15675,15679,15693,15712,15716,
15756,15768,15780,15793,15808,15818,15839,15864,15881,15895,
15938,15975,16006,16025,16043,16049,16052,16068,16092,16135,
16172,16184,16230,16254,16270,16274,16334,16340,16382,16406,
16481,16539,16546,16554,16559,16591,16595,16607,16611,16634,
16663,16666,16707,16735,16769,16780,16810,16817,16836,16868,
16904,16909,16918,16934,16947,16968,16987,16998,17015,17022,
17032,17037,17105,17144,17196,17217,17233,17320,17339,17349,
17360,17366,17378,17429,17433,17439,17492,17497,17506,17516,
17520,17536,17588,17596,17634,17638,17667,17670,17676,17693,
17716,17759,17776,17802,17806,17819,17931,17959,17963,17986,
18063,18072,18083,18107,18114,18129,18138,18193,18206,18259,
18281,18290,18311,18326,18340,18360,18364,18374,18378,18402,
18436,18442,18470,18495,18510,18527,18543,18547,18561,18580,
18584,18624,18654,18668,18681,18692,18730,18833,18837,18841,
18851,18864,18869,18904,18941,18958,19019,19070,19092,19106,
19110,19116,19125,19142,19146,19154,19162,19166,19171,19203,
19232,19244,19274,19279,19321,19350,19399,19430,19447,19457,
19481,19496,19558,19601,19634,19653,19678,19696,19703,19709,
19714,19729,19788,19804,19808,19817,19835,19859,19874,19915,
19929,19932,19973,19990,20021,20034,20040,20044,20082,20101,
20110,20160,20197,20205,20250,20263,20267,20322,20367,20376,
20411,20433,20439,20462,20474,20479,20501,20550,20563,20663,
20675,20688,20703,20747,20774,20782,20789,20801,20806,20812,
20826,20835,20850,20872,20888,20956,20960,20978,20985,21022,
21053,21092,21124,21135,21143,21155,21203,21223,21227,21232,
21276,21322,21375,21398,21409,21439,21444,21453,21459,21543,
21547,21551,21558,21570,21577,21625,21648,21654,21663,21669,
21704,21714,21721,21766,21774,21786,21798,21810,21892,21918,
21922,21939,21946,21981,22005,22025,22044,22050,22093,22101,
22121,22126,22141,22153,22162,22166,22185,22190,22206,22210,
22273,22299,22339,22370,22417,22470,22543,22587,22598,22615,
22671,22680,22694,22699,22718,22727,22744,22748,22757,22764,
22773,22794,22821,22851,22866,22877,22882,22900,22904,22961,
22989,23001,23009,23051,23087,23115,23120,23136,23164,23170,
23188,23198,23271,23299,23317,23335,23347,23352,23365,23439,
23444,23450,23468,23486,23518,23534,23587,23590,23623,23650,
23669,23672,23687,23715,23754,23759,23767,23812,23818,23887,
23893,23914,23933,23943,23963,24027,24031,24048,24060,24076,
24090,24121,24146,24213,24236,24291,24301,24323,24342,24352,
24389,24398,24424,24434,24447,24456,24477,24497,24500,24550,
24587,24611,24631,24654,24662,24711,24717,24721,24791,24798,
24837,24842,24850,24858,24867,24872,24897,24923,24931,24962,
24979,25004,25023,25055,25071,25078,25085,25161,25168,25178,
25187,25191,25202,25208,25289,25311,25410,25424,25450,25458,
25466,25475,25487,25491,25496,25536,25607,25626,25634,25734,
25741,25748,25752,25757,25775,25779,25787,25822,25829,25848,
25855,25868,25884,25954,25960,25987,25994,25998,26002,26007,
26029,26056,26079,26083,26122,26176,26224,26257,26262,26305,
26356,26360,26396,26409,26420,26437,26502,26508,26513,26527,
26538,26544,26555,26577,26619,26623,26660,26709,26715,26722,
26763,26783,26791,26827,26841,26882,26919,26949,26969,26978,
26999,27025,27038,27080,27089,27118,27125,27144,27152,27187,
27201,27236,27321,27327,27331,27349,27374,27389,27398,27404,
27413,27477,27480,27499,27506,27547,27556,27562,27576,27601,
27653,27661,27677,27682,27685,27744,27763,27785,27805,27813,
27849,27887,27901,27916,27924,27943,27971,27992,28000,28098,
28105,28120,28141,28156,28180,28242,28246,28251,28268,28303,
28319,28343,28358,28363,28418,28428,28450,28454,28469,28473,
28486,28522,28531,28546,28560,28574,28580,28668,28698,28757,
28762,28809,28825,28841,28847,28851,28864,28867,28874,28886,
28899,28924,28937,29005,29013,29023,29074,29087,29101,29110,
29119,29135,29187,29222,29255,29316,29341,29350,29394,29434,
29462,29467,29479,29488,29491,29525,29576,29594,29604,29615,
29619,29644,29648,29666,29688,29709,29722,29730,29772,29824,
29830,29867,29889,29897,29918,29956,29975,29992,30012,30160,
30177,30200,30236,30241,30260,30267,30291,30295,30365,30381,
30408,30415,30419,30438,30464,30468,30502,30566,30593,30616,
30633,30639,30648,30663,30667,30672,30685,30724,30729,30734,
30741,30747,30769,30772,30789,30813,30818,30845,30882,30912,
30930,30974,30986,31110,31137,31142,31146,31160,31190,31208,
31212,31217,31250,31255,31319,31342,31363,31378,31386,31427,
31434,31452,31489,31502,31560,31567,31583,31605,31609,31613,
31622,31629,31647,31690,31711,31733,31755,31780,31791,31877,
31888,31892,31899,31907,31916,31928,31932,31936,32017,
0};
static const gx_device_halftone_resource_t res_1 = {
    "Cyan", 3, 167, 167, 256, levels_1, bit_data_1, 2
};

/* StochasticDefault.Magenta */
static const unsigned int levels_2[] = {
    0,   59,  117,  171,  227,  288,  348,  407,  466,  526,
  584,  641,  698,  755,  818,  881,  934,  988, 1043, 1099,
 1152, 1205, 1260, 1314, 1366, 1417, 1469, 1520, 1579, 1641,
 1704, 1764, 1817, 1869, 1918, 1968, 2026, 2086, 2151, 2215,
 2277, 2331, 2380, 2430, 2480, 2532, 2594, 2654, 2712, 2770,
 2830, 2882, 2932, 2983, 3034, 3094, 3164, 3230, 3298, 3376,
 3431, 3480, 3532, 3586, 3638, 3689, 3752, 3832, 3887, 3944,
 4006, 4064, 4111, 4158, 4245, 4330, 4414, 4491, 4545, 4599,
 4671, 4789, 4900, 4955, 4997, 5039, 5081, 5123, 5171, 5225,
 5364, 5454, 5517, 5575, 5633, 5692, 5788, 5940, 6034, 6083,
 6132, 6184, 6236, 6296, 6358, 6426, 6510, 6594, 6663, 6780,
 6821, 6861, 6899, 6931, 6964, 6996, 7028, 7061, 7093, 7144,
 7216, 7515, 7687, 7806, 7881, 7955, 8016, 8066, 8157, 8239,
 8292, 8360, 8440, 8524, 8886, 9045, 9207, 9263, 9308, 9338,
 9367, 9396, 9428, 9461, 9494, 9537, 9599,10003,10129,10247,
10352,10431,10497,10574,10649,10723,10803,10884,11016,11231,
11300,11356,11409,11460,11543,11933,11988,12043,12099,12155,
12211,12276,12359,12442,12525,13024,13104,13162,13211,13264,
13320,13418,13650,13769,13889,13986,14047,14103,14159,14214,
14382,14647,14822,15022,15162,15268,15375,15485,15612,15750,
15836,15940,16051,16290,16421,16533,16657,16794,17063,17146,
17232,17303,17353,17410,17484,17558,18253,18697,18798,18894,
19014,19326,19441,19559,20083,20163,20241,20304,20462,20814,
20915,20979,21046,21117,21214,21316,21452,22095,22230,22332,
22432,22625,23011,23235,23384,23540,23707,23949,24107,24306,
24670,25326,25442,25557,26440,27889,
0};
static const unsigned short bit_data_2[] = {
  885, 1174, 2060, 2169, 3238, 4110, 4899, 5217, 5688, 6411,
 6856, 6925, 7743, 8872, 9362, 9984,10488,11023,11172,11349,
12204,13001,13126,13922,14933,15028,15718,16799,16969,17112,
17771,18669,19071,20104,20515,20628,20658,21129,22320,22880,
24295,24535,24643,25085,25553,26147,26167,27381,27546,28757,
28801,29318,29393,29434,30616,31017,31754,31909,32035,  321,
 1623, 1796, 2510, 2912, 2925, 2977, 3220, 3760, 4861, 5807,
 5907, 6116, 7585, 7904, 8183, 8921, 9082, 9126, 9228,11383,
11460,11998,12059,13797,14241,14413,14711,14866,15617,16443,
16558,17670,17911,18179,18383,18515,19229,20254,20312,21986,
22588,22721,23061,23969,24045,25242,25734,26062,26078,27175,
27911,28077,29791,30267,30577,31122,32026,   53,  273, 1255,
 2431, 3734, 3908, 4086, 4174, 4735, 4801, 5778, 6637, 6681,
 8138, 8470, 8611, 9541, 9754,10436,10953,12218,12371,12713,
13080,13308,14531,15081,15766,16649,17894,18168,18207,19407,
19464,20879,21154,21771,22188,22467,22798,23365,23513,24118,
24794,27663,27674,28001,28881,29474,30112,30674,31045,31495,
31552,   46,  522, 1054, 1544, 1568, 1894, 2000, 2072, 2419,
 3865, 4956, 5083, 6568, 6652, 7190, 7544, 8303, 9484,10204,
10647,10796,10851,10863,11907,12879,13203,13681,13982,15067,
15899,16051,16210,16866,17101,19112,19396,20288,20781,20983,
21722,22036,22196,24227,24846,25204,25825,26349,26568,27031,
27133,27388,27971,28336,29608,30598,31983,   26,  207, 1391,
 2900, 3272, 4328, 4552, 4647, 5455, 5828, 6242, 6535, 7055,
 7321, 7425, 7831, 8008, 9707,10704,11300,12339,13325,13549,
14666,15308,15402,15558,16065,16232,16356,16375,17237,18584,
18721,19121,19430,19449,19856,20650,20752,21659,22022,22669,
22740,23112,23903,24000,24396,24910,25259,25599,26050,26329,
26576,27301,28171,28659,30031,30448,31417,31776,  827,  929,
 1107, 1467, 2054, 2379, 2408, 3109, 3417, 4240, 4342, 4821,
 5003, 5700, 6009, 6772, 7788, 8643, 9235, 9285, 9343, 9521,
 9849,11786,12762,13283,14215,14610,14717,14846,15772,16578,
17563,17734,18077,19552,20281,20570,20611,21212,21476,22326,
22503,23345,23381,23743,24250,25728,26699,26977,27073,28513,
28540,28616,28643,28672,29206,29720,30342,30777,  473, 2151,
 2558, 3201, 3696, 3806, 5100, 5594, 6754, 7261, 7886, 8143,
 8589, 9568,10032,10081,10687,10909,10959,11284,11745,12018,
12433,12580,13187,13371,13914,14059,15458,15953,16463,17006,
17473,17933,17982,18060,18834,19145,21949,22810,23309,23433,
23825,25000,25429,25653,26056,26932,27183,27727,27791,27995,
29480,29697,29902,30429,30751,31337,31628,  643, 1190, 1946,
 2605, 2963, 3781, 5575, 5847, 6591, 7270, 7399, 7529, 7985,
 8896, 9442, 9878,11201,12315,12539,12872,13171,13848,13888,
14264,14514,14543,14752,15434,16928,17170,18289,19128,19288,
19784,20067,20616,20775,20798,21239,21904,22758,23666,24278,
24495,25122,25499,26334,26371,26517,27894,28638,29251,29272,
29678,30155,30681,30912,31130,31781, 1034, 1157, 1397, 2461,
 3000, 3146, 3708, 3739, 3871, 4034, 4566, 4654, 4694, 4770,
 4874, 5326, 6258, 7492, 8147, 8860, 9337, 9741, 9989,10505,
11434,12140,12642,13208,14154,16667,17189,17588,17608,18114,
19153,19327,19605,19820,20739,21440,21778,22362,23009,23260,
23483,24145,24650,24900,25830,26451,27016,28136,28309,28683,
29151,29422,30592,30803,31615,31825, 1067, 1166, 2014, 2931,
 3209, 5299, 5671, 6366, 6549, 6610, 7171, 7196, 7634, 8031,
 8600, 9117,10197,10444,10804,11448,11659,12223,12356,12674,
14310,14822,15199,15638,15947,16189,16517,17144,17324,17366,
18403,18840,19693,20020,20192,23492,23849,24330,24674,24967,
24991,25391,25686,26233,26389,26623,26847,27497,27657,28437,
29305,30551,31796,31904,  213,  384,  879, 1308, 2754, 3772,
 4423, 5045, 5501, 5803, 7418, 7730, 8194, 8357, 8840, 9458,
 9854,10406,11355,11916,13342,14018,14100,14810,14938,15279,
15689,15987,17491,17533,18467,18894,18909,18972,20306,20873,
20895,20950,21417,21919,22700,22943,23236,23830,25802,26412,
29085,29349,30007,30372,30437,30859,30879,30989,31638,31769,
31930,  509,  518,  586, 1002, 1443, 1745, 2157, 2642, 2693,
 2779, 2851, 3660, 3878, 5663, 6407, 6476, 7221, 7882, 8293,
 9488,10905,11036,11139,11389,11412,11872,12894,13331,13759,
15407,15892,15905,17810,18149,18350,18827,20032,20812,20979,
21398,21575,21834,22088,22436,23148,23561,24888,26363,26536,
26885,27285,28667,28916,29328,29572,30026,30381,  263,  853,
  989, 1215, 2905, 3558, 5250, 5414, 5512, 5720, 5918, 6737,
 6882, 8311, 9909,11429,11729,11942,12585,13075,13112,13391,
13892,14661,15484,15837,16821,16832,17246,18504,18627,18867,
21077,21545,21762,22292,22595,22966,23889,24155,25019,25172,
25647,26468,26780,27104,27159,27505,28098,28736,29197,29896,
30351,30452,30848,31346,31683,  728, 1102, 1665, 1845, 3756,
 4126, 4179, 4638, 5075, 6235, 6273, 6439, 6530, 6765, 7373,
 7702, 7941, 7962, 8941, 8970, 9816,10146,10185,10248,10324,
10664,11992,12422,12428,12718,12830,13366,14565,15975,16013,
16046,16198,16540,16946,17028,18375,19139,20054,20160,21242,
21413,21698,22031,22430,23093,23526,23872,24963,26319,26955,
27025,28388,28908,28953,29631,31008,31115,31647,  234,  461,
  483, 1873, 2958, 3513, 3572, 3691, 3860, 5630, 5773, 5813,
 8766, 9189, 9260, 9638, 9883,10000,10306,10592,11591,12438,
13352,13973,14095,14687,15033,15299,15376,16512,17626,18072,
18301,18520,18856,19268,19534,19699,20125,21059,21809,22542,
23353,23653,24436,24475,24513,25107,25355,25482,25578,25605,
26012,26609,27011,27748,27959,28237,28456,29402,30038,31572,
31596, 1841, 2163, 2314, 2629, 3142, 3215, 3812, 4347, 4482,
 4548, 4719, 5541, 6676, 7709, 8544, 8656, 8757,10809,10991,
11261,12367,12735,13841,13852,14055,14641,14983,16226,16794,
17037,17209,17950,19008,19441,19543,20174,20219,20846,21516,
21923,22521,24198,24222,24491,25380,27915,28178,28358,29131,
29639,30307,30376,31558, 1231, 1481, 1889, 2389, 4105, 5868,
 6170, 7163, 7524, 7820, 8299, 8595, 9181, 9895,10258,11059,
11927,12261,13107,13513,13643,13958,14169,14318,15313,16055,
16915,16935,17166,17697,19851,19878,19997,21024,22492,23376,
23397,23437,23882,25616,25854,26162,26458,27321,27522,27677,
27757,28037,28313,29619,29685,30100,30163,31351,   10,  121,
  300,  628,  803, 1731, 1941, 2042, 2142, 2211, 3037, 3746,
 4466, 5008, 5763, 5987, 6833, 8036, 8070, 8519, 8582, 8725,
 9077,11080,11719,12591,13154,14805,15439,15611,17096,18439,
18740,18772,19675,19908,20196,20284,21554,21790,22013,22422,
22533,24507,24544,25063,25246,25559,27428,27934,29220,29384,
30250,31357,31816, 1125, 3004, 3280, 3979, 4186, 4306, 4635,
 5139, 5639, 7008, 7044, 8189, 8555, 8673, 9367,10300,11472,
11570,12709,12990,13943,14678,15111,15203,15362,15429,15461,
16407,17346,17443,17520,17776,17872,18487,18749,20180,20360,
21742,22166,24403,24620,24659,26559,26597,26614,26896,27595,
28843,28902,29309,29457,29851,31025,31332,31388,31511,  256,
  348,  787, 1090, 1415, 1595, 1819, 2029, 3653, 5034, 6262,
 6385, 6798, 8316, 9314, 9930,10028,10430,11616,11967,12745,
12951,13444,16662,16809,17997,18282,19041,19363,20816,21331,
21664,22718,22946,22975,22986,23197,23316,23922,24025,24519,
25076,26637,27116,27540,27682,27991,28574,28634,30085,30108,
30364,31075,  529, 1302, 2184, 2981, 3484, 4506, 4664, 5095,
 5114, 5841, 5901, 6494, 7175, 7891, 8753, 9047, 9411,10142,
10560,10585,10984,11959,12215,12875,13408,14123,14637,15287,
15327,19300,19476,20300,20401,20442,20891,21562,22201,23277,
24446,25030,25700,25758,27228,27775,27841,28090,28677,29760,
30211,30844,30863,31533,31759,  296,  479,  794, 2340, 2647,
 2938, 3712, 4383, 4427, 4643, 5313, 6808, 8027, 8911, 9481,
 9630,10036,10287,10572,11017,11672,12034,12307,12512,13481,
14986,15703,16333,16453,16534,16554,16765,17405,17569,18537,
19417,20201,20469,22575,22884,23057,23671,23907,24624,24730,
24742,25207,25930,26189,26307,28624,29046,29260,31012,31698,
  498,  582,  624,  889, 1984, 2305, 2636, 2730, 2967, 3370,
 4531, 5087, 5783, 6279, 6348, 6586, 6826, 6941, 7532, 7570,
 9665,11438,12384,13580,13745,14162,14260,15658,16352,17041,
17308,17546,17941,18260,19067,19488,20037,21151,21583,21911,
22569,22855,23577,25166,25669,25681,26987,27096,28339,28463,
29856,30456,30915,31259,  608, 1578, 1619, 1740, 4161, 4878,
 5144, 5537, 7012, 7255, 7304, 7872, 8157, 8208, 8321, 8498,
 8761,10509,10721,11223,11598,13019,14110,14460,15104,15139,
16394,16625,18204,18764,19596,20074,20677,21261,21701,22599,
22802,23324,23648,23726,24069,26200,27140,27192,27591,27858,
28304,29297,30012,30773,30793,31811,  141,  278, 2800, 3538,
 3683, 4749, 4870, 5425, 5598, 6209, 7614, 8090, 9538, 9805,
10327,10459,10772,10848,11550,11566,12105,13056,13486,13663,
13718,14670,14691,15887,16898,17316,18128,18598,18691,19117,
19514,19731,20215,20646,21458,22344,23941,24269,25465,25959,
27358,27902,28559,28804,29077,29795,31501,  341, 1050, 1285,
 1833, 2519, 2656, 2934, 5835, 6480, 6648, 9415, 9491,10483,
12007,13313,13687,13845,14087,14139,14429,14596,14658,15384,
16478,17141,17409,18007,20736,21053,21186,21421,21656,22873,
22896,23121,24333,25311,25755,25787,25834,26928,27080,27412,
29333,29977,30828,30992,31060,31171,31222,31326,31872, 1208,
 1611, 1854, 2891, 4266, 4323, 4997, 5241, 5871, 6229, 6757,
 7152, 7312, 7406, 7457, 7541, 7958, 7976, 9167,10118,10475,
11265,11562,11859,12041,14732,15282,15449,15799,15982,16329,
18891,19015,19434,19738,21593,21734,22848,23081,23931,24791,
24804,25281,25842,27153,28069,28331,28931,29803,30078,30091,
  160,  440,  615, 1694, 1968, 2068, 2423, 3074, 3357, 3576,
 4389, 4439, 4753, 6107, 6848, 7622, 8653, 8715, 9723,10017,
10757,11205,11963,12597,13136,13382,13986,15777,16254,16267,
16421,16965,17674,18459,19089,19446,20184,20941,21148,21749,
21826,21990,22771,22936,23957,24003,24671,25218,26003,26743,
26908,27233,27336,28516,28537,29538,29775,30434,30958,  387,
 1410, 2145, 2633, 3478, 3507, 3723, 3798, 4094, 4919, 5860,
 6144, 6153, 7797, 8868, 9071, 9641, 9936,11026,11341,11484,
11803,12303,12985,13763,13860,14825,14892,15635,16592,17576,
17914,18094,18138,18164,18638,18752,18976,20320,20986,21163,
21447,21620,22091,23966,24591,24855,26072,26131,26401,26630,
27276,27569,28471,29216,29669,30034,30589,30918,31048,31190,
31612,   68,   93, 2373, 2514, 2590, 2717, 3205, 3617, 4331,
 5271, 5396, 6078, 6431, 6552, 7166, 7370, 8605, 8893, 8993,
 9129, 9695,10231,10276,10884,11328,11445,11778,12172,13541,
13639,14490,14556,14989,15939,16223,16345,16484,18950,19619,
19702,19973,20238,20271,20643,22539,23294,23337,23564,24009,
24423,25060,25073,25421,26620,28055,28510,28680,28745,29233,
29339,30933,30950,31784,  118,  413,  784, 1042, 1266, 2075,
 2118, 2200, 3135, 3583, 5131, 5229, 5800, 7051, 7124, 8771,
 9232, 9242, 9303,10433,11168,12046,12534,12695,12780,13083,
13838,13900,15876,16427,16529,17048,17715,17859,17979,18146,
18186,18463,19644,19723,20824,20934,20997,21374,22050,22557,
23746,24631,24907,25967,26082,26408,26725,27460,27806,28256,
30146,30274,30927,31922, 1057, 1369, 1678, 1764, 3182, 3404,
 3849, 4078, 5295, 6204, 6295, 6390, 6596, 7136, 8020, 8162,
 8640, 9334, 9860,11793,12441,12486,12766,13028,13787,14335,
15379,15614,16632,16788,17605,17705,19650,19793,20206,20309,
22054,22122,22220,22235,22481,23449,23915,24532,25731,25780,
25794,27214,27962,29011,29905,30295,30811,  253,  266,  904,
  961, 1085, 1202, 1463, 2276, 2358, 2996, 3793, 4294, 5016,
 5126, 5151, 5659, 6222, 8104, 9748, 9764,10062,11296,11643,
12003,12131,12144,12611,12814,13690,14535,16218,16274,16570,
17632,19246,19584,22353,22400,22515,23541,24164,25225,25569,
27393,27417,28081,28810,28890,28911,29053,30195,30412,  227,
 2577, 3112, 3534, 4282, 4512, 6160, 6916, 7410, 8186,10386,
10875,11161,13338,14063,15263,15816,17374,17686,17919,18022,
18122,18196,18725,18746,20363,21145,21193,21203,21233,23687,
23899,24048,25023,25111,25485,25742,26182,26529,26634,27553,
27561,28578,29032,29782,29880,30066,30369,31439,  620,  679,
  734, 1163, 1454, 2051, 2736, 3855, 4120, 4257, 5377, 6074,
 6922, 6954, 7450, 7746, 8174, 8478, 8722, 8899, 9178, 9544,
 9710,10331,10409,10609,10619,11277,12168,13928,13940,14593,
14627,15290,15979,16003,17202,17226,18901,19709,21080,21157,
23097,25624,26496,27927,28878,30471,30729,31653,    6, 1305,
 2214, 2447, 4626, 5876, 5904, 6113, 6276, 7385, 7582, 7931,
 8394, 8458, 8659, 9463,10462,12254,12374,13286,13967,14218,
15196,15517,15602,16802,17104,17615,18309,18353,18837,19044,
19939,21815,21993,22498,22858,22999,23163,23836,24498,24510,
24585,24925,25041,25180,26398,26454,26503,27149,27282,29636,
29675,29999,30762,31063,31600,31708,  599,  839, 1632, 1997,
 2172, 2794, 2842, 3331, 3976, 4864, 5578, 6058, 8539, 9700,
 9919,10371,10595,11824,12930,13099,13167,13885,14425,14886,
15052,15127,15780,16071,16564,19161,19470,19498,19713,20303,
20578,21168,21328,21601,22147,22487,23521,23892,25196,25851,
26154,26223,26228,26777,26945,27501,27508,28074,28377,28946,
29578,30684,31137,31235,31354,31971,   83, 1564, 2619, 3955,
 4228, 4518, 5213, 5259, 5531, 6090, 6176, 6379, 6968, 7058,
 7727, 7752, 7781, 8552, 9610,10532,10644,10780,10870,11051,
11094,11154,12126,12137,12413,12628,12966,13905,15047,15222,
15284,15564,16280,16715,16768,17195,17311,17752,18292,18490,
19099,19527,19696,20041,20573,21312,21469,21944,22417,23425,
23489,23635,26995,28534,29212,29652,30055,30201,30693,31564,
32006,  151,  589,  718, 2128, 3106, 3360, 4060, 4153, 4194,
 4738, 4881, 4965, 5040, 5525, 6182, 6995, 7433, 7631, 8309,
 8646, 9055, 9148, 9331,11212,11847,11876,12289,13261,13492,
13577,14521,14737,15063,15908,16589,16943,17592,19616,20597,
20636,20865,22978,23271,23391,23622,23860,23869,24272,24609,
25286,25317,25443,25875,26938,27922,28060,28158,28234,28896,
29063,29661,29726,29959,31721,  124,  210,  547,  639, 1508,
 1783, 2057, 4622, 5000, 5244, 5290, 5460, 5666, 6644, 6793,
 7460, 7500, 7949, 8066, 8790, 9096, 9429, 9646, 9689,11046,
11334,12353,12939,13397,15487,16058,17254,17284,17498,17745,
18442,18471,18540,20050,20222,20448,20663,20898,21197,21716,
22563,23694,23758,24312,25784,25941,26579,27172,27588,27708,
27813,28416,28941,29314,30445,31176,31206,  895, 1389, 2760,
 3086, 3311, 3352, 3648, 3720, 3803, 4334, 6002, 6149, 6620,
 7229, 8098, 8384, 8684, 9660,11226,11578,11647,11765,12913,
13089,13459,14505,15398,16739,18448,18688,19349,19357,20586,
20756,21455,21999,22143,22278,23266,24013,24485,24647,24720,
24877,26653,27909,28180,28905,29798,29825,30613,31541,31701,
32019,  476,  515, 1037, 1362, 2153, 2626, 3688, 3702, 3778,
 6164, 6746, 6875, 7184, 8180,10631,12121,12948,13061,13728,
14358,14370,14921,15020,15664,17031,17129,17176,17436,18958,
19317,19401,19611,19865,20882,21258,21787,22776,24088,24426,
25010,26810,28631,29048,29692,29837,30554,31193,31219,31264,
 1060, 1099, 1186, 1598, 2331, 2401, 2504, 3132, 4492, 4568,
 5028, 6692, 7335, 7402, 7812, 8416, 8967,10098,11090,11367,
12594,13184,13316,14228,14646,14976,15042,15561,15655,16147,
17985,18335,18870,20163,21031,21965,22495,23570,24578,25448,
26174,26316,26436,26640,28846,29302,30478,30546,31746,31836,
  968, 1028, 1238, 3283, 4158, 4509, 4660, 5494, 8080, 8343,
 8665, 8887,10059,11732,12380,13633,14703,15036,15824,16158,
16288,16604,16829,17339,17572,17581,17678,18886,19678,19824,
21627,22298,22409,22715,23150,23307,23472,23960,24214,25544,
25822,26378,26465,27111,27764,27976,29185,29321,29622,30732,
 1489, 2224, 2645, 2662, 3295, 4308, 4555, 5253, 5623, 6437,
 7155, 8739, 9216, 9356,10105,10567,10814,11531,12492,13163,
14295,14623,15507,15514,15769,16176,17351,17621,18152,18980,
20007,21513,21636,22272,22367,24258,24516,24977,25574,25867,
26714,26950,28242,28354,28477,28764,29849,30841,31377,31434,
31536,31979,  503, 1436, 1451, 1943, 3176, 3232, 4924, 5390,
 5633, 6977, 7106, 7127, 8516, 9253, 9757, 9818,10020,10382,
10414,10448,11083,11441,12537,13404,13561,14089,14685,14800,
16135,16192,17891,18509,18563,18672,20461,20609,20701,21044,
21958,22094,22317,22917,23394,23912,24411,24547,24693,25884,
26547,26731,26899,27852,28084,28109,28124,28695,28998,29788,
30216,31006,31214,31885,   39,  114,  656,  823,  923, 1346,
 2004, 3217, 3386, 3481, 4380, 5329, 5696, 6255, 7061, 7224,
 8784,10501,10998,11796,12009,12021,12753,12807,13025,13270,
14271,14337,14516,15252,15310,15468,16450,16659,18018,18523,
18743,18846,19219,20369,20483,21219,21654,21725,22625,23175,
23319,24056,26212,26239,27028,27487,28333,28962,29587,30659,
30977,31230,31442,31933, 2370, 2382, 2395, 3078, 3378, 4261,
 6190, 6425, 7071, 7330, 8410, 8881, 9120, 9500, 9863,10130,
10967,11422,11426,11588,11670,13008,14440,15172,15884,15993,
16245,16431,17110,17356,17900,18244,18586,18859,19920,20667,
21780,23439,23549,23659,24093,25345,25404,26191,26797,26853,
27006,27156,27463,27602,27942,28645,29092,29248,29450,29924,
31394,31714,   23,  241, 1312, 1638, 1685, 1779, 1848, 2726,
 2815, 3363, 3920, 4460, 5285, 5601, 6025, 7896, 8318, 9136,
 9618, 9897, 9943,10207,11186,11682,12925,13264,13757,14481,
14941,15025,15844,16360,18386,19455,19654,20315,20488,20601,
21937,22117,22572,22939,23141,24904,25837,25847,27106,27328,
27861,27879,28173,28691,29119,29523,30106,30416,30632,30677,
 1575, 1929, 3349, 3891, 4244, 4337, 4476, 4714, 4803, 6035,
 6658, 6818, 7573, 7837, 9029, 9101, 9108,11180,11290,11713,
12609,12742,13003,13277,13784,14021,14497,14917,14999,15840,
16213,17611,17731,18927,19490,20670,21123,21366,22046,23070,
23579,24665,25036,25083,25176,25296,25497,25586,25696,27163,
27211,29007,29419,29707,29872,30755,31650,31689,31767,32000,
   30,  724, 1460, 2307, 3308, 3399, 3598, 3944, 5124, 5706,
 6101, 7494, 9066, 9280, 9923,10263,11821,12309,12524,12707,
13532,13676,15950,16128,16775,18761,19274,19324,19636,19688,
19994,20428,20630,21227,22675,22805,22927,24289,25044,25279,
25944,26543,27511,28227,28674,28922,30240,30531,30646,31148,
31297,31641,   77,  684, 1799, 4288, 4889, 5210, 5393, 5853,
 7021, 7245, 7506, 8697, 9153, 9324, 9379,12557,12795,13411,
13585,14157,15819,16863,16902,16922,16999,17343,17398,18843,
19022,19202,20083,21357,21537,22390,23090,23944,24033,24112,
24636,24773,24873,24972,25248,25607,25772,26894,28130,30583,
31504,32010, 1939, 2351, 2555, 3031, 3152, 3992, 4044, 4949,
 5380, 7324, 7800, 7967, 8109, 9172, 9799,10285,10819,11432,
11555,12037,12444,12918,13935,15009,15833,17527,18056,18273,
18326,18590,20550,20694,21281,21376,22138,22168,22232,22385,
23243,24264,26118,26792,26843,27291,27951,28297,28832,29017,
30981,31132,31774, 1021, 1475, 2218, 3235, 3459, 5105, 5256,
 5428, 5499, 5604, 6350, 6589, 6987, 7016, 8034, 8076, 8284,
10294,10689,11065,12292,12497,13666,14082,14116,14283,14601,
15522,15669,16748,18066,19474,20422,21160,21526,22796,23255,
23361,24037,25475,26006,26817,27339,28191,28742,30187,30462,
30689,30779,31799,31928,  303, 1934, 2237, 2272, 3099, 3163,
 3766, 5347, 5417, 5626, 5645, 5981, 6662, 7558, 8368, 9873,
10226,10235,10507,10719,11535,11856,11932,12770,12791,13336,
13466,13877,14367,15493,17211,17556,17989,18367,18455,19799,
19896,20626,20684,20746,20901,21022,22015,22697,23042,23106,
23735,24349,24797,24860,26144,27577,27606,29336,29772,30357,
30473,30963,31915,31944,  357,  392,  856, 1006, 1374, 1615,
 1671, 1690, 3525, 4133, 4358, 4369, 4488, 4832, 5341, 6614,
 6767, 6886, 7035, 7548, 7718, 7924, 8205, 8214, 8528,10077,
10917,11270,11974,12349,12823,13257,13519,14223,14231,14257,
14548,15231,15596,16093,16653,17180,17392,17432,17551,18241,
18873,18911,18966,19833,20133,20581,21841,22356,22903,22922,
23012,25007,25017,25555,27563,28039,28849,29291,29436,29700,
30234,30288,31402,32015,  289,  293,  891, 1675, 2597, 2744,
 3275, 3858, 3897, 4916, 6416, 7808, 8198, 8525, 9230, 9652,
 9813, 9986,10025,10279,10709,11607,11837,12257,12327,13546,
14437,14649,15673,15797,16718,17511,17694,18923,19340,19524,
19624,19979,20264,20767,21062,21572,21961,22473,23155,24127,
24209,24640,24994,25262,25984,26256,26357,26394,27151,27456,
27887,28066,29275,29410,29491,30014,30052,30174,30494,31621,
   90, 1733, 1963, 2517, 2722, 2757, 2806, 2823, 2830, 3603,
 3742, 3847, 4249, 5281, 5465, 5681, 6212, 6462, 6966, 7978,
 8572, 8678, 8734, 9034, 9245, 9719,10126,10391,10841,11408,
11583,12390,12646,13311,14744,15055,15101,15261,16044,16150,
16758,17186,17215,17426,18512,18685,18769,19670,20988,21804,
22212,22813,22863,22952,24275,24722,26054,26332,26514,27206,
27616,27672,28096,28813,29454,30310,30987,31127,  158,  421,
  442, 1025, 1471, 2546, 2584, 2764, 3681, 4416, 4464, 4729,
 5398, 5702, 6015, 6482, 6919, 7395, 7444, 7600, 7760, 8085,
 8421, 8991,10466,10790,10828,10955,10974,11195,11678,11760,
13103,13556,13702,14152,14208,15427,15583,16277,16561,17060,
17290,17928,18363,18593,18821,19302,19925,19935,20567,20591,
21837,22083,22180,23327,24109,24242,25002,25301,25349,25458,
25619,25818,26313,26341,26748,26883,27543,27964,28374,28519,
28722,29517,29616,30021,31245,31685,  409,  649,  873,  882,
 1012, 1625, 3421, 3566, 4496, 4676, 4937, 4954, 5031, 6497,
 7929, 8072, 8951, 9156, 9510,10068,10865,12426,12568,13761,
14715,15075,15208,15381,15870,16515,16734,16779,16791,17883,
18738,19056,19074,21200,21209,21438,21518,21739,23182,25270,
26787,26974,27525,28460,28773,29279,29654,30070,30345,31261,
31335, 1123, 2258, 2897, 3329, 3389, 4129, 6252, 6927, 6951,
 8131, 9917,10049,10187,10576,10945,14235,14443,14483,15049,
15333,16963,17050,17518,18155,18166,18854,19795,19873,21231,
21274,21511,22586,22789,23239,23947,24927,25936,26085,26252,
26573,27185,28048,28665,29236,29574,30182,30595,31233,31762,
  659,  771,  901,  992, 2988, 3395, 5005, 5926, 6370, 6814,
 6838, 7772, 8692, 8713, 9278,10421,10521,11087,11544,12362,
12489,12699,12903,12956,13169,13539,14075,16741,17766,18010,
18915,19557,20946,21968,22131,22337,23662,23702,24246,24267,
24787,25992,26921,26998,27612,28561,28636,29341,29910,30960,
31167,31705,  538, 1000, 1172, 1762, 2017, 2229, 2459, 2540,
 3317, 3924, 4123, 4470, 5118, 5673, 6297, 6354, 6478, 6666,
 6981, 7682, 7768, 8563, 9026,10120,10861,11833,12055,14873,
14899,15306,15417,16455,16955,17421,17489,20002,20102,20226,
20403,21607,22886,23331,23454,23782,23875,24147,26361,26850,
26902,27122,29592,29695,30228,31227,    2,  912, 1079, 1417,
 2387, 3095, 3340, 4425, 4768, 5247, 5613, 6167, 7149, 7238,
 7804, 7833, 8853, 9632,11401,11465,11650,11756,12529,13250,
14108,15374,15682,15889,16627,17603,18903,19212,19222,19398,
19468,19917,20059,21625,21860,21906,24130,24806,24897,25370,
25480,26774,27721,28306,29222,29690,30061,30349,  328,  453,
 1456, 1982, 4254, 4264, 4751, 6751, 8741, 8795, 9115,10149,
11529,12207,12885,12960,13214,13671,14326,14341,14508,14598,
16812,16976,17314,17331,17948,17970,19244,20094,21460,22109,
22173,23100,23187,23193,23505,23924,24101,24408,25115,25161,
26410,26756,28361,28508,28919,30005,30606,31112,31636,  204,
  430, 1360, 1828, 1891, 2316, 2527, 2689, 3594, 4858, 5277,
 5457, 6055, 6387, 6538, 7360, 8113, 8274, 8902, 8972, 9465,
 9952,10794,10978,11813,12243,12922,12997,14047,14663,16155,
16207,16282,17828,18277,18304,18380,18888,19137,19355,20656,
20999,22120,22742,24011,24430,25028,25436,25827,26069,26616,
26719,26841,27274,27408,27896,28160,28292,28494,29956,30818,
30831,31316,  126,  860, 1210, 1687, 1994, 2802, 3493, 3518,
 5011, 5485, 5890, 6392, 6458, 6492, 6532, 7027, 8094, 8557,
 9456, 9475, 9552,10265,10303,10634,10661,11106,11380,11717,
12177,13128,13779,13792,14028,14927,15023,15249,15643,15745,
15814,16038,16049,16187,16388,16805,17249,17909,19537,20204,
20697,20857,21564,21832,22113,22960,22973,23477,23737,23847,
24388,24656,24821,25375,25468,25506,25805,26113,26236,27558,
27691,27930,27954,28003,28422,29294,29406,29536,29969,30835,
31936,31957,  308,  524, 1179, 1559, 2048, 2975, 3414, 5959,
 6185, 6556, 7427, 7818, 8489, 8537, 9643, 9820,11029,11919,
12001,13715,14755,14914,14995,15785,16162,16712,16826,17822,
18130,18390,19252,19614,19790,20248,20261,21195,22702,22875,
23302,23531,23866,24143,24345,25590,25763,26225,27684,28250,
28627,28759,29865,30749,31057,31374,31431,  243, 1118, 1425,
 1973, 1986, 3313, 3336, 3754, 4000, 4054, 4163, 4181, 6048,
 6810, 6831, 7654, 7755, 8210, 9058, 9678,10685,10846,11961,
12128,12431,14129,14171,17026,18254,18535,19261,19778,20076,
20098,20432,20558,22369,22375,22852,24489,24960,25740,26440,
27126,27279,27311,28356,28556,29066,29267,29570,30193,30272,
30623,31269,31300,31556,  225, 2063, 2536, 2617, 2889, 3019,
 3693, 3906, 5077, 5516, 5963, 6022, 7455, 7519, 7914, 8260,
 9615, 9904,10514,10816,11635,11752,12186,12942,12968,13515,
13833,14226,14643,14656,14813,15123,16532,17496,17904,17916,
17992,18000,19293,20086,21368,21540,22332,22414,23445,23651,
23779,25384,26024,26369,27390,27936,28379,29195,29253,29286,
29817,30476,31065,31391,31602,31888,  298,  545,  705, 1380,
 1438, 1546, 1729, 1835, 2466, 2787, 3736, 4541, 4613, 4850,
 5884, 6678, 7140, 7498, 8584, 8984, 9105, 9432, 9600,10525,
11819,13374,13912,14137,14277,15386,16133,16221,16290,16843,
17184,17966,18506,18565,18825,19217,19529,19813,19899,20052,
21528,22048,23497,23709,24015,25856,26001,27181,27230,27538,
28661,29793,30469,31188,  506,  918, 1774, 2262, 2329, 2773,
 4067, 4717, 4844, 6594, 6739, 6822, 7706, 7779, 8769, 9546,
 9698,10695,11738,11788,12601,12724,13013,13197,15271,15437,
16392,17039,18088,18899,19315,20604,21317,21406,22398,22616,
23083,23619,25240,25445,26074,27401,27946,28176,29805,30952,
31520,  677,  789, 2752, 3382, 4107, 5047, 6041, 6612, 7502,
 8314, 8483, 8567, 8686,10003,10022,10246,10425,11955,12044,
13413,14253,15687,15711,15868,17672,19927,19937,20298,20426,
21364,21783,22737,23251,23559,24597,25679,25988,26327,26953,
27323,28062,28734,28768,30209,31370,31400,31802,  131,  258,
  271,  618, 1465, 1585, 1621, 1785, 2077, 3076, 3306, 4633,
 4755, 4766, 4897, 5304, 5535, 5775, 6146, 7231, 7795, 8341,
 8939, 9493, 9533, 9715,10373,11049,11071,11674,11878,12509,
12740,12981,13334,13875,13926,14180,14538,15073,15792,16023,
16042,16335,16364,16594,17015,17595,17729,17876,18525,18625,
19311,19831,20081,20785,21013,21029,21131,21442,22420,22709,
22728,22815,24125,24453,24879,25402,25419,26230,26723,27238,
27548,27801,27843,28149,28898,29702,29722,29993,30045,30167,
30290,30395,31157,31691,31772,  339,  438, 1413, 1839, 2439,
 2791, 3011, 3128, 3184, 3227, 3470, 4310, 4876, 4901, 5215,
 5731, 5820, 5839, 6072, 6441, 6770, 7065, 8135, 8280, 8978,
 9256, 9512, 9846,10137,10202,10638,11015,11420,11557,11773,
12103,12334,12640,12881,13165,13255,13402,14141,14243,14897,
15509,15556,15763,16181,17043,17484,18284,18457,18531,18657,
19630,19741,19838,20692,20844,21279,22155,22475,22500,22677,
23104,23363,23575,24308,24477,24583,24917,25501,26434,26733,
27597,27712,27725,27925,29922,30232,30410,30529,30634,31117,
  411,  593,  651,  741,  818, 1613, 1852, 1948, 2035, 3199,
 4032, 4742, 4893, 5596, 5714, 6800, 7508, 7908, 7927, 7933,
 8388, 9099, 9413, 9865,10411,10490,10770,11972,11983,12424,
12505,12607,12877,13156,13279,13698,14057,14112,14285,14603,
14615,14905,15662,16269,16383,16924,17052,17172,17193,17204,
17529,17952,18978,19227,19472,19652,20391,20764,20992,22002,
22800,22925,23884,24415,24661,24932,25058,25100,26501,26611,
26697,27102,27194,28092,28294,28465,28841,28924,28943,29188,
29858,30753,31547,31598,  335,  673,  984, 1287, 1449, 1491,
 1510, 2832, 3536, 3621, 3770, 4081, 4478, 4712, 5780, 5798,
 6372, 7198, 7248, 8221, 8256, 8462, 8995, 9075, 9124,10079,
10569,10893,10907,11474,11609,11831,12325,13101,13302,13933,
14868,14978,15412,15897,15945,16358,16448,17008,17348,17638,
18054,19130,19347,19826,20182,20517,20826,21429,21552,21603,
21760,22011,22210,22479,22552,22954,23053,24043,24252,24902,
25174,25789,26545,26592,26607,27974,28198,28821,30068,30764,
30822,   88,  805, 1550, 2204, 3101, 3748, 3910, 3950, 4238,
 5641, 5845, 5896, 6409, 7404, 7556, 8145, 8919, 9276,10091,
10590,11232,12676,13464,14720,15044,15137,15393,16728,17178,
17599,18079,18365,18905,19240,19853,21451,23351,23728,23773,
23838,24020,24256,24697,25231,26463,27495,27796,28521,29009,
29026,29050,30418,30973,31920, 1669, 2548, 2724, 2762, 2969,
 3983, 4721, 4992, 5337, 5388, 5423, 6260, 7435, 8166, 9564,
10676,10951,11294,12818,13097,13575,16073,16664,16760,18588,
19231,20496,20638,20648,20814,21121,21342,22630,22723,22941,
24353,24633,25582,26250,26645,27667,27777,28132,28428,29071,
30110,30389,30929,31032,31396,31617,31719,31942,32024,    8,
 1069, 1240, 1350, 1600, 2512, 4362, 4650, 4691, 4866, 5400,
 5765, 6237, 6660, 6877, 6972, 7076, 7345, 7802, 8456, 8751,
 8947, 9557,10124,10336,10615,10642,11193,11203,11376,11538,
11662,12181,12351,12826,13521,14262,14890,15131,15432,15667,
16615,17149,17782,18136,19270,19711,19975,21055,21615,22041,
22104,23268,23627,23760,24679,25347,25359,25491,26396,26712,
27518,27575,28935,29139,29156,29316,29391,29961,30566,30575,
30936,    4,  637,  780, 1195, 1293, 1556, 2002, 2278, 2457,
 2715, 2847, 2973, 3560, 3967, 4092, 4242, 4533, 4570, 4580,
 4645, 4809, 4872, 6007, 6095, 6188, 6861, 7375, 7696, 8172,
 8288, 8512, 9326, 9351, 9479, 9636, 9921,10030,10481,10957,
11259,11523,12259,12382,12404,12589,13297,13306,13771,13850,
14147,14160,14211,14554,14607,14901,15013,15368,15807,16020,
16417,16657,16870,17222,17286,17515,17740,18070,18118,18297,
18369,18450,18676,19141,19684,20039,20354,20599,20744,20771,
21072,21085,21577,23180,23287,23643,23815,24135,24291,24652,
24875,24895,25113,25408,25644,25849,25948,25957,26052,26214,
26566,26770,26943,27161,27177,27458,27872,28299,28311,28458,
28718,28863,29000,29448,30679,30691,30846,30999,32037,   20,
   95,  511, 1506, 1758, 1958, 2006, 2182, 2414, 2442, 2691,
 3002, 3677, 4280, 4494, 4504, 5315, 6435, 6604, 6846, 6934,
 7147, 7216, 7397, 7637, 7810, 7824, 7841, 7876, 8699, 8849,
 8929, 8955, 9305, 9417, 9762,10402,10711,10774,10971,11075,
11178,11199,11410,12113,12394,12420,13591,13598,13647,13694,
13726,13843,14503,14949,15420,16331,17509,17857,18444,19063,
19286,19307,19512,19818,20190,20834,20853,20952,20969,21581,
21666,21707,22038,22124,22580,22602,22705,23123,23465,23547,
24287,24358,24523,24626,24781,25928,25969,26828,27363,27469,
27567,27618,27891,28152,28189,28563,29228,29397,29432,29840,
29979,30074,30450,30861,30967,31050,31413,31841,31974,32021,
 1692, 2435, 2835, 2941, 3466, 3744, 4076, 4828, 4928, 5283,
 5618, 5910, 6303, 7379, 7546, 9721, 9842,10755,11436,12053,
12358,12386,13755,14447,14668,15842,16203,16248,16260,17136,
17300,17820,19105,20563,20871,21802,21984,22469,23195,23359,
23481,24090,24883,25190,25426,26080,26456,26510,28454,28693,
29465,29711,31531,31710,31981,  688, 1236, 1469, 2768, 3474,
 3997, 4037, 4276, 5492, 5519, 5635, 7415, 7688, 8591, 8667,
10045,13551,14625,14651,15581,16429,17763,18318,18550,18767,
19167,19235,21381,23311,23539,24421,24593,25021,25032,25961,
26015,27013,27478,29442,29734,31560,31926, 1634, 2368, 3783,
 4536, 5977, 6501, 8216, 8332, 8351,10320,10821,11236,12057,
12107,12149,12220,12311,12757,13477,15503,16737,16900,18461,
18544,18955,18968,19265,21033,21135,21394,21531,22006,22882,
23678,23716,24493,26834,29106,30214,30491,30533,31004,  236,
 1008, 5153, 5385, 5761, 6231, 6791, 7122, 7578, 7725,11063,
12705,13259,13572,14492,15671,15760,16409,16938,17162,17769,
17812,18098,18942,20121,20217,20974,21445,21889,21942,22871,
23776,25622,26268,27654,29021,29705,30854,31515,31645,31821,
31948,  641,  798,  825,  846, 2621, 3671, 4292, 5219, 5261,
 5334, 5419, 7042, 7130, 7350, 7714, 9561,10281,12644,13344,
13368,15085,15405,16101,18405,18832,19869,20513,22382,22819,
23130,24342,24813,25373,25557,27004,27379,27706,29307,29472,
29835,30740,31212, 1105, 1161, 2338, 2399, 2947, 3495, 3959,
 4418, 5878, 6732, 7790, 7937, 8382, 8651, 8936,10798,11653,
11743,12330,12784,13704,13824,14541,15031,15321,15647,17554,
18377,18665,19084,20187,20981,21736,21852,22171,22216,23335,
24071,24194,24314,26258,26766,28259,28440,29605,30207,31139,
31186,  325,  662,  692, 1112, 1979, 2927, 3457, 5128, 5916,
 7452, 8597, 8805, 9375, 9436, 9734,10183,10453,11248,11542,
12032,12928,14467,14546,14680,15179,15782,16989,17295,17977,
18693,19594,20257,20875,22034,22159,22342,23086,24079,24527,
24778,25393,25978,25995,26321,27360,28506,28611,28867,28955,
29096,29312,29966,31447,31742,  145,  424,  543,  773,  906,
 1030, 1253, 2023, 2120, 2232, 2253, 2323, 2347, 2360, 2603,
 2701, 2853, 3347, 3372, 3515, 3796, 4172, 4352, 4624, 5097,
 5792, 6065, 6197, 6206, 6268, 6383, 6473, 6625, 6913, 7592,
 7956, 8203, 9069, 9090, 9311, 9612, 9746,10243,10464,10652,
10802,10889,10915,11004,11288,11357,12691,12994,13386,13637,
13674,13710,13880,13930,14102,14500,14558,15633,15680,15960,
16086,16370,16638,16673,16913,16961,17525,17586,18058,18132,
18200,18479,18919,19011,19224,19887,19984,20292,20415,20420,
20810,21042,21092,21244,22101,22163,22378,22752,22785,22984,
23264,23283,23441,23640,23764,23905,24132,24472,24540,24929,
25097,25185,25272,25411,25456,25666,26498,26583,26936,27044,
27108,27307,27785,27850,28278,28319,28347,28431,28738,29039,
29495,29907,29972,30063,30083,30179,30579,30651,30791,31343,
31459,31578,31716,31805,   59,  670, 1228, 1269, 1399, 2309,
 3546, 3762, 3801, 3810, 3881, 3922, 4251, 4490, 4641, 6443,
 6841, 6865, 6975, 7240, 7266, 7383, 7720, 8355, 8377, 8468,
 8965, 9049, 9675,10189,10369,10899,11361,11403,11493,11950,
12343,12583,13654,14131,15001,15018,15254,15465,15967,16322,
16476,16581,17046,17390,17424,18705,19058,19343,19481,19780,
19913,20576,21522,21895,21935,22392,22527,22620,23533,24220,
24617,24833,25953,25973,26027,26156,26210,26982,27008,27023,
27222,27289,27536,27907,28715,29142,29724,29810,30248,30367,
30628,31306,31311,31488,  139, 1753, 4042, 4140, 4514, 4628,
 5135, 5503, 6226, 7109, 7326, 8329, 8487, 8609, 8688, 9525,
 9550, 9687,10085,11623,11798,11869,12209,12546,12946,12953,
13130,13857,14462,14672,15185,15304,15693,16194,16611,16838,
17802,18209,18498,18553,19173,19835,20588,20672,21141,21207,
21270,21350,22107,22506,22685,22756,24700,25632,25844,26365,
27527,28966,29629,30361,30809,31539,31953,   28,  345,  591,
 1280, 1696, 1768, 2009, 2241, 2567, 3093, 3297, 3423, 3917,
 5430, 5913, 6018, 6085, 7177, 8732, 9080, 9150, 9248, 9796,
10064,10499,10788,12672,12812,12988,13582,13661,15218,16630,
17126,17133,17544,18074,18660,18933,19922,20548,20556,21403,
21947,22658,23126,25105,25702,25924,26125,26138,26727,27078,
27395,29270,29488,30496,31778,  494,  768, 1404, 2612, 3213,
 3319, 3365, 3462, 5102, 5187, 5462, 6172, 6543, 6566, 6570,
 7161, 7392, 7511,10239,11344,13602,13975,14421,14472,14981,
15587,16782,16906,17475,17561,17565,18299,18644,18733,18963,
19691,19931,20510,21824,21956,22519,23699,24106,24862,25091,
25688,26571,26754,28385,28688,29208,29225,30484,30535,30544,
30837,31361,31977,  276,  403, 2417, 3033, 4165, 5072, 5191,
 5669, 5675, 6028, 6291, 7412, 7448, 8115, 8361, 8531, 9294,
 9901,10140,10388,11969,11996,12049,12322,12494,13350,13679,
13750,15804,16597,17118,17383,19554,19657,19718,20279,20467,
20686,20995,21670,22285,22970,23049,24005,24502,27226,27473,
27793,28052,28286,28532,28747,28892,29043,29476,30221,30657,
30801,31161,  610,  666,  682,  732, 1155, 1248, 1772, 1821,
 1931, 2161, 2384, 3530, 3600, 3675, 4144, 4156, 4385, 4564,
 4620, 4699, 5014, 5038, 5109, 6092, 6202, 6307, 6560, 6997,
 7019, 7343, 7629, 7758, 8325, 8702, 9031, 9161, 9573, 9826,
10007,10107,10600,10832,11336,11463,13377,14266,14512,14742,
15524,15812,16009,16027,16095,16170,16252,16917,17224,17634,
18294,18437,19425,19522,20208,21217,22290,22432,22765,23232,
23862,23962,24232,24858,24869,25170,25400,25450,25470,25671,
25807,26278,26386,26741,26892,27118,27293,27948,28072,28232,
29326,30059,30093,30104,30378,30427,31216,31992,  223,  899,
  978, 1487, 1645, 1650, 1801, 2180, 2235, 2245, 2333, 2452,
 2695, 2817, 2923, 3041, 3664, 4148, 5060, 5235, 6464, 6642,
 6880, 7115, 7489, 8153, 8373, 8450, 8663, 8671, 8846, 8974,
 9062, 9461, 9536, 9669, 9693, 9851, 9941,10014,10100,10416,
10666,11042,11156,11214,11252,11576,11784,11987,12196,12552,
12715,12751,12787,12828,12870,12970,13059,13092,13192,13201,
13457,14053,14176,14297,14619,14923,15040,15077,15099,15297,
15751,15822,16272,16425,16572,16606,16643,16948,17692,17789,
17816,18116,18316,18337,18754,18862,19087,19210,19451,19545,
19648,20063,20169,20178,20213,20459,20954,21010,21075,21170,
21426,21507,21728,21797,22349,22406,23108,23157,23185,23370,
23685,23704,23748,23949,24351,24394,24611,24689,25046,25351,
25609,25753,25869,25938,26426,26794,27489,27752,27773,28111,
28281,28449,28720,28876,28958,29153,29650,29827,30089,30422,
30539,30747,30783,30877,31174,31253,31302,31574,31726,31985,
  534,  867, 1014, 1040, 1356, 1384, 2929, 3029, 3789, 3942,
 4097, 4703, 4731, 4887, 4951, 4963, 5437, 5470, 6000, 6871,
 6936, 6989, 7362, 7539, 7999, 8178, 8798, 9174, 9322, 9602,
 9663, 9875,10530,10587,11141,11174,11454,11668,12096,12728,
13692,14098,14164,14726,15070,15415,15592,16184,16434,16538,
17089,17360,17750,18160,18193,18517,18759,18921,18940,18974,
19050,19295,19505,19801,20245,20474,21256,21646,21901,22555,
22980,23137,24062,24239,24462,24521,25840,26343,26717,26825,
27350,27698,28057,28326,28888,28933,29581,29671,29717,29819,
29833,30076,30672,31544,  162,  315, 1032, 1395, 2079, 2844,
 2895, 3299, 3585, 5322, 5769, 7194, 7815, 7900, 7969, 8682,
 8694, 9425,10886,11925,11940,12109,14024,14173,14306,14943,
14991,16861,16959,20961,21629,21747,21758,22426,22489,23721,
24601,24728,25294,25627,25694,26446,28184,29246,29682,30336,
31073,31135,31896,  389, 1866, 1875, 1952, 2326, 2573, 2594,
 4667, 5637, 5690, 5969, 6053, 7145, 7550, 7651, 8593,10116,
10250,11182,12555,13440,13509,13554,13869,16338,16744,17898,
19942,20035,22471,22769,22909,23258,24051,24398,26221,26538,
27138,27746,27854,28225,28275,28487,28839,29019,29854,31146,
31415,31428,   41, 1004, 1434, 3843, 3887, 4183, 4840, 5651,
 5920, 6448, 7420,10103,11032,11468,11489,11619,12408,12889,
13149,13645,13827,14526,15275,15360,15691,15757,16468,17020,
17935,18082,18355,18494,19412,20071,20241,21662,22027,22310,
23588,25034,25546,25639,26772,26804,27040,27530,28728,29521,
29597,31590,31625,31643,   73,  711,  722,  796,  908, 1072,
 1274, 1922, 2377, 2741, 2985, 3191, 3932, 4138, 4447, 4516,
 6080, 6726, 8014, 8155, 8587, 9141, 9801,11054,11585,13723,
13898,15096,15318,17504,17794,17798,18190,18714,21179,21465,
22537,23468,23910,25014,25414,25865,26134,26429,27165,27788,
28894,29540,30087,30190,30796,31939,   14, 2220, 3014, 4367,
 4940, 5202, 6528, 8706, 9238, 9339, 9831,10083,10193,11110,
12101,12447,12632,14066,14273,14485,14830,15243,15258,16228,
16458,16982,17439,18063,18482,18683,20565,20868,21048,21897,
22243,22304,22373,22899,23190,23343,23809,23937,24606,24769,
24850,24864,24886,25389,25406,25891,26708,28145,28619,28653,
29429,30263,30638,30734,31106,31248,  406,  696, 1219, 1377,
 2365, 2582, 2919, 3158, 3476, 3893, 4196, 5523, 5794, 5850,
 5857, 6358, 6775, 6947, 8271, 9377,11189,11638,11850,11946,
12156,13496,13952,14238,14631,14792,15006,15108,15575,15848,
16173,16519,16972,17388,17726,18342,18581,18632,20044,20198,
20499,21548,21589,21977,22611,23500,23630,23842,25460,26009,
27781,28543,28707,29057,29300,31201,31384,31507,  193,  395,
 1735, 2342, 2712, 3522, 4573, 4671, 5199, 5450, 5488, 6344,
 7202, 7945, 8102, 8718, 9453,10040,10074,10419,10855,11725,
11843,12377,12720,13473,13525,13588,14314,14360,15088,15698,
17123,17522,17567,18970,19393,19667,19892,20110,20252,20452,
20477,20503,20545,21127,21347,22782,22906,23200,23515,23682,
24200,25357,25951,26552,27218,27317,27579,27694,28115,28253,
28366,29484,30788,31183,31321,31924,   36,   98, 1064, 1881,
 2542, 2798, 3149, 3170, 3187, 3428, 3785, 4807, 4931, 5019,
 5221, 5350, 5435, 6061, 7118, 7251, 7920, 8379, 8453, 8578,
 8988, 9298,10253,10534,10702,11613,12014,12174,12682,12703,
12732,13123,13964,14417,14888,15238,15708,16349,16622,16677,
16908,17146,17541,18346,18646,19256,19809,19981,20486,20806,
21599,22395,23046,23462,23928,24085,24457,24706,24717,24987,
26627,26659,26880,26992,27608,27737,27741,28289,28570,28873,
28994,29264,29768,29778,29888,29991,30243,31163,31989,32002,
  444,  466,  646, 1860, 2038, 2256, 2698, 3527, 3588, 3704,
 3929, 4071, 5147, 5824, 5973, 6097, 6455, 6598, 6993, 7206,
 8005, 8127, 8793, 9505,10314,10626,10681,11923,12027,12146,
12624,12800,13178,13735,13961,14303,14758,15120,15226,15294,
15829,15957,15971,15985,16017,17011,18212,18311,19033,19081,
19237,19319,19338,20413,20439,21286,21800,21806,22085,22324,
22546,22866,23857,23954,24549,24975,25187,25387,25812,26065,
26373,26750,27037,27884,28613,28860,29204,30176,30757,30857,
30874,31421,31950,32031,   17,  247,  775, 1114, 1823, 2586,
 2826, 3486, 3903, 4854, 4907, 5274, 5509, 5994, 6046, 7564,
 7606, 7643, 8267, 9110, 9347,10404,10478,10776,11100,11398,
13023,13268,14328,14796,15473,15878,16996,17689,17709,17804,
17869,18332,18787,19439,19495,19591,20508,20779,21037,21648,
21953,22511,23518,23676,24734,24819,25274,25684,25776,26352,
26403,27076,27089,27372,28552,29468,29847,29953,30149,30392,
30850,31019,31963,  239, 1152, 1562, 1955, 2125, 2404, 2553,
 2880, 2961, 3006, 3288, 3502, 3698, 3853, 3986, 4064, 4103,
 4232, 4630, 4914, 5966, 6413, 6490, 6779, 6787, 6939, 6961,
 7209, 7333, 7827, 7845, 7983, 8087, 8359, 8833, 9042, 9092,
 9144, 9251, 9265, 9450, 9519, 9752,10428,10766,10843,10882,
10897,11146,11548,12520,12562,12617,12773,12974,13288,13504,
13529,14820,14837,15452,15520,15749,16001,16441,16752,17219,
17320,17430,17493,17861,18104,18848,19092,19143,19443,19600,
19904,20047,20078,20322,20964,21068,21325,21335,21432,21559,
21813,22732,22919,23696,24023,24305,24325,24440,24837,24981,
26045,26178,26185,26338,26432,26783,26913,27143,27534,27686,
27766,28433,28836,29128,29527,29600,30305,31015,31153,31630,
   63,  135, 1640, 2130, 3608, 5480, 5725, 5989, 7049, 7113,
 7889, 9739,11103,11807,13206,13490,13765,14288,14561,16396,
17536,17956,17964,19672,20232,20377,21249,22821,23429,23582,
23754,24018,24224,25629,26838,26890,27423,28870,29502,30867,
31318,  975,  996, 1290, 1603, 1789, 1809, 2951, 5811, 7723,
 8404, 8414, 8504,11330,11369,12154,12613,12892,14332,14634,
14787,14880,15190,16240,16546,17056,17228,18084,18829,20090,
21585,22307,24260,25254,25690,26960,27867,28855,29610,30238,
30641,  155,  471,  700,  927, 1878, 2082, 2188, 3612, 4319,
 5787, 6083, 7365,10838,11450,11456,12200,12211,13218,14041,
14925,15094,15579,16099,21019,21181,23766,24236,25922,26599,
26823,28142,29089,29193,29324,29644,30886,31526,31879,  103,
 1109, 4271, 4545, 5266, 5308, 7763, 8474, 8493, 9138, 9290,
 9858,10785,13132,13537,15424,17158,17792,19484,20107,21137,
21651,22387,22888,24320,24465,24830,25315,26123,26164,28246,
29830,  434, 1076, 3410, 4006, 5683, 6572, 6671, 7003, 7299,
 7521, 8227,11019,13739,14408,15640,16063,17682,18475,18878,
19159,19502,19550,19804,20887,21829,22224,24316,24338,25768,
27989,29074,29098,31034, 1401, 1484, 2397, 2945, 3124, 3174,
 3322, 6853, 8164, 9622,11414,12063,12571,13593,14930,15570,
17786,18574,19627,20210,20387,21388,22237,22294,22334,23281,
24073,26523,27021,29023,30458,30600,  305, 2707, 3277, 3579,
 4169, 6032, 6361, 6628, 6632, 7031, 7157, 8777, 9880, 9947,
10679,11274,11580,13109,16067,16078,18982,20641,21354,22184,
22302,22411,22773,23487,24162,27659,28929,29376,  216,  456,
 1858, 3540, 3876, 4056, 4303, 4726, 5440, 8862, 8915, 8960,
 9467, 9803,10311,10470,11250,11914,12225,13483,14182,15789,
16403,18931,20932,23624,24218,26807,28709,29112,30205,30625,
31568,  863,  870, 2336, 3656, 5022, 5224, 5956, 7317, 8746,
 9998,10518,15229,15628,17379,21040,21379,21711,21973,22328,
23160,25257,25441,25495,27235,27287,28270,28283,28492,29786,
30160,31330,31490,  230,  268, 1864, 2910, 5432, 6485, 6687,
 6999, 7368, 7429, 8541,10397,10961,12797,13175,13511,13752,
14032,15512,15802,16436,16585,16857,16911,17754,18397,19727,
19881,20367,20704,20958,22340,22763,22860,23509,25156,25235,
25284,25291,25395,27170,27701,27743,27978,28104,28349,29137,
30246,30786,31195,31694,  832, 1573, 1658, 1924, 2167, 2463,
 3325, 3548, 4774, 5382, 5506, 5922, 6400, 9169, 9317, 9498,
 9759,10053,10221,10993,11351,11479,11574,11938,12066,12098,
12163,13030,13118,13468,14612,15324,15409,15675,16165,16608,
16852,16951,17445,17723,17939,18016,18881,18948,19109,19829,
19989,20166,20481,20584,21177,21276,21597,21641,24726,24800,
25980,26554,26738,26887,27092,27491,28343,28771,28948,29101,
29426,30117,30852,30922,30997,31831,   34,  100,  249,  283,
  501,  578,  738,  813,  844,  970, 1183, 1250, 1260, 1365,
 1496, 1588, 1606, 1654, 1743, 1806, 1869, 2021, 2136, 2202,
 2601, 2660, 2748, 2784, 2820, 2902, 2921, 3016, 3140, 3189,
 3375, 3497, 3774, 3939, 3957, 4117, 4190, 4316, 4473, 4524,
 4834, 4847, 4944, 5054, 5063, 5194, 5319, 5468, 5472, 5527,
 5568, 5584, 5656, 5678, 5694, 5710, 5722, 5983, 5997, 6216,
 6342, 6446, 6581, 6729, 6945, 7389, 7441, 7446, 7515, 7595,
 7646, 7693, 7734, 7879, 7990, 8201, 8334, 8412, 8546, 8709,
 8836, 8844, 8927, 9044, 9371, 9447, 9809, 9869, 9955,10110,
10200,10216,10268,10485,10668,10824,10878,11000,11039,11219,
11625,11631,11665,11828,11979,12183,12231,12237,12250,12296,
12502,12516,12575,12587,12722,13017,13070,13141,13448,13507,
13732,13776,13789,13795,14045,14078,14133,14405,14455,14683,
14701,14724,14728,14816,14851,14861,14911,15059,15268,15370,
15396,15456,15862,15962,16083,16144,16343,16367,16377,16398,
16411,16543,16574,16705,16848,17022,17033,17106,17243,17481,
17549,17578,17700,17888,17931,17959,17973,18005,18182,18434,
18571,18579,18680,18700,18718,18884,19036,19205,19405,19410,
19415,19518,19748,19969,19999,20013,20029,20116,20435,20465,
20621,20689,20836,20860,21252,21283,21359,21611,21730,21753,
21768,21850,21913,22008,22126,22192,22288,22465,22544,22549,
22745,22982,22996,23203,23356,23373,23834,23855,23964,24082,
24137,24151,24302,24676,24738,24811,24826,24890,25051,25397,
25453,25463,25472,25564,25601,25798,26040,26158,26196,26247,
26260,26275,26418,26587,26705,26968,27098,27114,27347,27365,
27397,27532,27584,27610,27848,27982,28194,28447,28479,28483,
28622,28824,28884,29037,29146,29381,29415,29511,29647,29812,
29845,29890,29919,29981,29988,30095,30297,30384,30404,30443,
30569,30742,30813,30931,31180,31238,31243,31251,31457,31740,
31786,31819,31917,31995,32004,  137,  702,  849, 1243, 1278,
 1348, 1501, 2085, 2251, 2563, 2580, 2955, 3026, 3090, 3264,
 3290, 3426, 3551, 3727, 3899, 4146, 4167, 4230, 4365, 4444,
 4485, 4884, 5587, 5864, 6051, 6265, 6283, 6301, 6375, 6777,
 7377, 7609, 7783, 8001, 8225, 8230, 8465, 8728, 8743, 8788,
 9051, 9087, 9268, 9606, 9656, 9732, 9743, 9823, 9839,10378,
10623,10714,11239,11254,11359,11372,11394,11491,12030,12406,
12564,13147,13564,14038,14312,14347,14402,14450,14856,15003,
15015,15174,15302,15851,15990,15998,16600,16675,16978,17002,
17115,17131,17160,17711,17779,17806,18110,18172,18340,18393,
18528,18703,18851,19061,19149,19169,19208,19290,19841,20380,
20410,20506,20633,20682,20788,21007,21046,21070,21224,21338,
22019,22245,22322,22750,22911,23064,23077,23168,23248,23585,
23712,23750,23820,23973,24115,24230,24284,24385,24985,25313,
25614,26208,26263,26324,26532,27001,27018,27188,27199,27267,
27315,27696,27716,27760,27881,28315,28568,28725,28740,29446,
29885,29996,30293,30586,30724,30745,30799,30839,31141,31409,
31424,31462,31632,31749,31894,31987,32029,  166,  201,  830,
 1094, 1193, 1584, 1750, 2226, 2248, 3195, 3224, 3914, 4377,
 4457, 4521, 4657, 4815, 5065, 5452, 6011, 6576, 7259, 7624,
 7776, 8120, 8482, 8534, 8575, 8908, 9409, 9517, 9528, 9627,
 9682, 9939,10180,10496,10657,10700,11477,12483,12621,12688,
12898,12933,13115,13712,13872,13938,14250,14353,14747,14946,
15256,16007,16473,16524,16636,16641,16987,17303,17334,17402,
17477,18268,18558,19047,19079,19126,19541,19663,20829,21322,
21383,21396,21535,21811,22204,22313,22664,23274,23279,23388,
23567,23645,23719,23895,24059,24400,24817,25158,25431,25636,
26030,26217,26382,26759,27224,27325,27331,27368,27920,28197,
28807,28818,29004,29081,29104,29243,29584,29667,30198,30225,
30282,31256,31262,31348,31390,31891,  932, 1047, 1296, 2175,
 3179, 3269, 3543, 4049, 4454, 4746, 5051, 6453, 6607, 6723,
 6784, 7918, 8522, 8875,10255,10456,11405,12227,12319,12500,
12908,12963,12978,13161,13273,13450,14246,15214,16033,16324,
16460,16772,16815,17619,17629,18249,18257,18329,19305,19705,
20455,20553,20802,21644,21845,22434,22607,22689,23299,23919,
24449,24997,25068,25103,25308,25750,25859,26035,26689,26918,
28750,29482,29658,29729,30254,30655,30770,30942,31028,31313,
31899,  110,  312,  801,  973, 1970, 2266, 2915, 2993, 4538,
 4687, 4946, 5156, 5476, 5610, 6363, 6419, 6467, 6867, 7142,
 7553, 7995, 8269, 8407, 8509, 9158, 9958,10581,10672,11953,
12437,12637,13570,14073,14470,15246,15442,15855,16755,17121,
18048,18157,18372,19028,19053,19715,20202,21505,21543,21980,
22151,22868,23290,23384,23457,23691,23740,25095,25193,25538,
25593,26205,26656,26701,26762,27476,28323,28418,28468,28731,
29399,29470,29875,30016,31203,   65,  286,  815,  821, 1169,
 1263, 1793, 2311, 2624, 3118, 3230, 3874, 4099, 4135, 5133,
 5205, 5497, 5832, 6157, 6740, 6828, 6958, 7357, 8649, 9163,
 9620, 9888,10441,10605,10835,11068,11148,11781,11810,12152,
12411,12542,13360,13909,14693,15316,15567,15902,15965,16264,
17559,17879,19640,21183,21774,22282,23140,24053,24776,25661,
25872,26990,28165,28452,30301,31109,   80,  526,  708, 1159,
 1300, 2191, 2426, 3972, 4912, 5607, 5616, 6044, 7232, 7691,
 8017, 8559, 9927,10027,10562,12123,12748,12835,13394,13917,
14653,15211,15480,15860,16551,18313,18960,19459,19493,20276,
20708,20966,21265,22179,22962,23724,23934,24529,24841,25038,
25200,26461,27734,28120,28443,29763,  489,  596,  985, 1245,
 2208, 2507, 2522, 3154, 3166, 3669, 4313, 4673, 4933, 5332,
 5408, 6602, 6843, 7005, 7188, 7217, 7264, 7685, 8398, 8864,
 8957, 8998, 9507, 9649, 9856, 9905,10134,10339,10511,10613,
11002,12398,12527,13151,13446,13768,13901,14050,14220,14894,
15937,16030,16140,16618,16993,17975,18087,18141,18400,18650,
18865,19277,19508,19736,19848,19863,19911,20015,20792,21713,
21892,22017,22793,23116,24281,24587,24604,25378,25743,26443,
26820,27421,27484,28087,28272,28938,29148,29257,29900,29974,
30010,30276,30500,30562,30603,31608,31737,  469,  834, 1503,
 1590, 1701, 1816, 2319, 2449, 3302, 3700, 4269, 4387, 4994,
 5080, 6403, 6471, 8338, 8499, 9039, 9319,10716,11217,11245,
11347,11656,11943,11977,12804,13864,13950,13978,14350,14808,
14842,15188,15715,17415,17720,18307,18630,18710,19587,21400,
21408,21463,21997,22359,22530,22583,22591,22682,23006,23314,
23714,23844,24121,24405,25221,25676,25815,25963,26021,26141,
26550,26692,26970,27768,27987,28263,28267,28383,28524,28529,
28703,28712,29963,30049,30261,30425,30571,31037,31308,  713,
 1272, 3851, 4618, 4763, 5403, 5899, 6104, 6563, 7438, 7892,
 9502,10042,10211,10778,11418,12865,13266,13356,15606,15623,
17583,18176,18485,18730,18876,19133,19548,19874,20235,20365,
20472,21222,21916,22099,22893,22951,23206,23656,24140,25889,
26421,26752,26813,28043,28500,29239,29507,29615,30152,30664,
30806,31450,  809, 1422, 2149, 2840, 3122, 3569, 3590, 3605,
 3963, 4113, 4823, 5444, 5816, 6067, 6761, 7180, 7296, 8903,
 9224, 9726,10783,10912,11077,11332,12240,12560,12935,13946,
15134,15390,15696,15754,15882,17091,17207,17230,17412,17501,
17737,17867,18937,19620,21088,21386,21818,21940,22227,23880,
24468,24480,25298,25612,25748,26506,26603,26965,27304,27621,
28106,29029,29060,29069,30870,31054,31379,31517,31585,31844,
  320,  837,  925, 1372, 1427, 1920, 2238, 2607, 2953, 3084,
 3172, 3776, 4429, 5344, 6004, 6038, 6310, 6432, 6545, 6655,
 7134, 7793, 7959, 8105, 8391, 8676, 8800, 9146, 9270, 9421,
 9705,10995,12024,12248,12518,12679,13454,13501,13652,13685,
13782,14479,14494,14832,15445,15651,16385,16439,17713,18395,
18735,20113,20357,20594,20613,21631,22605,22712,22808,23632,
23637,23812,24300,24418,24709,25168,25182,25267,25318,25658,
26245,27513,27844,28186,29202,29868,30460,31021,31365,31729,
  486,  612,  921, 1989, 2346, 2362, 2391, 2500, 2654, 3193,
 3343, 3841, 4058, 4562, 4734, 5090, 6248, 7534, 7561, 7903,
 7940, 8171, 8570, 8730, 9566, 9625, 9672, 9684,10451,11010,
11208,11229,11281,11737,12158,12235,12573,13956,14818,14859,
15233,15677,16230,16341,16919,16985,17099,17152,17241,18050,
18321,18775,19106,19816,20385,20493,20831,21140,21235,21927,
22315,22346,23552,23706,24065,24695,24704,25118,25439,26120,
26345,26380,27085,27404,27586,27739,27875,27905,28545,28752,
29034,30170,30398,31757,   75,  148,  199,  400,  415,  427,
  694,  983, 1212, 1258, 1276, 1282, 1418, 1499, 1571, 1579,
 1637, 1680, 1804, 1966, 2025, 2031, 2132, 2529, 2551, 2614,
 2638, 3044, 3080, 3161, 3403, 3488, 3553, 3610, 3715, 3883,
 3895, 3901, 3935, 4152, 4176, 4275, 4301, 4354, 4420, 4437,
 4452, 4501, 4528, 4679, 4710, 4761, 4817, 4826, 5035, 5043,
 5057, 5111, 5122, 5263, 5410, 5478, 5490, 5570, 5580, 5592,
 5716, 6013, 6087, 6285, 6339, 6405, 6424, 6488, 6690, 6734,
 6743, 6782, 6860, 7001, 7028, 7047, 7214, 7309, 7338, 7588,
 7705, 7785, 7965, 8003, 8026, 8100, 8118, 8160, 8263, 8496,
 8562, 8669, 8891, 8912, 8942, 8962, 9165, 9186, 9220, 9262,
 9439, 9469, 9555, 9737, 9914,10088,10094,10191,10494,10515,
10607,10621,10629,10650,10660,10674,10698,10762,11095,11150,
11164,11171,11487,11558,11571,11603,11741,11791,11853,11868,
11912,12005,12011,12400,12532,12577,12737,12810,12819,13066,
13078,13181,13292,13330,13364,13470,13488,13527,13668,13737,
13773,13830,14085,14127,14299,14345,14432,14453,14518,14529,
14551,14564,14699,14739,14798,14840,14882,14908,15169,15177,
15491,15625,15853,15858,15895,15977,16005,16179,16216,16262,
16401,16471,16479,16486,16722,16749,16818,16932,16953,17197,
17327,17363,17479,17486,17617,17623,17925,17943,17953,17995,
18286,18359,18453,18470,18697,18783,18818,19023,19136,19156,
19258,19283,19334,19366,19420,19437,19500,19665,19890,19900,
19978,20118,20126,20324,20457,20462,20479,20561,20623,20674,
20710,20761,20795,20819,20972,21051,21424,21569,21638,21765,
21855,21995,22175,22274,22525,22672,22693,22726,22779,22933,
22991,23004,23069,23134,23246,23305,23338,23368,23379,23476,
23538,23733,23818,23852,24262,24296,24433,24443,24539,24580,
24714,24824,25025,25049,25053,25072,25154,25416,25641,25760,
25765,25810,25879,25971,25975,25983,26117,26241,26375,26414,
26449,26512,26527,26540,26651,26711,26789,26830,26939,27120,
27167,27334,27370,27571,27648,27731,27856,27871,27997,28138,
28154,28317,28425,28497,28564,28656,28670,28852,28992,29109,
29191,29347,29388,29463,29514,29529,29595,29689,29714,29843,
29862,29986,30023,30028,30236,30257,30353,30439,30481,30558,
30722,30759,30884,31068,31177,31341,31358,31426,31528,31593,
31606,31681,31735,31826,31883,31959,   70,  244,  344,  451,
  685,  777, 1044, 1097, 1121, 1408, 1651, 1664, 1746, 2164,
 2263, 2575, 2588, 2598, 2908, 3327, 3592, 3808, 3927, 3947,
 4683, 5291, 5732, 5837, 5887, 6154, 6395, 6622, 6749, 6845,
 7121, 7159, 7182, 7648, 7806, 8022, 8322, 8856, 8906, 9282,
 9750, 9829, 9871,10230,10334,10376,10880,10948,10965,10981,
10987,11061,11392,11686,11841,11994,12759,13021,13326,13604,
13954,14269,14474,14827,14876,15555,15572,15603,15810,15826,
15969,16284,16521,16731,16846,17216,17250,17417,17574,17703,
18113,18568,18641,18845,19102,19453,19532,19608,19872,20250,
20417,20783,20808,20822,20930,20940,21035,21082,21344,21717,
21795,21847,21933,22562,22958,23118,23426,23485,23865,23886,
24031,24160,24682,24814,24915,25040,25163,25561,25887,26042,
26470,26589,26647,26802,26836,26963,27146,27272,27327,27374,
27599,27671,28129,28161,28167,28474,28554,28822,28886,29283,
29411,29765,29915,30265,30402,30419,30666,30765,30920,31362,
31497,31581,31806,31814,31969,  164,  398,  446,  528,  541,
  602, 1092, 1200, 1536, 1755, 1826, 2268, 2498, 2545, 2751,
 2770, 2828, 3008, 3367, 4450, 4743, 4838, 4856, 4958, 5446,
 5589, 5881, 5971, 5985, 5991, 6218, 6381, 7068, 7242, 7302,
 7387, 7536, 7738, 7911, 7916, 7942, 7953, 7981, 7993, 8265,
 8275, 8580, 9177, 9419, 9893,10069,10112,11021,11279,11452,
11481,11757,11910,11981,12118,12191,12298,12635,12896,12902,
13006,13159,13191,13442,13659,13742,13835,13969,14330,14854,
14994,15061,15128,15478,15598,15608,15653,16326,16720,16840,
17017,17183,17280,17305,17322,17742,17962,18013,18091,18100,
18170,18270,18576,18596,18716,18929,19031,19461,19589,19861,
20022,20295,20397,20450,21320,21340,21361,21390,21622,21857,
22025,22330,22405,22594,22614,22662,22748,22879,22930,24323,
24340,24438,24599,24662,24807,24867,24893,25304,25603,26150,
26384,26391,26423,26594,27202,27269,27319,27400,27808,27956,
28243,28420,28504,28527,28833,29117,29143,29342,29440,29612,
29816,30001,30157,30355,30970,31405,31956,  964, 1961, 2428,
 2658, 4061, 4188, 5119, 5520, 5648, 6427, 7226, 7574, 8140,
 8614, 8748, 8930, 8981, 9522, 9834,10011,10209,11197,11634,
12112,12317,12453,13568,14275,14706,15056,15589,18556,19466,
20026,20069,20383,20660,21970,22890,23639,24390,24499,25540,
25965,26203,28046,28490,29687,30278,30415,30488,30882,31523,
31587,31603,31724,  463,  998, 1608, 2193, 2838, 3532, 4051,
 4894, 5685, 7315, 7348, 8566, 9286, 9793,10655,11416,11816,
13499,13862,13980,14071,14342,14834,15864,16566,16582,16644,
17428,17507,18251,18357,20751,20799,22135,22568,23166,24843,
25737,26037,26957,27811,28573,31039,31241,31912, 1478, 1682,
 3156, 3563, 3650, 4690, 8882, 9112,10579,11092,11459,13923,
14419,15373,15454,15470,18896,19622,19745,21929,22030,23386,
23544,24041,26265,27197,27899,29379,30340,30774,  674, 1976,
 4374, 6246,11044,12160,12434,15115,16785,17205,17329,17796,
17825,18779,20004,21704,23075,23303,23525,24933,25649,26368,
26735,28135,29232,29589,30944,31418,32012,  491,  897, 1738,
 1759, 3407, 4225, 4285, 4921, 6469, 6885, 6984,12165,12822,
12919,13516,14222,19403,19520,20790,21410,21924,22680,23129,
24784,25212,26126,26905,27939,31751, 2533, 3082, 3768, 5233,
 6956, 8091, 8396, 9295,10683,12906,13188,15910,16061,18003,
18473,18502,21696,23094,23348,24098,24835,24923,25433,26169,
27352,28581,29461,29509,30441,31120,31838,31901,  196,  667,
 1812, 2438, 3965, 5766, 6111, 7009, 7062, 9845,12790,13195,
14177,14317,14849,15594,17165,17718,19232,19515,19720,21822,
23171,25088,25363,27411,27798,27918,29200,29665,29784,30386,
31002,  881, 2704, 3333, 4558, 4661, 6451, 7875, 8125, 8802,
 9065, 9886, 9932,10213,10872,11875,12139,12504,16614,18067,
18726,19095,23043,23051,23827,24336,25673,27191,27297,27718,
30081,30407,31381,31512,  112,  725, 1017, 1368, 1406, 1441,
 1642, 2524, 2616, 3115, 3759, 5092, 6269, 6337, 7616, 8348,
 9925, 9992,10288,10760,10858,11353,13407,13535,14291,14424,
15942,16035,16379,17340,17538,17666,19352,19633,19987,20374,
21756,25663,26947,27688,29731,30018,31407, 2177, 3731, 3751,
 3788, 4003, 4431, 4616, 5532, 6194, 6355, 6673, 7235, 7603,
 7715, 8550, 9837, 9912,10725,11012,11210,11375,11552,11956,
12416,12604,12755,14104,14119,14254,14734,15272,15774,15873,
15893,16850,17680,18708,20268,20445,20619,20741,20884,21064,
21190,21786,22239,22578,24328,24686,25198,25424,25634,27419,
28265,28685,28699,28829,29241,29289,29330,30687,30955,   48,
  127,  144,  281,  606,  634,  698,  715,  736,  742,  819,
  842, 1233, 1298, 1315, 1363, 1430, 1457, 1542, 1549, 1581,
 1592, 1628, 1855, 2041, 2186, 2259, 2270, 2321, 2393, 2412,
 2469, 2502, 2566, 2733, 2803, 2937, 3023, 3035, 3120, 3126,
 3138, 3164, 3202, 3267, 3337, 3473, 3490, 3685, 3706, 3863,
 3889, 3953, 4130, 4297, 4350, 4435, 4442, 4459, 4577, 4724,
 4757, 4867, 4892, 4904, 4909, 5189, 5196, 5228, 5237, 5269,
 5405, 5513, 5826, 5872, 5976, 6089, 6174, 6180, 6199, 6223,
 6250, 6292, 6421, 6539, 6639, 6821, 6851, 6874, 6970, 7172,
 7186, 7267, 7320, 7590, 7597, 7627, 7640, 7689, 7894, 7922,
 7936, 8028, 8289, 8328, 8401, 8501, 8602, 8661, 8724, 8866,
 8871, 8889, 8948, 9222, 9307, 9360, 9382, 9496, 9515, 9658,
 9667, 9716, 9729, 9811, 9866, 9996,10009,10035,10055,10127,
10138,10145,10218,10240,10274,10282,10564,10599,10616,10639,
10693,11084,11137,11425,11483,11605,11628,11641,11726,11747,
11768,11776,11846,11905,12052,12116,12178,12189,12252,12301,
12333,12387,12392,12549,12730,12833,12837,12868,13068,13282,
13294,13299,13322,13461,13559,13650,13657,13747,13854,13889,
13895,13989,14091,14113,14212,14355,14410,14620,14708,14722,
14749,14784,14884,15193,15202,15236,15329,15365,15447,15496,
15501,15834,15996,16012,16041,16069,16081,16090,16097,16138,
16152,16355,16373,16413,16445,16553,16776,16855,16927,17000,
17054,17061,17095,17173,17199,17353,17395,17598,17758,17817,
17863,17945,17967,18265,18288,18466,18492,18561,18636,18722,
18789,18924,18952,19017,19124,19241,19264,19312,19344,19445,
19538,19798,19845,19868,19895,20011,20099,20122,20128,20172,
20408,20491,20777,20849,20889,20894,21056,21143,21173,21210,
21314,21420,21474,21567,21726,21820,21900,21964,22097,22128,
22182,22199,22229,22364,22381,22535,22619,22708,22735,22818,
23152,23179,23240,23252,23297,23451,23480,23528,23557,23761,
23878,23902,24029,24076,24205,24255,24311,24356,24427,24486,
24537,24628,24637,24653,24788,24969,25055,25066,25079,25120,
25367,25477,25493,25575,25597,25745,25762,25893,25946,25987,
25998,26058,26077,26255,26416,26585,26601,26694,26722,26745,
26910,26925,26931,27042,27083,27376,27415,27472,27500,27709,
27729,27749,27771,27865,27966,27985,28034,28118,28364,28485,
28547,28664,28826,28913,28960,29093,29114,29386,29409,29438,
29679,29801,29883,29917,30219,30252,30259,30269,30358,30431,
30486,30538,30670,30767,30782,30819,30925,30939,30948,31052,
31158,31168,31197,31367,31399,31509,31563,31686,31713,31788,
31828,31833,32033,  218,  322,  811, 1062, 2062, 2407, 2436,
 2531, 2719, 2728, 2989, 3392, 3662, 3799, 4141, 4697, 4705,
 4804, 5070, 5117, 5242, 5729, 5806, 6069, 6459, 6561, 6579,
 7054, 7073, 7611, 7695, 7710, 7769, 7873, 7987, 8300, 8336,
 8460, 8548, 8607, 8705, 8858, 9135, 9160, 9444, 9532,10575,
10800,11176,12361,12593,12698,12792,13211,13303,13346,13524,
14060,14436,14714,14745,15475,15631,16236,16406,16724,16770,
17150,17167,17570,17636,18184,18728,18781,19216,19479,19659,
19683,19807,20093,20389,20763,20804,20877,21392,21606,21910,
21975,22044,22133,22144,22276,22609,22670,22691,22753,23572,
23616,23939,24158,24471,24526,25549,26427,26556,27204,27678,
28373,28549,28865,29015,29121,29451,29519,29663,29898,30040,
30375,30498,30618,30994,31743,31875,31887,31907,31967,   60,
  261,  580,  653,  691,  727,  782,  911, 1049, 1187, 1494,
 1847, 3210, 3380, 3463, 3729, 3988, 4101, 4279, 4549, 4831,
 5142, 5342, 5844, 5855, 5893, 6021, 6117, 6541, 6825, 6920,
 7169, 7391, 7740, 8346, 8774,10262,10292,10399,10712,11298,
11600,11716,11771,12418,12882,13135,13204,13314,13721,14321,
14487,15140,15216,15221,15422,15584,16142,16257,16363,16990,
17035,17093,17591,17937,18106,18655,19077,19248,19321,19331,
19734,19782,21166,21633,21669,22215,22895,22989,23073,23147,
23320,23330,23667,23770,23897,24211,24420,24509,24839,25093,
25656,25881,26005,26534,26661,26703,26764,26832,26979,27264,
27493,27755,27889,28041,28085,28095,28147,28230,28628,28705,
28850,29716,30834,31209,31266,31623,31731,  119,  480, 1181,
 1788, 1836, 2019, 2036, 2159, 2709, 2812, 3619, 3674, 4115,
 4343, 5412, 5484, 5960, 6288, 7144, 7192, 7567, 7829, 8259,
 8353, 8507, 8573, 8760, 8879, 9368, 9423,10321,10635,11048,
11143,11158,11191,11272,11345,11723,11753,12143,12615,13093,
13183,13199,13358,14068,14094,14696,15482,15591,15649,15954,
16130,17025,17190,17293,17684,18162,18198,18381,18628,18687,
18860,19360,19642,19858,19916,20017,20224,20272,20840,20942,
21215,21267,21510,21541,22876,22913,22967,23079,23503,23729,
24007,24413,24882,25237,25487,25591,26023,26243,26564,26901,
27356,27594,28345,28450,28952,29413,29913,30556,30580,31445,
31452,31763,   12,  630,  790, 1382, 1412, 1698, 2122, 2198,
 3219, 3500, 3614, 4325, 4462, 4480, 5207, 5324, 6244, 6299,
 6600, 7328, 8010, 8176, 8418, 9184, 9485, 9949,10461,10527,
11057,13086,13157,13340,13601,14464,14674,14730,14790,15515,
16347,16930,17370,17695,17907,18315,19679,19791,20938,20947,
21002,21061,21241,21587,22241,23099,23470,24067,24292,24463,
24771,25306,25566,26136,26273,26311,27003,27862,28113,28240,
28329,28576,28651,28926,29214,29493,29841,30588,30727,30815,
31042,   43,  432,  851,  861, 1862, 2140, 2979, 3354, 3846,
 4073, 4553, 4669, 4681, 7154, 7619, 8925, 9301,10121,10176,
10390,11007,11073,11470,11863,12321,12544,13144,13635,13919,
14426,15125,15241,15791,16201,16620,16669,16824,16942,17920,
18021,18519,19147,19234,19309,20131,21016,21371,22656,22667,
23177,24016,25381,25651,26193,26354,26796,27723,28608,29255,
29623,29806,29864,29983,30738,30794,31104,  105,  133, 1087,
 1791, 1851, 2261, 2592, 2882, 3679, 3933, 4685, 4772, 5582,
 5822, 6271, 6499, 6615, 6837, 7132, 7526, 7751, 8979, 9027,
 9085, 9900,10033,10426,10438,11242,11611,11928,12022,12306,
12365,12778,12915,13400,13948,13959,14371,14824,14997,15035,
15180,15505,16076,16250,16763,17318,18447,18853,19114,19854,
20057,20855,20957,21090,21617,22149,22158,22300,23546,23698,
24096,24216,25098,25202,26067,26632,27551,27704,28754,29444,
29582,30097,31058,31611,  878, 1936, 2456, 3097, 3131, 3204,
 4235, 5338, 6574, 6609, 6745, 7026, 7822, 7947, 8169, 8285,
 8782, 9037, 9123, 9431, 9441,10308,10449,10708,11622,11825,
11990,12150,12449,13064,13290,13414,14144,14166,14416,15489,
17138,17155,17596,17627,18143,18263,18724,19014,19418,19932,
20230,21467,22177,22218,22678,22994,23778,23846,24298,24667,
25110,25344,25646,25991,26047,26347,26846,27426,27804,28815,
29083,29262,29575,30181,31164,31323,31576,31711,32014,  614,
 1420, 1447, 1886, 1991, 2115, 2357, 2561, 2632, 2849, 3520,
 3667, 3995, 4560, 5279, 5302, 5809, 7011, 7461, 7505, 8281,
 8385, 9288,10989,11836,13319,13452,13883,14309,15092,15274,
15645,15880,16242,16481,16837,18542,18678,18706,18946,19646,
19883,20326,20977,21453,21745,22114,22207,22425,22565,23114,
24055,24589,24809,24872,25216,26115,26907,27344,27382,27470,
27714,27970,28127,28717,28940,30229,30285,30303,30630,30662,
31030,31151,31373,  539,  676, 1205, 1353, 1480, 2570, 3197,
 3718, 3974, 4340, 4841, 5621, 5697, 5801, 5883, 6667, 6725,
 7543, 7799, 8030, 8211, 9131, 9571, 9608,11293,12000,12359,
12619,13173,13932,14256,14280,14434,14910,15065,16404,17233,
17337,17499,17668,17735,18477,18744,18962,19100,19603,20115,
20293,20406,20551,20759,20817,21159,21220,21962,22140,22508,
22576,23045,24117,24384,24623,24711,25081,25178,25228,26019,
27653,28068,29287,29344,29569,29656,29681,30465,30542,30872,
30979,31809,31846,   55,  116,  458,  548,  600, 1082, 1586,
 2134, 2156, 2195, 2893, 2991, 3725, 4609, 5154, 5287, 5713,
 5790, 5834, 6040, 6352, 6398, 6878, 7431, 8149, 8485, 8518,
 8884, 8945, 9472, 9530,10297,10394,10597,10973,11302,11338,
11569,12133,13778,14209,14364,15224,15388,16167,16591,16612,
16905,17801,18126,18178,18652,18777,19422,19893,20395,20862,
22547,22596,23554,23680,23756,24153,25209,25251,25542,25862,
26172,26515,26984,27034,27409,28647,29126,29230,29499,29821,
30338,30560,31125,31144,   92,  332,  418,  915,  966, 1078,
 1223, 1539, 1630, 1761, 2242, 2273, 2344, 2444, 2776, 2886,
 3293, 3510, 3556, 3561, 3969, 4090, 4510, 4812, 5442, 5771,
 5842, 5874, 5954, 6294, 6849, 6912, 6949, 6991, 7023, 7033,
 7318, 7747, 7972, 8217, 8298, 8313, 8658, 9345, 9640, 9821,
 9884, 9891,10182,11594,11935,12040,12069,12346,12396,12686,
12998,13305,13791,14301,14340,14689,15619,16160,16224,16462,
16536,16896,16925,17175,17298,17748,17808,17865,17893,18500,
18594,18835,19364,20437,20489,20645,20652,20769,21278,21524,
21898,22724,22743,22777,22964,23001,23325,23341,23436,23840,
24046,24149,24524,25184,25223,25276,25504,25577,25778,25820,
25932,26581,26625,26916,27313,27590,27751,28102,28175,28248,
28302,28341,28502,28964,29485,29617,29780,29860,29893,30222,
30360,30826,30832,31455,31492,31697,   86,  108,  220,  232,
  317,  352,  448,  520, 1019, 1359, 1616, 1667, 1883, 2033,
 2651, 2739, 2792, 2833, 2949, 3088, 3304, 3384, 3505, 3791,
 4069, 4247, 4335, 4433, 4503, 4540, 4575, 4942, 5026, 5209,
 5306, 5317, 5384, 5718, 5818, 5866, 6062, 6241, 6429, 6558,
 6584, 6763, 6796, 7015, 7257, 7306, 7353, 7422, 8111, 8647,
 8721, 8779, 8804, 9273, 9373, 9489, 9702,10060,10136,10148,
10223,10242,10316,10380,10472,10492,10696,10806,10963,11028,
11247,11257,11386,11396,11423,11475,11563,11800,11839,11873,
12047,12294,12566,12764,12775,12794,12911,13137,13389,13463,
13479,13700,13856,13887,13907,14026,14121,14135,14422,14477,
14636,14736,14794,14903,14919,15277,15577,15685,15705,15713,
15752,15796,15846,16015,16293,16527,16661,17163,17201,17239,
17386,17707,17917,17947,18344,18547,18674,18757,18874,18890,
18943,19020,19104,19279,19336,19686,19992,20095,20200,20274,
20797,21094,21185,21188,21422,21508,21520,21557,21720,21843,
21982,22004,22186,22221,22513,22589,22816,23250,23254,23810,
23936,24027,24123,24266,24466,24542,24786,24852,24865,25070,
25508,25682,26028,26060,26187,26267,26336,26643,26769,26952,
26976,27129,27283,27385,27465,27582,27690,27758,28169,28375,
28380,28445,28476,28809,28997,29087,29459,29633,29770,29878,
30115,30196,30612,30620,30653,31160,31205,31304,31745,31753,
32022,  338,  980, 1126, 1198, 1577, 2012, 2421, 2959, 3168,
 4273, 5185, 5231, 6928, 6982, 7060, 7211, 7580, 7997, 9259,
 9335, 9745, 9795,10793,11034,11362,12817,12961,14035,14214,
15956,16196,16381,16549,16639,16796,17664,17823,19009,19163,
20371,20699,21205,21449,21738,22504,22628,23102,23142,23775,
23900,24035,24202,26129,26406,26729,26827,26882,26934,26941,
27329,27482,27541,28915,29504,29626,30217,30280,30483,30648,
   82,  680,  779, 1757, 3465, 4759, 5661, 5782, 7359, 8069,
 8278, 8515, 8745, 9053, 9349,10044,10195,10868,11774,11866,
12746,13595,13966,14870,15183,15334,15787,15831,16053,16820,
17601,17732,19655,20164,20220,20501,20665,20773,22161,23092,
24249,24451,26399,26622,27913,28065,28079,28662,28701,29134,
29210,29417,30380,30946,31579,31793,  122,  237,  594, 1647,
 1987, 2496, 2942, 3300, 4371, 4448, 4929, 5448, 5654, 6664,
 7843, 8196, 8376, 9365, 9459,10114,11739,12701,13082,13362,
14644,15038,15106,16466,16709,17881,18089,18747,19788,19827,
21609,22111,22401,22483,23301,24496,24724,24983,25282,25580,
25985,27186,27406,28032,29526,29532,30405,31155,31436,  664,
 1661, 1927, 1978, 2410, 3286, 3622, 3764, 3930, 3978, 4708,
 4869, 5708, 5979, 6377, 7572, 7905, 8564, 8736, 8842, 9427,
 9548,10072,10723,12036,12389,12481,14458,15205,16587,17059,
17332,18246,18570,18965,19506,20194,20425,20447,21004,21263,
21443,21596,22080,22523,24774,25920,27295,28351,28690,31780,
  847,  909, 1116, 1267, 1444, 2965, 3415, 3721, 4192, 4659,
 4806, 4829, 5297, 5804, 6496, 6804, 6933, 8078, 8344, 8366,
 8511,10670,10895,11526,11728,12136,12176,12337,12782,12993,
13072,13120,13253,14248,14549,14622,15499,15518,16624,16995,
17361,17613,17698,17814,18147,18253,19243,19447,19477,19843,
21272,21435,22231,22730,23263,23658,23917,23951,24478,24802,
25012,25101,25269,25353,25595,25692,26518,26629,26805,26972,
27221,28325,28387,28481,28918,29027,29079,29852,30299,30400,
31077,31310,31530,   32,   57,  291,  577,  817,  864,  875,
  893,  962,  987, 1111, 1217, 1432, 1684, 1748, 1752, 1766,
 1781, 1814, 1831, 1892, 2065, 2143, 2505, 2564, 2609, 2781,
 2836, 2998, 3021, 3039, 3104, 3207, 3315, 3345, 3419, 3565,
 3581, 3710, 3844, 3885, 4046, 4108, 4128, 4137, 4154, 4290,
 4390, 4497, 4530, 4547, 4556, 4836, 4960, 5006, 5012, 5068,
 5239, 5330, 5474, 5572, 5628, 5703, 5796, 5862, 5879, 5885,
 6098, 6109, 6220, 6274, 6593, 6618, 6635, 6815, 6872, 6964,
 6973, 7116, 7138, 7222, 7244, 7262, 7341, 7371, 7495, 7586,
 7599, 7774, 7925, 7951, 8207, 8257, 8295, 8305, 8655, 8763,
 8791, 8877, 8934, 8959, 9060, 9434, 9455, 9504, 9670, 9712,
 9718, 9807, 9827, 9847, 9994,10006,10066,10272,10284,10325,
10523,10603,10611,10637,10691,10753,10764,10812,10817,10910,
10969,10976,11014,11041,11097,11263,11540,11620,11794,11858,
11975,12217,12414,12439,12491,12522,12693,12725,12739,12788,
12941,13220,13280,13354,13381,13543,13562,13648,13683,13706,
13770,13866,13925,14043,14293,14324,14362,14524,14660,14801,
14878,15090,15118,15171,15200,15209,15219,15265,15270,15292,
15553,15569,15808,15818,16019,16028,16088,16238,16391,16568,
16576,16616,16647,16651,16717,16747,16787,16827,16859,16921,
17004,17221,17282,17372,17483,17513,17593,17777,17885,17902,
18011,18069,18102,18174,18272,18303,18323,18348,18388,18432,
18634,18648,18695,18765,18893,19075,19097,19165,19221,19250,
19299,19510,19618,19717,19722,19743,19785,19885,20024,20097,
20176,20243,20259,20283,20399,20430,20511,20574,20635,20679,
20706,20847,20851,20936,21026,21175,21192,21237,21461,21550,
21591,21751,21793,21859,22095,22146,22280,22284,22296,22348,
22361,22389,22622,22791,23041,23066,23084,23096,23120,23136,
23434,23459,23550,23664,23689,23722,23752,23768,23822,24021,
24134,24244,24253,24455,24505,24511,24684,24692,24856,24870,
24913,24920,24931,24989,25004,25214,25244,25288,25361,25418,
25588,25774,25852,25857,25989,26032,26070,26148,26152,26508,
26521,26525,26548,26617,26696,26799,26840,26949,27179,27207,
27237,27341,27467,27503,27515,27555,27650,27736,27762,27932,
27980,27999,28100,28140,28274,28369,28551,28697,28714,28762,
28995,29045,29055,29067,29198,29395,29404,29512,29641,29709,
29733,29838,29958,30047,30079,30172,30185,30203,30447,30548,
30609,30615,30636,30644,30776,30875,30983,30990,31047,31071,
31228,31392,31412,31441,31499,31555,31619,31706,31727,31733,
31881,31910,32008,  632, 1023, 2138, 2222, 2810, 3468, 3733,
 3779, 4053, 4277, 8287, 8712, 9309, 9354, 9761,10290,10845,
11052,11447,11779,12430,12958,13405,13566,13744,13870,14106,
14348,14639,14863,15940,17108,17547,17799,18863,19732,20266,
21246,22947,24196,25617,26271,27993,28070,28156,28687,28858,
28903,29123,30072,30102,30348,30564,30668,31133,  584, 1225,
 1310, 2352, 2917, 4040, 4845, 4890, 6023, 6178, 6449, 6864,
 6943, 7699, 8032, 8123, 8420, 9916,10577,10833,11521,11596,
12904,13015,13689,14605,15700,15866,16368,17213,17765,17773,
18019,18134,18663,19012,19674,22202,22528,22660,22686,22761,
23173,23478,23893,25365,26017,26359,26923,27087,31460,31700,
31783,31790,31961,   50,   62,  496, 1247, 1673, 3237, 4632,
 5078, 5107, 5699, 5727, 6192, 6759, 8976, 9292,10853,11268,
11759,12061,12180,12451,12887,13847,15113,15636,15660,15973,
16602,18361,19069,19090,19431,19822,20362,21125,21363,21831,
22194,23055,23350,23971,24482,24614,24707,24736,25643,25846,
27154,27299,27337,27614,27972,29281,29332,30020,31801,  354,
  644, 1818, 2147, 2622, 4860, 6094, 6225, 6684, 8012, 8074,
 8191, 8350, 8950,10215,10758,11365,11805,12202,13641,15136,
15621,16136,17419,17589,18120,19034,19725,20042,20228,20304,
20470,20842,20944,21066,21472,21579,21776,22418,22746,22795,
23535,24234,26160,26305,26562,27711,27859,28116,28441,28844,
29295,29350,29866,30467,31566,  270,  350,  706, 1553, 2113,
 2766, 2788, 3870, 5312, 5482, 5529, 5646, 6162, 6588, 6721,
 7036, 8854, 8923, 8986, 9024, 9089,10178,11721,12016,12162,
12314,12717,14400,14676,15563,15794,16672,16757,17760,18206,
18850,19131,19971,20568,20970,21533,22559,22784,22972,23507,
24639,25757,26569,28280,28620,29604,30736,31000,31224,31403,
31525,  153,  212,  324,  330,  622,  799, 1485, 1594, 1775,
 1995, 2045, 2206, 2275, 2746, 3690, 3990, 4259, 6151, 6306,
 6986, 7974, 8331, 8917, 9226, 9358,10016,10051,11108,12976,
13475,13749,14307,14510,14665,15021,15586,16707,16726,17235,
17530,18451,18497,20404,20696,21058,21213,21763,22710,23590,
24103,24392,24847,25191,25698,26198,26253,26596,26767,27354,
28108,28640,28649,28921,28957,30574,  604,  660,  887, 1345,
 1618, 2210, 2433, 2516, 2884, 2906, 3144, 4005, 4379, 4445,
 4519, 4935, 5293, 5466, 6019, 6388, 6554, 6646, 7311, 7355,
 7517, 7635, 7680, 7817, 8308, 9332, 9644,11573,11658,11734,
12950,13249,13384,13878,13891,13903,13971,14874,14935,15314,
15613,16156,17873,18052,19272,19750,19929,20188,20608,21346,
21529,21565,21709,21839,21894,22190,23382,23511,23693,24429,
24732,24782,25412,25428,25735,25832,27846,27961,28676,29277,
29823,30053,30162,30536,30865,31299,31328,31549,31570,  205,
  477,  531,  807, 1547, 2970, 3309, 3412, 4499, 4526, 5049,
 5201, 5226, 5349, 5631, 6812, 7039, 8082, 8364, 8527, 8680,
 9188, 9494,10057,10086,10839,10891,10901,11443,11861,12485,
12514,13104,13117,13216,13392,14338,14559,14940,15367,16186,
16246,16419,16834,16945,17345,17999,18483,18907,18926,19214,
19729,20061,20352,21931,22695,23431,23674,23763,23832,25265,
25571,25678,26466,26898,27510,27869,28004,28320,28338,28950,
29064,29407,29535,29814,30042,30147,30824,31010,31218,31254,
31703,31997,  251,  994, 1476, 1656, 1689, 2317, 2375, 2640,
 2935, 3401, 3471, 3749, 3912, 4287, 4543, 4896, 5115, 5964,
 7107, 7576, 7717, 8213, 8369, 9246, 9898,10237,10502,11152,
11390,11407,11680,11922,12187,12194,12213,12233,12921,12937,
12972,14029,14629,14806,15197,15244,15694,15717,15951,15959,
16353,17125,17245,17441,17987,18334,19171,19625,19839,21012,
21415,21853,21988,22118,23088,23876,25086,25584,25790,25943,
26201,26308,26441,26844,27309,27480,27573,27605,28093,28733,
29013,30605,30953,31823,31946,    1,   25,   67,   96,  102,
  209,  301,  307,  425,  437,  455,  505,  704,  730,  828,
 1035, 1052, 1178, 1221, 1366, 1388, 1453, 1473, 1505, 1871,
 2027, 2055, 2058, 2349, 2354, 2366, 2381, 2386, 2520, 2526,
 2537, 2556, 2649, 2700, 2796, 2913, 2983, 3042, 3073, 3091,
 3222, 3339, 3377, 3397, 3460, 3524, 3545, 3550, 3574, 3601,
 3658, 3672, 3713, 3867, 3981, 4088, 4132, 4150, 4227, 4283,
 4315, 4360, 4715, 4819, 4848, 4938, 4948, 5001, 5094, 5137,
 5149, 5223, 5251, 5265, 5422, 5495, 5538, 5599, 5643, 5667,
 5785, 5814, 5911, 5952, 6106, 6159, 6228, 6234, 6239, 6341,
 6359, 6373, 6393, 6630, 6650, 6669, 6768, 6789, 6830, 6858,
 6883, 6931, 6978, 7045, 7111, 7204, 7219, 7249, 7331, 7593,
 7650, 7721, 7729, 7736, 7754, 7884, 7934, 7954, 7989, 8006,
 8024, 8291, 8302, 8340, 8362, 8392, 8472, 8476, 8604, 8786,
 8838, 8851, 8886, 8932, 8964, 9041, 9057, 9072, 9097, 9133,
 9182, 9240, 9254, 9329, 9341, 9476, 9559, 9604, 9680, 9691,
 9907, 9934,10047,10132,10143,10228,10233,10260,10270,10295,
10301,10305,10341,10467,10583,10589,10706,10826,11066,11079,
11105,11166,11184,11187,11221,11235,11286,11373,11532,11560,
11645,11663,11749,11818,11834,11965,12110,12170,12198,12205,
12229,12341,12402,12436,12541,12558,12639,12761,12802,12808,
12815,12873,12884,12900,13139,13263,13275,13379,13533,13589,
13714,13730,13798,13828,13859,13911,13976,14076,14236,14259,
14344,14373,14441,14496,14599,14647,14655,14704,14712,14803,
14844,14865,15011,15045,15083,15280,15285,15289,15301,15331,
15426,15440,15679,15702,15800,15980,16025,16208,16234,16286,
16321,16366,16371,16415,16531,16579,16634,16655,16666,16742,
16956,16967,17014,17102,17288,17325,17377,17381,17410,17494,
17557,17676,17716,17744,17913,17923,17983,18124,18153,18188,
18275,18319,18351,18385,18391,18566,18666,18712,18785,18823,
18935,19025,19038,19065,19122,19151,19281,19303,19329,19354,
19428,19457,19486,19517,19613,19661,19777,19876,20088,20240,
20262,20317,20440,20615,20747,20754,20793,20858,20881,20892,
20960,21147,21201,21226,21254,21285,21352,21356,21574,21604,
21715,21808,21849,21921,21938,21951,22020,22052,22137,22153,
22164,22351,22428,22485,22491,22699,22706,22716,22767,22804,
22857,22915,22956,23125,23145,23272,23322,23375,23392,23395,
23428,23474,23523,23563,23634,23647,23661,23731,23772,23871,
23926,23930,24039,24083,24142,24207,24402,24460,24474,24518,
24602,24608,24645,24768,24828,24965,24971,25015,25233,25300,
25371,25446,25467,25489,25625,25630,25668,25739,25782,25800,
25877,25883,25939,25996,26000,26139,26219,26227,26238,26438,
26542,26558,26720,26785,26815,26818,26849,26854,26920,26929,
27027,27081,27100,27209,27216,27302,27366,27565,27661,27665,
27680,27720,27783,27897,27945,27968,28122,28150,28245,28269,
28371,28423,28488,28514,28538,28557,28838,28900,29002,29052,
29058,29129,29268,29421,29427,29453,29496,29593,29637,29684,
29699,29776,29790,29870,29904,30003,30036,30154,30165,30178,
30200,30242,30454,30475,30479,30490,30502,30593,30821,30913,
30935,30964,31023,31172,31339,31383,31423,31432,31546,31635,
31640,31765,31840,31877,  902, 1164, 1317, 1375, 1653, 1974,
 2216, 3616, 3879, 4299, 4483, 5212, 5625, 6184, 6280, 6802,
 7644, 7707, 7771, 8188, 9083, 9218, 9563,10457,10983,11266,
11399,11684,12099,12825,13180,13317,13485,14334,14595,14932,
15050,15574,15600,15656,15856,15875,16022,16205,16457,16522,
16778,17312,17368,17434,17756,18108,18539,19598,19695,19802,
20301,20738,21333,21816,21991,22998,23132,23496,24105,24241,
25483,25729,26084,26639,26966,27094,27699,28238,29073,29501,
29921,31236,31345,31386,  310,  465, 1393, 2845, 3159, 4185,
 4611, 4663, 4727, 5024, 5055, 5464, 5585, 6030, 6059, 6806,
 6869, 7701, 7749, 9320, 9543,12125,13177,13348,13494,14315,
15900,16542,18075,18202,18954,19254,19350,19489,20582,20675,
21457,21561,22379,22600,23292,24344,24616,24669,25263,26649,
27136,27669,28335,28626,28847,29154,29274,29478,29607,29911,
30917,32027,  228,  394,  977, 1046, 1059, 1291, 1925, 2635,
 2821, 3577, 4084, 4456, 5487, 7491, 7632, 7732, 8900, 9106,
 9539,10318,10786,11630,12768,13503,14754,14915,15451,18095,
18533,19275,19394,19880,20237,21078,21324,21784,22865,24354,
24790,25552,25770,26605,27124,27424,29952,30842,30937,31178,
31760,  214,  342, 1065, 1770, 2805, 3136, 3178, 3695, 4111,
 5267, 5515, 6264, 6357, 8717, 8953, 9271, 9903,10384,10412,
10632,11162,12256,12684,13387,15079,16039,16276,16483,17896,
18488,19747,19796,20286,20592,21643,22082,22787,24080,24113,
24138,24166,24321,25309,25733,25977,27387,28006,29100,29832,
30685,30923,31542,31965, 1824, 1879, 1933, 2818, 3857, 3999,
 6537, 6626, 7233, 7339, 7757, 8387, 8642, 8895, 9616,10571,
10810,11227,11660,11762,12184,12536,12711,13010,14174,15610,
17157,17384,18243,18549,20119,20168,20606,20838,21619,22923,
23161,23256,23390,23461,23520,23909,23933,24531,24642,26146,
26231,27132,27361,28059,29323,29579,30000,30231,31247,31914,
  913, 1207, 1230, 1602, 1998, 2231, 3320, 3390, 3554, 3873,
 3985, 4119, 4487, 4953, 4966, 5254, 5387, 5427, 5733, 6208,
 6365, 7322, 7416, 7621, 7765, 7970, 8371, 8491, 9727, 9765,
 9945,10446,10946,11637,11930,11937,12369,12442,12772,12866,
13106,13146,14033,14149,14217,14289,14351,14617,15295,15459,
15771,16079,16255,16789,16800,17128,17143,17231,17358,17534,
17784,17870,18181,18545,18720,19400,19860,19906,20006,20378,
20498,21156,22106,22318,22415,22496,23110,24087,24387,24891,
24996,25249,26014,26180,26314,27333,28235,28566,28610,28767,
29136,29299,29338,30622,31040,31258,31314,31626,   72,  129,
  334,  358,  390,  931, 1074, 1189, 1203, 1295, 1306, 1797,
 1838, 1888, 2007, 2052, 2213, 2454, 2535, 2706, 2735, 2888,
 2956, 3226, 3291, 3405, 3516, 3571, 4321, 4345, 4356, 4422,
 4693, 4764, 4852, 4880, 4911, 5258, 5276, 5310, 5517, 5603,
 5692, 5851, 5908, 6214, 6278, 6445, 6675, 6756, 6774, 7151,
 7367, 7613, 7704, 7712, 7839, 8037, 8129, 8219, 8272, 8727,
 8776, 9033, 9118, 9363, 9654, 9662, 9889,10004,10123,10205,
10417,10529,10627,10678,10877,11086,11099,11238,11462,11577,
11714,12246,12488,12496,12508,12599,12743,12798,13328,13548,
13916,13945,13987,14080,14240,14278,15129,15191,15207,15404,
15431,15629,15746,15839,15906,15948,16059,16074,16169,16183,
16191,16337,16711,16781,16792,16813,16842,16940,17045,17252,
17296,17310,17972,17980,18002,18150,18330,18440,18469,18559,
18591,18838,18868,19260,19333,19497,19601,19628,19811,19889,
19919,20055,20106,20603,20668,20749,20757,20787,20897,21198,
21431,21514,22033,22308,22358,22366,22931,22949,22992,23003,
23013,23154,23169,23366,23453,23491,23669,23813,23817,24225,
24347,24435,24634,24648,24713,24740,24911,24979,25008,25239,
25256,25260,25422,25792,25829,26127,26142,26166,26387,26782,
26801,26981,27148,27212,27266,27270,27306,27392,27795,28075,
28163,28192,28255,28261,28682,29061,29456,29602,29895,29976,
29994,30057,30064,30159,30363,30390,30463,30769,30789,30868,
30880,30974,30996,31142,31149,31184,31199,31692,31798,31843,
  449,  840, 1027, 1386, 1868, 2239, 2731, 2771, 2785, 2808,
 2903, 3342, 3949, 4075, 4080, 4237, 5245, 5379, 5395, 6057,
 6081, 6187, 6368, 6606, 7200, 7253, 7297, 7569, 7601, 7605,
 7642, 7787, 8480, 8503, 8644, 8700, 8869, 9114, 9237, 9449,
 9482, 9508, 9798,10267,10401,10645,11225,11342,11649,12019,
13095,13825,13831,13873,13897,14037,14128,14489,14533,14694,
14984,15068,15251,16259,16423,16766,17905,17930,19093,19359,
19836,19898,20393,20590,20687,20832,20990,21330,21613,21723,
21959,22205,22517,22567,22733,23059,23377,23868,24078,24111,
24277,24318,24501,24533,24630,25124,25160,25165,25194,25568,
25863,26133,26453,26584,26619,27745,27924,27952,28049,28228,
28390,28535,29042,29227,29311,30099,30436,31111,31688,  280,
  295,  416,  627, 1070, 1084, 1096, 1185, 1235, 1352, 1405,
 2073, 2127, 2446, 2782, 2933, 3388, 4578, 4666, 4740, 4825,
 4905, 5300, 5416, 5665, 5768, 6835, 6923, 8107, 8326, 8389,
 8598, 9074, 9103, 9614,10520,10663,10830,10866,10997,11160,
11528,11589,11677,12043,12141,12355,12454,12820,12926,12944,
13709,13786,14445,14698,14719,15004,15116,15413,15665,15904,
16057,16278,16629,17247,17687,17768,18093,18406,18578,18639,
18880,19638,20034,20256,20290,20463,20899,21020,21732,21782,
21908,22393,22403,22437,22477,22615,22713,23708,24792,25027,
25473,25796,26010,26985,26997,27343,27779,27790,27802,27877,
28182,28277,28362,28518,28669,28828,29223,29382,29577,29627,
29673,30309,30365,30394,30601,30660,31583,31807,31890, 1081,
 1120, 1191, 1777, 1992, 2173, 2416, 3046, 3111, 3804, 3945,
 4001, 4508, 5321, 5605, 5830, 6694, 7381, 7552, 7878, 8018,
 8184, 8223, 8276, 8768, 8780, 9035, 9437, 9514,10245,10312,
10573,11088,11435,11766,11789,11809,12510,13026,13472,13545,
13670,13984,14323,14456,14475,14929,15378,16037,16562,16844,
16868,17023,17306,17393,17400,17414,17889,18280,18325,18338,
19341,19483,20129,20547,20580,20823,21038,21326,21378,22042,
22921,23201,23642,24204,25043,25502,25654,25994,27039,27134,
27885,28125,28438,28769,29125,29238,29586,29634,29965,30032,
30829,31359,31397,31792,31813,31940,  106,  156,  195,  222,
  597, 1956, 2774, 2825, 3102, 4160, 4171, 4234, 4375, 4651,
 5723, 5903, 7400, 8752, 9634, 9840,10002,11006,12410,12776,
13004,13062,13320,14031,14155,14466,14835,14906,14980,15325,
15566,17350,18755,19414,19739,19902,20433,20809,21437,21741,
22582,22850,23165,24108,24716,24799,25061,25210,25560,26636,
27349,28290,28499,28910,29378,30568,31503,  275,  459, 1843,
 2569, 3228, 3285, 3937, 4082, 4255, 5391, 6148, 6747, 6840,
 7212, 7346, 7528, 7618, 8989, 9094, 9685,10102,10129,10333,
10393,11230,11947,12347,12530,12570,14040,16544,16811,18774,
18816,19018,19049,19262,19632,20000,21635,21754,21978,23296,
23467,23498,23958,24094,24702,25077,26462,26691,27000,29506,
29997,30624,32017,  326,  858, 1736, 2371, 2451, 2703, 3373,
 3586, 5112, 5248, 5923, 6256, 6461, 6487, 6578, 6738, 7363,
 8151,10298,10374,10423,10918,11592,11865,12312,13210,13766,
14815,14871,15071,15497,16153,16817,18210,18507,19108,20019,
20085,20183,21699,21792,22412,24961,25435,26034,26063,26171,
26779,27128,27620,28642,28723,28816,29090,29886,31931,  536,
 1541, 1885, 3334, 4262, 4372, 5612, 5650, 5788, 5974, 7639,
 8136, 9121, 9868,10024,11082,11145,12242,12324,12690,13673,
14709,14913,15086,15419,15890,16745,16975,17580,18702,18882,
19134,20101,22142,24406,24796,24898,25206,25764,26376,26531,
26926,27014,27550,27581,28044,28679,28744,29116,29303,29467,
29985,30528,31113,31320,  429,  484,  507,  588, 1446, 1462,
 1570, 1610, 1627, 1857, 1877, 1945, 2123, 2171, 2196, 2233,
 2550, 2595, 3114, 3186, 3216, 3350, 3425, 3508, 3904, 3961,
 4048, 4522, 4706, 4733, 4811, 5029, 5042, 5081, 5335, 6155,
 6402, 6474, 6657, 6742, 6855, 7164, 7269, 7301, 7439, 8093,
 8167, 8262, 8983, 9155, 9299, 9473, 9651, 9703, 9736, 9815,
 9881,10479,10624,10665,10768,10850,11216,11387,11440,11546,
11801,11844,12070,12221,12364,12446,12932,12983,13085,13301,
13399,13530,13775,13893,14125,14412,14438,14785,14948,15053,
15311,15485,15627,16102,16243,16283,16340,16465,16609,16751,
16762,17532,17630,17746,18256,18872,19046,19119,19346,19941,
20009,20372,20419,20505,20929,21260,21402,21744,21836,22089,
22339,22371,22502,22870,23127,23192,23494,23555,23565,23636,
23650,23655,23672,23780,24001,24157,24657,24680,24688,24921,
25409,25479,25611,26007,26025,26043,26175,26642,26791,26851,
27524,27656,27676,27941,28188,28654,28658,28806,29075,29590,
29620,29989,30343,30643,30784,30972,31035,31124,31438,31519,
31561,31951,   51,  355,  423,  635,  689,  709,  717,  876,
  916, 1016, 1089, 1168, 1176, 1424, 1429, 1538, 1557, 1635,
 1660, 1949, 1959, 2249, 2304, 2327, 2467, 2572, 3134, 3271,
 3355, 3492, 3595, 3795, 3918, 3951, 4125, 4246, 4296, 4382,
 4882, 4917, 5288, 5376, 5401, 5508, 5705, 5849, 5869, 5968,
 5999, 6006, 6050, 6075, 6304, 6617, 6685, 6795, 6816, 6823,
 6952, 7024, 7066, 7497, 7626, 7909, 8089, 8122, 8132, 8142,
 8158, 8374, 8400, 8586, 8690, 8764, 8938, 9068, 9179, 9243,
 9570, 9574,10251,10469,10903,10979,10985,11070,11525,11554,
11731,11814,11871,12329,12373,12785,12910,12923,12980,13153,
13193,13252,13271,13375,13505,13587,13716,13734,13942,14052,
14267,14357,14498,14553,14987,14992,15030,15110,15194,15319,
15615,15778,15784,16177,16200,16220,16389,16514,16548,16646,
16729,16865,16998,17097,17181,17407,17762,17829,17875,17886,
17922,17927,17993,18009,18086,18247,18295,18379,18514,18554,
18654,18670,18841,18918,19362,19392,19463,19703,19787,19850,
19986,20066,20073,20162,20269,20381,20443,20662,20680,20743,
20801,20863,20885,20962,20975,21027,21318,21428,21471,21556,
21640,21652,21772,21967,21971,22208,22383,22493,22853,23007,
23048,23188,23244,23312,23536,23542,23873,23943,24050,24228,
24283,24404,24483,24504,25005,25037,25302,25509,25674,25813,
25824,26121,26310,26317,26322,26351,26355,26420,26520,26575,
26911,26988,27035,27109,27201,27378,27787,27799,27809,27892,
27929,28301,28368,28522,28618,28633,28761,28831,28857,28928,
29157,29217,29245,29516,29533,29712,29873,29881,29954,29992,
30043,30114,30383,30552,30608,30855,31061,31208,31221,31268,
31324,31429,31454,31595,31893,31905,31919,   37,  255,  654,
  855,  866, 1197, 1303, 1357, 1699, 2015, 2116, 2559, 2610,
 2738, 2758, 2790, 2813, 3279, 3369, 3868, 3926, 4339, 4581,
 4653, 4678, 4747, 4998, 5067, 5086, 5328, 5653, 6027, 6071,
 6289, 6397, 6583, 6736, 6752, 6937, 7566, 7583, 7887, 8192,
 8296, 8449, 8543, 8848, 9274, 9328, 9445, 9534, 9553, 9987,
10257,10395,10498,10648,10718,10822,10859,10874,10950,11283,
11377,11587,11601,12012,12300,12727,12806,13143,13221,13323,
13553,13836,13867,14143,14281,14286,14448,14523,14750,14847,
15266,15476,15495,15642,15765,15983,16047,16064,16328,16526,
16733,16835,16980,17139,17154,17404,17422,17969,18139,18262,
18481,18527,18742,19116,19423,19934,19995,20049,20308,20423,
20984,21149,21384,21418,21434,21547,21660,21789,21861,21902,
22103,22560,22720,22897,23067,23144,23354,23823,23952,24100,
24247,24425,24459,24545,24832,25550,25766,25839,25874,26048,
26561,26716,26747,26757,27278,27345,27474,27516,27559,27578,
27792,27949,28495,29006,29141,29642,29677,29909,30227,30286,
30433,30492,30541,30649,30984,31353,31449,31534,31538,31770,
31804,31874,   16,   85,  318,  386,  407,  871,  990, 1009,
 1171, 1214, 1439, 1482, 1644, 1937, 1972, 2011, 2066, 2228,
 2313, 2630, 2652, 2720, 3108, 3129, 3266, 3359, 3504, 3717,
 4039, 4066, 4122, 4326, 4736, 4862, 4922, 5010, 5104, 5340,
 5406, 5573, 5620, 6308, 6422, 6634, 6819, 6862, 6918, 7038,
 7174, 7227, 7352, 7428, 7442, 7698, 7741, 7960, 8320, 8495,
 8529, 8696, 8873, 9127, 9487, 9708, 9756, 9853, 9862,10097,
10309,10914,11256,11371,11614,11735,11849,12134,12148,12290,
12579,12696,12987,12995,13073,13091,13409,13596,13921,14431,
14537,14544,14945,15058,15235,15401,15467,15706,15776,15988,
15995,16598,16670,16797,17018,17169,17292,17301,17336,17610,
17774,18195,18266,18370,18445,18464,18521,19026,19059,19086,
19203,19531,19677,19707,19866,20031,20297,20560,20821,21005,
21074,21083,21161,21336,21372,21925,22001,22213,22305,22509,
22613,22617,22623,22674,22862,22928,23204,23340,23700,23745,
23850,24306,24389,24432,24673,24698,24780,24853,24993,25074,
25292,25554,25562,25885,26194,26249,26277,26405,26424,27029,
27113,27430,27506,27521,27545,27592,27651,27754,27864,27916,
27957,28435,28512,28542,28945,29249,29319,29345,29401,29424,
29625,29892,29971,30051,30371,30396,31108,31794,31817,31829,
31938,31973,  203,  246,  474,  720,  793, 1122, 1566, 1648,
 1807, 2154, 2465, 2627, 2713, 2777, 2987, 3116, 3479, 4178,
 4304, 4440, 4551, 4813, 4961, 5141, 5454, 5892, 6017, 7407,
 7436, 7453, 7652, 7881, 7964, 8306, 8409, 8524, 8750, 8754,
 9234, 9353, 9730, 9825,10038,10330,10513,10602,10807,11030,
11467,11770,11823,11934,11989,12038,12336,12582,12677,13077,
13121,13557,13720,13882,14069,14167,14234,14276,14368,14519,
14789,15142,15240,15462,15684,15885,16131,16387,17376,17516,
17625,17727,18736,18945,18956,19055,19207,19266,19540,19846,
19983,20080,20124,20359,20494,20870,21918,22009,22087,22129,
22197,22354,22377,22666,23235,23270,23332,23581,23711,24075,
24331,24409,25116,25252,25277,25437,25786,25861,26775,26903,
27703,27873,28288,28295,28580,28880,28907,29285,29490,29498,
29531,29877,30549,30610,30940,31043,31056,31118,31170,31371,
31375,31648,   44,  146,  197,  260,  658,  883, 1227, 1241,
 1283, 1403, 1830, 2044, 2325, 3511, 3916, 3970, 3994, 4333,
 4349, 4696, 5033, 5591, 6195, 6689, 6914, 6963, 7064, 7168,
 7530, 7907, 8015, 8199, 8283, 8675, 8737, 9152, 9283, 9380,
10477,11008,11241,11339,11640,11675,11782,11984,12193,12260,
12955,12991,13087,14096,14145,14252,15182,16010,16164,16292,
16557,16823,16950,17117,17188,17487,17505,17702,17827,17991,
18668,19634,19690,20246,21172,21229,21247,21667,22040,22598,
22627,23447,23502,23956,24514,24613,25108,25227,26460,26504,
26736,26915,26958,27033,27384,27556,28252,28352,28571,29133,
29926,30284,30585,30878,30962,31210,31225,31605,  265,  419,
  482,  687, 1100, 1256, 1371, 1493, 1582, 1662, 1811, 1954,
 2756, 2939, 2972, 3273, 3281, 3568, 3686, 4655, 4996, 5088,
 5098, 5438, 5510, 5534, 6168, 6200, 6457, 6548, 6980, 7018,
 7307, 7393, 7615, 8402, 9471, 9950,10071,10439,11056,11384,
11556,11908,12595,12626,12630,12832,12916,13295,13310,13332,
14092,14539,14895,15709,15768,15836,15849,16433,16774,17690,
18192,18291,18552,19297,19536,19701,19806,19815,20310,20319,
20484,20571,20653,21017,21165,21316,21370,21539,21650,21770,
23285,23945,23967,24119,24273,24294,25126,25356,25981,26215,
26330,27486,28082,28328,28360,28429,28526,28755,28820,28862,
30373,30726,30817,31514,31834,   19,  346,  625, 1354, 1552,
 1849, 2355, 2637, 3212, 3361, 3499, 3575, 3741, 3814, 3862,
 4723, 5348, 5389, 6287, 6346, 6640, 6683, 6728, 7013, 7513,
 7796, 7938, 8612, 8698, 8773, 8910, 9063, 9526, 9696, 9714,
 9836,10323,10944,11169,11536,11764,11812,12331,12345,12375,
12971,13212,13373,13780,14151,14319,14414,15322,15471,15560,
15805,15827,17134,17234,17354,17539,18144,18327,18682,19039,
19968,20185,21658,21719,22286,22312,22766,22938,22987,23238,
23293,23573,23629,24619,24644,24919,25203,25289,25583,25816,
25926,25933,26577,27145,27280,27322,27402,28190,28648,29040,
29086,29145,29458,29728,30029,30213,30399,30807,31356,31422,
31444,31493,31521,31755,31976,  351,  521,  532,  617,  869,
  981, 1265, 1309, 1794, 1965, 2749, 2807, 2885, 3028, 3151,
 3398, 4035, 4281, 4675, 4701, 4833, 4903, 5854, 5888, 5894,
 5958, 5992, 6367, 6803, 7006, 7148, 7562, 7984, 9116, 9357,
 9364, 9370, 9991,10012,10019,10125,10418,10454,10653,10869,
11382,11648,11751,12239,13284,13378,13642,13707,13793,13842,
14020,14107,14229,14365,14484,14501,14528,15012,15213,16066,
16351,16400,16710,16807,16853,17396,17877,18053,18399,19083,
19285,19526,19871,19938,20027,20596,20691,20839,20967,21008,
21152,21206,21954,22571,22704,22780,22901,23010,23071,23242,
23317,23364,24346,24393,24445,24646,24664,25177,25451,25697,
25771,25955,26168,26591,26624,26800,27457,27882,28803,28875,
29003,29783,29808,30024,30464,30572,30627,30633,30639,31334,
31350,31903,  513,  550,  585,  669, 1153, 1222, 1398, 2265,
 2411, 2710, 3040, 3573, 3659, 3982, 4468, 4608, 4637, 5240,
 5255, 5680, 6033, 6100, 6564, 6605, 7327, 7767, 7973, 8067,
 8077, 8837, 8904, 9046, 9143, 9648,10084,10109,10198,10342,
10407,10782,10887,11025,11595,11666,11712,12114,12550,12685,
12767,12781,13390,13754,14632,14697,14853,15064,15410,15761,
16270,16279,16446,16601,16767,17105,17369,17387,18125,18173,
18495,18583,18731,18820,18913,19021,19042,19096,19164,19226,
19313,19323,19629,20046,21133,21257,21521,21798,22032,22139,
22273,22532,22540,22551,22775,22891,22944,23358,23443,23663,
23913,24437,24595,24718,25069,25383,25537,25779,26018,26261,
26306,26732,26786,26812,26821,27215,27357,27466,27613,27953,
28101,28155,28472,28696,28726,28932,29280,29405,29767,29822,
30291,30424,30455,30545,30797,31078,31627,31690,31966,31993,
   56,  219,  835, 2005, 2070, 3009, 3541, 3607, 4095, 4760,
 4877, 4936, 5627, 5686, 6145, 6378, 6428, 6959, 7313, 7608,
 7825, 7835, 7979, 8096, 8117, 8277, 8533, 8783, 8954, 9605,
10338,10811,10906,11233,11486,13276,13579,13696,14017,14049,
14407,14804,14877,15097,15122,15744,15748,15991,16032,16456,
16936,17665,17915,17988,19593,19685,20475,20554,20811,20833,
20994,21238,21250,21268,21750,22905,22961,23183,23452,23887,
24357,24417,24964,25213,26183,26325,26933,27298,27732,28047,
29418,29773,30581,31187,31599,31810,  309,  331,  888, 1861,
 1872, 2076, 2335, 2508, 2578, 2734, 3429, 3528, 3680, 3752,
 4500, 4926, 5424, 5577, 7046, 7075, 7376, 7510, 8163, 8894,
 9249, 9483, 9611,10089,10271,10565,11269,11541,11829,11838,
11864,11970,12201,12295,12553,12750,13497,13677,13682,13740,
14811,15247,15622,15964,15974,16141,16237,16725,16780,17364,
17440,17524,17957,18356,18643,18771,18790,18887,19140,20193,
20649,21086,21120,21602,21766,22014,22024,22170,23684,23769,
24238,24441,24668,24735,25056,25104,25364,25462,25567,25615,
26445,27091,27427,27603,27693,27938,28229,28284,28835,28853,
29062,29095,29659,29719,29894,30761,31026,31067,31192,31651,
  288, 1216, 1555, 1786, 1803, 2221, 2306, 2402, 3003, 3100,
 3148, 3214, 3613, 3709, 3747, 4239, 4455, 4765, 5018, 5058,
 5420, 5449, 5522, 5859, 5898, 5914, 6110, 6466, 7030, 7547,
 7794, 8038, 8381, 8536, 8797, 8878, 8885, 8933, 9624, 9690,
 9876,10101,10825,11804,11951,12443,12890,13057,13347,13455,
13573,13725,14118,14179,14707,15008,15227,15498,15510,16052,
16172,16212,16656,16860,17600,17961,18014,18121,18441,18468,
18677,18897,19607,19694,19859,19928,20233,20602,20786,22297,
22977,23460,23617,23739,24061,24299,24326,25162,25660,25664,
25801,25836,26272,27158,27178,27462,27483,27528,27583,28123,
28729,28749,29455,29462,29694,29828,30145,30661,30752,30982,
31722,   78,  142,  299,  401,  609,  631,  894,  965, 1095,
 1115, 1695, 1798, 1867, 1957, 2084, 2205, 2217, 2240, 2899,
 2918, 3208, 3654, 3701, 3786, 3886, 4197, 4515, 4615, 4728,
 4752, 4910, 5121, 5204, 5268, 5463, 5777, 6103, 6177, 6211,
 6247, 6259, 6748, 6780, 6811, 6950, 7070, 7537, 7559, 7638,
 7762, 7898, 8011, 8075, 8360, 8365, 8405, 8455, 8608, 8707,
 8845, 9025, 9052, 9140, 9296, 9350, 9428, 9464, 9558, 9724,
 9832, 9929,10056,10220,10400,10434,10612,10771,11072,11299,
11431,11437,11582,11661,11918,12025,12129,12348,12379,12450,
12681,12813,12975,13176,13480,13510,13518,13656,14158,14219,
14294,14451,14465,14609,14740,14839,14920,15102,15206,15264,
15371,15444,15490,15943,16000,16014,16336,16569,16633,16803,
16933,17010,17029,17090,17431,17612,17671,17706,17757,17781,
17787,18062,18306,18374,18402,18501,18573,18906,19052,19158,
19326,19358,19429,19597,19602,19681,19823,19844,19918,20023,
20436,20664,20850,20949,21079,21262,21405,21665,21706,21777,
21827,21891,22152,22195,22333,22484,22603,22755,22801,22811,
23014,23276,23517,23540,23649,23717,23816,23833,23918,24066,
24470,25009,25090,25188,25220,25398,25447,25620,25841,25870,
25880,25949,26013,26039,26153,26335,26448,26631,26660,26755,
26778,26889,27010,27414,27572,27860,27888,27903,27914,27981,
28307,28318,28417,28530,28765,28842,29030,29103,29189,29211,
29322,29431,29541,29777,29792,30169,30255,30346,30669,30676,
30680,30812,31152,31240,31315,31588,31718,31934,31943,31960,
  349,  431,  769,  920, 1039, 1055, 2034, 2139, 2583, 2696,
 2846, 2944, 3025, 3181, 3666, 3730, 4074, 4106, 4159, 4252,
 4364, 4475, 4835, 5046, 5467, 5676, 5728, 6417, 6483, 6601,
 6773, 7119, 7522, 7814, 8294, 8577, 9315, 9953, 9985,10076,
10115,10431,10584,10641,10675,10952,10990,11285,12171,12234,
12417,12547,13012,13606,13736,13977,14130,14136,14304,14594,
14682,14829,14845,15382,15832,16235,16275,16281,16535,17120,
17342,17543,17906,18076,18516,19030,19111,19645,19910,20197,
20277,20453,20828,21067,21551,21628,21724,22429,22566,22688,
22914,22932,23473,23675,24124,24335,24577,24603,24712,24849,
24884,25195,26128,26366,26580,26606,27232,27992,28195,28461,
28615,28868,28899,29259,29292,29524,29799,29813,29855,30268,
30421,30453,30466,30596,30690,30823,30924,31553,31732,31789,
31954,  605,  740,  841,  874, 1106, 1275, 1396, 1486, 1741,
 2166, 2376, 2591, 2854, 2995, 3314, 3393, 3737, 3989, 4260,
 4428, 5186, 5528, 5609, 5978, 6399, 6444, 6533, 6653, 7179,
 7191, 7342, 7991, 8464, 8521, 9132, 9266, 9551, 9850, 9997,
10224,10465,10491,10710,11151,11986,12119,12515,13363,13640,
13664,14247,14857,15026,15525,15652,15863,16266,16285,16714,
16831,17113,17552,18081,18158,18435,18587,18664,18751,19125,
19660,19914,19974,20225,20356,20396,20709,21519,21571,21608,
21752,22501,23056,24072,24091,24128,24203,25114,25699,25751,
26161,26218,26234,26612,26760,27019,27168,27492,27919,28089,
28166,28446,28930,29108,29396,29820,30109,30150,30189,30281,
30635,30934,31633,  316,  397,  583, 1560, 1926, 1960, 1981,
 2178, 2189, 2212, 2247, 2513, 3482, 3911, 3973, 4330, 4341,
 4436, 4481, 4849, 5305, 5456, 5711, 5856, 5962, 7052, 7490,
 7516, 7737, 7777, 7809, 8918, 8969, 8997,10052,10093,10443,
10791,11037,11167,11444,11593,11722,12499,12525,12603,12633,
12733,12765,12965,12969,13584,14333,14457,15000,15089,15117,
15175,15391,15595,16482,16708,17147,17179,17232,17584,18197,
18214,18511,18698,18760,19150,19546,19698,20212,20373,20441,
20624,20669,20702,20766,20867,21349,21983,22226,22246,22734,
22908,22969,23176,23530,23569,23621,23829,24040,24654,24798,
24827,24974,25047,25065,25407,25503,25773,26535,26893,26935,
27075,27174,27523,27564,27986,28157,28439,28817,30194,30409,
30413,30746,30956,31031,31232,31680,31897,  150,  161,  284,
  454,  516, 1003, 1271, 1379, 2415, 2964, 3103, 3234, 3305,
 3661, 3964, 4184, 4576, 4879, 5061, 5284, 5409, 5821, 5925,
 6063, 6232, 6382, 7057, 7125, 7207, 7458, 7731, 7913, 8471,
 8569, 8897, 9258, 9629, 9920, 9938,10104,10504,10701,10836,
10966,11045,11101,11527,11565,11655,11799,12051,12495,13027,
13098,13129,13443,13853,14064,14290,14507,14757,14862,15132,
15483,15504,15620,15646,15678,16374,16584,16595,16753,16769,
16992,17512,17739,18101,18258,18343,18635,18938,19292,19330,
19433,19556,19864,20305,20412,20805,20937,21618,21703,21805,
21932,22029,22554,22659,23065,23859,23959,24163,24286,24448,
24880,24914,25273,25442,25602,25804,25876,26011,26051,26075,
26304,26381,26706,26809,27312,27398,27481,27611,27687,28694,
28710,28963,29084,29327,29824,30245,30721,30947,30968,31022,
31437,31695,31738,32007,   29,   49,  460,  468,  488,  499,
  638,  786,  808,  971, 1007, 1119, 1262, 1316, 1376, 1431,
 1497, 1633, 1832, 2050, 2230, 2255, 2394, 2530, 2539, 2644,
 2743, 2894, 3001, 3012, 3032, 3143, 3323, 3366, 3602, 3651,
 3907, 4143, 4311, 4471, 4571, 4771, 4810, 4941, 5021, 5106,
 5200, 5222, 5504, 5670, 5955, 5995, 6029, 6036, 6077, 6179,
 6193, 6282, 6433, 6542, 6551, 6647, 6679, 6785, 7137, 7234,
 7405, 7555, 7581, 7686, 7803, 7948, 8081, 8112, 8124, 8226,
 8540, 8603, 8758, 8863, 8914, 9170, 9176, 9223, 9241, 9312,
 9321, 9376, 9478, 9547, 9677, 9843,10186,10192,10524,10594,
10820,11196,11301,11379,11617,11651,11744,11826,11982,12028,
12124,12212,12253,12395,12563,12612,12675,13002,13124,13260,
13300,13590,13693,13844,13962,14115,14296,14363,14471,14887,
14902,15017,15186,15232,15330,15363,15395,15578,15609,15661,
15686,15699,15755,16148,16346,16361,16380,16418,16438,16452,
16704,16784,16909,16983,17049,17107,17192,17218,17236,17476,
17519,17607,17721,17747,17809,17866,17955,18111,18264,18354,
18784,19057,19072,19280,19426,19465,19586,19641,19879,20089,
20171,20177,20267,20314,20639,20945,20955,20982,21255,21273,
21375,21391,21412,21624,21920,22132,22165,22240,22289,22319,
22396,22592,22727,22883,23103,23158,23194,23288,23329,23334,
23342,23371,23589,23853,23894,23940,24221,24309,24582,24592,
24733,24999,25016,25224,25455,25478,25809,25828,25940,26059,
26340,26362,26430,26500,26507,26730,26833,26962,26994,27342,
27355,27660,27847,28133,28143,28257,28291,28344,28363,28467,
28489,28937,29036,29051,29115,29150,29186,29390,29505,29796,
30041,30105,30116,30199,30237,30735,30951,31185,31364,31420,
31766,31777,31991, 1351, 1421, 1728, 2081, 2429, 2544, 2600,
 4062, 4268, 4318, 4610, 4886, 4908, 5441, 6805, 7821, 9084,
 9263, 9956,10266,10278,10474,10617,10692,10720,10876,11020,
11855,11862,12167,12480,12760,13113,13133,13536,14244,14428,
14793,15259,15435,17007,17058,17508,17819,19609,19923,20132,
20655,20776,21264,21846,21928,22157,22178,23062,23308,23323,
23346,23890,24215,25434,25585,25680,26650,26739,27046,27142,
27196,27296,27900,28058,28635,28774,28883,29443,29645,29666,
29899,29906,30060,31265,31410,31591,  436,  441,  519, 1234,
 1437, 1599, 2883, 2932, 2978, 3139, 3941, 4041, 4565, 4682,
 5015, 5052, 5345, 5717, 5789, 6731, 6857, 7104, 7527, 7828,
 7944, 7952, 8781, 9304, 9529, 9540,10328,10588,10947,11273,
11754,12067,12159,12606,13063,13190,13522,13599,13934,14934,
15605,16970,17751,18541,18658,18871,18910,18916,19155,19211,
19337,19361,20480,20963,20976,21000,21050,21477,21588,22408,
22470,22668,23455,23464,23584,23863,24206,24677,24892,25732,
26207,27498,28119,28426,29111,29335,30071,30366,30682,30858,
31389,31999,    7,   22,  450, 1088, 1252, 1459, 2192, 3096,
 4168, 4625, 5037, 5130, 5301, 5852, 6165, 6203, 6217, 6502,
 6769, 7162, 7641, 7791, 8650, 8852, 9059,10291,11393,11626,
12531,13209,13370,13839,13955,14614,15666,15793,16414,17208,
18283,18368,18651,18684,19397,19669,19692,20843,21334,21594,
22336,23566,24303,24622,24906,25121,25366,26337,26657,26980,
27190,27744,28139,28864,29219,29487,29613,29704,30224,30730,
30739,30986,31250,  493,  795, 1416, 1951, 2650, 3533, 3615,
 3880, 5146, 7225, 7386, 7594, 7917, 8324, 8554,11533,12190,
12623,13267,13669,13896,14022,16738,17446,17759,18831,19076,
21914,22738,22762,22803,23490,23742,23771,24803,24842,24901,
25403,25547,25781,26177,26709,27219,27405,29207,29235,30270,
30532,31532,31644,  804, 1018, 1103, 2361, 2441, 3183, 4709,
 4932, 5192, 5426, 5481, 6300, 6353, 7133, 7503, 8393, 9079,
 9229, 9452,10063,11206,11549,11604,11610,12199,12399,12694,
12704,14354,14562,14869,15464,15896,16215,17156,17225,17502,
17790,19990,20062,20195,20209,22234,22749,24193,24199,27079,
27182,27519,27587,28050,28698,29481,30111,30804,30976,31013,
  272, 1051, 2318, 2425, 3284, 3519, 3705, 3984, 4114, 5875,
 6599, 7349, 7413, 7647, 7744, 7902, 7998, 8228, 8452, 9300,
 9518, 9666, 9701,10724,11096,11155,11451,11958,13100,13174,
13879,14083,14883,15084,15300,15630,15758,15883,16080,17437,
18167,18564,18762,18902,19320,19435,19712,20229,20353,22092,
22522,22683,23906,24070,24280,24887,25153,25377,26264,26763,
26781,28035,28322,28370,28470,28927,29022,29464,29710,30258,
30845,31331,31812,31876,  313,  336,  783, 1045, 1604, 2131,
 2571, 3018, 3160, 3578, 3954, 4057, 4189, 4421, 4649, 5084,
 5500, 6114, 6415, 6468, 6762, 7432, 7589, 8215, 8666, 9149,
 9617,10021,10232,10487,10606,10813,11089,11964,13022,13531,
13758,14062,14270,15519,16190,16372,16444,16555,16603,17688,
17767,18524,18969,20108,20366,21232,21632,21994,22327,22772,
23383,23626,24058,24146,24488,25234,25606,27101,27310,27769,
27807,27921,28355,29973,30768,30965,31129,31368,    0,    9,
   40,   99,  111,  113,  252,  279,  404,  525,  535,  619,
  647,  671,  733,  737,  791,  934,  963, 1011, 1077, 1218,
 1259, 1373, 1474, 1479, 1540, 1576, 1676, 1683, 1737, 1784,
 1834, 1882, 1942, 1969, 1993, 2008, 2032, 2176, 2181, 2244,
 2271, 2310, 2350, 2363, 2406, 2523, 2525, 2532, 2534, 2576,
 2646, 2799, 2831, 2852, 2887, 3007, 3083, 3165, 3190, 3298,
 3310, 3338, 3346, 3364, 3413, 3485, 3523, 3597, 3609, 3728,
 3755, 3757, 3775, 3784, 3811, 3958, 4033, 4052, 4093, 4116,
 4293, 4368, 4449, 4465, 4493, 4529, 4539, 4546, 4623, 4639,
 4689, 4754, 4843, 4857, 4950, 4959, 5044, 5158, 5273, 5282,
 5459, 5471, 5486, 5539, 5614, 5624, 5636, 5644, 5689, 5698,
 5774, 5779, 5793, 5833, 5905, 5990, 6093, 6245, 6261, 6267,
 6362, 6389, 6430, 6440, 6463, 6477, 6489, 6531, 6567, 6597,
 6643, 6750, 6764, 6778, 6829, 6842, 6866, 6930, 6974, 6992,
 7040, 7072, 7077, 7108, 7128, 7181, 7187, 7237, 7246, 7332,
 7409, 7501, 7587, 7684, 7895, 8004, 8029, 8065, 8119, 8134,
 8150, 8154, 8181, 8187, 8292, 8301, 8339, 8367, 8397, 8461,
 8466, 8502, 8510, 8538, 8547, 8549, 8683, 8691, 8710, 8719,
 8744, 8756, 8775, 8785, 8907, 8980, 8992, 8994, 9154, 9221,
 9231, 9410, 9443, 9468, 9501, 9524, 9609, 9631, 9673, 9704,
 9753, 9874, 9890, 9926, 9942,10010,10046,10095,10206,10229,
10259,10370,10387,10495,10506,10517,10568,10574,10659,10703,
10789,10801,10842,10847,10856,10862,10956,10988,10996,11163,
11209,11244,11276,11291,11331,11352,11364,11368,11406,11415,
11428,11453,11488,11567,11633,11685,11911,11920,11939,11949,
11960,12033,12065,12106,12117,12185,12244,12407,12423,12429,
12507,12519,12618,12714,12736,12747,12752,12824,12949,13105,
13111,13116,13145,13150,13185,13258,13351,13355,13359,13395,
13526,13576,13658,13684,13756,13796,13894,13983,14046,14161,
14225,14232,14302,14313,14325,14374,14404,14442,14476,14626,
14638,14645,14675,14705,14725,14733,14797,14841,14850,14881,
14922,14937,15091,15100,15135,15215,15296,15380,15387,15441,
15446,15479,15500,15590,15825,15903,15907,15966,16002,16006,
16036,16060,16070,16085,16146,16174,16320,16325,16359,16395,
16449,16475,16613,16623,16663,16721,16736,16756,16810,16845,
16923,16957,16973,17012,17021,17094,17111,17130,17227,17344,
17444,17482,17490,17521,17526,17604,17677,17741,17753,17813,
17824,17892,17963,17971,17998,18049,18064,18096,18117,18129,
18169,18300,18489,18503,18530,18585,18589,18647,18661,18690,
18729,18739,18748,18768,18788,18824,18858,19123,19200,19220,
19228,19239,19259,19310,19408,19444,19460,19475,19480,19491,
19496,19544,19612,19649,19664,19716,19744,19912,19976,20012,
20068,20092,20236,20275,20407,20414,20434,20451,20514,20562,
20577,20618,20622,20631,20683,20688,20695,20698,20780,20852,
20933,20953,20987,21011,21052,21139,21189,21223,21282,21323,
21345,21362,21387,21407,21544,21637,21642,21697,21755,21759,
21807,21814,21854,21893,21905,22100,22115,22172,22181,22228,
22242,22314,22323,22352,22416,22423,22472,22538,22573,22577,
22585,22590,22657,22797,22877,22885,22889,22894,22918,22935,
22981,23091,23170,23186,23198,23233,23440,23510,23560,23586,
23690,23705,23736,23837,23845,23921,23948,23974,24017,24034,
24063,24077,24156,24212,24219,24276,24288,24324,24530,24534,
24683,24685,24690,24777,24810,24816,24844,24908,25013,25026,
25050,25054,25087,25169,25230,25350,25372,25385,25430,25496,
25498,25592,25631,25638,25652,25657,25662,25667,25736,25864,
25894,25935,25945,25999,26083,26151,26222,26348,26372,26379,
26390,26393,26402,26417,26435,26526,26551,26602,26644,26654,
26704,26749,26839,26891,26906,26944,27007,27017,27131,27160,
27229,27286,27303,27362,27416,27509,27531,27568,27601,27735,
27740,27767,27772,27810,27814,27906,27944,27955,27967,27977,
28054,28063,28067,28264,28268,28305,28340,28376,28382,28432,
28453,28464,28550,28702,28751,28758,28812,28872,28877,29025,
29078,29097,29105,29184,29192,29201,29224,29247,29447,29500,
29522,29539,29649,29670,29686,29721,29762,29764,29787,29789,
29844,29846,29853,29967,29995,30009,30027,30082,30156,30183,
30191,30210,30247,30249,30266,30279,30294,30368,30480,30495,
30590,30692,30780,30810,30849,31007,31053,31069,31134,31150,
31181,31202,31255,31298,31307,31336,31385,31430,31505,31510,
31551,31569,31609,31639,31693,31709,31715,31736,31845,31941,
31988,32011,32030,   45,   76,  229,  399,  485,  510,  665,
  693,  729,  829,  848,  969,  974, 1013, 1108, 1192, 1249,
 1289, 1313, 1367, 1392, 1466, 1477, 1563, 1574, 1597, 1620,
 1688, 1771, 1817, 1844, 2001, 2039, 2047, 2086, 2124, 2209,
 2252, 2427, 2450, 2587, 2732, 2765, 2914, 2946, 3121, 3177,
 3229, 3265, 3391, 3409, 3663, 3668, 3692, 3722, 3740, 3780,
 3875, 3890, 3894, 3936, 4195, 4250, 4366, 4477, 4505, 4511,
 4520, 4535, 4672, 4745, 4822, 4839, 4873, 4918, 5134, 5197,
 5318, 5383, 5397, 5402, 5434, 5502, 5606, 5638, 5724, 5760,
 5810, 5823, 6042, 6158, 6253, 6343, 6436, 6470, 6562, 6677,
 6686, 6985, 7000, 7112, 7117, 7131, 7199, 7252, 7337, 7351,
 7358, 7421, 7724, 7816, 7977, 8084, 8159, 8333, 8422, 8457,
 8479, 8506, 8513, 8579, 8668, 8767, 8834, 8926, 8944, 9093,
 9168, 9269, 9372, 9446, 9567, 9613, 9626, 9686, 9722, 9814,
 9838, 9857, 9911, 9935, 9940,10026,10181,10254,10405,10427,
10570,10690,10773,11022,11062,11204,11329,11411,11458,11480,
11584,11852,11944,11954,12004,12023,12062,12100,12164,12206,
12305,12352,12383,12419,12578,12821,12829,12897,12936,12947,
13009,13029,13069,13081,13094,13170,13388,13460,13506,13520,
13540,13560,13634,13760,13913,13937,13965,14056,14124,14165,
14227,14282,14339,14480,14493,14522,14552,14652,14833,14855,
15005,15019,15076,15225,15230,15361,15448,15557,15820,15850,
15872,15970,15978,16004,16034,16056,16092,16217,16241,16268,
16330,16424,16560,16759,16841,16851,16864,16904,16979,17122,
17198,17319,17380,17385,17500,17667,17725,17733,17815,17901,
17912,17942,17984,17996,18059,18131,18279,18333,18376,18404,
18433,18438,18452,18462,18575,18701,18928,18951,19113,19247,
19257,19294,19469,19549,19617,19708,19781,20025,20040,20096,
20112,20207,20263,20376,20382,20444,20487,20557,20585,20610,
20758,20896,20900,21028,21060,21122,21128,21182,21228,21234,
21277,21355,21367,21399,21582,21647,21655,21957,21992,22010,
22026,22108,22119,22209,22368,22480,22548,22681,22711,22759,
22807,23113,23138,23151,23245,23265,23278,23313,23326,23446,
23486,23686,23723,23749,23811,23814,23861,23911,23923,23929,
24159,24223,24235,24271,24508,24739,24770,24789,24823,24831,
25092,25119,25183,25222,25293,25348,25368,25457,25490,25573,
25596,25746,25833,25952,25966,26119,26165,26237,26246,26259,
26270,26397,26598,26702,26806,26829,26881,26886,26919,26927,
26964,27123,27139,27147,27184,27369,27396,27512,27539,27719,
27853,27983,28033,28040,28078,28244,28300,28475,28525,28577,
28678,28700,28732,28823,28939,28947,28956,29049,29080,29231,
29265,29317,29475,29599,29606,29769,30048,30067,30080,30107,
30253,30277,30356,30387,30411,30426,30594,30599,30678,30743,
30756,30928,31029,31074,31136,31242,31296,31303,31382,31404,
31616,31748,31771,31824,31925,31978,32034,  130,  217,  226,
  250,  714,  833, 1470, 2328, 2462, 2499, 2581, 2611, 2822,
 3276, 4270, 4357, 5073, 5116, 5218, 5331, 5682, 5863, 6624,
 7189, 7195, 7557, 8033, 8497, 8601, 8681, 9113, 9287, 9766,
 9885,10210,10673,10769,10873,10898,11104,11929,12719,12793,
12927,13000,13447,13469,13487,13727,13788,13910,14072,14409,
14468,16072,16185,16397,16869,17047,17403,17564,18671,19078,
19091,19509,19714,19733,19830,20065,20466,21202,21343,21746,
21769,22043,22985,23167,23856,24231,24456,24627,24866,24896,
25494,26331,26442,26721,27425,28086,28181,28287,28546,29638,
30652,30673,30723,30750,31024,31537,31720,32020,  699,  988,
 1036, 1450, 1500, 1601, 1681, 1702, 2623, 2954, 2980, 3494,
 3649, 3845, 3898, 4098, 4131, 4617, 5123, 5895, 6010, 6039,
 6189, 6547, 7258, 7789, 8179, 9247, 9344, 9931, 9948,10662,
11192,11224,11976,12401,12535,12683,13474,14120,14821,15315,
15425,15477,15568,15753,15986,16151,16348,16628,16716,17159,
17242,17406,17590,17618,17864,18877,18977,19504,21057,21216,
21830,21945,22222,22277,22295,22564,22719,22817,22887,23189,
23355,23692,24141,25052,25931,26195,26229,26374,27097,27284,
27994,28312,28515,28805,29310,29387,29469,29676,30148,30771,
31196,31366,31586,31687, 1551, 1636, 1780, 2337, 2795, 3030,
 3153, 3544, 3956, 3962, 4434, 4525, 5542, 6005, 6173, 6412,
 6529, 6595, 7017, 7241, 7424, 7507, 7535, 7764, 7770, 7880,
 8290, 8415, 8596, 8664, 9032, 9100, 9147,10144,10222,10283,
10429,10440,10561,10699,11142,11251,11346,11664,11806,11817,
12058,12368,12511,12608,13265,13500,13748,14727,14748,14799,
14928,14977,15201,15400,15453,15817,16354,17092,17182,17679,
17743,18347,18460,18773,19513,19535,19604,19982,20239,20316,
20544,20579,21047,21377,21976,21996,22341,22690,22707,23060,
23156,23261,23315,23819,24259,24536,24588,24871,24903,25197,
25314,25459,25645,25923,26049,27683,27726,27973,28721,29012,
29018,29070,29437,29618,29725,29884,30113,30161,30474,30570,
30607,31064,31548,31756,   13,   64,   91,   97,  109,  136,
  152,  165,  433,  470,  504,  719,  735,  814,  900,  967,
  993, 1029, 1264, 1400, 1435, 1730, 1822, 1940, 2121, 2168,
 2468, 2562, 2729, 2759, 2890, 2896, 2907, 2976, 3034, 3119,
 3133, 3185, 3316, 3348, 3396, 3427, 3480, 3580, 3943, 4045,
 4170, 4193, 4569, 4644, 4677, 4827, 4891, 4898, 4947, 5093,
 5260, 5394, 5407, 5571, 5579, 5634, 5674, 5840, 5900, 5912,
 6227, 6263, 6374, 6540, 6641, 6691, 6813, 6852, 6863, 6946,
 6967, 7203, 7254, 7411, 7456, 7565, 7692, 7733, 7801, 7946,
 7975, 8002, 8126, 8545, 8561, 8610, 8677, 8971, 9279, 9506,
 9516, 9520, 9812, 9848, 9872, 9993, 9999,10111,10310,10614,
10651,10688,10777,10784,10986,10992,11027,11076,11202,11211,
11228,11669,11740,12039,12108,12222,12517,12586,12596,12645,
12827,12934,12962,13060,13410,13462,13482,13550,13592,13762,
13837,13851,13904,14077,14140,14242,14258,14616,14679,14702,
14751,14795,14879,14916,15051,15082,15220,15582,15648,15674,
15790,16021,16209,16289,16384,16469,16621,16719,16771,16847,
16994,17088,17109,17137,17174,17220,17223,17545,17887,17910,
17921,17968,17986,18090,18137,18201,18205,18341,18364,18833,
18889,18936,18961,19013,19032,19060,19172,19236,19482,19528,
19595,19647,19817,19998,20058,20077,20280,20311,20402,20485,
20549,20598,20685,20830,21015,21136,21225,21385,21530,21542,
21825,21856,21862,21934,22198,22474,22629,22854,22940,22957,
23107,23117,23181,23387,23466,23482,23562,23633,23715,23938,
24161,24251,24313,24528,24550,24670,24785,24851,24889,24916,
24986,25159,25167,25417,25677,25756,25888,25986,26041,26155,
26213,26257,26266,26377,26395,26519,26533,26549,26604,26746,
26819,26959,27002,27043,27088,27268,27275,27308,27585,27898,
27935,28193,28266,28365,28430,28501,28675,28704,28713,28800,
28837,29113,29237,29449,29706,29863,30094,30171,30204,30226,
30344,30350,30370,30449,30621,30775,31018,31044,31166,31338,
31604,31646,31707,31764,31803,32013,  497,  579,  850, 1188,
 1194, 1865, 2549, 2613, 2657, 3175, 3270, 3487, 3521, 3599,
 4224, 4278, 4491, 4544, 5148, 5429, 5657, 6082, 6112, 6213,
 6766, 7334, 8337, 8556, 8806, 9159, 9227, 9318, 9448, 9601,
 9688,10106,10437,10972,11366,11490,11822,11988,12097,12501,
12533,12678,12738,12967,13777,13960,14099,14181,14718,15095,
15239,15523,15588,15607,15764,16828,16986,17132,17357,17394,
17826,17994,18083,18817,18973,19115,19160,19814,20800,20971,
21757,21781,21844,21903,22012,22110,22134,22193,22365,22536,
22597,23005,23321,23527,24217,24329,24731,25199,25791,25811,
26224,26455,27162,27418,27566,27717,28061,28071,28105,28151,
28760,28808,28934,29301,29611,29826,30663,30758,31038,31207,
31895,   42,   74,  101, 1110, 1448, 1805, 1967, 2043, 2067,
 2129, 2589, 2824, 3496, 3611, 3657, 4112, 4145, 4820, 5136,
 5292, 5418, 6205, 6990, 7488, 7520, 8025, 8685, 8916, 8982,
 9048, 9233, 9653, 9867,10241,10319,10410,10522,10849,10860,
10958,11350,11835,11978,12188,12241,12893,12996,13484,13512,
14081,14210,14261,14499,15317,15576,15654,15695,15852,15941,
15976,16440,17140,17145,17244,17478,17614,18513,18692,19040,
19255,19328,19339,19399,20030,20325,20673,20681,20985,21275,
21423,21512,21718,21729,22316,22338,23450,23744,23762,23925,
24419,24458,24666,25067,25769,25997,26560,26600,26737,27015,
27198,27507,27537,27664,27670,27797,27845,29152,29392,29815,
30050,30215,30230,30296,30359,30497,30650,31055,31076,   15,
   47,  123,  132,  224,  254,  457,  490,  495,  530,  581,
  601,  613,  645,  731,  865,  991, 1015, 1053, 1170, 1297,
 1402, 1433, 1461, 1464, 1472, 1617, 1700, 1739, 1837, 1870,
 1944, 1953, 1983, 2141, 2155, 2187, 2392, 2460, 2470, 2501,
 2515, 2625, 2648, 2745, 2767, 2793, 2797, 2834, 2881, 2901,
 2916, 2971, 3005, 3020, 3141, 3188, 3192, 3231, 3321, 3362,
 3732, 3782, 3892, 3998, 4050, 4065, 4121, 4139, 4162, 4295,
 4370, 4438, 4537, 4662, 4720, 4883, 4993, 5007, 5039, 5056,
 5079, 5132, 5155, 5220, 5252, 5262, 5320, 5381, 5399, 5404,
 5469, 5668, 5726, 5795, 5808, 5877, 5886, 6008, 6073, 6156,
 6163, 6215, 6257, 6293, 6364, 6384, 6394, 6442, 6472, 6479,
 6616, 6645, 6688, 6783, 6850, 6979, 7025, 7037, 7205, 7260,
 7319, 7347, 7369, 7384, 7419, 7496, 7591, 7653, 7697, 7742,
 7775, 7899, 7910, 7919, 8121, 8185, 8212, 8297, 8330, 8383,
 8390, 8395, 8399, 8413, 8459, 8542, 8703, 8765, 8847, 8865,
 8880, 8931, 8987, 9081, 9098, 9145, 9166, 9330, 9378, 9454,
 9490, 9499, 9560, 9607, 9668, 9830, 9887, 9924,10008,10015,
10034,10043,10070,10087,10188,10289,10340,10389,10493,10563,
10636,10726,10818,10840,10900,10954,11194,11231,11278,11370,
11413,11446,11455,11551,11657,11730,11815,11941,11962,11968,
12035,12247,12313,12335,12366,12388,12409,12565,12643,12716,
12721,12731,12864,12899,12973,13007,13024,13071,13096,13131,
13148,13152,13207,13372,13406,13445,13453,13489,13495,13508,
13558,13738,13846,13924,13957,14025,14058,14163,14349,14430,
14478,14491,14520,14550,14611,14635,14700,14848,14912,15057,
15173,15181,15237,15369,15408,15521,15650,15803,15861,15898,
15989,16062,16219,16239,16287,16327,16332,16350,16390,16426,
16454,16485,16665,16723,16743,16833,16849,16862,17098,17124,
17196,17206,17362,17378,17506,17517,17558,17582,17620,17785,
17874,17880,18051,18119,18127,18145,18199,18208,18285,18298,
18345,18352,18378,18522,18637,18673,18727,18741,18753,18836,
18844,18908,18949,19085,19132,19245,19263,19301,19406,19442,
19462,19779,19812,19828,19891,19921,19988,19996,20053,20060,
20203,20265,20409,20449,20478,20512,20583,20614,20620,20693,
20700,20848,20939,20951,21006,21018,21236,21284,21341,21360,
21462,21573,21586,21610,21626,21630,21645,21649,21708,21788,
21796,21930,22154,22211,22238,22244,22275,22360,22579,22601,
22679,22717,22736,22971,23054,23089,23095,23098,23146,23267,
23352,23398,23432,23475,23488,23688,23697,23707,23725,23839,
23851,23904,24089,24148,24195,24240,24261,24290,24301,24307,
24401,24467,24512,24615,24708,24737,24775,24829,24918,24988,
25045,25171,25232,25271,25275,25295,25316,25379,25396,25444,
25449,25500,25545,25604,25675,25749,25878,25921,25968,26135,
26209,26323,26364,26383,26433,26467,26502,26537,26758,26831,
26845,26917,26996,27166,27180,27217,27364,27517,27570,27681,
27695,27975,27979,27996,28042,28056,28117,28141,28314,28327,
28451,28539,28544,28579,28629,28673,28689,28724,28753,28814,
28848,29047,29065,29082,29315,29337,29380,29400,29433,29471,
29489,29568,29609,29657,29668,29696,29727,29794,29839,29882,
30069,30197,30208,30251,30289,30493,30637,30694,30748,30754,
30766,30795,30930,30978,30991,30998,31162,31234,31305,31309,
31347,31380,31408,31535,31543,31594,31607,31649,31682,31699,
31758,31775,32028,  340, 1101, 1254, 1318, 1863, 2560, 2596,
 3567, 3877, 3909, 3991, 4043, 4231, 4513, 4934, 5336, 6801,
 6948, 7123, 7633, 8114, 8156, 9134,10001,10326,10526,10680,
10888,11055,11715,11767,12421,13079,13335,13858,14138,14592,
14823,15305,16798,16960,17382,17602,17830,18505,19643,19857,
20079,20361,21218,21748,21761,21812,22494,22799,22809,22856,
22983,23821,23831,24126,24840,25785,25817,26163,26220,26248,
26350,27292,27464,27969,28103,28273,28303,28367,28523,29460,
30728,31443,31952,   66,  202,  595, 1607, 2162, 2207, 3676,
 3896, 3960, 5195, 5518, 5781, 5791, 6084, 6724, 6983, 7256,
 7906, 8261, 9430,10643,11599,11618,11676,11913,12045,12127,
13708,14415,14695,14738,15323,15472,15637,15952,15972,16706,
16730,16777,17135,17492,17531,18649,18656,18709,18971,19103,
20100,20302,20965,21280,21315,21907,22191,22321,22942,23427,
24229,24248,25510,25551,26044,27277,27429,28378,28637,28901,
29059,29329,29771,30778,30820,30836,31051,31194,31451,31524,
31613,  512,  831, 1572, 3268, 3278, 4265, 4272, 4495, 4507,
 5023, 5064, 5296, 5333, 6047, 6298, 6536, 6859, 7020, 7915,
 9735, 9899,11074,11581,11820,11973,12754,12977,13594,14054,
14343,14459,14563,14831,15223,15245,15450,15466,16442,17229,
17442,19658,19710,20398,20818,22090,23946,23961,24503,24672,
25474,25767,25886,25990,27105,27351,27560,27689,28478,28660,
29221,29643,30239,31046,   54,  385,  412,  478,  546,  845,
  892,  903, 1165, 1196, 1649, 1887, 2197, 2343, 2448, 2506,
 3318, 3358, 3371, 3400, 4348, 4612, 4670, 4750, 5343, 5496,
 6360, 6481, 6569, 6627, 7153, 7378, 7628, 7645, 7735, 8086,
 8130, 8161, 8508, 8729, 8759, 8861, 8935, 9302, 9412, 9466,
 9535, 9642, 9747,10275,10484,10604,10831,10980,11260,11761,
12569,12598,12627,12680,12883,12917,13353,13393,13412,13649,
14111,14132,14172,14716,14817,14979,15002,15184,15433,15683,
16040,16082,16222,16386,16571,16590,16839,17103,17142,17609,
18099,18387,18496,18723,18826,18852,18925,19218,19478,19507,
19533,19558,19740,19842,20278,20750,20880,21030,21049,21065,
21966,22230,22433,22673,22979,23082,23109,24019,24074,24607,
24621,25071,25117,25217,25287,25440,26254,26511,26524,26615,
26688,26765,27135,27223,27318,27574,27685,27940,28419,28424,
28548,28845,29140,29383,29483,29588,29683,29723,29732,29891,
30092,30385,30675,30802,30916,30954,31319,31406,31461,31518,
31773,31932,   18,   89,  198,  426,  435,  464,  487,  502,
  726,  854, 1020, 1033, 1091, 1173, 1261, 1349, 1370, 1394,
 1691, 1782, 1827, 1859, 1935, 2022, 2071, 2148, 2330, 2374,
 2443, 2557, 2579, 2618, 2718, 2737, 2801, 3282, 3394, 3489,
 3535, 3547, 3570, 3604, 3694, 3724, 3813, 3864, 3900, 3966,
 4187, 4309, 4327, 4373, 4443, 4574, 4646, 4658, 4773, 4859,
 4915, 4923, 5280, 5314, 5479, 5640, 5762, 5767, 5776, 5802,
 5846, 5870, 5897, 6003, 6016, 6272, 6410, 6420, 6631, 6693,
 6926, 6969, 7197, 7414, 7554, 7636, 7759, 7842, 7901, 7982,
 8009, 8148, 8264, 8270, 8571, 8599, 8660, 8679, 8946, 8963,
 8990, 9091, 9119, 9130, 9190, 9267, 9293, 9470, 9549, 9628,
 9758, 9908,10139,10249,10375,10403,10508,10722,10994,11140,
11198,11207,11240,11282,11289,11354,11381,11449,11461,11534,
11683,11802,11924,12102,12192,12210,12328,12425,12448,12556,
12584,12687,12796,12992,13122,13134,13205,13471,13478,13538,
13578,13632,13691,13695,13874,13908,13915,14279,14369,14406,
14513,14530,14998,15060,15119,15228,15320,15481,15526,15597,
15618,15806,15881,15936,15963,15968,16229,16342,16402,16435,
16451,16461,16599,16773,17307,17480,17514,17540,17562,17616,
17770,17884,17974,17990,18109,18133,18142,18171,18191,18203,
18250,18261,18474,18486,18508,18629,18750,18855,18904,18957,
18975,18979,19348,19471,19499,19631,19735,19847,19993,20001,
20199,20282,20323,20364,20446,20644,20651,20755,20768,20928,
20978,20989,20996,21126,21146,21245,21253,21353,21369,21580,
21657,21985,22162,22214,22219,22293,22376,22391,22499,22701,
22741,22783,22950,23115,23537,23548,23558,23574,23677,23703,
23759,23777,23835,24052,24257,24297,24322,24350,24525,24586,
24590,24655,24818,24868,24934,24982,25018,25075,25241,25346,
25374,25388,25420,25471,25492,25628,25814,25843,25882,25954,
26122,26149,26244,26595,26610,26621,26744,26784,26826,26946,
27115,27144,27155,27288,27386,27403,27422,27475,27649,27713,
27724,27895,27933,28179,28337,28389,28473,28491,28650,28746,
28825,28897,29010,29102,29196,29215,29320,29325,29346,29435,
29497,29594,29807,29842,30101,30175,30186,30206,30308,30438,
30540,30597,30647,31020,31200,31226,31263,31559,31589,31624,
31822,31832,31906,31986,   38,  138,  907, 1311, 1492, 1622,
 2114, 2119, 2219, 2628, 2761, 3043, 3113, 3416, 3743, 3856,
 4096, 4359, 4906, 5431, 5491, 5786, 5838, 5906, 6236, 6953,
 7114, 7356, 7620, 7823, 7874, 8358, 8913, 9633, 9988,10113,
10408,10463,10775,11102,12157,12360,13065,13465,13552,13581,
14168,14731,14814,14875,15269,15859,15946,16100,16202,16746,
17001,17210,17355,17537,17568,19010,19318,19606,19746,20043,
20103,20165,20247,20661,20883,21069,21401,21731,22141,22329,
22419,22478,22621,23011,24293,24315,24772,24998,25029,26776,
26837,26848,27598,27675,27738,28350,28727,29147,29632,30235,
30393,30553,31322,31554,31618,  587,  621, 1659, 1988, 1999,
 2203, 4999, 5691, 5805, 6682, 6771, 6935, 7032, 7135, 7403,
 8500, 8520, 9355, 9527, 9763,10054,10264,11043,11058,11337,
11597,12147,12323,12620,13349,13380,14463,14836,15278,15823,
15894,17304,17433,19144,19332,19792,20572,20973,21191,22380,
22464,22505,22754,23058,23310,23901,24327,24600,24629,25655,
26578,26884,26900,28641,29766,29871,31062,31312,31372,   71,
   84, 1075, 1773, 2966, 3697, 3735, 3980, 4063, 4824, 5988,
 6052, 6309, 8193, 8282, 8594, 8839, 8924, 9236, 9457, 9902,
10705,11165,11374,11602,12031,12445,12482,12572,12891,14667,
14791,16740,16926,16977,17281,17764,17778,18308,20227,20307,
20980,21214,21332,22394,22722,22859,22937,23843,23972,24150,
25215,25297,25838,25993,26216,26983,27203,28083,28885,29033,
29479,29701,29811,29831,30374,31301,  215,  868, 1609, 1747,
 1890, 2227, 2702, 3387, 3753, 3809, 4226, 4621, 5246, 6284,
 6544, 7110, 7239, 7340, 8177, 9067,10061,10122,10808,10960,
11478,12344,12397,13138,13871,13944,14230,14263,14311,14746,
15043,15298,15938,16447,17510,17523,17965,18061,18371,18719,
18875,19615,19977,20028,20127,21441,21504,21661,23269,23479,
24687,25394,25618,25947,26469,27103,27812,27901,28153,28565,
28802,28879,29975,30847,31066,31923,32018,  356,  633,  802,
  877, 1086, 1423, 1787, 2267, 3117, 3517, 3750, 4109, 4291,
 4885, 4900, 5120, 5843, 5865, 6108, 7074, 7215, 7700, 7805,
 7830, 8477, 8535, 8641, 8708, 9531, 9944,10646,11170,11494,
11755,12111,12548,13172,13534,13829,14142,14628,14864,15262,
15403,15676,15756,16416,16573,16750,17009,17248,17429,18123,
18271,18449,19107,19704,20018,20299,20313,20820,20845,22343,
22774,23280,23389,23734,24081,24197,24729,25001,25062,25290,
25783,25826,26064,26116,26505,26798,27593,28251,28293,28324,
28434,28766,28861,29525,29897,30153,30337,30642,30808,30932,
31329,31725,31975,31990,  128,  707,  806,  976, 1113, 1760,
 1825, 2260, 2356, 2711, 3137, 3689, 4451, 4579, 4665, 4818,
 4952, 6020, 6147, 6175, 6391, 6651, 7002, 7563, 7971, 8674,
 8716, 9480, 9855, 9937, 9995,10150,10280,10476,10608,10885,
10890,11586,11615,11736,11857,12249,12370,13855,14042,14352,
14411,14947,14996,15062,15093,15303,15815,15901,16459,17628,
18055,18287,18551,19062,19080,19345,19487,19610,19819,20368,
20482,20546,20634,20647,21639,21912,22156,22881,23044,23304,
23328,23336,23360,23631,23874,24201,24801,24885,24894,25476,
26081,26370,26618,27121,27227,27562,27733,27883,28236,29099,
29473,29848,30212,30264,30665,31349,  134,  414,  475,  852,
  872, 1347, 1355, 1754, 2246, 2413, 2615, 2655, 2962, 3110,
 3402, 3430, 3526, 3655, 3670, 3987, 4489, 4554, 4725, 4895,
 5608, 5873, 5961, 6380, 7059, 7173, 7201, 7434, 7499, 7739,
 7766, 8411, 8749, 8843, 9050, 9061, 9157, 9366, 9503,10108,
10256,10435,10908,10982,11340,11348,11430,11639,12262,12712,
13088,13307,13333,13357,13376,13781,13794,13868,13890,13963,
14093,14449,15389,15697,15762,15835,16727,16761,16984,17100,
17217,18085,18389,18686,19209,19458,19473,19776,19882,20273,
20416,21081,21134,21194,21397,21414,21430,21727,21791,21858,
21926,21936,22325,22413,22676,23385,23448,23571,24107,24237,
24461,24548,24635,25950,25979,26197,26509,26713,27141,27164,
27200,27514,27652,27800,28128,28455,28965,29229,29234,29261,
29313,29398,30096,30275,30435,30881,30914,31005,31440,31744,
31779,32032,    3,   27,   94,  125,  200,  274,  347,  452,
  462,  481,  598,  629,  636,  781,  843,  880,  886,  890,
  905,  914, 1001, 1031, 1048, 1093, 1117, 1124, 1251, 1390,
 1411, 1419, 1483, 1488, 1495, 1543, 1558, 1643, 1693, 1756,
 1769, 1778, 1820, 1846, 1856, 2194, 2223, 2254, 2345, 2372,
 2383, 2497, 2503, 2541, 2552, 2593, 2721, 2740, 2747, 2829,
 2892, 2898, 2968, 2974, 2982, 3010, 3036, 3098, 3145, 3150,
 3206, 3218, 3274, 3385, 3491, 3745, 3777, 3866, 3913, 3993,
 4124, 4147, 4164, 4229, 4233, 4263, 4274, 4284, 4324, 4432,
 4441, 4498, 4523, 4527, 4567, 4652, 4695, 4739, 4748, 4769,
 4871, 4925, 4945, 4955, 4995, 5025, 5041, 5059, 5066, 5193,
 5227, 5230, 5294, 5303, 5316, 5436, 5461, 5514, 5530, 5632,
 5730, 5772, 5909, 5957, 5975, 6026, 6049, 6060, 6183, 6230,
 6302, 6396, 6401, 6414, 6426, 6447, 6553, 6629, 6656, 6741,
 6753, 6854, 6870, 6876, 6965, 6988, 6998, 7029, 7105, 7167,
 7247, 7263, 7323, 7401, 7493, 7518, 7610, 7716, 7728, 7750,
 7761, 7773, 7844, 7912, 8013, 8079, 8088, 8116, 8128, 8152,
 8170, 8224, 8335, 8372, 8375, 8494, 8581, 8585, 8662, 8723,
 8850, 8888, 8985, 8996, 9028, 9064, 9142, 9151, 9225, 9281,
 9316, 9361, 9462, 9537, 9545, 9619, 9679, 9683, 9755, 9760,
 9828, 9841, 9852, 9882, 9892, 9906, 9933,10041,10190,10269,
10273,10385,10392,10398,10420,10486,10489,10528,10622,10671,
10779,10823,10879,10904,10916,10949,11018,11024,11050,11064,
11085,11200,11271,11280,11439,11553,11579,11590,11612,11667,
11679,11724,11827,11845,11933,11980,11991,12002,12060,12145,
12208,12219,12332,12354,12484,12490,12513,12543,12567,12576,
12610,12616,12625,12689,12697,12729,12783,12901,12964,13005,
13020,13058,13067,13102,13179,13248,13298,13318,13467,13476,
13514,13528,13574,13672,13746,13790,13881,13906,13953,14023,
14030,14079,14109,14122,14134,14170,14320,14366,14495,14536,
14618,14662,14681,14735,14826,14843,14885,14944,14985,15080,
15098,15124,15133,15141,15192,15267,15309,15397,15443,15474,
15559,15585,15604,15616,15681,15704,15801,15838,15854,15857,
15958,15961,16068,16171,16175,16204,16247,16323,16334,16357,
16405,16420,16464,16467,16530,16619,16637,16732,16754,16795,
16822,16836,16858,16867,16997,17151,17161,17359,17488,17528,
17566,17606,17669,17696,17704,17788,17878,17882,17899,17903,
17929,18020,18135,18140,18151,18165,18274,18296,18305,18339,
18366,18401,18567,18572,18577,18675,18707,18737,18776,18895,
18947,18959,19098,19129,19174,19215,19230,19238,19242,19395,
19416,19501,19639,19676,19687,19721,19742,19783,19855,19877,
19930,19980,20014,20051,20117,20214,20285,20384,20411,20424,
20569,20587,20593,20612,20666,20707,20841,20869,20893,20931,
21054,21155,21184,21196,21259,21266,21269,21321,21337,21358,
21365,21373,21404,21425,21509,21584,21612,21714,21767,21955,
21974,22081,22206,22279,22299,22427,22543,22556,22593,22612,
22703,22725,22768,22778,22878,22910,22948,22955,22963,23008,
23040,23105,23178,23184,23396,23430,23435,23463,23469,23508,
23524,23695,23727,23774,23858,23864,23877,23942,24022,24032,
24084,24144,24154,24208,24233,24285,24434,24447,24605,24632,
24663,24681,24715,24834,24912,24984,25112,25164,25226,25250,
25261,25312,25401,25438,25543,25556,25570,25608,25659,25741,
25806,25831,25835,25845,25866,25892,25937,25964,25982,26046,
26071,26199,26226,26353,26360,26437,26444,26530,26541,26648,
26690,26761,26942,26961,26978,26986,27026,27045,27090,27107,
27112,27213,27265,27380,27413,27529,27535,27552,27589,27658,
27662,27679,27697,27750,27759,27774,27857,27893,27908,27923,
27958,27963,28271,28316,28359,28384,28421,28493,28572,28639,
28663,28711,28719,28859,28925,28936,29020,29107,29135,29194,
29250,29273,29284,29394,29445,29583,29603,29621,29708,29730,
29867,29912,29970,29990,30011,30025,30065,30118,30173,30223,
30298,30391,30432,30440,30461,30534,30573,30614,30671,30792,
30926,30980,31036,31059,31114,31140,31147,31204,31220,31223,
31317,31352,31369,31376,31435,31458,31592,31622,31768,31791,
31830,31884,31908,31921,31980,  115,  333,  544,  640, 1010,
 1344, 1440, 2024, 2133, 2174, 2455, 2620, 3045, 3514, 3805,
 4077, 4127, 4151, 4446, 5032, 5071, 5096, 5473, 5583, 5619,
 5902, 6115, 6654, 6957, 7120, 7183, 7426, 7798, 7883, 8019,
 8312, 8714, 9374, 9513, 9733, 9794,10023,10203,10844,11060,
11222,11559,11718,12010,12197,12308,12405,12631,13651,13686,
13711,14114,14486,14723,14802,15024,15293,15639,15886,16098,
16178,16199,16376,16520,17005,17631,17940,18349,18446,18458,
18626,18861,18885,19276,19325,19353,19682,20179,20642,20657,
21150,21710,21835,22003,22183,22309,22714,22744,22872,23174,
23444,23741,24282,24304,24699,24995,25089,25157,25392,25432,
26066,26211,26459,26824,26888,27095,27340,27984,28097,28137,
28162,28224,28503,28895,28951,29187,29269,29688,29978,30352,
30377,30611,30658,30876,30961,31325,31741,31878,31892,31929,
  231,  683, 1569, 1657, 2185, 2199, 2250, 2320, 2909, 3952,
 4198, 4855, 5020, 5082, 5206, 6281, 6456, 6722, 7143, 7832,
 8356, 8451, 8672, 8747, 8892, 8922, 9261, 9859,10322,10377,
11262,11378,12068,12236,12554,12834,13542,14019,14090,14433,
14444,14461,14509,15554,15879,16018,17062,17148,17349,17675,
17811,18362,19671,19724,20003,20742,20791,21475,21737,21828,
21952,21987,22007,22039,22283,22291,22303,22468,22731,23122,
23532,24060,24120,24386,24454,24543,24976,25039,25094,25236,
25563,26773,26999,27005,27125,27231,27880,28249,28533,28555,
28657,28874,29408,29534,29614,29715,30619,30860,30988,31009,
31642,32036,   31,  120,  592,  859, 1041, 1977, 1985, 2046,
 2274, 2341, 2997, 3287, 3312, 3537, 3582, 3606, 3714, 4684,
 5569, 5602, 5649, 5715, 6171, 6238, 6277, 6577, 6633, 7170,
 7560, 7807, 8007, 8323, 8654, 8799, 8973, 9822,10196,10452,
10503,10854,11190,11792,12342,12605,12779,13076,13119,13385,
13834,14237,14547,14659,14838,15565,16801,16981,17034,17391,
17401,17474,17717,18631,18964,19035,19070,19110,19249,20038,
21409,21433,21785,21842,21943,21998,22751,22997,23068,23080,
23747,23757,24099,24500,25793,26112,26192,26204,26232,26346,
26516,26718,26937,27928,29630,30177,30339,30485,30640,31169,
31571,31704,  235,  896, 1177, 1213, 1314, 1428, 1646, 1923,
 2020, 2160, 2418, 2434, 2778, 2948, 3127, 3225, 3424, 3564,
 3652, 3854, 3925, 3975, 4155, 4175, 4351, 4865, 5150, 5477,
 5684, 5831, 5970, 6079, 6296, 6534, 6565, 6585, 6611, 6733,
 6781, 6794, 6817, 7022, 7268, 7512, 7579, 8083, 8095, 8141,
 8173, 8770, 8928, 9076, 9111, 9408, 9435, 9725, 9749,10029,
10037,10307,10368,10432,10442,10596,10797,10964,11417,11427,
11466,11524,11673,12064,12122,12138,12723,12805,12954,12982,
13202,13774,13990,14105,14517,14630,14669,14743,14788,15109,
15257,15593,15672,15773,15997,16231,16671,16783,16854,16929,
17302,17587,17728,18012,18189,18373,18472,18595,18645,18734,
19094,19213,19233,19273,19730,19888,19905,19940,19970,20087,
20255,20427,20566,20629,20796,20872,21071,21158,21329,21380,
21663,21939,22217,22357,22435,22781,22892,22920,23159,23247,
23291,23679,23720,24047,24343,24517,24812,24970,24980,25031,
25123,25299,25382,25405,25672,25858,25970,26016,26328,26415,
26816,27082,27117,27234,27330,27668,27747,27756,27998,28091,
28183,28730,28770,28999,29014,29031,29389,29660,29703,29861,
29889,30188,30220,30260,30499,30550,30825,30945,30966,31491,
31557,31808,31820,31882,31945,  143,  297,  323,  439,  576,
  603,  611,  663,  772,  776,  788,  800,  812,  816, 1080,
 1257, 1277, 1358, 1383, 1554, 1605, 1624, 1670, 1810, 1876,
 1932, 2146, 2257, 2269, 2380, 2521, 2602, 2631, 2692, 2827,
 2837, 2850, 2943, 2992, 3105, 3171, 3307, 3368, 3596, 3665,
 3678, 3699, 3703, 3711, 3738, 3919, 4245, 4329, 4384, 4458,
 4463, 4550, 4572, 4619, 4722, 4756, 4805, 4837, 5009, 5050,
 5085, 5157, 5451, 5498, 5511, 5593, 5622, 5719, 5819, 5848,
 5998, 6056, 6186, 6224, 6290, 6305, 6452, 6668, 6730, 6938,
 7043, 7230, 7316, 7380, 7398, 7437, 7531, 7540, 7545, 7602,
 7649, 7694, 7748, 7836, 7877, 8073, 8146, 8195, 8209, 8378,
 8419, 8490, 8551, 9073, 9102, 9171, 9277, 9422, 9477, 9711,
 9717, 9800, 9864, 9913,10147,10372,10445,10458,10468,10510,
10601,10618,10763,10803,10975,11053,11067,11093,11136,11153,
11213,11218,11292,11457,11547,11775,11780,11926,12104,12179,
12224,12245,12326,12493,12503,12551,12574,12702,12774,12831,
12907,12940,13182,13256,13369,13571,13644,13729,13743,13876,
13974,13985,14101,14117,14255,14265,14346,14420,14527,14606,
14664,14673,14896,14904,15010,15041,15069,15114,15276,15421,
15438,15599,15707,15716,15891,16137,16251,16412,16537,16556,
16565,16575,16586,16626,16668,16808,16901,16934,16962,17038,
17042,17212,17294,17309,17367,17579,17624,17699,17755,17761,
17791,17924,17936,17976,18068,18097,18240,18269,18293,18302,
18317,18443,18476,18717,18780,18932,18944,19142,19146,19450,
19542,19623,19706,19825,19840,19985,19991,20045,20075,20249,
20296,20321,20379,20497,20509,20745,20782,20815,20854,20864,
20902,21230,21395,21464,21506,21532,21740,21823,21896,21969,
21981,22287,22306,22335,22370,22431,22541,22608,22900,23000,
23241,23300,23344,23362,23393,23456,23499,23519,23618,23738,
23848,24028,24054,24086,24139,24339,24348,24391,24407,24546,
24612,24660,24675,24857,25080,25102,25181,25255,25268,25386,
25469,25539,25589,25689,25797,25803,25819,25868,25929,26076,
26367,26464,26513,26572,26641,26726,27012,27086,27099,27225,
27353,27367,27377,27399,27407,27485,27526,27549,27576,27580,
27692,28005,28231,28260,28298,28357,28459,28498,28623,28671,
28708,28716,28756,28954,29044,29110,29263,29486,29520,29596,
29693,29829,29857,29960,30002,30037,30062,30302,30401,30547,
30567,30781,30800,30840,30856,30919,30938,31217,31427,31446,
31453,31527,31580,31584,31610,31654,31696,31723,31827,31958,
32025,   52,  211,  262,  292,  302,  542,  710, 1026, 1229,
 1246, 1268, 1294, 1299, 1307, 1580, 1591, 1697, 2112, 2183,
 2398, 2814, 2920, 2930, 2960, 3079, 3351, 3483, 3765, 3792,
 4102, 4479, 4711, 4737, 4920, 5017, 5101, 5660, 5712, 5880,
 5984, 6014, 6152, 6196, 6636, 6790, 6834, 6873, 6942, 7078,
 7139, 7443, 7575, 7623, 7726, 7778, 8064, 8317, 8327, 8347,
 8454, 8486, 8574, 8590, 9122, 9128, 9139, 9185, 9239, 9297,
 9424, 9440, 9497, 9835, 9928,10304,10332,10516,11011,11040,
11144,11159,11442,11572,11624,11681,11748,11758,11785,11797,
12042,12216,12540,12786,12838,12943,13018,13281,13341,13502,
13655,13701,13947,13968,14249,14566,14690,14812,14939,15411,
15571,15701,15712,15811,15843,16024,16134,16166,16206,16244,
16472,16640,16648,16786,16825,16914,17164,17328,17575,17635,
17795,17803,18194,18245,18529,18699,18711,18857,18922,19019,
19267,19411,19547,19553,20388,20392,20659,20748,20765,20807,
20825,20888,21178,21436,21444,21801,21909,22045,22331,22388,
22507,22514,22760,22788,22988,23119,23442,23514,23576,23808,
24012,24319,24450,24487,24492,24651,24820,24863,24905,25020,
25390,25648,26053,26124,26240,26333,26411,26565,26590,26613,
26740,27320,27348,27461,27496,27673,27874,28094,28110,28144,
28170,28348,28469,28558,28737,28869,28891,29016,29226,29288,
29348,29377,29624,29836,30075,30180,30283,30555,30731,30971,
31189,31213,31344,31949,32009,  533,  701,  739, 1182, 1204,
 1407, 2010, 2117, 2424, 2599, 3024, 3092, 3147, 3374, 3557,
 3852, 4004, 4068, 4312, 4417, 4469, 5298, 5311, 5323, 5413,
 5588, 5827, 5891, 6351, 6434, 6955, 6994, 7050, 7713, 8408,
 8968, 9054, 9325, 9369, 9420, 9572, 9694, 9731, 9797, 9817,
10415,10480,10640,11003,11177,11904,11999,12432,12758,13110,
13160,13517,13840,13931,14048,14148,14515,14560,14988,15242,
15312,15383,15416,15430,15657,15690,15788,16143,16161,16430,
16513,16937,17555,17681,17722,18536,19043,19064,19127,19206,
19282,19314,19438,19523,19805,20358,20405,20454,20876,21021,
21089,21169,21515,21838,22187,22233,22490,22694,22861,22902,
23164,23318,23713,23732,24410,24725,24815,24924,24962,25219,
25258,25425,25942,25960,26145,26235,26452,26586,26638,26693,
26991,27171,27988,28002,28088,28427,28655,29028,29124,29149,
29256,29278,29957,29964,30044,30271,30470,30645,30772,30873,
30885,31014,31121,31246,  206,  257,  267,  306,  672,  716,
 1162, 1175, 1583, 1672, 1765, 1842, 1980, 2334, 2458, 2509,
 3383, 3456, 3549, 3587, 3859, 4089, 4305, 4322, 4484, 4559,
 4814, 5236, 5346, 5597, 5917, 6054, 6076, 6118, 6621, 6672,
 6799, 7158, 7223, 7551, 7596, 7968, 7996, 8273, 8473, 8560,
 8695, 9340, 9637, 9674, 9877,10135,10473,10593,10765,10913,
11642,11830,11921,11936,12153,12230,12357,12393,12811,12869,
12912,13168,13291,13315,13329,13597,13861,14423,14889,15105,
15198,15366,15457,15869,16182,16193,16261,16674,16991,17289,
17397,17416,18006,18057,18312,18398,18546,18839,18939,19656,
19680,19726,19903,20216,20270,20502,20607,20625,21142,21162,
21538,21605,22000,22084,22363,22402,22822,23257,23378,23753,
23881,24008,24038,24044,24114,24464,24594,25208,25245,25360,
25536,25695,26020,26555,26954,27036,27789,28053,28134,28148,
28254,28482,28509,29008,29132,29138,29266,29298,29306,29528,
30013,30056,30576,30602,30688,30943,31105,31575,31900,31927,
  238,  721, 1061, 1154, 1209, 1668, 2061, 2234, 2324, 2772,
 3324, 3335, 3802, 3882, 3888, 3948, 3977, 4248, 4256, 4300,
 4424, 4700, 5076, 5445, 5483, 5617, 5965, 6219, 6356, 6371,
 6484, 6592, 6809, 6960, 7298, 7451, 7784, 7792, 8101, 8108,
 8204, 8222, 8704, 8726, 8789, 8841, 8901, 9336, 9509, 9659,
 9744, 9810,10566,10628,10684,10713,10883,11033,11183,11629,
11854,12175,12316,12378,12769,12878,13304,13367,13398,13603,
13705,13951,14084,14403,14540,15016,15034,15326,15632,15670,
16043,16225,16523,16533,16541,16652,16947,16966,17194,17315,
17323,17335,17423,17858,18177,18185,18640,18704,18981,19037,
19168,19253,19289,19304,19454,19909,20010,20084,20253,20753,
21448,21468,21972,22053,22127,22148,22203,22345,22663,23074,
23133,23284,23580,23885,24254,24397,24414,24515,24721,25238,
25376,25466,25685,25925,26186,26274,26358,26522,26793,27324,
27410,27502,27778,27803,27842,28112,28239,29120,29282,29385,
29655,29781,29916,29982,30019,30033,30098,30814,30975,31143,
31231,31500,31761,31787,31797,31837,31873,  408,  445,  836,
  924,  997, 1071, 1158, 1242, 1612, 1880, 1893, 1928, 2016,
 2135, 2348, 2359, 2369, 2405, 2606, 2697, 2723, 3027, 3087,
 3162, 3196, 3200, 3379, 3406, 3422, 3618, 3687, 3923, 4180,
 4629, 4730, 4800, 5091, 5127, 5140, 5272, 5574, 5647, 5799,
 5817, 6066, 6338, 6408, 6659, 6844, 6879, 7305, 7396, 7447,
 7708, 7926, 7930, 7988, 8139, 8613, 8687, 8733, 8949, 9162,
 9219, 9250, 9255, 9647, 9697, 9896,10039,10065,10236,10335,
10578,10654,10677,10697,11179,11358,11385,11402,11522,11842,
11915,12056,12161,12526,12602,12801,12886,13140,13164,13200,
13383,13636,13660,13678,13722,13785,13884,14034,14534,14642,
14688,14907,15039,15168,15212,15250,15283,15375,16094,16197,
16258,16271,16294,16408,16547,16816,16899,16954,17053,17187,
17214,17238,17710,17736,17944,18073,18148,18159,18213,18278,
18322,18394,18491,18689,18864,19298,19413,19588,19668,19786,
20111,20221,20291,20518,20770,20859,21025,21034,21187,21248,
21427,21456,21558,21773,21915,21948,22037,22225,22739,22792,
22812,22851,22864,22869,22965,23149,23374,23471,23551,23646,
23652,23673,23683,23896,23970,24004,24095,24102,24694,24701,
24808,24881,25229,25307,25354,25369,25486,25956,26004,26055,
26130,26159,26179,26400,26497,26700,26753,26803,26922,26967,
27030,27152,27195,27314,27373,27494,27617,27784,27849,28296,
28308,28321,28332,28505,28834,28912,29056,29158,29240,29244,
29425,29674,29800,29903,29920,30088,30406,30444,30487,30617,
30798,30866,30957,31237,31496,31712,31962,31970,31994,  159,
  277,  343,  648,  657,  695,  822, 1281, 1565, 1639, 1742,
 2420, 2926, 3013, 3075, 3125, 3169, 3294, 3330, 3531, 3848,
 4532, 4704, 4716, 4830, 4851, 5145, 5327, 5386, 5421, 5505,
 5536, 6404, 6557, 6582, 6663, 7220, 7372, 7390, 7440, 7504,
 7509, 7525, 7921, 7961, 8720, 8740, 8796, 8859, 8975, 9289,
 9308,10048,10092,10586,10754,10894,11109,11343,11654,11860,
11995,12006,12015,12130,12293,12636,13127,13215,13565,13927,
13939,14097,14216,14329,14372,14435,14454,14872,15126,15178,
15494,15626,15770,15783,15955,15994,16089,17299,17373,17413,
17503,17548,18154,18465,18557,18967,19154,19485,19503,19653,
19808,20072,20173,20400,20490,21327,21576,21623,21702,21733,
22169,22374,22520,22529,22574,23495,23826,24226,24334,24520,
24741,24859,24968,25642,25972,26038,26635,26788,26914,26973,
27281,27520,28442,28560,28569,28612,28743,28819,28904,28959,
29068,29494,29571,29804,29968,30202,30457,30468,31128,31173,
31401,31508,31739,31913,31984,31998,32005,  192,  240,  285,
  329,  393,  616,  917, 1058, 1587, 1629, 1813, 2026, 2152,
 2190, 2432, 2464, 2661, 2839, 2950, 3017, 3301, 3477, 3771,
 3842, 4134, 4336, 4363, 4378, 4474, 4642, 4686, 5053, 5458,
 5662, 5693, 6070, 6091, 6166, 6254, 6423, 6500, 6760, 6917,
 6971, 7208, 7813, 7846, 7955, 7992, 8133, 8268, 8553, 8762,
 8801, 8876, 8943, 9043, 9272, 9346, 9802,10018,10073,10199,
10217,10227,10315,11016,11237,11295,11646,11772,12020,12258,
12338,12498,12521,12561,12929,13084,13114,13196,13287,13343,
13456,13972,14126,14233,14300,14608,14858,15138,15463,15488,
15601,15692,15779,15828,16029,16048,16559,16660,16806,16912,
17253,17287,17420,17497,17714,17724,18017,18163,18331,18694,
18763,19409,19419,19519,19635,19749,19834,19924,20091,20120,
20244,20258,20429,20654,20703,20760,20774,21199,21208,21478,
21527,21555,21566,22018,22023,22123,22176,22604,22934,23101,
23139,23275,23543,23765,23781,23914,24213,24442,24649,24658,
24795,24876,24926,25283,25303,25415,25507,25558,25637,25788,
25873,26008,26031,26344,26574,26626,26852,27271,27479,27700,
27722,27730,27763,28064,28159,28262,28536,28617,28666,29213,
29412,29651,30046,30168,30388,30543,30626,30862,30949,31070,
31257,31411,31416,31540,31565,31935,   35,  294,  337,  388,
  500,  652,  785,  826,  928,  933, 1068, 1232, 1288, 1304,
 1378, 1655, 1679, 1792, 1800, 1840, 1853, 1938, 2243, 2353,
 2390, 2554, 2639, 2705, 2716, 2750, 2783, 2809, 2843, 2904,
 2922, 2957, 2986, 3155, 3467, 3591, 3682, 3938, 4085, 4104,
 4191, 4241, 4253, 4289, 4314, 4344, 4355, 4386, 4502, 4542,
 4561, 4842, 4846, 5062, 5188, 5198, 5216, 5249, 5595, 5679,
 5734, 5836, 5858, 6043, 6088, 6105, 6191, 6251, 6266, 6347,
 6486, 6493, 6573, 6670, 6744, 6929, 7010, 7034, 7176, 7308,
 7549, 7617, 7683, 7745, 7838, 7950, 8021, 8097, 8103, 8202,
 8218, 8352, 8469, 8693, 8711, 8787, 8832, 8958, 8966, 9030,
 9038, 9088, 9109, 9323, 9460, 9556, 9621, 9676, 9742, 9792,
 9861, 9946,10080,10099,10117,10214,10302,10381,10396,10450,
10815,10837,10999,11091,11173,11243,11255,11275,11335,11397,
11419,11424,11471,11482,11539,11543,11568,11945,11957,12173,
12302,12350,12590,12708,12771,12836,12999,13014,13251,13272,
13337,13449,13491,13667,13751,13769,13865,14086,14103,14272,
14502,14506,14542,14555,14602,14648,14786,14909,15022,15054,
15087,15189,15204,15260,15506,15798,15845,15865,16008,16132,
16159,16265,16382,16552,16596,16907,16920,16968,17027,17057,
17168,17177,17203,17347,17399,17408,17427,17435,17868,17897,
17934,17951,18065,18103,18360,18382,18456,18484,18499,18534,
18562,18580,18819,18900,18912,19068,19166,19278,19308,19335,
19404,19436,19621,19700,19915,20056,20181,20287,20355,20418,
20507,20575,20678,20778,20837,20856,20935,21001,21041,21076,
21176,21419,21452,21523,21536,21549,21595,22049,22096,22112,
22386,22399,22488,22545,22584,22624,22696,22953,22995,23002,
23050,23076,23347,23367,23506,23583,23623,23670,23953,24026,
24049,24092,24110,24129,24192,24263,24452,24481,24506,24618,
24783,25022,25189,25205,25266,25579,25693,25759,25823,25848,
25855,25934,26312,26385,26407,26457,26546,26557,26655,26710,
26734,26822,26951,27022,27072,27359,27383,27391,27488,27542,
27604,27715,27780,27855,27868,28080,28126,28187,28334,28609,
28630,28652,28871,28887,29005,29118,29441,29508,29515,29646,
29718,29874,29923,29998,30006,30144,30164,30218,30244,30423,
30537,30557,30561,30656,30725,30787,30830,30843,30969,30995,
31267,31342,31387,31395,31433,31502,31562,31631,31747,31898,
   21,   58,   81,  149,  154,  163,  208,  259,  314,  327,
  396,  417,  472,  492,  540,  626,  703,  797,  862,  910,
  986, 1024, 1063, 1073, 1083, 1160, 1199, 1206, 1224, 1237,
 1284, 1292, 1361, 1385, 1507, 1596, 1663, 1732, 1751, 1795,
 1829, 1874, 1930, 1947, 1964, 1996, 2030, 2037, 2059, 2069,
 2074, 2078, 2144, 2165, 2385, 2396, 2403, 2440, 2568, 2585,
 2688, 2699, 2725, 2755, 2990, 3038, 3077, 3130, 3173, 3203,
 3221, 3236, 3418, 3472, 3501, 3506, 3542, 3673, 3716, 3726,
 3761, 3767, 3794, 3902, 3946, 3968, 4036, 4070, 4142, 4173,
 4182, 4236, 4267, 4317, 4634, 4744, 4902, 4957, 4962, 5002,
 5013, 5048, 5069, 5103, 5110, 5125, 5232, 5257, 5289, 5307,
 5378, 5411, 5415, 5493, 5526, 5586, 5629, 5652, 5701, 5709,
 5784, 5815, 5825, 5921, 6161, 6181, 6221, 6336, 6369, 6386,
 6418, 6465, 6590, 6613, 6623, 6727, 6786, 6824, 6839, 6881,
 6932, 6940, 6944, 7004, 7067, 7160, 7218, 7243, 7250, 7336,
 7364, 7430, 7459, 7538, 7568, 7577, 7598, 7612, 7687, 7722,
 7753, 7890, 7897, 7980, 8016, 8165, 8190, 8258, 8286, 8307,
 8315, 8319, 8349, 8370, 8386, 8532, 8565, 8583, 8657, 8689,
 8855, 8867, 8874, 8909, 9175, 9187, 9275, 9416, 9438, 9451,
 9474, 9486, 9495, 9565, 9713, 9728, 9738, 9806, 9894, 9910,
 9954,10075,10131,10179,10208,10225,10299,10413,10424,10455,
10482,10512,10519,10531,10580,10630,10658,10669,10694,10715,
10805,10827,10857,10881,10970,10977,11005,11009,11107,11147,
11249,11287,11409,11564,11608,11727,11750,11783,11787,11811,
11848,11877,11906,12026,12029,12050,12142,12182,12203,12228,
12251,12255,12297,12320,12391,12506,12622,12673,12741,12756,
12789,12799,12871,12905,12924,12938,12957,12984,13074,13108,
13217,13262,13278,13293,13401,13547,13555,13569,13586,13605,
13653,13697,13717,13731,13772,13920,13981,14016,14061,14065,
14074,14088,14146,14150,14221,14284,14287,14331,14359,14439,
14597,14621,14677,14692,14807,14852,14891,14900,14924,14931,
14942,15027,15037,15072,15112,15195,15255,15286,15364,15377,
15392,15428,15469,15492,15513,15562,15809,15821,15871,15909,
15949,15981,16077,16096,16154,16233,16273,16339,16369,16378,
16399,16410,16518,16580,16605,16610,16631,16635,16676,16814,
16856,16941,16949,16958,17030,17116,17119,17127,17365,17472,
17535,17573,17585,17594,17685,17701,17772,17807,17821,17860,
17926,17938,17960,17981,18078,18183,18392,18480,18518,18548,
18642,18659,18667,18681,18713,18732,18756,18786,18830,18847,
19016,19029,19073,19120,19162,19225,19269,19342,19432,19448,
19467,19492,19511,19516,19555,19585,19590,19810,19867,19933,
19936,20021,20036,20048,20186,20205,20234,20260,20458,20559,
20564,20595,20690,20827,20861,20878,20956,20993,21045,21084,
21091,21124,21132,21204,21251,21351,21393,21416,21553,21563,
21570,21600,21616,21653,21721,21819,21851,21890,21899,21917,
21963,21989,22160,22404,22410,22482,22510,22518,22524,22534,
22553,22570,22606,22665,22687,22806,22820,22849,22924,22945,
22976,23131,23153,23162,23237,23259,23282,23295,23438,23556,
23638,23657,23681,23718,23841,23867,23888,23891,23932,23963,
23968,24014,24133,24152,24245,24268,24279,24310,24332,24395,
24422,24431,24494,24581,24596,24705,24723,24861,24874,24922,
24928,24992,25035,25059,25082,25099,25152,25175,25201,25278,
25362,25410,25454,25548,25576,25600,25621,25633,25670,25754,
25775,25808,25976,26036,26061,26086,26114,26132,26184,26188,
26262,26342,26413,26428,26528,26553,26582,26633,26652,26698,
26808,26835,26897,26909,26948,26971,26993,27173,27210,27300,
27459,27468,27504,27533,27607,27615,27705,27710,27753,27876,
27910,27926,27931,27937,27960,28038,28051,28172,28196,28247,
28457,28484,28531,28562,28686,28739,28772,28851,28856,28882,
28906,28923,28942,28961,29024,29038,29091,29127,29190,29203,
29209,29252,29293,29334,29414,29466,29530,29601,29640,29662,
29680,29761,29774,29818,29879,29887,30017,30086,30192,30292,
30300,30304,30379,30414,30420,30430,30442,30477,30584,30591,
30631,30720,30733,30833,30985,31001,31041,31049,31123,31131,
31138,31145,31154,31229,31252,31456,31494,31550,31582,31597,
31684,31717,31750,31782,31918,32003,  269,  290,  422, 1364,
 1502, 1537, 1850, 2543, 2643, 2804, 2911, 3552, 3773, 4091,
 4307, 4467, 4486, 4614, 4627, 4939, 5339, 5521, 5611, 5658,
 5861, 5982, 6665, 6832, 7063, 7150, 8652, 8738, 8794, 8905,
 8952, 9433, 9706,10759,10792,11069,11769,11997,12017,12310,
12440,13011,13090,13327,13544,13638,14482,14624,14684,14721,
14950,15830,16087,16168,16180,16437,16910,17708,17932,18107,
18248,18384,18624,18953,19101,19251,19521,19884,20170,20390,
20438,20473,20794,20886,20998,21411,22005,22116,22558,22916,
23087,23202,23372,24638,24822,25042,25096,25488,25626,25890,
26309,26924,26989,27009,27093,27169,27794,28276,28285,28330,
28381,28646,28811,28893,29492,29691,29785,29962,30871,31249,
31378,31902,  104,  117,  140,  514,  661,  972, 1220, 1567,
 1767, 2409, 2437, 2708, 3326, 3787, 4298, 4388, 5089, 5695,
 6150, 6406, 6827, 7041, 7141, 7156, 7703, 7782, 7957, 8099,
 8229, 8592, 8898, 9137, 9252, 9542, 9655, 9951,10067,10252,
10277,10383,11038,11746,11777,12803,12809,12876,12920,13724,
14178,14327,14418,15048,15399,15418,15767,15841,16045,16091,
16393,16545,17024,17040,17285,17371,17438,17730,17871,18662,
18917,19082,19157,19719,20082,20223,20640,20676,21003,21087,
21174,21590,21668,21840,22121,22476,22486,22684,23289,23424,
23512,23529,24678,24836,24973,25078,26026,26318,26771,26940,
26956,27236,27761,28076,28168,28541,28567,28692,29428,29477,
29901,30233,30565,30853,31126,31355,31652,   11,   24,   79,
  107,  147,  233,  245,  248,  264,  282,  287,  304,  391,
  405,  428,  443,  447,  537,  549,  607,  678,  690,  697,
  712,  770,  792,  857,  930,  979,  995, 1005, 1038, 1043,
 1066, 1104, 1167, 1270, 1301, 1381, 1414, 1442, 1452, 1458,
 1498, 1545, 1593, 1626, 1631, 1666, 1674, 1776, 1790, 1802,
 1808, 1815, 1971, 2003, 2040, 2053, 2064, 2083, 2126, 2137,
 2264, 2277, 2308, 2312, 2339, 2364, 2400, 2430, 2538, 2565,
 2608, 2634, 2714, 2742, 2753, 2763, 2775, 2789, 2848, 3085,
 3089, 3094, 3123, 3180, 3194, 3198, 3211, 3223, 3296, 3303,
 3344, 3356, 3376, 3381, 3408, 3458, 3464, 3498, 3512, 3529,
 3539, 3555, 3559, 3620, 3807, 3850, 3861, 3869, 3905, 3928,
 3971, 3996, 4079, 4087, 4149, 4166, 4258, 4320, 4376, 4430,
 4461, 4517, 4563, 4582, 4636, 4648, 4674, 4688, 4713, 4718,
 4732, 4758, 4767, 4802, 4808, 4863, 4888, 4913, 4927, 4930,
 4943, 5030, 5074, 5208, 5214, 5238, 5243, 5278, 5286, 5392,
 5443, 5447, 5453, 5533, 5540, 5581, 5655, 5664, 5687, 5704,
 5764, 5770, 5867, 5915, 5972, 5986, 5996, 6001, 6012, 6024,
 6034, 6064, 6099, 6169, 6198, 6275, 6286, 6349, 6376, 6438,
 6450, 6454, 6460, 6495, 6587, 6619, 6661, 6674, 6680, 6735,
 6797, 6807, 6820, 6884, 6915, 6921, 6962, 6976, 7129, 7146,
 7178, 7185, 7213, 7325, 7329, 7382, 7388, 7423, 7445, 7454,
 7584, 7607, 7630, 7681, 7819, 7834, 7840, 7885, 7893, 7928,
 7932, 7939, 7986, 7994, 8000, 8071, 8106, 8110, 8137, 8168,
 8197, 8266, 8345, 8363, 8406, 8417, 8463, 8475, 8481, 8505,
 8526, 8558, 8588, 8645, 8670, 8735, 8870, 8961, 9086, 9095,
 9107, 9125, 9164, 9183, 9217, 9264, 9306, 9333, 9338, 9342,
 9359, 9381, 9418, 9426, 9562, 9603, 9645, 9650, 9661, 9681,
 9692, 9699, 9709, 9751, 9819, 9833, 9915,10005,10050,10184,
10212,10247,10286,10296,10313,10317,10379,10447,10497,10533,
10582,10591,10610,10620,10633,10649,10656,10707,10767,10852,
10867,10911,11035,11081,11138,11157,11175,11181,11185,11215,
11220,11246,11253,11258,11267,11333,11363,11395,11433,11473,
11485,11492,11545,11575,11720,11742,11790,11795,11840,11851,
11870,11917,11931,11966,12013,12048,12054,12115,12155,12169,
12195,12214,12232,12291,12340,12376,12415,12452,12523,12528,
12629,12634,12700,12710,12749,12763,12874,12931,12945,12952,
12959,12979,12989,13155,13158,13162,13166,13189,13198,13213,
13219,13269,13289,13296,13309,13321,13441,13563,13662,13688,
13699,13713,13764,13899,13936,13949,13979,14027,14039,14044,
14051,14153,14159,14251,14268,14305,14316,14322,14356,14452,
14469,14488,14525,14545,14600,14640,14657,14753,14809,14819,
14828,14860,14867,14918,14936,14982,14990,14993,15032,15078,
15130,15281,15288,15414,15423,15486,15502,15508,15552,15573,
15634,15641,15644,15659,15710,15714,15750,15786,15813,15867,
15877,15984,16011,16031,16050,16129,16139,16145,16157,16163,
16188,16211,16256,16263,16422,16480,16539,16577,16650,16654,
16713,16793,16819,16897,16918,16931,16939,16952,16971,16974,
17003,17019,17044,17051,17185,17191,17291,17326,17330,17418,
17542,17553,17571,17633,17683,17691,17719,17738,17749,17775,
17783,17793,17797,17856,17890,17918,17946,18004,18008,18071,
18115,18187,18252,18281,18290,18336,18436,18493,18510,18543,
18555,18560,18592,18653,18696,18715,18778,18782,18869,18898,
18914,18920,18934,19027,19054,19135,19148,19152,19204,19284,
19322,19365,19402,19421,19427,19452,19456,19539,19599,19626,
19673,19689,19737,19794,19800,19852,19870,19875,19886,19894,
19907,20008,20016,20105,20114,20161,20175,20191,20218,20231,
20242,20456,20468,20492,20504,20516,20552,20589,20637,20671,
20705,20737,20762,20772,20789,20991,21009,21039,21073,21130,
21138,21153,21167,21221,21339,21389,21439,21446,21450,21466,
21525,21546,21592,21598,21621,21705,21712,21764,21817,21888,
21960,22016,22028,22035,22047,22086,22130,22136,22145,22185,
22189,22350,22372,22397,22407,22424,22497,22526,22550,22581,
22661,22698,22729,22814,22898,22904,22929,22959,22974,22993,
23078,23172,23191,23205,23249,23253,23262,23306,23333,23339,
23369,23493,23501,23516,23545,23578,23620,23628,23641,23654,
23660,23668,23710,23870,23908,23920,23935,23950,23955,24010,
24030,24116,24122,24136,24210,24265,24355,24424,24428,24473,
24479,24497,24541,24576,24579,24598,24610,24625,24641,24703,
24719,24727,24825,24848,24854,24930,24966,24990,25003,25057,
25064,25106,25179,25243,25264,25285,25413,25464,25484,25541,
25572,25587,25594,25610,25613,25665,25687,25691,25701,25738,
25744,25761,25974,26002,26022,26033,26057,26068,26079,26137,
26140,26157,26173,26176,26181,26202,26206,26242,26404,26419,
26425,26447,26658,26724,26728,26742,26768,26814,26895,26930,
26969,27024,27032,27077,27130,27137,27176,27189,27205,27273,
27290,27294,27305,27316,27335,27371,27420,27477,27547,27557,
27596,27622,27728,27770,27776,27851,27886,27950,28000,28045,
28107,28121,28131,28164,28177,28185,28226,28241,28282,28342,
28372,28444,28448,28466,28480,28496,28517,28528,28614,28644,
28681,28735,28827,28889,28914,28920,28993,29054,29088,29130,
29199,29258,29331,29340,29416,29420,29430,29503,29537,29573,
29576,29591,29598,29628,29653,29672,29698,29713,29779,29809,
29850,29869,29925,29980,29987,30022,30030,30090,30184,30241,
30256,30262,30273,30341,30397,30417,30459,30482,30489,30578,
30667,30686,30737,30744,30763,30785,30790,30827,30838,30883,
30921,30941,31011,31016,31107,31119,31159,31182,31191,31198,
31360,31393,31414,31419,31489,31498,31522,31529,31601,31629,
31637,31730,31752,31815,31835,31839,31889,31955,31996,32001,
    5,   33,   61,   69,   87,  157,  194,  221,  242,  311,
  319,  353,  402,  410,  420,  467,  508,  517,  523,  527,
  590,  623,  642,  650,  655,  668,  675,  681,  686,  723,
  774,  778,  810,  820,  824,  838,  884,  898,  919,  922,
  926,  960,  982,  999, 1022, 1056, 1098, 1156, 1180, 1184,
 1201, 1211, 1226, 1239, 1244, 1273, 1279, 1286, 1387, 1409,
 1426, 1445, 1455, 1468, 1490, 1504, 1509, 1548, 1561, 1589,
 1614, 1641, 1652, 1677, 1686, 1734, 1744, 1749, 1763, 1884,
 1921, 1950, 1962, 1975, 1990, 2013, 2018, 2028, 2049, 2056,
 2080, 2150, 2158, 2170, 2179, 2201, 2215, 2225, 2236, 2315,
 2322, 2332, 2367, 2378, 2388, 2422, 2445, 2453, 2511, 2518,
 2528, 2547, 2574, 2604, 2641, 2653, 2659, 2690, 2694, 2727,
 2769, 2780, 2786, 2811, 2816, 2819, 2841, 2924, 2928, 2936,
 2940, 2952, 2984, 2994, 2999, 3015, 3022, 3072, 3081, 3107,
 3157, 3167, 3233, 3289, 3292, 3328, 3332, 3341, 3353, 3411,
 3420, 3461, 3469, 3475, 3503, 3509, 3562, 3584, 3589, 3593,
 3684, 3707, 3719, 3758, 3763, 3769, 3790, 3797, 3800, 3840,
 3872, 3884, 3915, 3921, 3931, 3934, 3940, 4002, 4038, 4047,
 4055, 4059, 4072, 4083, 4100, 4118, 4136, 4157, 4177, 4243,
 4286, 4302, 4332, 4338, 4346, 4353, 4361, 4381, 4419, 4426,
 4453, 4472, 4534, 4557, 4631, 4640, 4656, 4668, 4680, 4692,
 4698, 4702, 4707, 4741, 4762, 4816, 4853, 4868, 4875, 4964,
 5004, 5027, 5036, 5099, 5108, 5113, 5129, 5138, 5143, 5152,
 5184, 5190, 5203, 5211, 5225, 5234, 5264, 5270, 5275, 5309,
 5325, 5433, 5439, 5475, 5489, 5507, 5524, 5576, 5590, 5600,
 5615, 5642, 5672, 5677, 5707, 5721, 5797, 5812, 5829, 5882,
 5889, 5919, 5924, 5953, 5967, 5980, 5993, 6031, 6037, 6045,
 6068, 6086, 6096, 6102, 6201, 6207, 6210, 6233, 6240, 6243,
 6249, 6270, 6340, 6345, 6475, 6491, 6498, 6546, 6550, 6555,
 6559, 6571, 6575, 6580, 6603, 6608, 6638, 6649, 6720, 6755,
 6758, 6776, 6788, 6792, 6836, 6847, 6868, 6924, 6996, 7007,
 7014, 7048, 7053, 7056, 7069, 7126, 7165, 7193, 7210, 7228,
 7236, 7265, 7300, 7303, 7310, 7314, 7344, 7354, 7361, 7366,
 7374, 7394, 7408, 7417, 7449, 7462, 7514, 7523, 7533, 7542,
 7571, 7604, 7625, 7690, 7711, 7719, 7756, 7780, 7786, 7811,
 7826, 7888, 7923, 7935, 7943, 7963, 7966, 8023, 8035, 8068,
 8092, 8144, 8175, 8182, 8200, 8206, 8220, 8279, 8304, 8310,
 8342, 8354, 8380, 8403, 8448, 8467, 8484, 8488, 8492, 8514,
 8517, 8523, 8530, 8568, 8576, 8606, 8648, 8701, 8731, 8742,
 8755, 8772, 8778, 8792, 8803, 8835, 8857, 8883, 8890, 8920,
 8937, 8940, 8956, 8977, 9036, 9040, 9045, 9056, 9070, 9078,
 9104, 9173, 9180, 9244, 9257, 9284, 9291, 9310, 9313, 9327,
 9348, 9352, 9414, 9492, 9511, 9523, 9554, 9569, 9623, 9635,
 9639, 9657, 9664, 9671, 9720, 9740, 9804, 9808, 9824, 9844,
 9870, 9879, 9918, 9922, 9957, 9990,10013,10031,10058,10078,
10082,10090,10096,10119,10128,10133,10141,10177,10194,10201,
10219,10234,10238,10244,10261,10293,10329,10337,10422,10460,
10471,10500,10598,10625,10667,10682,10686,10717,10752,10756,
10761,10781,10787,10795,10799,10829,10834,10864,10871,10892,
10896,10902,10962,10968,11001,11013,11031,11047,11078,11098,
11149,11188,11234,11264,11297,11356,11360,11388,11391,11400,
11404,11421,11464,11469,11476,11520,11530,11537,11561,11606,
11621,11627,11632,11636,11644,11652,11671,11733,11763,11808,
11832,11867,11874,11909,11948,11952,11971,11985,11993,12008,
12120,12132,12135,12151,12166,12226,12238,12288,12299,12304,
12318,12363,12372,12381,12385,12403,12412,12427,12435,12487,
12538,12545,12559,12581,12588,12592,12600,12614,12638,12641,
12692,12706,12726,12734,12744,12777,12816,12867,12880,12888,
12895,12909,12914,12986,13016,13125,13142,13186,13194,13222,
13254,13274,13285,13312,13324,13339,13345,13361,13365,13396,
13403,13451,13458,13493,13498,13523,13567,13583,13600,13646,
13665,13675,13680,13703,13719,13733,13741,13753,13767,13783,
13826,13832,13849,13863,13886,13902,13918,13929,13941,13970,
13988,14036,14067,14070,14156,14175,14213,14224,14239,14245,
14274,14292,14298,14308,14336,14361,14401,14427,14446,14473,
14504,14511,14532,14557,14604,14613,14633,14650,14654,14671,
14686,14710,14713,14729,14741,14756,14893,14898,14926,15007,
15014,15029,15046,15066,15074,15103,15107,15121,15170,15176,
15187,15210,15217,15234,15248,15253,15273,15291,15307,15328,
15332,15372,15385,15394,15406,15436,15455,15460,15511,15516,
15580,15612,15624,15663,15668,15688,15747,15759,15775,15781,
15795,15847,15874,15888,15944,15992,15999,16016,16026,16054,
16075,16084,16149,16195,16214,16227,16249,16253,16291,16344,
16362,16365,16428,16432,16470,16474,16477,16516,16525,16528,
16550,16563,16567,16583,16588,16593,16607,16617,16642,16645,
16658,16678,16735,16764,16790,16804,16830,16903,16916,16944,
16964,16988,17013,17016,17032,17036,17055,17114,17153,17171,
17200,17240,17251,17283,17297,17313,17317,17321,17333,17338,
17341,17352,17375,17389,17411,17425,17485,17495,17550,17560,
17577,17597,17622,17637,17673,17693,17712,17780,17800,17805,
17818,17862,17895,17908,17949,17954,17958,17978,18001,18015,
18080,18092,18105,18112,18156,18161,18175,18180,18211,18242,
18255,18259,18267,18276,18310,18314,18320,18324,18328,18358,
18396,18454,18478,18526,18532,18538,18569,18582,18597,18633,
18679,18745,18758,18766,18770,18822,18828,18842,18849,18866,
18879,18883,18892,18930,18941,19024,19045,19048,19051,19066,
19088,19118,19138,19170,19201,19223,19271,19287,19291,19296,
19306,19316,19351,19356,19424,19440,19494,19525,19530,19551,
19592,19637,19651,19662,19666,19697,19728,19789,19797,19803,
19821,19832,19837,19849,19862,19897,19901,19926,19972,20005,
20033,20064,20070,20109,20123,20130,20134,20167,20189,20211,
20251,20289,20294,20318,20370,20375,20386,20394,20421,20431,
20460,20464,20471,20476,20495,20500,20555,20600,20605,20617,
20627,20632,20740,20784,20803,20813,20835,20866,20874,20890,
20943,20948,20959,20968,21014,21023,21032,21036,21043,21063,
21093,21144,21164,21171,21180,21211,21240,21243,21271,21313,
21319,21348,21382,21454,21459,21470,21473,21517,21534,21560,
21568,21578,21614,21634,21700,21735,21743,21775,21779,21794,
21799,21803,21810,21821,21833,21848,21922,21941,21946,21950,
21979,22021,22051,22093,22098,22102,22105,22125,22150,22167,
22174,22200,22223,22236,22281,22301,22311,22347,22355,22384,
22421,22438,22466,22512,22516,22531,22561,22587,22610,22618,
22626,22671,22692,22747,22757,22764,22770,22786,22790,22794,
22867,22874,22907,22912,22926,22968,22990,23047,23052,23063,
23072,23085,23111,23124,23128,23135,23143,23196,23199,23234,
23273,23286,23298,23349,23357,23380,23458,23484,23504,23522,
23534,23553,23568,23587,23625,23644,23665,23701,23730,23751,
23755,23767,23824,23828,23854,23879,23883,23898,23916,23927,
23965,24002,24006,24024,24036,24042,24057,24064,24068,24097,
24104,24131,24165,24243,24270,24274,24317,24337,24341,24352,
24399,24412,24416,24439,24444,24469,24476,24484,24490,24522,
24538,24584,24691,24696,24710,24779,24793,24805,24838,24845,
24878,24899,24909,24978,25006,25011,25024,25033,25048,25084,
25109,25125,25155,25173,25186,25192,25211,25247,25253,25280,
25305,25310,25352,25358,25399,25423,25427,25452,25461,25481,
25505,25565,25581,25598,25623,25635,25640,25650,25683,25730,
25747,25752,25777,25795,25799,25821,25850,25853,25860,25871,
25927,25958,25962,26029,26073,26143,26170,26190,26251,26269,
26276,26315,26320,26326,26339,26356,26388,26392,26409,26422,
26431,26439,26450,26499,26539,26544,26563,26567,26570,26588,
26593,26608,26628,26646,26662,26695,26707,26715,26751,26790,
26795,26811,26842,26904,26912,26975,27020,27038,27041,27074,
27084,27110,27119,27127,27150,27157,27187,27193,27208,27220,
27326,27332,27338,27346,27375,27389,27394,27471,27490,27499,
27544,27554,27600,27609,27619,27655,27666,27702,27707,27742,
27765,27782,27786,27805,27840,27863,27866,27870,27878,27890,
27904,27912,27917,27943,27947,27965,27990,28036,28073,28099,
28114,28146,28174,28233,28258,28279,28310,28346,28353,28386,
28436,28462,28486,28507,28511,28520,28553,28575,28582,28621,
28625,28632,28668,28684,28706,28741,28748,28763,28830,28840,
28854,28866,28909,28917,28944,28949,28996,29001,29035,29041,
29072,29076,29094,29122,29144,29155,29205,29218,29242,29254,
29271,29276,29290,29296,29304,29308,29343,29403,29423,29439,
29452,29510,29513,29518,29542,29580,29585,29635,29648,29664,
29797,29802,29834,29859,29876,29908,29914,29918,29955,29984,
30004,30008,30015,30035,30039,30054,30058,30073,30077,30084,
30103,30151,30158,30166,30287,30306,30347,30354,30362,30382,
30403,30408,30428,30446,30451,30472,30501,30530,30559,30563,
30582,30587,30604,30629,30654,30683,30741,30760,30805,30816,
30851,30864,30869,30959,30993,31003,31027,31033,31072,31110,
31116,31156,31165,31175,31179,31211,31215,31239,31244,31260,
31270,31327,31333,31340,31363,31398,31425,31448,31506,31513,
31516,31545,31567,31573,31577,31614,31620,31634,31702,31728,
31734,31785,31795,31800,31818,31842,31880,31886,31911,31916,
31937,31947,31964,31968,31972,31982,32016,32023,32038,
0};
static const gx_device_halftone_resource_t res_2 = {
    "Magenta", 3, 167, 167, 256, levels_2, bit_data_2, 2
};

/* StochasticDefault.Yellow */
static const unsigned int levels_3[] = {
    0,   59,  117,  171,  227,  288,  348,  407,  466,  526,
  584,  641,  698,  755,  818,  881,  934,  988, 1043, 1099,
 1152, 1205, 1260, 1314, 1366, 1417, 1469, 1520, 1579, 1641,
 1704, 1764, 1817, 1869, 1918, 1968, 2026, 2086, 2151, 2215,
 2277, 2331, 2380, 2430, 2480, 2532, 2594, 2654, 2712, 2770,
 2830, 2882, 2932, 2983, 3034, 3094, 3164, 3230, 3298, 3376,
 3431, 3480, 3532, 3586, 3638, 3689, 3752, 3832, 3887, 3944,
 4006, 4064, 4111, 4158, 4245, 4330, 4414, 4491, 4545, 4599,
 4671, 4789, 4900, 4955, 4997, 5039, 5081, 5123, 5171, 5225,
 5364, 5454, 5517, 5575, 5633, 5692, 5788, 5940, 6034, 6083,
 6132, 6184, 6236, 6296, 6358, 6426, 6510, 6594, 6663, 6780,
 6821, 6861, 6899, 6931, 6964, 6996, 7028, 7061, 7093, 7144,
 7216, 7515, 7687, 7806, 7881, 7955, 8016, 8066, 8157, 8239,
 8292, 8360, 8440, 8524, 8886, 9045, 9207, 9263, 9308, 9338,
 9367, 9396, 9428, 9461, 9494, 9537, 9599,10003,10129,10247,
10352,10431,10497,10574,10649,10723,10803,10884,11016,11231,
11300,11356,11409,11460,11543,11933,11988,12043,12099,12155,
12211,12276,12359,12442,12525,13024,13104,13162,13211,13264,
13320,13418,13650,13769,13889,13986,14047,14103,14159,14214,
14382,14647,14822,15022,15162,15268,15375,15485,15612,15750,
15836,15940,16051,16290,16421,16533,16657,16794,17063,17146,
17232,17303,17353,17410,17484,17558,18253,18697,18798,18894,
19014,19326,19441,19559,20083,20163,20241,20304,20462,20814,
20915,20979,21046,21117,21214,21316,21452,22095,22230,22332,
22432,22625,23011,23235,23384,23540,23707,23949,24107,24306,
24670,25326,25442,25557,26440,27889,
0};
static const unsigned short bit_data_3[] = {
  114,  208, 1784, 2626, 3277, 3297, 4139, 4384, 4685, 6191,
 6475, 6750, 7020, 7104, 7800, 8709, 9266,10072,10590,11099,
11149,12163,12222,12902,13538,14094,14209,14533,15121,15277,
16187,16903,17303,18319,18910,19149,19816,20165,20618,20839,
21947,22488,22626,23152,23177,24036,25742,26174,26243,26403,
27036,28150,28625,28697,29031,31296,31356,31957,32022, 1184,
 1226, 2422, 2587, 2841, 3460, 4078, 5634, 5963, 6269, 6295,
 6428, 8660, 8681, 8791, 8912, 9160, 9415,10633,10667,11255,
11853,12528,12565,13213,13653,15833,16006,16862,17208,17315,
18109,18152,18751,18775,18868,19703,19801,21651,22938,22972,
23625,23697,23857,24933,25224,25451,27295,27527,28360,28566,
29245,29568,29864,30367,30954,31623,31775,  333,  625, 1346,
 1837, 2902, 2945, 3592, 4308, 4346, 4706, 5014, 5029, 6584,
 7369, 7972,10342,10513,11617,12290,13168,13202,13889,14332,
14453,15568,15717,16038,16659,17132,18829,19936,20248,20787,
21060,22697,23112,23527,24526,24538,25243,25541,25581,25653,
26384,27312,27409,27514,28039,29508,29684,30600,30730,30933,
31418,  680,  833, 1694, 2573, 2979, 4946, 5045, 5489, 6302,
 6760, 7692, 7812, 8558, 8669, 8698, 8998, 9147, 9503,10019,
10617,10879,11737,13447,13852,14709,15013,15516,15826,16641,
16815,17560,17612,18209,18656,19118,20035,21312,21422,21523,
22163,22234,22323,23832,23940,24637,25173,26660,28322,28468,
29018,29340,29844,30093,30430,31183,32029,   41, 1237, 1476,
 1685, 2343, 2544, 3045, 3130, 3991, 4829, 4928, 5158, 6993,
 7128, 7361, 7630, 8150, 9183, 9809, 9894,10641,11009,12129,
13192,13870,14298,14881,15178,15306,15388,15423,16176,18282,
18433,18693,18950,20050,20112,20411,20579,20660,21024,21512,
21763,23235,24851,24896,24991,25780,26237,26255,26708,26967,
27301,27586,27759,28685,29118,29254,29814,31596,   32,  217,
  697, 1160, 1436, 1553, 2139, 2252, 3216, 3546, 3766, 4173,
 4238, 5051, 5460, 5640, 6737, 6817, 7254, 7537,10115,10418,
10950,11059,11079,11176,11490,11993,12305,12752,12923,13366,
13514,14313,14554,17380,17547,17720,18642,18650,20122,20862,
21741,21813,22800,23293,23775,23826,24090,24427,24502,25481,
25884,28385,28653,29196,29525,30785,31074,31543,  267, 1772,
 2376, 2813, 2989, 3306, 3347, 3524, 5129, 5958, 6441, 6659,
 7643, 7716, 7875, 8349, 9330, 9363,10010,11764,12057,14829,
14857,15190,15292,16354,17252,17374,17864,18738,18902,19301,
19981,20876,21198,21337,21992,22497,23713,24265,24495,24780,
24918,25250,26143,26371,26882,27194,27275,27478,27537,27942,
28524,29616,29781,30254,30273,30483,30837,    5, 1481, 1599,
 1635, 2121, 3124, 4060, 4702, 4996, 5148, 5286, 5777, 5789,
 6222, 6645, 7456, 7546, 7999, 9479, 9643,10389,10844,11429,
11962,12228,12382,12408,12588,12878,12893,13027,13883,14294,
15821,16087,16552,16627,16840,16910,16962,19070,19393,19632,
19904,21081,21132,21351,21821,21979,22178,22904,23107,25683,
27547,29383,29794,30810,31140,32001,  529,  634,  895, 1074,
 1120, 4096, 5421, 5496, 6098, 8511, 8551, 8845, 8974,10335,
11372,11667,12295,12744,14246,14349,14358,14369,14417,15797,
15942,16060,16339,16654,17330,17619,19469,19616,19988,20459,
22022,22347,23191,23350,24386,24450,24631,25381,26138,26187,
26416,26589,27188,27403,27841,27881,27907,28253,28943,29282,
29840,30298,30543,30959,31205,31246,  484, 1040, 1380, 1750,
 2195, 2848, 4050, 4145, 4164, 4423, 4676, 5893, 5988, 6039,
 6144, 6205, 7385, 7895, 7914, 8524, 9058, 9943,10046,10094,
10829,11794,12993,13100,13158,14704,15876,16349,16588,16597,
17793,17975,18204,18854,19676,19913,20705,20992,22219,22273,
23147,23246,23262,24412,24487,26454,26536,26794,28159,28833,
29306,30555,30653,31367,  164,  477,  813, 1487, 1656, 2408,
 3723, 4197, 4266, 4281, 5081, 5291, 6004, 6790, 6920, 7408,
 8392, 8496, 9717, 9726, 9875,10316,10570,11136,11787,12019,
12824,14240,14789,15044,16221,17089,17871,17924,18145,18287,
19400,19515,20215,20765,21399,21474,23552,23955,24138,25084,
26362,26389,26694,28093,28802,29657,30020,30112,30534,30586,
31694,  684,  780,  986, 1112, 1587, 2045, 2083, 2180, 2451,
 3421, 4056, 5859, 7227, 7442, 7708, 8225, 8648, 8795, 9110,
 9849,11345,11357,11819,12350,13686,13765,14218,14650,15477,
16033,16235,16567,17624,17773,18377,19167,19464,20782,21191,
22288,22593,23077,24164,24479,25892,26348,26549,27013,27662,
28106,28185,28500,29486,30825,30996,31448,31538,  577,  645,
 2510, 2888, 3369, 3395, 3746, 3875, 3890, 4951, 5729, 6169,
 7400, 7434, 7926, 9431, 9603, 9860,10683,10850,11364,12256,
12692,12725,12811,13150,13338,13797,13894,15594,16482,16729,
17691,17940,19499,19732,20261,21345,22280,22543,22579,22703,
23894,24582,24593,24655,25201,26123,26250,27553,28665,29321,
29801,30413,30472,31235,31517,   61,  437,  516,  612, 1841,
 2116, 2909, 4350, 4723, 5456, 5902, 7571, 8771, 8932, 9678,
10222,12108,12330,13373,13522,13937,14426,14867,14912,16076,
16574,17000,17405,17606,18193,18437,19447,19628,19909,20079,
20752,20883,21048,21203,22621,22753,23480,24902,24926,25219,
25422,25830,25991,26616,26982,27425,27508,27866,28369,28529,
29347,29392,30386,30436,30530,31218,31507,31771,   80, 2146,
 2515, 2632, 3158, 3186, 3986, 4680, 5005, 6255, 7147, 7412,
 7698, 7748, 8097, 8229, 8403, 8566,10023,10312,11032,11092,
11783,12041,13122,13281,13738,14948,15025,15127,15261,16130,
16522,16966,17511,17587,17695,18330,19172,19222,20065,20738,
21724,21749,22144,22420,22869,23277,24313,24807,25073,25178,
25209,25239,26530,27329,27997,28260,28702,28902,29643,30206,
31799,   67, 1192, 1432, 2074, 2358, 2749, 3193, 3358, 5470,
 5694, 5800, 6772, 6946, 7581, 7688, 9133, 9473, 9498, 9947,
10993,11054,11389,12196,12815,13442,13590,13644,14421,15270,
17359,18121,18554,18898,20583,21178,21454,21853,22585,23309,
23760,24108,25487,25689,25747,26703,27150,27606,28052,28548,
29057,31305,31635,31818,  980, 2207, 2540, 3657, 3726, 4520,
 5126, 5425, 5590, 5630, 6410, 7039, 7566, 8379, 9630, 9804,
 9890,10563,10968,11457,12695,14112,14161,14250,14463,15053,
15328,15393,15857,16474,17107,18489,19647,19891,20872,20950,
21212,22189,22476,22931,24224,25822,26463,27006,27693,27927,
28346,28426,29469,29597,30263,31069,31725,31783,  712,  733,
 1276, 1414, 1449, 1549, 1613, 2086, 3212, 4121, 4188, 4449,
 5915, 6855, 6882, 6926, 6973, 9654, 9743,10147,10295,11413,
11715,13297,13754,15254,16441,17536,18069,18083,18101,18914,
18963,19163,19812,20361,20901,21413,21827,22341,23398,23580,
23655,23869,24052,25407,25850,26113,26221,28485,28850,30295,
30759,31512,31613,  470, 1596, 3098, 3145, 3221, 3687, 3901,
 4418, 5326, 6457, 6807, 6915, 7204, 8272, 8486, 8885, 9291,
 9706,10630,12124,12748,13334,13769,15565,15888,15974,16563,
16602,16785,17483,17667,18562,19420,19478,19600,20666,21578,
21701,22684,22942,23921,23959,24014,24069,24124,24291,25474,
26008,26711,26834,27755,28364,29110,29713,31372,31841,  864,
 1107, 3703, 3810, 4841, 5009, 5384, 6403, 6550, 8135, 8204,
 8473, 8562, 9541,11486,11643,11952,12016,12200,12453,13791,
14116,15107,15418,16151,16173,16803,17629,18538,18863,18934,
20239,21084,21930,22308,22790,24431,25121,25546,25959,26543,
26611,27100,27145,28880,29013,29962,30117,30190,30354,30774,
31301,31362,   11,  111,  213,  693, 2211, 3773, 4535, 4911,
 5524, 5792, 7789, 8642, 8685, 8730, 9468,10664,10894,11156,
11190,11943,12873,13265,13476,13761,13979,15169,15688,16193,
17340,17423,19266,19543,19916,20637,21817,22935,22951,23283,
23564,23814,24406,26941,27208,27462,28004,28960,29818,29977,
30450,30469,30615,30817,31521,  605, 1951, 2008, 2255, 2415,
 2577, 3089, 3310, 3457, 3750, 4304, 4865, 5154, 5876, 6245,
 6862, 6959, 7066, 7933, 7968, 8144, 9254,10098,10383,10595,
10603,11287,11791,12435,14125,14133,14606,14814,15288,17027,
18404,18699,19050,19205,20133,20230,21361,21425,22524,24076,
24907,25064,25617,29077,29145,29290,29606,29885,30672,31910,
  346,  581, 1315, 1391, 2437, 2723, 3911, 4468, 4552, 4633,
 5452, 5698, 6008, 6225, 8216, 8575, 9042, 9379,10076,11268,
11395,12444,12596,13310,14283,15222,15871,16393,16855,18380,
18443,18497,18534,20209,20437,20483,20501,20570,21227,21791,
22052,22099,22223,23048,23394,25569,26054,26976,27033,27873,
27918,28125,29420,29764,  125, 1013, 1664, 2368, 2461, 3477,
 6187, 6307, 8222, 9722,10182,11530,11611,12603,13081,13289,
14022,14289,15082,15117,15379,16094,16812,16926,17709,17980,
18141,19330,20414,21163,21710,21776,23065,23353,24664,24913,
25153,25595,25943,25969,26949,27128,27184,27772,28080,29121,
29324,29859,30024,31023,31050,31384,   98,  462,  784, 1831,
 2498, 2611, 3950, 5116, 5866, 5897, 6047, 6731, 6867, 6988,
 7519, 8928, 8938, 9546,10621,11925,12614,12933,13581,13874,
14824,15066,15432,15892,16335,16607,16677,17584,18072,18542,
19098,19643,20995,21656,23266,23489,24319,25077,25578,27214,
27238,27474,27540,28087,28288,29105,31942,    0,   58,  858,
 1461, 1561, 4126, 4569, 4694, 4810, 4847, 5216, 5659, 5763,
 9242, 9263,10253,10519,10655,11360,12577,12728,12762,12868,
13725,14536,15365,15598,16053,17441,19880,20317,20384,20742,
20983,22192,22660,23172,23709,24057,24844,25696,27112,27781,
28421,28440,28622,28773,29065,29238,30417,30563,30873,   47,
 1100, 1411, 1809, 2263, 3200, 4453, 6949, 7124, 7235, 7349,
 7918, 8129, 8170, 8208, 8267, 8915, 9345,10303,10644,10912,
11083,14468,14558,15577,16454,16637,17142,17174,19152,20093,
20563,20656,21248,21448,21920,21975,23658,24202,24349,24803,
24876,25168,25842,26408,26698,26970,27575,28329,29632,31040,
  534,  617, 1070, 1994, 2553, 2617, 2891, 4559, 4669, 5254,
 5402, 5432, 6420, 6450, 7651, 8837, 9372,10229,10433,10587,
10916,11432,12707,13326,13356,13848,14521,15458,15619,15967,
16943,18005,18278,18824,19218,19473,19636,22128,22565,23002,
23188,23250,23732,24274,24707,25013,25825,25855,26770,27982,
28572,28650,29895,30494,30886,30937,31117,31198,31824,  134,
  740, 1157, 1862, 2163, 2328, 2603, 2757, 2918, 2982, 3678,
 4372, 6158, 6491, 7006, 7032, 7961, 7988, 8312, 8904, 9143,
 9940,10578,11193,11209,11719,12049,12831,14547,15440,15754,
15853,16021,16516,16741,17352,17577,18653,19336,19404,20043,
20825,21719,22326,22344,22590,22989,23331,23810,24645,25247,
25756,25975,26117,26457,27763,28947,29215,30059,30378,30781,
30788,  107,  659, 1022, 1439, 1769, 2584, 3609, 3978, 4037,
 4436, 4740, 4881, 5720, 6784, 7301, 7527, 9422,10673,11832,
11949,12033,12777,13222,13402,13841,14336,14449,14695,14818,
15037,16843,17371,18022,18066,18201,18322,18356,18373,19067,
19236,19313,19488,19969,20205,20279,20688,21373,21732,22571,
22720,23836,24327,25454,25686,25796,26321,26924,29774,30043,
30266,31032,31060,31569,  393,  649,  791, 1209, 1307, 2782,
 2885, 3190, 3234, 3344, 3969, 4516, 5110, 5282, 5732, 6022,
 6163, 6252, 7131, 7816, 8779, 9055, 9600, 9866,10469,10598,
11584,11959,12246,12592,13305,14686,15905,16822,16954,17051,
17905,18888,19997,20625,20836,22048,22822,23689,24532,24969,
25003,25273,25428,26568,26725,26752,26818,26828,27368,29262,
29916,30358,31135,31156,  121,  608, 1253, 1874, 3313, 3327,
 3663, 3734, 4844, 4959, 6273, 7069, 7946, 8115, 8893, 8977,
10016,10501,11654,11989,12704,12736,13171,13188,15657,16207,
17478,18148,18785,18940,20586,21270,21451,22774,23120,23445,
24476,25611,26931,27029,27289,27422,27851,28455,28541,28669,
29001,29126,29478,29811,29855,31587,31924,   64,  353, 1936,
 4748, 6369, 6823, 7804, 8898, 9319, 9428, 9760, 9801, 9841,
10522,11216,11231,11727,11877,13584,14051,14373,14600,15090,
15110,15602,17296,17362,17609,19112,21328,22423,22508,23007,
23722,24161,24626,24792,25253,25868,26011,26274,27364,27987,
28114,28532,29400,30668,30795,30828,31529,31604,31643,  898,
 2172, 2720, 3206, 3568, 4235, 4298, 4856, 4908, 6344, 6364,
 6885, 7695, 7830, 9117, 9257,11280,12132,12169,13470,13675,
13908,14072,14280,15124,15705,15992,17377,17514,18124,18327,
18575,18647,19461,20183,21752,21898,22016,23051,23493,23548,
23726,26524,27106,27459,28488,29028,31122,31945,   28,  282,
  330, 1734, 2050, 2272, 3026, 5882, 6480, 6810, 7160, 7984,
 8194, 8339, 8611, 9368, 9519,10990,11439,12798,12947,12984,
13927,14992,15865,16388,16725,16929,17041,19939,20062,21236,
21244,21279,21965,22366,23511,23559,24064,25308,25928,26229,
26573,27180,29241,29687,29696,29873,30499,31682, 1318, 1372,
 1766, 1967, 2012, 2042, 3149, 3480, 3598, 3769, 4100, 5377,
 5411, 5418, 5463, 6577, 6979, 7393, 8070, 9034, 9685,10677,
11453,13068,13319,14809,15588,16614,17216,18077,18160,18175,
18895,19739,20212,20556,21506,21767,21927,22408,22901,23662,
24231,25478,26619,27531,27550,27610,27784,28829,28997,29039,
29536,30181,30230,30439,31047,31359,  688, 1932, 2057, 3127,
 4465, 4579, 4891, 6340, 6587, 6831, 6996, 8084, 8094, 8354,
 8483, 8663, 9272,10007,10064,11139,11675,11806,12429,12506,
12771,12915,13013,13794,14680,14940,15041,16170,17115,17594,
18590,18668,18678,19008,19316,19673,20417,20487,20504,21342,
21410,21609,22302,23648,24499,24832,25156,26003,26258,27517,
28048,29080,29395,29443,29720,29959,   55,  236,  912, 2036,
 2191, 2389, 3564, 3691, 5390, 5486, 5534, 5627, 5707, 5863,
 6028, 6278, 7975, 8389, 9150,10055,10455,10804,10882,10953,
11206,12367,12524,13720,13950,14078,14539,14594,15646,16102,
16140,16239,16970,17539,19518,19683,19727,19786,20090,20621,
20653,21568,22106,22226,22359,22674,22766,23769,24102,25728,
25985,26631,27890,28162,28517,28909,29266,29898,30199,31600,
31687,  294, 1195, 1273, 1354, 1939, 2593, 2659, 3227, 5396,
 5521, 6071, 6208, 6374, 6678, 7430, 7533, 7873, 9102, 9356,
10026,10080,10235,10299,11162,11754,13647,14700,14864,15400,
15693,15765,16066,16792,17723,17868,18448,18581,19042,22198,
23115,23323,23377,23927,24212,24826,25007,25102,25763,26025,
26400,26432,27427,27583,27930,28256,28746,29158,30348,30573,
31249,31572,31593,31715,31821,   18,  508,  844, 1259, 1676,
 1990, 2431, 2830, 3621, 3893, 4063, 4149, 5067, 7558, 8948,
10717,10784,11542,11659,11965,12259,12582,13828,13943,14147,
14499,14840,14909,15019,15626,15806,15964,16266,17204,18492,
18953,19057,19225,19588,19693,20491,20806,20936,22404,22907,
23080,23507,23974,24470,24974,25367,26460,27088,27307,28705,
28921,31162,31460,31616,31647,31702,31949,  147, 1094, 1202,
 2537, 2838, 3142, 3744, 3898, 4033, 6434, 6573, 6652, 6799,
 7307, 7382, 8123, 8569, 8799, 9173, 9507, 9735,10178,10281,
11242,11636,12147,12357,12491,13269,13670,13971,13976,16327,
17045,17388,17796,19431,20176,20251,20965,21264,21364,24129,
24490,24546,24699,27511,27686,28224,28436,28674,29907,30172,
30210, 1058, 1793, 3615, 3974, 4433, 4903, 4999, 5123, 5248,
 7827, 7949, 8027, 8103, 8536, 9636,10515,10767,13743,14795,
14945,15489,16227,16937,16973,17092,17151,17525,17828,18527,
21589,22084,22396,22530,23088,23451,23820,25107,25113,25316,
25998,26393,26552,27332,28090,28892,29891,30028,30724,31196,
   88,  422,  637, 1689, 1813, 2333, 3463, 3730, 3932, 5338,
 6001, 6688, 7052, 7595, 7616, 8848,10436,10458,11670,11934,
12062,12673,12760,13153,14735,14836,18311,18778,19361,19833,
19861,20002,20480,21989,22002,22670,24674,24841,25373,25470,
26040,26849,27272,27676,28076,28141,29327,29953,30843,31620,
  206,  287, 1569, 1697, 2310, 2762, 3196, 3797, 3945, 4264,
 4921, 5042, 5842, 7513, 9260, 9279,10126,10380,10680,11376,
11404,11608,13217,13508,14237,14445,14514,15444,16672,16827,
17744,17766,17999,18080,18112,19275,21003,21166,21402,22294,
22794,23670,24079,24337,26133,26318,26354,29226,30802,30941,
   50,  118, 1455, 1782, 2218, 2405, 3300, 3475, 4884, 5019,
 6042, 6101, 7329, 7550, 9218, 9298, 9921,10697,11730,12014,
12712,13387,13466,13708,15555,16272,16796,17099,18290,19129,
19525,20040,20544,20642,21659,23238,23346,24979,25383,25398,
26499,26720,26831,26998,27999,28310,28683,28761,29654,29969,
31556,32025,  513, 1167, 1426, 2325, 2496, 2739, 2800, 2826,
 3161, 3674, 4545, 4572, 5107, 5223, 5387, 6793, 7026, 7222,
 8283, 8690, 8944, 9285, 9820,10004,11045,12370,12539,12610,
12617,13178,13295,13492,13833,14109,14804,14854,15472,16721,
17684,17823,17946,18053,20010,20118,20703,20988,21124,21803,
22329,22502,23012,23328,23949,25222,26797,29984,30049,30203,
30260,30870,31149,31335,  543, 3324, 3660, 3714, 4321, 4948,
 5621, 5828, 5975, 7654,10477,10722,10793,11712,12188,12485,
15523,15652,16215,16233,16284,16749,17542,19064,19230,20264,
20822,20947,21446,22054,22363,22568,22917,23169,23573,24196,
24414,24713,24860,25041,25159,25212,25648,25966,26020,27351,
27769,27979,27990,28035,28304,28442,28738,28854,29922,30096,
30961,31011,31120,31177,  226,  839,  855, 1302, 1367, 2924,
 4301, 4525, 6529, 6656, 7121, 7248, 7771, 8299, 8324, 8521,
 8966, 9528,11027,11554,12302,12826,13162,13747,14221,14668,
15130,15198,16153,16181,17221,17626,17781,17897,18155,18551,
18819,18923,19215,19605,20955,21393,22037,22546,23675,24044,
24218,26964,27711,27747,28055,28146,28906,29638,29691,30658,
31499,31707, 3169, 3572, 4053, 4582, 4733, 6065, 6473, 6553,
 7155, 7448, 7509, 7761, 8591, 9460, 9496, 9573, 9708, 9949,
11003,11811,12027,12161,12312,13504,14151,15368,15506,15643,
15953,17519,19157,19284,19438,19531,19742,19975,20275,20785,
20960,21623,22880,23197,24095,24399,24536,26149,26172,27092,
28103,28237,28615,28766,29107,29578,29821,30233,30880,31210,
  297,  632,  717, 1053, 1079, 1729, 1884, 2895, 3984, 4504,
 4643, 5665, 5806, 6726, 7646, 8269, 8556, 9633, 9938,10423,
11663,12938,13540,14628,14903,16071,16247,16402,16447,16469,
16705,17126,17497,18516,18715,18881,18947,20494,21380,21515,
21840,23652,24251,24576,24869,25092,25625,26700,26713,26763,
26787,27683,29279,29410,29676,29804,30270,30388,30753,31106,
   82,  195,  583,  595,  730, 1279, 2771, 3696, 4134, 4639,
 5054, 5926, 6820, 8183, 8452, 8543, 8549, 8597, 9052,10048,
10583,12406,12689,13711,14274,14652,15215,16164,16571,16817,
17760,18441,18664,20032,20114,20600,21033,22431,22663,23440,
23874,24419,25267,25484,26069,26373,26633,27412,28579,28656,
28743,29378,  450,  997, 1230, 2340, 2714, 2755, 3074, 3402,
 3583, 5070, 5131, 5252, 6377, 6390, 8480, 8695, 9646,10567,
11065,11558,12172,12432,13665,13789,14484,14885,14950,17229,
17992,18467,18836,19854,20197,20854,20899,21058,21545,22142,
22706,22732,23716,24887,26154,26496,27165,27201,27936,30607,
31393,31414,  906, 1182, 1211, 1459, 1608, 2157, 2449, 3804,
 4815, 5208, 5380, 5504, 6160, 6407, 6424, 6826, 8764, 9178,
10467,10635,11187,11481,12343,12974,13253,13864,14035,15510,
16583,16947,17172,18049,18365,19995,20075,21041,21333,21406,
21746,23166,25640,28535,28749,28859,29143,29235,29330,29787,
30054,30406,30968,  724,  870, 1818, 2428, 2821, 3365, 3528,
 4278, 4461, 5499, 6623, 7049, 7145, 7736, 8265, 8527,10122,
10752,11334,11844,11873,12765,13500,13963,14424,14492,14530,
15809,16543,19293,20098,20507,21836,22549,22769,22849,23341,
23754,24200,24795,24813,24879,25186,25311,25745,26928,30548,
30919,31190,31229,31446,  430, 1978, 2315, 2844, 2986, 4040,
 4479, 4486, 5088, 5334, 5480, 5605, 5703, 6174, 7920, 8010,
 8256, 9713, 9797,10270,11273,11441,12718,13567,13824,14921,
15667,15803,16203,16993,17622,17701,18105,18916,21477,21627,
22803,22891,22948,23103,23255,23693,24155,24436,24455,25609,
25622,25860,26312,26800,26939,27753,28823,29198,30184,30620,
30639,30875,31435,31738,  263, 1364, 1700, 1825, 2972, 3681,
 4508, 5919, 6285, 7163, 7422, 8533, 8993, 9060, 9155, 9424,
 9500,10109,10607,10980,11007,11012,11533,11647,11814,12183,
13396,13544,13967,14255,15243,15264,15326,15482,16178,16644,
17058,17289,17741,17970,18308,19537,20355,20558,20567,21580,
23746,25356,25836,25872,26078,27152,27196,27456,27657,27893,
27984,28507,28868,28924,29092,29260,29726,30227,30283,31535,
31742,31790,31845,32003,   23,  498, 1777, 2174, 2261, 2767,
 2806, 3304, 3602, 4147, 5769, 5834, 6010, 6541, 6548, 6564,
 7195, 7563, 7590, 7744, 7986, 9045,10100,10205,10260,10904,
11034,11090,11914,12319,12326,13110,14068,14906,15193,15493,
16810,17309,17486,18789,19210,19545,19557,19889,20029,20448,
20612,21155,22093,22126,22413,23317,23778,24105,24425,24702,
25409,25538,25785,25852,26846,26946,27678,28719,30344,31015,
 1117, 1490, 2039, 2512, 2927, 3484, 4185, 4306, 4420, 4528,
 4630, 4944, 5405, 5686, 6680, 7417, 8412,10447,10498,11577,
11781,12193,12202,12308,13190,13400,14405,14989,15256,15430,
15467,15976,16576,17198,17226,17446,17943,18169,18195,18763,
18893,19686,20015,20477,20789,20819,21833,22808,22964,23930,
24088,24325,24461,25395,25753,25759,26072,27378,27416,27909,
28070,28108,28372,29274,30192,30743,31881,31973,   92,  143,
  602,  627,  961,  994, 1028, 1474, 1757, 1996, 2221, 4156,
 4362, 4475, 5869, 6037, 6483, 7133, 7268, 7406, 8100, 9083,
 9122, 9228, 9321, 9359, 9488, 9640, 9753,11300,11436,11547,
12231,12641,12950,13258,13535,13897,14702,14744,15486,15969,
16727,17049,17312,18285,18928,19136,19251,19650,19794,20969,
21631,21905,21922,22368,23374,23687,23829,24543,25865,26205,
27076,27085,27125,28165,28544,28643,28671,28690,28819,30442,
30502,30591,30648,30982,31566,31803,  656, 1660, 1736, 2742,
 4118, 4964, 5257, 5839, 7491, 7628, 7767, 8309, 8466, 9283,
10145,11069,12739,13198,13271,14179,14479,15416,15503,16242,
16524,16783,16997,17144,17246,18074,18254,19035,19096,19701,
20322,21268,21806,21957,22050,22666,22691,22968,23706,24247,
24276,24863,25463,26445,26598,27310,29709,30148,30293,31045,
31697,  301, 1164, 1389, 1398, 2225, 3010, 3092, 3103, 3183,
 3415, 3711, 5276, 7305, 7364, 7618, 8347, 8907, 9998,10961,
12594,12629,12871,12942,12988,14104,14812,15745,16027,18687,
18769,20616,20870,21368,21721,22728,23473,24115,24149,24772,
25584,26730,26910,28187,29624,29646,30565,31457,31711,31767,
  738, 1829, 2636, 3513, 3685, 4714, 4801, 5284, 5393, 6305,
 6661, 7183, 7587, 7898, 8875, 9221, 9843,10105,10288,10408,
11421,12022,12100,12530,13855,14137,14310,14440,15412,16099,
16555,17763,17790,18179,19076,19104,19658,20887,21794,22682,
22787,25301,25698,27565,27858,28811,29488,29641,29975,30158,
31745,32008,  503,  510, 3339, 3589, 4000, 4250, 4620, 5804,
 6590, 6685, 7343, 7841, 8601, 9625, 9852,10325,10511,10973,
11030,11406,12733,12906,13378,16137,16274,17022,17177,17617,
18780,19053,19830,20297,21038,22169,22202,22619,23337,23620,
24332,24396,25790,26001,26226,26583,26628,27148,27397,28265,
29096,29510,29732,29914,31131,31915,  481,  550, 1217, 1871,
 2370, 2504, 2774, 3508, 4152, 4290, 4550, 4566, 5026, 6260,
 7310, 7333, 8553, 8769, 8777, 9509,12235,14038,14123,14175,
14657,14741,15763,16090,16539,16772,17534,17757,20938,22160,
23009,23286,23436,23934,24805,25001,25045,25066,25227,25857,
26146,26411,27135,27810,27924,29502,30862,31541, 1242, 1540,
 1763, 1834, 4131, 4647, 5619, 5904, 6083, 6604, 7583, 7824,
 8514, 9868,10186,11566,12060,13083,13412,14983,15438,15596,
17591,17682,17737,17907,18531,19433,19513,20381,20815,20827,
21415,21663,21961,22314,22748,22864,24254,25628,26277,26323,
27598,28270,28418,28471,29422,29796,29881,30434,31794,  344,
  778, 1944, 2052, 2153, 2458, 2469, 3231, 3579, 3843, 5266,
 5979, 6045, 6105, 6637, 7175, 7731, 8174, 8871, 8996, 9532,
 9925,10773,11061,11235,11277,12359,12416,13075,13092,13560,
13689,13722,13892,14994,15250,15690,16560,17698,17995,18822,
19040,19357,19497,19911,21318,21563,23068,24596,24835,25635,
26644,26951,27000,27672,28327,28639,29403,29650,29826,30835,
31453,31562,  222,  276,  807,  900, 1065, 1170, 2397, 3274,
 3788, 5773, 5884, 5986, 6387, 7252, 7530, 8278, 8509, 9112,
 9333,10091,10213,10220,10249,10885,11296,11410,11574,12052,
12288,12981,13137,13524,13922,14319,14364,14816,15398,15639,
15655,16320,17201,17301,17557,17826,19471,19503,19607,19667,
21050,21066,21134,21551,21779,21909,22040,22086,22210,23275,
23290,23557,23838,23842,24047,24358,24497,25096,26165,27545,
27765,27905,28319,29150,29435,30085,30733,30815,30989,31138,
31213,31317, 1479, 1615, 2751, 2984, 3665, 3736, 4574, 5011,
 5231, 5344, 5491, 5508, 5574, 5824, 6610, 6752, 6934, 7956,
 7994, 8006, 8372, 8880,10050,10401,11178,13485,14456,14979,
15816,16031,16429,16957,17210,18391,18728,19453,20171,20588,
21726,22437,23503,24732,25049,25280,25923,26622,27044,27497,
27845,28871,28949,29009,29416,30410,31386,   36,  396,  447,
  771,  815, 2336, 2747, 2759, 2904, 4369, 6247, 6647, 9048,
 9417, 9557, 9957,10332,10393,11048,11778,12828,13058,13973,
14223,14526,15092,15420,15711,15950,17411,18158,18247,18567,
18674,19826,19846,20199,20499,20798,21443,21789,24111,24585,
25022,25038,25297,25363,26141,26898,27558,28156,28753,29853,
30497,30866,31684,31999,  891, 1822, 1879, 2126, 2247, 2996,
 3072, 3548, 3920, 4076, 4683, 5657, 6079, 6501, 6763, 6966,
 7714, 7785, 7833, 8189, 8787, 9289, 9882,10807,10955,11570,
11593,12378,12398,12509,12818,13262,13575,14496,15075,16460,
17383,17922,18243,18453,19598,19999,20067,21619,21890,22186,
22718,23385,24216,26185,26839,26888,27018,27314,27612,27721,
28144,28312,29381,29779,30656,31339,  116,  349, 1042, 1102,
 1796, 2047, 2078, 2921, 3330, 4662, 4725, 5078, 6347, 7041,
 7071, 7167, 9741,10193,13340,14060,14278,15583,15671,15767,
16132,16190,16990,17043,17899,17938,18207,18509,19160,20517,
20649,20701,20953,21193,23325,23679,23944,24143,24289,24608,
24931,25544,25606,26234,26369,26767,28932,29304,30256,30361,
30772,31076,31186,31258,  619, 1015, 3779, 4954, 5097, 5118,
 6146, 6865, 7685, 7752, 8302, 8589, 8651, 8989,10084,11579,
12804,13905,14697,14870,16004,16472,16931,18103,18932,19134,
19426,19715,19863,20373,21070,22146,23333,23588,24242,24889,
26031,26328,26613,27170,27534,27668,28707,28955,28962,29233,
29599, 1610, 2815, 3693, 3762, 4070, 4194, 4445, 5780, 6842,
 7410, 8732, 8953, 9896,10039,10700,11056,11259,11352,12440,
12489,13087,13553,14042,14211,14268,14545,15600,16260,16757,
17223,19555,19971,22805,22970,23425,23892,24209,25964,26005,
26557,26984,27489,29055,30613,30737,30975,31777,  261,  518,
  597,  918, 1072, 2113, 2168, 2961, 3016, 3913, 4425, 4942,
 5669, 6747, 7882, 8213, 8227, 8529, 9300, 9466, 9566, 9886,
10180,10224,10623,11101,11170,11336,12554,12837,13156,13287,
13872,14434,15333,15824,16377,16437,16443,16478,16609,16787,
17665,17687,17866,17926,18712,18765,18832,19449,19678,20269,
20435,20664,21349,21378,21758,22196,22206,22484,22563,22686,
22926,23179,23391,23691,24041,24117,24493,24513,25015,25318,
25740,26587,28041,28366,28466,29398,29580,29674,30300,30478,
30576,30666,31581,31897,31977,  199,  853, 1382, 1441, 1447,
 2161, 2379, 2500, 2836, 3363, 3732, 4080, 4731, 4870, 5105,
 6091, 6405, 6812, 6961, 7210, 7798, 8519, 8667, 8896, 8934,
 9731,10258,10483,10532,10902,11656,11817,11967,12310,12334,
13407,13741,13756,14216,14451,14733,14806,15087,15304,16341,
16656,16905,17771,17895,19078,19533,19928,20085,20293,20359,
20794,21026,21469,21654,21785,22312,23175,24093,24989,25197,
25303,26074,27095,28152,28302,28389,28475,28645,28694,29036,
29490,29506,29665,29910,30178,30208,30584,30821,31115,31433,
  145,  782,  988, 1077, 1755, 2202, 2595, 3427, 3566, 3967,
 4506, 4901, 5250, 5348, 5434, 5454, 5513, 5532, 5785, 5991,
 6049, 6342, 7037, 7548, 7888, 7965, 8368, 9426, 9762,10685,
11019,11330,11540,11837,12177,12345,12767,13120,13160,13459,
14131,14519,14563,14634,14831,14876,14942,15272,15425,15491,
16205,16358,17997,18505,18525,18827,18852,19298,20237,21122,
21205,21940,22108,22236,22349,23321,23449,23536,23824,23965,
24485,24534,25467,25870,26214,26916,27154,27472,27696,28169,
30030,31172,31525,31843,  123,  472, 1224, 1811, 1839, 2542,
 2810, 2929, 3976, 4048, 4259, 4285, 4769, 7045, 7206, 7377,
 7432, 8297, 8454, 8738, 9270, 9436, 9553, 9663, 9911,10070,
10465,11560,11744,12047,12341,13132,15508,16217,16945,17194,
17338,18177,18354,18460,18787,19062,19319,19590,20110,20319,
20399,21022,21340,21582,22282,22519,22953,23491,23571,23668,
24657,25011,25749,25765,26080,27182,27621,27777,27800,28139,
28290,28383,29460,29870,30268,31416,31740,31828,31892,31947,
32031,  868, 2832, 2846, 3279, 3881, 4687, 4704, 5718, 5802,
 5871, 6024, 6422, 6543, 7266, 7511, 7746, 9216,11151,11638,
11717,12328,13144,13183,13586,14149,14153,14847,15203,15676,
15752,16456,16824,17062,17156,17357,17819,18540,19347,20178,
20658,20864,21266,21547,22893,23270,24071,24459,24666,26248,
26743,28438,30187,30557,31000,  140,  248, 1453, 2322, 2442,
 3269, 3670, 5815, 6018, 7064, 7489, 7970, 8865, 9162,10137,
10184,10831,10982,12912,13440,14360,15034,15183,17239,17903,
18107,19203,19220,19708,20027,21838,22383,22406,23045,24770,
24790,25694,26016,26387,26526,26816,27602,27708,28132,28636,
29184,29264,29515,30022,30069,30346,30444,30952,31921,  610,
 1096, 1311, 1406, 1658, 1702, 1738, 2155, 2893, 2914, 3225,
 3562, 4613, 4635, 4659, 4746, 6957, 7303, 8206, 9031, 9323,
 9536,10460,10671,11052,11650,11789,11927,12198,12446,12813,
12972,13506,13910,15648,15855,16078,16423,16968,17056,17693,
17990,19814,19856,20441,21089,21366,21433,22165,22200,22730,
22871,23550,24441,24448,25358,25476,25936,26640,26994,27370,
27691,28239,28258,28725,29428,29668,29848,30275,30833,31503,
31618,  407,  444,  668,  682,  934, 1228, 1386, 1551, 1594,
 1622, 1869, 2466, 2605, 2970, 3198, 3526, 3600, 3998, 4296,
 5086, 5227, 5336, 5407, 6165, 6267, 6778, 7028, 7135, 7192,
 7246, 8082, 8331, 8416, 8582, 8946, 9505,10053,10605,10619,
10695,11015,11233,11665,11875,12112,12122,12180,12322,12410,
13468,13512,13694,13749,13837,13965,14070,14419,14630,14666,
15296,15771,15900,16211,16709,16723,17113,18007,18150,18705,
19048,19264,19614,20116,20185,20581,20769,20860,21029,21137,
21238,21808,22374,22553,22607,23264,23724,24198,24421,24530,
24839,24883,25245,25375,25603,25805,25961,26038,26783,26926,
27203,27232,27591,27705,27741,27920,28999,29412,29530,29659,
29711,30201,30680,31303,31399,31631,31680,31951,32027,  265,
  728,  893, 1567, 1845, 2165, 2193, 2374, 2519, 2533, 2975,
 3367, 3384, 3742, 4006, 4045, 4334, 4354, 4665, 5194, 5293,
 5715, 5821, 5917, 6640, 7179, 7452, 7916, 7929, 8127, 8172,
 8385, 8462, 8499, 9439, 9456, 9638, 9813,10565,10627,10765,
10896,11449,11606,11999,12204,13595,14724,14838,15119,15371,
15851,15982,16578,16668,17039,17206,18143,18280,18406,18744,
18874,19032,19141,19520,19584,19867,20454,20610,21274,21335,
21633,21896,22321,22467,22522,23060,23105,23434,23575,23660,
23736,24323,24548,25086,25261,25291,25446,26501,26545,26650,
26727,26907,27078,27774,28242,28608,28735,28852,29088,29103,
30164,30432,30913,31038,31127,31158,31220,31263,31769,31912,
  686, 1009, 2068, 2716, 3707, 3916, 5517, 5761, 7314, 7331,
 8258, 8593, 9115, 9293, 9715, 9737,10988,11263,11863,13542,
14482,14682,15778,16064,16337,17101,17321,18484,18579,18691,
18900,18918,19147,20405,20843,20928,22117,23122,23348,23711,
24429,24717,25306,25426,25978,27468,28376,28712,28936,29213,
29806,30026,30110,30662,30751, 1105, 1662, 3302, 3604, 4247,
 5305, 5653, 6426, 6786, 7143, 7903,10128,10368,11418,11748,
11826,12685,13001,13303,13826,13860,15047,15213,15512,16288,
18271,19082,21009,21408,21667,22124,22410,22726,22976,24159,
25562,27525,27578,27594,30290,30595,31884,  846,  967, 2215,
 2936, 4518, 4935, 5238, 5638, 6415, 6575, 7200,10279,11947,
12442,12546,13358,13449,14715,15799,16420,17669,18363,18974,
19243,19308,20217,20967,21574,21903,22708,23183,23911,26067,
26756,27542,27761,28059,29252,29308,29480,29768,31813,  244,
  328, 1174, 1866, 2209, 3156, 3585, 4463, 5186, 5583, 6436,
 8142, 8613, 8766, 8889, 9377, 9672,10420,11005,13763,14285,
14592,16545,16838,17169,17407,17755,20234,22933,22957,24260,
25440,25591,25734,26316,27073,28490,29438,29982,30146,30763,
31052, 3140, 3846, 4065, 4563, 5121, 5602, 5922, 6654, 6859,
 8394, 8677, 8726,10496,11106,11158,12643,13200,14411,14923,
15138,17326,17919,18445,18529,20273,20740,21016,21170,22104,
23137,23630,23834,24153,25090,28840,28939,29493,30972,31344,
31589,31751,31763,   94,  424,  527, 1888, 2233, 2435, 4626,
 5245, 6057, 6682, 6724, 6739, 7116, 7636, 7733, 7941, 8166,
 8942,10233,10648,12105,12605,13015,13673,13919,14659,15003,
15748,15819,17523,18325,18394,19821,20088,21246,21604,22792,
22994,23464,24315,25642,26163,26375,27163,28001,28062,29463,
30005,  340,  593, 1457, 1957, 1984, 2199, 2698, 2956, 3293,
 4330, 5493, 7380, 8878, 9175, 9442,11167,11484,11905,12387,
12880,12955,13317,13490,14431,15209,15219,16432,16675,16986,
17298,17934,18456,18685,19983,21612,22435,23305,24590,24680,
25701,25844,26252,26746,27495,28084,28123,28730,28995,29345,
29776,30080,30088,30646,31801,  322,  412,  643, 1055, 1122,
 1691, 1941, 1992, 2420, 2648, 2898, 3134, 3214, 3308, 3342,
 3748, 3802, 3850, 4083, 4651, 4674, 4691, 5675, 6189, 6280,
 6371, 6729, 6913, 6937, 7844, 8159, 8280, 8410, 8759, 9027,
 9039, 9094, 9157, 9681, 9710, 9799, 9837,10251,10310,10387,
10778,10846,10906,11476,11629,12038,12156,12558,12791,12898,
12977,13116,13601,13638,14266,15071,15637,15987,16085,16200,
16253,16605,16732,16935,17282,17775,18259,18358,18480,18544,
18666,18756,19291,19552,19844,19932,20095,20300,20402,20446,
20697,20885,21322,21375,21538,21831,21945,21963,22861,23075,
23195,23623,23635,23864,23942,24001,24272,24661,24720,24816,
24977,24993,25059,25162,25385,25405,26159,26326,26340,26414,
26437,26593,26658,26812,27025,27227,28006,28148,28235,28459,
28563,28883,29256,29292,29991,30427,30692,30949,30992,31299,
31406,31514,31545,31832,    2,  304,  465,  831, 1114, 1396,
 1923, 2609, 2883, 3510, 3962, 4319, 4824, 4888, 4919, 5328,
 5416, 5960, 6035, 6203, 6367, 6443, 6478, 7806, 7910, 8018,
 8152, 8478, 8936, 9076, 9611, 9667,10207,10662,10719,11494,
12145,12226,12517,12885,13328,14351,14507,14516,14752,15383,
15621,15890,16599,16832,17153,17428,18211,18846,19131,19207,
19610,19877,19977,20246,20561,20575,20677,20972,21196,22035,
22173,22624,23090,23355,23363,24602,25656,26241,26367,27482,
27522,27724,27971,28334,28815,28825,28878,29523,29964,30001,
30033,31233,31251,31787, 1089, 2065, 3351, 3982, 4088, 4808,
 4957, 5235, 5616, 5888, 6430, 7351, 7610, 8113, 8507, 9337,
 9794,11391,11724,11741,11995,12742,12754,12773,13655,14139,
14306,15450,15552,15843,15878,16617,16760,16820,17094,17187,
18465,18959,19088,19248,19506,19882,20881,21799,22304,22581,
23302,23846,24522,24635,25807,26199,26570,26854,27157,27381,
27596,28856,30249,30984,31034,31747,31888,  100,  432,  799,
  827,  883, 1177, 2363, 2526, 3043, 4182, 5022, 5064, 5542,
 5663, 6262, 6485, 6981, 7022, 7373, 7515, 7837, 8717, 9687,
10506,10871,11380,12807,13785,13899,14145,14930,15474,16526,
16558,17244,17527,17785,18817,21517,22532,22736,23907,24311,
24736,24923,25176,25264,25671,26980,27360,27876,28095,29512,
29541,30677,30728,30878,31905,  162,  651,  715, 1048, 1300,
 1351, 1998, 3012, 3079, 3179, 3909, 4123, 4543, 4622, 5510,
 6805, 7428, 7886, 8196,10609,10709,11073,11399,11679,12209,
12483,12699,13108,13915,14428,15055,15377,15979,16650,17163,
17931,18085,18560,19541,20160,20393,20608,20997,21260,21284,
22425,22470,24629,25188,27222,28292,28424,29086,29217,29823,
30396,30931,31200, 1001, 1483, 1774, 2546, 2789, 3287, 3812,
 3860, 3952, 5837, 6630, 9119, 9807, 9916,10948,11604,11923,
12584,12921,14080,14727,14793,15094,15500,15558,16058,16293,
16400,17680,17768,19213,19529,19681,19852,20283,20681,21043,
21850,22140,22290,22400,22695,22751,22909,23471,24775,25681,
25792,26705,27323,27862,27944,28358,29312,29527,29593,30066,
31169,31926,   45,  736, 1030, 1463, 1555, 1643, 2268, 2330,
 2446, 3491, 3506, 4110, 4364, 4530, 5331, 5592, 6276, 6401,
 6643, 6691, 7700, 7720, 7791, 8072, 8146, 8605, 8857, 8972,
 9152, 9277, 9563,10203,10410,10439,10786,11228,11270,12025,
13140,13371,14099,14356,15102,15200,15470,15514,15773,16450,
17317,17443,17480,17555,17614,18013,18592,18680,19429,20386,
20515,20554,20674,20757,20976,21508,21595,21649,22604,23040,
23730,23890,23953,24226,24865,25025,25953,26027,26189,26423,
27015,27082,27199,27278,27796,28559,28890,29194,29610,30115,
30611,30770,31056,31179,31430,31574,31797,31902,  319,  506,
  630,  674, 1155, 1251, 1378, 1428, 1496, 1789, 1959, 1986,
 2119, 2241, 2808, 3219, 3360, 3487, 3517, 3617, 3948, 4537,
 4832, 5049, 5190, 5274, 5450, 5722, 5874, 6073, 6117, 6197,
 6354, 6359, 6758, 7010, 7197, 7415, 8356, 8407, 8833, 8900,
 9328, 9656, 9931,10062,10237,10293,10858,10963,11393,11443,
11600,12102,12352,12376,12875,13102,13128,13196,13211,13291,
13364,13444,13925,13929,14049,14173,14608,14663,14834,15060,
15084,15188,15235,15268,15756,15801,16040,16514,16520,16548,
16939,17180,17212,17972,18128,18302,18695,18925,19303,19445,
19480,19990,20241,20379,20451,20463,20604,21086,21521,21696,
21734,21943,22020,22046,22180,22380,22386,22417,22510,22587,
23453,23704,23771,24022,24074,24693,24709,24855,24920,25029,
25232,25314,25387,25691,25778,26210,26314,26541,26777,27104,
27114,27384,27615,27730,27886,27938,28281,28570,28612,28723,
29258,29441,30052,30150,30352,30568,30813,30851,30927,31063,
  103,  269,  500, 1068, 2463, 2508, 2548, 4738, 4820, 4863,
 5072, 5295, 5595, 7404, 7517, 7765, 7839, 8131, 9064, 9351,
 9559, 9622, 9919,10529,10646,10754,10834,10852,11339,11615,
11850,11945,12212,12625,12800,14027,14914,15015,15436,15521,
15837,16051,16381,16390,16536,16586,16845,16912,17521,18136,
18186,18306,18382,18670,19170,19603,19730,19788,20228,20470,
21536,21576,21761,21969,22012,23484,23758,23818,23876,24299,
24509,25391,25552,25818,25989,26168,26331,26343,27219,27318,
27655,27912,28509,28522,28620,28759,28919,28964,29123,29133,
30404,30457,31216,31437,    8, 1629, 1864, 2599, 2968, 3031,
 3381, 4136, 4608, 4838, 4849, 5501, 5956, 6393, 6869, 7016,
 8185, 9845, 9951,10489,11918,11957,12174,13985,17409,17505,
18749,18908,20203,21900,23781,24054,24916,25838,26046,26635,
27293,27299,29204,29222,29618,30104,30223,30237,30369,30617,
30684,30917,31270,   96,  211, 1124, 1393, 2709, 2727, 3399,
 3537, 4378, 5037, 5199, 6300, 7504, 7759, 8001, 8068, 8092,
 8137, 8734, 8940, 9811, 9833,11470,11759,12031,12697,12926,
13344,13385,13650,14321,14501,14937,18059,18838,18969,19527,
20958,21744,21984,22851,23561,25347,25458,26653,27962,28381,
31423,31935,   86,  670,  722, 1953, 2580, 2591, 3905, 4899,
 5580, 6600, 7346, 7821, 8038, 8609, 9170,11974,14231,14244,
15241,15613,16073,16155,17005,17439,17954,19114,19586,19809,
19838,20631,21637,22151,22299,22962,23057,23142,23886,23936,
24283,26306,26740,26773,26987,27853,28497,29137,29762,30390,
30746,30856,31019,31532,  540, 1283, 1843, 4254, 5538, 6095,
 6219, 8492, 8841,10328,10404,11384,12586,12864,13474,14065,
14170,14182,14302,14598,17349,17567,17596,17810,17881,18064,
19343,19626,20311,20497,21229,21665,22583,22998,23128,23584,
24029,24711,25034,25802,25930,26083,26336,26810,26902,27042,
27336,27389,28195,28887,29431,31501,  132,  229,  234,  388,
 1063, 1780, 2129, 2694, 2854, 2952, 3377, 3595, 3867, 4091,
 4342, 5798, 6194, 7603, 8657, 8674, 8921, 9670, 9693, 9839,
10189,11397,11938,12572,12793,14487,15781,16411,16590,17367,
18469,19122,19282,19442,20891,21127,21357,21716,22693,22857,
23097,23734,24810,25402,25879,26577,27021,27600,27652,28846,
29285,30604,30630,31328,31347,31981, 1424, 1605, 1625, 2731,
 3003, 3650, 3988, 4357, 4388, 4501, 5848, 5852, 6495, 6570,
 6664, 6850, 7357, 7578, 7639, 8168, 8502, 8722,10284,10322,
10691,10848,11623,11866,11978,12495,13024,14636,14654,14670,
16374,16662,16665,16899,17119,17140,17416,18628,18760,19025,
19655,20052,20812,22286,22306,22762,23203,24402,24670,25432,
25558,26601,28273,28284,28362,28678,31030,31633,  251,  257,
  357, 1400, 1501, 1576, 1669, 2276, 2530, 2601, 3019, 4760,
 4803, 5587, 5983, 6432, 6775, 6797, 7420, 7450, 8757, 8854,
 9316, 9675, 9904, 9984,10200,10780,10866,11183,12238,12715,
12820,13062,14141,14346,15097,15172,15956,16000,16416,17190,
17394,17516,17725,18315,18945,19260,19886,20444,20749,21592,
21642,22335,23639,24060,24240,25257,27283,27326,28057,28117,
28512,29052,29276,29636,30287,30766,   26,  399, 1082, 1198,
 1485, 1547, 2020, 2382, 2558, 2817, 3355, 3467, 4293, 5220,
 5324, 5649, 6052, 6399, 7078, 7243, 7340, 7498, 8985, 9341,
10818,11213,11332,11466,11620,12499,12962,13323,13498,13527,
14032,14055,14897,14934,15079,15374,15862,16361,17110,17878,
17962,18294,18966,18982,19017,20057,20129,20423,21063,21200,
21224,21272,21530,22230,22464,23082,23666,23739,24587,24960,
24998,25082,25180,25293,25788,26451,26974,27110,27375,28353,
29207,29533,29586,30037,30072,31324,31637,31760,31984,32011,
  977, 1011, 2072, 2916, 3503, 3752, 3854, 4115, 4167, 4867,
 6153, 6755, 6803, 7110, 7170, 7633, 8290, 8469, 9450, 9491,
 9703,10034,10899,11223,11536,11684,11772,11931,12220,12424,
12783,13277,13572,13603,13703,13780,14083,14976,15635,15682,
15793,15908,16160,16404,16764,17234,18332,18741,19713,19871,
20021,21173,22158,22812,22914,22981,23343,23522,23720,24003,
24279,24676,25492,25501,25661,26310,26398,26562,26609,27736,
27749,27803,27871,27975,28074,29497,29574,29900,30170,30528,
31560,31719,31928,31962,  202,  793,  969, 1408, 1506, 2235,
 2393, 2569, 3289, 3430, 3937, 4718, 4874, 5908, 7024, 8199,
 8314, 8714, 9073, 9089, 9245, 9248, 9829,10509,10725,10760,
11563,12242,12532,13547,14719,16631,16715,17419,17433,17472,
17677,17735,18092,18183,18397,19037,19278,19841,20549,20685,
20760,20985,21232,21782,22783,23132,23459,24966,25270,25674,
25812,26130,26648,26954,27702,28449,29729,29887,30012,30061,
30374,30627,31365,  151,  160,  312, 1033, 1044, 1680, 2028,
 2551, 2642, 2651, 2798, 2823, 3136, 3282, 3575, 4068, 4107,
 4366, 4457, 4471, 4540, 4757, 5150, 5314, 5482, 6156, 6212,
 6289, 6362, 6557, 6838, 6876, 6928, 6969, 7001, 7232, 7318,
 7756, 7777, 7781, 8181, 8980, 9189, 9295, 9412, 9526, 9538,
 9747, 9857,10265,10614,10791,10824,11097,11459,11632,12384,
12563,12702,12995,13175,13285,13657,13679,13777,14046,14640,
14917,14999,15230,15403,15703,15845,16195,17184,17582,17750,
18267,19354,19492,19781,19899,20289,21182,21219,21429,21437,
21736,22029,22517,22678,23095,23159,23313,24031,24343,24605,
24639,25070,25229,25576,25987,26127,26405,26937,27266,27950,
28178,28350,28876,29005,29300,29701,30806,30921,31165,31806,
 1004, 1857, 1946, 3389, 3497, 3611, 4227, 4860, 6184, 7239,
 9696,12262,12363,13456,13885,14673,15452,16960,17889,18345,
19273,20106,20126,20809,24205,24824,25631,26086,26434,26539,
26804,28230,28827,28898,29332,30281,30380,30552,30637,31003,
31728,  491,  665, 2564, 3041, 4311, 5205, 5475, 6608, 6770,
 6984, 7073, 7979, 8076, 8154, 8382, 9928,10576,10874,11239,
11869,13022,13096,13783,15386,15606,15709,18057,18521,19619,
21586,21703,23486,23900,25637,26656,26957,28539,29601,30459,
30798,  415, 1344, 1742, 4893, 5269, 5320, 7298, 8488,11768,
13376,14604,14747,16622,16868,17529,18384,18639,19804,20071,
21140,22183,22744,23531,23971,24683,25287,25947,26894,27161,
28843,28957,29926,30100,30690,31202,31260,31379,31878, 2142,
 3320, 4243, 5114, 6446, 7727, 8762, 9168,10014,11941,12374,
12787,13451,13517,14326,14690,15591,15883,16062,17729,18720,
19942,22007,22130,23947,24616,24650,24911,26750,28278,28769,
31331,  704, 1627, 3530, 5439, 6463, 7712, 8326, 8580, 9764,
11972,14509,15759,16981,17602,20367,20639,21185,22217,22433,
23429,23848,24467,25589,27588,27699,28072,28181,28629,29050,
29059,30401,31420,32018, 3541, 4274, 4340, 5212, 5967, 6780,
 8320, 9453, 9661,10134,11103,11285,11954,12631,13831,14057,
14647,16619,17573,18010,19324,19734,23432,23498,25667,27039,
27098,27334,28121,29472,30195,30632,   13, 2134, 2645, 3800,
 4933, 5810, 8119,10274,10305,11626,12140,15495,17011,18683,
19332,20019,20100,21861,22512,22959,22978,23764,24784,25235,
26425,26449,26604,26738,27347,29875,31145,31940,  825, 1579,
 2024, 2227, 4753, 4773, 5032, 5880, 7058, 8352, 8724,11445,
11721,12426,13988,15312,15362,16017,16056,16276,18631,19409,
19696,21996,22148,22798,22875,23055,24696,24871,25117,26033,
31965,  386,  903, 1683, 2802, 2933, 3081, 4160, 4440, 5003,
 5900, 6298, 6531, 7819, 8851,10802,11347,11799,12919,14610,
14677,16372,18402,18658,19084,19746,20195,20473,21561,23086,
28912,29026,31321,  803, 2351, 2689, 2940, 2958, 3165, 3373,
 5680, 5817, 5911, 7461, 9826,10198,10890,11220,12678,13106,
13728,13844,13952,14096,14757,15971,16364,16834,17354,17476,
17978,18262,18841,19593,20223,20592,22353,22946,23135,24019,
24100,25379,25664,26269,26517,26723,27520,27855,28741,29270,
29455,30215,30660,30779,  487,  924, 1213, 1290, 1370, 1925,
 3865, 3930, 4094, 4523, 5472, 6181, 6632, 6743, 7186, 7262,
 7739, 8753, 9494, 9517, 9613, 9627,10239,10474,10638,10715,
11000,11164,11402,11551,11861,12002,12421,12450,12548,12967,
13362,16009,16325,17397,17812,17910,18512,19459,19510,20943,
22867,23582,23701,24828,25098,25350,25412,26358,27959,28432,
28495,28838,28993,29099,30008,30039,30644,30682,30793,31208,
31240,31313,31690,31756,31971,32014,  137,  241,  254,  271,
  454,  547,  888,  973, 1026, 1051, 1285, 1469, 1557, 1632,
 1638, 1803, 1859, 2006, 2059, 2081, 2424, 2561, 2622, 2705,
 2786, 3037, 3122, 3154, 3209, 3291, 3379, 3521, 3533, 3653,
 3959, 4191, 4230, 4325, 4375, 4481, 4497, 4624, 4721, 4763,
 4852, 5017, 5034, 5075, 5311, 5409, 5443, 5578, 5661, 5970,
 6014, 6032, 6087, 6112, 6217, 6233, 6466, 6581, 6669, 6694,
 6922, 6986, 6998, 7013, 7501, 7605, 7793, 7879, 8020, 8023,
 8089, 8293, 8640, 8655, 8702, 8775, 8802, 8862, 8883, 9066,
 9079, 9105, 9165, 9224, 9700, 9995,10142,10210,10308,10494,
10651,10821,10861,10997,11025,11087,11109,11173,11521,11672,
11774,11984,11997,12044,12114,12513,12882,12953,12960,13064,
13124,13206,13369,13472,13598,13772,13877,13934,13958,14473,
14504,14596,14615,14661,14754,14843,14859,14873,14899,15057,
15099,15133,15180,15409,15785,15960,15996,16024,16044,16144,
16158,16331,16369,16418,16465,16807,16922,17033,17136,17435,
17500,17508,17553,17562,17637,17777,17802,17808,17862,17984,
18117,18341,18349,18360,18518,18570,18584,18938,18976,19154,
19238,19258,19287,19295,19366,19416,19548,19849,20266,20313,
20353,20427,20552,20598,20645,20671,20847,20879,20896,20962,
21018,21160,21253,21257,21418,21461,21555,21756,21917,22377,
22537,22557,22576,22610,22614,22628,22740,22781,22814,22882,
23071,23092,23461,23616,23853,23866,24257,24270,24302,24306,
24329,24339,24473,24599,24610,24971,25344,25400,25434,25496,
25560,25732,25775,25800,25933,25950,26023,26059,26202,26263,
26345,26382,26428,26689,26692,26758,27117,27175,27229,27285,
27401,27466,27727,27743,27789,27899,27946,27968,28228,28294,
28307,28446,28463,28478,28681,28928,29033,29130,29343,29385,
29475,29583,29591,29621,29671,29705,29837,29878,29994,30075,
30239,30463,30481,30539,30915,31124,31142,31267,31326,31342,
31352,31391,31411,31552,31641,  149,  231,  475,  600,  774,
  927, 1239, 1268, 1296, 1602, 2032, 2346, 3117, 3386, 3606,
 3785, 3869, 4224, 4317, 4654, 4806, 4836, 5047, 5141, 5261,
 5272, 5303, 5436, 5519, 6059, 6067, 6788, 6940, 7108, 7150,
 7336, 7576, 7621, 7893, 8333, 8458, 8555, 9098, 9139, 9238,
 9650, 9691, 9816,10042,10102,10243,10451,10868,11075,11143,
11196,11474,11976,11987,12143,12207,12215,12543,12779,13017,
13078,13249,13391,13453,13901,13913,14551,15009,15174,15225,
15237,15315,15680,15714,15822,16229,16269,16281,16976,17017,
17147,17346,17491,17570,17632,17704,18096,18388,18462,18475,
18502,19143,19271,19884,19897,19902,20024,20060,20104,20430,
20628,21526,21699,22033,22080,22121,22154,22297,22481,22713,
22758,22764,22854,23258,23359,23366,23880,23904,24011,24296,
24352,24355,24409,24579,24622,24893,25204,25361,25460,25771,
25815,26065,26470,26522,26555,26780,26822,26843,27139,27216,
27321,27338,27572,27650,28183,28537,28617,29022,29202,29447,
29628,29679,30144,30278,30303,30947,30956,30979,31036,31253,
31376,31403,31722,31731,31836,31875,31996,  309,  677,  881,
 1035, 1187, 1360, 1584, 1893, 1975, 2319, 2384, 3021, 3084,
 3111, 3172, 3472, 3648, 4381, 4492, 5300, 5447, 5611, 6006,
 6627, 6650, 7555, 7922, 8015, 8032, 8109, 8156, 9069, 9310,
 9348, 9374, 9445, 9550, 9987,10377,10444,10876,11342,11369,
11426,11463,11736,12066,12888,13347,13659,13687,13699,13715,
14156,14354,14712,14730,15005,15232,15381,15455,15561,15860,
16183,16634,16738,16746,16983,17103,17550,17914,18051,18558,
18735,19020,19233,19819,19992,20190,20303,21045,21151,21519,
21982,22043,22133,22723,23157,23500,23766,23859,23888,24262,
24506,24688,24848,25889,26239,26267,26505,26991,27173,27500,
27932,28339,28673,28715,29188,29209,29334,29457,29520,29850,
29889,29997,30340,31193,31700,32038,  219,  707,  849, 1109,
 1787, 1799, 2016, 3267, 3335, 3409, 3941, 4256, 4897, 5184,
 5765, 6054, 6384, 7140, 7322, 7388, 7439, 8376, 8547, 8919,
 8957, 9606,11468,12251,12419,12519,12730,12909,13135,14330,
14891,15281,15300,16852,16865,17008,17159,17292,18707,19107,
19836,20226,20258,20365,20694,20772,21129,21354,21391,21987,
22111,22277,22597,23296,24391,25184,25255,26638,26934,26961,
27281,27492,27505,27808,28299,28661,29987,30219,30924,31154,
31650,   72,  246,  402,  417, 2523, 2619, 2657, 3863, 3887,
 3907, 4143, 4429, 5317, 6380, 6413, 6498, 6871, 7425, 7542,
 7907, 8125, 8201, 8707, 9512, 9756, 9871,10002,10977,11037,
11181,11834,12298,12607,13531,13683,14235,14443,15063,15310,
15830,16069,17716,17886,18061,19012,19027,19338,21000,21286,
21396,21615,21847,22091,23205,23567,23633,23741,23851,25056,
25216,25285,25415,25847,25956,28173,28355,28710,29115,29229,
29723,30245,30748,31628,31987,  964, 1498, 1573, 1849, 1970,
 2412, 2630, 2965, 3424, 3956, 3971, 4171, 4489, 5651, 6674,
 6930, 8751, 8962, 8982, 9186,10217,10338,10816,10855,11840,
12005,12152,12637,12646,13009,13353,13960,14128,15029,16046,
16414,16779,18213,18547,18921,19246,19482,19921,20867,21146,
21472,21601,23370,23718,23917,24033,24729,25556,26194,26807,
27212,27680,28503,30153,30420,30486,  495,  587, 1504, 2238,
 5202, 5287, 7353, 7568, 7625, 8343, 8370, 9251, 9353,11802,
12929,14053,14087,14692,15012,15323,15526,16534,16916,17799,
17950,19059,19457,20779,21434,21645,21935,22333,22356,23126,
23578,24234,24705,25490,25507,26035,27428,27716,27879,27896,
27965,28129,28576,30173,31396,31547,  275,  820, 1086, 1248,
 2150, 2265, 2386, 2396, 2912, 3317, 4003, 4179, 4234, 4961,
 5061, 5145, 5399, 5414, 6264, 6282, 6535, 6562, 6621, 7560,
 9086, 9125, 9235, 9476, 9524,10287,10580,10810,10945,11146,
11245,12403,12622,13887,14030,14340,14407,14638,14850,14878,
15894,16257,16767,17128,17232,17928,17986,18016,18131,18198,
18338,18587,18702,19125,20324,20432,21209,21222,21811,21825,
22337,22921,23042,23747,24120,24820,25353,25371,25677,25983,
26207,26352,26512,26717,26891,27387,27568,28555,28914,29248,
29967,30168,30791,30849,31409,31496,31992,  524,  640,  795,
 1221, 2122, 2307, 2999, 3034, 3755, 3927, 4071, 4697, 5040,
 5598, 6954, 7445, 7507, 7592, 7774, 8263, 8275, 8287, 8784,
 9914,10131,10396,10526,10826,11225,12721,12834,12935,12997,
13283,14120,15660,15789,15867,16484,16581,16736,16754,16951,
17036,17053,17096,17306,18257,18487,18634,18859,19423,19894,
19985,20754,20980,21036,21714,22473,22897,23062,23273,24005,
24286,24433,25444,25996,26053,26218,26913,27356,27994,28245,
29047,29662,30063,30383,30547,30687,31381,31440,31838,  291,
 1545, 2062, 2132, 2258, 2556, 3553, 3699, 3965, 5102, 5322,
 5428, 6833, 6852, 7723, 8687, 9036,10246,10453,10574,11250,
11588,12315,13717,14461,16146,16518,17387,18165,18879,19640,
19823,20421,20833,21387,22493,23100,23200,24027,24067,24648,
25165,26119,26467,26824,26921,27392,29319,29571,29902,30017,
30944,31918,  128,  653,  875, 1654, 1948, 2004, 2185, 3872,
 4557, 5570, 5643, 5846, 6062, 6976, 7119, 7259, 7704, 8003,
 8034, 9750,10036,10888,13071,13194,13731,13752,13866,14090,
14228,14263,14625,14721,14799,15135,15461,15697,15939,16167,
16346,18471,18626,20572,21844,22215,22925,23300,23477,23518,
23762,24308,25420,25645,25876,26580,27269,27341,27733,27751,
28067,28275,28756,28806,29336,30424,30777,30830,31489,31703,
  156,  789,  810, 1020, 1444, 2454, 2613, 2639, 2784, 3107,
 3115, 3396, 3470, 3935, 4075, 5535, 5795, 5889, 6567, 7033,
 7397, 7996, 9305, 9409, 9482, 9659, 9901,10119,10271,10486,
10800,10967,11808,12561,13251,13307,13410,14167,15259,16095,
16406,16647,16829,18139,18565,19093,19350,20276,20747,20776,
20933,21381,21465,21822,22115,22929,23144,23457,23543,23816,
24347,24438,24516,24723,24741,25566,25574,26043,27121,27902,
28895,29232,29287,29588,29831,30306,30841,30859,31907,32006,
  338,  456,  921, 1566, 2189, 2521, 3896, 4113, 4494, 4905,
 4916, 5001, 5137, 6077, 6396, 6617, 6741, 7075, 7540, 7743,
 7901, 8079, 8218, 8306, 8959,11290,11912,12007,12365,12501,
12521,12567,12781,13181,13404,13932,13940,14143,14258,14489,
14621,14785,15317,15623,16048,16244,16858,17166,17323,17401,
17494,17957,17964,18274,18298,18883,18956,19666,19748,20102,
20668,22136,22886,23382,23546,24085,24334,24614,24620,24786,
24983,25438,26791,26904,27132,27665,27948,28175,29061,29453,
29538,30372,30453,30489,   15,   22,  193,  279,  390,  419,
  434,  452,  521,  709,  806,  886,  911,  990, 1246, 1358,
 1419, 1467, 1509, 1640, 1686, 1746, 1815, 1962, 1982, 2018,
 2030, 2112, 2317, 2441, 2624, 2733, 2763, 2777, 2796, 2819,
 2947, 2993, 3093, 3100, 3120, 3236, 3272, 3323, 3405, 3535,
 3995, 4102, 4175, 4322, 4443, 4547, 4577, 4745, 4858, 4926,
 5133, 5196, 5441, 5484, 5614, 5673, 5689, 5767, 5856, 5973,
 5980, 6069, 6116, 6176, 6235, 6292, 6489, 6538, 6666, 6828,
 6878, 6990, 7007, 7036, 7055, 7136, 7152, 7366, 7402, 7494,
 7682, 7955, 8192, 8396, 8402, 8414, 8420, 8476, 8490, 8505,
 8545, 8643, 8705, 8719, 8903, 8950, 8988, 9100, 9135, 9233,
 9241, 9312, 9338, 9447, 9823, 9874, 9898, 9932, 9936,10000,
10028,10085,10267,10492,10561,10591,10706,10713,10789,10841,
11022,11202,11354,11367,11386,11448,11680,11761,11823,11829,
11847,11858,11907,11921,12035,12127,12516,12534,12580,12620,
13011,13301,13321,13331,13341,13359,13381,13464,13480,13488,
13642,13661,13774,13858,14020,14061,14085,14101,14367,14566,
14602,14749,14928,15227,15273,15307,15480,15570,15616,15633,
15776,15841,15947,15958,15994,16002,16012,16042,16367,16463,
16704,16717,16777,16800,16978,17029,17124,17218,17238,17391,
17564,17673,17875,17892,17981,18094,18265,18291,18386,18556,
18697,18725,18772,18905,19311,19327,19419,19496,19550,19595,
19722,19726,19784,20008,20082,20162,20193,20220,20255,20286,
20316,20372,20376,20397,20512,20596,20634,20648,20801,21005,
21012,21149,21180,21234,21240,21249,21405,21468,21540,21559,
21606,21647,21705,21932,21951,21967,21972,21999,22010,22026,
22103,22369,22402,22479,22507,22658,22747,22809,22819,22919,
22988,23185,23244,23444,23539,23664,23673,23871,23897,23968,
24098,24304,24444,24643,24798,24859,24963,25019,25080,25100,
25104,25120,25238,25277,25782,25794,25810,26050,26055,26157,
26396,26420,26509,26534,26596,26607,26761,26837,27011,27167,
27177,27191,27206,27291,27417,27503,27793,27806,27848,27869,
27915,28033,28044,28269,28314,28324,28336,28341,28434,28483,
28553,28582,28862,29024,29067,29073,29076,29083,29101,29317,
29389,29518,29693,29716,29788,29799,29919,29957,29999,30057,
30165,30398,30581,30597,30609,30635,31223,31236,31310,31494,
31549,31579,31639,31931,31938,31953,  428,  441,  661,  877,
  971, 1541, 1560, 1648, 1730, 1808, 1890, 2054, 2147, 2361,
 3333, 3393, 3613, 3925, 4085, 4141, 4240, 4438, 4672, 4728,
 4833, 5263, 5527, 5636, 5699, 5993, 6199, 6419, 6733, 7213,
 7219, 7562, 8345, 8365, 8646, 8692, 8869, 9082, 9877,10139,
10149,10481,10689,10986,11154,11461,11756,11777,11804,12120,
12245,12395,12447,12540,12552,12675,12680,12756,12790,12795,
13028,13606,13882,14233,14299,14328,14542,14920,15018,15022,
15073,15105,15283,15321,15396,15828,15944,15962,16289,16528,
16570,16804,16850,17341,17384,17753,17817,17858,17884,18115,
18180,18495,18624,18644,18865,19022,19061,19659,19737,20390,
20601,20683,20690,21091,21144,21167,21915,22238,22573,23241,
23455,24131,24193,24318,24520,24653,24686,24734,24788,24873,
25054,25729,25940,26182,26260,26380,26465,26503,26514,26945,
27343,27479,28261,28443,28916,28925,29020,29045,29147,29349,
29625,29771,30034,30243,30449,30560,30761,30847,30867,31073,
31181,31584,31625,31901,31978,   76,  158,  480,  537,  786,
  984, 1024, 1200, 1233, 1256, 1280, 1591, 1851, 2022, 2206,
 2229, 2505, 2852, 3151, 3544, 3656, 3667, 3771, 3783, 4169,
 4327, 4454, 4483, 4876, 5155, 5279, 5341, 5431, 5831, 5999,
 6243, 6352, 6471, 6671, 7326, 7395, 7437, 7525, 7613, 7623,
 8140, 8328, 8460, 8573, 8700, 8745, 8773, 8917, 9343, 9376,
 9418, 9463, 9561,10056,10407,10430,10584,10763,10837,10893,
11141,11186,11262,12068,12248,12301,12897,13313,13529,13565,
13578,14342,14888,14893,15031,15050,15389,15677,15791,15896,
16128,16383,16408,16434,16550,16733,16914,17600,17712,17733,
18317,18343,18844,18876,18973,19045,19477,19507,19874,19925,
20425,20931,21053,21215,21330,21764,22293,22710,22742,22877,
23310,23357,23368,23496,23516,23915,24015,24037,24690,24727,
24985,25009,25192,25466,25505,25586,25981,26018,26062,26136,
26191,26356,26625,27032,27363,27564,27718,27812,27934,28456,
28849,29007,29219,29272,29483,29495,29861,30082,30107,30217,
30308,30350,30477,30742,30965,31558,31654,  801,  929, 1191,
 2708, 3175, 4459, 5298, 5670, 5713, 6012, 6449, 6722, 7189,
 8028, 8111, 8179, 8449, 8671,11198,11820,12956,14226,14273,
14716,15176,15448,15497,15796,16639,17502,17605,18936,19010,
19454,20857,21978,21994,22005,22082,22119,22331,22860,23553,
23878,23962,24524,24672,25737,27786,28728,29192,30097,31110,
31257,31782,31994,  307, 1760, 2183, 2938, 3776, 3793, 6795,
 7390, 7457, 7680, 9689,10112,10448,10611,10653,11424,12154,
13520,13558,13982,14437,14740,14810,15332,15707,17003,18189,
18351,20017,20073,22495,22535,22601,22778,23124,24238,24389,
25424,25820,26308,28492,28952,30046,30162,31318,  531,  589,
  776, 2582, 3739, 3759, 7360, 7913, 7924, 9720,10374,11349,
15428,15886,16278,17015,18134,19102,20692,21206,23084,24025,
25259,25887,27316,28190,28525,29406,29613,30976, 1589, 4044,
 6149, 6766, 6974, 9051, 9230, 9484,10908,12317,12391,13677,
15631,18979,19309,19436,19718,19796,21729,22541,23427,25418,
26776,26880,28134,28944,29829,30986,31717,  336, 2077, 2177,
 2718, 2780, 3109, 4656, 4826, 6109, 6964,10426,10659,11555,
11856,13351,13633,13954,14688,17134,18871,19029,20708,23373,
24641,24930,25669,27605,28900,31811,   53, 2070, 3076, 5308,
 5568, 7257, 7942, 8163, 8578, 9547,10414,10974,12901,13510,
15286,16333,16920,17122,18857,20168,22317,23187,23727,24083,
25442,25549,27003,28297,29797,30337,31698,31956,  933, 1288,
 3086, 3682, 4619, 6210, 8149, 9608,10291,10442,12569,14861,
14997,16285,17285,17635,18636,18754,21020,22756,23681,24146,
24245,24612,25198,25882,26176,26786,28248,28822,28930,30663,
31005,  622,  701, 2158, 3224, 3690, 3720, 4610, 4709, 6360,
 7217, 7991, 8359,10318,11836,13397,13462,13640,16323,16771,
18163,19653,19664,21858,22213,22873,23150,24778,26337,26995,
27407,27688,31225,31401,  325,  458, 1235, 1646, 1650, 3710,
 4284, 4699, 4767, 4907, 5529, 7702, 8406, 9472,11105,11409,
11573,11596,12063,12682,12747,12890,16028,17787,18336,18783,
19091,19340,20462,20510,21315,21459,21617,21670,23193,24134,
24417,24703,25651,28771,29250,30625,31308, 1018, 1678, 3023,
 3146, 3781, 5584, 5844, 6250, 6846, 7891, 8261, 8755, 8867,
 8924, 9131, 9734,10088,10958,12635,13165,13496,14316,14459,
14801,15394,16036,16083,16197,16989,17333,17489,17916,18849,
19706,19869,19923,20055,20174,20797,21158,21937,22207,23155,
23909,24678,24852,25281,26152,26169,27027,27354,27972,28046,
28111,28474,28692,29784,30090,30535,30579,31442,31791,   89,
  296,  300,  404,  439,  725,  860,  867,  879, 1046, 1099,
 1153, 1179, 1270, 1305, 1310, 1417, 1421, 1581, 1764, 1795,
 1854, 1927, 1933, 2002, 2011, 2137, 2244, 2356, 2365, 2373,
 2402, 2418, 2443, 2501, 2536, 2598, 2654, 2793, 3095, 3296,
 3315, 3412, 3418, 3551, 3763, 3791, 3807, 3877, 3885, 3943,
 4034, 4128, 4153, 4232, 4287, 4349, 4450, 4472, 4562, 4690,
 4736, 4743, 4821, 4871, 4887, 4895, 4914, 5008, 5023, 5135,
 5189, 5228, 5466, 5609, 5706, 5786, 5813, 5854, 5894, 5923,
 6030, 6337, 6349, 6459, 6555, 6560, 6598, 6615, 6625, 6648,
 6676, 6801, 6825, 6917, 7046, 7251, 7521, 7599, 7608, 7883,
 7930, 7938, 7952, 8177, 8295, 8318, 8399, 8471, 8587, 8666,
 8742, 8792, 8798, 8929, 9030, 9267, 9287, 9366, 9382, 9554,
 9725, 9818, 9889, 9906, 9954,10022,10032,10232,10241,10257,
10298,10315,10372,10518,10694,10769,10796,10812,10857,10863,
10910,10971,11064,11095,11236,11252,11266,11283,11299,11590,
11603,11734,11745,11750,11910,11917,12136,12150,12292,12354,
12393,12401,12413,12525,12574,12808,12822,12895,12980,13005,
13143,13185,13266,13311,13349,13482,13593,13635,13681,13726,
13746,13903,13947,14092,14160,14165,14305,14323,14363,14370,
14402,14409,14493,14633,14644,14675,14822,15007,15216,15279,
15302,15574,15712,15847,15873,16249,16397,16426,16453,16459,
16532,16671,16790,17013,17116,17161,17242,17253,17336,17364,
17590,17714,17727,17805,17814,17822,17860,17937,17959,18090,
18122,18248,18276,18717,18731,18885,18929,18961,19014,19110,
19289,19407,19414,19523,19623,19635,19711,19779,20012,20046,
20070,20109,20188,20243,20388,20465,20486,20661,20737,20745,
20791,20804,20842,20890,20978,21055,21069,21324,21385,21389,
21444,21528,21533,21550,21570,21640,21712,21754,21842,21855,
22089,22156,22175,22232,22339,22362,22388,22392,22414,22884,
22888,22899,22911,22944,23338,23388,23439,23587,23627,23638,
23861,24009,24081,24213,24267,24336,24541,24550,24633,24838,
24884,25050,25110,25170,25214,25283,25570,25580,25619,25647,
25833,26180,26198,26439,26442,26527,26734,26748,26815,26851,
26885,26899,26989,27158,27271,27486,27570,27607,27714,27766,
27814,27861,27883,27923,27963,28097,28192,28316,28379,28417,
28520,28550,28642,28659,28750,28808,29016,29071,29311,29377,
29415,29434,29450,29630,29651,29682,29690,29699,29809,29867,
29911,30055,30077,30155,30175,30234,30394,30414,30491,30736,
30756,30782,30883,30912,30995,30999,31012,31026,31055,31130,
31152,31159,31425,31456,31528,31712,31749,31758,31774,31780,
31834,31990,32035,   43,  317,  576,  818,  909, 2426, 2529,
 2736, 2835, 2880, 2991, 3006, 3138, 3919, 4276, 4431, 5092,
 5112, 5157, 5242, 5782, 5886, 6015, 6104, 6468, 6720, 6768,
 6873, 7003, 7029, 7164, 7496, 7788, 7832, 8418, 8541, 8571,
 8968, 9326, 9924,10227,10657,11275,11548,11981,12097,12339,
12496,12601,12751,13114,14118,14413,14464,15116,15245,15253,
15415,15483,15749,16224,16593,16743,16756,16769,16906,17214,
17230,17287,18240,18252,18672,18766,18891,18913,19072,19322,
19638,19745,19930,20037,20818,21073,21079,21431,21797,22166,
22205,22599,23140,23514,23645,23743,23749,23925,24062,24140,
24725,24783,25125,25194,25369,25498,25554,26184,26231,26507,
27130,27303,27394,27420,27469,27889,28460,28627,29139,29466,
29858,30004,30213,30377,30650,31042,31049,31112,31563,   24,
  873,  931, 1037, 1171, 1215, 1492, 1666, 1748, 2628, 2770,
 2850, 2907, 3555, 3688, 3857, 6021, 6064, 6093, 6229, 6382,
 6880, 6951, 7127, 7324, 8337, 8888, 9071, 9282, 9303, 9429,
 9616, 9793, 9835,10196,10263,10704,11208,11433,11646,11686,
11990,12116,12609,12769,13315,13383,13393,13413,13669,14619,
14947,15266,15466,15625,15699,16264,16351,16625,16795,16941,
17130,17183,17249,17403,18126,18368,18376,18641,18861,19034,
20164,20291,20566,20590,21788,21894,22100,22243,22385,22421,
22923,23005,23073,23298,24039,24822,24850,25062,25218,25572,
25672,25679,25849,25922,25971,26646,26766,27119,27618,27675,
28428,28514,28562,28864,28940,28959,29155,29295,29408,29611,
30475,31108,31212,31576,31708,31734,31815,  466,  699,  837,
 1206, 1385, 1452, 1671, 2217, 2572, 2745, 2997, 3371, 3539,
 3914, 4058, 4184, 4332, 5139, 5383, 5423, 5607, 5728, 6546,
 7050, 7117, 7158, 7202, 7534, 7573, 7809, 7977, 8516, 9127,
 9144, 9179, 9470, 9991,10077,10593,10668,11200,11450,11677,
12165,12349,12527,13084,14511,15069,15212,15295,15807,15937,
16081,16355,17025,17688,18296,18596,18709,18747,19164,19661,
19807,20026,20058,20077,20874,20893,21217,21565,21739,21925,
21960,22428,22895,22992,23014,23161,23251,23510,23960,24122,
24482,24846,25182,26021,26220,26519,26943,27143,27490,27554,
27782,27953,28280,28611,28734,28872,29200,29302,29387,29955,
30786,31444,  613, 1241, 1350, 1373, 1977, 2075, 2470, 2943,
 3091, 3705, 4245, 4386, 4555, 4638, 5265, 5774, 5793, 5858,
 6026, 6272, 6606, 7455, 8273, 8596, 8876, 8975, 9865,10531,
11374,11527,12379,12431,12905,13215,13956,14265,14471,14901,
15207,15563,15572,15834,15990,16667,17356,17761,17968,18246,
18304,19240,19334,19490,19536,20179,21628,21805,22477,23288,
23642,24208,24965,25593,26586,26621,27019,28374,29603,29846,
29894,30259,30484,30640,30738,30839,30942,30963,31008,31227,
31262,    4,   17,   48,  113,  671, 1298, 2160, 3113, 3462,
 4336, 5083, 5531, 5962, 6438, 6594, 7138, 8017, 8422, 8843,
 8910, 9108, 9380, 9629, 9729,10572,11383,11854,12205,12361,
12389,13646,14098,14103,14158,14214,14422,15582,16098,16438,
16774,16953,16994,17429,17976,18018,18334,19159,19979,20763,
20816,20994,22113,23119,24877,25279,25885,26350,26418,26447,
26755,27371,28696,29097,30224,31358,31753,  535,  695, 2391,
 2700, 2825, 2950, 3558, 4120, 4648, 4712, 5426, 5505, 5625,
 6099, 7172, 7372, 7423, 7769, 9522, 9635, 9891,10774,11248,
11407,11416,11831,12040,12253,13069,13299,13552,13758,14886,
14926,15027,15039,15787,16836,17150,17578,18002,18263,18473,
18585,20326,20419,20452,20460,20851,21750,22595,22760,22906,
23468,23506,23618,23773,23902,24518,24545,25702,26014,26140,
26532,26963,27850,27926,28037,28049,28255,28344,28763,29281,
31161,31388,31429,31630,   34, 1219, 1356, 1634, 2256, 2615,
 2896, 3163, 3228, 4272, 4487, 4533, 4931, 4950, 5057, 5187,
 5691, 5953, 6453, 7113, 7338, 8161, 8285, 8964, 9677,10471,
11478,11524,12941,13501,13663,14525,14990,15664,15684,16616,
16898,17487,17510,18312,18675,19127,19269,19690,20284,20392,
21153,21282,21801,22018,23883,24415,24669,24854,25457,25494,
26547,27264,27385,27390,28079,28527,28836,28893,29338,29707,
29815,29835,29974,30015,30363,31014,31128,31147,31969,  606,
  731, 2400, 2534, 2711, 3391, 3795, 4923, 5210, 6579, 7459,
 7909, 8749, 9028, 9461, 9465, 9544,10330,10437,10601,11422,
11968,12323,12436,12633,12694,13729,13788,13942,14254,14751,
14787,15384,15813,16329,17941,18260,18379,19138,19441,19484,
19591,19935,20005,20439,20607,20945,21190,21970,22360,22661,
22680,22795,23913,24435,24891,24981,25028,25615,25735,26196,
26265,26896,27081,27127,27791,29426,29906,30493,30537,30993,
31064,31808,31933,   39,  204,  842,  982, 1006, 1091, 1403,
 1652, 1887, 2695, 3712, 4474, 5027, 5259, 6619, 6932, 7544,
 8008, 8013, 8497, 8710, 9062, 9308,10313,10336,10428,10687,
11020,11571,12869,13587,13706,13734,13916,14260,14361,14627,
15610,16209,16908,17176,17731,18536,19039,19256,19363,19790,
20663,20830,21553,21708,22416,22505,22562,22974,23109,23268,
23752,24150,24281,24769,24776,24905,25597,25874,25958,26271,
26789,26820,27917,28100,28286,28348,29190,29924,30252,30461,
30734,31413,31873,  284,  334,  392, 1185, 1806, 2027, 2647,
 3205, 3676, 4036, 4379, 4771, 5104, 5445, 5462, 5677, 5825,
 5896, 6151, 7207, 7215, 7226, 7505, 7570, 7684, 8316, 8603,
 8846, 9514, 9758,10104,10726,10839,10979,11550,11723,12037,
12331,12405,13562,14344,14372,14931,15048,15248,15985,16091,
16444,17031,19043,19280,19915,19994,21463,21816,22438,22527,
23345,23541,23585,23629,24250,25004,25032,25393,25743,25760,
26048,26378,26923,27864,27977,28127,29417,29445,29594,30044,
30467,31244,31652,31980,   78,  130,  519,  734,  770, 1265,
 1303, 1313, 1801, 1972, 2248, 2335, 2348, 2445, 2788, 3265,
 3532, 3577, 3716, 3851, 3894, 4352, 4616, 4627, 4688, 5646,
 5683, 5717, 6056, 6179, 6186, 6226, 6394, 6493, 6692, 6938,
 7177, 7234, 7796, 7834, 7905, 8187, 8873, 9420, 9432, 9632,
10516,11041,11067,11238,11281,12810,12949,12990,13104,13126,
13460,13667,13792,14314,14985,14995,15298,15880,16202,16348,
16380,16530,16752,16781,17048,17696,17779,17830,17901,17948,
18191,18206,18514,18714,19123,19211,19325,19348,19451,19798,
20308,20358,20795,20838,20941,20973,21442,21510,22024,22319,
22483,22817,23280,23362,23843,24796,24886,24899,24914,25115,
25436,25547,25751,25827,26216,26364,26919,27034,27045,27345,
27476,27722,28386,28649,28934,29423,29500,30392,30531,30623,
30754,31067,31174,31504,31554,31784,  426,  822,  975, 1254,
 1465, 1539, 1620, 1674, 1744, 1751, 1931, 2009, 2013, 2048,
 2371, 2416, 2960, 3039, 3126, 3222, 3407, 3493, 3501, 3672,
 3757, 4269, 4315, 4512, 4560, 4661, 4670, 4885, 4939, 5225,
 5541, 5586, 5892, 6173, 6238, 6668, 7249, 7584, 7741, 7829,
 7845, 8086, 8330, 8362, 8387, 8538, 9123, 9137, 9148, 9457,
 9556, 9669, 9944, 9993,10068,10230,10478,10756,10884,10969,
11062,11072,11204,11243,11272,11489,11538,11770,11785,12190,
12452,12481,12492,12536,12785,13112,13151,13163,13399,13850,
14017,14248,14276,14430,14477,14706,14723,14875,15234,15251,
15518,15579,15650,15669,15673,15783,15949,16030,16135,16165,
16237,16613,16678,16847,17001,17545,17671,17764,17989,18100,
18255,18347,18458,18499,18661,18758,19396,19648,19668,19700,
19876,19906,20039,20080,20120,20253,20403,20428,20488,20767,
20902,21015,21142,21156,21175,21255,21420,21456,21773,21852,
21949,22150,22324,22667,22937,22941,23189,23256,23340,23524,
23563,23657,23920,23951,24007,24049,24165,24215,24320,24446,
24452,24489,24618,25310,25605,25621,25675,26009,26178,26223,
26276,26324,26809,26911,26993,27123,27169,27405,27560,27603,
27738,27992,28065,28252,28277,28331,28688,28800,28937,29011,
29069,29298,29461,29505,29790,29913,29917,29971,30262,30375,
30671,30768,30885,30997,31017,31306,31522,31602,31609,31762,
31929,   74,  259,  331,  410,  691, 1244, 1960, 3202, 3294,
 3708, 3741, 3923, 4001, 5015, 6635, 6761, 7184, 7729, 7899,
 7982, 8030, 8117, 8374, 8992, 9163, 9552,10394,11148,11738,
11793,11950,12504,13138,13570,14025,15319,16343,16376,17389,
17706,17743,17791,17820,18582,18723,19613,19630,20673,22096,
22618,22966,23047,24125,24464,24589,26121,26359,26715,27940,
27956,28197,28232,28546,29819,29827,30571,30602,31537,32033,
  829, 1084, 1876, 2274, 2967, 3761, 4347, 4360, 5006, 5687,
 5725, 6356, 6533, 7162, 7885, 8340, 8456, 9044,10030,10385,
10984,11581,11634,12009,12224,12903,12986,13130,13696,14037,
14308,15603,15910,16601,16788,17474,17873,17993,18269,20131,
20281,21697,22351,22382,22547,23291,24220,24843,25654,27279,
27358,28668,29134,29673,29856,31959,   20,  153, 1039, 2367,
 3619, 3697, 4452, 4873, 5090, 5289, 5668, 6003, 6287, 7061,
 7944, 8481, 8805, 9796, 9855, 9909,10074,11992,12055,12511,
13020,13256,13293,13962,16649,20214,21470,21543,21913,21985,
23163,23590,23685,24818,24909,24995,25048,25074,25468,26244,
26883,27288,28113,28368,28454,28726,28813,29965,31422,   31,
   51,  293, 1189, 1223, 1500, 2040, 3765, 4373, 5319, 5976,
 6461, 6589, 7191, 8005,10060,11227,11292,11377,13389,14076,
14480,14649,15761,16255,17010,17059,17426,17718,18300,18553,
19201,19342,19494,20506,21953,22394,22419,24158,24403,25207,
25448,26566,26642,26997,27017,27512,28676,31374,31407,32020,
 1057, 1258, 1293, 1762, 2567, 2691, 2812, 3170, 3177, 4162,
 4252, 5709, 5850, 5997, 6565, 6602, 6735, 7772, 7783, 8066,
 8107, 8322, 8584, 9510, 9934,10020,10625,11361,12218,12296,
12386,12498,12927,14163,14256,15330,15463,15628,16259,16385,
16471,16719,17019,17675,17690,18087,19080,19086,19359,19411,
20970,21220,21231,21243,21584,21835,22240,22491,22499,22672,
23671,24867,25564,26774,27108,27147,27234,27498,27566,28633,
28699,28874,29043,29141,29240,29769,29985,30113,30422,30853,
30865,31315,31685,   70,  238,  277,  302,  315,  355,  406,
  460,  545,  591,  663,  905,  914, 1162, 1471, 1563, 1586,
 1593, 1728, 1791, 1881, 1964, 1989, 2034, 2114, 2135, 2187,
 2213, 2332, 2354, 2414, 2433, 2575, 2702, 2730, 2828, 2833,
 2931, 2995, 3001, 3133, 3167, 3298, 3349, 3353, 3661, 3847,
 3946, 3980, 3997, 4073, 4098, 4104, 4132, 4338, 4658, 4677,
 4765, 4828, 4878, 4909, 4993, 5038, 5109, 5277, 5345, 5385,
 5389, 5596, 5604, 5641, 5819, 6107, 6215, 6231, 6241, 6253,
 6294, 6310, 6592, 6657, 6764, 6835, 6942, 7031, 7048, 7053,
 7296, 7453, 7611, 7710, 7881, 7947, 7959, 8158, 8165, 8335,
 8367, 8484, 8494, 8760, 8768, 8786, 8864, 8886, 8905, 9025,
 9047, 9084, 9141, 9259, 9531, 9570, 9619, 9666, 9879, 9887,
 9903, 9941,10012,10017,10024,10114,10177,10191,10276,10301,
10333,10440,10613,10616,10675,10699,10758,10798,10814,10832,
11110,11337,11351,11630,11657,11752,11842,11939,12051,12111,
12167,12368,12372,12590,12612,12640,12723,12816,12866,12931,
12964,13076,13146,13209,13274,13279,13549,13556,13637,13671,
13701,13713,13736,13880,14028,14059,14242,14292,14303,14415,
14528,14642,14726,14732,14737,14808,14852,14883,14895,14981,
14987,15036,15293,15406,15559,15695,15701,15849,15858,15997,
16007,16015,16019,16412,16669,16711,16758,16918,16933,17055,
17105,17138,17155,17412,17531,17685,17699,17740,17747,18008,
18137,18174,18250,18371,18435,18478,18545,18549,18577,18594,
18677,18711,18733,18873,18943,18954,19031,19069,19074,19173,
19306,19486,19621,19671,19704,19720,19872,19933,20048,20305,
20369,20395,20449,20569,20676,20706,20743,20756,20774,20807,
20814,20849,20991,21076,21202,21320,21339,21370,21439,21535,
21620,21770,21849,21910,21976,22031,22138,22275,22279,22310,
22364,22372,22514,22520,22721,22772,22785,22807,22984,23260,
23271,23307,23335,23520,23569,23677,23695,23737,23812,23840,
23895,23899,24136,24148,24162,24236,24264,24294,24394,24423,
24492,24504,24800,24830,25094,25154,25263,25295,25600,25613,
25633,25769,25925,25938,25945,25968,25979,26000,26057,26070,
26112,26125,26147,26155,26560,26591,26768,26901,27009,27023,
27084,27141,27223,27352,27580,27843,27859,27877,27996,28137,
28167,28171,28487,28568,28574,28663,28721,28831,29094,29113,
29153,29211,29221,29227,29267,29315,29485,29585,29660,29766,
29833,29839,29872,29909,30211,30279,30385,30446,30465,30533,
30549,30588,30592,30679,30861,31163,31333,31349,31586,31645,
31692,31705,32016,  808,  851, 2312, 2452, 3917, 4177, 5147,
 5572, 6075, 6919, 7316, 8926, 9092, 9114,10320,10915,11152,
12257,12969,13945,14475,15185,15257,15585,16467,17373,17966,
17974,18147,19055,19792,20413,20845,21275,21599,22001,22955,
23050,23576,23828,24248,24288,25167,25299,25994,26614,26887,
26972,27366,28480,28810,29397,30241,30558,31028,  298,  816,
  835, 1681, 1699, 2586, 2905, 3375, 3774, 3841, 4066, 5808,
 6082, 6662, 7255, 7557, 7779, 8282, 8781, 9297, 9370,10412,
10589,11039,11452,12337,13767,14176,14698,15662,16362,16584,
17088,17344,17421,18655,19466,19777,20208,21002,21121,21829,
23475,23508,23923,24077,25582,27779,28501,29091,30496,30845,
31369,31491,31611, 1016, 1980, 2926, 4510, 4515, 4750, 6744,
 7187, 7334, 7553, 7619, 8895, 9129, 9350, 9766, 9847,11779,
12070,13066,14040,14710,15769,15811,16213,16231,16652,17360,
18400,18638,18855,19502,20577,20821,21668,21939,22220,22688,
22701,23233,23303,25190,25289,25365,25452,25973,26392,26462,
27768,28430,30248,30359,30665,30758,31338,31398,31830,  221,
 1262, 1618, 1823, 2044, 3129, 3669, 4818, 5059, 6875, 7211,
 7601, 8104, 8464, 9246,11661,12118,12700,13117,13219,13333,
13896,14270,14454,14978,15413,15686,16148,17328,17437,17961,
18171,20363,20410,20455,21326,21356,22539,22716,22776,24345,
24508,25160,26553,26736,26764,27005,27136,27399,27709,28082,
30084,30775,30808,31269,31886,   91,  119,  323,  347,  497,
  638, 1833, 2197, 2321, 3078, 3422, 3590, 4344, 4667, 5094,
 5600, 5622, 5906, 6596, 6924, 7106, 8121, 8740, 9684,10255,
10771,11652,12134,12599,12775,14044,15113,15128,15141,15980,
16218,16901,17592,18289,18506,19352,20490,20547,21608,23044,
23683,23855,23938,24624,24715,25123,29514,29688,30408,30501,
30800,  655, 1478, 1575, 2038, 3718, 4005, 4303, 6114, 6161,
 6258, 6613, 6816, 6864, 7523, 7889, 8211, 8728, 8839, 8995,
 9181,10044,10416,11211,11288,11294,12550,12917,12978,14106,
14338,14523,14556,14612,15195,15205,16440,16542,17304,17912,
18203,19100,19228,19709,19817,21211,21603,22559,23248,24156,
25017,25509,26661,27102,27231,27382,28301,28946,29243,29542,
30160,31137,31238,31451,31597,31916,  126,  289,  351,  579,
  840,  919, 1173, 1204, 1376, 1543, 2549, 2725, 3008, 3337,
 3465, 3993, 4329, 4854, 5124, 5143, 5437, 5458, 5539, 5695,
 5711, 6147, 6583, 8564, 8679,10107,10117,10282,10462,11456,
11714,11766,11797,12107,12347,12958,12999,13073,13090,13890,
13974,14827,15262,15746,15902,16162,16291,16611,16748,17369,
17418,17870,18971,19402,19919,20000,21067,21171,22390,22788,
23010,23253,24922,26061,26209,26430,26602,27509,27846,28119,
28318,28351,28845,29081,29439,29904,29990,31826,31936,   60,
  585, 1061, 1388, 1430, 2270, 2661, 2754, 3403, 3482, 3580,
 4417, 4650, 5589, 5965, 6629, 6753, 7536, 7650, 7801, 8203,
 8308, 8789, 9314, 9486, 9862,10379,10391,11084,11179,11218,
11810,12233,12556,13839,14130,15290,16079,16629,16814,17290,
17431,17540,17795,17918,18020,18451,18821,19089,19698,19974,
20859,21188,21263,21731,21892,21907,22187,22738,24000,24514,
25039,25052,26798,27297,27529,27745,27904,28267,28388,28565,
28713,28718,28804,28816,30041,30541,30619,30818,31133,31509,
31607,31819,  705,  797, 2439, 2589, 2650, 2963, 3028, 3180,
 3560, 4047, 4313, 4447, 4499, 4631, 5655, 5878, 6417, 6689,
 7181, 7194, 7230, 7347, 7877, 7936, 8664, 9249, 9262,10711,
11043,11493,11732,11825,11936,12011,12159,12240,13098,13786,
13970,14115,14208,14679,14791,15275,16185,17023,17118,17575,
18119,18573,18919,19252,19539,19831,20467,20835,21819,22487,
22567,23198,23756,24017,24228,24527,25225,25503,25840,26333,
26407,26453,27349,27457,27801,28631,28732,29534,29979,30197,
30221,30826,30988,31363,31765,   37,  135,  197,  255,  273,
  342,  358,  720,  812,  862,  884,  916,  960,  996, 1093,
 1272, 1362, 1412, 1434, 1473, 1612, 1753, 1775, 1827, 1868,
 1929, 1935, 2067, 2144, 2148, 2170, 2378, 2410, 2429, 2456,
 2518, 2765, 2791, 2920, 2977, 3014, 3083, 3286, 3331, 3383,
 3429, 3495, 3499, 3514, 3679, 3701, 3728, 3737, 3768, 3778,
 3789, 3798, 3939, 4041, 4051, 4081, 4299, 4383, 4421, 4527,
 4549, 4726, 4730, 4755, 4761, 4812, 4936, 4966, 5030, 5152,
 5214, 5218, 5233, 5240, 5281, 5330, 5401, 5468, 5498, 5632,
 5679, 5771, 5827, 5868, 5913, 5995, 6089, 6166, 6171, 6182,
 6201, 6388, 6455, 6487, 6537, 6791, 6808, 6814, 6843, 6848,
 6977, 7011, 7209, 7237, 7312, 7320, 7375, 7414, 7529, 7627,
 7706, 7725, 7735, 7786, 7963, 7998, 8025, 8036, 8133, 8259,
 8304, 8503, 8531, 8607, 8653, 8659, 8683, 8716, 8747, 8794,
 8860, 8913, 8955, 8970, 9324, 9335, 9347, 9357, 9434, 9534,
 9644, 9648, 9652, 9754, 9802, 9805, 9873, 9884, 9900, 9989,
10058,10097,10278,10340,10400,10488,10504,10596,10650,10761,
10836,10878,10897,10965,10995,11002,11011,11017,11057,11077,
11138,11472,11535,11557,11568,11598,11609,11613,11673,11682,
11813,11816,11932,12029,12058,12138,12148,12186,12210,12487,
12545,12627,12687,12758,12802,12911,12937,12944,13003,13030,
13060,13173,13204,13260,13286,13336,13379,13408,13494,13691,
13710,13796,13842,13846,13856,14067,14135,14311,14318,14334,
14537,14549,14561,14623,14631,14664,14797,14848,14938,15077,
15218,15239,15391,15421,15434,15442,15446,15476,15587,15608,
15618,15641,15691,15839,15869,15898,15977,16034,16138,16142,
16179,16241,16251,16262,16321,16366,16395,16428,16707,16798,
16956,16965,17121,17171,17188,17236,17300,17319,17325,17414,
17588,17616,17825,17952,18081,18113,18161,18196,18321,18374,
18523,18598,18651,18700,18825,18834,18911,19052,19116,19120,
19145,19216,19254,19263,19320,19329,19345,19398,19468,19608,
19618,19645,19687,19716,19724,19750,19842,19927,20181,20206,
20232,20287,20408,20434,20457,20475,20574,20632,20686,20700,
20783,20888,20951,21031,21047,21087,21093,21131,21251,21317,
21360,21383,21557,21591,21594,21814,21845,21955,21990,22110,
22123,22195,22209,22245,22284,22551,22589,22664,22676,22698,
22734,22801,22804,22916,22961,22986,23053,23102,23130,23319,
23396,23442,23466,23482,23504,23529,23533,23556,23650,24065,
24106,24113,24118,24222,24387,24411,24457,24469,24597,24739,
24834,24881,24927,24987,25036,25060,25164,25249,25377,25396,
25464,25623,25639,25666,25685,25757,25767,25784,25798,25853,
25942,26029,26076,26115,26204,26212,26235,26256,26319,26329,
26627,26637,26652,26696,26732,26952,27090,27204,27218,27305,
27379,27464,27501,27523,27536,27556,27562,27613,27659,27673,
27874,27898,27911,27969,27980,27988,28143,28153,28226,28243,
28250,28451,28464,28518,28530,28557,28640,28704,28885,28908,
28950,29063,29109,29128,29186,29278,29309,29429,29529,29576,
29634,29648,29703,29731,29792,29995,30002,30010,30074,30205,
30284,30418,30455,30629,30642,30721,30765,30939,30981,31021,
31071,31231,31242,31255,31341,31383,31427,31540,31736,31772,
31793,31880,31899,31967,  224,  442,  502,  666,  679, 2000,
 2464, 2707, 2752, 4087, 4249, 4309, 5055, 5310, 5515, 6111,
 6220, 7597, 7634, 7814, 8736, 9301, 9411, 9448, 9814,10524,
11081,11447,11592,13007,13345,13739,13868,14287,14296,14544,
14866,15567,15875,16538,16595,16972,17200,17283,17598,17710,
17738,19828,20053,20123,20201,20614,21376,21588,22622,23093,
23906,23932,24013,24284,25068,25236,25348,25890,26246,26385,
26722,27133,27484,28505,28847,29476,29644,29877,30079,30868,
30923,31519,31594,31840,  718,  965, 3401, 3473, 4054, 4158,
 5256, 5671, 5840, 6284, 7355, 7500, 7718, 9040, 9567,10434,
10464,10702,10998,11565,12236,12313,13374,15111,15716,16643,
16854,17034,17294,17894,18689,19297,19597,20086,20594,20636,
20679,21331,21347,22821,22990,23330,25211,26037,26161,26564,
27895,28739,28866,29003,29224,29404,29521,29640,29760,30036,
30296,31119,   10,  449,  703, 1116, 2084, 2359, 3105, 3311,
 3425, 4261, 4805, 6638, 7077, 7823, 8096, 9096,10009,10110,
10129,12192,13176,14212,14466,14845,15361,15863,16673,16949,
17558,18532,19169,19462,20031,20956,21226,21450,23380,23430,
25241,25269,25688,26841,26848,27377,27775,28857,30744,31144,
31194,  435,  992, 2117, 2404, 3184, 3903, 4165, 4389, 5100,
 7753, 8221, 8560, 9171, 9275,10370,10678,10822,10975,12438,
13835,13935,14905,15313,15401,16075,17856,19859,19864,20321,
20502,20751,21427,21737,22616,23174,23352,23640,24253,24808,
25200,26537,26742,26785,26826,28498,28965,30151,30179,30823,
31360,31377,31893,31913,  505,  647, 1597, 1860, 2124, 2223,
 2652, 3188, 3410, 4653, 5204, 6558, 7148, 7588, 8064, 8384,
 9226, 9705,10853,11221,11246,11545,11963,12216,12710,13325,
14447,14910,16713,16999,17580,18476,18589,18648,18948,19434,
19642,20044,22134,22534,22878,23278,24042,24897,25112,25275,
26702,26986,27460,28131,28263,29054,29149,30381,30429,30674,
  401,  483,  493,  615, 1601, 1820, 1949, 2131, 2250, 2761,
 3357, 3459, 4890, 5043, 5052, 5096, 5120, 5268, 5701, 6193,
 6440, 6482, 6948, 6968, 7358, 7757, 8378, 8882, 9698, 9930,
10637,10720,10901,11979,12422,12830,13086,13272,13486,13579,
13775,15052,15088,15132,15136,15644,15654,16191,16399,16446,
16745,16849,17378,18055,18079,18501,18511,18659,18941,18964,
19094,19300,21766,22094,22203,22570,23003,23114,23168,23653,
24341,24466,24471,24500,24581,25023,25608,25629,25663,26498,
27506,27533,27539,27548,27663,27986,28002,28092,28818,29491,
29517,29572,29582,29670,30545,31796,31817,32013,  408,  468,
  489, 1002, 1176, 1295, 1316, 1423, 1606, 1637, 1687, 1770,
 1847, 1974, 2305, 2387, 2554, 2889, 2910, 3148, 3173, 3195,
 3328, 3345, 3608, 3684, 3954, 4090, 4292, 4503, 4618, 4734,
 5192, 5333, 5477, 5612, 5681, 5790, 5836, 5971, 6236, 6270,
 6376, 6540, 6783, 6857, 6962, 7043, 7123, 7174, 7264, 7300,
 7575, 7641, 7954, 8074, 8088, 8276, 8512, 8526, 8534, 8644,
 9153, 9176, 9252, 9414, 9520, 9831, 9850, 9952,10052,10125,
10219,10376,10398,10484,10499,10642,11050,11174,11387,11586,
11668,11909,12020,12178,12320,12381,12604,12908,12975,13254,
13263,13405,13532,13574,13718,13732,13760,13862,13990,14225,
14347,14617,14743,14863,14869,15010,15032,15364,15373,15457,
15501,15965,15983,16133,16462,16562,16739,16766,16825,16860,
16975,17351,17608,17758,17803,18075,18098,18167,18244,18324,
18739,18768,19418,19424,19439,19547,19656,19692,20003,20170,
20225,20771,20832,21007,21061,21277,21453,21514,21723,21759,
21934,22049,22228,22345,22657,22767,22903,22949,23326,23376,
23699,23867,23881,23945,24110,24127,24292,24331,24392,24454,
24600,24814,24934,25172,25488,25500,25602,25773,25835,25862,
25931,26233,26342,26558,26575,26579,26802,26905,27210,27221,
27373,27429,27493,27519,27616,27695,27892,28105,28246,28342,
28356,28422,28552,28686,28903,28954,29464,29718,29728,29800,
29807,29869,29884,30094,30598,30654,30726,30740,30877,30970,
31024,31188,31297,31390,31458,31526,31565,31727,31805,32037,
  286,  320,  714,  787,  889, 1267, 1348, 1438, 1537, 1571,
 1624, 2531, 2640, 2795, 3284, 3511, 3694, 3786, 4062, 4125,
 4150, 4567, 5237, 6177, 6266, 6277, 6448, 7224, 7586, 7932,
 7989, 8099, 8223, 8270, 8390, 8401, 8408, 8891, 9361, 9481,
 9502, 9615,10225,10406,10682,11562,11583,11641,11851,11961,
11983,12644,13025,13684,13986,14110,14281,14325,14832,15017,
15108,15125,15679,16023,16088,16149,16360,16387,16431,16924,
17179,17196,17399,17585,17752,18490,18561,18646,18776,19208,
19317,19674,19825,19857,20295,20670,20982,21074,21353,21525,
21597,21823,22184,22503,22591,22866,23192,23487,23644,24051,
24232,24398,24539,24874,24903,25234,25627,25952,27037,27515,
27885,28234,28637,28647,28737,29695,30594,31524,31891, 1165,
 1642, 1672, 1695, 1740, 2242, 2545, 2804, 2949, 3035, 3456,
 3892, 4490, 4645, 4716, 4941, 5392, 5464, 5576, 6308, 6496,
 6965, 7125, 7502, 7818, 8380, 8712, 8731, 8743, 9719, 9955,
10195,10262,10285,10327,10432,10992,11144,11278,11340,11729,
11871,12003,12356,12734,12900,12966,13088,13354,13563,14023,
14879,15086,15192,15287,15459,16096,16565,17061,17311,17707,
17721,18200,18242,18493,18761,19602,19887,19941,20042,20172,
20186,20301,20442,21281,21372,21781,21998,22211,22411,22490,
22544,23282,23315,23957,23969,24385,24474,24802,25021,25174,
25202,25351,25486,25659,26273,26515,26792,26968,27286,27418,
28102,28516,28820,28882,28922,29041,29296,29532,29590,29663,
30250,30605,30804,31247,31354,31689,31730,31943,31974,  635,
 1277, 2231, 2344, 2506, 2607, 2743, 3468, 3542, 3963, 4242,
 5035, 5068, 5685, 5861, 6240, 6409, 6971, 7241, 7391, 7638,
 7648, 7751, 8661, 9565, 9680,10382,10473,10843,11867,11929,
12099,12415,12684,12727,13056,13361,13576,13980,14063,14239,
14491,14889,15370,15972,16391,16448,16762,17537,17807,17876,
18729,18887,19395,19475,20256,20306,20469,20651,20934,21177,
21505,21658,21772,22172,22689,23116,23164,23393,24462,24697,
25537,25551,25804,26225,26443,26959,27001,27138,27757,27929,
28157,29620,30099,30370,30554,30652,30814,30881,30929,30958,
30974,31058,31203,31567,32004,32023,  397,  431,  741,  856,
 1250, 2064, 2773, 2882, 2973, 3570, 4195, 4289, 4641, 5910,
 5925, 5989, 6644, 7068, 7687, 8398, 8693, 9331, 9881,11171,
12013,12691,12763,13516,13921,14074,15612,15954,16344,16664,
19428,20068,20096,20518,20777,21136,21625,22705,23513,23526,
24046,24055,24255,24721,25221,26456,26781,26833,26908,26918,
26979,27592,29136,29824,29897,30118,30231,   68,  603,  902,
 1987, 3018, 4181, 4701, 4912, 5315, 6096, 6206, 6224, 7807,
 7939, 8300, 8360, 8650, 9280, 9701, 9728, 9745,11189,11430,
11970,12333,13559,14169,14252,14564,16101,16436,17332,17381,
18089,18156,18439,18770,20623,20865,22237,22500,22770,23066,
23171,24230,24973,25087,25206,27840,27954,28842,28869,30102,
30257,30264,30365,  228,  629, 1264, 1693, 3032, 3088, 3587,
 4477, 4710, 4882, 6041, 6545, 9732, 9854,10672,10777,11328,
11358,12427,12992,13018,13930,14470,16793,16828,17442,17499,
17506,18328,18485,18831,19267,21077,21638,21775,21919,22097,
22526,23180,23537,24133,24203,25108,25823,25893,26390,26930,
27487,28378,29125,29481,29666,31176,31432,31511,31982,    7,
 1118, 1732, 1836, 2324, 3556, 4263, 4359, 4611, 5413, 5512,
 6346, 6748, 6944, 7014, 7440, 7794, 7951, 7967, 8585, 8858,
10403,11414,11955,12740,13589,13649,13853,13948,14707,15045,
15246,15881,17485,18071,18743,20811,21208,22554,22862,23823,
24023,24259,24857,24997,25598,25754,26129,26605,28116,28135,
28560,29119,29348,30301,  233,  249,  281, 1088, 1168, 1275,
 1352, 1558, 1779, 2246, 2253, 2267, 2395, 2467, 3143, 3182,
 3217, 3844, 3883, 3900, 3921, 4236, 4271, 4355, 4531, 4956,
 5098, 5398, 5666, 5692, 5954, 6571, 6686, 7114, 7244, 7345,
 7363, 7387, 7531, 7934, 8214, 8804, 8849, 9103, 9269, 9617,
 9740, 9908, 9996,10132,10273,10521,10795,10820,11215,11435,
11483,11525,11595,11649,12126,12294,12399,12434,12514,12597,
12805,12914,12924,13079,13155,13342,13484,14018,14366,14433,
14485,14694,14872,15168,15468,15590,15818,15951,16054,16283,
16661,16735,16750,17193,17203,17228,17335,17376,17630,18704,
18926,18958,19058,19161,19364,19413,19743,19803,19892,19900,
20006,20191,20271,20495,21021,21379,21424,21542,21611,22038,
22087,22162,22815,22947,23378,23387,23621,23647,23780,24086,
24103,24142,24900,24925,25196,25271,25449,25954,26051,26228,
26629,26933,26936,27116,27267,27543,27551,27584,27798,27921,
28060,28098,28765,29089,29112,29131,29230,29413,29436,29842,
29972,30185,30411,30438,31061,31323,31531,31577,31743,31809,
31955,31976,   65,  138,  154,  394,  445,  464,  542,  865,
 1007, 1066, 1181, 1207, 1402, 1415, 1493, 1582, 1758, 1805,
 1855, 1937, 2175, 2200, 2349, 2525, 3160, 3207, 3232, 3485,
 3518, 3721, 3753, 3879, 4032, 4190, 4368, 4513, 4570, 4615,
 4636, 4768, 4817, 4868, 4879, 4924, 4938, 5079, 5302, 5379,
 5617, 5628, 5724, 5829, 5833, 5968, 5978, 6336, 6350, 6585,
 6612, 6634, 6829, 6952, 6992, 7005, 7060, 7129, 7229, 7368,
 7644, 7652, 7690, 7764, 7810, 7974, 7981, 8567, 8676, 8901,
 8931, 9024, 9032, 9053, 9081, 9159, 9490, 9641, 9721, 9821,
 9958,10005,10038,10456,10503,10631,10913,10960,11260,11420,
11427,11491,11726,12054,12181,12522,12538,12576,12745,13180,
13329,13697,13705,13906,13968,14271,14513,14531,14645,14745,
14803,14820,15100,15122,15196,15220,15367,15405,15519,15814,
15885,15988,16223,16352,16422,16479,17109,17220,17224,17482,
17512,17532,17621,17746,17933,18001,18172,18464,18563,18722,
18878,18890,18907,18951,19047,19065,19166,19504,19652,19662,
19679,19689,19907,19972,20107,20222,20370,20472,20546,20762,
20898,20989,21064,21362,21458,21548,21634,21707,21796,21859,
21912,22301,22327,22371,22468,22605,22700,22715,22750,22779,
22912,23079,23243,23494,23751,23929,23966,24301,24442,24460,
24481,24592,24627,24793,24929,25482,25539,25699,25808,25816,
25926,25962,26166,26171,26377,26402,26441,26459,26529,26618,
26623,26710,26759,26836,26893,27235,27660,27667,27771,28320,
28371,28462,28470,28578,28613,28666,28700,28835,29014,29079,
29102,29393,29449,29467,29698,29786,29879,30157,30276,30339,
30480,30575,30583,30633,30854,30934,30991,31114,31170,31221,
31450,31461,31492,31695,31714,31754,31989,  314,  384,  690,
  923, 1261, 1292, 1617, 2398, 2406, 2503, 2655, 2703, 2712,
 2721, 2740, 2768, 2922, 3005, 3029, 3192, 3203, 3479, 4116,
 4295, 4467, 4930, 5230, 5246, 5296, 5403, 5522, 5624, 5647,
 6017, 6275, 7221, 7270, 7328, 7803, 7911, 8310, 8350, 8782,
 8800, 8834, 9107, 9307, 9455, 9478, 9515, 9602, 9752, 9869,
10600,10660,10692,10809,10947,11254,11355,11543,11845,12185,
12249,12261,12325,12336,12508,12749,12970,13275,13550,13582,
13592,13692,13829,13879,14108,14220,14439,14497,14535,14540,
15068,15103,15139,15186,15576,15614,15658,15665,15945,16206,
16457,16658,16802,16866,17007,17281,17365,17544,17909,18188,
18310,18362,18367,18396,18481,18632,18903,18978,19241,19736,
19799,20014,20309,20407,20654,20803,20840,20940,20949,21344,
21395,21622,21769,21792,22041,22224,22358,22725,22983,23239,
23447,23469,23479,23534,23707,23809,23884,24152,24309,24477,
24607,24659,24700,25072,25231,25828,26006,26830,27273,27340,
27670,27690,27787,27957,27974,28064,28332,28477,28619,28623,
29152,29379,29960,30006,30399,30426,30447,30951,31454,31733,
31778,31823,  486,  533,  548,  598,  642,  772,  999, 1097,
 1282, 1489, 1882, 2341, 2380, 2566, 2735, 3131, 3238, 3362,
 3420, 3489, 3504, 3523, 3582, 3596, 3658, 3666, 3808, 4108,
 4521, 4580, 4629, 4663, 4708, 4813, 5025, 5063, 5898, 5921,
 6043, 6214, 6228, 6296, 6372, 6386, 6673, 6728, 6818, 7062,
 7156, 7399, 7897, 7928, 7958, 7992, 8106, 8363, 8689, 9146,
 9229, 9255, 9364, 9569, 9623, 9859,10067,10087,10121,10140,
10828,10873,10880,10956,11094,11411,11528,11575,11827,11838,
12045,12064,12158,12411,12494,12503,12672,12951,13395,13555,
13569,14613,14841,15043,15285,15407,15629,15674,15774,15832,
16171,16357,16378,16486,16592,16645,17021,17111,17158,17343,
17425,17628,17920,17935,18154,18389,18399,18450,18662,18718,
19018,19109,19139,19392,19421,19728,19895,19938,20374,20484,
20630,20781,20852,20894,21194,21644,21748,21810,21889,21924,
21928,22427,22485,23069,23148,23462,23502,23565,23680,23715,
23745,24210,24322,24357,24718,24811,25031,25251,25355,25472,
25587,25649,25881,25934,26135,26305,26334,26365,26395,26409,
26571,26655,26753,26915,27395,27739,27856,28089,28160,28188,
28296,28609,28634,28657,29425,29653,29817,30048,30068,30091,
30105,30176,30416,30577,30926,31001,31009,31214,31534,31622,
31710,31896,  621,  658, 1049, 1060, 1395, 1404, 1410, 1853,
 1968, 2277, 2637, 2692, 2942, 3574, 4039, 4130, 4442, 4564,
 4751, 4839, 4952, 4962, 5084, 5381, 5812, 5864, 5918, 6357,
 6451, 7341, 8175, 8219, 8523, 8598, 9091, 9318, 9459, 9723,
10269,10482,10533,10582,10670,11168,11230,11241,12170,12307,
12578,12615,12676,12738,12945,13148,13503,13651,13911,14403,
14441,14714,15114,15171,15325,15376,15504,15751,15794,16424,
16621,16731,16991,17240,17444,17789,17890,18283,18508,19235,
19245,19406,19670,19685,20210,20560,20695,21241,21417,21440,
21566,21573,21662,21901,22009,22475,22515,22560,22939,23284,
23437,24035,24836,25076,25157,25305,25429,25480,25568,25786,
25832,26063,26422,26728,26795,26948,27008,27156,27324,27653,
27811,27952,28177,28481,28748,29085,29451,29499,29681,29773,
29988,30014,30188,30272,30722,30812,31053,31066,31265,31506,
31615,31960,  514, 1125, 1564, 2219, 2775, 2955, 4186, 4460,
 4553, 5307, 5395, 5645, 6050, 6411, 6746, 6841, 6845, 6994,
 7142, 7370, 8012, 8191, 8517, 8540, 8614, 8720, 9243, 9605,
 9664, 9922, 9926,10040,10446,10708,10951,11487,12397,12417,
12982,13221,13545,14291,14435,14560,14738,15002,15020,15453,
15464,15907,16573,17038,17248,17571,18727,18745,19223,19277,
19741,20268,20356,20416,20984,21040,21072,22242,22466,22927,
23064,23146,23236,23964,24144,24440,24483,24595,24695,24861,
24999,25106,25312,25777,25993,26044,26889,27087,27581,28198,
28452,28458,29236,29314,29402,29714,29778,29866,29981,30342,
31044,31345,31350,31370,31570,31591,31606,31883,  823,  872,
  908, 1158, 1877, 2240, 2338, 2514, 3413, 3856, 3972, 4692,
 4742, 4994, 5021, 5066, 5243, 5343, 5783, 5823, 6684, 6774,
 6884, 7018, 7112, 7443, 7551, 8696, 8990, 9121, 9166, 9620,
 9863,10083,10221,10859,10886,11191,11479,11743,11920,12001,
12042,12213,13186,13208,13519,13744,14181,14261,14685,15592,
16093,16225,16818,17145,17748,17815,18572,18630,18690,18752,
18980,19624,19806,19987,20128,20244,20482,20492,20987,21138,
21401,21475,21613,21652,21777,22181,22528,22889,23110,23365,
24350,24511,25404,25866,26131,26346,26779,27041,27713,27720,
28086,28133,28155,28241,28767,28861,28901,29569,30229,30451,
30474,30570,30589,30820,31908,   62,  109,  962, 1183, 1197,
 1621, 1667, 2053, 2079, 2527, 2539, 2634, 2738, 2779, 3096,
 3178, 3230, 3814, 4370, 4469, 4861, 4927, 6019, 6338, 6444,
 7607, 7697, 7730, 8294, 8358, 8404, 8563, 8909, 9057, 9231,
 9571, 9827, 9946,10089,11046,11160,11205,11257,11523,11757,
11796,12104,12797,12939,13094,13257,14041,14284,14401,14794,
15096,15580,15757,16020,16710,16775,16806,16928,17327,18003,
18063,18504,18548,18773,19305,19522,19968,20643,21168,21398,
21404,21636,22004,22222,22398,22773,22996,23389,24097,24195,
25657,26013,26339,26520,26735,27030,27225,27590,28109,28337,
28419,28511,28652,29029,29391,29622,29655,29733,29892,30050,
30356,30732,31610,31627,32019,  215,  592,  721,  861, 1032,
 1111, 1231, 1287, 1458, 1767, 1965, 2015, 2127, 3550, 4105,
 4124, 4193, 4427, 4835, 5490, 5952, 5998, 6033, 6085, 6200,
 6477, 6751, 6834, 7000, 7009, 7299, 7545, 7593, 7815, 8035,
 8085, 8288, 8455, 8577, 8727, 8796, 9227, 9264, 9712,10043,
10223,10371,10475,10782,11088,11390,11751,11864,12724,12829,
13006,13478,13834,14335,14416,14467,14495,15318,15417,15441,
16067,16219,16365,16386,16568,16624,16934,17565,17783,17967,
17998,18178,18184,18268,18303,19015,19483,19554,19834,19855,
19917,20167,20578,20593,21319,21531,21629,21856,22348,22574,
23000,23856,24584,24604,24667,24682,24712,25043,25057,25389,
25793,25864,25877,26468,27186,27190,27559,28283,28534,28567,
28580,28687,29608,29686,30236,30304,30599,30693,30945,31007,
31151,31167,  105,  142,  225,  242,  352,  413,  700,  836,
 1080, 1355, 1891, 1921, 1943, 2259, 2552, 2563, 2596, 2620,
 3271, 3318, 3341, 3348, 3559, 3686, 3692, 4337, 4343, 4376,
 5058, 5581, 5710, 5870, 6080, 6595, 7044, 7522, 7600, 7770,
 8303, 8475, 8704, 9067, 9332, 9686, 9824,10127,10215,10527,
10770,10891,11379,11915,12166,12175,13105,13268,13337,13541,
13600,13771,13944,14506,14641,14790,14856,14916,15038,15661,
15687,16753,16830,16904,16913,16963,16984,17164,17168,17880,
18019,18048,18340,18446,18479,18692,18843,18847,19314,19517,
19637,20202,20250,20613,20620,20698,20964,21028,21641,21717,
21762,22612,22673,22856,22896,22967,23232,23519,23636,23682,
23835,24072,24114,24237,24273,24932,25360,25563,26030,26360,
26690,27302,27346,27361,27410,27481,27700,28138,28233,28551,
28638,29062,29074,29531,30019,30167,30871,31877,31985,32036,
   84,  266,  285,  326,  804,  852, 1076, 1435, 1792, 1979,
 2507, 2900, 3392, 3929, 4061, 4155, 5349, 5420, 5473, 6268,
 6375, 6429, 6552, 7758, 8077, 8197, 9154,10183,10202,10300,
10421,10643,10918,10991,11401,11438,11465,11747,12241,12383,
12729,13026,13662,14458,14925,15210,15940,16150,16442,16468,
16476,17797,17945,18515,18682,18732,19456,20669,21314,21743,
22712,22793,23167,23320,23544,23676,24919,24961,25016,25417,
26193,26253,26784,27502,27577,27966,28120,28472,28956,29140,
29326,29678,29886,30443,31217,31720,   56,  979, 1071, 1446,
 1865, 2228, 2457, 2578, 3673, 3717, 3874, 4111, 4138, 4351,
 5273, 5459, 5985, 6106, 6291, 6397, 6454, 6736, 7379, 7878,
 8662, 8735, 8872, 8984, 9354, 9695,10059,10192,10983,11040,
11539,12024,12776,13099,13455,13493,13525,13700,13972,14117,
14517,14671,15076,15201,15255,15488,15897,16204,16271,16900,
17331,17484,17702,18353,18468,18837,18870,19132,19465,19791,
20115,20219,20263,20274,20831,21010,21893,22343,22569,22629,
22690,23202,24244,24297,24333,25411,25644,25693,25739,25858,
26164,26853,27101,27684,27805,28247,28293,29004,29289,29419,
29765,30108,30393,30566,30796,31298,31320,31426,31829,31941,
  201,  235,  290,  538, 1175, 1798, 1955, 2976, 3024, 3806,
 4480, 4724, 4850, 5091, 5132, 5207, 5526, 6150, 6232, 6956,
 6982, 7631, 8065, 8530, 8586, 8952, 9128, 9658,10245,10296,
11195,11293,11415,11455,11753,11859,12448,12812,13067,13445,
13847,14048,14077,14088,14126,14154,14557,14742,15181,15620,
15999,16210,16243,16525,16537,17018,17396,17492,17769,17951,
18597,18970,19105,19144,19155,19512,19677,20233,20377,20584,
20768,21083,21184,22014,22170,22355,22578,22786,23249,23659,
23767,23841,24123,24204,24407,24609,24651,24815,25093,25543,
25632,25768,26582,26632,27089,27414,27728,28170,28886,29247,
29704,29862,30031,30265,30286,30292,30409,30471,30750,31389,
31997,  210,  311,  461,  628,  974, 1121, 1299, 1418, 1427,
 1466, 1486, 1578, 1754, 1828, 1928, 1973, 2198, 2204, 2236,
 2560, 2616, 2760, 2792, 3153, 3275, 3354, 3400, 3428, 3520,
 3651, 3758, 3799, 3861, 3889, 3957, 3979, 4089, 4703, 4809,
 4842, 5117, 5198, 5495, 5507, 5599, 5981, 6155, 6256, 6379,
 6439, 6470, 6499, 6947, 7169, 7182, 7260, 7297, 7311, 7383,
 7426, 7447, 7776, 7795, 7902, 8080, 8138, 8493, 8515, 8561,
 8978, 9087, 9220, 9237, 9444, 9535, 9883,10095,10323,10402,
10573,10622,10649,10723,10869,11024,11622,11651,11762,11904,
12010,12117,12371,12571,12713,12743,12784,12891,12985,12998,
13091,13119,13318,13536,13597,13632,13759,13875,13938,14229,
15059,15072,15142,15478,15605,15870,15955,16161,16188,16214,
16267,16551,16604,16842,16896,17307,17348,17574,17603,17670,
17887,17900,17911,17930,18011,18067,18519,18688,19056,19087,
19151,19202,19435,19810,19883,19910,20091,20315,20709,21035,
21051,21162,21261,21321,21327,21411,21728,21906,21946,21966,
22131,22214,22295,22316,22391,22538,22879,23099,23138,23182,
23312,23336,23690,23924,24258,24280,24354,24685,24731,24908,
24986,24996,25046,25205,25614,25799,25846,25948,26081,26116,
26201,26262,26419,26510,26643,26737,26813,26845,26955,27079,
27093,27142,27172,27178,27296,27320,27327,27357,27430,27677,
27790,27888,28423,28506,28731,28824,28867,28917,28927,29049,
29068,29127,29191,29216,29808,29921,30161,30402,30466,30686,
30842,30966,31175,31206,31404,31516,31644,31693,31825,31919,
  230,  306,  354,  474, 1361, 1645, 1688, 2309, 3009, 3102,
 3603, 4291, 4310, 4496, 4719, 5222, 5339, 5429, 5448, 5520,
 6192, 6221, 6655, 6861, 7165, 7419, 7499, 8209, 8291, 8658,
 8729, 8941, 9078, 9188, 9452, 9673, 9985,10187,10307,10508,
11371,11471,11776,11801,11933,11980,12208,12439,12482,12719,
12965,13063,13072,13707,14148,14353,14414,14503,15329,15589,
15663,15685,15744,15891,16156,16175,16198,16328,16857,16980,
17370,17610,17722,17778,18251,18401,18524,19024,19126,19452,
19633,19782,19843,20063,20626,20750,20873,20929,21078,21148,
21981,22044,22191,22309,22472,22525,23133,23817,23849,23862,
24529,24870,24890,24968,25266,25791,25854,26150,26599,26745,
27024,27496,27991,28306,28357,28429,28515,28716,29205,29346,
29458,29470,30194,30309,30488,30745,30857,31027,31111,31316,
31968,  523,  646,  828, 1092, 1161, 1214, 1631, 1999, 2152,
 2447, 2610, 2653, 2934, 2988, 3118, 3194, 3853, 4229, 4448,
 4519, 4877, 5127, 5731, 5778, 6239, 6408, 6821, 6935, 7056,
 7153, 7580, 7749, 8009, 8508, 8649, 8960, 9329, 9438, 9688,
 9718, 9749,10143,10523,10805,10964,11251,11531,12229,12541,
12918,13851,13865,13978,14105,14138,14178,14529,14656,15189,
15435,15848,16833,17235,17513,18393,18457,18736,19285,20022,
20382,20514,20551,20855,20869,21192,22177,22231,22287,22300,
22531,22932,22973,23454,23728,23776,24132,24453,24463,24617,
24917,24976,25748,26313,26559,26578,26714,27423,27573,27842,
28193,28754,28911,29322,29604,29830,30154,30226,31329,31651,
31739,31766,32024,    1,  511,  601,  847, 1003, 1308, 1431,
 1507, 2025, 2055, 2522, 2660, 2724, 3280, 3417, 3749, 3983,
 4074, 4092, 4434, 4696, 4766, 4800, 4998, 5140, 5503, 5797,
 5818, 6038, 6060, 7159, 7516, 7598, 7721, 7836, 8341, 8453,
 8672, 8741, 9549, 9609,10045,10586,11035,11070,11365,11405,
11567,11812,11868,12130,12623,12827,12887,13170,13778,14024,
14122,14277,14512,14792,14939,15014,15024,15238,15419,15498,
16632,16740,17148,17549,17956,17965,18292,18568,18750,19355,
19491,19609,20196,20259,20396,20496,20759,21042,21579,21784,
21952,22379,22608,22853,23279,23371,23717,23973,24020,24059,
24092,24580,24894,25210,25682,26075,26158,26181,26424,27010,
27160,27331,27593,27725,27744,27884,28053,28083,28680,29477,
29633,30395,30562,31185,31800,31923,31944,   29,  198,  624,
  672, 1397, 1450, 1785, 2181, 2643, 2881, 2981, 3483, 3527,
 4161, 4333, 4538, 4823, 4846, 5662, 5684, 6102, 6474, 6725,
 6879, 7510, 7755, 7937, 7997, 8021, 8162, 8182, 8417, 8500,
 8746, 8965, 9240, 9309, 9487, 9834, 9918,10248,10449,10757,
11137,11580,11848,12299,12327,12559,12600,12705,13141,13306,
13388,13604,13904,14114,14474,14624,14813,15065,15309,15836,
16016,16238,16279,16529,16809,16959,17030,17329,17503,17679,
17730,17829,18088,18133,18510,18850,19339,19401,19501,19601,
19847,19905,20635,20981,21125,21447,21466,21541,21942,23008,
23154,23259,23267,23354,23492,23702,23954,24277,24691,25026,
25183,25508,25752,25920,26026,26224,27075,27124,27183,27470,
27734,27901,27970,28069,28147,28328,28448,28966,29034,29329,
29783,29791,30040,30253,30863,31078,31232,31254,31312,31337,
31395,31553,31770,31816,   79,  398,  448,  662,  676,  711,
  723,  796,  843, 1190, 1278, 1365, 1462, 1993, 2033, 2061,
 2140, 2173, 2196, 2273, 2326, 2401, 2574, 2701, 2820, 2839,
 2886, 3110, 3185, 3211, 3314, 3321, 3325, 3388, 3543, 3618,
 3725, 3871, 3922, 3934, 4548, 4679, 4918, 5073, 5077, 5241,
 5479, 5608, 5708, 5734, 6072, 6196, 6249, 6303, 6355, 6465,
 6593, 6639, 6681, 6767, 6806, 6854, 6923, 6941, 7435, 7493,
 7524, 7842, 7953, 7960, 8091, 8391, 8409, 8463, 8682, 9074,
 9099, 9185, 9340, 9475, 9542, 9574, 9810, 9899, 9907,10035,
10081,10425,10569,10703,10712,10788,10797,11008,11018,11029,
11165,11343,11477,11601,11628,11644,11807,12067,12142,12151,
12168,12355,12375,12611,12883,12991,13010,13059,13154,13166,
13557,13680,13723,13782,13859,14034,14081,14717,14756,14900,
14919,15000,15080,15223,15426,15439,15556,15584,15770,15864,
16010,16037,16263,16292,16371,16513,16554,16782,16848,16863,
16988,17098,17434,17496,17786,17865,17983,18299,18550,18625,
18669,18730,18757,18782,18897,19081,19101,19232,19255,19412,
19629,19721,19733,19839,19865,20045,20125,20132,20278,20605,
20646,21013,21056,21165,21280,21332,21346,21457,21914,21959,
21993,22028,22244,22375,22504,22702,22737,22745,22777,22811,
22848,22980,23059,23094,23294,23383,23631,23742,23811,23858,
23912,24135,24221,24625,24714,24781,25037,25089,25116,25258,
25386,25425,25445,25495,25762,25813,25976,25995,26320,26590,
26595,26630,26707,26719,26733,26805,27213,27611,27867,27914,
28151,28180,28309,28493,28569,28896,29124,29303,29335,29386,
29432,29454,29535,29614,29629,29852,29882,29903,30064,30182,
30247,30351,30689,30771,30789,30838,31191,31228,31438,31498,
31648,31724,31788,  101,  157,  526, 1503, 1817, 4270, 4456,
 4864, 5012, 5201, 5467, 5905, 6168, 6987, 7004, 7732, 7738,
 8592, 9142, 9369, 9441, 9819,11042,11055,11541,11639,12618,
12877,13465,13735,14486,14637,14701,14796,14835,14882,14943,
15786,15952,16451,16653,16996,17314,17393,17517,17559,18192,
18528,18828,18867,19697,19778,20121,20464,20746,20877,21371,
21390,21891,21933,23833,23918,24154,25455,26699,27198,27561,
27681,27704,28043,28287,28853,28905,29596,29834,30831,30916,
31068,31182,31550,31603,31889,31898,  129,  685,  727,  800,
 1201, 1442, 1873, 1938, 2178, 2243, 2352, 2728, 4556, 5487,
 5704, 5768, 5996, 6597, 6777, 7615, 7724, 8087, 8169, 9273,
10135,10148,10261,10602,10628,11108,11660,12199,12254,13014,
13881,13949,14286,14350,15485,15840,15904,16182,16724,16778,
17014,17859,18015,18116,18270,18967,19268,19430,19538,20998,
21214,22858,22863,23349,23481,23845,24293,24384,24636,25461,
25826,26084,26162,26370,26412,26435,26502,27193,28291,28542,
28745,28751,28889,29006,29297,29575,30624,30764,30978,31051,
31400,31735, 1025, 1510, 1926, 2041, 2974, 3406, 3654, 3960,
 4166, 4258, 4279, 4314, 4390, 4758, 5253, 6365, 6734, 6839,
 8327, 8652, 8780, 8870, 9492, 9539, 9893,11265,11462,11589,
12304,12338,12587,12836,14150,14213,15369,15515,16384,17334,
17800,18129,18454,19226,19360,20458,20564,20602,20800,21325,
21352,21438,21973,22193,22239,22603,22681,23117,23521,24647,
24737,25246,26124,26257,26533,26636,27308,28036,29474,29503,
30940,30948,32005,  775, 1245, 2145, 2602, 2948, 3745, 4059,
 4430, 5044, 5346, 6108, 6607, 6757, 7199, 7826, 8450, 8765,
 9806,10208,11362,12510,12716,13123,13179,13918,13983,14245,
14932,15792,17408,18151,18314,20400,20474,20479,21092,23361,
24201,24235,25573,27096,27557,28249,28272,29708,29721,29803,
29954,30676,31948,  232, 1369, 1384, 1675, 2614, 3007, 3397,
 3476, 4286, 4324, 5674, 5697, 5835, 6244, 6781, 7074, 8565,
 9469, 9738,10679,11098,11297,12119,12293,13133,13548,15282,
16134,16234,16409,16786,17297,17386,17904,18110,19397,19534,
19879,20054,20173,20298,21145,21414,21462,24266,25175,25485,
26381,26427,26458,27617,28124,29268,29619,30086,30538,31195,
  227,  252,  596,  768,  890, 2355, 2772, 2842, 3756, 3989,
 5232, 5775, 5885, 6370, 6723, 8321, 8546,10304,10386,10472,
10654,11091,11185,12244,12414,12788,12957,13309,13481,13764,
14427,15061,15525,15889,16246,16580,16909,16936,17633,17883,
18835,18858,19097,19508,20824,21237,21897,22216,22592,22754,
22885,22920,23106,23386,23723,24006,24317,24400,24640,25345,
25414,25431,26565,26772,27276,27731,27794,28051,29214,29293,
30220,30655,31599,31612, 1103, 1963, 2748, 3042, 3380, 3803,
 4042, 4682, 4804, 4945, 5113, 5593, 7218, 8014, 8195, 8336,
 8856, 8925, 8943, 9222,10065,10181,10610,10865,11177,11624,
11822,11986,11996,13214,13473,13827,14553,15301,15573,15779,
16481,17046,17552,17568,17734,17804,19519,19850,20007,20404,
21560,22034,22320,22960,23254,23397,23572,23889,23946,24119,
24287,24630,25171,25477,26240,26647,26942,27813,27949,28073,
29037,29116,29444,30289,30435,30550,30614,31239,   14,   66,
   81,  166,  237,  240,  245,  264,  316,  337,  387,  395,
  496,  501,  683,  708,  737,  779,  859,  894,  897,  926,
 1012, 1017, 1041, 1078, 1186, 1229, 1306, 1448, 1495, 1550,
 1568, 1585, 1598, 1604, 1647, 1765, 1844, 1885, 1894, 1995,
 2017, 2023, 2115, 2138, 2167, 2262, 2313, 2320, 2413, 2497,
 2570, 2585, 2618, 2623, 2799, 2824, 2890, 2911, 2998, 3022,
 3090, 3099, 3116, 3137, 3144, 3176, 3266, 3278, 3299, 3305,
 3316, 3343, 3356, 3515, 3531, 3538, 3578, 3586, 3704, 3760,
 3784, 3880, 3891, 3906, 3926, 3985, 4004, 4135, 4226, 4244,
 4248, 4380, 4485, 4493, 4541, 4578, 4700, 4715, 4737, 4831,
 4857, 5018, 5087, 5106, 5125, 5195, 5224, 5262, 5270, 5285,
 5292, 5337, 5410, 5440, 5442, 5569, 5579, 5610, 5615, 5716,
 5721, 5727, 5764, 5788, 5843, 5853, 5873, 5891, 5972, 6068,
 6094, 6152, 6223, 6351, 6391, 6395, 6472, 6479, 6569, 6618,
 6677, 6721, 6740, 6771, 6824, 6837, 6985, 7019, 7035, 7040,
 7065, 7122, 7146, 7151, 7173, 7214, 7381, 7431, 7449, 7497,
 7512, 7518, 7554, 7569, 7589, 7620, 7683, 7694, 7699, 7734,
 7787, 7838, 7846, 7906, 7919, 8101, 8114, 8132, 8141, 8155,
 8164, 8266, 8377, 8397, 8419, 8467, 8477, 8506, 8510, 8557,
 8579, 8744, 8763, 8836, 8879, 8914, 8922, 8969, 8981, 8986,
 9033, 9111, 9130, 9234, 9253, 9288, 9483, 9506, 9518, 9551,
 9564, 9655, 9838, 9842, 9913, 9953,10049,10063,10079,10093,
10124,10199,10212,10266,10289,10309,10443,10490,10588,10620,
10658,10684,10753,10785,10856,10889,10909,10954,11014,11033,
11085,11267,11353,11381,11385,11394,11482,11526,11591,11618,
11637,11685,11739,11790,11857,11911,11964,12018,12026,12034,
12098,12110,12137,12149,12314,12364,12388,12443,12544,12681,
12693,12708,12741,12755,12761,12832,13012,13085,13121,13193,
13248,13304,13320,13380,13392,13403,13487,13523,13534,13561,
13564,13645,13702,13795,13840,14124,14132,14152,14172,14251,
14257,14267,14357,14410,14423,14429,14455,14481,14500,14520,
14629,14653,14683,14729,14788,14800,14825,14858,14862,14913,
14927,15011,15035,15083,15199,15289,15410,15424,15460,15490,
15507,15513,15554,15564,15571,15624,15636,15638,15694,15804,
15859,15893,15993,16001,16026,16049,16059,16065,16074,16139,
16168,16273,16419,16523,16527,16541,16546,16556,16598,16608,
16636,16726,16751,16763,16811,16869,16921,16961,17052,17091,
17117,17131,17162,17186,17191,17227,17286,17316,17390,17402,
17404,17686,17715,17867,17973,18006,18065,18084,18140,18146,
18181,18245,18273,18295,18350,18378,18403,18472,18713,18820,
18840,18845,18886,18931,18955,19068,19073,19119,19130,19135,
19174,19262,19283,19307,19349,19443,19472,19514,19526,19596,
19617,19738,19785,19832,19873,19989,20033,20078,20084,20089,
20101,20169,20175,20229,20252,20380,20431,20509,20582,20617,
20641,20691,20704,20844,20966,20977,21059,21075,21150,21186,
21230,21258,21365,21392,21409,21426,21435,21464,21478,21527,
21660,21711,21725,21738,21745,21786,21802,21824,21839,21862,
21926,22101,22141,22147,22149,22153,22168,22212,22272,22291,
22305,22330,22350,22389,22393,22556,22588,22598,22625,22668,
22709,22802,22806,22870,22934,22950,23083,23234,23265,23281,
23304,23369,23433,23555,23740,23750,23759,23821,23830,23865,
23870,23877,23891,23896,23903,24078,24107,24225,24241,24405,
24410,24420,24496,24517,24531,24535,24663,24706,24774,24849,
24866,24872,24970,25006,25079,25097,25103,25119,25181,25185,
25384,25408,25419,25469,25499,25583,25590,25626,25665,25731,
25746,25811,25843,25929,26022,26041,26079,26144,26156,26175,
26208,26259,26325,26330,26550,26585,26597,26608,26688,26747,
26765,26917,26922,26966,26988,27038,27077,27120,27151,27162,
27174,27195,27205,27207,27220,27236,27337,27393,27473,27567,
27608,27656,27698,27707,27717,27792,27863,27933,27961,27976,
28045,28071,28078,28163,28174,28321,28382,28444,28467,28519,
28536,28682,28691,28720,28757,28809,28817,28839,28915,28941,
28953,28994,28996,29019,29042,29051,29072,29156,29203,29208,
29218,29249,29284,29388,29446,29465,29492,29509,29524,29602,
29627,29725,29841,29868,29993,30149,30169,30214,30269,30307,
30336,30355,30364,30382,30389,30536,30612,30616,30622,30669,
30683,30784,30794,30827,30840,30850,31016,31075,31126,31148,
31155,31160,31164,31224,31309,31327,31380,31434,31443,31495,
31557,31564,31583,31640,31681,31786,31810,31894,31904,31914,
31964,32012,32034,    3,  136,  212,  218,  262,  278,  299,
  341,  421,  440,  479,  504,  618,  650,  802,  871, 1023,
 1045, 1073, 1178, 1194, 1222, 1347, 1374, 1477, 1482, 1556,
 1592, 1614, 1665, 1739, 1850, 1889, 2001, 2031, 2184, 2459,
 2517, 2541, 2555, 2594, 2612, 2625, 2635, 2715, 2822, 2849,
 3027, 3044, 3077, 3121, 3366, 3488, 3740, 3848, 3859, 3910,
 3936, 3964, 3987, 4069, 4142, 4170, 4268, 4282, 4339, 4365,
 4422, 4432, 4575, 4642, 4668, 4848, 4898, 5108, 5130, 5136,
 5313, 5342, 5427, 5451, 5497, 5656, 5820, 5830, 5964, 5987,
 5992, 6074, 6148, 6175, 6381, 6400, 6435, 6605, 6611, 6660,
 6679, 6866, 6918, 7137, 7216, 7269, 7308, 7394, 7413, 7433,
 7454, 7514, 7539, 7559, 7564, 7629, 7773, 7784, 7840, 7931,
 8000, 8147, 8178, 8296, 8311, 8344, 8413, 8574, 8595, 8600,
 8713, 8806, 8852, 8863, 8877, 8947, 9038, 9050, 9085, 9090,
 9296, 9375, 9497, 9558, 9704, 9736, 9746, 9800, 9817,10176,
10206,10218,10294,10337,10514,10597,10608,10615,10639,10688,
10775,10825,10959,11006,11010,11031,11258,11274,11346,11440,
11553,11610,11786,11855,11870,11874,11948,11960,11991,12032,
12133,12232,12390,12394,12430,12595,12602,12679,12731,12768,
12823,12889,13057,13139,13159,13164,13300,13322,13367,13457,
13475,13483,13577,13639,13654,13721,13886,13923,14062,14146,
14157,14300,14355,14408,14425,14611,14676,14758,14849,14853,
14907,14936,15030,15085,15089,15208,15451,15456,15522,15566,
15597,15708,15959,16008,16014,16035,16043,16154,16177,16286,
16515,16585,16628,16759,16911,16982,17026,17170,17182,17231,
17245,17251,17288,17415,17473,17625,17681,17724,17811,17885,
17927,17947,18093,18114,18168,18342,18364,18369,18383,18442,
18482,18578,18779,18784,18862,18899,18917,19021,19257,19276,
19288,19296,19304,19333,19556,19612,19818,19824,19837,20020,
20049,20111,20184,20192,20227,20236,20285,20310,20352,20436,
20587,20739,20792,20829,20937,20946,21062,21197,21223,21358,
21529,21572,21624,21730,21778,21790,21944,21986,22090,22122,
22429,22469,22627,22683,22765,22797,22952,22963,22991,23004,
23123,23136,23274,23476,23515,23540,23583,23770,23825,23847,
23872,24030,24128,24330,24356,24505,24533,24540,24578,24586,
24638,24649,24660,24671,24819,25067,25071,25244,25254,25274,
25368,25380,25401,25491,25545,25550,25579,25695,25758,25861,
25867,25980,25988,26183,26238,26383,26446,26464,26500,26548,
26704,26953,26962,26977,26985,27035,27099,27107,27166,27404,
27408,27477,27510,27526,27571,27649,27710,27767,27939,27989,
28066,28186,28240,28254,28303,28531,28545,28577,28701,28708,
28740,28807,29040,29046,29066,29275,29291,29342,29539,29770,
29968,30035,30070,30089,30200,30209,30244,30294,30366,30440,
30468,30564,30569,30645,30778,30799,30930,31072,31104,31109,
31334,31441,31546,31559,31779,31995,32028,  582,  729, 1440,
 1819, 2453, 3374, 4762, 4904, 4965, 5213, 5664, 5766, 6007,
 6363, 6641, 6667, 6693, 7528, 7681, 7993, 8976, 9093, 9120,
 9124, 9258, 9410, 9530, 9653, 9830,10388,10431,10845,11026,
11301,12115,12195,12642,13147,13375,13452,13507,13750,13863,
14069,14865,15692,15800,16003,16449,16473,16606,17207,17601,
17739,17971,18335,18564,18686,18853,19912,21509,21807,21948,
22025,22233,22529,23332,23342,23692,23815,23948,24351,24430,
24613,24978,25024,25126,25680,25880,26195,26211,26351,26525,
26659,27847,28142,28363,28416,28628,28672,28834,29070,29498,
29812,30047,30490,30829,30936,31037,31759,31988,  339,  777,
  976, 1010, 1106, 1345, 1609, 1812, 1870, 2125, 2143, 2212,
 2383, 3157, 3780, 3864, 4466, 4498, 4825, 5457, 5537, 6070,
 6624, 7193, 7444, 7535, 8774, 9683, 9798,10661,10860,10996,
11271,11282,11780,12144,12566,12638,12817,13443,13469,13709,
13928,14359,14635,14753,15966,16839,16915,17004,17668,17700,
17869,18488,18818,19026,19153,19249,19351,19695,20061,20511,
20748,21054,21569,21798,22204,22352,22494,22550,22731,23661,
23779,24206,24268,24537,24694,24825,25292,25781,26056,26803,
27113,27315,27998,28107,28311,28654,29589,29645,29697,30067,
30111,30960,30980,32030,   59,  280,  303,  324,  607,  845,
 1260, 1655, 1661, 2154, 2342, 2750, 2954, 2969, 3038, 3273,
 3361, 3563, 3599, 3775, 3855, 3886, 3904, 4729, 5007, 5446,
 5613, 5702, 6053, 6423, 6490, 6576, 6609, 6651, 6742, 6779,
 7766, 8071, 8675, 8945, 9151, 9612, 9840,10141,10311,11522,
11616,11725,11824,12535,12904,12996,13298,13936,14100,14593,
14711,14725,14991,14998,15175,15229,15242,15462,15702,15981,
16254,16948,17044,17406,17942,18125,18153,19358,19813,20265,
20290,20615,20657,20696,20788,20961,21071,21713,22114,22188,
22318,22367,22418,22905,23297,23570,23735,23819,24677,24704,
24799,25557,25957,26010,26433,26504,26799,27521,27737,27754,
28538,28677,28951,29189,29223,29672,30013,30042,30156,30651,
30834,30922,31139,32010,   16,   77,  541,  713,  792,  866,
 1019, 1027, 1199, 1379, 1505, 1544, 1842, 1883, 1969, 2071,
 2136, 2176, 2201, 2249, 2407, 2430, 2436, 2590, 2641, 2662,
 2696, 2706, 2915, 2959, 2994, 3097, 3128, 3223, 3301, 3307,
 3332, 3594, 3955, 3996, 4109, 4320, 4444, 4675, 4698, 4756,
 4910, 5028, 5046, 5185, 5193, 5278, 5325, 5335, 5408, 5481,
 5822, 5845, 6025, 6090, 6254, 6497, 6536, 6620, 6658, 6978,
 7054, 7120, 7132, 7205, 7225, 7350, 7429, 7935, 8024, 8067,
 8083, 8108, 8136, 8160, 8173, 8286, 8472, 8884, 8916, 8994,
 9174, 9325, 9485, 9572, 9660, 9692,10051,10071,10133,10190,
10204,10302,10427,10441,10479,10566,10690,10867,10907,10911,
11157,11163,11180,11368,11529,11805,11862,11908,12028,12160,
12214,12369,12454,12553,12703,12780,12809,12825,12881,12910,
12943,13390,13409,13539,13784,14029,14045,14050,14071,14084,
14091,14333,14488,14508,14731,14830,14911,15194,15454,15475,
15496,15634,15753,15973,16045,16070,16129,16277,16338,16403,
16589,16676,16761,16794,17160,17342,17345,17501,17583,17613,
17631,17638,17711,17772,17863,17987,18086,18106,18205,18261,
18329,18449,18517,18583,18746,18790,18894,18915,18933,18957,
19051,19137,19422,19463,19532,19787,19901,19922,20177,20216,
20357,20440,20453,20489,20764,20853,20975,20990,21008,21094,
21210,21216,21577,21621,21664,21704,21818,21828,21846,22208,
22274,22373,22707,22982,23101,23108,23204,23247,23263,23269,
23272,23358,23450,23509,23617,23879,23901,23956,24295,24498,
24687,24791,24821,25002,25033,25055,25085,25179,25349,25421,
25433,25453,25475,25493,25506,25596,25841,25997,26024,26177,
26278,26508,26540,26641,26808,27016,27072,27091,27105,27118,
27131,27274,27535,27587,27619,27687,27870,27908,28365,28453,
28689,28714,28929,29053,29280,29320,29350,29448,29519,29598,
29719,29805,29860,30216,30338,30618,30691,30752,30773,30848,
30932,30953,30994,31057,31201,31226,31322,31428,31445,31555,
31642,31729,31781,31846,31911,31925,  144,  260,  295,  308,
  739, 1252, 1301, 1552, 2230, 2932, 3924, 4133, 4416, 4840,
 5485, 5588, 5811, 6100, 6792, 6997, 7072, 7302, 7359, 7403,
 7424, 7508, 7797, 8224, 8268, 8313, 8525, 8963, 9059,10277,
10314,10329,10419,10512,10645,11765,12128,12346,12628,12683,
12772,13270,13360,13382,13719,13873,14036,14543,14860,15675,
15906,15968,16029,16232,16373,17012,17133,17225,17305,17358,
17906,19702,19780,19820,19875,19926,20611,20858,21143,21225,
21534,21747,21860,21964,22478,22617,22868,22936,23538,23860,
23887,24197,24282,24719,25095,25585,25744,25927,26039,26206,
26344,26461,26569,27604,27935,28469,29021,29201,29251,29592,
29798,30092,30191,30212,30855,31065,31178,31211,31382,31773,
31993,  127,  476,  981, 1043, 1227, 1409, 1590, 1875, 2797,
 3085, 3094, 3382, 3419, 3981, 4246, 4277, 4331, 4424, 4693,
 4727, 5036, 5667, 6211, 6271, 6389, 6759, 7763, 7828, 7904,
 8176, 8202, 8230, 8498, 8544, 8761, 9180, 9435, 9815,10061,
10268,10292,10571,10626,11001,11021,11846,11966,12316,12573,
12593,12722,13125,13641,13920,14247,14312,14374,14515,14815,
14941,15106,15505,15575,15622,16248,16521,17318,17767,18009,
18734,18826,19099,19558,19669,19996,20127,20580,20820,20846,
20875,21367,21841,22506,23121,23431,23721,23772,24217,24619,
24642,24827,25443,25946,26264,26363,26754,27339,27461,27541,
27569,27788,27943,28075,28380,28630,28695,28920,28961,29193,
29501,29680,29816,29908,30029,30735,30920,31493,31741,   12,
   99,  223,  332,  343,  385,  616,  626,  639,  648,  687,
  781, 1047, 1056, 1098, 1113, 1123, 1180, 1381, 1425, 1460,
 1580, 1663, 1731, 1761, 1814, 1821, 1940, 1997, 2029, 2169,
 2234, 2269, 2357, 2385, 2417, 2438, 2499, 2565, 2583, 2592,
 2704, 2734, 2753, 2978, 3000, 3020, 3046, 3303, 3390, 3461,
 3529, 3561, 3601, 3616, 3649, 3677, 3683, 3727, 3738, 3782,
 3801, 3902, 3908, 4049, 4064, 4144, 4183, 4318, 4367, 4446,
 4464, 4473, 4544, 4554, 4621, 4628, 4681, 4722, 4764, 4902,
 4963, 5309, 5382, 5412, 5438, 5444, 5509, 5514, 5623, 5723,
 5841, 5851, 5994, 6058, 6066, 6113, 6309, 6358, 6456, 6481,
 6492, 6534, 6539, 6603, 6738, 6754, 6765, 6819, 6856, 6975,
 6989, 7051, 7063, 7130, 7208, 7267, 7411, 7421, 7526, 7547,
 7567, 7778, 7884, 7900, 7995, 8116, 8157, 8171, 8298, 8317,
 8346, 8411, 8548, 8706, 8711, 8715, 8838, 8949, 9026, 9046,
 9126, 9149, 9164, 9190, 9232, 9247, 9256, 9271, 9302, 9336,
 9349, 9352, 9454, 9477, 9504, 9508, 9665, 9714, 9795, 9836,
 9920,10018,10047,10130,10185,10259,10510,10562,10575,10606,
10656,10721,10887,10957,11004,11063,11068,11093,11096,11140,
11182,11207,11240,11244,11269,11295,11412,11428,11442,11549,
11735,11749,11760,12030,12069,12162,12217,12227,12252,12297,
12332,12377,12392,12428,12497,12677,12782,12994,13089,13152,
13172,13195,13288,13302,13335,13398,13411,13467,13499,13505,
13521,13704,13766,13776,13867,14031,14144,14180,14259,14327,
14331,14406,14498,14555,14651,14703,14851,14977,15033,15067,
15078,15115,15173,15179,15197,15240,15320,15395,15408,15569,
15595,15640,15710,15798,15820,15861,15975,16077,16131,16275,
16340,16356,16382,16421,16427,16517,16587,16626,16844,16946,
17006,17024,17028,17050,17100,17129,17233,17247,17295,17299,
17337,17350,17515,17554,17563,17589,17623,17717,17726,17732,
17762,17994,18017,18073,18170,18241,18253,18348,18355,18366,
18474,18530,18654,18684,18696,18786,18856,18892,18901,18965,
19128,19212,19224,19234,19253,19294,19302,19337,19458,19521,
19795,19845,19881,19890,19903,20194,20221,20231,20312,20354,
20398,20406,20433,20447,20485,20516,20553,20689,20761,20813,
20826,20935,20948,20968,20971,21027,21080,21085,21195,21394,
21476,21507,21562,21575,21646,21709,21809,21826,21830,21911,
22006,22120,22129,22143,22289,22298,22328,22422,22474,22533,
22548,22596,22600,22623,22733,22752,22763,22850,22883,23085,
23131,23190,23199,23306,23334,23351,23356,23367,23375,23435,
23478,23634,23651,23663,23744,23782,23875,23905,24112,24121,
24130,24151,24246,24252,24275,24328,24491,24507,24588,24594,
24615,24665,24735,24797,24837,24847,24921,24964,25091,25105,
25166,25203,25256,25382,25459,25510,25604,25630,25809,25851,
25875,25941,26245,26251,26353,26410,26567,26709,26721,26811,
27020,27031,27126,27164,27372,27383,27421,27483,27491,27555,
27579,27589,27849,27857,27865,27894,27903,27919,28000,28176,
28184,28196,28317,28457,28491,28526,28540,28667,28742,28832,
28837,28855,28891,29064,29090,29095,29301,29337,29390,29456,
29652,29880,29923,29952,29973,29986,30011,30081,30106,30152,
30171,30267,30387,30415,30433,30473,30482,30540,30610,30678,
30780,30792,30819,30852,30914,30950,30998,31222,31314,31325,
31397,31436,31523,31539,31544,31601,31646,31761,31807,31879,
31917,31983,32026,   90,  681, 1488, 1542, 1559, 1583, 1788,
 2257, 2538, 3378, 3777, 4458, 4514, 5400, 5809, 6622, 7042,
 7250, 7577, 8861, 9427, 9724, 9822,10037,10665,10976,11392,
12366,12441,12533,13394,13652,13861,14086,15187,15360,15615,
15683,16141,16801,17120,17788,18127,18767,18872,19353,19660,
19744,20562,20766,21239,21374,21421,21460,22325,23151,23517,
24233,24789,25035,25638,25869,25967,26077,26142,26222,26391,
27233,27475,27504,27967,28227,28581,28913,29138,29323,29424,
30448,31946,32032,  463,  620,  631,  899, 1083, 1832, 2085,
 2123, 2251, 2520, 2913, 2971, 3155, 3700, 3811, 3915, 4168,
 4341, 4869, 5071, 5523, 5585, 6055, 6088, 6213, 6653, 6914,
 6995, 7144, 7161, 9101, 9458, 9755,10792,10898,11142,11403,
12838,12879,13762,13790,14095,14687,15274,16047,16389,16405,
17284,18095,18307,18395,18922,19206,19408,19866,21363,21590,
22278,23186,23839,24002,25406,25479,26693,27176,27325,27402,
27854,28122,29313,29587,29763,29828,29847,30058,30776,31704,
31906,  917, 1668, 1971, 2837, 6092, 6361, 7070, 7118, 7389,
 7520, 7894, 8016, 8381, 8892, 9113, 9360,10001,10647,11419,
11818,11922,12258,13352,13471,13964,14272,14412,14871,15311,
15802,15844,16728,17366,17615,18249,18375,18470,19991,20438,
20659,20841,20866,21643,21795,22887,23505,24256,24740,24994,
25069,25733,26012,26036,26538,26819,27149,28747,29418,29664,
29702,30368,31180,31387,   27,  356,  594,  664,  773,  885,
  910, 1357, 1554, 1636, 1988, 2073, 2656, 2746, 2908, 2957,
 3159, 3312, 3359, 3522, 3689, 3747, 3852, 4348, 4419, 4741,
 5080, 5404, 5540, 5688, 5762, 5990, 6425, 6980, 7021, 7126,
 7642, 8004, 8069, 8110, 8180, 8559, 8608, 8656, 8678, 9416,
 9513, 9537, 9864,10275,10392,10445,10517,10534,10686,11253,
11408,11520,11642,12046,12121,12358,12515,12735,12753,12796,
13294,14102,14249,14811,14946,15028,15056,15278,15750,15872,
16475,16577,16630,17189,17209,17857,18130,18197,18212,18333,
18466,18748,19077,19121,19140,19221,19641,19896,20051,20257,
20557,20693,20996,21123,21348,21854,22092,22145,22365,22384,
22679,22717,22757,22876,22969,23178,23289,23898,23916,23952,
23970,24501,25163,25199,25237,25362,25955,25999,26082,26261,
26361,26379,26890,27007,27137,27294,27406,27706,27802,27937,
27973,28115,28231,28295,28325,28340,28431,28851,29017,29772,
30016,30045,30180,30271,30667,30685,30962,31268,31500,31585,
31683,31937,   57,   83,   95,  214,  418,  520,  876, 1029,
 1119, 1208, 1243, 1255, 1317, 1456, 1480, 1611, 1659, 1950,
 1958, 1991, 2311, 2318, 2364, 2726, 2794, 2811, 2818, 2980,
 3036, 3208, 3471, 3605, 3622, 3671, 3706, 3944, 3961, 4082,
 4103, 4192, 4260, 4305, 4312, 4632, 4754, 4816, 4862, 5004,
 5048, 5099, 5146, 5151, 5226, 5260, 5267, 5327, 5449, 5492,
 5693, 5794, 5912, 5961, 5966, 6048, 6202, 6227, 6398, 6484,
 6528, 6559, 6769, 6832, 7067, 7134, 7392, 7438, 7549, 7556,
 7609, 7782, 7927, 8073, 8081, 8134, 8139, 8200, 8228, 8281,
 8482, 8688, 8725, 8979, 9035, 9088, 9560, 9637, 9657, 9694,
 9709, 9742, 9759, 9910, 9927, 9956,10025,10283,10438,10525,
10581,10779,10962,10999,11074,11172,11341,11423,11469,11607,
11666,11681,11755,11769,11784,11865,11913,11988,12012,12021,
12191,12423,12502,12520,12698,12757,12770,12799,12983,13113,
13131,13255,13327,13594,13634,13695,13724,13740,13849,13961,
14129,14177,14341,14418,14446,14614,14626,14646,14662,14693,
14739,14902,15074,15206,15233,15294,15316,15524,15755,15795,
15825,15961,16089,16216,16222,16252,16261,16368,16392,16464,
16544,16648,16674,16747,16784,16964,17123,17254,17355,17385,
17566,17620,17697,17877,17985,18108,18120,18359,18436,18459,
18535,18571,18640,18676,18912,19036,19165,19237,19259,19394,
19474,19592,19631,19740,19908,19914,19920,19940,20018,20069,
20076,20200,20426,20471,20603,20609,20741,21088,21135,21245,
21256,21715,21740,21787,21848,21888,21916,21991,22008,22036,
22112,22116,22161,22221,22387,22729,22784,22820,22855,22898,
23245,23318,23339,23428,23448,23485,23577,23688,23738,23757,
23852,23908,24028,24056,24261,24338,24418,24432,24675,24710,
25000,25051,25099,25109,25233,25272,25309,25313,25374,25592,
25643,25772,25779,25801,26114,26126,26388,26406,26429,26440,
26513,26523,26592,26712,26739,26842,26992,27086,27111,27140,
27153,27189,27265,27499,27528,27544,27723,28140,28244,28450,
28482,28543,28564,28618,28706,28752,28844,28963,29056,29114,
29148,29185,29271,29430,29484,29600,29832,29874,29905,29918,
30360,30376,30452,30456,30479,30532,30596,30822,30955,31004,
31118,31215,31230,31357,31364,31402,31497,31699,31812,31822,
31827,31909,31958,31991,  451,  509,  539,  805,  882, 1021,
 1499, 1826, 2003, 2049, 2737, 3218, 4288, 4526, 4807, 4896,
 4995, 5128, 5206, 5849, 6452, 6773, 7332, 7462, 7792, 8002,
 8022, 8143,10698,10952,10994,11648,11763,11815,12300,12433,
12555,12674,13284,13926,14168,14290,14462,14476,15112,15672,
16670,16765,16923,17143,17302,17481,17561,17798,18352,18387,
18507,19432,19479,19707,20238,20493,20699,21600,22164,22218,
22523,22722,22865,23501,23656,24211,24882,24962,25471,25497,
25982,26064,26662,26778,26850,27129,27168,27287,27582,28168,
28274,28282,28575,28635,29277,29333,29775,30193,30445,30688,
30747,31168,31343,31447,31571,   49,  794, 1163, 1484, 1835,
 2275, 3075, 3135, 3502, 3866, 4546, 4646, 4684, 5435, 6081,
 6353, 6822, 7921, 8697, 8776, 8803, 9895, 9923,10073,10106,
10214,12187,13212,13554,13688,13946,14595,14890,15021,15252,
15324,15772,17009,17627,17898,18864,19117,19489,20672,20786,
21207,21323,21997,22881,22965,23170,23753,23774,25410,25441,
25960,26179,26806,26981,28805,28884,29452,29700,31412,  268,
  485,  963, 1433, 1464, 2159, 3895, 3958, 4749, 5115, 5283,
 5676, 5838, 6097, 6762, 6991, 7047, 7304, 7887, 8797, 8939,
 9525, 9555, 9803, 9812,10041,12131,12720,12925,13127,13643,
13798,14047,14490,15630,15850,16294,16336,16663,16851,17135,
17765,17784,18104,19274,19335,19789,19802,19998,21152,21235,
21962,22241,23474,24488,24892,25177,25548,27026,27875,27951,
28154,28285,28841,30246,31530,31814,   54,  400,  467,  528,
 1281, 1790, 2568, 2638, 2840, 3181, 3204, 3805, 4316, 4426,
 4581, 5215, 5977, 6016, 7149, 7371, 8375, 8576, 9118, 9634,
 9792, 9867,10604,10652,10854,10862,11396,11582,11733,12043,
12952,14174,14898,15184,15777,15842,18309,19362,19868,20307,
21001,21030,21350,21820,22235,23134,23252,23765,24390,24465,
24823,25047,25223,26049,26610,27014,28032,28626,28907,29573,
29658,30198,30590,31059,31261,31510,31709,  200,  313,  798,
 1000, 1054, 1737, 1756, 2388, 2983, 3334, 3474, 3845, 3966,
 5203, 5690, 6023, 6339, 6636, 6690, 7002, 7908, 8342, 8361,
 8641, 8790, 8911, 9261, 9662,10592,11107,11485,11728,11792,
11860,13008,13157,13177,13267,13682,14472,14929,15327,15449,
15593,16072,16186,16461,16623,16826,16902,18135,18144,18513,
18848,19075,19219,19341,19620,19731,19776,20296,20986,21090,
21147,21441,21774,21895,22370,22656,22699,22704,23104,23733,
23893,24126,24285,24353,24716,26315,26327,26531,26749,27679,
28621,28684,28926,29299,29414,29437,29915,30087,30189,30353,
30797,31234,31653,31979,  443,  710,  814, 1416, 1768, 2203,
 2226, 2323, 2923, 3132, 3233, 3597, 3928, 4568, 4660, 4713,
 5056, 5085, 6046, 6086, 6301, 6373, 6383, 6649, 6863, 7458,
 8019, 8277, 8319, 9095, 9327, 9433,10138,10179,10435,10693,
11086,12211,12630,12701,12714,12778,13065,13191,13716,13869,
13891,13941,14527,14643,14713,15846,16342,16600,16907,17339,
17410,18305,18346,18477,18637,18781,19133,19835,20013,20081,
20375,20559,20848,22501,22552,22918,23049,23452,23748,24229,
24621,24742,25020,25315,25378,25646,25974,26007,26311,26606,
26769,27740,27906,27945,27955,28571,29325,29479,29537,29785,
30027,30228,30943,31385,31439,31986,   63,  389,  735,  790,
 1491, 1794, 1863, 2232, 2239, 2271, 2381, 2411, 2524, 2744,
 3540, 3888, 3947, 4237, 4371, 4495, 4652, 4827, 5111, 5149,
 5654, 5791, 5924, 6005, 6242, 7176, 7223, 7348, 7405, 7446,
 7506, 7780, 7817, 8542, 8581, 8654, 8680, 9268, 9499, 9614,
10226,11023,11159,11359,11366,11425,11454,11973,12289,12348,
12737,12766,12976,13273,13377,13588,14159,14264,14798,14823,
14877,15473,15617,15895,16290,16350,16375,16417,16638,16974,
17556,17636,17689,17861,18293,18357,18381,18452,18753,19009,
19016,19639,19691,20130,20415,20585,21025,21049,21082,21757,
21832,22606,22711,22954,23001,23922,24601,24673,24782,24845,
25161,25655,25883,25894,26624,26639,26645,26782,27122,27651,
27658,27925,28268,28354,28370,28679,28703,28918,29206,29421,
29433,29883,30062,30681,30720,30918,31157,31199,31527,31696,
31975,32021,   46,   97,  216,  243,  321,  345,  411,  482,
  633,  641,  657,  716,  742,  869,  887,  978, 1014, 1034,
 1069, 1087, 1095, 1104, 1159, 1196, 1377, 1394, 1407, 1429,
 1437, 1497, 1502, 1701, 1783, 1816, 1846, 1867, 1872, 1924,
 1934, 1942, 2021, 2069, 2156, 2210, 2304, 2339, 2366, 2409,
 2440, 2455, 2528, 2658, 2693, 2710, 2769, 2781, 2801, 2892,
 2946, 3004, 3112, 3147, 3215, 3285, 3295, 3364, 3376, 3466,
 3469, 3481, 3509, 3536, 3576, 3607, 3764, 3873, 4035, 4163,
 4265, 4297, 4307, 4345, 4382, 4387, 4551, 4644, 4673, 4695,
 4720, 4732, 4855, 4859, 4883, 4900, 4932, 4943, 5065, 5082,
 5138, 5142, 5234, 5280, 5294, 5312, 5350, 5391, 5455, 5533,
 5577, 5606, 5672, 5807, 5826, 5872, 5887, 5969, 5974, 6185,
 6204, 6218, 6421, 6437, 6442, 6467, 6476, 6488, 6556, 6561,
 6599, 6732, 6745, 6776, 6868, 6912, 6916, 7008, 7027, 7038,
 7185, 7190, 7203, 7306, 7362, 7532, 7622, 7632, 7705, 7754,
 7775, 7799, 7805, 7912, 8026, 8029, 8033, 8130, 8153, 8260,
 8315, 8329, 8338, 8395, 8479, 8550, 8590, 8647, 8668, 8684,
 8793, 8887, 8894, 8930, 8954, 8971, 8991, 9043, 9072, 9097,
 9106, 9342, 9408, 9430, 9437, 9467, 9511, 9523, 9548, 9639,
 9642, 9679, 9697, 9744, 9757, 9861,10069,10096,10108,10136,
10188,10197,10231,10306,10339,10429,10485,10568,10577,10624,
10755,10781,10790,10794,10823,10827,10872,10905,10978,11028,
11038,11044,11058,11338,11344,11388,11417,11434,11480,11635,
11653,11658,11664,11683,11767,11930,11935,11951,12015,12135,
12173,12189,12197,12225,12344,12373,12396,12412,12425,12526,
12551,12598,12613,12686,12709,12774,12916,13004,13023,13061,
13077,13115,13210,13220,13261,13290,13296,13530,13537,13546,
13566,13685,13742,13773,13793,13830,13857,13884,14019,14026,
14039,14043,14089,14093,14162,14166,14243,14304,14317,14343,
14348,14559,14562,14648,14674,14696,14722,14802,15008,15109,
15126,15140,15177,15191,15211,15217,15231,15236,15244,15284,
15291,15322,15363,15414,15469,15578,15678,15838,15887,15899,
15909,15957,15998,16005,16022,16052,16057,16169,16172,16401,
16458,16519,16564,16642,16646,16734,16742,16776,16805,16808,
16846,16897,16992,17020,17047,17057,17102,17178,17347,17395,
17413,17551,17683,17713,17719,17728,17736,17770,17809,17821,
17896,17949,17969,17982,18082,18123,18132,18199,18214,18331,
18440,18455,18533,18737,18759,18771,18777,18788,18842,18851,
18920,19079,19095,19168,19204,19214,19244,19247,19281,19299,
19315,19318,19344,19455,19470,19481,19524,19606,19735,19793,
19808,19840,19848,19970,19976,20056,20198,20218,20288,20378,
20445,20461,20476,20555,20576,20591,20624,20687,20702,20736,
20790,20871,20963,20993,21204,21259,21313,21329,21334,21355,
21412,21419,21423,21445,21455,21467,21552,21596,21607,21666,
21706,21751,21765,21780,21918,21974,21983,22003,22095,22127,
22185,22225,22276,22296,22395,22496,22536,22594,22677,22735,
22749,22768,22775,22813,22818,22852,22930,22971,22987,23149,
23299,23344,23381,23472,23483,23512,23551,23586,23637,23649,
23714,23719,23813,23882,24008,24016,24061,24080,24141,24166,
24214,24223,24243,24249,24263,24494,24503,24708,24733,24817,
24853,24862,24885,24915,25061,25111,25220,25294,25423,25427,
25483,25489,25559,25565,25594,25641,25658,25697,25730,25770,
25803,25824,25859,25878,25939,25990,26028,26128,26203,26213,
26368,26421,26426,26466,26528,26542,26634,26691,26726,26744,
26847,26892,26909,26950,27022,27097,27159,27171,27181,27187,
27197,27224,27419,27463,27471,27524,27546,27585,27685,27689,
27694,27729,27756,27807,27910,27941,27958,27981,28058,28088,
28182,28194,28229,28305,28330,28465,28504,28632,28664,28670,
28744,28801,28931,29023,29135,29151,29195,29212,29220,29253,
29269,29294,29496,29522,29577,29609,29631,29647,29661,29706,
29810,29876,29901,29925,29970,30051,30056,30083,30103,30202,
30232,30302,30305,30379,30400,30428,30431,30470,30634,30657,
30739,30755,30767,30809,30832,30836,30844,30983,31054,31107,
31116,31241,31355,31375,31520,31533,31561,31598,31608,31614,
31649,31706,31768,31882,31939,   19,  159,  453,  499,  590,
  995, 1152, 1257, 1562, 1616, 2237, 2741, 2758, 3017, 3080,
 3201, 3545, 3709, 3743, 3840, 3884, 3942, 4187, 4441, 4655,
 5002, 5062, 5297, 5571, 5816, 5903, 6756, 7154, 7594, 7602,
 7820, 7880, 8708, 8770, 8785, 9250, 9304, 9413, 9682, 9761,
 9929,10463,10833,10875,10944,11184,11284,11713,12059,12451,
12500,13316,13714,14329,14616,14658,15263,15297,15308,15943,
16201,16334,16603,16620,16722,16789,16930,16944,17320,17774,
18256,18385,18591,18762,18875,18880,18909,19038,19495,19827,
20108,20124,20180,20277,20456,20999,21006,21544,21755,22132,
22246,22381,22566,22782,22993,23052,23654,23961,24043,24066,
24087,24324,24804,24967,24980,25088,25242,25652,25774,26139,
26741,27237,27348,27400,27669,28063,28349,29008,29093,29146,
29442,29789,29958,30291,30454,30603,30884,31187,31431,31831,
  423,  469,  515,  669,  698,  817, 1210, 1840, 2162, 2186,
 3108, 3226, 3698, 4363, 4819, 5217, 5516, 5719, 6002, 6157,
 6265, 6427, 6494, 6782, 7617, 7653, 7701, 7925, 8539, 8758,
 8844, 9425, 9707,10201,10618,10701,11561,11597,11640,11803,
12340,12979,13324,13479,14171,14224,14301,14309,14448,14597,
15204,15790,15827,16163,16347,16768,16859,17400,17420,17479,
18629,19060,19323,19680,20665,20707,20780,21019,21650,22482,
22874,22900,23081,23173,23390,23495,24026,24300,25397,25764,
26004,26438,26651,26706,26886,26944,26983,28145,28236,28298,
29044,29310,29570,30349,30553,30567,31204,31351,31488,31592,
31950,32017,   30,  329,  459,  584, 1413, 2014, 2581, 2809,
 3235, 3868, 3938, 3953, 4565, 4609, 5251, 5318, 5422, 5660,
 5787, 5875, 6118, 6345, 6665, 7258, 7726, 8093, 9365, 9474,
 9540,10250,10457,10470,10476,10612,10970,11100,11916,11971,
12194,12484,12512,12636,12801,12819,12954,12987,13502,13951,
14734,15390,15465,15689,15700,15713,15938,16240,16398,16917,
17141,17634,17694,18182,18288,18679,18703,19049,19651,19694,
20292,20644,21172,21388,21511,22311,22615,23070,23206,23287,
23308,24101,24340,24348,24510,25195,25670,26032,26045,26401,
26574,27115,27192,28085,28315,28361,28484,28616,28655,28948,
30649,31259,  112,  117,  446,  578,  732,  857,  874,  915,
 1284, 1359, 1920, 1945, 1956, 2509, 2562, 2627, 2834, 2925,
 3319, 3591, 3772, 3862, 3876, 3949, 4101, 4231, 4239, 4283,
 4300, 4637, 4735, 4960, 5095, 5301, 5652, 6076, 6341, 6402,
 6414, 7023, 7236, 7330, 7352, 7386, 7503, 7750, 7957, 8167,
 8421, 8457, 8485, 8495, 8665, 8750, 8754, 9065, 9371, 9631,
 9844, 9892,10103,10290,10373,10710,11076,11348,11373,11578,
11746,11795,11843,11872,12139,12362,12400,12621,12696,13111,
13207,13250,13668,13768,13871,14016,14082,14320,14339,14460,
14601,14874,14908,15247,16068,16287,16370,16379,16466,16579,
16823,17175,17181,17195,17379,17432,17599,17676,18301,18463,
18552,18755,19030,19115,19356,19403,19530,19858,20011,20166,
20758,20884,21052,21189,21250,21278,21341,21567,22042,22155,
22281,22409,22555,22755,22894,22910,23125,23441,23761,24048,
24116,24519,24528,24577,24603,24738,24779,24831,24992,25081,
25114,25265,25575,25607,25624,25636,25932,26066,26145,26170,
26355,26603,26881,27144,27359,27513,27601,28096,28130,28259,
28724,28879,29012,29032,29082,29318,29482,29526,30025,30357,
30476,30582,30608,30824,30869,31121,31129,31264,31304,31332,
31346,31366,31551,31617,31966,   71,  108,  163,  427,  438,
  609,  880,  920,  930, 1038, 1085, 1101, 1349, 1363, 1383,
 1546, 1588, 1633, 1639, 1651, 1698, 1759, 1773, 1786, 1810,
 1852, 2051, 2182, 2222, 2254, 2399, 2460, 2597, 2713, 2764,
 2778, 2805, 2814, 2847, 2897, 2930, 3073, 3292, 3326, 3372,
 3404, 3411, 3614, 3655, 3912, 3931, 3968, 4002, 4176, 4328,
 4455, 4478, 4517, 4880, 4937, 4953, 4997, 5122, 5209, 5244,
 5290, 5347, 5388, 5417, 5430, 5591, 5603, 5639, 5644, 5860,
 5907, 6061, 6188, 6306, 6486, 6578, 6616, 6683, 6794, 6883,
 6931, 6950, 7245, 7323, 7374, 7398, 7490, 7495, 7552, 7647,
 7722, 7983, 8098, 8186, 8198, 8207, 8257, 8274, 8355, 8383,
 8405, 8470, 8501, 8518, 8528, 8610, 8890, 8967, 9109, 9116,
 9167, 9378, 9471, 9480, 9527, 9610, 9902, 9939, 9999,10031,
10078,10111,10209,10247,10256,10409,10505,10707,10724,11036,
11071,11201,11247,11276,11464,11718,11798,11830,11975,12113,
12125,12146,12176,12201,12243,12247,12351,12488,12568,12750,
13101,13129,13161,13182,13259,13280,13365,13406,13463,13733,
13914,13939,14227,14288,14432,14444,14538,14620,14691,14746,
14833,14846,14855,14892,14896,15062,15095,15182,15226,15314,
15366,15433,15494,15604,15642,15762,15852,15868,15901,15991,
16039,16166,16256,16330,16413,16512,16553,16780,16867,17032,
17054,17112,17125,17149,17392,17427,17504,17546,17666,17745,
17879,17908,17925,17944,17996,18149,18284,18434,18635,18698,
18719,18866,19046,19158,19217,19312,19485,19684,19712,19800,
19811,19898,20047,20103,20117,20304,20320,20325,20505,20606,
20619,20753,20823,21037,21130,21133,21176,21407,21428,21549,
21593,21655,21700,21720,21968,22015,22030,22307,22340,22405,
22580,22671,22714,23046,23063,23076,23113,23129,23201,23329,
23347,23426,23467,23488,23547,23562,23698,23725,23831,23885,
24012,24034,24160,24290,24321,24437,24458,24475,24634,24644,
24679,24875,25005,25155,25248,25276,25282,25317,25370,25555,
25795,25871,25886,25944,26058,26073,26118,26173,26563,26584,
26588,26729,26840,26912,27012,27028,27200,27300,27342,27376,
27480,27622,27661,27697,27868,27900,27964,27995,28110,28166,
28225,28264,28308,28343,28433,28558,28573,28711,28717,28760,
28803,28865,28894,29129,29231,29239,29259,29376,29401,29409,
29584,29845,29983,29992,30021,30032,30060,30078,30095,30147,
30204,30299,30345,30578,30628,30749,30864,30957,30973,31006,
31039,31046,31143,31256,31410,31419,31573,31701,31820,31874,
31930,   42,  124,  155,  205,  983, 1031, 1234, 1274, 1494,
 1644, 1670, 2118, 2179, 2334, 2345, 2362, 3189, 3500, 3534,
 3713, 3733, 3813, 4084, 4511, 4524, 4534, 4623, 4822, 4940,
 5191, 5332, 5465, 5597, 5626, 5890, 6261, 6279, 6433, 6549,
 6849, 6921, 6972, 7017, 7378, 7418, 7703, 7740, 7831, 7940,
 7964, 8078, 8305, 8371, 8606, 8866, 8937, 8958, 9219, 9292,
 9649, 9751, 9878,10011,10021,10090,10118,10150,10194,10718,
10764,10776,11192,11333,11378,11556,11621,11835,11924,12000,
12039,12239,12711,12833,12930,12948,12973,13264,13276,13343,
13571,13585,13605,13690,13755,13787,14121,14438,14469,14603,
14669,14784,14944,14996,15058,15214,15267,15511,15670,15823,
16152,16324,16425,16773,16831,16853,16979,17146,17205,17324,
17488,17595,17801,17953,18076,18202,18208,18277,18541,18694,
18906,18935,18942,19092,19365,19815,19851,19918,19982,20016,
20074,20087,20213,20420,20573,20775,20868,20932,21068,21285,
21524,21537,21988,21995,22019,22139,22199,22322,22354,22432,
22492,22611,23143,23176,23181,23311,23626,23710,23827,23863,
24314,24344,24424,24606,24656,24689,24785,24910,25226,25392,
25399,25567,25891,26047,26192,26227,26304,26341,26516,26600,
26697,26762,26927,27282,27386,27424,27742,27785,27795,28104,
28352,28384,28528,28693,29228,29242,29265,29507,29667,29825,
29849,29920,30065,30196,30500,30805,30977,31018,31031,31070,
31371,31502,31963,31972,32002,  104,  272,  335,  420,  970,
  987, 1075, 1115, 1212, 1218, 2130, 2166, 2314, 2392, 2421,
 2450, 2543, 2962, 3013, 3166, 3268, 3338, 3977, 3990, 4255,
 4502, 4915, 5031, 5041, 5631, 5879, 5920, 6237, 6366, 6418,
 6462, 6787, 6927, 7057, 7242, 7344, 7711, 7950, 7980, 8386,
 8532, 8897, 9041, 9061, 9136, 9464, 9990,10144,10236,10319,
10415,10466,10772,10819,10838,11210,11437,12255,12899,13000,
13526,13838,14295,14550,14880,15471,15586,15810,15874,16011,
16557,16612,17040,17308,17436,17674,17913,18062,18164,18344,
18667,18949,19033,19540,19589,19644,19929,20038,20066,20245,
20387,20595,20638,21046,21201,21269,21338,21616,21954,22027,
22171,22315,22471,22915,23194,23646,23854,24163,24393,24523,
25217,25268,25288,25359,25437,25736,26232,26581,26626,26827,
26938,27268,27292,27317,27735,27750,27799,28437,28445,28646,
28772,29307,29382,29427,29494,29989,30159,30811,30969,31125,
31459,31605,31634,31686,   33,  148,  196,  819, 1059, 1238,
 1577, 1800, 1804, 2080, 2606, 2649, 2829, 2853, 3087, 3106,
 3368, 3387, 3494, 3794, 4052, 4280, 4484, 4507, 4576, 4845,
 4922, 5376, 5705, 5779, 5847, 5914, 5957, 6248, 6447, 6582,
 7198, 7220, 7261, 7337, 8120, 8353, 8489, 9182, 9223, 9315,
10123,10450,10497,10560,10681,10787,10813,11047,11089,11356,
11676,11722,12155,12223,12562,12645,12690,12961,13199,13350,
13888,13895,14058,14215,14234,14324,14565,15299,15399,15611,
15649,15696,15758,16435,16706,17522,17874,17891,17988,18004,
18318,18496,18557,18595,18710,18960,19231,19446,19604,19719,
19978,20249,20262,20272,20863,21181,21556,21602,21626,21902,
21929,21958,22045,22053,22292,22540,22761,22977,22997,23438,
23530,23684,23926,23933,23943,24084,24447,24856,25010,25300,
25618,25831,26188,26270,26347,26788,26895,27043,27094,27328,
27599,27780,28047,28077,28860,28873,29106,29197,29722,29978,
30240,30280,30407,30561,30727,31022,31184,31243,31920,32007,
  192,  405,  457,  512,  544,  667,  991, 1263, 1392, 1679,
 1741, 1848, 2192, 2306, 2535, 2631, 2787, 2899, 3141, 3322,
 3571, 3973, 3994, 4043, 4112, 4752, 5020, 5478, 5635, 5648,
 5770, 5799, 6178, 6288, 6574, 6796, 6853, 7228, 7492, 7768,
 8126, 8210, 8332, 8572, 8855, 8997, 9075, 9132, 9346, 9362,
 9545, 9870,10029,10242,10397,10636,10849,11104,11224,11444,
11544,11669,11944,11969,12101,12409,12420,12874,13107,13149,
13167,13368,13386,13518,13781,14066,14111,14238,14534,14736,
14826,15271,15380,15429,15445,15553,15562,16180,16268,16280,
16547,16633,16716,17154,17197,17219,17382,17806,17902,17917,
18054,18706,18724,18830,19509,19553,20034,20094,20187,20429,
20545,20627,20682,20882,21034,21630,22334,22465,22741,22945,
23158,23458,23579,23667,23919,24388,24478,24591,24840,24982,
25191,25262,25502,25599,26167,26376,26450,26960,26971,27004,
27228,27369,27532,27764,27878,28003,28042,28056,28549,28641,
28729,28897,29487,29715,29782,29888,29963,29996,30007,30145,
30423,30460,30787,31134,31392,31732,31748,   87,  141,  220,
  490,  517,  623,  654,  694,  809,  832,  863, 1289, 1312,
 1538, 1692, 1749, 1856, 1880, 1954, 1983, 2216, 2331, 2966,
 3030, 3119, 3486, 3549, 3567, 4079, 4097, 4174, 4323, 4571,
 4772, 4834, 4872, 5236, 5471, 5502, 5803, 5867, 6145, 6544,
 6586, 6646, 6800, 6872, 6943, 6955, 7265, 7319, 7367, 7606,
 7624, 7635, 7691, 7717, 8090, 8364, 8535, 8602, 8645, 8906,
 8927, 8933, 9054, 9068, 9140, 9145, 9284, 9421, 9624, 9690,
10422,10493,10674,10714,10766,10987,11051,11080,11214,11261,
11398,11534,11572,11614,11633,11773,11876,12184,12303,12507,
12549,12583,12634,12894,12907,12920,13218,13330,13448,13843,
13898,13957,14315,14524,14750,14819,14837,14982,15305,15385,
15666,15815,15831,15984,16082,16147,16159,16192,16226,16730,
16938,16969,16977,17035,17095,17106,17280,17375,17430,17440,
17977,18159,18281,18461,18522,18588,18643,18681,18740,18816,
18882,19085,19148,19272,19328,19546,19625,20083,20364,20409,
20744,20755,20834,20952,20974,21273,21384,21473,21520,21583,
21733,22023,22107,22135,22167,22229,22397,22511,22575,22584,
22694,23424,23525,23566,23641,23674,23705,23939,23958,24038,
24269,24428,24632,24726,24868,25042,25065,25213,25284,25540,
25819,25951,26017,26060,26122,26134,26160,26415,26615,27298,
27309,27413,27467,27518,27538,27703,27746,27891,28038,28375,
28556,28561,28660,28826,28877,29000,29120,29288,29341,29471,
29639,29795,30000,30114,30222,30419,30485,30641,30659,30731,
30935,31146,31252,31752,31802,31837,31887,31932,31954,  494,
  588,  726,  785, 1062, 1205, 1572, 1628, 1682, 2007, 2058,
 2557, 2845, 2935, 2987, 3082, 3199, 3288, 3498, 3664, 3724,
 3731, 3842, 4159, 4612, 5010, 5076, 5103, 5304, 5700, 5726,
 5901, 5909, 6027, 6207, 6406, 6554, 6568, 6631, 6811, 7157,
 7231, 7572, 7872, 8459, 8778, 8983, 9276, 9533, 9933,10015,
10326,10459,10500,10530,10801,11145,11219,11329,12311,12402,
12529,12821,13189,13252,13312,13676,13730,13878,13987,14134,
14293,14548,14607,14667,14720,15481,15645,15715,16485,16985,
17139,17213,17509,17576,17782,17882,17921,17932,18176,18574,
18774,19227,19321,19634,19688,19870,19934,19984,20030,20163,
20385,20424,20850,20878,21169,21377,21416,21504,22174,22401,
22415,22426,22669,22687,22902,23011,23240,23324,24070,24096,
24192,24906,24928,25352,25536,25612,25687,25814,25834,25937,
26052,26151,26556,26716,27304,27374,27576,27595,27666,27776,
28099,28521,28888,29060,29157,29394,29459,29516,30053,30073,
30544,30626,30694,30858,31580,31718,31789,  165,  530, 1090,
 1368, 1420, 1745, 1892, 2035, 2427, 2887, 3150, 3162, 3168,
 3329, 3557, 3767, 4072, 4180, 4257, 4358, 4439, 4470, 4529,
 4617, 4666, 4875, 4892, 5221, 5249, 5474, 5582, 6164, 6642,
 6670, 6804, 6925, 7109, 7253, 7315, 7354, 7585, 7709, 7811,
 7835, 7843, 7973, 7985, 8301, 8307, 8568, 9104, 9381, 9493,
 9674, 9702, 9846, 9856, 9905, 9950, 9986, 9992,10006,10870,
11153,11175,11199,11234,11279,11458,11552,11594,11625,11758,
11852,11958,12096,12579,13372,13509,13591,13666,13933,14054,
14230,14297,14786,14844,15004,15118,15131,15224,15653,15766,
15782,15882,15948,16061,16189,16212,16477,16559,16837,16927,
16952,17202,17543,17756,17939,18014,18021,18058,18185,18337,
18483,18823,18877,18977,19054,19425,19500,19663,19729,19862,
20097,20282,20394,20508,20773,21179,21213,21254,21343,21432,
21587,21648,22083,22102,22152,22376,22791,22892,23043,23058,
23165,23545,23678,23763,24137,24298,24404,24449,24662,24730,
24988,25012,25078,25187,25662,25972,26455,26469,26757,26801,
26823,26832,26929,26956,26965,26978,27270,27872,28479,28496,
28510,28651,28770,29027,29144,29246,29380,29712,30341,30373,
30587,30636,30874,30985,31033,31192,31207,31330,31515,31621,
31723,31744,31757,31833,31927,31998,    9,   25,   40,  115,
  120,  209,  473,  636,  644,  673,  702,  850,  907,  932,
  966, 1271, 1387, 1401, 1451, 1565, 1735, 1824, 1966, 2010,
 2190, 2245, 2260, 2369, 2377, 2432, 2511, 2608, 2690, 2719,
 2790, 2807, 2827, 2901, 2917, 3123, 3336, 3394, 3408, 3416,
 3426, 3612, 3702, 3754, 3849, 4093, 4119, 4148, 4154, 4241,
 4251, 4522, 4657, 4678, 4686, 4705, 4739, 4759, 4992, 5033,
 5321, 5397, 5488, 5528, 5575, 5712, 5984, 6011, 6034, 6167,
 6195, 6198, 6283, 6343, 6460, 6675, 6687, 6815, 6886, 6958,
 6999, 7012, 7139, 7168, 7212, 7409, 7612, 7728, 7760, 7945,
 7966, 7976, 8102, 8122, 8205, 8215, 8289, 8465, 8513, 8694,
 8772, 8835, 8842, 8859, 8920, 8973, 9158, 9236, 9322, 9449,
 9562, 9628, 9888,10054,10101,10211,10280,10297,10321,10378,
10411,10452,10632,10669,10808,10842,10949,11289,11298,11587,
11740,11839,11940,11985,12006,12056,12206,12380,12407,12445,
12493,12606,12619,12624,12732,12865,12870,12886,12934,12940,
13095,13355,13363,13533,13580,13648,13658,13672,13753,13902,
13907,13953,13969,13981,14073,14210,14217,14708,14728,14755,
14887,14935,14988,15042,15049,15064,15101,15437,15520,15581,
15601,15788,15856,15941,16086,16196,16208,16430,16439,16535,
16655,16666,16712,16720,16797,16958,17165,17185,17424,17475,
17526,17579,17607,17705,17751,18068,18264,18272,18313,18392,
18500,18539,18546,18555,18663,18946,18952,18962,19011,19108,
19209,19450,19476,19654,19675,19749,19805,20207,20443,20503,
20599,20652,20662,20678,20802,20897,21126,21139,21161,21221,
21400,21449,21661,21753,21899,21923,21938,22125,22157,22194,
22336,22436,22872,22924,22943,22956,23006,23072,23089,23098,
23111,23184,23316,23384,23463,23554,23558,23622,24089,24157,
24207,24305,24312,24335,24408,24416,24434,24445,24583,24652,
24809,24895,25030,25230,25296,25307,25357,25366,25650,25755,
25787,25848,25965,25986,26019,26068,26247,26272,26307,26386,
26399,26620,26701,26751,26796,26935,27290,27335,27355,27380,
27396,27458,27563,27609,27614,27882,27983,28005,28118,28271,
28300,28333,28345,28439,28473,28486,28533,28733,28812,28899,
28933,29344,29405,29511,29615,29675,29683,29692,29780,29820,
29836,29851,29912,30177,30277,30403,30462,30556,30572,30673,
30769,30882,30964,30990,31248,31300,31307,31588,31842,32009,
    6,   35,   75,   93,  133,  152,  203,  239,  256,  292,
  414,  436,  488,  507,  522,  599,  689,  769,  824,  841,
  854,  913,  925,  998, 1005, 1050, 1110, 1154, 1166, 1172,
 1216, 1232, 1443, 1470, 1475, 1603, 1653, 1696, 1776, 1830,
 1947, 2005, 2060, 2076, 2151, 2164, 2220, 2264, 2327, 2337,
 2360, 2448, 2468, 2502, 2579, 2588, 2699, 2729, 2732, 2756,
 2785, 2803, 2939, 2985, 3220, 3237, 3290, 3350, 3385, 3398,
 3423, 3490, 3505, 3525, 3554, 3581, 3593, 3652, 3662, 3668,
 3729, 3870, 3878, 3899, 3951, 3970, 4099, 4106, 4127, 4172,
 4198, 4267, 4435, 4451, 4505, 4536, 4573, 4744, 4814, 4853,
 4866, 4925, 4947, 5024, 5053, 5074, 5093, 5101, 5134, 5153,
 5188, 5229, 5271, 5340, 5433, 5453, 5506, 5594, 5620, 5658,
 5730, 5832, 5857, 5877, 5883, 6000, 6020, 6029, 6159, 6172,
 6180, 6230, 6246, 6257, 6274, 6299, 6348, 6378, 6445, 6469,
 6500, 6532, 6591, 6789, 6840, 6858, 6933, 6936, 7105, 7178,
 7238, 7256, 7309, 7325, 7335, 7401, 7441, 7543, 7565, 7579,
 7626, 7713, 7745, 7808, 7876, 7890, 7915, 7971, 8031, 8184,
 8190, 8264, 8325, 8373, 8400, 8554, 8604, 8701, 8718, 8723,
 8733, 8737, 8752, 8788, 8832, 8847, 8881, 8935, 9056, 9063,
 9184, 9225, 9239, 9286, 9355, 9443, 9462, 9489, 9501, 9521,
 9529, 9604, 9645, 9727, 9733, 9748, 9763, 9808, 9851, 9880,
 9915,10082,10216,10238,10254,10286,10331,10417,10528,10696,
10759,10768,10783,10817,10864,10881,10892,10966,10972,11013,
11147,11217,11229,11286,11302,11370,11382,11446,11451,11569,
11619,11678,11800,11821,11849,11906,11926,11982,12036,12050,
12103,12141,12171,12219,12321,12449,12490,12523,12537,12547,
12564,12575,12589,12616,12706,12726,12789,12803,13016,13021,
13029,13070,13074,13082,13118,13136,13142,13145,13184,13203,
13314,13348,13441,13461,13489,13513,13551,13737,13836,13854,
13917,13977,13984,14021,14142,14155,14269,14307,14436,14452,
14465,14505,14510,14622,14632,14639,14684,14748,14807,14868,
14904,14918,14924,14984,14993,15093,15123,15249,15260,15392,
15402,15411,15422,15487,15607,15659,15706,15718,15760,15817,
15877,15978,16136,16184,16228,16250,16265,16353,16396,16410,
16415,16452,16480,16533,16540,16582,16615,16660,16744,16791,
16816,16821,17002,17060,17093,17137,17157,17215,17241,17293,
17361,17493,17498,17518,17530,17535,17586,17794,17818,17893,
17936,17955,17979,18000,18050,18056,18060,18210,18372,18486,
18520,18526,18645,18657,18671,18896,18927,19023,19044,19103,
19113,19162,19261,19265,19290,19417,19444,19467,19516,19542,
19549,19585,19627,19699,19725,19783,19878,19937,20023,20041,
20099,20182,20242,20270,20299,20360,20368,20389,20401,20412,
20498,20633,20640,20647,20805,20810,20861,20900,20930,20942,
20957,21014,21039,21154,21159,21199,21247,21265,21271,21276,
21452,21516,21558,21571,21702,21722,21742,21771,21804,21812,
21843,21857,22000,22011,22017,22098,22176,22303,22342,22361,
22521,22564,22586,22602,22620,22696,22743,22771,22796,22859,
22913,22928,22979,22995,23061,23067,23139,23460,23470,23499,
23528,23589,23632,23669,23696,23708,23729,23755,23777,23837,
23850,23873,23935,24004,24058,24073,24104,24227,24316,24395,
24468,24484,24542,24547,24623,24692,24722,24773,24806,24864,
24878,24901,25053,25083,25152,25169,25208,25302,25388,25394,
25413,25430,25447,25504,25577,25673,25676,25738,25761,25806,
25821,25839,25856,25935,25992,26042,26085,26200,26217,26254,
26266,26309,26332,26521,26546,26612,26724,26817,26844,26900,
26920,26969,26975,27040,27080,27103,27155,27209,27217,27280,
27313,27322,27330,27365,27426,27530,27760,27773,27922,28050,
28091,28128,28136,28161,28179,28189,28251,28262,28313,28338,
28420,28425,28662,28758,28764,28774,28814,28830,28848,28938,
28945,29015,29084,29100,29104,29111,29225,29255,29263,29462,
29473,29581,29605,29635,29717,29724,29734,29802,29813,29863,
29871,29890,29961,29980,30009,30116,30207,30218,30238,30261,
30285,30425,30487,30492,30551,30631,30723,30729,30757,30762,
30783,30803,30928,31010,31043,31048,31173,31219,31245,31353,
31361,31405,31408,31415,31424,31455,31462,31505,31508,31536,
31568,31638,31764,31776,31785,31903,   69,  350,  989, 1247,
 1294, 1454, 1607, 1930, 1981, 2128, 2425, 2766, 3790, 3999,
 4057, 4326, 4811, 4917, 5760, 5895, 6103, 6234, 6626, 6963,
 7313, 7356, 7460, 7762, 7790, 8393, 8474, 8522, 8961, 9070,
 9177, 9858, 9935,10003,10066,10405,11049,11194,11400,11473,
11731,11942,13103,13497,13583,14136,14665,14949,15265,15747,
15780,15835,16080,16572,16596,17313,17417,17754,17872,17923,
17960,18097,18580,18649,18937,18981,19063,19528,20064,20371,
20468,20799,20954,21635,21800,22285,22424,22516,22545,23160,
23292,23581,23628,24109,24147,24794,24833,24858,26148,26372,
26436,26829,26925,27682,27719,27844,27978,28054,28323,28377,
28858,28998,29075,29122,29286,29689,29899,30163,30495,31136,
31150,31961,   44, 1036, 1286, 2353, 2403, 2465, 2532, 2717,
 2953, 2992, 3547, 3992, 4228, 4273, 4500, 4542, 5424, 6110,
 6416, 6633, 6844, 7030, 7111, 7233, 7365, 7574, 7645, 7923,
 8468, 9997,10113,10424,10676,10851,10989,11222,11331,11546,
12053,12157,12585,12746,12792,13093,13216,13573,13912,14097,
14275,14352,14457,14618,14705,15963,16050,16145,16445,16483,
16566,16940,17097,17548,17759,18157,18491,18708,18764,19405,
19460,19505,19622,19710,20134,20204,20314,20383,20675,21011,
21718,21815,21950,22630,22692,22940,24018,24521,24654,24898,
25124,25252,25403,25542,25690,25845,25984,26132,26404,26835,
27046,27083,27701,27726,27770,28675,29010,29843,30412,30585,
30643,31197,31490,31513,31542,31632,31804,   38,   52,   73,
   85,  194,  207,  250,  253,  270,  274,  288,  310,  318,
  403,  492,  525,  532,  546,  580,  614,  678,  692,  706,
  811,  834,  838,  904,  922,  968,  972,  985,  993, 1008,
 1067, 1081, 1169, 1188, 1203, 1236, 1240, 1468, 1508, 1548,
 1595, 1626, 1641, 1649, 1677, 1684, 1690, 1733, 1752, 1781,
 1807, 1858, 1886, 1922, 1952, 1961, 1976, 1985, 2019, 2037,
 2043, 2056, 2066, 2133, 2188, 2194, 2205, 2224, 2278, 2347,
 2375, 2516, 2600, 2621, 2629, 2633, 2646, 2776, 2831, 2843,
 2884, 2894, 2906, 2941, 2944, 2990, 3002, 3011, 3040, 3104,
 3125, 3210, 3264, 3270, 3283, 3309, 3346, 3352, 3414, 3496,
 3512, 3519, 3573, 3659, 3715, 3722, 3751, 3809, 3975, 4055,
 4077, 4086, 4117, 4129, 4140, 4146, 4157, 4178, 4196, 4262,
 4302, 4335, 4374, 4428, 4488, 4509, 4614, 4671, 4747, 4770,
 4774, 4830, 4843, 4889, 4906, 4929, 4934, 4955, 5016, 5050,
 5144, 5200, 5219, 5239, 5258, 5264, 5288, 5299, 5306, 5386,
 5394, 5406, 5469, 5476, 5518, 5573, 5633, 5637, 5650, 5696,
 5714, 5772, 5784, 5796, 5801, 5805, 5855, 5865, 5881, 5899,
 6013, 6063, 6115, 6162, 6293, 6368, 6385, 6392, 6458, 6464,
 6530, 6566, 6601, 6663, 6672, 6730, 6785, 6798, 6802, 6809,
 6813, 6827, 6874, 6881, 6929, 6939, 6945, 6970, 7025, 7263,
 7339, 7342, 7396, 7416, 7436, 7596, 7637, 7689, 7693, 7707,
 7719, 7742, 7813, 7822, 7874, 7896, 7943, 7969, 7987, 8037,
 8112, 8118, 8128, 8148, 8188, 8193, 8212, 8217, 8262, 8292,
 8334, 8348, 8357, 8461, 8487, 8491, 8537, 8583, 8612, 8670,
 8699, 8748, 8756, 8783, 8801, 8853, 8899, 8908, 8956, 9080,
 9169, 9278, 9299, 9306, 9313, 9317, 9334, 9373, 9419, 9446,
 9516, 9543, 9601, 9607, 9618, 9626, 9647, 9651, 9671, 9676,
 9711, 9716, 9730, 9825, 9942, 9948,10008,10027,10075,10086,
10234,10244,10341,10381,10395,10399,10454,10502,10507,10520,
10564,10634,10666,10705,10799,10803,10830,10840,10847,10877,
10900,10917,10981,11066,11102,11155,11161,11169,11197,11431,
11460,11467,11492,11532,11585,11602,11612,11631,11645,11655,
11674,11720,11742,11782,11809,11828,11919,11946,11953,11977,
12008,12023,12061,12153,12182,12237,12260,12291,12306,12318,
12353,12418,12486,12505,12518,12531,12560,12570,12626,12632,
12786,12814,12936,12959,12963,12971,12989,13002,13109,13278,
13282,13292,13332,13339,13401,13446,13450,13515,13599,13656,
13693,13745,13751,13770,13825,13876,13893,13959,13989,14033,
14056,14064,14113,14119,14127,14140,14164,14222,14241,14253,
14282,14337,14365,14420,14478,14483,14494,14552,14655,14681,
14817,14828,14839,14884,14915,14922,14980,14986,15026,15046,
15054,15081,15098,15137,15276,15280,15334,15378,15382,15387,
15397,15502,15509,15517,15560,15599,15609,15627,15647,15651,
15668,15681,15775,15805,15812,15829,15879,15884,15936,16018,
16025,16041,16055,16084,16092,16097,16194,16236,16332,16394,
16549,16561,16640,16708,16835,16841,16856,16861,16950,16987,
16995,16998,17037,17042,17104,17108,17114,17127,17152,17167,
17173,17199,17211,17250,17291,17310,17353,17398,17438,17445,
17495,17507,17541,17572,17581,17604,17708,17749,17780,17792,
17813,17915,18052,18078,18091,18102,18111,18187,18279,18323,
18339,18361,18398,18405,18447,18503,18543,18559,18569,18576,
18586,18627,18633,18660,18701,18716,18884,18975,19013,19028,
19071,19083,19106,19111,19124,19156,19229,19242,19250,19310,
19331,19410,19415,19437,19448,19511,19535,19544,19615,19665,
19672,19682,19717,19723,19747,19853,19924,19973,19980,19993,
20004,20028,20036,20092,20211,20224,20267,20302,20450,20513,
20550,20568,20589,20622,20629,20667,20680,20710,20828,20886,
20895,20939,20979,21032,21044,21057,21141,21183,21218,21228,
21233,21242,21262,21359,21369,21382,21386,21513,21522,21539,
21546,21598,21639,21653,21657,21669,21698,21727,21735,21783,
21837,21904,21971,21980,22013,22021,22047,22051,22109,22159,
22179,22190,22313,22332,22489,22513,22518,22572,22582,22609,
22613,22659,22662,22665,22675,22719,22724,22759,22789,22816,
22922,22975,22985,23056,23074,23127,23153,23196,23261,23276,
23285,23395,23446,23465,23490,23532,23542,23549,23574,23619,
23624,23686,23694,23700,23712,23731,23808,23941,23950,24050,
24091,24094,24099,24219,24239,24278,24310,24342,24346,24397,
24401,24422,24426,24439,24443,24451,24486,24512,24525,24598,
24628,24646,24658,24681,24701,24768,24777,24801,24842,24880,
24888,24972,24990,25101,25118,25215,25260,25286,25298,25364,
25390,25439,25561,25571,25610,25620,25634,25660,25668,25692,
25783,25817,25873,25921,25970,26002,26153,26215,26249,26275,
26335,26349,26366,26397,26413,26417,26506,26511,26551,26572,
26576,26649,26654,26695,26760,26793,26814,26838,26903,26914,
26932,26940,26947,26999,27002,27074,27185,27306,27344,27350,
27362,27391,27398,27485,27494,27549,27574,27597,27674,27715,
27752,27797,27804,27809,27852,27860,27887,27897,27931,27947,
28040,28068,28094,28164,28238,28266,28276,28289,28335,28359,
28367,28390,28435,28447,28489,28494,28502,28508,28610,28709,
28736,28768,28904,28923,28942,29025,29030,29038,29108,29142,
29210,29234,29244,29257,29273,29316,29328,29339,29384,29396,
29440,29540,29612,29623,29637,29656,29669,29685,29694,29727,
29761,29793,29838,29854,29896,29966,29976,30098,30183,30242,
30251,30282,30343,30384,30405,30421,30441,30464,30529,30559,
30580,30638,30647,30661,30670,30675,30741,30790,30801,30846,
30872,30925,30971,30987,31002,31035,31132,31141,31189,31266,
31302,31336,31394,31452,31548,31590,31595,31619,31626,31636,
31691,31713,31726,31746,31792,31798,31835,31844,31895,32015,
   21,  102,  106,  110,  122,  131,  139,  146,  150,  161,
  247,  258,  283,  305,  327,  348,  391,  409,  416,  425,
  429,  433,  455,  471,  478,  536,  549,  586,  604,  611,
  652,  660,  675,  696,  719,  783,  788,  821,  826,  830,
  848,  878,  892,  896,  901,  928, 1052, 1064, 1108, 1126,
 1156, 1193, 1220, 1225, 1249, 1266, 1269, 1291, 1297, 1304,
 1309, 1314, 1353, 1366, 1371, 1375, 1390, 1399, 1405, 1422,
 1445, 1472, 1536, 1570, 1574, 1600, 1619, 1623, 1630, 1657,
 1673, 1743, 1747, 1771, 1778, 1797, 1802, 1838, 1861, 1878,
 2026, 2046, 2063, 2082, 2120, 2141, 2149, 2171, 2208, 2214,
 2266, 2308, 2316, 2329, 2350, 2372, 2390, 2394, 2419, 2423,
 2434, 2444, 2462, 2513, 2547, 2550, 2559, 2571, 2576, 2604,
 2644, 2688, 2697, 2722, 2783, 2816, 2851, 2903, 2919, 2928,
 2937, 2951, 2964, 3015, 3025, 3033, 3101, 3114, 3139, 3152,
 3164, 3171, 3174, 3187, 3191, 3197, 3213, 3229, 3276, 3281,
 3340, 3370, 3458, 3464, 3478, 3492, 3507, 3516, 3552, 3565,
 3569, 3584, 3588, 3610, 3620, 3675, 3680, 3695, 3719, 3735,
 3770, 3787, 3792, 3796, 3858, 3882, 3897, 3918, 3933, 3940,
 4038, 4046, 4067, 4095, 4114, 4122, 4137, 4151, 4189, 4225,
 4233, 4253, 4275, 4294, 4353, 4356, 4361, 4377, 4385, 4437,
 4462, 4476, 4482, 4491, 4532, 4539, 4558, 4561, 4625, 4634,
 4640, 4649, 4664, 4689, 4707, 4711, 4717, 4802, 4837, 4851,
 4886, 4894, 4913, 4920, 4949, 4958, 5000, 5013, 5039, 5060,
 5069, 5089, 5119, 5156, 5197, 5211, 5247, 5255, 5275, 5316,
 5323, 5329, 5378, 5415, 5419, 5461, 5483, 5494, 5500, 5511,
 5525, 5530, 5536, 5601, 5618, 5629, 5642, 5678, 5682, 5733,
 5776, 5781, 5814, 5862, 5916, 5955, 5959, 5982, 6009, 6031,
 6036, 6040, 6044, 6051, 6078, 6084, 6154, 6170, 6183, 6190,
 6209, 6216, 6251, 6259, 6263, 6281, 6286, 6290, 6297, 6304,
 6404, 6412, 6431, 6502, 6542, 6547, 6551, 6563, 6572, 6580,
 6588, 6614, 6628, 6727, 6749, 6830, 6836, 6847, 6851, 6860,
 6870, 6877, 6953, 6960, 6967, 6983, 7015, 7034, 7059, 7076,
 7107, 7115, 7141, 7166, 7171, 7180, 7188, 7196, 7201, 7240,
 7247, 7317, 7321, 7327, 7376, 7384, 7407, 7427, 7451, 7488,
 7538, 7541, 7561, 7582, 7591, 7604, 7614, 7640, 7649, 7686,
 7696, 7715, 7737, 7747, 7802, 7825, 7892, 7917, 7948, 7962,
 7978, 7990, 8007, 8011, 8075, 8095, 8105, 8124, 8145, 8151,
 8220, 8226, 8271, 8279, 8284, 8323, 8351, 8366, 8369, 8388,
 8415, 8448, 8451, 8504, 8520, 8552, 8570, 8588, 8594, 8599,
 8673, 8686, 8691, 8703, 8721, 8739, 8767, 8840, 8850, 8868,
 8874, 8902, 8918, 8923, 8951, 8987, 9029, 9037, 9049, 9077,
 9134, 9138, 9156, 9161, 9172, 9187, 9217, 9244, 9265, 9274,
 9281, 9290, 9294, 9311, 9320, 9339, 9344, 9358, 9367, 9423,
 9440, 9451, 9495, 9568, 9621, 9668, 9699, 9739, 9765, 9828,
 9832, 9848, 9853, 9872, 9876, 9885, 9897, 9912, 9917, 9937,
 9945, 9988, 9994,10013,10033,10057,10092,10099,10116,10120,
10146,10228,10240,10252,10264,10272,10317,10324,10334,10369,
10375,10384,10390,10413,10461,10468,10480,10487,10491,10495,
10579,10585,10594,10599,10629,10640,10663,10716,10762,10806,
10811,10815,10835,10883,10895,10903,10914,10946,10985,11016,
11053,11060,11078,11082,11150,11166,11188,11203,11212,11226,
11232,11237,11249,11256,11264,11291,11335,11350,11363,11375,
11475,11488,11537,11559,11564,11576,11599,11605,11627,11662,
11671,11716,11771,11775,11788,11833,11841,11878,11928,11937,
11956,11994,11998,12004,12017,12048,12065,12106,12109,12123,
12164,12179,12203,12221,12230,12234,12250,12309,12324,12329,
12335,12342,12360,12385,12404,12437,12480,12542,12557,12581,
12591,12608,12639,12688,12717,12759,12764,12794,12806,12835,
12867,12872,12876,12884,12892,12896,12913,12922,12928,12932,
12946,12968,13019,13080,13097,13134,13169,13174,13187,13197,
13201,13205,13308,13346,13357,13370,13384,13414,13454,13458,
13477,13491,13495,13511,13528,13543,13568,13596,13602,13636,
13660,13664,13674,13678,13698,13712,13727,13748,13757,13779,
13832,13845,13900,13909,13924,13931,13955,13966,13975,14052,
14075,14079,14107,14219,14232,14236,14262,14279,14322,14345,
14362,14368,14371,14400,14404,14442,14450,14502,14518,14522,
14532,14541,14546,14599,14605,14609,14660,14672,14678,14689,
14699,14718,14805,14821,14842,14894,14933,15001,15006,15016,
15023,15040,15051,15070,15091,15104,15120,15129,15134,15170,
15202,15221,15228,15258,15269,15303,15331,15372,15375,15404,
15427,15431,15443,15447,15479,15484,15492,15499,15557,15632,
15656,15698,15704,15764,15768,15784,15808,15854,15866,15903,
15946,15970,15986,15989,15995,16013,16032,16063,16100,16143,
16157,16174,16199,16220,16230,16245,16258,16270,16282,16322,
16326,16345,16359,16363,16407,16433,16455,16470,16531,16569,
16575,16591,16594,16610,16618,16635,16651,16657,16714,16718,
16737,16755,16770,16799,16813,16819,16864,16870,16919,16925,
16932,16942,16955,16967,16971,17016,17090,17192,17217,17222,
17237,17243,17322,17363,17368,17372,17422,17477,17490,17520,
17524,17528,17533,17538,17569,17593,17597,17611,17618,17664,
17672,17678,17692,17703,17742,17776,17816,17824,17827,17888,
17929,17958,17963,17991,18012,18070,18099,18118,18138,18142,
18162,18166,18173,18190,18194,18258,18266,18275,18286,18297,
18316,18320,18326,18370,18390,18432,18438,18444,18494,18498,
18537,18566,18593,18652,18665,18673,18721,18726,18742,18833,
18839,18860,18869,18889,18904,18924,18930,18939,18944,18968,
18972,19019,19041,19066,19090,19142,19146,19150,19171,19200,
19239,19270,19279,19286,19292,19326,19346,19399,19427,19440,
19487,19493,19498,19551,19587,19594,19599,19611,19646,19649,
19657,19705,19714,19797,19822,19829,19860,19885,19888,19893,
19931,19986,20001,20009,20025,20059,20072,20105,20113,20119,
20161,20189,20235,20240,20247,20254,20260,20280,20294,20318,
20323,20362,20366,20391,20418,20422,20466,20478,20481,20500,
20548,20565,20571,20597,20650,20655,20684,20770,20778,20784,
20793,20796,20808,20817,20837,20856,20880,20889,20892,20944,
20959,21004,21017,21023,21065,21120,21128,21157,21164,21174,
21187,21252,21267,21283,21316,21336,21397,21403,21430,21436,
21471,21518,21532,21554,21564,21581,21585,21605,21610,21614,
21618,21632,21760,21768,21793,21834,21851,21908,21921,21931,
21936,21941,21956,21977,22032,22039,22081,22085,22088,22105,
22118,22137,22182,22197,22201,22227,22283,22338,22346,22357,
22378,22399,22403,22407,22412,22430,22434,22480,22486,22498,
22509,22542,22558,22561,22577,22685,22727,22739,22746,22780,
22799,22810,22890,22908,22958,22999,23013,23041,23054,23078,
23087,23091,23096,23118,23141,23145,23156,23162,23237,23242,
23257,23295,23301,23314,23322,23327,23360,23364,23372,23379,
23392,23443,23456,23497,23523,23535,23560,23568,23643,23665,
23672,23703,23768,23822,23844,23868,23910,23914,23928,23931,
23937,23963,23967,23972,24010,24021,24024,24032,24040,24045,
24053,24063,24068,24075,24082,24139,24145,24194,24199,24271,
24303,24307,24326,24413,24456,24472,24480,24515,24544,24549,
24611,24668,24684,24698,24724,24728,24771,24787,24812,24829,
24904,24912,24924,24975,24984,25008,25014,25018,25027,25040,
25044,25058,25063,25075,25122,25158,25189,25193,25228,25240,
25278,25290,25304,25346,25354,25372,25376,25416,25435,25450,
25456,25462,25465,25473,25553,25588,25601,25616,25678,25684,
25700,25741,25750,25766,25776,25789,25797,25829,25837,25863,
25888,25924,25949,25963,25977,26015,26034,26071,26120,26137,
26186,26190,26197,26219,26230,26236,26242,26268,26317,26322,
26338,26357,26374,26394,26431,26444,26448,26452,26497,26518,
26535,26544,26554,26561,26594,26617,26657,26718,26731,26771,
26775,26790,26821,26825,26852,26884,26897,26906,26958,26973,
26990,26996,27109,27134,27146,27179,27202,27211,27215,27226,
27230,27277,27284,27311,27319,27333,27353,27367,27388,27411,
27415,27465,27488,27507,27516,27552,27620,27648,27654,27664,
27671,27692,27712,27732,27748,27758,27762,27778,27783,27880,
27913,27916,27928,27960,27985,27993,28034,28061,28081,28101,
28112,28126,28149,28158,28172,28191,28257,28279,28326,28347,
28373,28387,28427,28441,28461,28476,28499,28513,28523,28547,
28554,28614,28624,28644,28648,28658,28698,28722,28727,28755,
28762,28821,28828,28863,28870,28875,28881,28910,28935,28958,
28992,29002,29035,29048,29058,29078,29087,29098,29117,29132,
29154,29187,29199,29237,29261,29283,29305,29331,29399,29407,
29411,29468,29489,29504,29513,29528,29579,29595,29607,29617,
29626,29642,29649,29677,29710,29730,29767,29777,29822,29857,
29865,29893,29956,29998,30003,30018,30023,30038,30071,30076,
30101,30109,30166,30174,30186,30225,30235,30255,30258,30274,
30288,30297,30310,30347,30362,30371,30391,30397,30437,30458,
30498,30542,30546,30574,30593,30601,30606,30621,30664,30725,
30760,30807,30816,30860,30876,30879,30938,30946,30967,31013,
31020,31025,31029,31041,31062,31077,31105,31113,31123,31153,
31166,31171,31209,31237,31250,31311,31319,31340,31348,31368,
31373,31378,31417,31421,31449,31518,31575,31578,31582,31624,
31629,31688,31716,31721,31737,31750,31755,31795,31839,31872,
31876,31885,31890,31900,31922,31934,31952,31970,32000,
0};
static const gx_device_halftone_resource_t res_3 = {
    "Yellow", 3, 167, 167, 256, levels_3, bit_data_3, 2
};
/* Check the prototype. */
DEVICE_HALFTONE_RESOURCE_PROC(gs_dht_StochasticDefault);

const gx_device_halftone_resource_t *const *
gs_dht_StochasticDefault(void)
{
    static const gx_device_halftone_resource_t *const res[] = {
	&res_0, &res_1, &res_2, &res_3, 0
    };
    return res;
}
