#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/^${PKG}-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/^${PKG}-${VER}-//"`
export FULLPKG=${PKG}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e ${PKG}-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${PKG}-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export PKG2=libintl2
export PKG3=gettext-devel
export PKG4=libgettextpo0
export src_orig_pkg_name=${PKG}-${VER}.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg2_name=${PKG2}-${VER}-${REL}.tar.bz2
export bin_pkg3_name=${PKG3}-${VER}-${REL}.tar.bz2
export bin_pkg4_name=${PKG4}-${VER}-${REL}.tar.bz2
export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_pkg2=${topdir}/${src_pkg_name2}
export src_patch=${topdir}/${src_patch_name}
export src_patch2=${topdir}/${src_patch_name2}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg2_name}
export bin_pkg3=${topdir}/${bin_pkg3_name}
export bin_pkg4=${topdir}/${bin_pkg4_name}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# build on
build=i686-pc-cygwin
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc
pnoslash=`echo $prefix | sed -e 's#^/##'`
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
MY_CFLAGS="-O2 -g"
MY_LDFLAGS=
alias_path='/usr/share/locale:/usr/local/share/locale:/usr/X11R6/lib/X11/locale'
PKG1_LIST="\
  ${pnoslash}/share/doc/Cygwin/${PKG}-${VER}.README \
  ${pnoslash}/share/doc/${PKG}-${VER}/* \
  ${pnoslash}/share/gettext/ABOUT-NLS \
  ${pnoslash}/bin/gettext.exe \
  ${pnoslash}/bin/ngettext.exe \
  ${pnoslash}/share/man/man1/gettext.1 \
  ${pnoslash}/share/man/man1/ngettext.1 \
  ${pnoslash}/share/doc/gettext/gettext.1.html \
  ${pnoslash}/share/doc/gettext/ngettext.1.html \
  ${pnoslash}/lib/libintl.* \
  ${pnoslash}/lib/charset.alias \
  ${pnoslash}/share/locale/locale.alias \
  ${pnoslash}/include/libintl.h \
  ${pnoslash}/share/man/man3/* \
  ${pnoslash}/share/doc/gettext/*.3.html \
  ${pnoslash}/share/gettext/libintl.jar \
  ${pnoslash}/share/doc/gettext/javadoc1/* \
  ${pnoslash}/share/doc/gettext/javadoc2/* \
  ${pnoslash}/share/locale/*/LC_MESSAGES/gettext-runtime.mo \
  ${pnoslash}/lib/libasprintf.* \
  ${pnoslash}/include/autosprintf.h \
  ${pnoslash}/share/doc/libasprintf/autosprintf.html \
  ${pnoslash}/share/info/autosprintf.info"
PKG2_LIST="\
  ${pnoslash}/bin/cygintl-*.dll"
PKG4_LIST="\
  ${pnoslash}/bin/cyggettextpo-*.dll \
  ${pnoslash}/bin/cyggettextlib-*.dll \
  ${pnoslash}/bin/cyggettextsrc-*.dll"
PKG3_LIST="\
  ${pnoslash}/share/doc/Cygwin/gettext-devel-${VER}.README \
  ${pnoslash}/bin/autopoint \
  ${pnoslash}/bin/gettextize \
  ${pnoslash}/bin/msg*.exe \
  ${pnoslash}/bin/xgettext.exe \
  ${pnoslash}/share/man/man1/autopoint.1 \
  ${pnoslash}/share/man/man1/gettextize.1 \
  ${pnoslash}/share/man/man1/msg*.1 \
  ${pnoslash}/share/man/man1/xgettext.1 \
  ${pnoslash}/share/doc/gettext/msg*.1.html \
  ${pnoslash}/share/doc/gettext/xgettext.1.html \
  ${pnoslash}/share/doc/gettext/gettextize.1.html \
  ${pnoslash}/share/doc/gettext/autopoint.1.html \
  ${pnoslash}/share/doc/gettext/gettext_*.html \
  ${pnoslash}/share/info/gettext.info* \
  ${pnoslash}/include/gettext-po.h \
  ${pnoslash}/lib/libgettextpo.* \
  ${pnoslash}/lib/libgettextlib.* \
  ${pnoslash}/lib/libgettextsrc.* \
  ${pnoslash}/lib/gettext/* \
  ${pnoslash}/share/locale/*/LC_MESSAGES/gettext-tools.mo \
  ${pnoslash}/share/gettext/config.rpath \
  ${pnoslash}/share/gettext/mkinstalldirs \
  ${pnoslash}/share/gettext/intl/* \
  ${pnoslash}/share/gettext/po/* \
  ${pnoslash}/share/gettext/projects/* \
  ${pnoslash}/share/gettext/gettext.h \
  ${pnoslash}/share/gettext/gettext.jar \
  ${pnoslash}/share/gettext/msgunfmt.tcl \
  ${pnoslash}/share/gettext/archive.tar.gz \
  ${pnoslash}/share/aclocal/codeset.m4 \
  ${pnoslash}/share/aclocal/gettext.m4 \
  ${pnoslash}/share/aclocal/glibc21.m4 \
  ${pnoslash}/share/aclocal/iconv.m4 \
  ${pnoslash}/share/aclocal/intdiv0.m4 \
  ${pnoslash}/share/aclocal/inttypes-pri.m4 \
  ${pnoslash}/share/aclocal/inttypes.m4 \
  ${pnoslash}/share/aclocal/inttypes_h.m4 \
  ${pnoslash}/share/aclocal/isc-posix.m4 \
  ${pnoslash}/share/aclocal/lcmessage.m4 \
  ${pnoslash}/share/aclocal/lib-ld.m4 \
  ${pnoslash}/share/aclocal/lib-link.m4 \
  ${pnoslash}/share/aclocal/lib-prefix.m4 \
  ${pnoslash}/share/aclocal/nls.m4 \
  ${pnoslash}/share/aclocal/po.m4 \
  ${pnoslash}/share/aclocal/progtest.m4 \
  ${pnoslash}/share/aclocal/stdint_h.m4 \
  ${pnoslash}/share/aclocal/uintmax_t.m4 \
  ${pnoslash}/share/aclocal/ulonglong.m4 \
  ${pnoslash}/share/emacs/site-lisp/po-compat.* \
  ${pnoslash}/share/emacs/site-lisp/po-mode.*"

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir}
)}

prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} && \
  cd ${topdir} && \
  patch -p0 < ${src_patch} && \
  mkdirs && \
  cd ${srcdir} && \
  chmod +x gettext-tools/misc/gettextize.in && \
  chmod +x gettext-tools/misc/autopoint.in
)}

conf() {
  (cd ${objdir} && \
  export PATH=/usr/X11R6/bin:/usr/bin:/bin
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  ${srcdir}/configure \
  --srcdir=${srcdir} \
  --prefix=${prefix} \
  --infodir=${prefix}/share/info \
  --sysconfdir=${sysconfdir} \
  --libexecdir='${sbindir}' \
  --localstatedir=/var \
  --datadir='${prefix}/share' \
  --with-included-gettext && \
  chmod +x gettext-tools/misc/gettextize && \
  chmod +x gettext-tools/misc/autopoint
)}

build() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  make aliaspath=${alias_path}
)}

check() {
  check-rpath
  check-runtime
  check-tools
}
check-rpath() {
  (cd ${objdir}/autoconf-lib-link && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  make aliaspath=${alias_path} check | tee ${checkfile}-rpath 2>&1
)}
check-runtime() {
  (cd ${objdir}/gettext-runtime && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  make aliaspath=${alias_path} check | tee ${checkfile}-runtime 2>&1
)}
check-tools() {
  (cd ${objdir}/gettext-tools && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  make aliaspath=${alias_path} check | tee ${checkfile}-tools 2>&1
)}

clean() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  make aliaspath=${alias_path} clean
)}

install() {
  (cd ${objdir} && \
  make install alias_path=${alias_path} DESTDIR=${instdir} && \
  (cd ${instdir}${prefix}/bin ; chmod +x *.dll ) && \
  for fn in share/doc/Cygwin share/doc/${PKG}-${VER} ; do \
    if [ ! -d ${instdir}${prefix}/${fn} ] ; then \
      mkdir -p ${instdir}${prefix}/${fn} ; \
    fi ;
  done && \
  if [ ! -d ${instdir}${sysconfdir}/postinstall ] ; then \
    mkdir -p ${instdir}${sysconfdir}/postinstall ; \
  fi && \
  if [ -f ${instdir}${prefix}/share/info/dir ] ; then \
    rm -f ${instdir}${prefix}/share/info/dir ; \
  fi && \
  templist=""; && \
  for f in ${srcdir}/README ${srcdir}/ABOUT-NLS ${srcdir}/AUTHORS \
    ${srcdir}/BUGS ${srcdir}/COPYING ${srcdir}/DISCLAIM ${srcdir}/NEWS \
    ${srcdir}/PACKAGING ${srcdir}/THANKS ${srcdir}/TODO \
    ${srcdir}/doc/ISO_*  ; do
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
  fi && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
         ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README &&
  cat ${srcdir}/CYGWIN-PATCHES/${PKG3}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
         ${instdir}${prefix}/share/doc/Cygwin/${PKG3}-${VER}.README &&
  if [ -f ${srcdir}/CYGWIN-PATCHES/postinstall.sh ]; then \
    /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/postinstall.sh \
      ${instdir}${sysconfdir}/postinstall/${PKG3}.sh ; \
  fi 
)}

strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip > /dev/null 2>&1 ;
  find . -name "*.dll" | xargs strip > /dev/null 2>&1 ;
  # only strip cygintl.  The other dlls are fragile.
  # find . -name "cygintl*.dll" | xargs strip > /dev/null 2>&1
)}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg2} ${PKG2_LIST}
  tar cvjf ${bin_pkg4} ${PKG4_LIST}
  tar cvjf ${bin_pkg3} ${PKG3_LIST}
  tar cvjf ${bin_pkg}  ${PKG1_LIST}
)}

mkpatch() {
  (cd ${srcdir} && \
  find . -name "autom4te.cache" | xargs rm -rf && \
  tar xv${opt_decomp}f ${src_orig_pkg} && \
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig
)}

spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} *
)}

finish() {
  rm -rf ${srcdir} 
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  check-rpath)	check-rpath ; STATUS=$? ;;
  check-runtime)	check-runtime ; STATUS=$? ;;
  check-tools)	check-tools ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}

