/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.text;

import gnu.java.text.BaseBreakIterator;
import java.text.CharacterIterator;

public class LineBreakIterator
extends BaseBreakIterator {
    public Object clone() {
        return new LineBreakIterator(this);
    }

    public LineBreakIterator() {
        this.iter = null;
    }

    private LineBreakIterator(LineBreakIterator other) {
        this.iter = (CharacterIterator)other.iter.clone();
    }

    private final boolean isNb(char c) {
        return c == '\u00a0' || c == '\u2011' || c == '\ufeff';
    }

    private final boolean isClose(int type) {
        return type == 22 || type == 24;
    }

    private final boolean isIdeo(char c) {
        return c > '\u303f' && c <= '\u309f' || c > '\u309f' && c <= '\u30ff' || c > '\u4dff' && c <= '\u9fff' || c > '\u30ff' && c <= '\u312f';
    }

    public int next() {
        int end = this.iter.getEndIndex();
        if (this.iter.getIndex() == end) {
            return -1;
        }
        while (this.iter.getIndex() < end) {
            char c = this.iter.current();
            int type = Character.getType(c);
            char n = this.iter.next();
            if (n == '\uffff' || type == 14 || type == 13) break;
            int start = this.iter.getIndex();
            if (type == 12 || type == 21 || this.isIdeo(c)) {
                while (n != '\uffff' && Character.getType(n) == 6) {
                    n = this.iter.next();
                }
                if (n == '\uffff') break;
                if (type == 12) {
                    int nt = Character.getType(n);
                    if (nt != 6 && nt != 12 && !this.isNb(n)) {
                        break;
                    }
                } else if (type == 21) {
                    if (this.isIdeo(n)) {
                        start = this.iter.getIndex();
                    }
                } else if (this.isClose(Character.getType(n))) break;
            }
            this.iter.setIndex(start);
        }
        return this.iter.getIndex();
    }

    public int previous() {
        char c;
        int start = this.iter.getBeginIndex();
        if (this.iter.getIndex() == start) {
            return -1;
        }
        while (this.iter.getIndex() >= start && (c = this.iter.previous()) != '\uffff') {
            int type = Character.getType(c);
            char n = this.iter.previous();
            if (n == '\uffff') break;
            this.iter.next();
            int nt = Character.getType(n);
            if (nt == 14 || nt == 13) break;
            int init = this.iter.getIndex();
            while (n != '\uffff' && nt == 6) {
                n = this.iter.previous();
                nt = Character.getType(n);
            }
            if (nt == 12 && type != 12 && type != 6 && !this.isNb(c) || !this.isClose(type) && this.isIdeo(n) || this.isIdeo(c) && nt != 21) break;
            this.iter.setIndex(init);
        }
        return this.iter.getIndex();
    }
}

