// Copyright (c) 1999-2002 by Digital Mars
// All Rights Reserved
// written by Walter Bright
// www.digitalmars.com
// License for redistribution is by either the Artistic License
// in artistic.txt, or the GNU General Public License in gnu.txt.
// See the included readme.txt for details.


#include "d-gcc-includes.h"
#include <assert.h>

#include "total.h"
#include "mars.h"
#include "statement.h"
#include "aggregate.h"
#include "init.h"
#include "attrib.h"

#include "symbol.h"
#include "d-lang.h"
#include "d-codegen.h"

void slist_add(Symbol */*s*/)
{
}
void slist_reset()
{
}

/********************************* SymbolDeclaration ****************************/

SymbolDeclaration::SymbolDeclaration(Loc loc, Symbol *s)
    : Declaration(new Identifier(s->Sident, TOKidentifier))
{
    this->loc = loc;
    sym = s;
    storage_class |= STCconst;
}

Symbol *SymbolDeclaration::toSymbol()
{
    // Create the actual back-end value if not yet done
    if (! sym->Stree) {
	AggregateDeclaration * agg_decl = sym->Sspecial.aggDecl;
	tree struct_type = agg_decl->type->toCtype();
	if ( POINTER_TYPE_P( struct_type ) )
	    struct_type = TREE_TYPE( struct_type ); // for TypeClass
	tree t = sym->Stree = build_decl(VAR_DECL, get_identifier(sym->Sident), struct_type);
	dkeep(t);

	// this->module is isn't set...%%
	if (! getModule())
	    this->parent = agg_decl->parent;
	gen.setupStaticStorage(this, sym->Stree);
	
	// %% what's the diff between setting this stuff on the DECL and the
	// CONSTRUCTOR itself?

	TREE_ADDRESSABLE( t ) = 1;
	TREE_CONSTANT( t ) = 1;
	TREE_READONLY( t ) = 1;
	DECL_CONTEXT( t ) = 0; // These are always global

	// this->module is NULL
    }
    return sym;
    //return csym; // or type csym?
}

/*************************************
 * Helper
 */

Symbol *Dsymbol::toSymbolX(const char *prefix, int sclass, type *t)
{
    Symbol *s;
    char *id;
    char *n;

    n = mangle(); //ident->toChars();
    id = (char *) alloca(strlen(prefix) + strlen(n) + 1);
    sprintf(id,"%s%s", prefix, n);
    s = symbol_name(id, sclass, t);
    return s;
}

/*************************************
 */

Symbol *Dsymbol::toSymbol()
{
    // %% could move this out by haveing IRState::symbolContextDecl...
    // %% Because call toSymbol for arbitrary symbols now, may need
    // to remove the assert below..
    StructDeclaration * struct_decl = (this->isStructDeclaration()); // ClassDeclaration handles itself
    if (struct_decl) {
	if (! csym) {
	    csym = new Symbol();
	    csym->ScontextDecl = struct_decl->type->toCtype();
	}
	return csym;
    } else {
	assert(0);		// BUG: implement
	return NULL;
    }
}

/*********************************
 * Generate import symbol from symbol.
 */

Symbol *Dsymbol::toImport()
{
    if (!isym)
    {
	if (!csym)
	    csym = toSymbol();
	isym = toImport(csym);
    }
    return isym;
}

/*************************************
 */

Symbol *Dsymbol::toImport(Symbol *sym)
{
    /*
    char *id;
    char *n;
    Symbol *s;
    type *t;

    n = sym->Sident;
    id = (char *) alloca(6 + strlen(n) + 5 + 1);
    if (sym->Stype->Tmangle == mTYman_std)
    {
	sprintf(id,"_imp__%s@%d",n,type_paramsize(sym->Stype));
    }
    else
	sprintf(id,"_imp__%s",n);
    t = type_alloc(TYnptr | mTYconst);
    t->Tnext = sym->Stype;
    t->Tnext->Tcount++;
    t->Tmangle = mTYman_c;
    t->Tcount++;
    s = symbol_calloc(id);
    s->Stype = t;
    s->Sclass = SCextern;
    s->Sfl = FLextern;
    slist_add(s);
    return s;
    */
    return 0;
}

/*************************************
 */

Symbol *VarDeclaration::toSymbol()
{
    if (! csym) {
	tree var_decl;

	// For field declaration, it is possible for toSymbol to be called
	// before the parent's toCtype()
	if (storage_class & STCfield) {
	    AggregateDeclaration * parent_decl = parent->isAggregateDeclaration();
	    assert(parent_decl);
	    parent_decl->type->toCtype();
	    assert(csym);
	    return csym;
	}

	var_decl = build_decl(storage_class & STCparameter ? PARM_DECL : VAR_DECL,
	    get_identifier(ident->string),
	    gen.trueDeclarationType( this ));
	dkeep(var_decl);
	// Don't need to mangle if not static storage
	if (isDataseg())
	    SET_DECL_ASSEMBLER_NAME (var_decl, get_identifier( mangle() ));
	//gen.setDeclLoc(var_decl, loc);//try
	gen.setDeclLoc(var_decl, this);
	if ( TREE_CODE( var_decl ) == VAR_DECL ) {
	    gen.setupSymbolStorage(this, var_decl);
	} else {
	    // PARM_DECL
	    /* from gcc code: Some languages have different nominal and real types.  */
	    // %% What about DECL_ORIGINAL_TYPE, DECL_ARG_TYPE_AS_WRITTEN, DECL_ARG_TYPE ?
	    DECL_ARG_TYPE (var_decl) = TREE_TYPE (var_decl);
	    if ( parent->isFuncDeclaration() ) {
		DECL_CONTEXT (var_decl) = parent->toSymbol()->Stree;
	    }
	}
	

	// Can't set TREE_STATIC, etc. until we get to toObjFile as this could be
	// called from a varaible in an imported module
	// %% (out const X x) doesn't mean the reference is const...
	if ( isConst() && ! gen.isDeclarationReferenceType( this )) {
	    // %% CONST_DECLS don't have storage, so we can't use those,
	    // but it would be nice to get the benefit of them (could handle in
	    // VarExp -- makeAddressOf could switch back to the VAR_DECL

	    // if ( typs->isscalar() ) CONST_DECL...
	    
	    TREE_READONLY( var_decl ) = 1;
	    // can at least do this...
	    //  const doesn't seem to matter for aggregates, so prevent problems..
	    if ( type->isscalar() ) {
		TREE_CONSTANT( var_decl ) = 1;
	    }
	}

	if (nestedref) {
	    DECL_NONLOCAL( var_decl ) = 1;
	    TREE_ADDRESSABLE( var_decl ) = 1;
	}

	TREE_ADDRESSABLE( var_decl ) = 1;
	TREE_USED( var_decl ) = 1;
	
	csym = new Symbol();
	csym->Stree = var_decl;

    }
    return csym;
    
#if 0
    //printf("VarDeclaration::toSymbol(%s)\n", toChars());
    assert(!needThis());
    if (!csym)
    {	Symbol *s;
	TYPE *t;
	const char *id;
	mangle_t m;

	if (isDataseg())
	    id = mangle();
	else
	    id = ident->toChars();
	s = symbol_calloc(id);

	if (isParameter())
	{
	    if (storage_class & STCout)
		t = type_fake(TYnptr);
	    else
		t = type->toCParamtype();
	}
	else
	    t = type->toCtype();

	if (isDataseg())
	{
	    s->Sclass = SCextern;
	    s->Sfl = FLextern;
	    slist_add(s);
	}
	else
	{
	    s->Sclass = SCauto;
	    s->Sfl = FLauto;

	    if (nestedref)
	    {
		/* Symbol is accessed by a nested function. Make sure
		 * it is not put in a register, and that the optimizer
		 * assumes it is modified across function calls and pointer
		 * dereferences.
		 */
		//printf("\tnested ref, not register\n");
		type_setcv(&t, t->Tty | mTYvolatile);
	    }
	}
	if (storage_class & STCconst)
	{
	    // Insert const modifiers
	    tym_t tym = 0;

	    if (storage_class & STCconst)
		tym |= mTYconst;
	    type_setcv(&t, tym);
	}
	switch (linkage)
	{
	    case LINKwindows:
		m = mTYman_std;
		break;

	    case LINKpascal:
		m = mTYman_pas;
		break;

	    case LINKc:
		m = mTYman_c;
		break;

	    case LINKd:
		m = mTYman_d;
		break;

	    case LINKcpp:
		m = mTYman_cpp;
		break;

	    default:
		printf("linkage = %d\n", linkage);
		assert(0);
	}
	type_setmangle(&t, m);
	t->Tcount++;
	s->Stype = t;

	csym = s;
    }
    return csym;
#endif    
}

/*************************************
 */

Symbol *ClassInfoDeclaration::toSymbol()
{
    return cd->toSymbol();
}

/*************************************
 */

Symbol *ModuleInfoDeclaration::toSymbol()
{
    return mod->toSymbol();
}

/*************************************
 */

Symbol *TypeInfoDeclaration::toSymbol()
{
    if ( ! csym ) {
	VarDeclaration::toSymbol();
	
	// This variable is the static initialization for the
	// given TypeInfo.  It is the actual data, not a reference
	assert( TREE_CODE( TREE_TYPE( csym->Stree )) == REFERENCE_TYPE );
	TREE_TYPE( csym->Stree ) = TREE_TYPE( TREE_TYPE( csym->Stree ));
    }
    return csym;
}

/*************************************
 */

// returns a FUNCTION_DECL tree
Symbol *FuncDeclaration::toSymbol()
{
    if (! csym) {
	tree id;
	//struct prod_token_parm_item* parm;
	//tree type_node;
	tree fn_decl;
	char * mangled_ident_str;

	//if (getModule() == gen.getBuiltinsModule() && gen.setUpBuiltin(this)) {
	if (gen.maybeSetUpBuiltin(this)) {
	    return csym;
	}

	if (ident) {
	    // Obtain be an IDENTIFIER_NODE tree.
	    id = get_identifier(ident->string);
	} else {
	    // This happens for assoc array foreach bodies
	    
	    // Not sure if idents are strictly necc., but announce_function
	    //  dies without them.

	    // %% better: use parent name
	    
	    static unsigned unamed_seq = 0;
	    char buf[64];
	    sprintf(buf, "___unamed_%u", ++unamed_seq);//%% sprintf
	    id = get_identifier(buf);
	}

	tree fn_type = type->toCtype();
	tree context;
	if (isNested()) {
	    // Nested functions take an extra argument to be compatible with delegates.
	    // The stack frame will come from a trampoline.
	    fn_type = build_function_type(TREE_TYPE(fn_type),
		tree_cons(NULL_TREE, ptr_type_node, TYPE_ARG_TYPES(fn_type)));
	    TYPE_LANG_SPECIFIC( fn_type ) = build_d_type_lang_specific(type);
	    TYPE_LANG_SPECIFIC( fn_type )->is_nested_function = 1;
	    context = parent->toSymbol()->Stree;
	} else {
	    context = NULL;
	}
	
	fn_decl = build_decl( FUNCTION_DECL, id, fn_type );
	dkeep(fn_decl);
	if (ident) {
	    mangled_ident_str = mangle();
	    SET_DECL_ASSEMBLER_NAME (fn_decl, get_identifier( mangled_ident_str ));
	}
	// %% What about DECL_SECTION_NAME ?
	//DECL_ARGUMENTS(fn_decl) = NULL_TREE; // Probably don't need to do this until toObjFile
	DECL_CONTEXT (fn_decl) = context;
	    
	gen.setDeclLoc(fn_decl, loc);
	gen.setupSymbolStorage(this, fn_decl);
	if (! ident)
	    TREE_PUBLIC( fn_decl ) = 0;
	
	
	TREE_USED (fn_decl) = 1; // %% Probably should be a little more intelligent about this

	// if -mrtd is passed, how to handle this? handle in parsing or do
	// we go back and find out if linkage was specified
	switch (linkage)
	{
	    case LINKwindows:
		// %% how to mangle these?
		// add attribute stdcall
		break;
	    case LINKpascal:
		// this is just stdcall without mangling, right?
		break;
	    case LINKc:
		// %% hack: on darwin (at least) using a DECL_EXTERNAL (IRState::getLibCallDecl)
		// and TREE_STATIC FUNCTION_DECLs causes the stub label to be output twice.  This
		// is a work around.  This doesn't handle the case in which the normal
		// getLibCallDecl has already be created an used.  Note that the problem only
		// occurs with function inlining is used.
		gen.replaceLibCallDecl(this);
		break;
	    case LINKd:
		// %% If x86, regparm(1)
		// not sure if reg struct return 
		break;
	    case LINKcpp:
		break;
	    default:
		printf("linkage = %d\n", linkage);
		assert(0);
	}
	
	csym  = new Symbol();
	csym->Sident = mangled_ident_str; // save for making thunks
	csym->Stree = fn_decl;
	csym->ScontextDecl = fn_decl;
    }
    return csym;
}

/*************************************
 */

Symbol *FuncDeclaration::toThunkSymbol(int offset)
{
    Symbol *fsym = toSymbol();
    Symbol *sthunk;

    char *id;
    char *n;
    //type *t;

    n = fsym->Sident; // dmd uses 'sym' -- not sure what that is...
    id = (char *) alloca(8 + 5 + strlen(n) + 1);
    sprintf(id,"_thunk%d__%s", offset, n);
    sthunk = symbol_calloc(id);
    slist_add(sthunk);
    //s->Stype = csym->Stype;
    //s->Stype->Tcount++;
    //sthunk = symbol_generate(SCstatic, csym->Stype);
    //sthunk->Sflags |= SFLimplem;

    tree target_func_decl = fsym->Stree;
    tree thunk_decl = build_decl(FUNCTION_DECL, get_identifier(id), TREE_TYPE( target_func_decl ));
    dkeep(thunk_decl);
    sthunk->Stree = thunk_decl;

    SET_DECL_ASSEMBLER_NAME(thunk_decl, DECL_NAME(thunk_decl));
    DECL_CONTEXT(thunk_decl) = DECL_CONTEXT(target_func_decl);  // from c++...
    TREE_READONLY(thunk_decl) = TREE_READONLY(target_func_decl);
    TREE_THIS_VOLATILE(thunk_decl) = TREE_THIS_VOLATILE(target_func_decl);
    TREE_PUBLIC(thunk_decl) = TREE_PUBLIC(target_func_decl);
    DECL_ARTIFICIAL(thunk_decl) = 1;
    DECL_NO_STATIC_CHAIN(thunk_decl) = 1;
    DECL_INLINE(thunk_decl) = 0;
#if D_GCC_VER >= 34
    DECL_DECLARED_INLINE_P(thunk_decl) = 0;
#endif

    TREE_ADDRESSABLE(thunk_decl) = 1;
    TREE_USED (thunk_decl) = 1; // assuming only called if it will be used   
    
    //cod3_thunk(sthunk, csym, 0, TYnptr, -offset, -1, 0);
    return sthunk;
}


// if 0 -- no place in GCC?
/****************************************
 * Create a static symbol we can hang DT initializers onto.
 */

Symbol *static_sym()
{
#if 0
    Symbol *s;
    type *t;

    t = type_alloc(TYint);
    t->Tcount++;
    s = symbol_calloc("internal");
    s->Sclass = SCstatic;
    s->Sfl = FLextern;
    s->Sflags |= SFLnodebug;
    s->Stype = t;
#if ELFOBJ // Burton
    s->Sseg = DATA;
#endif /* ELFOBJ */
    slist_add(s);
    return s;
#endif
    return 0;
}

/**************************************
 * Fake a struct symbol.
 */

Classsym *fake_classsym(char *name)
{
#if 0
    // if 0 -- no place in GCC ?
    TYPE *t;
    Classsym *scc;

    scc = (Classsym *)symbol_calloc("ClassInfo");
    scc->Sclass = SCstruct;
    scc->Sstruct = struct_calloc();
    scc->Sstruct->Sstructalign = 8;
    //scc->Sstruct->ptrtype = TYnptr;
    scc->Sstruct->Sflags = STRglobal;

    t = type_alloc(TYstruct);
    t->Tflags |= TFsizeunknown | TFforward;
    t->Ttag = scc;		// structure tag name
    assert(t->Tmangle == 0);
    t->Tmangle = mTYman_c;
    t->Tcount++;
    scc->Stype = t;
    slist_add(scc);
    return scc;
#endif
    return 0;
}

/*************************************
 * Create the "ClassInfo" symbol
 */

static Classsym *scc;

Symbol *ClassDeclaration::toSymbol()
{
    if (! csym)
    {
	tree decl;
	csym = toSymbolX("_Class_", SCextern, 0);
	slist_add(csym);

	decl = build_decl( VAR_DECL, get_identifier( csym->Sident ),
	    TREE_TYPE( ClassDeclaration::classinfo->type->toCtype() )); // want the RECORD_TYPE, not the REFERENCE_TYPE
	csym->Stree = decl;
	csym->ScontextDecl = TREE_TYPE( type->toCtype() ); // want the RECORD_TYPE, not the REFERENCE_TYPE
	dkeep(decl);
 
	gen.setupStaticStorage(this, decl);

	TREE_CONSTANT( decl ) = 0; // DMD puts this into .data, not .rodata...
	TREE_READONLY( decl ) = 1; // Non-constant data, but still won't be assigned to.
    }
    return csym;
}

/*************************************
 * Create the "InterfaceInfo" symbol
 */

Symbol *InterfaceDeclaration::toSymbol()
{
    // %% TODO !
    if (!csym)
    {
	csym = ClassDeclaration::toSymbol();
	tree decl = csym->Stree;
	
	Symbol * temp_sym = toSymbolX("_Interface_", SCextern, 0);
	DECL_NAME( decl ) = get_identifier( temp_sym->Sident );
	delete temp_sym;

	TREE_CONSTANT( decl ) = 1; // Interface ClassInfo images are in .rodata, but classes arent..?
    }
    return csym;
}

/*************************************
 * Create the "ModuleInfo" symbol
 */

Symbol *Module::toSymbol()
{
    // %% TODO !

    if (!csym)
    {
	if (! moduleinfo) {
	    Array * packages = new Array;
	    packages->push(Lexer::idPool("std"));
	    Module * mod = Module::load(0, packages, Lexer::idPool("moduleinit.d"));
	    mod->semantic();
	    mod->semantic2();
	    mod->semantic3();
	    if (global.errors || ! moduleinfo) {
		::error("could not get definition of ModuleInfo");
		abort();
	    }
	}
	
	csym = toSymbolX("_ModuleInfo_", SCextern, 0);
	slist_add(csym);

	tree decl = build_decl(VAR_DECL, get_identifier(csym->Sident),
	    TREE_TYPE(moduleinfo->type->toCtype())); // want the RECORD_TYPE, not the REFERENCE_TYPE
	csym->Stree = decl;
#if D_GCC_VER >= 34
	csym->ScontextDecl = build_decl(TRANSLATION_UNIT_DECL, NULL, NULL);
#endif
	
	dkeep(csym->ScontextDecl);
	dkeep(decl);
	
	gen.setupStaticStorage(this, decl);
	TREE_CONSTANT( decl ) = 0; // *not* readonly, moduleinit depends on this
	TREE_READONLY( decl ) = 0; // Not an lvalue, tho
    }
    return csym;
}

/*************************************
 * This is accessible via the ClassData, but since it is frequently
 * needed directly (like for rtti comparisons), make it directly accessible.
 */

Symbol *ClassDeclaration::toVtblSymbol()
{
    if (!vtblsym)
    {
	//if (!csym)
	//    toSymbol();
	tree decl;
	
	vtblsym = toSymbolX("_vtbl_", SCextern, 0);
	slist_add(vtblsym);

	// %% eventual CONSTRUCTOR may have a different type object from the VAR_DECL -- ok?
	// ... can just set the TREE_TYPE of one to the other later
	TypeSArray * vtbl_type = new TypeSArray(Type::tvoid->pointerTo(), new IntegerExp(vtbl.dim));

	decl = build_decl( VAR_DECL, get_identifier( vtblsym->Sident ), vtbl_type->toCtype() );
	vtblsym->Stree = decl;
	dkeep(decl);

	gen.setupStaticStorage(this, decl);

	TREE_ADDRESSABLE( decl ) = 1;
	// from cp/class.c (%%?)
	DECL_CONTEXT (decl) = type->toCtype(); // hm? does this do anything besides make it show
	// up anoyingly in the debugger for every instance? IGNORE_P ?
	// DECL_ARTIFICIAL (decl) = 1;
	DECL_VIRTUAL_P (decl) = 1;
	DECL_ALIGN (decl) = TARGET_VTABLE_ENTRY_ALIGN;
    }
    return vtblsym;
}

/**********************************
 * Create the static initializer for the struct/class.
 */

/* Because this is called from the front end (mtype.cc:TypeStruct::defaultInit()),
   we need to hold off using back-end stuff.  The Symbol is wrapped in a
   SymbolDeclaration which knows to look at the s->Sspecial.aggDecl to construct
   the Stree field
*/

Symbol *AggregateDeclaration::toInitializer()
{
    char *id;
    char *n;
    Symbol *s;
    Classsym *stag;

    if (!sinit)
    {
	n = mangle();
	stag = fake_classsym(n);

	id = (char *) alloca(6 + strlen(n) + 1);
	sprintf(id,"_init_%s",n);
	s = symbol_calloc(id);
	s->Sspecial.aggDecl = this;
	slist_add(s);
	sinit = s;
    }
    return sinit;
}


/******************************************
 */

Symbol *Module::toModuleAssert()
{
#if 0
    // if 0 -- no place in GCC ?
    if (!massert)
    {
	type *t;

	t = type_alloc(TYjfunc);
	t->Tflags |= TFprototype | TFfixed;
	t->Tmangle = mTYman_d;
	t->Tnext = tsvoid;
	tsvoid->Tcount++;

	massert = toSymbolX("_assert_", SCextern, t);
	massert->Sfl = FLextern;
	massert->Sflags |= SFLnodebug;
	slist_add(massert);
    }
    return massert;
#endif
    return 0;
}

/******************************************
 */

Symbol *Module::toModuleArray()
{
#if 0
    if (!marray)
    {
	type *t;

	t = type_alloc(TYjfunc);
	t->Tflags |= TFprototype | TFfixed;
	t->Tmangle = mTYman_d;
	t->Tnext = tsvoid;
	tsvoid->Tcount++;

	marray = toSymbolX("_array_", SCextern, t);
	marray->Sfl = FLextern;
	marray->Sflags |= SFLnodebug;
	slist_add(marray);
    }
    return marray;
#endif
    return 0;
}

/********************************************
 * Determine the right symbol to look up
 * an associative array element.
 * Input:
 *	flags	0	don't add value signature
 *		1	add value signature
 */

Symbol *TypeAArray::aaGetSymbol(char *func, int flags)
#if __DMC__
    __in
    {
	assert(func);
	assert((flags & ~1) == 0);
    }
    __out (result)
    {
	assert(result);
    }
    __body
#endif
    {
#if 0
    // no place in GCC?
	int sz;
	char *id;
	type *t;
	Symbol *s;
	int i;

	// Dumb linear symbol table - should use associative array!
	static Array *sarray = NULL;

	//printf("aaGetSymbol(func = '%s', flags = %d, key = %p)\n", func, flags, key);
#if 0
	OutBuffer buf;
	key->toKeyBuffer(&buf);

	sz = next->size();		// it's just data, so we only care about the size
	sz = (sz + 3) & ~3;		// reduce proliferation of library routines
	id = (char *)alloca(3 + strlen(func) + buf.offset + sizeof(sz) * 3 + 1);
	buf.writeByte(0);
	if (flags & 1)
	    sprintf(id, "_aa%s%s%d", func, buf.data, sz);
	else
	    sprintf(id, "_aa%s%s", func, buf.data);
#else
	id = (char *)alloca(3 + strlen(func) + 1);
	sprintf(id, "_aa%s", func);
#endif
	if (!sarray)
	    sarray = new Array();

	// See if symbol is already in sarray
	for (i = 0; i < sarray->dim; i++)
	{   s = (Symbol *)sarray->data[i];
	    if (strcmp(id, s->Sident) == 0)
		return s;			// use existing Symbol
	}

	// Create new Symbol

	s = symbol_calloc(id);
	slist_add(s);
	s->Sclass = SCextern;
	s->Ssymnum = -1;
	symbol_func(s);

	t = type_alloc(TYnfunc);
	t->Tflags = TFprototype | TFfixed;
	t->Tmangle = mTYman_c;
	t->Tparamtypes = NULL;
	t->Tnext = next->toCtype();
	t->Tnext->Tcount++;
	t->Tcount++;
	s->Stype = t;

	sarray->push(s);			// remember it
	return s;
#endif
	return 0;
    }

