/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 *
 * Copyright (C) 2003 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef _DISTCC_STATE_H
#define _DISTCC_STATE_H

#ifdef __cplusplus
extern "C" {
#endif

int dcc_get_state_dir (char **p);
int dcc_open_state_file (int *p_fd);


/* Note that these must be in the order in which they are encountered
 * for the state file to work properly.  It's OK if some are skipped
 * though. */
enum dcc_state {
    DCC_STATE_STARTUP,
    DCC_STATE_BLOCKED,
    DCC_STATE_CONNECT,
    DCC_STATE_CPP,
    DCC_STATE_SEND,
    DCC_STATE_COMPILE,          /**< or unknown */
    DCC_STATE_RECEIVE,
    DCC_STATE_DONE              /**< MUST be last */
};
    

int dcc_note_state (enum dcc_state state,
                    const char *file,
                    const char *host);
void dcc_remove_state_file (void);


extern const char *dcc_state_prefix;


#define DCC_STATE_MAGIC 0x44494800 /* DIH\0 */

/**
 * State and history of a distcc process.  Used in memory and also in native
 * format for binary state files.
 *
 * This should be <4kB, so that it will normally be written out
 * atomically.
 **/
struct dcc_history {
    size_t struct_size;
    unsigned long magic;
    unsigned long cpid;          /**< Client pid */
    char file[128];             /**< Input filename  */
    char host[128];             /**< Destination host description */
    int slot;                   /**< Which CPU slot for this host */

    enum dcc_state curr_state;

    /** In memory, point to the next in a list of all tasks.  In the
     * file, undefined. */
    struct dcc_history *next;
};


const char *dcc_get_state_name(enum dcc_state state);

void dcc_note_state_slot(int slot);

#ifdef __cplusplus
}
#endif

#endif /* _DISTCC_STATE_H */
