#!/bin/sh
# This script SHOULD get all the api-sgml-files needed by api2man.pl
# It may not. :)
#
if [ $# -lt 1 ]; then
	echo "usage: $0 /path/to/cygwin/src"
	exit 1;
fi

SRCPATH="$1"
OUTDIR="$PWD/api_sgml/"


if [ ! -d "$SRCPATH/winsup" ]; then
	echo "usage: $0 /path/to/cygwin/src"
	echo "(Don't include winsup)"
	exit 1;
fi

cp $(find "$SRCPATH/winsup/cygwin/" -name "*sgml" | grep -v ansi | grep -v posix | grep -v misc) "$OUTDIR"
#for some reason pinfo has embedded SGML in a DOCTOOL comment; let's get it!
csplit.exe "$SRCPATH/winsup/cygwin/pinfo.cc" /DOCTOOL*/+1 /DOC*/ > /dev/null
sed -e 's/  //g' xx01 > "$OUTDIR/pinfo.sgml" && rm -f xx*
echo "Copied:"
ls "$OUTDIR"
