#!/usr/bin/perl
#  Programmer:   Joshua Daniel Franklin
#  Date:    27 April 2002
# 
# As the name implies, this script converts the newlib texinfo documentation
# into passable man pages. This is mainly so that people won't complain 
# about 'man malloc' not working.

$debug=0;
$date=`date +"%Y %b %d"`;
chomp ($date);
mkdir man3 if (! -d man3);

# We decide whether the content of a page should go in a "summary" 
# man page or not with a flag; the first page of the info file should 
# We know which nodes are summaries from the list
@summary_nodes = qw( Top Math version Reentrancy Index Ctype
Stdio Strings Signals Timefns Locale Misc Syscalls Stubs
ReentrantSyscalls Arglists Stdarg Varargs Stdlib LibraryIndex );

@files = qw( libm.info libc.info);

foreach (@files)
{
	open (INF, "$_") || die "Can't open $_!\n";
	$first_time = 1;
	$summary_node = 1;
	
	# Every info file begins with a START-INFO-DIR-ENTRY of the form:
	#'* libm::                   An ANSI-C conforming mathematical library.'
	# which is where we'll get our TITLE, NAME, and SYNOPSIS sections
	$_ = <INF> until (/START-INFO-DIR-ENTRY/);
	$_ = <INF>;
	s/^\* //;
	s/\s\s//g;
	chomp ();
	($title, $synopsis) = split (/::/);
	$TITLE = uc ($title);
	lc ($title); # lowercase for non-case-sensitive filesystem
	open OUTSUM, ">man3/$title.3";
	print OUTSUM ".TH $TITLE 3 \"$date\" \"NEWLIB\" \"NEWLIB\"\n";
	print OUTSUM ".SH NAME\n $title\n";
	print OUTSUM ".SH SYNOPSIS\n $synopsis\n";
	print OUTSUM ".SH DESCRIPTION\n";
	$_ = <INF> until (/END-INFO-DIR-ENTRY/);
	# Some man pages desribe more than one function like:
	#'* acosf:                                 acos.'
	# We can generate a shell script to create the links
	open (LOUT, ">${title}_links.sh");
	print LOUT "#!/bin/sh\n";
	
	while (<INF>) 
	{
	  # octal 037 ("^_") marks node breaks in info files
	  # header lines that follow the break look like:    
	  #'File: libm.info,  Node: atan,  Next: atan2,  Prev: asinh,  Up: Math'
	  # We want just the "Node: $node" part to play with
	  if (/\037/)
	  {
	    $_ = <INF>;
	    if (/Node:/)
	    {
	      @header_line = split (/,/);
	      foreach (@header_line)
	      {
	        if (/Node/)
	        {
		  if ($first_time) { $first_time = 0; }
		  else { print_footer (OUTF); }
	          ($junk, $node) = split (/:/);
	          $node =~ s/\W*//;
	          $node =~ s/ //;
	          if (grep /\Q$node/, @summary_nodes)
	          {
	            $summary_node = 1;
	          }
	          else
	          {
	            $summary_node = 0;
	            open (OUTF, ">man3/$node.3");
		    $NODE = uc ($node);
		    print "working on $node of $title\n" if ($debug);
	            print OUTF ".TH $NODE 3 \"$date\" ";
	            print OUTF "\"NEWLIB\" \"NEWLIB\"\n";
	            print OUTF ".SH NAME\n";
	          }
	        } # End if (/Node/) 
	      } # End of foreach
	    } # End if (/Node:/)
	
	    # We don't need the "Tag Table"
	    if ((/Tag Table:/) || (/^Indirect:/))
	    {
	    	$_ = <INF> until (/End Tag Table/);
		s/.*//g;
	    }  
	    else
	    {
	    # Get rid of the line we already processed
	    $_ = <INF>;
	    }
	
	  } # End if (/\037/)
	
	  s/\s*\*Synopsis\*/.SH SYNOPSIS/;
	  s/\s*\*Description\*/.SH DESCRIPTION/;
	  s/\s*\*Returns\*/.SH RETURNS/;
	  s/\s*\*Portability\*/.SH PORTABILITY/;
	  #s/^[ \t]*//;
	
	  # If a line begins with an "*", we need a line break afterward
	  if (/^\*/) { $_ .= ".br\n"; }
	  if (/^===/) { $_ = ""; }
	
	  # OUTPUT
	  if ($summary_node) { print OUTSUM; }
	  else { print OUTF; }

	  # Some man pages desribe more than one function like:
	  #'* acosf:                                 acos.'
	  # The Index tells us which links to make
	  if ((grep /$node/, "Index") || (grep /$node/, "Library Index"))
	  {
		  s/.br\n//;
		  s/\* //;
		  s/\.$//;
		  s/\s*//g;
		  s/<(.)>/-$1/;
		  ($from, $to) = split(/:/);
		  lc($from);
		  $to = lc($to);
		  if ((!grep /\Q$to/i, @summary_nodes) && ($from ne $to))
		  { 
		  print LOUT "cp man3/${to}.3 man3/${from}.3\n";
		  }
	  } # End if (grep /$node/, "Index")
	} # End while(<INF>)
	
	close (LOUT);
	print_footer (OUTSUM);
}	
exit;
	
sub print_footer
{
	$out_handle = @_[0];
	print { $out_handle } ".SH \"SEE ALSO\"\n";
        if ((!grep /\Q$node/, @summary_nodes) && ($node ne "Library Index"))
	{
		print { $out_handle } ".B $node\n";
		print { $out_handle } "is part of the\n";
		print { $out_handle } ".B $title\n";
		print { $out_handle } "library.\n";
	}
	print { $out_handle } "The full documentation for\n";
	print { $out_handle } ".B $title\n";
	print { $out_handle } "is maintained as a Texinfo manual.  If \n";
	print { $out_handle } ".B info\n";
	print { $out_handle } "and\n";
	print { $out_handle } ".B $title\n";
	print { $out_handle } "are properly installed at your site, ";
	print { $out_handle } "the command\n";
	print { $out_handle } ".IP\n";
	print { $out_handle } ".B info $title\n";
	print { $out_handle } ".PP\n";
	print { $out_handle } "will give you access to the complete manual.\n";
	print "finished $node of $title\n" if ($debug);
	close ($out_handle);
}
