/* $Id: msg.c,v 1.9 2002/11/13 18:21:22 cwilson Exp $ */

/*
 *   IPC package for CygWin
 *
 *   Copyright (C) 1997 Philippe CHAPUY
 *   Copyright (C) 1998 Ludovic LANGE
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   HISTORY:
 *   --------
 *
 *   13/05/1998 : Version 1.00 released
 *                First public release
 *                adress any comments to llange@capgemini.fr
 *
 */



/*
 * Philippe Chapuy, le 20/05/97
 */

#define EXTERN
#include <IpcNtExt.h>
#include <unistd.h>
#include <syslog.h>
#include <sys/ipctrace.h>
extern err_handlerP err_handler;

static void freeque (int id);
static int newque (key_t key, int msgflg);
static int findkey (key_t key);

static struct msqid_ds **msgque;
static int msgbytes = 0;
static int msghdrs = 0;
static unsigned short msg_seq = 0;
static int used_queues = 0;
static int max_msqid = 0;

static struct msqid_ds    *ptrmsg           ;		/*PCPC*/
static CYGWIN_IPCNT_MSGSTR *shareadrmsg         ;		/*PCPC*/

static int		  GFirstMsg	 = 0;		/*PCPC*/
static int		  GFdMsg	    ;		/*PCPC*/

/*****************************************/
/*	Initialization of static variables   */
/*****************************************/
static pid_t GProcessId = 0;
static void init_globals(void)
{
	pid_t pid;

	if (pid=getpid(), pid != GProcessId)
	{
		GFirstMsg = 0;
		msgbytes = msghdrs = msg_seq = used_queues = max_msqid = 0;
		GProcessId = pid;
	}
}
/************************************************************************/
/* Demande d'acces a la zone partagee de gestion des semaphores		*/
/************************************************************************/

static int IsGSemMsgExist()
{
 GSemMsg = OpenSemaphore(SEMAPHORE_ALL_ACCESS, FALSE, CYGWIN_IPCNT_SEMMSG) ;
 if( GSemMsg != NULL )
 {
  return (1) ;
 }
 else
 {
  return (0) ;
 }

}

static int msg_connect(void)
{
 int LRet ;

 init_globals();
 if( GFirstMsg == 0 )
 {
  if( IsGSemMsgExist() )
  {
   GFirstMsg = 1 ;
   GFdMsg  = open(CYGWIN_IPCNT_FILEMSG, O_RDWR, 00666 ) ;
   shareadrmsg = (CYGWIN_IPCNT_MSGSTR *)
   		mmap(0, sizeof(CYGWIN_IPCNT_MSGSTR), PROT_WRITE|PROT_READ,
			MAP_SHARED, GFdMsg, 0) ;
   if( shareadrmsg == (CYGWIN_IPCNT_MSGSTR *) -1 )
   {
    close (GFdMsg) ;
    return (0) ;
   }
   ptrmsg = &(shareadrmsg->msg[0]) ;
   msgque = &(shareadrmsg->msgque[0]);
  }
  else
  {
   /* RAF unmap */
   return(0) ;
  }
 }


 LRet = WaitForSingleObject(GSemMsg, INFINITE) ;


 max_msqid = shareadrmsg->max_msqid ;
 used_queues = shareadrmsg->used_queues ;
 msg_seq = shareadrmsg->msg_seq ;
 msgbytes = shareadrmsg->msgbytes ;
 msghdrs = shareadrmsg->msghdrs ;


 return(1) ;
}

/************************************************************************/
/*PCPC									*/
/************************************************************************/
static void sem_deconnect()
{
 long LPrevious ;


 shareadrmsg->max_msqid = max_msqid ;
 shareadrmsg->used_queues = used_queues ;
 shareadrmsg->msg_seq = msg_seq ;
 shareadrmsg->msgbytes = msgbytes ;
 shareadrmsg->msghdrs = msghdrs ;

 ReleaseSemaphore(GSemMsg, (LONG) 1, &LPrevious) ;


 if( LPrevious != 0 )
 {
   err_handler(stderr, LOG_ERR, "Error , messageQ semaphore not equal 0") ;
 }
}


static int findkey (key_t key)
{
	int id;
	struct msqid_ds *msq;

	if (msg_connect() == 0)
	{
debug_printf("findkey : return -ENOSYS\n");
	 CYGWIN_IPCNT_RETURN (-ENOSYS) ;
	} 
	for (id = 0; id <= max_msqid; id++) { 
		if (msgque[id] == IPC_UNUSED)
		{
			continue;
		}
		msq = (struct msqid_ds *) &(ptrmsg[id]) ;
		if (key == msq->msg_perm.key)
		{
	CYGWIN_IPCNT_RETURN_DECONNECT( id );
	/*		CYGWIN_IPCNT_RETURN (id) ; */
		}
	}
	CYGWIN_IPCNT_RETURN_DECONNECT( -1 );
/*	CYGWIN_IPCNT_RETURN (-1) ;*/
}


int msgsnd (int msqid, struct msgbuf *msgp, size_t msgsz, int msgflg)
{
	int i, id;
	struct msqid_ds *msq;
	struct ipc_perm *ipcp;
	struct msg *msgh;
	struct msg *msg_inter;
	int LBloc ;

debug_printf("msgsnd : msqid=%X msgp=%p msgsz=%X msgflg=%X\n",msqid,msgp,msgsz,msgflg);
	if (msgsz > MSGMAX || (long) msgsz < 0 || msqid < 0 || msgp->mtype <= 0)
	{
debug_printf("msgsnd : return -EINVAL\n");
		CYGWIN_IPCNT_RETURN( -EINVAL );
	}
	if (!msgp)
	{
debug_printf("msgsnd : return -EFAULT\n");
		CYGWIN_IPCNT_RETURN( -EFAULT );
	}

	LBloc = 0 ;
	if (msg_connect() == 0)
	{
debug_printf("msgsnd : return -ENOSYS\n");
	 CYGWIN_IPCNT_RETURN (-ENOSYS) ;
	}

	id = (unsigned int) msqid % MSGMNI;
	if (msgque[id] == IPC_UNUSED || msgque[id] == IPC_NOID)
	{
debug_printf("msgsnd : return -EINVAL\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( -EINVAL );
	}
	msq = (struct msqid_ds *)
			((char *) msgque[id] + (int) msgque);
	ipcp = &msq->msg_perm;

	if (msq->msg_perm.seq != (unsigned int) msqid / MSGMNI)
	{
debug_printf("msgsnd : return -EIDRM\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( -EIDRM );
	}
	/*
	 * Non-root kernel level processes may send to kerneld!
	 * i.e. no permission check if called from the kernel
	 * otoh we don't want user level non-root snoopers...
	 */

	if ( msgsz + (size_t)(msq->msg_cbytes) > (size_t)(msq->msg_qbytes) )
	{
	 if (msgflg & IPC_NOWAIT)
	 {
debug_printf("msgsnd : return -EAGAIN\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( -EAGAIN );
	 }
	}

slept:
	if (LBloc == 1)
	{
	 if (msg_connect() == 0)
	 {
debug_printf("msgsnd : return -ENOSYS\n");
 	  CYGWIN_IPCNT_RETURN (-ENOSYS) ;
 	 }
	}

	/* allocate message header and text space*/
	for( i= 0; i< MSGMAXMESS; i++)
	{
	 if( msq->msg[i].state == 0 )
	 {
	  break ;
	 }
	}
	if( i == MSGMAXMESS )
	{
	 if (msgflg & IPC_NOWAIT)
	 {
debug_printf("msgsnd : return -ENOMEM\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( -ENOMEM );
	 }
	 LBloc = 1 ;
	 sem_deconnect() ;
	 usleep (100000) ;
	 goto slept ;
	}

	msgh = &(msq->msg[i]) ;

/*	memcpy ((char *) msgh->msg_spot*/
/*	+ (int) msgque , msgp->mtext, msgsz); */
	memcpy (msgh->data , msgp->mtext, msgsz); 

	msgh->msg_next = NULL;
	msgh->msg_ts = msgsz;
	msgh->msg_type = msgp->mtype;
	msgh->msg_stime = CURRENT_TIME;
	msgh->state = 1 ;

	if (!msq->msg_first)
		msq->msg_first =
			msq->msg_last =
				(struct msg *) ((char *) msgh -
							(int) msgque) ;
	else {
		msg_inter = (struct msg *)
				((char *) msq->msg_last + (int) msgque) ;
		msg_inter->msg_next =
				(struct msg *) ((char *) msgh -
							(int) msgque) ;
		msq->msg_last =
				(struct msg *) ((char *) msgh -
							(int) msgque) ;
	}
	msq->msg_cbytes += msgsz;
	msgbytes  += msgsz;
	msghdrs++;
	msq->msg_qnum++;
	msq->msg_lspid = getpid();
	msq->msg_stime = CURRENT_TIME;
debug_printf("msgsnd : return 0\n");
	CYGWIN_IPCNT_RETURN_DECONNECT( 0 );
}

int msgrcv (int msqid, struct msgbuf *msgp, size_t msgsz,
	    long msgtyp, int msgflg)
{
	struct msqid_ds *msq;
	struct ipc_perm *ipcp;
	struct msg *tmsg, *leastp = NULL;
	struct msg *nmsg = NULL;
	int id;
	int LBloc ;

debug_printf("msgrcv : msqid=%X msgp=%p msgsz=%X msgtyp=%lX msgflg=%X\n",msqid,msgp,msgsz,msgtyp,msgflg);
	if (msqid < 0 || (long) msgsz < 0)
	{
debug_printf("msgrcv : return -EINVAL\n");
		CYGWIN_IPCNT_RETURN( -EINVAL );
	}
	if (!msgp || !msgp->mtext)
	{
debug_printf("msgrcv : return -EFAULT\n");
	    CYGWIN_IPCNT_RETURN( -EFAULT );
	}

	LBloc = 0 ;
	if (msg_connect() == 0)
	{
debug_printf("msgrcv : return -ENOSYS\n");
	 CYGWIN_IPCNT_RETURN (-ENOSYS) ;
	}

	id = (unsigned int) msqid % MSGMNI;
	if (msgque[id] == IPC_NOID || msgque[id] == IPC_UNUSED)
	{
debug_printf("msgrcv : return -EINVAL\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( -EINVAL );
	}
	msq = (struct msqid_ds *)
			((char *) msgque[id] + (int) msgque);
	ipcp = &msq->msg_perm;

	if (msq->msg_perm.seq != (unsigned int) msqid / MSGMNI)
	{
debug_printf("msgrcv : return -EIDRM\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( -EIDRM );
	}


	/*
	 *  find message of correct type.
	 *  msgtyp = 0 => get first.
	 *  msgtyp > 0 => get first message of matching type.
	 *  msgtyp < 0 => get message with least type must be < abs(msgtype).
	 *  NOTE: msgtyp < 0 is dead code, since msgsnd() will refuse to 
	 *        send messages when called with type < 0.
	 */
	while (!nmsg) {
		if (LBloc == 1)
		{
		 if (msg_connect() == 0)
		 {
debug_printf("msgrcv : return -ENOSYS\n");
	 	  CYGWIN_IPCNT_RETURN (-ENOSYS) ;
	 	 }
		}

		if (msq->msg_perm.seq != (unsigned int) msqid / MSGMNI)
		{
debug_printf("msgrcv : return -EIDRM\n");
			CYGWIN_IPCNT_RETURN_DECONNECT( -EIDRM );
		}

		if (msgtyp == 0)
		{
			if( msq->msg_first )
			{
			 nmsg = (struct msg *)
					((char *) msq->msg_first +
						(int) msgque) ;
			}
		}
		else if (msgtyp > 0)
		{
			if (msgflg & MSG_EXCEPT)
			{
				for ( tmsg = msq->msg_first ; tmsg ;
				tmsg = tmsg->msg_next
				)
				{
					tmsg = (struct msg *) ((char *) tmsg + (int) msgque ) ;
					if (tmsg->msg_type != msgtyp)
					{
						break;
					}
				}
				nmsg = tmsg;
			} else {
				for (tmsg = msq->msg_first; tmsg;
				     tmsg = tmsg->msg_next)
				{
					tmsg = (struct msg *) ((char *) tmsg + (int) msgque ) ;
					if (tmsg->msg_type == msgtyp)
					{
						break;
					}
				}
				nmsg = tmsg;
			}
		}
		else
		{
			for (
			leastp = (struct msg *)
				((char *) msq->msg_first +
					(int) msgque), tmsg = msq->msg_first
			;
			tmsg
			;
			tmsg = tmsg->msg_next)
			{
				tmsg = (struct msg *) ((char *) tmsg + (int) msgque ) ;
				if (tmsg->msg_type < leastp->msg_type)
				{
					leastp = tmsg;
				}
			}
			if (leastp && leastp->msg_type <= - msgtyp)
			{
				nmsg = leastp;
			}
		}

		if (nmsg)
		{ /* done finding a message */
			if ( (msgsz < (size_t)(nmsg->msg_ts) ) && !(msgflg & MSG_NOERROR))
			{
debug_printf("msgrcv : return -E2BIG\n");
				CYGWIN_IPCNT_RETURN_DECONNECT( -E2BIG );
			}
			msgsz = (msgsz > (size_t)(nmsg->msg_ts) )? (size_t)(nmsg->msg_ts) : msgsz;
			if (nmsg ==  (struct msg *)
				((char *) msq->msg_first + (int) msgque))
			{
				msq->msg_first = nmsg->msg_next;
			}
			else
			{
				for (tmsg = msq->msg_first; tmsg;
				     tmsg = tmsg->msg_next)
				{
					tmsg = (struct msg *) ((char *) tmsg + (int) msgque ) ;
					if ((struct msg *)
					    ((char *) tmsg->msg_next
					    + (int) msgque) == nmsg)
					{
						break;
					}
				}
				tmsg->msg_next = nmsg->msg_next ;
				if (nmsg == (struct msg *)
					((char *) msq->msg_last +
						(int) msgque))
				{
					msq->msg_last = (struct msg *)
					((char *) tmsg - (int) msgque) ;
				}
			}
			if (!(--(msq->msg_qnum)))
			{
				msq->msg_last = msq->msg_first = NULL;
			}

			msq->msg_rtime = CURRENT_TIME;
			msq->msg_lrpid = getpid();
			msgbytes -= nmsg->msg_ts;
			msghdrs--;
			msq->msg_cbytes -= nmsg->msg_ts;
			msgp->mtype = nmsg->msg_type ;
/*			memcpy (msgp->mtext, (char *) nmsg->msg_spot
			+ (int) msgque , msgsz); */
			memcpy (msgp->mtext, nmsg->data, msgsz); 
			nmsg->state = 0 ;
debug_printf("msgrcv : return %X\n",msgsz);
			CYGWIN_IPCNT_RETURN_DECONNECT( (int) msgsz );
		}
		else
		{  /* did not find a message */
		 if (msgflg & IPC_NOWAIT)
		 {
debug_printf("msgrcv : return -ENOMSG\n");
			CYGWIN_IPCNT_RETURN_DECONNECT( -ENOMSG );
		 }
		 LBloc = 1 ;
		 sem_deconnect() ;
		 usleep (100000) ;
		}
	} /* end while */
debug_printf("msgrcv : return -1\n");
	CYGWIN_IPCNT_RETURN_DECONNECT( -1 );
}

static int newque (key_t key, int msgflg)
{
	int id;
	struct msqid_ds *msq;
	struct ipc_perm *ipcp;

debug_printf("newque : key=%X msgflg=%X\n",key,msgflg);
	if (msg_connect() == 0)
	{
debug_printf("newque : return -ENOSYS\n");
	 CYGWIN_IPCNT_RETURN (-ENOSYS) ;
	}

	for (id = 0; id < MSGMNI; id++)
		if (!msgque[id] || (msgque[id] == IPC_UNUSED) ) {
			msgque[id] = (struct msqid_ds *) IPC_NOID;
			goto found;
		}

debug_printf("newque : return -ENOSPC\n");
	CYGWIN_IPCNT_RETURN_DECONNECT( -ENOSPC );

found:
	msq = (struct msqid_ds *) &(ptrmsg[id]) ;

	ipcp = &msq->msg_perm;
	ipcp->mode = msgflg ;
	ipcp->key = key;
	ipcp->cuid = ipcp->uid = getpid();
	ipcp->gid = ipcp->cgid = getgid();
	msq->msg_perm.seq = msg_seq;
	msq->msg_first = msq->msg_last = NULL;
	msq->rwait = msq->wwait = NULL;
	msq->msg_cbytes = msq->msg_qnum = 0;
	msq->msg_lspid = msq->msg_lrpid = 0;
	msq->msg_stime = msq->msg_rtime = 0;
	msq->msg_qbytes = MSGMNB;
	msq->msg_ctime = CURRENT_TIME;
	if (id > max_msqid)
	{
		max_msqid = id;
	}
	msgque[id] = (struct msqid_ds *)
			((char *) msq - (int) msgque);
	used_queues++;
debug_printf("newque : return %X\n",(msq->msg_perm.seq) * MSGMNI + id);
	CYGWIN_IPCNT_RETURN_DECONNECT( (msq->msg_perm.seq) * MSGMNI + id );
}

int msgget (key_t key, int msgflg)
{
	int id;
	struct msqid_ds *msq;

debug_printf("msgget : key=%X msgflg=%X\n",key,msgflg);
	/* it is a "normal" request */
	if (key == IPC_PRIVATE)
	{
debug_printf("msgget -> newque\n");
		return newque(key, msgflg);
	}
	if ((id = findkey (key)) == -1) { /* key not used */
		if (!(msgflg & IPC_CREAT))
		{
debug_printf("msgget : return -ENOENT\n");
			CYGWIN_IPCNT_RETURN( -ENOENT );
		}
debug_printf("msgget -> newque\n");
		return newque(key, msgflg);
	}
	if (msgflg & IPC_CREAT && msgflg & IPC_EXCL)
	{
debug_printf("msgget : return -EEXIST\n");
		CYGWIN_IPCNT_RETURN( -EEXIST );
	}
	if (msg_connect() == 0)
	{
debug_printf("newque : return -ENOSYS\n");
	 CYGWIN_IPCNT_RETURN (-ENOSYS) ;
	}

	msq = (struct msqid_ds *)
			((char *) msgque[id] + (int) msgque);
	if (msgque[id] == IPC_UNUSED || msgque[id] == IPC_NOID)
	{
debug_printf("msgget : return -EIDRM\n");
	/*	CYGWIN_IPCNT_RETURN( -EIDRM ); */
	CYGWIN_IPCNT_RETURN_DECONNECT( -EIDRM );
	}
debug_printf("msgget : return %X\n",(msq->msg_perm.seq) * MSGMNI + id);
	/*CYGWIN_IPCNT_RETURN( (msq->msg_perm.seq) * MSGMNI + id );*/
	CYGWIN_IPCNT_RETURN_DECONNECT( (msq->msg_perm.seq) * MSGMNI + id );
}

static void freeque (int id)
{
	struct msqid_ds *msq ;
	struct msg *msgp, *msgh;

debug_printf("newque : id=%X\n",id);
	msq = (struct msqid_ds *)
			((char *) msgque[id] + (int) msgque);
	msq->msg_perm.seq++;

	msg_seq = (msg_seq+1) % ((unsigned)(1<<31)/MSGMNI); /* increment, but avoid overflow */

	msgbytes -= msq->msg_cbytes;

	if (id == max_msqid)
		while (max_msqid && (msgque[--max_msqid] == IPC_UNUSED));

	msgque[id] = (struct msqid_ds *) IPC_UNUSED;

	used_queues--;

	for (msgp = msq->msg_first; msgp;
	     msgp = msgh)
	{

		msgp = (struct msg *) ((char *) msgp + (int) msgque) ;
		msgp->state = 0 ;
		msgh = msgp->msg_next;
		msghdrs--;
	}
}

int msgctl (int msqid, int cmd, struct msqid_ds *buf)
{
	int id;
	struct msqid_ds *msq;
	struct msqid_ds tbuf;
	struct ipc_perm *ipcp;

debug_printf("msgctl : msqid=%X cmd=0x%02X buf=%p\n",msqid,cmd,buf);
	if (msqid < 0 || cmd < 0)
	{
debug_printf("msgctl : return -EINVAL\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( -EINVAL );
	}

	if (msg_connect() == 0)
	{
debug_printf("msgctl : return -ENOSYS\n");
	 CYGWIN_IPCNT_RETURN (-ENOSYS) ;
	}

	id = (unsigned int) msqid % MSGMNI;

	switch (cmd) {
	case IPC_INFO:
	case MSG_INFO:
		if (!buf)
		{
debug_printf("msgctl : MSG_INFO return -EFAULT\n");
			CYGWIN_IPCNT_RETURN_DECONNECT( -EFAULT );
		}
	{
		struct msginfo msginfo;
		msginfo.msgmni = MSGMNI;
		msginfo.msgmax = MSGMAX;
		msginfo.msgmnb = MSGMNB;
		msginfo.msgmap = MSGMAP;
		msginfo.msgpool = MSGPOOL;
		msginfo.msgtql = MSGTQL;
		msginfo.msgssz = MSGSSZ;
		msginfo.msgseg = MSGSEG;
		if (cmd == MSG_INFO) {
			msginfo.msgpool = used_queues;
			msginfo.msgmap = msghdrs;
			msginfo.msgtql = msgbytes;
		}
		memcpy (buf, &msginfo, sizeof(struct msginfo));
debug_printf("msgctl : MSG_INFO return %X\n",max_msqid);
		CYGWIN_IPCNT_RETURN_DECONNECT( max_msqid );
	}
	case MSG_STAT:
		if (!buf)
		{
debug_printf("msgctl : MSG_STAT return -EFAULT\n");
			CYGWIN_IPCNT_RETURN_DECONNECT( -EFAULT );
		}
		if (id > max_msqid)
		{
debug_printf("msgctl : MSG_STAT return -EINVAL\n");
			CYGWIN_IPCNT_RETURN_DECONNECT( -EINVAL );
		}
		if (msgque[id] == IPC_UNUSED || msgque[id] == IPC_NOID)
		{
debug_printf("msgctl : MSG_STAT return -EINVAL\n");
			CYGWIN_IPCNT_RETURN_DECONNECT( -EINVAL );
		}
		msq = (struct msqid_ds *)
			((char *) msgque[id] + (int) msgque);
		id = (unsigned int) msq->msg_perm.seq * MSGMNI + msqid;
		memcpy( &(tbuf.msg_perm), &(msq->msg_perm),
				sizeof(struct ipc_perm) );
		tbuf.msg_stime  = msq->msg_stime;
		tbuf.msg_rtime  = msq->msg_rtime;
		tbuf.msg_ctime  = msq->msg_ctime;
		tbuf.msg_cbytes = msq->msg_cbytes;
		tbuf.msg_qnum   = msq->msg_qnum;
		tbuf.msg_qbytes = msq->msg_qbytes;
		tbuf.msg_lspid  = msq->msg_lspid;
		tbuf.msg_lrpid  = msq->msg_lrpid;
		memcpy (buf, &tbuf, sizeof(struct msqid_ds));
debug_printf("msgctl : MSG_STAT return %X\n",id);
		CYGWIN_IPCNT_RETURN_DECONNECT( id );
	case IPC_SET:
		if (!buf)
		{
debug_printf("msgctl : IPC_SET return -EFAULT\n");
			CYGWIN_IPCNT_RETURN_DECONNECT( -EFAULT );
		}
		memcpy (&tbuf, buf, sizeof (struct msqid_ds) );
		break;
	case IPC_STAT:
		if (!buf)
		{
debug_printf("msgctl : IPC_STAT return -EFAULT\n");
			CYGWIN_IPCNT_RETURN_DECONNECT( -EFAULT );
		}
		break;
	}

	id = (unsigned int) msqid % MSGMNI;
	if (msgque[id] == IPC_UNUSED || msgque[id] == IPC_NOID)
	{
debug_printf("msgctl : return -EINVAL\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( -EINVAL );
	}
	msq = (struct msqid_ds *)
			((char *) msgque[id] + (int) msgque);
	if (msq->msg_perm.seq != (unsigned int) msqid / MSGMNI)
	{
debug_printf("msgctl : return -EINVAL\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( -EIDRM );
	}
	ipcp = &msq->msg_perm;

	switch (cmd) {
	case IPC_STAT:
		tbuf.msg_perm   = msq->msg_perm;
		tbuf.msg_stime  = msq->msg_stime;
		tbuf.msg_rtime  = msq->msg_rtime;
		tbuf.msg_ctime  = msq->msg_ctime;
		tbuf.msg_cbytes = msq->msg_cbytes;
		tbuf.msg_qnum   = msq->msg_qnum;
		tbuf.msg_qbytes = msq->msg_qbytes;
		tbuf.msg_lspid  = msq->msg_lspid;
		tbuf.msg_lrpid  = msq->msg_lrpid;
		memcpy (buf, &tbuf, sizeof ( struct msqid_ds ));
debug_printf("msgctl : IPC_STAT return 0\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( 0 );
	case IPC_SET:
		msq->msg_qbytes = tbuf.msg_qbytes;
		ipcp->uid = tbuf.msg_perm.uid;
		ipcp->gid =  tbuf.msg_perm.gid;
		msq->msg_ctime = CURRENT_TIME;
debug_printf("msgctl : IPC_SET return 0\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( 0 );
	case IPC_RMID:
		freeque (id);
debug_printf("msgctl : IPC_RMID return 0\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( 0 );
	default:
debug_printf("msgctl : return -EINVAL\n");
		CYGWIN_IPCNT_RETURN_DECONNECT( -EINVAL );
	}
}
