/* $Id: ipctest.c,v 1.9 2002/11/12 19:14:06 cwilson Exp $ */

/*
 *   IPC package for CygWin
 *
 *   Copyright (C) 1997 Philippe CHAPUY
 *   Copyright (C) 1998 Ludovic LANGE
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   HISTORY:
 *   --------
 *
 *   13/05/1998 : Version 1.00 released
 *                First public release
 *                adress any comments to llange@capgemini.fr
 * 
 *   14/05/1998 : Version 1.01 released
 *                support for Linux style / Posix style 
 *                adress any comments to llange@capgemini.fr
 *
 */


#define EXTERN
#include <IpcNtExt.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <syslog.h>
#include <sys/ipctrace.h>

typedef struct
{
 long type ;
 char message[200] ;
} MON_MESSAGE ;

void FSyntaxe(char *chaine)
{
 printf ("\n%s s [<nsems>] | [c <key> <nsems>] | [g <key> <num>] | [s <key> <num> <val>\n\n", chaine) ;
 printf ("Semaphores\n") ;
 printf ("  no args,            creates an array of 1 semaphore, key = 0\n") ;
 printf ("  <nsems>             creates an array of <nsems> semaphores, key = 0\n") ;
 printf ("  c <key> <nsems>     creates an array of <nb> semaphores, with key <key>\n") ;
 printf ("  g <key> <num>       gets semaphore <num> from key <key>\n") ;
 printf ("  s <key> <num> <val> sets semaphore <num> from key <key> to value <val>\n") ;
 printf ("\n\n");
 printf ("%s h [g <key> <size>] | [a <shmid> ]\n\n", chaine) ;
 printf ("sHared memory\n") ;
 printf ("  no args,            creates an array of 1000 bytes of shared memory\n") ;
 printf ("  g <key> <size>      gets segment of size <size> from key <key>\n") ;
 printf ("  a <shmid>           attaches to segment <shmid>\n") ;
 printf ("\n\n");
 printf ("%s g [c <size>] | [m <key>] | [k <key>] | [f <file>] | [v <file>] | \n"
         "     [s <msgid> <st> <t>] | [r <msgid> <t> <max>]\n\n", chaine) ;
 printf ("messaGe queue\n") ;
 printf ("  no args,            creates a message queue\n") ;
 printf ("  c <size>            creates a message queue\n") ;
 printf ("  m <key>             creates a message queue with key <key>\n") ;
 printf ("  k <key>             return id for message queue with key <key>\n") ;
 printf ("  f <file>            creates a message queue for file <file>\n") ;
 printf ("  v <file>            return id for message queue for file <file>\n") ;
 printf ("  s <msgid> <st> <t>  sends string <st> type <t>\n") ;
 printf ("  r <msgid> <t> <max> receives type <t> long max <max>\n") ;
 printf ("\n\n") ;
}

int libcygipc_err_handler(FILE *stream, int severity, const char *fmt, ...);

int main(int a, char **v)
{
 int LId, LRet ;
 char *adr ;
 struct sembuf LPop ;
 struct stat st;
 
 FVersionInfo(a,v);
 cygipc_set_err_handler(libcygipc_err_handler);

 printf ("Test v0.03\n") ;
 
 if( a >= 2 )
 {
  switch (*(v[1]))
  {

   case 's':
   case 'S':

	  if( a == 2)
	  {
 	   LId = semget(IPC_PRIVATE, 1, IPC_CREAT|IPC_EXCL) ;

	   if( LId < 0 )
	   {
	    printf ("Unable to create semaphore\n") ;
	    perror ("semget ") ;
	   }
	   else
	   {
	    printf ("semaphore %d created\n", LId) ;
	   }
	  }
	  else if (a == 3)
	  {
 	   LId = semget(IPC_PRIVATE, atoi(v[2]), IPC_CREAT|IPC_EXCL) ;

	   if( LId < 0 )
	   {
	    printf ("Unable to create semaphore\n") ;
	    perror ("semget ") ;
	   }
	   else
	   {
	    printf ("semaphore %d created\n", LId) ;
	   }
	  }
	  else
	  {
	   if( (v[2][0]=='c') || (v[2][0]=='C'))
	   {
	    LId = semget (atoi(v[3]), atoi(v[4]), IPC_CREAT|IPC_EXCL);
	    if( LId < 0 )
	    {
	     printf ("Unable to create semaphore\n") ;
	     perror ("semget ") ;
	    }
	    else
	    {
	     printf ("semaphore %d created\n", LId) ;
 	    }
	   }
	   else if( ((v[2][0]=='g') || (v[2][0]=='G')) && a == 5 )
	   {
 	    LPop.sem_num = atoi(v[4]) ;
	    LPop.sem_op = -1 ;
	    LPop.sem_flg = 0 ;

	    errno = 0 ;

	    LRet = semop(atoi(v[3]), &LPop, 1) ;

	    if (LRet < 0)
	    {
	     printf ("Unable to get semaphore\n") ;
	     perror ("semop ") ;
 	    }
	    else
	    {
	     printf ("get was ok, 20 seconds sleep\n") ;
	     sleep(20) ;
	     LPop.sem_op = 1 ;
	     LPop.sem_flg = 0 ;

	     errno = 0 ;
	     LRet = semop(atoi(v[3]), &LPop, 1) ;
	     if (LRet < 0)
	     {
	      printf ("Unable to set semaphore\n") ;
	      perror ("semop ") ;
	     }
	     else
	     {
	      printf ("get/set was ok.\n") ;
	     }
	    }
	   }
	   else if( ((v[2][0]=='s') || (v[2][0]=='S')) && a == 6 )
	   {
 	    LPop.sem_num = atoi(v[4]) ;
	    LPop.sem_op = atoi(v[5]) ;
	    LPop.sem_flg = 0 ;

	    errno = 0 ;

	    LRet = semop(atoi(v[3]), &LPop, 1) ;
/*
test:
 	    LPop.sem_num = 0 ;
	    LPop.sem_op = 2 ;
	    LPop.sem_flg = 0 ;

	    errno = 0 ;

	    LRet = semop(0, &LPop, 1) ;
*/

	    if (LRet < 0)
	    {
	     printf ("Unable to set semaphore\n") ;
	     perror ("semop ") ;
 	    }
	    else
	    {
	     printf ("semaphore has been set ok.\n") ;
	    }
	   }
	  }
	 break ;

   case 'h':
   case 'H':

	if( a == 2)
	{
	 LId = shmget (IPC_PRIVATE, 1000, IPC_CREAT);
	 if( LId < 0 )
	 {
	  printf ("Unable to create shared memory segment\n") ;
	  perror ("shmget ") ;
	 }
	 else
	 {
	  printf ("Shared memory segment %d created\n", LId) ;
	 }

#if SHMAT_LINUX
	 LRet = shmat (LId, NULL, 0, &adr);
#warning Compiling LINUX-like shmat
#else
	 adr = shmat (LId, NULL, 0);
	 LRet = ( (adr==(char*)-1)?-1:0 );
#endif
	 printf ("shmat return code= %d\n", LRet) ;
	 if( LRet == 0 )
	 {
	  printf ("shmat ok adr= %p\n", adr) ;
	printf("ok\n");
	  strcpy(adr, "TEST 1") ;
 	 }
	 else
	 {
	printf("nok\n");
	  printf ("shmat failed, errno= %d\n", errno) ;
	 }

	}
	else if( ((v[2][0]=='a')||(v[2][0]=='A')) && a == 4 )
	{
#if SHMAT_LINUX
	 LRet = shmat (atoi(v[3]), NULL, 0, &adr);
#else
	 adr = shmat (atoi(v[3]), NULL, 0);
	 LRet = ( (adr==(char*)-1)?-1:0 );
#endif
	 printf ("shmat return code= %d\n", LRet) ;
	 if( LRet == 0 )
	 {
	  printf ("shmat ok adr= %p\n", adr) ;
	  printf ("Data read = %s\n", adr) ;
 	 }
	 else
	 {
	  printf ("shmat failed\n") ;
	  perror ("shmat ") ;
	 }
	}
	else if( ( (v[2][0]=='g') || (v[2][0]=='G') ) && a == 5 )
	{
	 LRet = shmget (atoi(v[3]), atoi(v[4]), 0);
	 printf ("shmget return code= %d\n", LRet) ;
	 if( LRet >= 0 )
	 {
	  printf ("shmget ok\n") ;
 	 }
	 else
	 {
	  printf ("shmget failed\n") ;
	  perror ("shmget ") ;
	 }
	}
	break ;

   case 'g':
   case 'G':

/*	 if( a == 2 || a == 3 ) */
	 if( a == 2 )
	 {
	  LId = msgget (IPC_PRIVATE, IPC_CREAT);
	  if( LId < 0 )
	  {
	   printf ("Unable to create PRIVATE msgqueue.\n") ;
	   perror ("msgget ") ;
	  }
	  else
	  {
	   printf ("PRIVATE msgqueue %d created\n", LId) ;
 	  }
	 }
	 else
	 {
	  if( ( v[2][0]=='c') || (v[2][0]=='C') )
	  {
	   LId = msgget (atoi(v[3]), IPC_CREAT);
	   if( LId < 0 )
	   {
	    printf ("Unable to create msgqueue %d\n", atoi(v[3]) ) ;
	    perror ("msgget ") ;
	   }
	   else
	   {
	    printf ("msgqueue %d created\n", LId) ;
 	   }
	  }
	  else if( (( v[2][0]=='m') || (v[2][0]=='M')) && a == 4 )
	  {
          
	   if (atoi(v[3]) == 0)
	   {
	       printf("Invalid Key\n");
	       exit(0);
	   }
           LId = msgget (atoi(v[3]), IPC_CREAT|IPC_EXCL ); 
	   if( LId < 0 )
	   {
	    printf ("Unable to create msgqueue for key %d . Return: %d\n", atoi(v[3]),LId ) ;
	    perror ("msgget ") ;
	   }
	   else
	   {
	    printf ("msgqueue %d,key %d  created \n", LId, atoi(v[3])) ;
 	   }
          }
	  else if( (( v[2][0]=='k') || (v[2][0]=='K')) && a == 4 )
	  {
	   if (atoi(v[3]) == 0)
	   {
	       printf("Invalid Key\n");
	       exit(0);
	   }
	   LId = msgget (atoi(v[3]), 0600 );
	   if( LId < 0 )
	   {
	    printf ("Unable to find msgqueue with key %d .Return: %d \n", atoi(v[3]), LId ) ;
	    perror ("msgget ") ;
	   }
	   else
	   {
	    printf ("msgqueue %d found for key %d\n", LId, atoi(v[3])) ;
 	   }
          }
	  else if( (( v[2][0]=='f') || (v[2][0]=='F')) && a == 4 )
	  {
	   if (stat (v[3], &st) < 0)
	   {
	    printf("Invalid Filename %s\n", v[3]);
	    perror ("ftok ");
	   }
	   else 
	   {
	    LId = msgget (ftok(v[3],0), IPC_CREAT );
	    if( LId < 0 )
	    {
	     printf ("Unable to create msgqueue for file %s. Return: %d\n", v[3],LId ) ;
	     perror ("msgget ") ;
	    }
	    else
	    {
	     printf ("msgqueue %d,key %lld  created for file %s\n", LId, 
	      (long long int) ftok(v[3],0),v[3]) ;
	    }
	   }
	  }
	  else if( (( v[2][0]=='v') || (v[2][0]=='V')) && a == 4 )
	  {
	   if (stat (v[3], &st) < 0)
	   {
	       printf("Invalid Filename %s\n", v[3]);
	       perror ("ftok ");
	   }
	   else
	   {
	    LId = msgget (ftok(v[3],0), 0600 );
	    if( LId < 0 )
	    {
	     printf ("Unable to find msgqueue %s with key %lld.Return: %d \n", 
	      v[3], (long long int) ftok(v[3],0), LId ) ;
	     perror ("msgget ") ;
	    }
	    else
	    {
	     printf ("msgqueue %d found for %s\n", LId, v[3]) ;
	    }
	   }
	  }
	  else if( ( (v[2][0]=='s') || (v[2][0]=='S'))  && a == 6 )
	  {
	   MON_MESSAGE mess ;
	   int LBoucle = 0 ;
	   int msgq ;

	   msgq = atoi(v[3]) ;
boucle_send:

	   mess.type = (long) atoi (v[5]) ;
	   strcpy (mess.message, v[4]) ;
	   name_mangle(LBoucle, mess.message+strlen(mess.message)+1) ;

	   LRet = msgsnd(msgq, (struct msgbuf *) &mess, strlen(mess.message), 0);
	   if( LRet < 0 )
	   {
	    perror ("msgsnd ") ;
	   }
	   else
	   {
	    if( (LBoucle % 1000) == 0)
	    printf ("Message sent\n") ;
	   }
	   if( a > 6 )
	   {
	    if( LBoucle == 10000 ) LBoucle = 0 ;
	    else LBoucle++ ;

	    usleep (1000) ;
	    goto boucle_send ;
	   }
	  }
	  else if( ( (v[2][0]=='r') || (v[2][0]=='R')) && a == 6 )
	  {
	   MON_MESSAGE mess ;
	   int LBoucle = 0 ;
	   int msgq ;

	   msgq = atoi(v[3]) ;

boucle_receive:

	   memset (&mess, 0, sizeof (MON_MESSAGE)) ;
	   LRet = msgrcv(msgq, (struct msgbuf *) &mess, atoi(v[5]), atoi(v[4]),IPC_NOWAIT);

	   if( LRet < 0 )
	   {
	    perror ("msgrcv ") ;
	   }
	   else
	   {
	    if( (LBoucle % 1000) == 0)
	    printf ("Message received = %s\n", mess.message) ;
	   }
	   if( a > 6 )
	   {
	    if( LBoucle == 10000 ) LBoucle = 0 ;
	    else LBoucle++ ;

	    usleep (1000) ;
	    goto boucle_receive ;
	   }
	  }
	  else
	  {
	   FSyntaxe(v[0]) ;
	  }
	 }
	 break ;


   default:

   	 FSyntaxe(v[0]) ;
	 break ;

  }
 }
 else
 {
  FSyntaxe(v[0]) ;
 }
 return 0;
}

int libcygipc_err_handler(FILE *stream, int severity, const char *fmt, ...)
{
  char buf[2000];
  va_list ap;
  int count;
  
  if(cygipc_get_debug() || (severity < LOG_DEBUG))
  {
    count = snprintf (buf, 2000, "(ipctest:libcygipc) ");
    va_start (ap, fmt);
    count += vsnprintf (buf + count, 2000 - count, fmt, ap);
    va_end (ap);
    snprintf(buf + count, 2000 - count, "\n");
    fprintf(stream, buf); 
  } 
  return 0;
} 

