/* $Id: IpcNtLit.h,v 1.8 2003/05/21 03:01:32 cwilson Exp $ */

/*	
 *   IPC package for CygWin
 *
 *   Copyright (C) 1997 Philippe CHAPUY
 *   Copyright (C) 1998 Ludovic LANGE
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   HISTORY:
 *   --------
 *
 *   13/05/1998 : Version 1.00 released
 *                First public release
 *                adress any comments to llange@capgemini.fr
 *
 */
 
 


/************************************************************************/
/*									*/
/************************************************************************/

#ifndef CYGWIN_IPCNT_LIT
#define CYGWIN_IPCNT_LIT

#define CYGWIN_IPCNT_BIT_IPC			0x0001

/************************************************************************/
/************************************************************************/
#define CYGWIN_IPCNT_PKGNAME		"cygipc2_"
#define CYGWIN_IPCNT_SEMCTL_BASE	"MultiSemCtl2_"
#define CYGWIN_IPCNT_SEMSEM_BASE	"MultiSemSem2_"
#define CYGWIN_IPCNT_SEMSHM_BASE	"MultiSemShm2_"
#define CYGWIN_IPCNT_SEMMSG_BASE	"MultiSemMsg2_"
#define CYGWIN_IPCNT_FILESEM		"/tmp/MultiFileSem2"
#define CYGWIN_IPCNT_FILESHM		"/tmp/MultiFileShm2"
#define CYGWIN_IPCNT_FILEMSG		"/tmp/MultiFileMsg2"

#define NAMESPACE_PREFIX "Global\\"
#define FULL_NAMESPACE_PATH(name) \
	({DWORD ver = GetVersion(); \
	(ver < 0x80000000 && LOBYTE(LOWORD(ver)) >= 5) ? \
	NAMESPACE_PREFIX name : name;})

#define CYGWIN_IPCNT_SEMCTL	FULL_NAMESPACE_PATH(CYGWIN_IPCNT_SEMCTL_BASE)
#define CYGWIN_IPCNT_SEMSEM	FULL_NAMESPACE_PATH(CYGWIN_IPCNT_SEMSEM_BASE)
#define CYGWIN_IPCNT_SEMSHM	FULL_NAMESPACE_PATH(CYGWIN_IPCNT_SEMSHM_BASE)
#define CYGWIN_IPCNT_SEMMSG	FULL_NAMESPACE_PATH(CYGWIN_IPCNT_SEMMSG_BASE)
/************************************************************************/
/* SEMAPHORE								*/
/************************************************************************/
#define CYGWIN_IPCNT_RETURN(a) \
	{ \
	errno = 0 ; \
	if( a == -1 ) return (a) ; \
	if( a < 0 ) { errno = -a; return(-1) ; } \
	return (a) ; \
	}

#define CYGWIN_IPCNT_RETURN_DECONNECT(a) \
	{ \
	sem_deconnect() ; \
	errno = 0 ; \
	if( a == -1 ) return (a) ; \
	if( a < 0 ) { errno = -a; return(-1) ; } \
	return (a) ; \
	}

#if SHMAT_LINUX

#define CYGWIN_IPCNT_RETURN_DECONNECT_SHMAT(a) CYGWIN_IPCNT_RETURN_DECONNECT(a)

#else

#define CYGWIN_IPCNT_RETURN_DECONNECT_SHMAT(a) \
	{ \
	sem_deconnect() ; \
	errno = 0 ; \
	if( a == -1 ) return ((char *)a) ; \
	if( a < 0 ) { errno = -a; return((char *)-1) ; } \
	return (adr) ; \
	}
#endif

#define CYGWIN_IPCNT_RETURN_DECONNECT_WAIT1(a) \
	{ \
	sem_deconnect() ; \
	sleep(1) ; \
	errno = 0 ; \
	if( a == -1 ) return (a) ; \
	if( a < 0 ) { errno = -a; return(-1) ; } \
	return (a) ; \
	}


/************************************************************************/
/* MEMOIRE PARTAGEE							*/
/************************************************************************/

/************************************************************************/
/* MESSAGE QUEUE							*/
/************************************************************************/

#define CURRENT_TIME			time(0)

#endif
