


WordNet User Commands                                    WNB(1WN)



NAME
     wnb - WordNet window-based browser interface

SYNOPSIS
     wnb

DESCRIPTION
     wnb() provides a window-based  interface  for  browsing  the
     WordNet  database,  allowing  synsets  and  relations  to be
     displayed as formatted text.  For  each  search  word,  dif-
     ferent  searches  are  available based on syntactic category
     and information available in the database.

     wnb is written in Tcl/Tk, which is available  for  Unix  and
     Windows platforms.  This allows the same code to work on all
     supported WordNet platforms without modification.

WNB WINDOWS
     wnb() was developed with  the  philosophy  that  only  those
     searches and buttons that are applicable at the current time
     are displayed.  As a result, the appearance of the interface
     changes  as  it  is used.  Use the standard windowing system
     mouse functions to open and close the WordNet  Browser  Win-
     dow, move the window, and change its size.

     The WordNet Browser Window  contains  the  following  areas,
     from top to bottom:

     Menubar             A menubar runs  along  the  top  of  the
                         browser  window  with pulldown menus and
                         button entitled File, History,  Options,
                         and Help.

     Search Word Entry   Below the Menubar is a line for entering
                         the search word.  A search word can be a
                         single word,  hyphenated  string,  or  a
                         collocation.  Case is ignored.  Although
                         only uninflected forms of words are usu-
                         ally stored in WordNet, users may search
                         for inflected forms.  WordNet's  morpho-
                         logical  processor  finds  the base form
                         automatically.

     Search Selection    Below the Search Word Entry line  is  an
                         area  for  selecting the search type and
                         senses to search.  Until a  search  word
                         is  entered this area is blank.  After a
                         search word is entered,  buttons  appear
                         corresponding to each syntactic category
                         (Noun, Verb, Adjective, Adverb) in which
                         the search string is defined in WordNet.




WordNet 2.0          Last change: July 2003                     1






WordNet User Commands                                    WNB(1WN)



                         At the right edge of the  Search  Selec-
                         tion  line  is  a box for entering sense
                         numbers.  When this box is empty, search
                         results  for  all  senses  of the search
                         word that  match  the  search  type  are
                         displayed.  The search may be restricted
                         to one or more specific senses by enter-
                         ing  a  comma or space separated list of
                         sense numbers in the Senses box.   These
                         sense  numbers  remain  in  effect until
                         either the user changes or deletes them,
                         or a new search word is entered.

     Results Window      Most of the browser window consists of a
                         large  text  buffer  for  displaying the
                         results of WordNet searches.  Horizontal
                         and vertical scroll bars are present for
                         scrolling through the output.

     Status Line         A status line is at the  bottom  of  the
                         browser window.  When search results are
                         displayed in the  Results  Window,  this
                         status  line reflects the type of search
                         selected.  When there is no search  word
                         entered,  your  are  prompted  to "Enter
                         search word and press return."   If  the
                         search  word  entered is not in WordNet,
                         the message "Sorry, no  matches  found."
                         is displayed.

SEARCHING THE DATABASE
     The WordNet browser navigates through WordNet in two  steps.
     First  a  search  word is entered and an overview of all the
     senses of the word in all syntactic categories is  displayed
     in  the  Results Window. The senses are grouped by syntactic
     category, and each synset is annotated  as  described  above
     with  _s_y_n_s_e_t__o_f_f_s_e_t,  _l_e_x__f_i_l_e_n_a_m_e, and _s_e_n_s_e__n_u_m_b_e_r as dic-
     tated by the advanced  search  options  set.   The  overview
     search also indicates how many of the senses in each syntac-
     tic category are represented in the tagged texts.  This is a
     way for the user to determine whether a sense's sense number
     is based on semantic tagging data, or was randomly assigned.
     For  each  sense that has appeared in such texts, the number
     of semantic tags to that sense are indicated in  parentheses
     after the sense number.

     Then, within a syntactic  category,  a  specific  search  is
     selected.   The  desired  search is performed and the search
     results are displayed in  the  Results  Window.   Additional
     searches  on the same word can be performed, or a new search
     word can be entered.




WordNet 2.0          Last change: July 2003                     2






WordNet User Commands                                    WNB(1WN)



     To enter a search word, click the mouse  in  the  horizontal
     box  labeled  Search  Word,  type  a single word, hyphenated
     string, or collocation and press RETURN.

     wnb() responds by making a set of  Part  of  Speech  buttons
     appear   in   the   Search   Selection  line.   Each  button
     corresponds to a syntactic  category  in  which  the  search
     string is defined in WordNet.  At the same time, an Overview
     of the  synsets  for  all  senses  of  the  search  word  is
     displayed  in the Results Window.  The Overview includes the
     gloss for each synset and also indicates which of the senses
     have  appeared  in  the semantically tagged texts.  For each
     sense that has appeared in such texts, the number of  seman-
     tic  tags  to  that sense are indicated in parentheses after
     the sense number.

     The pulldown menus in the Search Selection line list all  of
     the  WordNet  searches  that can be performed for the search
     word in that part of speech.  To select a search,  highlight
     it  by dragging the mouse to it, and release the mouse while
     it is highlighted.  Drag the mouse outside of  the  pulldown
     list  and  release  to hide the menu without making a selec-
     tion.  Dragging the mouse across the Part of Speech  buttons
     displays the available searches for each syntactic category.

     To restrict a search to one or more senses within a  syntac-
     tic category, enter a comma or space separated list of sense
     numbers in the Senses box before selecting a search.

     After a search is selected, wnb() performs the search on the
     WordNet  database  and displays the formatted results in the
     Results Window.  Whenever search results  are  displayed,  a
     button  entitled  Redisplay Overview is present at the right
     edge of the Search Word Entry line.  Clicking on this button
     redisplays  the  Overview of all synsets for the search word
     in the Results Window.

  Changing the Search Word
     A new search word can be entered at any time  by  moving  to
     the  Search  Word Entry box, if necessary highlighting it by
     clicking, erasing the old  string,  typing  a  new  one  and
     pressing RETURN. The Senses box is cleared if necessary, the
     Part of Speech buttons applicable to  the  new  search  word
     appear,  and  the  Overview  for  the  new  search  word  is
     displayed.

     The middle mouse button can also be used  to  select  a  new
     search  word  by  placing  the  mouse  over  any word in the
     Results Window and clicking.  The selected word will replace
     the  text in the Search Word Entry box, and the overview for
     that word will automatically be displayed.




WordNet 2.0          Last change: July 2003                     3






WordNet User Commands                                    WNB(1WN)



     To select a new search string collocation from text  in  the
     Results  Window, highlight the text with the mouse and press
     CONTROL-S.


  Interrupting a Search
     When a search is in progress the message "Searching...(press
     escape  to  abort)"  is  displayed in the Status Line.  Note
     that most searches return  very  quickly,  so  this  message
     isn't  noticeable.   As  indicated,  pressing the ESCAPE key
     will interrupt  the  search.   The  results  of  the  search
     obtained  before  the  time  the  search was interrupted are
     displayed in the Results Window.

MENUS
  File Menu
          Find keywords by substring
               Display a popup window for specifying a search  of
               WordNet  for  words or collocations that contain a
               specific substring.  If a search word is currently
               entered  in the Search Word box, it is used as the
               substring to search for by default.  The Substring
               Search  Window  contains a box for entering a sub-
               string, a pulldown menu to its right for  specify-
               ing the part of speech to search, a large area for
               displaying the search results, and action  buttons
               at   the   bottom  entitled  Search,  Save,  Print
               Dismiss.

               Once a substring is entered and a part  of  speech
               selected,  clicking  on the Search button causes a
               search to be done for all words  and  collocations
               in  WordNet, in that syntactic category, that con-
               tain the substring according to the following cri-
               teria:

               1. The substring can appear at  the  beginning  or
               end of a word, hyphenated string o collocation.

               2. The substring can appear in  the  middle  of  a
               hyphenated  string or collocation, but only delim-
               ited on both sides by spaces or hyphens.

               The search results  are  displayed  in  the  large
               buffer.   Clicking  on  an  item  from  the search
               results list causes wnb() to  automatically  enter
               that  word  in  the Search Word box of the WordNet
               Browser Window and perform the Overview search.

               Clicking the Save button generates a popup  dialog
               for  specifying  a  filename to save the substring
               search results  to.   Clicking  the  Print  button



WordNet 2.0          Last change: July 2003                     4






WordNet User Commands                                    WNB(1WN)



               generates  a popup dialog in which a print command
               can be specified.

               Selecting Dismiss closes the Substring Search Win-
               dow.

          Save current display
               Display a popup dialog for specifying  a  filename
               to save the current Results Window contents to.

          Print current display
               Display a popup dialog in which to specify a print
               command  to  which the current Results Window con-
               tents can be piped. Note - this  option  does  not
               exist in the Windows version.

          Clear current display
               Clear  the  Search  Word  and  Senses  boxes,  and
               Results Window.

          Exit Does what you would expect.

  History
     This pulldown menu contains a list of the last searches per-
     formed.   Selecting  an  item  from  this list performs that
     search again.  The maximum number of searches stored in  the
     list  can be adjusted from the Options menu.  The default is
     10.

  Options
          Show help with each search
               When this checkbox is selected search results  are
               preceded  by  some explanatory text about the type
               of search selected. This is off by default.

          Show descriptive gloss
               When this checkbox is selected, synset glosses are
               displayed  in  all search results.  This is set by
               default.  Note that glosses are  always  displayed
               in the Overview.

          Wrap Lines
               When this  checkbox  is  selected,  lines  in  the
               Results  Window that are wider than the window are
               automatically wrapped.  This is  set  by  default.
               If  not  selected,  a  horizontal  scroll  bar  is
               present if any lines are longer than the width  of
               the window.

          Set advanced search options
               Selecting this item displays a  popup  window  for
               setting  the  following  search  options:  Lexical



WordNet 2.0          Last change: July 2003                     5






WordNet User Commands                                    WNB(1WN)



               file  information;  Synset  location  in  database
               file; Sense number.  Choices for each are:

                    Don't show (default)
                    Show with searches
                    Show with searches and overview

               When lexical file information is shown,  the  name
               of  the  lexicographer file is printed before each
               synset, enclosed in  angle  brackets  (<  ...  >).
               When  both  lexical  file  information  and synset
               location information  are  displayed,  the  synset
               location information appears first.  If within one
               lexicographer file more than one sense of  a  word
               is entered, an integer _l_e_x__i_d is appended onto all
               but one of the word's instances to uniquely  iden-
               tify  it.  In each synset, each word having a non-
               zero _l_e_x__i_d  is  printed  with  the  _l_e_x__i_d  value
               printed  immediately  following the word.  If both
               lexicographer information and  sense  numbers  are
               displayed,  _l_e_x__i_ds,  if  present,  precede  sense
               numbers.

               When synset location is shown, the byte offset  of
               the synset in the database "data" file correspond-
               ing to the syntactic category  of  the  synset  is
               printed  before  each  synset,  enclosed  in curly
               braces ({  ...  }).  When both lexical file infor-
               mation   and   synset   location  information  are
               displayed, the synset location information appears
               first.

               When sense numbers are shown, the sense number  of
               each  word  in  each synset is printed immediately
               after the word, and is preceded by a  number  sign
               (#).

          Set maximum history length
               Display a popup dialog in which the maximum number
               of  previous  searches  to  be kept on the History
               list can be set.

          Set font
               Display  a  popup  window  for  setting  the  font
               (typeface)  and  font  size to use for the Results
               Window.  Choices for typeface are:  Courier,  Hel-
               vetica,  and  Times  (default).   Font size can be
               small, medium (default), or large.

  Help
          Help on using the WordNet browser
               Display this manual page.



WordNet 2.0          Last change: July 2003                     6






WordNet User Commands                                    WNB(1WN)



          Help on WordNet terminology
               Display the wngloss(7WN) manual page.

          Display the WordNet license
               Display the WordNet copyright notice  and  license
               agreement.

          About the WordNet browser
               Information about this application.

SHORCUTS
     Clicking on any word in the  Results  Window  while  holding
     down  the  SHIFT  key  on the keyboard causes the browser to
     replace Search Word with the word and display  its  Overview
     and available searches.  Clicking on any word in the Results
     Window with the middle mouse button does the same thing.

     Pressing the CONTROL-S keys causes  the  browser  to  do  as
     above  on the text that is currently highlighted, even it if
     is in another  window.   This  method  works  on  hyphenated
     strings and collocations, as well as individual words.

     Pressing the CONTROL-G keys displays  the  Substring  Search
     Window.


SEARCH RESULTS
     The  results  of  a  search  of  the  WordNet  database  are
     displayed  in  the  Results Window.  Horizontal and vertical
     scroll bars are present for  scrolling  through  the  search
     results.

     All searches other than the Overview list all senses  match-
     ing  the  search  results  in  the following general format.
     Items enclosed in italicized square brackets  ([ ... ])  may
     not be present.

     If a search cannot be performed on some senses of _s_e_a_r_c_h_s_t_r,
     the search results are headed by a string of the form:
          X of Y senses of _s_e_a_r_c_h_s_t_r

          One line listing the  number  of  senses  matching  the
          search selected.

          Each sense matching the search  selected  displayed  as
          follows:

               Sense _n
               [{_s_y_n_s_e_t__o_f_f_s_e_t}] [<_l_e_x__f_i_l_e_n_a_m_e>]  _w_o_r_d_1[#_s_e_n_s_e__n_u_m_b_e_r][,  _w_o_r_d_2...]

          Where _n  is  the  sense  number  of  the  search  word,
          _s_y_n_s_e_t__o_f_f_s_e_t  is  the byte offset of the synset in the



WordNet 2.0          Last change: July 2003                     7






WordNet User Commands                                    WNB(1WN)



          data._p_o_s file corresponding to the syntactic  category,
          _l_e_x__f_i_l_e_n_a_m_e is the name of the lexicographer file that
          the synset comes from, _w_o_r_d_1 is the first word  in  the
          synset  (note  that  this is not necessarily the search
          word) and _s_e_n_s_e__n_u_m_b_e_r  is  the  WordNet  sense  number
          assigned   to   the   preceding  word.   _s_y_n_s_e_t__o_f_f_s_e_t,
          _l_e_x__f_i_l_e_n_a_m_e, and _s_e_n_s_e__n_u_m_b_e_r  are  generated  if  the
          appropriate Options are specified.

          The synsets matching the search  selected  are  printed
          below each sense's synset output described above.  Each
          line of output is preceded by a  marker  (usually  =>),
          then  a  synset,  formatted  as  described above.  If a
          search traverses more one level of the tree, then  suc-
          cessive  lines  are indented by spaces corresponding to
          its level in the hierarchy.  Glosses are  displayed  in
          parentheses  at the end of each synset if the appropri-
          ate Option is set.  Each synset is printed on one line.

          Senses are ordered from most to least frequently  used,
          with  the  most  common sense numbered 1.  Frequency of
          use is determined by the number of  times  a  sense  is
          tagged  in  the  various  semantic  concordance  texts.
          Senses that are  not  semantically  tagged  follow  the
          ordered  senses.  Note  that  this  ordering is only an
          estimate based on usage in a small corpus.

          Verb senses can be grouped by  similarity  of  meaning,
          rather  than  ordered  by  frequency  of use.  When the
          "Synonyms, grouped by similarity of meaning" search  is
          selected,  senses that are close in meaning are printed
          together, with a line of dashes indicating the end of a
          group.   See  wngroups(7WN) for a discussion how senses
          are grouped.

          The output of the "Derivationally Related Forms" search
          shows  word  forms  that are morphologically related to
          searchstr. Each word form pointed to from _s_e_a_r_c_h_s_t_r  is
          displayed,  preceded  by RELATED TO-> and the syntactic
          category of the link, followed, on the  next  line,  by
          its  synset.  Printed after the word form is #_n where _n
          indicates the WordNet sense number of the term  pointed
          to.

          The "Domain"  and  "Domain  Terms"  searches  show  the
          domain  that  a synset has been classified in and, con-
          versely, all of the terms that have been assigned to  a
          specific domain.  A domain is either a CATEGORY, REGION
          _o_r USAGE, _a_s _r_e_f_l_e_c_t_e_d _i_n _t_h_e _s_p_e_c_i_f_i_c _p_o_i_n_t_e_r  _c_h_a_r_a_c_-
          _t_e_r  _s_t_o_r_e_d  _i_n _t_h_e _d_a_t_a_b_a_s_e, _a_n_d _d_i_s_p_l_a_y_e_d _i_n _t_h_e _o_u_t_-
          _p_u_t.  _A -domn _s_e_a_r_c_h _o_n _a _t_e_r_m  _s_h_o_w_s  _t_h_e  _d_o_m_a_i_n,  _i_f
          _a_n_y,  _t_h_a_t  _e_a_c_h  _s_y_n_s_e_t  _c_o_n_t_a_i_n_i_n_g _s_e_a_r_c_h_s_t_r _h_a_s _b_e_e_n



WordNet 2.0          Last change: July 2003                     8






WordNet User Commands                                    WNB(1WN)



          _c_l_a_s_s_i_f_i_e_d _i_n.  _T_h_e _o_u_t_p_u_t  _d_i_s_p_l_a_y  _s_h_o_w_s  _t_h_e  _d_o_m_a_i_n
          _t_y_p_e  (CATEGORY, REGION _o_r USAGE), _f_o_l_l_o_w_e_d _b_y _t_h_e _s_y_n_-
          _t_a_c_t_i_c _c_a_t_e_g_o_r_y _o_f _t_h_e _d_o_m_a_i_n _s_y_n_s_e_t _a_n_d _t_h_e  _t_e_r_m_s  _i_n
          _t_h_e  _s_y_n_s_e_t.  _E_a_c_h _t_e_r_m _i_s _f_o_l_l_o_w_e_d _b_y #_n _w_h_e_r_e _n _i_n_d_i_-
          _c_a_t_e_s _t_h_e _W_o_r_d_N_e_t _s_e_n_s_e _n_u_m_b_e_r _o_f _t_h_e _t_e_r_m.   _T_h_e  _c_o_n_-
          _v_e_r_s_e _s_e_a_r_c_h, -domt, _s_h_o_w_s _a_l_l _o_f _t_h_e _s_y_n_s_e_t_s _t_h_a_t _h_a_v_e
          _b_e_e_n _p_l_a_c_e_d _i_n_t_o _t_h_e _d_o_m_a_i_n _s_e_a_r_c_h_s_t_r,  _w_i_t_h  _a_n_a_l_o_g_o_u_s
          _m_a_r_k_e_r_s.

          _W_h_e_n _t_h_e "Sentence Frames" _s_e_a_r_c_h _i_s _s_p_e_c_i_f_i_e_d,  _s_a_m_p_l_e
          _i_l_l_u_s_t_r_a_t_i_v_e  _s_e_n_t_e_n_c_e_s _a_n_d _g_e_n_e_r_i_c _s_e_n_t_e_n_c_e _f_r_a_m_e_s _a_r_e
          _d_i_s_p_l_a_y_e_d.  _I_f _a _s_a_m_p_l_e _s_e_n_t_e_n_c_e  _i_s  _f_o_u_n_d,  _t_h_e  _b_a_s_e
          _f_o_r_m  _o_f  _t_h_e  _s_e_a_r_c_h _w_o_r_d _i_s _s_u_b_s_t_i_t_u_t_e_d _i_n_t_o _t_h_e _s_e_n_-
          _t_e_n_c_e, _a_n_d _i_t _i_s _p_r_i_n_t_e_d  _b_e_l_o_w  _t_h_e  _s_y_n_s_e_t,  _p_r_e_c_e_d_e_d
          _w_i_t_h  _t_h_e  EX:  _m_a_r_k_e_r.   _W_h_e_n  _n_o _s_a_m_p_l_e _s_e_n_t_e_n_c_e_s _a_r_e
          _f_o_u_n_d, _t_h_e _g_e_n_e_r_i_c _s_e_n_t_e_n_c_e _f_r_a_m_e_s _a_r_e _d_i_s_p_l_a_y_e_d.  _S_e_n_-
          _t_e_n_c_e  _f_r_a_m_e_s  _t_h_a_t  _a_r_e  _a_c_c_e_p_t_a_b_l_e _f_o_r _a_l_l _w_o_r_d_s _i_n _a
          _s_y_n_s_e_t _a_r_e _p_r_e_c_e_d_e_d _b_y _t_h_e _m_a_r_k_e_r *>.  _I_f  _a  _f_r_a_m_e  _i_s
          _a_c_c_e_p_t_a_b_l_e  _f_o_r _t_h_e _s_e_a_r_c_h _w_o_r_d _o_n_l_y, _i_t _i_s _p_r_e_c_e_d_e_d _b_y
          _t_h_e _m_a_r_k_e_r =>.

          _S_e_a_r_c_h _r_e_s_u_l_t_s _f_o_r _a_d_j_e_c_t_i_v_e_s  _a_r_e  _s_l_i_g_h_t_l_y  _d_i_f_f_e_r_e_n_t
          _f_r_o_m  _t_h_o_s_e  _f_o_r _o_t_h_e_r _p_a_r_t_s _o_f _s_p_e_e_c_h.  _W_h_e_n _a_n _a_d_j_e_c_-
          _t_i_v_e _i_s _p_r_i_n_t_e_d, _i_t_s _d_i_r_e_c_t _a_n_t_o_n_y_m, _i_f _i_t _h_a_s _o_n_e,  _i_s
          _a_l_s_o  _p_r_i_n_t_e_d  _i_n _p_a_r_e_n_t_h_e_s_e_s.  _W_h_e_n _t_h_e _s_e_a_r_c_h _w_o_r_d _i_s
          _i_n _a _h_e_a_d _s_y_n_s_e_t, _a_l_l _o_f _t_h_e _h_e_a_d  _s_y_n_s_e_t'_s  _s_a_t_e_l_l_i_t_e_s
          _a_r_e  _a_l_s_o  _d_i_s_p_l_a_y_e_d.   _T_h_e _p_o_s_i_t_i_o_n _o_f _a_n _a_d_j_e_c_t_i_v_e _i_n
          _r_e_l_a_t_i_o_n _t_o _t_h_e _n_o_u_n _m_a_y _b_e _r_e_s_t_r_i_c_t_e_d _t_o _t_h_e  _p_r_e_n_o_m_i_-
          _n_a_l,   _p_o_s_t_n_o_m_i_n_a_l   _o_r  _p_r_e_d_i_c_a_t_i_v_e  _p_o_s_i_t_i_o_n.   _W_h_e_r_e
          _p_r_e_s_e_n_t, _t_h_e_s_e _r_e_s_t_r_i_c_t_i_o_n_s _a_r_e _n_o_t_e_d _i_n _p_a_r_e_n_t_h_e_s_e_s.

          _W_h_e_n _a_n _a_d_j_e_c_t_i_v_e _i_s _a _p_a_r_t_i_c_i_p_l_e _o_f _a _v_e_r_b, _t_h_e _o_u_t_p_u_t
          _i_n_d_i_c_a_t_e_s _t_h_e _v_e_r_b _a_n_d _d_i_s_p_l_a_y_s _i_t_s _s_y_n_s_e_t.

          _W_h_e_n _a_n  _a_d_v_e_r_b  _i_s  _d_e_r_i_v_e_d  _f_r_o_m  _a_n  _a_d_j_e_c_t_i_v_e,  _t_h_e
          _s_p_e_c_i_f_i_c _a_d_j_e_c_t_i_v_a_l _s_e_n_s_e _o_n _w_h_i_c_h _i_t _i_s _b_a_s_e_d _i_s _i_n_d_i_-
          _c_a_t_e_d.

          _T_h_e  _m_o_r_p_h_o_l_o_g_i_c_a_l  _t_r_a_n_s_f_o_r_m_a_t_i_o_n_s  _p_e_r_f_o_r_m_e_d  _b_y  _t_h_e
          _s_e_a_r_c_h  _c_o_d_e _m_a_y _r_e_s_u_l_t _i_n _m_o_r_e _t_h_a_n _o_n_e _w_o_r_d _t_o _s_e_a_r_c_h
          _f_o_r.  wnb() _a_u_t_o_m_a_t_i_c_a_l_l_y _p_e_r_f_o_r_m_s _t_h_e _r_e_q_u_e_s_t_e_d _s_e_a_r_c_h
          _o_n  _a_l_l  _o_f _t_h_e _s_t_r_i_n_g_s _a_n_d _r_e_t_u_r_n_s _t_h_e _r_e_s_u_l_t_s _g_r_o_u_p_e_d
          _b_y _w_o_r_d.  _F_o_r _e_x_a_m_p_l_e, _t_h_e _v_e_r_b saw _i_s _b_o_t_h _t_h_e _p_r_e_s_e_n_t
          _t_e_n_s_e  _o_f saw _a_n_d _t_h_e _p_a_s_t _t_e_n_s_e _o_f see.  _W_h_e_n _t_h_e_r_e _i_s
          _m_o_r_e _t_h_a_n _o_n_e _w_o_r_d _t_o _s_e_a_r_c_h _f_o_r,  _s_e_a_r_c_h  _r_e_s_u_l_t_s  _a_r_e
          _g_r_o_u_p_e_d _b_y _w_o_r_d.

DIAGNOSTICS
     If the WordNet database files cannot be opened,  error  mes-
     sages  are  displayed.  This is usually corrected by setting
     the environment variables  described  below  to  the  proper
     location of the WordNet database for your installation.



WordNet 2.0          Last change: July 2003                     9






WordNet User Commands                                    WNB(1WN)



ENVIRONMENT VARIABLES
     WNHOME              Base  directory   for   WordNet.    Unix
                         default  is /usr/local/WordNet-2.0, Win-
                         dows             default              is
                         C:\Program Files\WordNet\2.0.

     WNSEARCHDIR         Directory in which the WordNet  database
                         has  been  installed.   Unix  default is
                         WNHOME/dict,    Windows    default    is
                         WNHOME\dict.

FILES
     All files are in the directory WNSEARCHDIR.

     index._p_o_s           database index files (Unix)

     _p_o_s.idx             database index files (Windows)

     data._p_o_s            database data files (Unix)

     _p_o_s.dat             database data files (Windows)

     *.vrb               files of sentences illustrating the  use
                         of verbs

     _p_o_s.exc             morphology exception lists

SEE ALSO
     wnintro(1WN),    wn(1WN),    wnintro(3WN),    lexnames(5WN),
     senseidx(5WN),    wndb(5WN),    wninput(5WN),   morphy(7WN),
     wngloss(7WN), wngroups(7WN).

BUGS
     Please reports bugs to wordnet@princeton.edu.





















WordNet 2.0          Last change: July 2003                    10



