// Common.gens.floats.m

// 
// Common code for simple generators
// Random version 0.7
// 

// ----- Get floating-point random values: -----

-(float) getFloatSample {
   // One 32-bit unsigned random number is used
   // to fill the 24-bit mantissa of a float

   return (float) [self getThinDoubleSample];
}

-(double) getThinDoubleSample {
  // *One single* 32-bit unsigned random number is used
  // to fill the 53-bit mantissa of a double

   return (double) [self getUnsignedSample] * invModMult;
}

-(double) getDoubleSample {
   // *Two* 32-bit unsigned random numbers are used
   // to fill the 53-bit mantissa of a double.
   // Since everyone uses standard 8-byte doubles with 53-bit mantissa,
   // truncating a long double to a double should be portable.

   return (double) [self getLongDoubleSample];
}

-(long double) getLongDoubleSample {
   long double ld;
   // Two 32-bit unsigned random numbers are used
   // to fill the mantissa of a long double.
   // NOTE: since the size of a long double is machine dependent,
   // using this method may render the simulation non-portable!

   ld = (long double) [self getUnsignedSample] * invModMult
      + (long double) [self getUnsignedSample] * invModMult2;

   return ld;
}

