/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Vector;
import kaffe.io.ObjectStreamClassImpl;

public class ObjectInputStreamImpl
extends DataInputStream {
    private static ObjectStreamClassImpl defaultClassDesc = new ObjectStreamClassImpl();
    private static int firstKey = 0x7E0000;
    private byte[] buffer = new byte[255];
    private int pos;
    private int len;
    private boolean buffering = false;
    private Vector objectReferences = new Vector();
    private ObjectInputStream parent;

    public boolean enableBuffering(boolean bl) {
        boolean bl2 = this.buffering;
        if (bl != bl2) {
            if (this.buffering) {
                this.len = 0;
                this.pos = 0;
            }
            this.buffering = bl;
        }
        return bl2;
    }

    public Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        boolean bl = this.enableBuffering(false);
        Object object = null;
        int n = this.readUnsignedByte();
        switch (n) {
            case 112: {
                object = null;
                break;
            }
            case 116: {
                object = this.readUTF();
                this.makeObjectReference(object);
                break;
            }
            case 113: {
                object = this.getObjectFromReference(this.readInt());
                break;
            }
            case 114: {
                object = this.getStreamClass();
                break;
            }
            case 115: {
                object = this.getObject();
                break;
            }
            case 117: {
                object = this.getArray();
                break;
            }
            case 121: {
                this.resetObjectReferences();
                break;
            }
            case 119: {
                int n2 = this.read();
                if (n2 == -1) {
                    throw new StreamCorruptedException("incomplete block count");
                }
                throw new OptionalDataException(n2);
            }
            case 122: {
                int n3 = this.read();
                int n4 = this.read();
                int n5 = this.read();
                int n6 = this.read();
                if (n3 == -1 || n4 == -1 || n5 == -1 || n6 == -1) {
                    throw new StreamCorruptedException("incomplete block count");
                }
                int n7 = n3 << 24 | n4 << 16 | n5 << 8 | n6;
                throw new OptionalDataException(n7);
            }
            default: {
                throw new StreamCorruptedException("unexpected token: " + n);
            }
        }
        this.enableBuffering(bl);
        return object;
    }

    public void defaultReadObject(Object object, ObjectStreamClass objectStreamClass) throws IOException, StreamCorruptedException {
        boolean bl = this.enableBuffering(false);
        objectStreamClass.defaultReadObject(object, this.parent);
        this.enableBuffering(bl);
    }

    public void readStreamHeader() throws IOException, StreamCorruptedException {
        short s = this.readShort();
        if (s != -21267) {
            throw new StreamCorruptedException("bad magic nr: " + s);
        }
        s = this.readShort();
        if (s != 5) {
            throw new StreamCorruptedException("bad version nr: " + s);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getObjectFromReference(int n) throws StreamCorruptedException {
        try {
            return this.objectReferences.elementAt(n - firstKey);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new StreamCorruptedException("reference to unknown object");
        }
    }

    public void makeObjectReference(Object object) {
        this.objectReferences.addElement(object);
    }

    private void resetObjectReferences() {
        this.objectReferences.removeAllElements();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getObject() throws StreamCorruptedException, OptionalDataException {
        try {
            ObjectStreamClassImpl objectStreamClassImpl = (ObjectStreamClassImpl)this.parent.readObject();
            return objectStreamClassImpl.getObject(this.parent, this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException("error getting object: " + classNotFoundException);
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException("error getting object: " + iOException);
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException("error getting object: " + classCastException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getStreamClass() throws StreamCorruptedException {
        try {
            return defaultClassDesc.getClass(this.parent, this);
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException("error getting class: " + iOException);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new StreamCorruptedException("error getting class: " + classCastException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getArray() throws StreamCorruptedException {
        try {
            ObjectStreamClassImpl objectStreamClassImpl = (ObjectStreamClassImpl)this.parent.readObject();
            return objectStreamClassImpl.getArray(this.parent, this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException("bad array: " + classNotFoundException);
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException("bad array: " + iOException);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new StreamCorruptedException("bad array: " + classCastException);
        }
    }

    /* synthetic */ boolean access$0() {
        return this.buffering;
    }

    /* synthetic */ int access$1() {
        return this.pos;
    }

    /* synthetic */ int access$2() {
        return this.len;
    }

    /* synthetic */ byte[] access$3() {
        return this.buffer;
    }

    /* synthetic */ void access$4(int n) {
        this.pos = n;
    }

    /* synthetic */ void access$5(int n) {
        this.len = n;
    }

    public ObjectInputStreamImpl(InputStream inputStream, ObjectInputStream objectInputStream) {
        super(null);
        ObjectInputStreamImpl objectInputStreamImpl = this;
        if (objectInputStreamImpl == null) {
            throw null;
        }
        this.in = objectInputStreamImpl.new Input(inputStream);
        this.parent = objectInputStream;
    }

    class Input
    extends InputStream {
        private InputStream in;
        int leftinblock;

        public void close() throws IOException {
            this.in.close();
        }

        public int read() throws IOException {
            if (!ObjectInputStreamImpl.this.access$0()) {
                int n = this.in.read();
                return n;
            }
            if (ObjectInputStreamImpl.this.access$1() < ObjectInputStreamImpl.this.access$2()) {
                byte[] byArray = ObjectInputStreamImpl.this.access$3();
                ObjectInputStreamImpl objectInputStreamImpl = ObjectInputStreamImpl.this;
                int n = objectInputStreamImpl.access$1();
                objectInputStreamImpl.access$4(n + 1);
                return byArray[n] & 0xFF;
            }
            if (this.leftinblock > 0) {
                int n = ObjectInputStreamImpl.this.access$3().length;
                if (n > this.leftinblock) {
                    n = this.leftinblock;
                }
                ObjectInputStreamImpl.this.access$5(this.in.read(ObjectInputStreamImpl.this.access$3(), 0, n));
                if (ObjectInputStreamImpl.this.access$2() != n) {
                    throw new StreamCorruptedException("bad blockdata size, read " + ObjectInputStreamImpl.this.access$2() + " expected " + n);
                }
                ObjectInputStreamImpl.this.access$4(1);
                this.leftinblock -= ObjectInputStreamImpl.this.access$2();
                return ObjectInputStreamImpl.this.access$3()[0] & 0xFF;
            }
            int n = this.in.read();
            switch (n) {
                case 119: {
                    this.leftinblock = this.in.read();
                    return this.read();
                }
                case 122: {
                    int n2 = 0;
                    int n3 = 24;
                    while (n3 >= 0) {
                        n = this.in.read();
                        if (n == -1) {
                            throw new StreamCorruptedException("reached eof while reading block size");
                        }
                        n2 |= n << n3;
                        n3 -= 8;
                    }
                    this.leftinblock = n2;
                    return this.read();
                }
            }
            new Throwable().printStackTrace();
            throw new StreamCorruptedException("expected blockdata: " + n);
        }

        Input(InputStream inputStream) {
            this.in = inputStream;
        }
    }
}

