/*
 * Decompiled with CFR 0.152.
 */
package kaffe.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import kaffe.applet.AudioPlayer;
import kaffe.management.Classpath;

public class AppletViewer
extends Frame
implements AppletStub,
AppletContext,
ActionListener,
WindowListener {
    Applet app;
    Vector apps = new Vector();
    String codebase = "";
    String archive = "";
    String code;
    Hashtable paramDict = new Hashtable();
    Label state = new Label();
    Dimension appletSize = new Dimension(200, 200);

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Quit".equals(string)) {
            if (this.app != null) {
                this.app.stop();
                this.app.destroy();
            }
            this.dispose();
        } else if ("Stop".equals(string)) {
            if (this.app != null) {
                this.app.stop();
            }
            this.showStatus("Applet stopped");
        } else if ("Start".equals(string)) {
            if (this.app != null) {
                this.app.start();
            }
            this.showStatus("Applet started");
        }
    }

    public void appletResize(int n, int n2) {
        this.appletSize.setSize(n, n2);
        Insets insets = this.getInsets();
        int n3 = n2 + insets.top + insets.bottom;
        int n4 = n + insets.left + insets.right;
        this.setSize(n4, n3);
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.state.getPreferredSize();
        int n = dimension.width - insets.left - insets.right;
        super.doLayout();
        this.app.setBounds(insets.left, insets.top, n, dimension.height - insets.top - insets.bottom - dimension2.height);
        this.state.setBounds(insets.left, dimension.height - insets.bottom - dimension2.height, n, dimension2.height);
    }

    public Applet getApplet(String string) {
        return this.app;
    }

    public AppletContext getAppletContext() {
        return this;
    }

    public Enumeration getApplets() {
        return this.apps.elements();
    }

    public AudioClip getAudioClip(URL uRL) {
        return new AudioPlayer(uRL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getCodeBase() {
        try {
            return new URL(this.codebase);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL getDocumentBase() {
        return this.getCodeBase();
    }

    public Image getImage(URL uRL) {
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public String getParameter(String string) {
        String string2 = string.toLowerCase();
        String string3 = (String)this.paramDict.get(string2);
        return string3;
    }

    private int getStateHeight() {
        return 2 * this.state.getFontMetrics(this.state.getFont()).getHeight();
    }

    public boolean isActive() {
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: AppletViewer <html file>");
        } else {
            File file = new File(stringArray[0]);
            if (file.exists()) {
                new AppletViewer(file);
            } else {
                System.out.println("File " + file + " does not exist");
            }
        }
    }

    void parseApplet(StreamTokenizer streamTokenizer) throws IOException {
        block3: while (streamTokenizer.nextToken() != 62) {
            if (streamTokenizer.sval == null) continue;
            switch (streamTokenizer.ttype) {
                case -3: {
                    if (streamTokenizer.sval.equals("codebase")) {
                        streamTokenizer.lowerCaseMode(false);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        this.codebase = new String(streamTokenizer.sval);
                        streamTokenizer.lowerCaseMode(true);
                        break;
                    }
                    if (streamTokenizer.sval.equals("archive")) {
                        streamTokenizer.lowerCaseMode(false);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        this.archive = new String(streamTokenizer.sval);
                        streamTokenizer.lowerCaseMode(true);
                        break;
                    }
                    if (streamTokenizer.sval.equals("code")) {
                        streamTokenizer.lowerCaseMode(false);
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        this.code = new String(streamTokenizer.sval);
                        if (this.code.endsWith(".class")) {
                            this.code = this.code.substring(0, this.code.length() - 6);
                        }
                        streamTokenizer.lowerCaseMode(true);
                        break;
                    }
                    if (streamTokenizer.sval.equals("height")) {
                        streamTokenizer.nextToken();
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == -2) {
                            this.appletSize.height = (int)streamTokenizer.nval;
                            break;
                        }
                        this.appletSize.height = Integer.parseInt(streamTokenizer.sval);
                        break;
                    }
                    if (!streamTokenizer.sval.equals("width")) continue block3;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -2) {
                        this.appletSize.width = (int)streamTokenizer.nval;
                        break;
                    }
                    this.appletSize.width = Integer.parseInt(streamTokenizer.sval);
                    break;
                }
            }
        }
    }

    void parseParam(StreamTokenizer streamTokenizer) throws IOException {
        String string = null;
        String string2 = null;
        while (streamTokenizer.nextToken() != 62) {
            if (streamTokenizer.sval == null) continue;
            if (streamTokenizer.sval.equals("name")) {
                streamTokenizer.nextToken();
                streamTokenizer.nextToken();
                string = new String(streamTokenizer.sval);
                continue;
            }
            if (!streamTokenizer.sval.equals("value")) continue;
            streamTokenizer.nextToken();
            streamTokenizer.lowerCaseMode(false);
            streamTokenizer.nextToken();
            string2 = streamTokenizer.ttype == -2 ? Double.toString(streamTokenizer.nval) : new String(streamTokenizer.sval);
            streamTokenizer.lowerCaseMode(true);
        }
        if (string != null && string2 != null) {
            string = string.toLowerCase();
            this.paramDict.put(string, string2);
        }
    }

    void setMenus() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Applet");
        menu.add("Restart");
        menu.add("Reload");
        menu.add("Stop");
        menu.add("Save...");
        menu.add("Start");
        menu.add("Clone...");
        menu.addSeparator();
        menu.add("Tag...");
        menu.add("Info...");
        menu.add("Edit");
        menu.add("Character Encoding");
        menu.addSeparator();
        menu.add("Print...");
        menu.addSeparator();
        menu.add("Properties...");
        menu.addSeparator();
        menu.add("Close");
        menu.add("Quit");
        menu.addActionListener(this);
        menuBar.add(menu);
        this.setMenuBar(menuBar);
    }

    public void showDocument(URL uRL) {
        System.out.println(uRL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void showDocument(URL uRL, String string) {
        try {
            this.showDocument(new URL(uRL, string));
            return;
        }
        catch (MalformedURLException malformedURLException) {
        }
    }

    public void showStatus(String string) {
        this.state.setText(" " + string + " ");
    }

    void start() {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.app != null) {
            this.app.stop();
            this.app.destroy();
        }
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AppletViewer(File file) {
        super("AppletViewer: " + file);
        this.setLayout(null);
        this.setMenus();
        this.state.setFont(new Font("SansSerif", 1, 12));
        this.add(this.state);
        this.addWindowListener(this);
        try {
            FileReader fileReader = new FileReader(file);
            StreamTokenizer streamTokenizer = new StreamTokenizer(fileReader);
            streamTokenizer.lowerCaseMode(true);
            streamTokenizer.ordinaryChar(47);
            streamTokenizer.ordinaryChar(39);
            while (true) {
                int n;
                if ((n = streamTokenizer.nextToken()) == -1) {
                    if (!this.codebase.equals("")) {
                        Classpath.add(this.codebase);
                    }
                    if (!this.archive.equals("")) {
                        Classpath.add(this.archive);
                    }
                    fileReader.close();
                    Class clazz = Class.forName(this.code);
                    this.app = (Applet)clazz.newInstance();
                    this.app.setStub(this);
                    this.apps.addElement(this.app);
                    this.add(this.app);
                    this.addNotify();
                    this.appletResize(this.appletSize.width, this.appletSize.height);
                    this.app.init();
                    this.app.validate();
                    this.app.start();
                    this.setVisible(true);
                    this.showStatus("Applet started");
                    return;
                }
                if (n != 60 || (n = streamTokenizer.nextToken()) != -3) continue;
                if (streamTokenizer.sval.equals("applet")) {
                    this.parseApplet(streamTokenizer);
                    continue;
                }
                if (!streamTokenizer.sval.equals("param")) continue;
                this.parseParam(streamTokenizer);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus("Cannot start applet");
        }
    }
}

