/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Properties
extends Hashtable {
    private static final long serialVersionUID = 4112578634029874840L;
    protected Properties defaults;
    private StringBuffer key;
    private StringBuffer value;

    private static String escape(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '!': 
                case '#': {
                    if (n == 0) {
                        stringBuffer.append("\\");
                    }
                    stringBuffer.append(c);
                    break;
                }
                case ' ': 
                case ':': 
                case '=': {
                    if (!bl) {
                        stringBuffer.append(c);
                        break;
                    }
                }
                case '\\': {
                    stringBuffer.append("\\" + c);
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                default: {
                    if (c > '~') {
                        stringBuffer.append("\\\\u");
                        stringBuffer.append(Character.forDigit(c >> 12 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c >> 8 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
                        stringBuffer.append(Character.forDigit(c & 0xF, 16));
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getProperty(String string) {
        Object object = super.get(string);
        if (object != null) {
            return (String)object;
        }
        if (this.defaults != null) {
            return this.defaults.getProperty(string);
        }
        return null;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public void list(PrintStream printStream) {
        this.list(new PrintWriter(printStream, true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void list(PrintWriter printWriter) {
        try {
            this.save(printWriter, "Properties list");
            return;
        }
        catch (IOException iOException) {
            System.err.println("unable to list properties");
        }
    }

    public Enumeration propertyNames() {
        Vector vector = new Vector();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        if (this.defaults != null) {
            enumeration = this.defaults.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                if (vector.contains(object)) continue;
                vector.addElement(object);
            }
        }
        Properties properties = this;
        if (properties == null) {
            throw null;
        }
        return new Enumeration(properties, vector){
            private final /* synthetic */ Properties this$0;
            private final /* synthetic */ Vector val$result;
            private int posn;

            public boolean hasMoreElements() {
                return this.posn < this.val$result.size();
            }

            public Object nextElement() {
                if (this.posn == this.val$result.size()) {
                    throw new NoSuchElementException();
                }
                return this.val$result.elementAt(this.posn++);
            }
            {
                this.val$result = vector;
                this.this$0 = properties;
                this.posn = 0;
                this.constructor$0(properties);
            }

            public void constructor$0(Properties properties) {
            }
        };
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 16);
        while (this.readKeyAndValue(pushbackInputStream)) {
            this.put(this.key.toString(), this.value.toString());
        }
        this.key = null;
        this.value = null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readKeyAndValue(PushbackInputStream var1_1) throws IOException {
        while (true) {
            if ((var2_2 = var1_1.read()) != -1 && var2_2 <= 32) {
                continue;
            }
            switch (var2_2) {
                case 33: 
                case 35: {
                    while ((var2_2 = var1_1.read()) != 10) {
                    }
                    break;
                }
                case -1: {
                    return false;
                }
                default: {
                    this.key = new StringBuffer();
                    this.value = new StringBuffer();
                    while (true) {
                        switch (var2_2) {
                            case 58: 
                            case 61: {
                                ** GOTO lbl39
                            }
                            case 13: {
                                var2_2 = var1_1.read();
                                switch (var2_2) {
                                    case 10: {
                                        break;
                                    }
                                    case -1: {
                                        return true;
                                    }
                                    default: {
                                        var1_1.unread(var2_2);
                                        ** GOTO lbl39
                                    }
                                }
                            }
                            case -1: 
                            case 10: {
                                return true;
                            }
                            default: {
                                if (var2_2 <= 32) ** GOTO lbl39
                                var1_1.unread(var2_2);
                                this.key.append((char)Properties.getEscapedChar(var1_1));
                                var2_2 = var1_1.read();
                            }
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (var2_2 != -1 && var2_2 != 10) continue;
                        return true;
lbl39:
                        // 4 sources

                        ** while ((var2_2 = var1_1.read()) <= 32)
                    }
lbl40:
                    // 1 sources

                    while (true) {
                        switch (var2_2) {
                            case 13: {
                                var2_2 = var1_1.read();
                                switch (var2_2) {
                                    case -1: {
                                        this.value.append('\r');
                                    }
                                    case 10: {
                                        return true;
                                    }
                                }
                                var1_1.unread(var2_2);
                                this.value.append('\r');
                                break;
                            }
                            case -1: 
                            case 10: {
                                return true;
                            }
                            default: {
                                var1_1.unread(var2_2);
                                this.value.append((char)Properties.getEscapedChar(var1_1));
                                break;
                            }
                        }
                        var2_2 = var1_1.read();
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int getEscapedChar(PushbackInputStream var0) throws IOException {
        var1_1 = var0.read();
        switch (var1_1) {
            case 92: {
                var1_1 = var0.read();
                switch (var1_1) {
                    case 13: {
                        var1_1 = var0.read();
                        switch (var1_1) {
                            default: {
                                var0.unread(var1_1);
                            }
                            case -1: {
                                var0.unread(13);
                                return 92;
                            }
                            case 10: 
                        }
                    }
                    case 10: {
                        while ((var1_1 = var0.read()) != -1 && var1_1 <= 32) {
                        }
                        return var1_1;
                    }
                    case 110: {
                        return 10;
                    }
                    case 114: {
                        return 13;
                    }
                    case 116: {
                        return 9;
                    }
                    case 92: {
                        var1_1 = var0.read();
                        switch (var1_1) {
                            case 117: {
                                var2_2 = new int[4];
                                var5_3 = 0;
                                var3_4 = 0;
                                while (var3_4 < 4) {
                                    var2_2[var3_4] = var0.read();
                                    if (var2_2[var3_4] != -1 && (var4_5 = Character.digit((char)var2_2[var3_4++], 16)) != -1) {
                                        var5_3 = var5_3 << 4 | var4_5;
                                        continue;
                                    }
                                    ** GOTO lbl40
                                }
                                return var5_3;
lbl-1000:
                                // 1 sources

                                {
                                    var0.unread(var2_2[--var3_4]);
lbl40:
                                    // 2 sources

                                    ** while (var3_4 > 0)
                                }
                            }
                        }
lbl41:
                        // 2 sources

                        var0.unread(var1_1);
                        return 92;
                    }
                    case -1: {
                        return 92;
                    }
                }
                return var1_1;
            }
            case 13: {
                var1_1 = var0.read();
                switch (var1_1) {
                    default: {
                        var0.unread(var1_1);
                    }
                    case -1: {
                        return 13;
                    }
                    case 10: 
                }
                break;
            }
        }
        return var1_1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void save(OutputStream outputStream, String string) {
        try {
            this.store(outputStream, string);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Unable to save properties: " + string);
        }
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        this.save(new PrintWriter(outputStream, true), string);
    }

    private synchronized void save(PrintWriter printWriter, String string) throws IOException {
        if (string != null) {
            printWriter.println("# " + Properties.escape(string, false));
        }
        Enumeration enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            printWriter.println(Properties.escape(string2, true) + "=" + Properties.escape(this.getProperty(string2), false));
        }
        printWriter.flush();
    }

    public Properties() {
        this(null);
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }
}

