/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;

public final class StringCharacterIterator
implements CharacterIterator {
    private String text;
    private int pos;
    private int begin;
    private int end;

    public Object clone() {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.text, this.begin, this.end, this.pos);
        return stringCharacterIterator;
    }

    public char current() {
        if (this.pos < this.begin || this.pos >= this.end) {
            return '\uffff';
        }
        return this.text.charAt(this.pos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        try {
            StringCharacterIterator stringCharacterIterator = (StringCharacterIterator)object;
            if (!this.text.equals(stringCharacterIterator.text)) return false;
            if (this.pos != stringCharacterIterator.pos) return false;
            if (this.begin != stringCharacterIterator.begin) return false;
            if (this.end != stringCharacterIterator.end) return false;
            return true;
        }
        catch (ClassCastException classCastException) {
        }
        return false;
    }

    public char first() {
        this.pos = this.begin;
        return this.current();
    }

    public int getBeginIndex() {
        return this.begin;
    }

    public int getEndIndex() {
        return this.end;
    }

    public int getIndex() {
        return this.pos;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public char last() {
        this.pos = this.end - 1;
        return this.current();
    }

    public char next() {
        if (this.pos < this.end) {
            ++this.pos;
            return this.current();
        }
        return '\uffff';
    }

    public char previous() {
        if (this.pos > this.begin) {
            --this.pos;
            return this.current();
        }
        return '\uffff';
    }

    public char setIndex(int n) {
        if (n < this.getBeginIndex() || n > this.getEndIndex()) {
            throw new IllegalArgumentException("Invalid index: " + n);
        }
        this.pos = n;
        if (n == this.getEndIndex()) {
            return '\uffff';
        }
        return this.text.charAt(n);
    }

    public StringCharacterIterator(String string) {
        this(string, 0, string.length(), 0);
    }

    public StringCharacterIterator(String string, int n) {
        this(string, 0, string.length(), n);
    }

    public StringCharacterIterator(String string, int n, int n2, int n3) {
        this.text = string;
        this.pos = n3;
        this.begin = n;
        this.end = n2;
    }
}

