/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class NumberFormat
extends Format
implements Cloneable {
    private static final long serialVersionUID = -2308460125733713944L;
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    boolean grouping = false;
    boolean intonly = false;
    int maxfrac = 0;
    int maxint = 0;
    int minfrac = 0;
    int minint = 1;

    public Object clone() {
        return super.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        try {
            NumberFormat numberFormat = (NumberFormat)object;
            if (this.grouping != numberFormat.grouping) return false;
            if (this.intonly != numberFormat.intonly) return false;
            if (this.maxfrac != numberFormat.maxfrac) return false;
            if (this.maxint != numberFormat.maxint) return false;
            if (this.minfrac != numberFormat.minfrac) return false;
            if (this.minint != numberFormat.minint) return false;
            return true;
        }
        catch (ClassCastException classCastException) {
        }
        return false;
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Double) {
            return this.format((Double)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Long) {
            return this.format((Long)object, stringBuffer, fieldPosition);
        }
        stringBuffer.append("<unknown type>");
        return stringBuffer;
    }

    public final String format(double d) {
        return this.format(d, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public final String format(long l) {
        return this.format(l, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public static synchronized Locale[] getAvailableLocales() {
        return Format.getAvailableLocales("numberformat");
    }

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getCurrencyInstance(Locale.getDefault());
    }

    public static NumberFormat getCurrencyInstance(Locale locale2) {
        ResourceBundle resourceBundle = Format.getResources("numberformat", locale2);
        String string = resourceBundle.getString("\u00a40");
        return new DecimalFormat(string + "#,##0.00;(" + string + "#,##0.00)", locale2);
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getInstance(Locale.getDefault());
    }

    public static NumberFormat getInstance(Locale locale2) {
        return NumberFormat.getNumberInstance(locale2);
    }

    public int getMaximumFractionDigits() {
        return this.maxfrac;
    }

    public int getMaximumIntegerDigits() {
        return this.maxint;
    }

    public int getMinimumFractionDigits() {
        return this.minfrac;
    }

    public int getMinimumIntegerDigits() {
        return this.minint;
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getNumberInstance(Locale.getDefault());
    }

    public static NumberFormat getNumberInstance(Locale locale2) {
        ResourceBundle resourceBundle = Format.getResources("numberformat", locale2);
        return new DecimalFormat("#,##0.###;-#,##0.###", locale2);
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getPercentInstance(Locale.getDefault());
    }

    public static NumberFormat getPercentInstance(Locale locale2) {
        ResourceBundle resourceBundle = Format.getResources("numberformat", locale2);
        String string = resourceBundle.getString("%");
        return new DecimalFormat("#,##0" + string, locale2);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isGroupingUsed() {
        return this.grouping;
    }

    public boolean isParseIntegerOnly() {
        return this.intonly;
    }

    public Number parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.parse(string, parsePosition);
        if (number == null) {
            throw new ParseException("", parsePosition.getIndex());
        }
        return number;
    }

    public abstract Number parse(String var1, ParsePosition var2);

    public final Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public void setGroupingUsed(boolean bl) {
        this.grouping = bl;
    }

    public void setMaximumFractionDigits(int n) {
        this.maxfrac = n;
    }

    public void setMaximumIntegerDigits(int n) {
        this.maxint = n;
    }

    public void setMinimumFractionDigits(int n) {
        this.minfrac = n;
    }

    public void setMinimumIntegerDigits(int n) {
        this.minint = n;
    }

    public void setParseIntegerOnly(boolean bl) {
        this.intonly = bl;
    }
}

