/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.URL;
import java.net.UnknownServiceException;
import kaffe.net.DefaultFileNameMap;
import kaffe.net.DefaultStreamMap;
import kaffe.net.StreamMap;

public abstract class URLConnection {
    private static FileNameMap fileNameMap = new DefaultFileNameMap();
    private static StreamMap streamMap = new DefaultStreamMap();
    private static ContentHandlerFactory factory = null;
    private static boolean defaultAllowUserInteraction = false;
    private static boolean defaultUseCaches = false;
    protected boolean allowUserInteraction = defaultAllowUserInteraction;
    protected boolean connected = false;
    protected boolean doInput = true;
    protected boolean doOutput = false;
    protected long ifModifiedSince = 0L;
    protected URL url;
    protected boolean useCaches = defaultUseCaches;

    public abstract void connect() throws IOException;

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public Object getContent() throws IOException {
        return null;
    }

    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("content-length", -1);
    }

    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    public long getDate() {
        return this.getHeaderFieldDate("date", -1L);
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    public static String getDefaultRequestProperty(String string) {
        return null;
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("expiration", -1L);
    }

    public static FileNameMap getFileNameMap() {
        return fileNameMap;
    }

    public String getHeaderField(String string) {
        return null;
    }

    public String getHeaderField(int n) {
        return null;
    }

    public String getHeaderFieldKey(int n) {
        return null;
    }

    public long getHeaderFieldDate(String string, long l) {
        String string2 = this.getHeaderField(string);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHeaderFieldInt(String string, int n) {
        String string2 = this.getHeaderField(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getIfModifiedSince() {
        if (this.ifModifiedSince == 0L) {
            this.ifModifiedSince = this.getHeaderFieldInt("If-Modified-Since", 0);
        }
        return this.ifModifiedSince;
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public long getLastModified() {
        return this.getHeaderFieldDate("lastModified", -1L);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public String getRequestProperty(String string) {
        return null;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    protected static String guessContentTypeFromName(String string) {
        if (fileNameMap != null) {
            return fileNameMap.getContentTypeFor(string);
        }
        return null;
    }

    public static String guessContentTypeFromStream(InputStream inputStream) throws IOException {
        if (streamMap != null) {
            return streamMap.getContentTypeFor(inputStream);
        }
        return null;
    }

    public void setAllowUserInteraction(boolean bl) {
        this.allowUserInteraction = bl;
    }

    public static synchronized void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
        if (factory != null) {
            throw new Error("factory already defined");
        }
        factory = contentHandlerFactory;
    }

    public static void setDefaultAllowUserInteraction(boolean bl) {
        defaultAllowUserInteraction = bl;
    }

    public static void setDefaultRequestProperty(String string, String string2) {
    }

    public void setDefaultUseCaches(boolean bl) {
        defaultUseCaches = bl;
    }

    public void setDoInput(boolean bl) {
        this.doInput = bl;
    }

    public void setDoOutput(boolean bl) {
        this.doOutput = bl;
    }

    public static void setFileNameMap(FileNameMap fileNameMap) {
        URLConnection.fileNameMap = fileNameMap;
    }

    public void setIfModifiedSince(long l) {
        this.ifModifiedSince = l;
    }

    public void setRequestProperty(String string, String string2) {
    }

    public void setUseCaches(boolean bl) {
        this.useCaches = bl;
    }

    public String toString() {
        return this.getClass().toString() + " " + this.url;
    }

    protected URLConnection(URL uRL) {
        this.url = uRL;
    }
}

