/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import kaffe.net.DefaultURLStreamHandlerFactory;

public final class URL
implements Serializable {
    private static final long serialVersionUID = -7627629688361524110L;
    private static URLStreamHandlerFactory defaultFactory = new DefaultURLStreamHandlerFactory();
    private static URLStreamHandlerFactory factory;
    private URLStreamHandler handler;
    private String protocol;
    private String host;
    private int port;
    private String file;
    private String ref;
    private URLConnection conn;

    public boolean equals(Object object) {
        if (object == null || !(object instanceof URL)) {
            return false;
        }
        URL uRL = (URL)object;
        return this.protocol.equals(uRL.protocol) && this.host.equals(uRL.host) && this.port == uRL.port && this.file.equals(uRL.file) && this.ref.equals(uRL.ref);
    }

    public final Object getContent() throws IOException {
        this.openConnection();
        return this.conn.getContent();
    }

    public String getFile() {
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.ref;
    }

    private static URLStreamHandler getURLStreamHandler(String string) throws MalformedURLException {
        URLStreamHandler uRLStreamHandler = null;
        if (factory != null && (uRLStreamHandler = factory.createURLStreamHandler(string)) != null) {
            return uRLStreamHandler;
        }
        uRLStreamHandler = defaultFactory.createURLStreamHandler(string);
        if (uRLStreamHandler != null) {
            return uRLStreamHandler;
        }
        throw new MalformedURLException("unknown protocol: " + string);
    }

    public int hashCode() {
        return this.protocol.hashCode() ^ this.host.hashCode() ^ this.file.hashCode();
    }

    private static String merge(URL uRL, String string) {
        int n;
        if (uRL == null) {
            return string;
        }
        String string2 = uRL.toString();
        if (string == null) {
            return string2;
        }
        if (string.indexOf(35) == 0) {
            return string2 + string;
        }
        int n2 = string2.lastIndexOf(47);
        if (n2 > -1 && (n = string2.lastIndexOf(46)) > n2) {
            return string2.substring(0, n2 + 1) + string;
        }
        return string2 + string;
    }

    public URLConnection openConnection() throws IOException {
        if (this.conn == null) {
            this.conn = this.handler.openConnection(this);
            this.conn.connect();
        }
        return this.conn;
    }

    public final InputStream openStream() throws IOException {
        if (this.conn == null) {
            this.openConnection();
        }
        return this.conn.getInputStream();
    }

    public boolean sameFile(URL uRL) {
        return this.protocol.equals(uRL.protocol) && this.host.equals(uRL.host) && this.port == uRL.port && this.file.equals(uRL.file);
    }

    protected void set(String string, String string2, int n, String string3, String string4) {
        this.protocol = string;
        this.host = string2;
        this.port = n;
        this.file = string3;
        this.ref = string4;
    }

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory) {
        if (factory != null) {
            throw new Error("factory already set");
        }
        factory = uRLStreamHandlerFactory;
    }

    public String toExternalForm() {
        return this.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.protocol);
        stringBuffer.append(":");
        if (!this.host.equals("")) {
            stringBuffer.append("//");
            stringBuffer.append(this.host);
            if (this.port != -1) {
                stringBuffer.append(":");
                stringBuffer.append(Integer.toString(this.port));
            }
        }
        stringBuffer.append(this.file);
        return stringBuffer.toString();
    }

    public URL(String string) throws MalformedURLException {
        int n = string.indexOf(58, 0);
        if (n == -1) {
            this.protocol = "file";
            this.host = "";
            this.port = -1;
            this.file = string;
        } else {
            int n2;
            int n3;
            this.protocol = string.substring(0, n);
            int n4 = n + 3;
            if (string.length() >= n4 && string.substring(n + 1, n4).equals("//")) {
                n3 = string.indexOf(58, n4);
                if (n3 != -1) {
                    this.host = string.substring(n4, n3);
                    int n5 = n3 + 1;
                    int n6 = string.indexOf(47, n5);
                    if (n6 == -1) {
                        n6 = string.length();
                    }
                    this.port = Integer.parseInt(string.substring(n5, n6));
                    n2 = string.indexOf(47, n4);
                } else {
                    n3 = string.indexOf(47, n4);
                    if (n3 != -1) {
                        this.host = string.substring(n4, n3);
                        this.port = -1;
                        n2 = string.indexOf(47, n4);
                    } else {
                        this.host = string.substring(n4);
                        this.port = -1;
                        n2 = -1;
                    }
                }
            } else {
                this.host = "";
                this.port = -1;
                n2 = n + 1;
            }
            if (n2 != -1) {
                this.file = string.substring(n2);
                n3 = this.file.lastIndexOf(35);
                if (n3 > -1) {
                    this.ref = this.file.substring(n3 + 1);
                    this.file = this.file.substring(0, n3);
                }
            } else {
                this.file = "";
            }
        }
        this.handler = URL.getURLStreamHandler(this.protocol);
    }

    public URL(String string, String string2, String string3) throws MalformedURLException {
        this(string, string2, -1, string3);
    }

    public URL(String string, String string2, int n, String string3) throws MalformedURLException {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException();
        }
        this.protocol = string;
        this.host = string2;
        this.file = string3;
        this.port = n;
        this.handler = URL.getURLStreamHandler(string);
    }

    public URL(URL uRL, String string) throws MalformedURLException {
        this(URL.merge(uRL, string));
    }
}

